/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.ExchangeUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CommitDisableDeleteMailbox
extends WorkFlowCommitListener {
    private static String value = "";

    public CommitDisableDeleteMailbox() {
        this.reportId = (int)ReportsUtil.DISABLE_DELETE_MAILBOX_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message;
        block23: {
            message = new StringBuffer();
            Boolean errorOccured = true;
            String statusMessage = "";
            String guid = "";
            try {
                String dn = (String)result.get(1004);
                String sid = (String)result.get(1144);
                this.domainName = (String)result.get(1143);
                guid = (String)result.get(1145);
                String samAccountName = (String)result.get(1006);
                ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
                Long actionToPerform = (Long)requestActionDetails.get("REQUEST_ACTION");
                System.out.println("ACTTOPER" + actionToPerform);
                System.out.println("inputsDetails" + inputsDetails);
                if (!actionToPerform.equals(11L) || inputsDetails.isEmpty()) break block23;
                for (AdmpInput admpInput : inputsDetails) {
                    if (admpInput.getIsMultiple().booleanValue()) {
                        ArrayList inputsList = admpInput.getMultipleInput();
                        for (FcOption fcOption : inputsList) {
                            if (!fcOption.getLabel().equalsIgnoreCase("DisableDeleteMailbox")) continue;
                            value = fcOption.getValue();
                        }
                        continue;
                    }
                    value = admpInput.getValue();
                }
                if (value != null) {
                    if (!value.equals("")) {
                        String mailServer = UserMgmtUtil.getMailServer((String)guid);
                        if (mailServer != null && !mailServer.equalsIgnoreCase("")) {
                            boolean usePowershell = ExchangeUtil.checkExchange2007((String)mailServer);
                            try {
                                if (usePowershell) {
                                    String statMessage;
                                    Properties exchangeServerDetails = ExchangeUtil.getExchangeServerProperty((String)this.domainName, (String)mailServer);
                                    if (value.equals("disable")) {
                                        statMessage = ADHandler.disableMailBox((String)this.domainName, (long)loginId, (String)guid, (Properties)exchangeServerDetails, (String)dn);
                                        if (statMessage.equalsIgnoreCase("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_disabled_mailbox")) {
                                            errorOccured = false;
                                        }
                                        message.append(rb.getString(statMessage));
                                    } else if (value.equals("disconnect")) {
                                        statMessage = ADHandler.deleteMailBox((String)this.domainName, (long)loginId, (String)guid, (Properties)exchangeServerDetails, (boolean)false, (String)dn);
                                        if (statMessage.equalsIgnoreCase("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_disconnected_mailbox")) {
                                            errorOccured = false;
                                        }
                                        message.append(rb.getString(statMessage));
                                    } else if (value.equals("delete")) {
                                        statMessage = ADHandler.deleteMailBox((String)this.domainName, (long)loginId, (String)guid, (Properties)exchangeServerDetails, (boolean)true, (String)dn);
                                        if (statMessage.equalsIgnoreCase("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_deleted_mailbox")) {
                                            errorOccured = false;
                                        }
                                        message.append(rb.getString(statMessage));
                                    }
                                }
                                if (!usePowershell) {
                                    ADHandler.deleteMailBox2003((String)this.domainName, (Long)loginId, (String)sid, (String)dn);
                                    message.append(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_successfully_deleted_2003_mailbox"));
                                    errorOccured = false;
                                }
                            }
                            catch (LocalizedException le) {
                                le.printStackTrace();
                                message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), le.getMessage(rb)));
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                                message = new StringBuffer(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.statmsg_unable_del_mailbox"), e.getMessage()));
                            }
                        } else {
                            message = new StringBuffer(rb.getString("admp.mgmt.user_mgmt.move_delete_homefolders.statmsg.unable_delete_user_no_mailbox"));
                        }
                        TechAuditAPI.getInstance().auditDeleteUser(loginId, rb.getString("admp.mgmt.user_mgmt.disable_del_mailbox.mgmtname.disable_del_mailbox"), this.getValue(result, (Integer)1010), this.domainName, message.toString(), rb);
                        if (message == null) {
                            message = new StringBuffer(rb.getString("admp.mgmt.common.statmsg.successfully_modified"));
                            errorOccured = false;
                        }
                        out.log(Level.INFO, "Disable/Delete Mailbox completed for the user name " + samAccountName);
                    }
                }
                this.updateResult(guid, message.toString(), errorOccured);
                return message.toString();
            }
            catch (Exception r) {
                r.printStackTrace();
            }
        }
        return message.toString();
    }
}

