/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.delegation.workflow.WFRequesterUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.GroupHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.webclient.groups.GroupErrorHandler;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;

public class CommitGroupAttributesForGroup
extends WorkFlowCommitListener {
    public CommitGroupAttributesForGroup() {
        this.reportId = (int)ReportsUtil.GROUP_ORG_ATTR_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        StringBuffer message = new StringBuffer();
        String guid = "";
        Boolean errorOccured = true;
        this.domainName = (String)result.get(2021);
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            String dn = (String)result.get(2003);
            String sid = (String)result.get(2023);
            guid = (String)result.get(2022);
            String samAccountName = (String)result.get(2043);
            String groupModifyStatusMessage = "";
            ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
            if (!inputsDetails.isEmpty()) {
                Properties groupProps;
                ArrayList memberOfList;
                AdmpInput admpInput = (AdmpInput)inputsDetails.get(0);
                String groupActionType = admpInput.getName();
                ArrayList<Hashtable> handleErrorList = new ArrayList<Hashtable>();
                String status = new String();
                ArrayList multiInputDetailsList = admpInput.getMultipleInput();
                Boolean isMultiple = admpInput.getIsMultiple();
                Boolean isRemoveFromAllGroup = false;
                ArrayList<String> removeFromGroupSidList = new ArrayList<String>();
                ArrayList<String> removeFromGroupNameList = new ArrayList<String>();
                groupModifyStatusMessage = "";
                for (FcOption fcoption : multiInputDetailsList) {
                    if (fcoption.getLabel().equalsIgnoreCase("isRemoveAllGroup")) {
                        isRemoveFromAllGroup = Boolean.parseBoolean(fcoption.getValue());
                        continue;
                    }
                    removeFromGroupSidList.add(fcoption.getValue());
                    removeFromGroupNameList.add(fcoption.getLabel());
                }
                String searchStr = "(&(objectClass=Group)(objectCategory=Group)(objectSID=" + sid + "))";
                ArrayList<String> existGroupAttributeList = new ArrayList<String>();
                existGroupAttributeList.add("memberOf");
                existGroupAttributeList.add("objectSID");
                existGroupAttributeList.add("distinguishedName");
                existGroupAttributeList.add("objectClass");
                Properties domainDetail = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)loginId);
                ArrayList groupPropsList = ADHandler.getObjectsWithOutListener((Properties)domainDetail, (String)domainDetail.getProperty("DEFAULT_NAMING_CONTEXT"), existGroupAttributeList, (String)searchStr);
                ArrayList<Object> existingMemberOfList = new ArrayList<Object>();
                ArrayList<Object> existingMemberOfSidsList = new ArrayList<Object>();
                if (groupPropsList.size() > 0 && (memberOfList = (ArrayList)(groupProps = (Properties)groupPropsList.get(0)).get("memberOf")) != null) {
                    for (int i = 0; i < memberOfList.size(); ++i) {
                        Properties memberOfProps = (Properties)memberOfList.get(i);
                        existingMemberOfList.add(memberOfProps.get("distinguishedName"));
                        existingMemberOfSidsList.add(memberOfProps.get("objectSID"));
                    }
                }
                if (groupActionType.equalsIgnoreCase("AddToGroup")) {
                    ArrayList groupList = new ArrayList();
                    ArrayList<String> addToGroupSidList = new ArrayList<String>();
                    ArrayList<String> addToGroupNameList = new ArrayList<String>();
                    for (FcOption fcoption : multiInputDetailsList) {
                        addToGroupSidList.add(fcoption.getValue());
                        addToGroupNameList.add(fcoption.getLabel());
                    }
                    out.log(Level.INFO, "Selected groupsid details " + addToGroupSidList + " domainName :: " + this.domainName + " addToGroupNameList : " + addToGroupNameList);
                    if (addToGroupSidList != null && addToGroupSidList.size() > 0) {
                        groupList = GroupHandler.getDNList((String)this.domainName, addToGroupSidList);
                        out.log(Level.FINE, "After getting dnlist from DB :: " + groupList);
                    }
                    int totalCount = groupList.size();
                    groupList.removeAll(existingMemberOfList);
                    int actualCount = groupList.size();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", "");
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "memberOf");
                    p.put("DW_CONTROL_CODE", new Long(1L));
                    list.add(p);
                    if (groupList.size() > 0) {
                        int errorFlag = 0;
                        try {
                            NativeError errHdlr = ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)loginId, (String)sid, (String)dn, new ArrayList(), (ArrayList)groupList, (boolean)true);
                            errorOccured = false;
                            out.log(Level.INFO, " Add to group guid " + guid + " for the user " + sid + " list: " + groupList);
                            for (int index = 0; index < groupList.size(); ++index) {
                                String errorSeverity = errHdlr.getSeverityLevel(groupList.get(index));
                                if (errorSeverity == null || !errorSeverity.equals("WARNING")) continue;
                                Hashtable errorDetails = errHdlr.getErrorDetails(groupList.get(index));
                                if (errorDetails != null) {
                                    handleErrorList.add(errorDetails);
                                }
                                ++errorFlag;
                            }
                        }
                        catch (LocalizedException le) {
                            this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                            status = le.getMsgFromDetails(rb);
                        }
                        catch (Exception ex) {
                            message.append(ex.getMessage());
                            status = ex.getMessage();
                        }
                        String addToGroupSuccessStatusMsg = rb.getString("admp.mgmt.mod_grp_attribs.statmsg.addtogroup_operation_success");
                        String addToGroupErrorStatusMsg = "";
                        addToGroupErrorStatusMsg = groupList.size() == errorFlag ? rb.getString("admp.mgmt.mod_grp_attribs.statmsg.addtogroup_operation_failed") : rb.getString("admp.mgmt.user_mgmt.mod_grp_attribs.statmsg.addtogroup_partial_successful");
                        errorFlag += totalCount - actualCount;
                        if (totalCount != actualCount) {
                            Hashtable<String, String> errorTable = new Hashtable<String, String>();
                            errorTable.put("ERROR_CODE", "80071392");
                            for (int c = 0; c < totalCount - actualCount; ++c) {
                                handleErrorList.add(errorTable);
                            }
                        }
                        groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, totalCount, rb, removeFromGroupNameList, "", "add", errorFlag);
                        message.append(groupModifyStatusMessage);
                        out.log(Level.INFO, "Group Mgmt - Add To Group Message " + groupModifyStatusMessage);
                    } else {
                        message.append(rb.getString("admp.workflow.commitrequest.statmsg.group_already_memberof_msg"));
                    }
                    this.fillAttribs(list, "memberOf", addToGroupNameList);
                    TechAuditAPI.getInstance().auditGroupModification(loginId, rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.add_to_group"), this.getValue(result, (Integer)2043), this.domainName, list, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
                } else if (groupActionType.equalsIgnoreCase("RemoveFromGroup")) {
                    int index;
                    ArrayList ouList = null;
                    Object includeExcludeGroupOUMap = null;
                    Long requestMode = 0L;
                    if (this.requestId != null) {
                        Properties requesterProps = WFRequesterUtil.getRequestProps((Long)this.requestId);
                        requestMode = (Long)requesterProps.get("REQUEST_MODE");
                        Long requesterId = (Long)requesterProps.get("REQUESTER_ID");
                        if (requestMode.equals(0L)) {
                            ouList = WFRequesterUtil.getOUListDN((String)this.domainName, (Long)requesterId);
                        }
                    }
                    if (isRemoveFromAllGroup.booleanValue()) {
                        out.log(Level.INFO, "Going to Remove From all group membership from the group : " + dn);
                        String searchString = "(&(objectCategory=Group)(objectClass=group)(member=" + dn + "))";
                        Properties domainDetails = HDTDomainHandler.getConfiguredValues((String)this.domainName, (Long)loginId);
                        ArrayList<String> groupAttributeList = new ArrayList<String>();
                        groupAttributeList.add("cn");
                        groupAttributeList.add("distinguishedName");
                        groupAttributeList.add("objectSid");
                        ArrayList grouplistProps = ADHandler.getObjectsWithOutListener((Properties)domainDetails, (String)domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), groupAttributeList, (String)searchString);
                        out.log(Level.INFO, "Membership details of the group : " + grouplistProps);
                        if (grouplistProps.isEmpty()) {
                            message = new StringBuffer(rb.getString("admp.workflow.view_request.stat_msg.group_not_part_of_any_group"));
                        } else {
                            removeFromGroupSidList = new ArrayList();
                            removeFromGroupNameList = new ArrayList();
                            for (index = 0; index < grouplistProps.size(); ++index) {
                                Properties props = (Properties)grouplistProps.get(index);
                                if (props == null) continue;
                                ArrayList dnObject = (ArrayList)props.get("distinguishedName");
                                boolean isAuthorized = false;
                                isAuthorized = requestMode.equals(0L) ? HelpdeskUtil.isAuthorizedGroup((String)((String)dnObject.get(0)), (ArrayList)ouList) : this.isAuthorizedGroup((String)dnObject.get(0), this.domainName);
                                if (!isAuthorized) continue;
                                ArrayList groupObjectSid = (ArrayList)props.get("objectSid");
                                removeFromGroupSidList.add((String)groupObjectSid.get(0));
                                ArrayList groupObjectName = (ArrayList)props.get("cn");
                                removeFromGroupNameList.add((String)groupObjectName.get(0));
                            }
                        }
                    }
                    int totalNoOfGroups = removeFromGroupSidList.size();
                    removeFromGroupSidList.retainAll(existingMemberOfSidsList);
                    int actualNoOfGroups = removeFromGroupSidList.size();
                    list = new ArrayList();
                    Properties p = new Properties();
                    p.put("ATTRIB_VALUE", dn);
                    p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                    p.put("DATA_HANDLER_TYPE", new Long(3L));
                    p.put("ATTRIB_LDAP_NAME", "member");
                    p.put("DW_CONTROL_CODE", new Long(4L));
                    list.add(p);
                    if (removeFromGroupSidList != null && !removeFromGroupSidList.isEmpty()) {
                        handleErrorList = new ArrayList();
                        errorOccured = false;
                        int removeFailCount = 0;
                        out.log(Level.INFO, "Modifying Group :RemoveFromGroup,  Domain Name : " + this.domainName + ", DNList : " + removeFromGroupSidList + ", list : " + list + " removeFromGroupNameList : " + removeFromGroupNameList);
                        for (index = 0; index < removeFromGroupSidList.size(); ++index) {
                            try {
                                ADHandlerForMgmt.modifyGroup((String)this.domainName, (Long)loginId, (String)((String)removeFromGroupSidList.get(index)), (String)dn, list, new ArrayList(), (boolean)true);
                                continue;
                            }
                            catch (LocalizedException le) {
                                this.addErrorMsgDetails(handleErrorList, le.getErrorMsgList());
                                status = le.getMsgFromDetails(rb);
                                errorOccured = true;
                                ++removeFailCount;
                                continue;
                            }
                            catch (Exception ex) {
                                message.append(ex.getMessage());
                                status = ex.getMessage();
                                errorOccured = true;
                                ++removeFailCount;
                            }
                        }
                        if (totalNoOfGroups != actualNoOfGroups) {
                            handleErrorList.add(new Hashtable());
                        }
                        groupModifyStatusMessage = GroupErrorHandler.handleModifyGroupError(handleErrorList, totalNoOfGroups, rb, removeFromGroupNameList, "", "remove", removeFailCount += totalNoOfGroups - actualNoOfGroups);
                        message.append(groupModifyStatusMessage);
                        out.log(Level.INFO, "User Mgmt - Remove from Group Message " + groupModifyStatusMessage);
                    } else {
                        out.log(Level.INFO, "Remove group sid list was empty... this should not be the case..severity ..need to check might be there is no group other pG associated with the selected dn " + dn);
                        message.append(rb.getString("admp.workflow.commitrequest.statmsg.group_not_memberof_msg"));
                    }
                    this.fillAttribs(list, "memberOf", removeFromGroupNameList);
                    TechAuditAPI.getInstance().auditGroupModification(loginId, rb.getString("admp.mgmt.user_mgmt.grp_attribs.mgmtname.remove_from_group"), this.getValue(result, (Integer)2043), this.domainName, list, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
                }
            }
            try {
                ADHandlerForMgmt.updateUser((String)this.domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)this.attributeList, (NativeListener)this);
            }
            catch (LocalizedException le) {
                message.append(le.getMessage(rb));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            message = new StringBuffer(rb.getString("admp.workflow.commitrequest.statmsg.error"));
        }
        this.updateResult(guid, message.toString(), errorOccured);
        return message.toString();
    }

    private void addErrorMsgDetails(ArrayList<Hashtable> handlerErrorMsgList, ArrayList nativeErrorMsgList) {
        if (nativeErrorMsgList != null & !nativeErrorMsgList.isEmpty()) {
            for (int count = 0; count < nativeErrorMsgList.size(); ++count) {
                handlerErrorMsgList.add((Hashtable)nativeErrorMsgList.get(count));
            }
        }
    }
}

