/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitMoveGroups
extends WorkFlowCommitListener {
    public CommitMoveGroups() {
        this.reportId = (int)ReportsUtil.MOVE_GROUP_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String destinationDN;
        String dn;
        String guid;
        Boolean errorOccured;
        StringBuffer message;
        block11: {
            message = new StringBuffer();
            errorOccured = true;
            guid = "";
            dn = (String)result.get(2003);
            this.domainName = (String)result.get(2021);
            destinationDN = "";
            try {
                String sid = (String)result.get(2023);
                guid = (String)result.get(2022);
                ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
                if (!inputsDetails.isEmpty()) {
                    for (AdmpInput admpInput : inputsDetails) {
                        if (admpInput.getIsMultiple().booleanValue()) {
                            for (FcOption fcOption : admpInput.getMultipleInput()) {
                                if (!fcOption.getLabel().equalsIgnoreCase("Container")) continue;
                                destinationDN = fcOption.getValue();
                            }
                            continue;
                        }
                        if (!admpInput.getName().equals("Container")) continue;
                        destinationDN = admpInput.getValue();
                    }
                    if (!this.isAuthorizedGroup(dn, this.domainName)) {
                        out.log(Level.INFO, "HDT is not authorized to modify this group--" + dn);
                        message.append(rb.getString("groupmanagement.messages.not_authorized_group"));
                    } else {
                        ADHandlerForMgmt.moveObject((String)this.domainName, (Long)loginId, (String)dn, (String)destinationDN);
                        ADHandlerForMgmt.updateUser((String)this.domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)this.attributeList, (NativeListener)this);
                        if (message.length() == 0) {
                            message.append(rb.getString("admp.workflow.commitrequest.statmsg.success_modified"));
                        } else {
                            message.insert(0, rb.getString("admp.workflow.commitrequest.statmsg.modified_but_error"));
                        }
                        errorOccured = false;
                        out.log(Level.INFO, "Commit move groups dn " + dn + " destination dn " + destinationDN);
                    }
                    break block11;
                }
                message = new StringBuffer(rb.getString("admp.workflow.commitrequest.alert.No_inputs_mentioned"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(rb.getString("groupmanagement.messages.unable_to_modify") + le.getMessage(rb));
            }
            catch (Exception e) {
                message = new StringBuffer(rb.getString("groupmanagement.messages.unable_to_modify") + e.getMessage());
            }
        }
        this.updateResult(guid, message.toString(), errorOccured);
        String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
        TechAuditAPI.getInstance().auditMoveGroup(loginId, rb.getString("admp.deleg.hdt_deleg.cre_role.action_name.move_groups"), this.getValue(result, (Integer)2003), this.domainName, sourceDN, destinationDN, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return message.toString();
    }
}

