/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.webclient.formats.UserModificationFormatUtil;
import com.adventnet.sym.adsm.common.webclient.util.DeleteUtil;
import com.adventnet.sym.adsm.common.webclient.util.MgmtUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class CommitMoveHomeFolder
extends WorkFlowCommitListener {
    public CommitMoveHomeFolder() {
        this.reportId = (int)ReportsUtil.PROFILE_USER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        this.domainName = (String)result.get(1143);
        ArrayList<String> attributeList = new ArrayList<String>();
        attributeList.add("distinguishedName");
        attributeList.add("objectGUID");
        attributeList.add("objectSID");
        attributeList.add("homeDirectory");
        attributeList.add("scriptPath");
        attributeList.add("profilePath");
        attributeList.add("sAMAccountName");
        attributeList.add("userPrincipalName");
        attributeList.add("name");
        Hashtable resultHash = new Hashtable();
        resultHash.putAll(result);
        ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
        String path = new String();
        String drive = new String();
        boolean retainHomeFolder = false;
        for (AdmpInput admpInput : inputsDetails) {
            if (!admpInput.getIsMultiple().booleanValue()) continue;
            for (FcOption fcOption : admpInput.getMultipleInput()) {
                if (fcOption.getValue().equals("")) continue;
                String text = fcOption.getLabel();
                if (text.equalsIgnoreCase("retain")) {
                    if (!fcOption.getValue().equalsIgnoreCase("true")) continue;
                    retainHomeFolder = true;
                    continue;
                }
                if (fcOption.getLabel().equalsIgnoreCase("drive")) {
                    drive = fcOption.getValue();
                    continue;
                }
                path = fcOption.getValue();
            }
        }
        StringBuffer message = new StringBuffer();
        try {
            String movefrom;
            String moveto;
            String task;
            boolean profilePath;
            boolean homefolder;
            block30: {
                String sid = this.getValue(result, (Integer)1144);
                String dn = this.getValue(result, (Integer)1004);
                homefolder = false;
                profilePath = false;
                boolean moveSuccess = false;
                boolean v2Exists = false;
                String value2 = new String();
                task = new String();
                moveto = path;
                movefrom = "";
                homefolder = true;
                movefrom = this.getValue(result, (Integer)1042);
                String value = moveto;
                if (!moveto.endsWith("\\")) {
                    value = moveto.concat("\\");
                }
                if ((value2 = value.concat(movefrom.substring(movefrom.lastIndexOf(92) + 1))).endsWith("$")) {
                    value2 = value2.substring(0, value2.length() - 1);
                }
                value2 = UserModificationFormatUtil.getFormattedValue(value2, resultHash, this.domainName, "");
                String validPathMsg = "";
                if (!movefrom.equals("") && movefrom.length() != 0 && !(validPathMsg = MgmtUtil.checkForValidPath(movefrom, value2, rb)).equals("")) {
                    message = message.append(validPathMsg);
                    homefolder = false;
                } else {
                    if (!movefrom.equals("") && movefrom.length() != 0 && movefrom.startsWith("\\\\")) {
                        try {
                            ADHandlerForMgmt.moveFolder((String)this.domainName, (Long)loginId, (String)movefrom, (String)value2);
                            moveSuccess = true;
                            ArrayList<Properties> setAttributeList = new ArrayList<Properties>();
                            Properties p = new Properties();
                            p.put("ATTRIB_LDAP_NAME", "homeDirectory");
                            p.put("ATTRIB_VALUE", value2);
                            p.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            p.put("DATA_HANDLER_TYPE", new Long(3L));
                            setAttributeList.add(p);
                            Properties p1 = new Properties();
                            p1.put("ATTRIB_LDAP_NAME", "homeDrive");
                            p1.put("ATTRIB_VALUE", drive);
                            p1.put("ATTRIB_VALUE_COUNT", new Long(1L));
                            p1.put("DATA_HANDLER_TYPE", new Long(3L));
                            setAttributeList.add(p1);
                            try {
                                ADHandlerForMgmt.modifyUser((String)this.domainName, (Long)loginId, (String)sid, (String)dn, setAttributeList, new ArrayList(), attributeList, (NativeListener)this);
                                if (homefolder) {
                                    message.append(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.successfully_moved_homefolder"));
                                }
                                if (!homefolder || retainHomeFolder) break block30;
                                boolean homeDeleteStatus = true;
                                homeDeleteStatus = this.deleteSharedFolder(false, movefrom, this.domainName, loginId);
                                if (!homeDeleteStatus) {
                                    message.append(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_delete"));
                                }
                                break block30;
                            }
                            catch (LocalizedException le) {
                                if (homefolder) {
                                    this.deleteSharedFolder(false, value2, this.domainName, loginId);
                                }
                                if (homefolder) {
                                    message = message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.error_modifying_homefolder"), le.getMessage(rb)));
                                }
                                break block30;
                            }
                            catch (Exception e) {
                                if (homefolder) {
                                    this.deleteSharedFolder(false, value2, this.domainName, loginId);
                                }
                                if (homefolder) {
                                    message = message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.error_modifying_homefolder"), e.getMessage()));
                                }
                                break block30;
                            }
                        }
                        catch (LocalizedException le) {
                            if (moveSuccess) {
                                this.deleteSharedFolder(false, value2, this.domainName, loginId);
                            }
                            if (homefolder) {
                                message = message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_homefolder"), le.getMessage(rb)));
                            }
                            break block30;
                        }
                        catch (Exception e) {
                            if (moveSuccess) {
                                this.deleteSharedFolder(false, value2, this.domainName, loginId);
                            }
                            if (homefolder) {
                                message = message.append(MessageFormat.format(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_homefolder"), e.getMessage()));
                            }
                            break block30;
                        }
                    }
                    if (homefolder) {
                        message.append(rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.unable_move_user_does_not_have_homefolder"));
                    }
                }
            }
            String modifiedMoveFrom = movefrom;
            String retainedText = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_retained");
            String deletedText = rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.folder_deleted");
            if (homefolder) {
                task = rb.getString("admp.mgmt.user_mgmt.move_homefolders.mgmtname.move_home_folders");
                modifiedMoveFrom = movefrom != null && movefrom != "" ? (retainHomeFolder ? modifiedMoveFrom + " " + retainedText : modifiedMoveFrom + " " + deletedText) : rb.getString("admp.mgmt.user_mgmt.move_homefolders.statmsg.no_home_folder");
            }
            if (profilePath || homefolder) {
                TechAuditAPI.getInstance().auditMoveHomeFolder(loginId, task, this.getValue(result, (Integer)1010), this.domainName, modifiedMoveFrom, moveto, drive, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb, profilePath);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return message.toString();
    }

    public boolean deleteSharedFolder(boolean v2Flag, String directoryPath, String domainName, Long loginId) {
        Boolean isFolderDeleted = false;
        Boolean isVistaFolderDeleted = false;
        try {
            if (v2Flag) {
                DeleteUtil.deleteFolder(directoryPath.concat(".V2"), domainName, loginId);
                isVistaFolderDeleted = true;
            }
            File folderPath = new File(directoryPath);
            DeleteUtil.deleteFolder(directoryPath, domainName, loginId);
            isFolderDeleted = true;
        }
        catch (LocalizedException le) {
            isFolderDeleted = false;
            le.printStackTrace();
        }
        catch (Exception e) {
            isFolderDeleted = false;
            e.printStackTrace();
        }
        return isVistaFolderDeleted != false || isFolderDeleted != false;
    }
}

