/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.ADHandlerForMgmt;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.TechAuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.logging.Level;

public class CommitMoveUsers
extends WorkFlowCommitListener {
    public CommitMoveUsers() {
        this.reportId = (int)ReportsUtil.MOVE_USER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String destinationDN;
        String dn;
        String guid;
        Boolean errorOccured;
        StringBuffer message;
        block7: {
            message = new StringBuffer();
            errorOccured = true;
            guid = "";
            dn = (String)result.get(1004);
            this.domainName = (String)result.get(1143);
            String sid = this.getValue(result, (Integer)1144);
            destinationDN = "";
            try {
                guid = (String)result.get(1145);
                ArrayList inputsDetails = (ArrayList)requestActionDetails.get("MultipleInputs");
                if (!inputsDetails.isEmpty()) {
                    for (AdmpInput admpInput : inputsDetails) {
                        if (admpInput.getIsMultiple().booleanValue()) {
                            for (FcOption fcOption : admpInput.getMultipleInput()) {
                                if (!fcOption.getLabel().equalsIgnoreCase("Container")) continue;
                                destinationDN = fcOption.getValue();
                            }
                            continue;
                        }
                        if (!admpInput.getName().equals("Container")) continue;
                        destinationDN = admpInput.getValue();
                    }
                    ADHandlerForMgmt.moveObject((String)this.domainName, (Long)loginId, (String)dn, (String)destinationDN);
                    ADHandlerForMgmt.updateUser((String)this.domainName, (Long)loginId, (String)sid, (String)dn, (ArrayList)this.attributeList, (NativeListener)this);
                    message.append(rb.getString("groupmanagement.messages.successfully_modified"));
                    errorOccured = false;
                    out.log(Level.INFO, "Commit move users dn " + dn + " destination dn " + destinationDN);
                    break block7;
                }
                message = new StringBuffer(rb.getString("admp.workflow.commitrequest.alert.No_inputs_mentioned"));
            }
            catch (LocalizedException le) {
                le.printStackTrace();
                message = new StringBuffer(rb.getString("usermanagement.messages.unable_modify_user") + le.getMessage(rb));
            }
            catch (Exception e) {
                message = new StringBuffer(rb.getString("usermanagement.messages.unable_modify_user") + e.getMessage());
            }
        }
        this.updateResult(guid, message.toString(), errorOccured);
        String sourceDN = StrUtil.getContainerDNFromDN((String)dn);
        TechAuditAPI.getInstance().auditMoveUser(loginId, rb.getString("admp.mgmt.common.mgmtname.move_user"), this.getValue(result, (Integer)1010), this.domainName, sourceDN, destinationDN, message.toString(), (Long)audit_info.get("object_id"), auditDataObj, rb);
        return message.toString();
    }
}

