/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowCommitListener;
import com.manageengine.ads.fw.api.RestAPI;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;

public class CommitSSPResetPassword
extends WorkFlowCommitListener {
    public CommitSSPResetPassword() {
        this.reportId = (int)ReportsUtil.RESET_PASSWORD_USER_MGMT_REPORT_ID;
    }

    @Override
    protected String commit(HashMap result, HashMap requestActionDetails, Long loginId, AdventNetResourceBundle rb, Hashtable audit_info, DataObject auditDataObj) {
        String message;
        Boolean errorOccured = true;
        String dn = (String)result.get(1004);
        String sid = (String)result.get(1144);
        this.domainName = (String)result.get(1143);
        String guid = (String)result.get(1145);
        String samAccountName = (String)result.get(1006);
        Long actionToPerform = (Long)requestActionDetails.get("REQUEST_ACTION");
        if (actionToPerform.compareTo(WorkFlowUtil.SSP_WF_APPROVAL_PASSWORD_ACTION_ID) != 0) {
            String message2 = rb.getString("admp.workflow.sspwf.statmsg.execute_wrong_action");
            this.updateResult(guid, message2, errorOccured);
            return message2;
        }
        Properties params = new Properties();
        params.put("USERNAME", samAccountName);
        params.put("DOMAIN_NAME", this.domainName);
        params.put("ACTION_TO_PERFORM", "reset");
        params.put("OBJECT_SID", sid);
        params.put("OBJECT_GUID", guid);
        params.put("USER_DN", dn);
        params.put("operation", "selfServiceApproval");
        Long productId = CommonUtil.getProductId((String)"ManageEngine ADSelfService Plus");
        RestAPI api = new RestAPI();
        try {
            api.execute(productId, "ADSSP_PASSWORD_SELFSERVICE_APPROVAL", params);
            message = rb.getString(this.getMessageText(api.getResponseText()));
            if (api.getResponseText().equalsIgnoreCase("adssp.common.text.mail_sent_success")) {
                errorOccured = false;
            }
        }
        catch (Exception e) {
            message = rb.getString("admp.workflow.sspwf.statmsg.execute_failed_ssp_down");
        }
        this.updateResult(guid, message, errorOccured);
        return message;
    }

    private String getMessageText(String sspText) {
        String message = "admp.workflow.sspwf.statmsg.problem_with_mail_server";
        if (sspText.equalsIgnoreCase("adssp.common.text.mail_sent_success")) {
            message = "admp.workflow.sspwf.statmsg.executed_success";
        } else if (sspText.equalsIgnoreCase("adssp.common.text.unable_send_notification")) {
            message = "admp.workflow.sspwf.statmsg.no_mail_id_present";
        } else if (sspText.equalsIgnoreCase("adssp.reset_unlock.accounts.rp_ua.permission_denied_contact_admin")) {
            message = "admp.workflow.sspwf.statmsg.no_reset_permission";
        }
        return message;
    }
}

