/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.fileserver.FileServerMgmtHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.FileServerMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.AdditionalExecutionActions;
import com.adventnet.taskengine.util.CalendarRowConfig;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class RevertNTFSPermission
extends AdditionalExecutionActions {
    String duration = "";
    String durationType = "";

    @Override
    public void executeAction() {
        try {
            Criteria criteria;
            DataObject dataObject;
            JSONObject durationJSON = new JSONObject(this.value);
            if (durationJSON.has("duration")) {
                this.duration = durationJSON.getString("duration");
            }
            if (durationJSON.has("durationType")) {
                this.durationType = durationJSON.getString("durationType");
            }
            if (this.isCVCRequest.booleanValue() && (dataObject = AutomationUtil.getWFRequestDO((Long)this.requestId, (Criteria)(criteria = new Criteria(Column.getColumn((String)"ADSMRequestsToReqMonitorMap", (String)"REQUEST_ID"), (Object)this.requestId, 0)))) != null) {
                this.executeActionForCVCRequest(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private void executeActionForCVCRequest(DataObject requestDO) throws Exception {
        if (this.actionId.equals(AdditionalExecutionActions.REVERT_PERMISSION_DURATION) && !this.duration.equals("0")) {
            this.createRevertSchedule(requestDO);
        }
    }

    private void createRevertSchedule(DataObject requestDO) throws Exception {
        DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
        Long reqMonitorId = (Long)requestDO.getFirstValue("ADSMReqMonitorTaskSet", "REQ_MONITOR_ID");
        Row reqMonitorTaskSetRow = new Row("ADSMReqMonitorTaskSet");
        reqMonitorTaskSetRow.set("REQ_MONITOR_ID", (Object)reqMonitorId);
        reqMonitorTaskSetRow.set("SCHEDULE_ID", (Object)0L);
        reqMonitorTaskSetRow.set("IS_EXECUTED", (Object)true);
        reqMonitorTaskSetRow.set("AUTOMATIC_EXECUTION_ENABLED", (Object)true);
        reqMonitorTaskSetRow.set("EXECUTION_STATUS", (Object)WorkFlowUtil.TASKSET_SCHEDULER_STARTED);
        dataObject.addRow(reqMonitorTaskSetRow);
        DataAccess.fillGeneratedValues((DataObject)dataObject);
        Long taskSetId = (Long)reqMonitorTaskSetRow.get("REQ_MONITOR_TASKSET_ID");
        String scheduleName = "Automaton_" + taskSetId + "" + System.currentTimeMillis();
        CalendarRowConfig calRowConf = new CalendarRowConfig();
        calRowConf.setScheduleType("None");
        Calendar cal = Calendar.getInstance();
        if (this.durationType.equalsIgnoreCase("date")) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
            Date date = sdf.parse(this.duration);
            long millis = date.getTime();
            cal.setTimeInMillis(millis);
        } else {
            Integer revertTime = Integer.parseInt(this.duration);
            cal.setTimeInMillis(System.currentTimeMillis());
            if (this.durationType.equalsIgnoreCase("minutes")) {
                cal.add(12, revertTime);
            } else if (this.durationType.equalsIgnoreCase("hours")) {
                cal.add(10, revertTime);
            } else if (this.durationType.equalsIgnoreCase("days")) {
                cal.add(5, revertTime);
            }
        }
        calRowConf.setExecutionTime(cal.get(11), cal.get(12), cal.get(13));
        calRowConf.setStartDate(cal.get(5), cal.get(2), cal.get(1));
        Row calRow = calRowConf.toCalendarRow();
        Long scheduleId = this.fillTimeBasedSchedule(dataObject, scheduleName, calRow);
        reqMonitorTaskSetRow.set("SCHEDULE_ID", (Object)scheduleId);
        CalendarRowConfig.Date1 date = new CalendarRowConfig.Date1(cal.get(5), cal.get(2), cal.get(1));
        CalendarRowConfig.Time1 time = new CalendarRowConfig.Time1(cal.get(11), cal.get(12), cal.get(13));
        Row timeBasedAutoRow = new Row("ADSMTimeBasedAutomation");
        timeBasedAutoRow.set("SCHEDULE_ID", (Object)scheduleId);
        timeBasedAutoRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
        timeBasedAutoRow.set("TIME_SUMMARY", (Object)(date.toString() + " " + time.toString()));
        dataObject.addRow(timeBasedAutoRow);
        Iterator monitorTaskIt = requestDO.getRows("ADSMReqMonitorTask");
        while (monitorTaskIt.hasNext()) {
            Row taskRow = (Row)monitorTaskIt.next();
            Row reqMonitorTaskRow = new Row("ADSMReqMonitorTask");
            reqMonitorTaskRow.set("REQ_MONITOR_TASKSET_ID", reqMonitorTaskSetRow.get("REQ_MONITOR_TASKSET_ID"));
            reqMonitorTaskRow.set("REQUEST_ACTION", (Object)5002L);
            reqMonitorTaskRow.set("CREATION_TIME", (Object)System.currentTimeMillis());
            dataObject.addRow(reqMonitorTaskRow);
            Long resultGenerationId = 0L;
            DataObject resultDO = null;
            String resultTable = FileServerMgmtHandler.getModifyFolderResultTableName((Long)resultGenerationId);
            Row resultGenRow = requestDO.getRow("RequestCVCResultGenerationMap", new Criteria(Column.getColumn((String)"RequestCVCResultGenerationMap", (String)"REQ_MONITOR_TASK_ID"), taskRow.get("REQ_MONITOR_TASK_ID"), 0));
            if (resultGenRow != null) {
                resultGenerationId = (Long)resultGenRow.get("REPORT_GENERATION_ID");
                resultDO = FileServerMgmtUtil.getFolderModificationResult((Long)resultGenerationId);
            }
            Criteria cvcCriteria = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"REQ_MONITOR_TASK_ID"), taskRow.get("REQ_MONITOR_TASK_ID"), 0);
            cvcCriteria = cvcCriteria.and(new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"IS_REMOVED"), (Object)false, 0));
            DataObject cvcDO = WorkFlowUtil.getCVCWorkFlowObjectsDO((Criteria)cvcCriteria);
            cvcCriteria = cvcCriteria.and(new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"ACTION_RESULT"), null, 0));
            Iterator cvcDataIt = requestDO.getRows("WFCVCDataSummary", cvcCriteria);
            while (cvcDataIt.hasNext()) {
                Row cvcDataRow = (Row)cvcDataIt.next();
                Long actionId = (Long)cvcDataRow.get("ACTION_ID");
                if (actionId.equals(WorkFlowUtil.ADD_TO_GROUP_HAVING_SAME_PERMISSION) || actionId.equals(WorkFlowUtil.ADD_TO_GROUP_ASSIGN_PERMISSION_TO_GROUP)) {
                    this.addCVCDataSummaryRow(dataObject, cvcDataRow, reqMonitorTaskRow, actionId);
                    continue;
                }
                String cvcDataJSONStr = (String)cvcDataRow.get("CVC_DATA_SUMMARY");
                JSONObject cvcDataJSON = new JSONObject(cvcDataJSONStr);
                Long folderId = cvcDataJSON.has("CVC_FOLDER_INPUT_ID") ? Long.valueOf(cvcDataJSON.getLong("CVC_FOLDER_INPUT_ID")) : null;
                Long permId = cvcDataJSON.has("CVC_PERMISSION_INPUT_ID") ? Long.valueOf(cvcDataJSON.getLong("CVC_PERMISSION_INPUT_ID")) : null;
                Criteria resultCri = new Criteria(Column.getColumn((String)"CVCAccessMaskData", (String)"PERM_DATA_ID"), (Object)permId, 0);
                ArrayList<Long> maskIdList = new ArrayList<Long>();
                Iterator maskIt = cvcDO.getRows("CVCAccessMaskData", resultCri);
                while (maskIt.hasNext()) {
                    Row maskRow = (Row)maskIt.next();
                    Long uniqueId = (Long)maskRow.get("UNIQUE_ID");
                    maskIdList.add(uniqueId);
                }
                Boolean hasSuccessfullResult = true;
                JSONArray maskIdJSONArray = new JSONArray();
                resultCri = new Criteria(Column.getColumn((String)resultTable, (String)"CVC_FOLDER_ID"), (Object)folderId, 0);
                resultCri = resultCri.and(new Criteria(Column.getColumn((String)resultTable, (String)"CVC_PERMISSION_ID"), (Object)StrUtil.getLongArray(maskIdList), 8));
                resultCri = resultCri.and(new Criteria(Column.getColumn((String)resultTable, (String)"ERROR_CODE"), (Object)0, 0));
                if (resultDO != null) {
                    Iterator resultValueIt = resultDO.getRows(resultTable, resultCri);
                    while (resultValueIt.hasNext()) {
                        Row resultValueRow = (Row)resultValueIt.next();
                        Long maskId = (Long)resultValueRow.get("CVC_PERMISSION_ID");
                        maskIdJSONArray.put((Object)maskId);
                    }
                }
                if (maskIdJSONArray.length() == 0) continue;
                cvcDataJSON.put("CVC_ACCESS_MASK_INPUT_ID", (Object)maskIdJSONArray);
                cvcDataRow.set("CVC_DATA_SUMMARY", (Object)cvcDataJSON.toString());
                this.addCVCDataSummaryRow(dataObject, cvcDataRow, reqMonitorTaskRow, actionId);
            }
        }
        if (dataObject.containsTable("WFCVCDataSummary")) {
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
        }
    }

    private void addCVCDataSummaryRow(DataObject dataObject, Row cvcDataRow, Row reqMonitorTaskRow, Long editActionId) throws Exception {
        Long revertEditActionId = WorkFlowUtil.getRevertEditActionId((Long)editActionId, (Integer)this.subCategoryId);
        Row summaryRow = new Row("WFCVCDataSummary");
        summaryRow.set("CVC_DATA_ID", cvcDataRow.get("CVC_DATA_ID"));
        summaryRow.set("CVC_DATA_SUMMARY", cvcDataRow.get("CVC_DATA_SUMMARY"));
        summaryRow.set("REQ_MONITOR_TASK_ID", reqMonitorTaskRow.get("REQ_MONITOR_TASK_ID"));
        summaryRow.set("ACTION_ID", (Object)revertEditActionId);
        summaryRow.set("ACTION_VALUE", cvcDataRow.get("ACTION_VALUE"));
        summaryRow.set("ACTION_VALUE_ID", cvcDataRow.get("ACTION_VALUE_ID"));
        summaryRow.set("ACTION_VALUE_DOMAIN", cvcDataRow.get("ACTION_VALUE_DOMAIN"));
        summaryRow.set("IS_EXECUTED", (Object)false);
        summaryRow.set("HAS_MULTIPLE_EDIT_ACTIONS", (Object)false);
        dataObject.addRow(summaryRow);
    }
}

