/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataAccess;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.internal.UniqueValueHolder;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.automation.ReportFilterConfig;
import com.adventnet.sym.adsm.common.server.automation.constants.AutomationConstants;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.ScheduledMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.wengine.SchedulerRunNowObject;
import com.adventnet.sym.adsm.common.server.workflow.AddUserRequestHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBDataSourceUtil;
import com.adventnet.sym.adsm.common.webclient.integration.DBInputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.InputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.WorkdayInputDataSource;
import com.adventnet.sym.adsm.common.webclient.integration.ZPeopleInputDataSource;
import com.adventnet.sym.adsm.common.webclient.model.BeanMap;
import com.adventnet.sym.adsm.common.webclient.usermanagement.ModifyPhotoListener;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.SchedulerExecution;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONObject;

public class ScheduledMgmtActionUtil {
    private static Logger out = Logger.getLogger("WFLogger");

    public static void addAutomation(DynaValidatorForm bean, Long robo_id, HttpServletRequest request, Long loginId, HashMap timeValues) throws Exception {
        HttpSession session = request.getSession();
        String domainName = (String)bean.get("domains");
        domainName = DomainUtil.getDomainName((String)domainName);
        String scheduleName = (String)bean.get("roboName");
        boolean isPolicyBasedAutomation = false;
        if (request.getParameter("isPolicyBasedAutomation") != null) {
            isPolicyBasedAutomation = new Boolean(request.getParameter("isPolicyBasedAutomation"));
        }
        String autoExecution = request.getParameter("autoExecution");
        String isAppendedCSVData = request.getParameter("isAppendedCSVData");
        autoExecution = autoExecution != null ? "false" : "true";
        isAppendedCSVData = isAppendedCSVData != null ? "true" : "false";
        boolean isCustom = false;
        if (((String)bean.get("repSchedule")).equalsIgnoreCase("Custom")) {
            isCustom = true;
        }
        UniqueValueHolder automationId = null;
        Long requestAction = (Long)bean.get("requestAction");
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row row = new Row("ADSMAutomation");
            row.set("SCHEDULE_ID", (Object)robo_id);
            row.set("AUTOMATION_NAME", (Object)scheduleName);
            row.set("DESCRIPTION", bean.get("description") != null ? bean.get("description") : "");
            row.set("OBJECT_TYPE", bean.get("subCategory"));
            row.set("DOMAIN_NAME", (Object)domainName);
            row.set("TIME_SUMMARY", timeValues.get("timeSummary"));
            row.set("CREATED_BY", (Object)loginId);
            row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            row.set("SUBJECT", (Object)scheduleName);
            row.set("CSV_LOCATION", (Object)((String)bean.get("csvLocation")));
            row.set("AUTOMATIC_EXECUTION_ENABLED", (Object)new Boolean(autoExecution));
            row.set("IS_POLICYBASED_AUTOMATION", (Object)isPolicyBasedAutomation);
            row.set("APPENDED_CSV_DATA", (Object)new Boolean(isAppendedCSVData));
            row.set("CUSTOM_SCHEDULER", (Object)isCustom);
            Boolean isNotificationEnabled = request.getParameter("isNotificationEnabled") != null ? Boolean.valueOf(request.getParameter("isNotificationEnabled")) : false;
            row.set("IS_NOTIFY_ENABLED", (Object)isNotificationEnabled);
            dataObj.addRow(row);
            Row automationRow = dataObj.getFirstRow("ADSMAutomation");
            automationId = (UniqueValueHolder)automationRow.get("AUTOMATION_ID");
            if (isPolicyBasedAutomation) {
                Row policyRow = new Row("ADSMAutomationPolicyMapping");
                policyRow.set("AUTOMATION_ID", (Object)automationId);
                policyRow.set("AUTO_POLICY_ID", (Object)requestAction);
                dataObj.addRow(policyRow);
            } else {
                Row mgmtActionRow = new Row("ADSMAutomationRequestActions");
                mgmtActionRow.set("AUTOMATION_ID", (Object)automationId);
                mgmtActionRow.set("REQUEST_ACTION", (Object)requestAction);
                dataObj.addRow(mgmtActionRow);
                ScheduledMgmtActionUtil.updateActionInputDetails(bean, request, dataObj, robo_id);
            }
            DataAccess.generateValues((Row)automationRow);
            if (isNotificationEnabled.booleanValue()) {
                String templateIdStr = request.getParameter("selectedTemplateIds");
                String[] templateIdStrArr = templateIdStr.split(",");
                Long[] templateIds = new Long[templateIdStrArr.length];
                for (int i = 0; i < templateIdStrArr.length; ++i) {
                    templateIds[i] = Long.valueOf(templateIdStrArr[i]);
                }
                ScheduledMgmtUtil.setSelectedTemplateList((DataObject)dataObj, (Long)((Long)automationRow.get("AUTOMATION_ID")), (Long[])templateIds);
            }
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            Hashtable excludedOUListMap = (Hashtable)bean.get("excludedOUList");
            Hashtable exclChildOUListMap = (Hashtable)bean.get("domainVsExcludeChildOU");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domains = authObject.getDomainAndOUs();
            Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
            ArrayList excludedOUList = (ArrayList)excludedOUListMap.get(dnDomainNameMap.get(request.getParameter("domains")));
            ArrayList selectedOUList = (ArrayList)domainOUList.get(request.getParameter("domains"));
            Boolean exclChildOU = (Boolean)exclChildOUListMap.get(dnDomainNameMap.get(request.getParameter("domains")));
            if (selectedOUList != null) {
                try {
                    Hashtable<String, Boolean> exclChildOUMap = new Hashtable<String, Boolean>();
                    exclChildOUMap.put(domainName, exclChildOU);
                    SchedulerInputsUtil.addExcludeChildOUListInScheduler(exclChildOUMap, robo_id, dataObj, false);
                    Hashtable<String, ArrayList> excludedOUMap = new Hashtable<String, ArrayList>();
                    excludedOUMap.put(domainName, excludedOUList);
                    SchedulerInputsUtil.addExcludedOUListInScheduler(excludedOUMap, robo_id, dataObj, false);
                    Hashtable<String, ArrayList> selectedOUMap = new Hashtable<String, ArrayList>();
                    selectedOUMap.put(domainName, selectedOUList);
                    SchedulerInputsUtil.addOUListInScheduler(selectedOUMap, robo_id, dataObj, false);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (!requestAction.equals(WorkFlowUtil.CREATE_USER_ACTION_ID) && bean.get("rfConfig") != null) {
                ReportFilterConfig rfConfig = (ReportFilterConfig)bean.get("rfConfig");
                SchedulerInputsUtil.addReportFilterDetails(rfConfig, robo_id, dataObj, false);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObj);
        }
        catch (DataAccessException e) {
            e.printStackTrace();
            throw e;
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public static void updateAutomation(DynaValidatorForm bean, HttpServletRequest request, Long automationId, Long scheduleId, HashMap timeValues) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Criteria criteria = new Criteria(Column.getColumn((String)"ADSMAutomation", (String)"AUTOMATION_ID"), (Object)automationId, 0);
        String automationName = (String)bean.get("roboName");
        String domainName = (String)bean.get("domains");
        domainName = DomainUtil.getDomainName((String)domainName);
        String autoExecution = request.getParameter("autoExecution");
        String isAppendedCSVData = request.getParameter("isAppendedCSVData");
        isAppendedCSVData = isAppendedCSVData != null ? "true" : "false";
        autoExecution = autoExecution != null ? "false" : "true";
        boolean isPolicyBasedAutomation = false;
        boolean isCustom = false;
        if (((String)bean.get("repSchedule")).equalsIgnoreCase("Custom")) {
            isCustom = true;
        }
        if (request.getParameter("isPolicyBasedAutomation") != null) {
            isPolicyBasedAutomation = new Boolean(request.getParameter("isPolicyBasedAutomation"));
        }
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMAutomation"));
        query.addSelectColumn(Column.getColumn(null, (String)"*"));
        query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMAutomationRequestActions"), new String[]{"AUTOMATION_ID"}, new String[]{"AUTOMATION_ID"}, 1));
        query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMAutomationPolicyMapping"), new String[]{"AUTOMATION_ID"}, new String[]{"AUTOMATION_ID"}, 1));
        query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMSchedulersOUMapping"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        query.addJoin(new Join(Table.getTable((String)"ADSMAutomation"), Table.getTable((String)"ADSMScheduleReportsMapping"), new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1));
        query.setCriteria(criteria);
        DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
        if (!dataObj.isEmpty()) {
            Hashtable exclChildOUListMap;
            Boolean isExclChildOU;
            Hashtable excludedOUListMap;
            ArrayList excludedOUList;
            Row row = dataObj.getRow("ADSMAutomation");
            row.set("SCHEDULE_ID", (Object)scheduleId);
            row.set("AUTOMATION_NAME", (Object)automationName);
            row.set("DESCRIPTION", bean.get("description"));
            row.set("OBJECT_TYPE", bean.get("subCategory"));
            row.set("DOMAIN_NAME", (Object)domainName);
            row.set("TIME_SUMMARY", timeValues.get("timeSummary"));
            row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            row.set("SUBJECT", (Object)automationName);
            row.set("CSV_LOCATION", bean.get("csvLocation") != null ? bean.get("csvLocation") : "");
            row.set("AUTOMATIC_EXECUTION_ENABLED", (Object)new Boolean(autoExecution));
            row.set("IS_POLICYBASED_AUTOMATION", (Object)isPolicyBasedAutomation);
            row.set("CUSTOM_SCHEDULER", (Object)isCustom);
            row.set("APPENDED_CSV_DATA", (Object)new Boolean(isAppendedCSVData));
            Boolean isNotificationEnabled = request.getParameter("isNotificationEnabled") != null ? Boolean.valueOf(request.getParameter("isNotificationEnabled")) : false;
            row.set("IS_NOTIFY_ENABLED", (Object)isNotificationEnabled);
            if (isNotificationEnabled.booleanValue()) {
                String templateIdStr = request.getParameter("selectedTemplateIds");
                String[] templateIdStrArr = templateIdStr.split(",");
                Long[] templateIds = new Long[templateIdStrArr.length];
                for (int i = 0; i < templateIdStrArr.length; ++i) {
                    templateIds[i] = Long.valueOf(templateIdStrArr[i]);
                }
                ScheduledMgmtUtil.setSelectedTemplateList((DataObject)dataObj, (Long)automationId, (Long[])templateIds);
            }
            dataObj.updateRow(row);
            Long requestAction = (Long)bean.get("requestAction");
            Criteria deleteCriteria = null;
            deleteCriteria = new Criteria(Column.getColumn((String)"ADSMAutomationRequestActions", (String)"AUTOMATION_ID"), (Object)automationId, 0);
            dataObj.deleteRows("ADSMAutomationRequestActions", deleteCriteria);
            deleteCriteria = new Criteria(Column.getColumn((String)"ADSMAutomationPolicyMapping", (String)"AUTOMATION_ID"), (Object)automationId, 0);
            dataObj.deleteRows("ADSMAutomationPolicyMapping", deleteCriteria);
            if (isPolicyBasedAutomation) {
                Row policyRow = new Row("ADSMAutomationPolicyMapping");
                policyRow.set("AUTOMATION_ID", (Object)automationId);
                policyRow.set("AUTO_POLICY_ID", (Object)requestAction);
                dataObj.addRow(policyRow);
            } else {
                Row mgmtActionRow = new Row("ADSMAutomationRequestActions");
                mgmtActionRow.set("AUTOMATION_ID", (Object)automationId);
                mgmtActionRow.set("REQUEST_ACTION", (Object)((Long)bean.get("requestAction")));
                dataObj.addRow(mgmtActionRow);
                ScheduledMgmtActionUtil.updateActionInputDetails(bean, request, dataObj, scheduleId);
            }
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domains = authObject.getDomainAndOUs();
            Criteria deleteCriteria1 = new Criteria(Column.getColumn((String)"ADSMSchedulersExclChildMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria1);
            deleteCriteria1 = new Criteria(Column.getColumn((String)"ADSMSchedulersExcludeOUMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria1);
            deleteCriteria1 = new Criteria(Column.getColumn((String)"ADSMSchedulersOUMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(deleteCriteria1);
            Hashtable dnDomainNameMap = (Hashtable)domains.get("dnDomainNameMap");
            Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
            ArrayList selectedOUList = (ArrayList)domainOUList.get(request.getParameter("domains"));
            if (selectedOUList != null) {
                Hashtable<String, ArrayList> selectedOUMap = new Hashtable<String, ArrayList>();
                selectedOUMap.put(domainName, selectedOUList);
                SchedulerInputsUtil.addOUListInScheduler(selectedOUMap, scheduleId, dataObj, false);
            }
            if ((excludedOUList = (ArrayList)(excludedOUListMap = (Hashtable)bean.get("excludedOUList")).get(dnDomainNameMap.get(request.getParameter("domains")))) != null) {
                Hashtable<String, ArrayList> excludedOUMap = new Hashtable<String, ArrayList>();
                excludedOUMap.put(domainName, excludedOUList);
                SchedulerInputsUtil.addExcludedOUListInScheduler(excludedOUMap, scheduleId, dataObj, false);
            }
            if ((isExclChildOU = (Boolean)(exclChildOUListMap = (Hashtable)bean.get("domainVsExcludeChildOU")).get(dnDomainNameMap.get(request.getParameter("domains")))) != null) {
                Hashtable<String, Boolean> exclChildOUMap = new Hashtable<String, Boolean>();
                exclChildOUMap.put(domainName, isExclChildOU);
                SchedulerInputsUtil.addExcludeChildOUListInScheduler(exclChildOUMap, scheduleId, dataObj, false);
            }
            if (!requestAction.equals(WorkFlowUtil.CREATE_USER_ACTION_ID) && bean.get("rfConfig") != null) {
                ReportFilterConfig rfConfig = (ReportFilterConfig)bean.get("rfConfig");
                SchedulerInputsUtil.addReportFilterDetails(rfConfig, scheduleId, dataObj, true);
            }
        }
        CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObj);
    }

    private static void updateActionInputDetails(DynaValidatorForm bean, HttpServletRequest request, DataObject dataObj, Long scheduleId) throws Exception {
        Long requestAction = (Long)bean.get("requestAction");
        Row mgmtActionRow = dataObj.getRow("ADSMAutomationRequestActions");
        BeanMap props = (BeanMap)bean.get("props");
        UniqueValueHolder reqActionDetailsId = (UniqueValueHolder)mgmtActionRow.get("AUTO_REQACTION_DETAILS_ID");
        String inputValue = (String)bean.get("inputValue");
        String inputName = "";
        boolean flag = false;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ArrayList multipleInputs = new ArrayList();
        HashMap<String, Object> inputMap = new HashMap<String, Object>();
        if (inputValue != null && !inputValue.equals("")) {
            String dataSourceType;
            ArrayList<FcOption> inputsList;
            Long integAdvncCriteriaId;
            Long automationId;
            JSONObject inputDetails;
            if (requestAction.equals(4L) || requestAction.equals(34L) || requestAction.equals(42L) || requestAction.equals(53L)) {
                inputName = "Container";
                inputMap.put("VARIABLE", "Container");
                inputMap.put("VALUE", inputValue);
                inputMap.put("ISMULTIPLE", false);
                multipleInputs.add(inputMap);
                flag = true;
                out.log(Level.INFO, "inputName: " + inputName + "inputValue: " + inputValue);
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "domainSelect");
                inputMap.put("VALUE", (String)bean.get("domainSelect"));
                inputMap.put("ISMULTIPLE", false);
                multipleInputs.add(inputMap);
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "selectedOUName");
                inputMap.put("VALUE", (String)bean.get("selectedOUName"));
                inputMap.put("ISMULTIPLE", false);
                multipleInputs.add(inputMap);
            } else if (requestAction.equals(3L)) {
                String csvLoc;
                inputDetails = null;
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "DeleteUsers");
                inputMap.put("VALUE", "");
                inputMap.put("ISMULTIPLE", true);
                ArrayList<FcOption> arrayList = new ArrayList<FcOption>();
                inputMap.put("multiInputValuesList", arrayList);
                FcOption fcOption3 = null;
                String dataSourceType2 = bean.get("dataSourceType").toString();
                if (AutomationConstants.EXTERNAL_SOURCES.contains(dataSourceType2)) {
                    fcOption3 = new FcOption();
                    fcOption3.setLabel("dbConfigId");
                    fcOption3.setValue((String)bean.get("dbConfigId"));
                    arrayList.add(fcOption3);
                    if (bean.get("integAdvncCriteriaId") != null) {
                        automationId = Long.getLong(mgmtActionRow.get("AUTOMATION_ID").toString());
                        integAdvncCriteriaId = AutomationUtil.saveIntegAdvncDetails((Long)scheduleId, (JSONObject)new JSONObject(request.getParameter("integAdvncCriteriadetails")), (DataObject)dataObj);
                        fcOption3 = new FcOption();
                        fcOption3.setLabel("integAdvncCriteriaId");
                        fcOption3.setValue(integAdvncCriteriaId.toString());
                        arrayList.add(fcOption3);
                    }
                    fcOption3 = new FcOption();
                    fcOption3.setLabel("dataSourceType");
                    fcOption3.setValue(dataSourceType2);
                    arrayList.add(fcOption3);
                    fcOption3 = new FcOption();
                    fcOption3.setLabel("isAddCurrentRecords");
                    fcOption3.setValue("true");
                    arrayList.add(fcOption3);
                } else if (dataSourceType2.equalsIgnoreCase("csv") && !(csvLoc = (String)bean.get("csvLocation")).isEmpty()) {
                    fcOption3 = new FcOption();
                    fcOption3.setLabel("dataSourceType");
                    fcOption3.setValue(dataSourceType2);
                    arrayList.add(fcOption3);
                    fcOption3 = new FcOption();
                    fcOption3.setLabel("isAddCurrentRecords");
                    fcOption3.setValue("true");
                    arrayList.add(fcOption3);
                }
                if (!bean.get("reportValue").toString().isEmpty()) {
                    fcOption3 = new FcOption();
                    fcOption3.setLabel("addReportObjs");
                    fcOption3.setValue(bean.getString("reportValue"));
                    arrayList.add(fcOption3);
                }
                flag = true;
                multipleInputs.add(inputMap);
            } else if (requestAction.compareTo(WorkFlowUtil.ADDTO_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.COMPUTER_ADDTO_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CONTACT_ADDTO_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.GROUP_ADDTO_GROUP_ACTION_ID) == 0) {
                Hashtable addToGroupSidVsNameMap = (Hashtable)props.get("addToGroupSidVsNameMap");
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "AddToGroup");
                inputMap.put("ISMULTIPLE", true);
                String string = "";
                ArrayList<FcOption> inputsList3 = new ArrayList<FcOption>();
                if (addToGroupSidVsNameMap != null && addToGroupSidVsNameMap.size() > 0) {
                    Enumeration groupMapKeys = addToGroupSidVsNameMap.keys();
                    while (groupMapKeys.hasMoreElements()) {
                        String string2 = (String)groupMapKeys.nextElement();
                        FcOption fcOption2 = new FcOption(string2, (String)addToGroupSidVsNameMap.get(string2), false);
                        inputsList3.add(fcOption2);
                    }
                }
                inputMap.put("multiInputValuesList", inputsList3);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.compareTo(WorkFlowUtil.REMOVEFROM_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.COMPUTER_REMOVEFROM_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CONTACT_REMOVEFROM_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.GROUP_REMOVEFROM_GROUP_ACTION_ID) == 0) {
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "RemoveFromGroup");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList<FcOption>();
                inputMap.put("multiInputValuesList", inputsList);
                multipleInputs.add(inputMap);
                inputValue = "false";
                String string = request.getParameter("isRemoveAllGroup");
                if (string != null) {
                    inputValue = "true";
                }
                FcOption fcOption = new FcOption(inputValue, "isRemoveAllGroup", false);
                inputsList.add(fcOption);
                if (!inputValue.equals("true")) {
                    Hashtable removeFromGroupSidVsNameMap = (Hashtable)props.get("removeFromGroupSidVsNameMap");
                    String groupSid = "";
                    if (removeFromGroupSidVsNameMap != null && removeFromGroupSidVsNameMap.size() > 0) {
                        Enumeration groupMapKeys = removeFromGroupSidVsNameMap.keys();
                        while (groupMapKeys.hasMoreElements()) {
                            groupSid = (String)groupMapKeys.nextElement();
                            inputsList.add(new FcOption(groupSid, (String)removeFromGroupSidVsNameMap.get(groupSid), false));
                        }
                    }
                }
                flag = true;
            } else if (requestAction.equals(6L)) {
                String isPasswordNeverExpires;
                String isCantChangePassword;
                inputName = "Password";
                inputValue = (String)bean.get("passwordType");
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "Password");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList();
                inputMap.put("multiInputValuesList", inputsList);
                FcOption fcOption = new FcOption();
                if (inputValue.equals("ownPassword")) {
                    FcOption fcOption2 = new FcOption();
                    fcOption2.setLabel("Password");
                    fcOption2.setValue((String)bean.get("newPassword"));
                    inputsList.add(fcOption2);
                }
                FcOption fcOption3 = new FcOption();
                fcOption3.setLabel("PasswordType");
                fcOption3.setValue(inputValue);
                inputsList.add(fcOption3);
                String isMustChangePwd = request.getParameter("isMuchChangePwdAtNextLogon");
                if (isMustChangePwd != null) {
                    FcOption fcOption4 = new FcOption();
                    fcOption4.setLabel("UserMustChangePwd");
                    fcOption4.setValue(isMustChangePwd);
                    inputsList.add(fcOption4);
                }
                if ((isCantChangePassword = request.getParameter("isCantChangePwd")) != null) {
                    FcOption fcOption5 = new FcOption();
                    fcOption5.setLabel("CantChangePwd");
                    fcOption5.setValue(isCantChangePassword);
                    inputsList.add(fcOption5);
                }
                if ((isPasswordNeverExpires = request.getParameter("isPwdNeverExpires")) != null) {
                    FcOption fcOption6 = new FcOption();
                    fcOption6.setLabel("PwdNeverExpires");
                    fcOption6.setValue(isPasswordNeverExpires);
                    inputsList.add(fcOption6);
                }
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(18L)) {
                inputName = "IsSendAutoReply";
                inputValue = (String)bean.get("sendAutoReply");
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "IsSendAutoReply");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList();
                inputMap.put("multiInputValuesList", inputsList);
                FcOption fcOption = new FcOption();
                fcOption.setLabel("IsSendAutoReply");
                fcOption.setValue(inputValue);
                inputsList.add(fcOption);
                FcOption fcOption7 = new FcOption();
                fcOption7.setLabel("IsSendOutsideMsg");
                fcOption7.setValue((String)bean.get("sendOutsideMsg"));
                inputsList.add(fcOption7);
                FcOption fcOption8 = new FcOption();
                fcOption8.setLabel("InsideMessage");
                fcOption8.setValue((String)bean.get("insideMsg"));
                inputsList.add(fcOption8);
                if (((String)bean.get("sendOutsideMsg")).equals("true")) {
                    FcOption fcOption9 = new FcOption();
                    fcOption9.setLabel("OutsideMessage");
                    fcOption9.setValue((String)bean.get("outsideMsg"));
                    inputsList.add(fcOption9);
                }
                FcOption fcOption10 = new FcOption();
                fcOption10.setLabel("IsAutoReplyTimeBased");
                fcOption10.setValue((String)bean.get("isTimeBased"));
                inputsList.add(fcOption10);
                if (((String)bean.get("isTimeBased")).equals("true")) {
                    FcOption fcOption11 = new FcOption();
                    fcOption11.setLabel("ReplyStartDate");
                    fcOption11.setValue((String)bean.get("replyStartDate"));
                    inputsList.add(fcOption11);
                    FcOption fcOption12 = new FcOption();
                    fcOption12.setLabel("ReplyEndDate");
                    fcOption12.setValue((String)bean.get("replyEndDate"));
                    inputsList.add(fcOption12);
                    FcOption fcOption13 = new FcOption();
                    fcOption13.setLabel("StartHr");
                    fcOption13.setValue((String)bean.get("startHr"));
                    inputsList.add(fcOption13);
                    FcOption fcOption14 = new FcOption();
                    fcOption14.setLabel("StartMin");
                    fcOption14.setValue((String)bean.get("startMin"));
                    inputsList.add(fcOption14);
                    FcOption fcOption15 = new FcOption();
                    fcOption15.setLabel("EndHr");
                    fcOption15.setValue((String)bean.get("endHr"));
                    inputsList.add(fcOption15);
                    FcOption fcOption16 = new FcOption();
                    fcOption16.setLabel("EndMin");
                    fcOption16.setValue((String)bean.get("endMin"));
                    inputsList.add(fcOption16);
                }
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(10L) || requestAction.equals(37L)) {
                inputName = "CustomScript";
                inputValue = (String)bean.get("customScriptVal");
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "CustomScript");
                inputMap.put("VALUE", inputValue);
                inputMap.put("ISMULTIPLE", false);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(11L)) {
                System.out.println("AAA" + (String)bean.get("disableDeleteMailbox"));
                inputName = "DisableDeleteMailbox";
                inputValue = (String)bean.get("disableDeleteMailbox");
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "DisableDeleteMailbox");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList();
                inputMap.put("multiInputValuesList", inputsList);
                FcOption fcOption = new FcOption();
                fcOption.setLabel("DisableDeleteMailbox");
                fcOption.setValue(inputValue);
                inputsList.add(fcOption);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(15L)) {
                inputName = "MoveHomeFolder";
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "MoveHomeFolder");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList();
                inputMap.put("multiInputValuesList", inputsList);
                FcOption fcOption = new FcOption();
                fcOption.setLabel("drive");
                fcOption.setValue((String)bean.get("homeDrive"));
                inputsList.add(fcOption);
                FcOption fcOption17 = new FcOption();
                fcOption17.setLabel("path");
                fcOption17.setValue((String)bean.get("homeDirectoryPath"));
                inputsList.add(fcOption17);
                FcOption fcOption18 = new FcOption();
                fcOption18.setLabel("retain");
                fcOption18.setValue(inputValue);
                inputsList.add(fcOption18);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(13L)) {
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "CreateMailBox");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList();
                inputMap.put("multiInputValuesList", inputsList);
                FcOption fcOption = new FcOption();
                fcOption.setLabel("mailFormat");
                fcOption.setValue((String)bean.get("mail_alias_format_sel1"));
                inputsList.add(fcOption);
                FcOption fcOption19 = new FcOption();
                fcOption19.setLabel("serverName");
                fcOption19.setValue((String)bean.get("ServerNameValues1"));
                inputsList.add(fcOption19);
                FcOption fcOption20 = new FcOption();
                fcOption20.setLabel("mailBoxStore");
                fcOption20.setValue((String)bean.get("MailBoxStores1"));
                inputsList.add(fcOption20);
                FcOption fcOption21 = new FcOption();
                fcOption21.setLabel("mailFormatValue");
                fcOption21.setValue((String)bean.get("mail_alias_format_sel"));
                inputsList.add(fcOption21);
                FcOption fcOption22 = new FcOption();
                fcOption22.setLabel("serverNameValue");
                fcOption22.setValue((String)bean.get("ServerNameValues"));
                inputsList.add(fcOption22);
                FcOption fcOption23 = new FcOption();
                fcOption23.setLabel("mailBoxStoresValue");
                fcOption23.setValue((String)bean.get("MailBoxStores"));
                inputsList.add(fcOption23);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(14L)) {
                inputName = "ManageuserPhotos";
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "ManageuserPhotos");
                inputMap.put("ISMULTIPLE", true);
                inputsList = new ArrayList();
                inputMap.put("multiInputValuesList", inputsList);
                FcOption fcOption = new FcOption();
                fcOption.setLabel("folderpath");
                fcOption.setValue((String)bean.get("importPhotoSharePath"));
                inputsList.add(fcOption);
                FcOption fcOption24 = new FcOption();
                fcOption24.setLabel("format");
                fcOption24.setValue((String)bean.get("formatDisplay"));
                inputsList.add(fcOption24);
                FcOption fcOption25 = new FcOption();
                fcOption25.setLabel("attributeName");
                fcOption25.setValue((String)bean.get("attribName"));
                inputsList.add(fcOption25);
                FcOption fcOption26 = new FcOption();
                fcOption26.setLabel("uniqueOperationId");
                fcOption26.setValue((String)bean.get("uniqueOperationId"));
                inputsList.add(fcOption26);
                FcOption fcOption27 = new FcOption();
                fcOption27.setLabel("hostId");
                fcOption27.setValue(request.getRemoteHost());
                inputsList.add(fcOption27);
                FcOption fcOption28 = new FcOption();
                String domainName = (String)bean.get("domains");
                domainName = DomainUtil.getDomainName((String)domainName);
                String photoFolderName = ModifyPhotoListener.getPhotoFolder(request, domainName, (String)bean.get("attribName"));
                fcOption28.setLabel("photoFolderName");
                fcOption28.setValue(photoFolderName);
                inputsList.add(fcOption28);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(WorkFlowUtil.HIDE_EXCHANGE_ADDR_LIST_ACTION_ID)) {
                inputName = "hideFromAddrList";
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "hideFromAddrList");
                inputMap.put("VALUE", inputValue);
                inputMap.put("ISMULTIPLE", false);
                multipleInputs.add(inputMap);
                flag = true;
            } else if (requestAction.equals(WorkFlowUtil.CREATE_GROUP_ACTION_ID) || requestAction.equals(WorkFlowUtil.CREATE_CONTACT_ACTION_ID) || requestAction.equals(WorkFlowUtil.CREATE_USER_ACTION_ID) || requestAction.equals(WorkFlowUtil.MODIFY_USER_ACTION_ID)) {
                inputName = "template";
                inputValue = (String)bean.get("template");
                inputsList = new ArrayList();
                flag = true;
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "template");
                inputMap.put("VALUE", inputValue);
                inputMap.put("ISMULTIPLE", false);
                multipleInputs.add(inputMap);
                String string = request.getParameter("dbConfigId");
                String dataSourceType3 = (String)bean.get("dataSourceType");
                if (dataSourceType3 != null && dataSourceType3.equalsIgnoreCase("csv")) {
                    String csvLoc = (String)bean.get("csvLocation");
                    if (!csvLoc.isEmpty()) {
                        inputMap = new HashMap();
                        inputMap.put("VARIABLE", "dataSourceType");
                        inputMap.put("VALUE", "csv");
                        inputMap.put("ISMULTIPLE", false);
                        multipleInputs.add(inputMap);
                        inputMap = new HashMap();
                        inputMap.put("VARIABLE", "csvLocation");
                        inputMap.put("VALUE", csvLoc);
                        inputMap.put("ISMULTIPLE", false);
                        multipleInputs.add(inputMap);
                    }
                } else if (dataSourceType3 != null) {
                    inputMap = new HashMap();
                    inputMap.put("VARIABLE", "dataSourceType");
                    inputMap.put("VALUE", dataSourceType3);
                    inputMap.put("ISMULTIPLE", false);
                    multipleInputs.add(inputMap);
                    inputMap = new HashMap();
                    inputMap.put("VARIABLE", "dbConfigId");
                    inputMap.put("VALUE", request.getParameter("dbConfigId"));
                    inputMap.put("ISMULTIPLE", false);
                    multipleInputs.add(inputMap);
                    String isAddCurrentRecords = request.getParameter("isAddCurrentRecords");
                    if (!isAddCurrentRecords.isEmpty()) {
                        inputMap = new HashMap();
                        inputMap.put("VARIABLE", "isAddCurrentRecords");
                        inputMap.put("VALUE", isAddCurrentRecords);
                        inputMap.put("ISMULTIPLE", false);
                        multipleInputs.add(inputMap);
                    }
                    if (request.getParameter("integAdvncCriteriadetails") != null) {
                        automationId = Long.getLong(mgmtActionRow.get("AUTOMATION_ID").toString());
                        integAdvncCriteriaId = AutomationUtil.saveIntegAdvncDetails((Long)scheduleId, (JSONObject)new JSONObject(request.getParameter("integAdvncCriteriadetails")), (DataObject)dataObj);
                        inputMap = new HashMap();
                        inputMap.put("VARIABLE", "integAdvncCriteriaId");
                        inputMap.put("VALUE", integAdvncCriteriaId);
                        inputMap.put("ISMULTIPLE", false);
                        multipleInputs.add(inputMap);
                    }
                }
            } else if (requestAction.equals(WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID)) {
                inputDetails = null;
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "modifyUserAttributes");
                inputMap.put("ISMULTIPLE", true);
                ArrayList<FcOption> arrayList = new ArrayList<FcOption>();
                inputMap.put("multiInputValuesList", arrayList);
                String modifyUserAttribInputs = request.getParameter("modifyUserAttribInputs");
                if (modifyUserAttribInputs == null || modifyUserAttribInputs != null && modifyUserAttribInputs.equals("")) {
                    out.log(Level.INFO, "ModifyUserAttibute action's input not selected from UI. So get the details from imported csv files");
                    inputDetails = new JSONObject();
                } else {
                    out.log(Level.INFO, "ModifyUserAttibute action's input details selected from UI.");
                    inputDetails = new JSONObject(modifyUserAttribInputs);
                }
                flag = true;
                Iterator inputKeys = inputDetails.keys();
                while (inputKeys.hasNext()) {
                    String key = (String)inputKeys.next();
                    arrayList.add(new FcOption(inputDetails.getString(key), key, false));
                }
                FcOption fcOption = new FcOption();
                fcOption.setLabel("dataSourceType");
                fcOption.setValue((String)bean.get("dataSourceType"));
                arrayList.add(fcOption);
                if (!bean.get("dataSourceType").toString().equalsIgnoreCase("CSV")) {
                    fcOption = new FcOption();
                    fcOption.setLabel("dbConfigId");
                    fcOption.setValue((String)bean.get("dbConfigId"));
                    arrayList.add(fcOption);
                    if (bean.get("integAdvncCriteriaId") != null) {
                        Long automationId2 = Long.getLong(mgmtActionRow.get("AUTOMATION_ID").toString());
                        Long integAdvncCriteriaId2 = AutomationUtil.saveIntegAdvncDetails((Long)scheduleId, (JSONObject)new JSONObject(request.getParameter("integAdvncCriteriadetails")), (DataObject)dataObj);
                        fcOption = new FcOption();
                        fcOption.setLabel("integAdvncCriteriaId");
                        fcOption.setValue(integAdvncCriteriaId2.toString());
                        arrayList.add(fcOption);
                    }
                    fcOption = new FcOption();
                    fcOption.setLabel("isAddCurrentRecords");
                    fcOption.setValue((String)bean.get("isAddCurrentRecords"));
                    arrayList.add(fcOption);
                }
                multipleInputs.add(inputMap);
            } else if (requestAction.equals(WorkFlowUtil.REMOVE_O365_LICENSES_ID)) {
                String domainName = (String)bean.get("domains");
                domainName = DomainUtil.getDomainName((String)domainName);
                inputMap = new HashMap();
                inputMap.put("VARIABLE", "o365LicenseDetails");
                inputMap.put("ISMULTIPLE", true);
                ArrayList<FcOption> arrayList = new ArrayList<FcOption>();
                arrayList.add(new FcOption(domainName, "domain", false));
                arrayList.add(new FcOption((String)bean.get("isRemoveAllO365License"), "isRemoveAllO365License", false));
                arrayList.add(new FcOption((String)bean.get("selectedO365Licenses"), "selectedO365Licenses", false));
                inputMap.put("multiInputValuesList", arrayList);
                multipleInputs.add(inputMap);
                flag = true;
            }
            if ((requestAction.equals(WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID) || requestAction.equals(WorkFlowUtil.DELETE_USER_ACTION_ID) || requestAction.equals(WorkFlowUtil.CREATE_USER_ACTION_ID)) && (dataSourceType = bean.get("dataSourceType").toString()) != null && !dataSourceType.equalsIgnoreCase("CSV") && !dataSourceType.isEmpty()) {
                Integer n = Integer.parseInt(bean.get("dbConfigId").toString());
                boolean checkAddRecords = false;
                Criteria criteria = new Criteria(Column.getColumn((String)"TPIntegrationScheduleMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject mappingDo = CommonUtil.getPersistence((boolean[])new boolean[0]).get("TPIntegrationScheduleMapping", criteria);
                Row mappingRow = mappingDo.getRow("TPIntegrationScheduleMapping");
                if (mappingRow == null) {
                    Row row = new Row("TPIntegrationScheduleMapping");
                    row.set("CONFIG_ID", (Object)n);
                    row.set("SCHEDULE_ID", (Object)scheduleId);
                    if (dataSourceType.equalsIgnoreCase("mssql") || dataSourceType.equalsIgnoreCase("oracle")) {
                        row.set("CONFIG_TYPE", (Object)"DB");
                    } else {
                        row.set("CONFIG_TYPE", (Object)dataSourceType);
                    }
                    mappingDo.addRow(row);
                    CommonUtil.getPersistence((boolean[])new boolean[0]).update(mappingDo);
                    checkAddRecords = true;
                } else {
                    Integer oldConfigId = (Integer)mappingRow.get("CONFIG_ID");
                    if (n.intValue() != oldConfigId.intValue()) {
                        mappingRow.set("CONFIG_ID", (Object)n);
                        mappingDo.updateRow(mappingRow);
                        CommonUtil.getPersistence((boolean[])new boolean[0]).update(mappingDo);
                        checkAddRecords = MetaDataUtil.getTableDefinitionByName((String)DBDataSourceUtil.getLocalTableName(n, scheduleId)) == null;
                    }
                }
                String isAddCurrentRecords = (String)bean.get("isAddCurrentRecords");
                if (requestAction.equals(3L)) {
                    isAddCurrentRecords = "true";
                }
                final int confId = n;
                final Long schId = scheduleId;
                final HttpServletRequest req = request;
                DataObject dataObject = dataObj;
                Row r = dataObject.getRow("ADSMAutomation");
                final Long loginId = (Long)r.get("CREATED_BY");
                Long action = requestAction;
                final String configType = request.getParameter("dataSourceType");
                final String domainName = DomainUtil.getDomainName((String)((String)bean.get("domains")));
                Long integAdvncCriteriaId3 = (Long)bean.get("integAdvncCriteriaId");
                if (checkAddRecords && isAddCurrentRecords != null && isAddCurrentRecords.equalsIgnoreCase("true")) {
                    new Thread(){

                        /*
                         * WARNING - Removed try catching itself - possible behaviour change.
                         * Enabled aggressive block sorting
                         * Enabled unnecessary exception pruning
                         * Enabled aggressive exception aggregation
                         * Converted monitor instructions to comments
                         * Lifted jumps to return sites
                         */
                        @Override
                        public void run() {
                            try {
                                InputDataSource dataSource;
                                Class clazz;
                                if (configType.equalsIgnoreCase("workday")) {
                                    clazz = DBInputDataSource.class;
                                    // MONITORENTER : com.adventnet.sym.adsm.common.webclient.integration.DBInputDataSource.class
                                    dataSource = new WorkdayInputDataSource(0, schId);
                                    ((WorkdayInputDataSource)dataSource).setDomainName(domainName);
                                    ((WorkdayInputDataSource)dataSource).addCurrentRecordsToDB();
                                    // MONITOREXIT : clazz
                                } else if (configType.equalsIgnoreCase("zPeople")) {
                                    clazz = ZPeopleInputDataSource.class;
                                    // MONITORENTER : com.adventnet.sym.adsm.common.webclient.integration.ZPeopleInputDataSource.class
                                    dataSource = new ZPeopleInputDataSource(0, schId);
                                    ((ZPeopleInputDataSource)dataSource).setDomainName(domainName);
                                    ((ZPeopleInputDataSource)dataSource).addCurrentRecordsToDB();
                                    // MONITOREXIT : clazz
                                } else {
                                    clazz = DBInputDataSource.class;
                                    // MONITORENTER : com.adventnet.sym.adsm.common.webclient.integration.DBInputDataSource.class
                                    dataSource = DBInputDataSource.getInstance(confId, schId);
                                    ((DBInputDataSource)dataSource).addCurrentRecordsToDB();
                                    // MONITOREXIT : clazz
                                }
                                if (req.getParameter("Run_Now") != null && req.getParameter("Run_Now").equals("true")) {
                                    out.log(Level.INFO, "Run Now options selected.");
                                    Long taskInstanceId = SchedulerUtil.getTaskInstanceId((Long)schId);
                                    Long taskId = SchedulerUtil.getTaskID((String)"MgmtAutomation");
                                    out.log(Level.INFO, "Going the run the scheduler for the instance " + taskInstanceId);
                                    if (taskInstanceId != null) {
                                        SchedulerExecution task = new SchedulerExecution(taskInstanceId, taskId);
                                        task.start();
                                    }
                                }
                                SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
                                runNowObj.updateScheduleStatus(loginId, schId, "COMPLETED", "", "");
                                return;
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                        }
                    }.start();
                }
            }
        }
        if (flag) {
            for (HashMap hashMap : multipleInputs) {
                Object inputVariabletName = hashMap.get("VARIABLE");
                Object value = hashMap.get("VALUE");
                boolean isMultiple = (Boolean)hashMap.get("ISMULTIPLE");
                if (!isMultiple) {
                    if (inputName == null || inputValue == null) continue;
                    Row reqActionInputDetailsRow = new Row("AutoReqActionInputDetails");
                    reqActionInputDetailsRow.set("VARIABLE_NAME", inputVariabletName);
                    reqActionInputDetailsRow.set("VALUE", value);
                    reqActionInputDetailsRow.set("AUTO_REQACTION_DETAILS_ID", (Object)reqActionDetailsId);
                    dataObj.addRow(reqActionInputDetailsRow);
                    continue;
                }
                ArrayList inputsList = (ArrayList)hashMap.get("multiInputValuesList");
                Row reqActionInputDetailsRow = new Row("AutoReqActionInputDetails");
                reqActionInputDetailsRow.set("VARIABLE_NAME", inputVariabletName);
                reqActionInputDetailsRow.set("IS_MULTIPLE_VALUE", (Object)isMultiple);
                reqActionInputDetailsRow.set("AUTO_REQACTION_DETAILS_ID", (Object)reqActionDetailsId);
                dataObj.addRow(reqActionInputDetailsRow);
                DataAccess.generateValues((Row)reqActionInputDetailsRow);
                Long singleInputId = (Long)reqActionInputDetailsRow.get("ACTION_SINGLE_INPUT_ID");
                for (FcOption fcOption : inputsList) {
                    Row reqActionMultiInputDetailsRow = new Row("AutoReqActionMultiInputDetails");
                    reqActionMultiInputDetailsRow.set("CLIENT_VALUE", (Object)fcOption.getValue());
                    reqActionMultiInputDetailsRow.set("SERVER_VALUE", (Object)fcOption.getLabel());
                    reqActionMultiInputDetailsRow.set("ACTION_SINGLE_INPUT_ID", (Object)singleInputId);
                    dataObj.addRow(reqActionMultiInputDetailsRow);
                }
            }
        }
        if (request.getParameter("isAddCurrentRecords") != null && request.getParameter("isAddCurrentRecords").equalsIgnoreCase("false") && !requestAction.equals(WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID) && !requestAction.equals(WorkFlowUtil.CREATE_USER_ACTION_ID) && !requestAction.equals(WorkFlowUtil.DELETE_USER_ACTION_ID)) {
            Long schId = scheduleId;
            DataObject dataObject = dataObj;
            Row r = dataObject.getRow("ADSMAutomation");
            Long loginId = (Long)r.get("CREATED_BY");
            SchedulerRunNowObject runNowObj = SchedulerRunNowObject.getInstanceForAutomation();
            runNowObj.updateScheduleStatus(loginId, schId, "COMPLETED", "", "");
        }
    }

    public static void csvImport(String fileName, ArrayList<Hashtable> attributeList, ArrayList customAttributeList, AdventNetResourceBundle rb) throws Exception {
        ArrayList userDetailsList = new ArrayList();
        AddUserRequestHandler.importCSVs((String)fileName, attributeList, userDetailsList, (ArrayList)customAttributeList, (AdventNetResourceBundle)rb);
    }
}

