/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.persistence.DataObject;
import com.adventnet.sym.adsm.common.server.CategoryHandler;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.popup.datamodel.PopupTableDataModel;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.server.workflow.WorkflowConfigDataCacheUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class WFModificationRequestAction
extends DispatchAction {
    public ActionForward getWorkFlowActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        String domainName = "";
        if (json.has("domainName")) {
            domainName = (String)json.get("domainName");
        }
        Integer catagoryId = (Integer)json.get("catagoryId");
        Long requestAction = new Long((String)json.get("requestAction"));
        Integer reportId = WorkFlowUtil.WF_CREATEREQUEST_REPORTID[catagoryId];
        ArrayList workFlowMenus = CategoryHandler.getWorkFlowMenus((Integer)reportId, (String)domainName, (Long)loginId);
        request.setAttribute("workFlowMenus", (Object)workFlowMenus);
        request.setAttribute("requestAction", (Object)requestAction);
        request.setAttribute("domainName", (Object)domainName);
        request.setAttribute("reportId", (Object)reportId);
        request.setAttribute("catagoryId", (Object)catagoryId);
        return mapping.findForward("showList");
    }

    public ActionForward showModifyRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        String tile = "modify";
        try {
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Integer catagoryId = Integer.parseInt(request.getParameter("catagoryId"));
            if (catagoryId == 5) {
                tile = "modifyPermission";
            }
            Integer subCategory = catagoryId;
            ArrayList subCategoryList = WorkFlowUtil.getRequestSubCategoryDetails();
            for (HashMap subCategoryHash : subCategoryList) {
                Integer catId = (Integer)subCategoryHash.get("CATEGORY");
                if (!catId.equals(catagoryId)) continue;
                subCategory = (Integer)subCategoryHash.get("SUB_CATEGORY");
                break;
            }
            String domainName = null;
            Long requestAction = 0L;
            if (request.getParameter("requestId") != null) {
                requestAction = Long.parseLong(request.getParameter("requestId"));
            }
            Integer reportId = WorkFlowUtil.WF_CREATEREQUEST_REPORTID[catagoryId];
            Hashtable requestorRolesAndActions = WorkFlowUserHandler.getRequestorRoles((Long)loginId);
            ArrayList domainList = WorkFlowUserHandler.getAuthorizedDomainListForCatagory((Long)loginId, (Integer)subCategory);
            if (domainList.isEmpty() && WorkFlowUserHandler.isRequesterMigrated((Long)loginId).booleanValue()) {
                ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
                Hashtable domainsHash = HDTDomainHandler.getDomainsAndOUs((Long)loginId);
                domainList = (ArrayList)domainsHash.get("domainList");
            }
            ArrayList priorityList = WorkflowConfigDataCacheUtil.getRequestPriorityList();
            if (domainName == "" || domainName == null) {
                Properties prop = (Properties)domainList.get(0);
                domainName = prop.getProperty("DOMAIN_NAME");
            }
            ArrayList rangeList = NavigateRangeUtil.getRangeListForModule((String)"BulkModification");
            request.setAttribute("domainName", domainName);
            request.setAttribute("rangeList", (Object)rangeList);
            request.setAttribute("priorityList", (Object)priorityList);
            request.setAttribute("reportId", (Object)reportId);
            request.setAttribute("catagoryId", (Object)catagoryId);
            request.setAttribute("requestAction", (Object)requestAction);
            request.setAttribute("requestorRolesAndActions", (Object)requestorRolesAndActions);
            request.setAttribute("domainList", (Object)domainList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(tile);
    }

    public ActionForward showResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        Integer catagoryId = json.getInt("catagoryId");
        String moduleName = WorkFlowUtil.WF_REQUEST_MODULE_NAME[catagoryId];
        if (!json.getString("requestAction").equals("") && Long.valueOf(json.getLong("requestAction")) == WorkFlowUtil.REMOVE_O365_LICENSES_ID) {
            moduleName = "O365UserSelection";
        }
        Long cvId = ColumnConfiguration.getDefaultCvId((String)moduleName);
        ArrayList columnList = ColumnConfiguration.getViewColumnList((long)cvId);
        HashMap columnProp = (HashMap)columnList.get(0);
        String tableName = (String)columnProp.get("TABLE_NAME");
        PopupTableDataModel popupTableModel = new PopupTableDataModel();
        ArrayList totalColumn = ColumnConfiguration.getTotalColumnList((long)cvId);
        for (int k = 0; k < totalColumn.size(); ++k) {
            Boolean isUniqueDisplayColumn;
            HashMap map = (HashMap)totalColumn.get(k);
            Boolean isUniqueColumn = (Boolean)map.get("IS_UNIQUE_VALUE_COLUMN");
            if (isUniqueColumn.booleanValue()) {
                popupTableModel.setUniqueColumnMap(map);
            }
            if (!(isUniqueDisplayColumn = (Boolean)map.get("IS_UNIQUE_DISPLAY_COLUMN")).booleanValue()) continue;
            popupTableModel.setUniqueDisplayColumnMap(map);
        }
        DataObject dataObj = WorkFlowClientUtil.getResultList(params, loginId, columnList, request);
        popupTableModel.setUniqueIdAndValueInTableDataWithDO(dataObj, tableName);
        popupTableModel.setColumnList(columnList);
        request.setAttribute("DropDownResultDataModel", (Object)popupTableModel);
        return mapping.findForward("showListInDropDown");
    }

    public ActionForward createModifyRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String guidList = request.getParameter("guidList");
        String params = request.getParameter("params");
        JSONObject paramsJSON = new JSONObject(params);
        JSONObject guidJSON = new JSONObject(guidList);
        Integer catagoryId = paramsJSON.getInt("catagoryId");
        Integer reportId = WorkFlowUtil.WF_CREATEREQUEST_REPORTID[catagoryId];
        ArrayList<String> sidList = new ArrayList<String>();
        Iterator itr = guidJSON.keys();
        while (itr.hasNext()) {
            sidList.add((String)itr.next());
        }
        WorkFlowClientUtil.createRequest(request, paramsJSON, sidList, reportId);
        return mapping.findForward("success");
    }

    public ActionForward getTaskSetFieldComponent(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String fieldDetailsStr = request.getParameter("fieldDetailsStr");
        Long adTaskDetailsId = new Long(request.getParameter("adTaskDetailsId"));
        String domainName = request.getParameter("domainName");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Integer reportId = null;
        if (request.getParameter("reportId") != null) {
            reportId = Integer.parseInt(request.getParameter("reportId"));
        }
        Boolean showDomain = false;
        if (request.getParameter("showDomain") != null) {
            showDomain = Boolean.parseBoolean(request.getParameter("showDomain"));
        }
        try {
            JSONObject fieldDetailsJsonObj = new JSONObject(fieldDetailsStr);
            if (fieldDetailsJsonObj.length() > 0) {
                fieldDetailsJsonObj.put("isWorkFlowMode", true);
                HttpSession session = request.getSession();
                Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
                JSONObject componentDetailsObj = AutomationUtil.getComponentDetails((JSONObject)fieldDetailsJsonObj, (String)domainName, (Long)loginId, (AdventNetResourceBundle)rb);
                request.setAttribute("componentDetails", (Object)componentDetailsObj);
                request.setAttribute("adTaskDetailsId", (Object)adTaskDetailsId);
                request.setAttribute("defaultComponentId", (Object)fieldDetailsJsonObj.getLong("componentId"));
                request.setAttribute("domainName", (Object)domainName);
                request.setAttribute("reportId", (Object)reportId);
                request.setAttribute("showDomain", (Object)showDomain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("taskInput");
    }

    public ActionForward getDistinguishName(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String guid = request.getParameter("params");
        String DN = OUUtil.getOUDNFromGUID((String)guid);
        JSONObject json = new JSONObject();
        json.put("DN", (Object)DN);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(json.toString());
        return null;
    }

    public ActionForward getObjectGuid(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String dn = request.getParameter("dn");
        String domainName = request.getParameter("domainName");
        Properties prop = null;
        Enumeration<Object> enumeration = prop.keys();
        JSONObject json = new JSONObject();
        JSONArray jsonArray = new JSONArray();
        try {
            while (enumeration.hasMoreElements()) {
                json = new JSONObject();
                String key = (String)enumeration.nextElement();
                json.put("key", (Object)key);
                json.put("value", (Object)key);
                jsonArray.put((Object)json);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        json = new JSONObject();
        json.put("guidProp", (Object)jsonArray);
        response.setContentType("application/json");
        PrintWriter writer = response.getWriter();
        writer.print(json.toString());
        return null;
    }
}

