/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.AdmpInput;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationMacro;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplate;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTemplateHandler;
import com.adventnet.sym.adsm.common.server.admin.notification.NotificationTrigger;
import com.adventnet.sym.adsm.common.server.automation.AutomationNotificationMacro;
import com.adventnet.sym.adsm.common.server.automation.AutomationUtil;
import com.adventnet.sym.adsm.common.server.customview.ColumnConfiguration;
import com.adventnet.sym.adsm.common.server.customview.NavigateRangeUtil;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.layout.FcExecuteActionConstants;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutBulkViewHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutUpdateHandler;
import com.adventnet.sym.adsm.common.server.layout.FcLayoutViewHandler;
import com.adventnet.sym.adsm.common.server.layout.component.FcOption;
import com.adventnet.sym.adsm.common.server.pushnotification.PushNotificationTrigger;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.ReportAttributesUtil;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflow;
import com.adventnet.sym.adsm.common.server.workflow.BusinessWorkflowRule;
import com.adventnet.sym.adsm.common.server.workflow.WFAssignToRule;
import com.adventnet.sym.adsm.common.server.workflow.WFAssigningRuleUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFAttributeHandler;
import com.adventnet.sym.adsm.common.server.workflow.WFNotificationMacro;
import com.adventnet.sym.adsm.common.server.workflow.WFRequestUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleConstants;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleExecutor;
import com.adventnet.sym.adsm.common.server.workflow.WFRuleHandler;
import com.adventnet.sym.adsm.common.server.workflow.WFTask;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskAuditActivities;
import com.adventnet.sym.adsm.common.server.workflow.WFTaskSet;
import com.adventnet.sym.adsm.common.server.workflow.WFViewRequest;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlow;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowCommit;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormAction;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormBean;
import com.adventnet.sym.adsm.common.webclient.layout.FcBulkExecuteFormFlow;
import com.adventnet.sym.adsm.common.webclient.reports.ReportResultUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.workflow.AdditionalExecutionActions;
import com.adventnet.sym.adsm.common.webclient.workflow.WorkFlowClientUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.io.File;
import java.io.PrintWriter;
import java.io.Serializable;
import java.net.URLDecoder;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class WorkFlowAction
extends DispatchAction {
    private static Logger out = Logger.getLogger("WFLogger");
    public static final Integer[] htmlEscapeAttributeIs = new Integer[]{1021, 3014};
    public static final Long[] htmlEscapeRequestActionIds = new Long[]{8L, 9L, 10L, 35L};

    public ActionForward customizeColumns(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "WFAddRemoveColumn";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ArrayList viewList = WFAttributeHandler.getInstance().getListReqDefaultColumnList(loginId);
            ArrayList nonVisibleList = WFAttributeHandler.getInstance().getListReqEditColumnList(viewList);
            request.setAttribute("ColumnList", (Object)viewList);
            request.setAttribute("EditList", (Object)nonVisibleList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward viewBusinessRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        return mapping.findForward("BusinessRuleResult");
    }

    public ActionForward showBusinessRuleRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long cvId = ColumnConfiguration.getDefaultCvId((String)"WFBUSINESSRULE");
        ArrayList columnList = ColumnConfiguration.getTotalColumnList((long)cvId);
        String[] searchColumns = new String[]{"BUSINESS_RULE_NAME", "BUSINESS_RULE_DESC"};
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        String params = request.getParameter("params");
        JSONObject jsonObject = new JSONObject(params);
        JSONObject pageNavigation = jsonObject.getJSONObject("pageNavigation");
        String searchText = URLDecoder.decode(jsonObject.getString("searchText"), "UTF-8").replace("\\", "\\\\");
        jsonObject.put("searchText", (Object)searchText);
        int range = pageNavigation.getInt("range");
        boolean isNavigate = pageNavigation.getBoolean("isNavigate");
        if (!isNavigate) {
            NavigateRangeUtil.setDefaultRange((String)"WFBusinessRule", (int)range, (Long)loginId);
        }
        Integer count = WFRuleHandler.getWFBusinessRulesCount((String)searchText, (String[])searchColumns);
        LinkedHashMap rulesList = WFRuleHandler.getWFBusinessRulesList((JSONObject)jsonObject, (ArrayList)columnList, (String[])searchColumns, (AdventNetResourceBundle)rb);
        request.setAttribute("count", (Object)count);
        request.setAttribute("columnList", (Object)ColumnConfiguration.getViewColumnList((long)cvId));
        request.setAttribute("rulesList", (Object)rulesList);
        return mapping.findForward("BusinessRuleResultRows");
    }

    public ActionForward editBusinessRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long ruleId = new Long(request.getParameter("BUSINESS_RULE_ID"));
        Hashtable businessRuleHash = WorkFlowUtil.getBusinessRule((Long)ruleId);
        request.setAttribute("BUSINESS_RULE_ID", (Object)ruleId);
        request.setAttribute("BUSINESS_RULE_NAME", businessRuleHash.get("BUSINESS_RULE_NAME"));
        request.setAttribute("BUSINESS_RULE_DESC", businessRuleHash.get("BUSINESS_RULE_DESC"));
        request.setAttribute("REQUESTER", businessRuleHash.get("REQUESTER"));
        request.setAttribute("REVIEWER", businessRuleHash.get("REVIEWER"));
        request.setAttribute("APPROVER", businessRuleHash.get("APPROVER"));
        request.setAttribute("EXECUTER", businessRuleHash.get("EXECUTER"));
        return mapping.findForward("AddBusinessRule");
    }

    public ActionForward addBusinessRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        request.setAttribute("BUSINESS_RULE_ID", (Object)0L);
        request.setAttribute("BUSINESS_RULE_NAME", (Object)"");
        request.setAttribute("BUSINESS_RULE_DESC", (Object)"");
        request.setAttribute("REQUESTER", (Object)1L);
        request.setAttribute("REVIEWER", (Object)1L);
        request.setAttribute("APPROVER", (Object)1L);
        request.setAttribute("EXECUTER", (Object)1L);
        return mapping.findForward("AddBusinessRule");
    }

    public ActionForward saveOrUpdateBusinessRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long ruleId = new Long(request.getParameter("BUSINESS_RULE_ID"));
        String ruleName = request.getParameter("BUSINESS_RULE_NAME");
        PrintWriter writer = response.getWriter();
        if (!WorkFlowUtil.isBusinessRuleNameAvailable((String)ruleName, (Long)ruleId).booleanValue()) {
            writer.print(false);
            return null;
        }
        String ruleDesc = request.getParameter("BUSINESS_RULE_DESC");
        Long reviewerCount = new Long(request.getParameter("REVIEWER"));
        Long approverCount = new Long(request.getParameter("APPROVER"));
        Long executerCount = new Long(request.getParameter("EXECUTER"));
        String message = rb.getString("admp.workflow.businessworkflow.message_updated_status_success");
        Boolean isSuccess = true;
        if (ruleId.equals(0L)) {
            message = rb.getString("admp.workflow.businessworkflow.message_added_status_success");
        }
        try {
            WFRuleHandler.saveOrUpdateBusinessRule((Long)ruleId, (String)ruleName, (String)ruleDesc, (Long)reviewerCount, (Long)approverCount, (Long)executerCount);
        }
        catch (Exception e) {
            e.printStackTrace();
            isSuccess = false;
            message = rb.getString("admp.workflow.businessworkflow.message_added_status_erro");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("isSuccess", (Object)isSuccess);
            json.put("message", (Object)message);
            writer.print(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteBusinessRules(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long ruleId = new Long(request.getParameter("BUSINESS_RULE_ID"));
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = rb.getString("admp.workflow.businessworkflow.message_deleted_status_success");
        ArrayList list = WorkFlowUtil.getMappedAsssigningRulesForBusinessRule((Long)ruleId);
        PrintWriter writer = response.getWriter();
        Boolean isAllowed = true;
        if (list.size() > 0) {
            isAllowed = false;
            writer.print(isAllowed);
            return null;
        }
        Boolean isSuccess = true;
        try {
            WFRuleHandler.deleteBusinessRule((Long)ruleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            isSuccess = false;
            message = rb.getString("admp.workflow.businessworkflow.message_delete_status_error");
        }
        try {
            JSONObject json = new JSONObject();
            json.put("isSuccess", (Object)isSuccess);
            json.put("message", (Object)message);
            writer.print(json);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward isdeleteBusinessRuleAllowed(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long ruleId = new Long(request.getParameter("BUSINESS_RULE_ID"));
        ArrayList list = WorkFlowUtil.getMappedAsssigningRulesForBusinessRule((Long)ruleId);
        PrintWriter writer = response.getWriter();
        Boolean isAllowed = true;
        if (list.size() > 0) {
            isAllowed = false;
        }
        writer.print(isAllowed);
        return null;
    }

    public ActionForward saveTable(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String substring = request.getParameter("substring");
            StringTokenizer substringTokenizer = new StringTokenizer(substring, ",");
            ArrayList<Properties> subList = new ArrayList<Properties>();
            int i = 0;
            while (substringTokenizer.hasMoreTokens()) {
                Properties properties = new Properties();
                Integer attributeId = new Integer(substringTokenizer.nextToken());
                properties.put("WF_ATTRIB_ID", attributeId);
                properties.put("PRIORITY", new Integer(++i));
                subList.add(properties);
            }
            WFAttributeHandler.getInstance().saveColumns(loginId, subList);
            ArrayList viewList = WFAttributeHandler.getInstance().getListReqDefaultColumnList(loginId);
            ArrayList nonVisibleList = WFAttributeHandler.getInstance().getListReqEditColumnList(viewList);
            request.setAttribute("ColumnList", (Object)viewList);
            request.setAttribute("EditList", (Object)nonVisibleList);
            request.setAttribute("message", (Object)"Successfully Saved");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("WFAddRemoveColumn");
    }

    public ActionForward listRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ArrayList requestFilters = WorkFlowUserHandler.getRequestFilters((Long)loginId);
        Properties optGroupTexts = WorkFlowUserHandler.getOptGroupTexts();
        Boolean isAdmin = false;
        if (loginId == 1L) {
            isAdmin = true;
        }
        request.setAttribute("isAdmin", (Object)isAdmin);
        request.setAttribute("requestFilters", (Object)requestFilters);
        request.setAttribute("optGroupTexts", (Object)optGroupTexts);
        request.setAttribute("RANGE", (Object)NavigateRangeUtil.getDefaultRange((String)"WorkFlowView", (Long)loginId));
        return mapping.findForward("listRequests");
    }

    public ActionForward listRequestsResults(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String params = request.getParameter("params");
        JSONObject json = new JSONObject(params);
        try {
            ArrayList defaultColumnList;
            Integer range = (Integer)json.get("range");
            Integer startIndex = (Integer)json.get("startIndex");
            Integer toIndex = (Integer)json.get("toIndex");
            Boolean ascending = (Boolean)json.get("ascending");
            Boolean isNavigation = (Boolean)json.get("isNavigation");
            Integer attributeId = (Integer)json.get("attributeId");
            Integer searchFilter = (Integer)json.get("searchFilter");
            Object requestId = json.get("requestId");
            Boolean isNewRange = json.getBoolean("isNewRange");
            if (isNewRange.booleanValue()) {
                NavigateRangeUtil.setDefaultRange((String)"WorkFlowView", (int)range, (Long)loginId);
            }
            if ((defaultColumnList = WFAttributeHandler.getInstance().getListReqDefaultColumnList(loginId)).isEmpty()) {
                defaultColumnList = WFAttributeHandler.getInstance().getListReqDefaultColumnList(Long.valueOf(1L));
            }
            ArrayList columnList = WFAttributeHandler.getInstance().listRequestsAllColumns();
            if (ascending.booleanValue()) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            Integer count = -1;
            if (!isNavigation.booleanValue()) {
                count = WorkFlow.getListReqResultCount((String)searchFilter.toString(), (Long)loginId, (Object)requestId);
            }
            List result = new ArrayList();
            if (count != null && count != 0) {
                result = WorkFlow.listRequests((int)startIndex, (int)toIndex, (String)searchFilter.toString(), (ArrayList)columnList, (Integer)attributeId, (Boolean)ascending, (Long)loginId, (Object)requestId, (AdventNetResourceBundle)rb);
            }
            ArrayList reviewersList = WorkFlowUserHandler.getBoardMembers((Long)2L);
            ArrayList approversList = WorkFlowUserHandler.getBoardMembers((Long)3L);
            ArrayList committersList = WorkFlowUserHandler.getBoardMembers((Long)4L);
            request.setAttribute("reviewersList", WorkFlowClientUtil.getWFUsersMap(reviewersList, rb));
            request.setAttribute("approversList", WorkFlowClientUtil.getWFUsersMap(approversList, rb));
            request.setAttribute("committersList", WorkFlowClientUtil.getWFUsersMap(committersList, rb));
            Boolean isAdmin = false;
            if (loginId == 1L) {
                isAdmin = true;
            }
            request.setAttribute("isAdmin", (Object)isAdmin);
            request.setAttribute("columnList", (Object)defaultColumnList);
            request.setAttribute("requestId", requestId);
            request.setAttribute("attributeId", (Object)attributeId);
            request.setAttribute("ascending", (Object)ascending);
            request.setAttribute("result", result);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("isNavigation", (Object)isNavigation);
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("ListRequestsRows");
    }

    public ActionForward showSummary(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            Hashtable summaryList = WorkFlow.getSummaryList((Long)loginId);
            request.setAttribute("summaryList", (Object)summaryList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("ShowSummary");
    }

    public ActionForward reqMgmtAction(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String operation = request.getParameter("operation");
        if (operation != null && operation.equals("close")) {
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            String[] selectedGUIDsStr = new String[json.length()];
            Iterator itr = json.keys();
            int i = 0;
            while (itr.hasNext()) {
                selectedGUIDsStr[i] = (String)itr.next();
                ++i;
            }
            WorkFlowUtil.deleteWFRequestSchedule((String[])selectedGUIDsStr, (String)operation);
            WorkFlowUtil.closeRequests((String[])selectedGUIDsStr);
        } else if (operation != null && operation.equals("delete")) {
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            String[] selectedGUIDsStr = new String[json.length()];
            Long[] selectedGUIDs = new Long[json.length()];
            Iterator itr = json.keys();
            int i = 0;
            while (itr.hasNext()) {
                selectedGUIDsStr[i] = (String)itr.next();
                selectedGUIDs[i] = Long.valueOf(selectedGUIDsStr[i]);
                ++i;
            }
            WorkFlowUtil.deleteWFRequestSchedule((String[])selectedGUIDsStr, (String)operation);
            WorkFlowUtil.deleteBulkLayoutData((Long[])selectedGUIDs);
            Boolean isSuccess = WorkFlowUtil.deleteRequests((String[])selectedGUIDsStr);
            ClientUtil.setStatusXMLElement(response, "success", isSuccess.toString());
            return null;
        }
        this.listRequests(mapping, form, request, response);
        return mapping.findForward("listRequests");
    }

    public ActionForward modifyTask(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            Long requestId = new Long(request.getParameter("requestId"));
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            String operation = request.getParameter("operation");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            String comments = "";
            Properties prop = new Properties();
            String statusMessage = "";
            String status = "Success";
            if (operation.equals("delete")) {
                out.log(Level.INFO, "Delete WFTask request: Requested by : " + loginId + " requested Task : " + wfTask.getRequestActionId() + " taskDetailsId " + taskDetailsId);
                boolean isDeleted = wfViewRequest.deleteWFTask(loginId, taskDetailsId, comments, rb);
                if (isDeleted) {
                    String fullName = rb.getString(WorkFlowUtil.getFullName((Long)loginId));
                    String time = DateTimeUtil.formatDate((Long)System.currentTimeMillis(), (Long)loginId);
                    statusMessage = rb.getString("admp.workflow.view_request.delete_task_success");
                    String deletedTaskName = rb.getString(AutomationUtil.getActionName((Long)wfTask.getRequestActionId()));
                    String auditText = MessageFormat.format(rb.getString("admp.workflow.view_request.workflow_status.deleted_by"), fullName, deletedTaskName, time);
                    prop.put("auditText", auditText);
                    out.log(Level.INFO, "Successfully deleted the requested task");
                } else {
                    status = "Error";
                    statusMessage = rb.getString("admp.workflow.view_request.delete_task_error");
                    out.log(Level.INFO, "Exception/Error occurred when deleting the task");
                }
            } else if (operation.equals("run")) {
                out.log(Level.INFO, "Before TimeBased task exeution, manual execte request received for the that task detailsid : " + taskDetailsId + " by loginId :: " + loginId);
                statusMessage = rb.getString("admp.workflow.view_request.stat_msg.follow_up_task_execution_success");
                Long automationId = wfViewRequest.getAutomationId();
                if (automationId != null) {
                    String automationName = wfViewRequest.getAutomationName();
                    AutomationNotificationMacro notificationMacro = new AutomationNotificationMacro();
                    Hashtable<String, Object> ids = new Hashtable<String, Object>();
                    ids.put("automationId", automationId);
                    ids.put("autoRaisedId", wfViewRequest.getRaisedRequestId());
                    ids.put("requestId", requestId);
                    ids.put("errorMessage", rb.getString("admp.automation.notification.success_message"));
                    notificationMacro.init(ids);
                    NotificationTemplateHandler.macroMap.put(requestId, notificationMacro);
                }
                String message = wfViewRequest.executedWFTask(loginId, taskDetailsId, comments, rb);
                String count = wfTask.getReqActionResultCount().toString();
                prop.put("count", count);
                if (message.equalsIgnoreCase("error")) {
                    statusMessage = rb.getString("admp.workflow.view_request.stat_msg.follow_up_task_execution_failure");
                }
                out.log(Level.INFO, "Status message of theFollow-up task, " + taskDetailsId + " is : " + statusMessage);
            }
            ClientUtil.setStatusXMLElement(response, status, statusMessage, prop);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public ActionForward getReqTaskResultRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        try {
            Long reqMonitorTaskId;
            Long requestId = new Long(request.getParameter("requestId"));
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String fromIndesStr = request.getParameter("FROM_INDEX");
            String rangeStr = request.getParameter("RANGE");
            String isNavigate = request.getParameter("isNavigate");
            String sortColumnNameStr = request.getParameter("attributeId");
            String pageNumber = request.getParameter("PAGE_NUMBER");
            String sortingOrder = "true";
            Object tableKey = null;
            if (request.getParameter("ascending") != null) {
                sortingOrder = request.getParameter("ascending");
            }
            Integer range = ClientUtil.getDefaultRange(rangeStr, isNavigate, "BulkModification", loginId);
            Integer attributeId = 0;
            Long fromIndex = 1L;
            if (fromIndesStr != null) {
                fromIndex = new Long(fromIndesStr);
            }
            if (pageNumber == null) {
                pageNumber = "1";
            }
            Hashtable<String, Object> requestProperties = new Hashtable<String, Object>();
            requestProperties.put("RANGE", range);
            requestProperties.put("FROM_INDEX", fromIndex);
            requestProperties.put("ascending", sortingOrder);
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            BusinessWorkflow businessWF = new BusinessWorkflow(requestId, loginId);
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            Long reqActionId = wfTask.getRequestActionId();
            out.log(Level.INFO, "is taskid " + taskDetailsId + " executed or not:" + wfTask.isExecuted());
            if (reqActionId.compareTo(WorkFlowUtil.MODIFY_PHOTO_ACTION_ID) == 0) {
                String uniqueOperationId = "";
                String shareFolderPath = "";
                String photoFileNameFormat = "";
                String attribute = "";
                for (AdmpInput admpInput : wfTask.getInputList()) {
                    ArrayList multiInputDetailsMap = admpInput.getMultipleInput();
                    for (FcOption fcOption : multiInputDetailsMap) {
                        String label = fcOption.getLabel();
                        if (label.equalsIgnoreCase("format")) {
                            photoFileNameFormat = fcOption.getValue();
                            continue;
                        }
                        if (label.equalsIgnoreCase("uniqueOperationId")) {
                            uniqueOperationId = fcOption.getValue();
                            continue;
                        }
                        if (label.equalsIgnoreCase("folderpath")) {
                            shareFolderPath = fcOption.getValue();
                            continue;
                        }
                        if (!label.equalsIgnoreCase("attributeName")) continue;
                        attribute = fcOption.getValue();
                    }
                }
                HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
                ArrayList columnList = WFAttributeHandler.getInstance().getCommitColumnList(requestId);
                HashMap h = (HashMap)columnList.get(0);
                ArrayList matchedUserObjectIdLists = WorkFlowCommit.getReqMonitorTaskGUIDResult((Long)taskDetailsId, (Long)requestId, (ArrayList)columnList, (String)((String)h.get("TABLE_NAME")));
                JSONArray matchedUserObjectIdList = new JSONArray();
                String domainName = "";
                HashMap resultMap = (HashMap)matchedUserObjectIdLists.get(0);
                domainName = (String)resultMap.get(1143);
                matchedUserObjectIdList = UserMgmtUtil.getObjectId((String)uniqueOperationId, (ArrayList)matchedUserObjectIdLists);
                ArrayList<String> attribListToUI = new ArrayList<String>();
                attribListToUI.add("OBJECT_GUID");
                attribListToUI.add("SID_STRING");
                attribListToUI.add("DISPLAY_NAME");
                attribListToUI.add("SAM_ACCOUNT_NAME");
                JSONObject matchedSearchCrit = new JSONObject();
                matchedSearchCrit.put("OBJECT_GUID_LIST", (Object)matchedUserObjectIdList);
                int startIndex = 1;
                int rangee = 25;
                JSONObject result = UserMgmtUtil.getUsers(null, (String)domainName, (int)startIndex, (int)rangee, attribListToUI, null, (JSONObject)matchedSearchCrit, null);
                JSONArray matchedUserDetails = (JSONArray)result.get("userDetails");
                JSONArray unmatchedPhotoList = UserMgmtUtil.getUnmatchedPhotoList((String)uniqueOperationId);
                Integer workflowStatus = (Integer)requestDetails.get("WFStatus");
                request.setAttribute("requestId", (Object)requestId);
                request.setAttribute("TotalObjectId", (Object)matchedUserObjectIdList);
                request.setAttribute("uniqueOperationId", (Object)uniqueOperationId);
                request.setAttribute("workflowStatus", (Object)workflowStatus);
                request.setAttribute("unmatchedPhotoList", (Object)unmatchedPhotoList);
                request.setAttribute("photoFileNameFormat", (Object)photoFileNameFormat);
                request.setAttribute("selectedAttribute", (Object)attribute);
                request.setAttribute("resultLists", (Object)matchedUserDetails);
                request.setAttribute("domainName", (Object)domainName);
                return mapping.findForward("managePhotosResult");
            }
            boolean removeObjectFromTask = businessWF.isAllowToModifyRequestData(wfTask.isExecuted());
            wfTask.setReportId();
            Integer reportId = wfTask.getReportId();
            ArrayList columnList = wfTask.getColumnList();
            attributeId = sortColumnNameStr != null ? new Integer(sortColumnNameStr) : wfTask.getSortColumnId();
            requestProperties.put("attributeId", attributeId);
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList resultList = wfTask.getRequestResultRows(requestProperties, columnList, multipleValuesSids);
            String key = ReportsUtil.TABLE_KEY;
            if (Arrays.asList(ReportsUtil.o365Userreports).contains(reportId)) {
                key = ReportsUtil.O365_TABLE_KEY;
            }
            WFAttributeHandler.getInstance();
            WFAttributeHandler.getMultipleValues((ArrayList)columnList, multipleValuesSids, (String)key, null);
            ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
            Long count = wfTask.getReqActionResultCount();
            request.setAttribute("columnList", (Object)columnList);
            request.setAttribute("resultList", (Object)resultList);
            request.setAttribute("multipleValuesSids", multipleValuesSids);
            request.setAttribute("removeObjectFromTask", (Object)removeObjectFromTask);
            if (sortingOrder != null && sortingOrder.equals("true")) {
                request.setAttribute("sortImage", (Object)"images/sortdown.gif");
            } else {
                request.setAttribute("sortImage", (Object)"images/sortup.gif");
            }
            JSONObject actionNameList = new JSONObject();
            ArrayList<Long> taskDetailsIdList = new ArrayList<Long>();
            ArrayList wfTaskSetList = wfViewRequest.getInstantTaskSetList();
            for (WFTaskSet wfTaskSet : wfTaskSetList) {
                for (WFTask workFlowTask : wfTaskSet.getAdmpTaskList()) {
                    reqMonitorTaskId = workFlowTask.getReqMonitorTaskId();
                    if (!businessWF.isAllowToModifyRequestData(workFlowTask.isExecuted())) continue;
                    actionNameList.put(reqMonitorTaskId.toString(), (Object)rb.getString(workFlowTask.getReqActionName()));
                    taskDetailsIdList.add(reqMonitorTaskId);
                }
            }
            wfTaskSetList = wfViewRequest.getSuccessiveTaskSetList();
            for (WFTaskSet wfTaskSet : wfTaskSetList) {
                for (WFTask workFlowTask : wfTaskSet.getAdmpTaskList()) {
                    reqMonitorTaskId = workFlowTask.getReqMonitorTaskId();
                    if (!businessWF.isAllowToModifyRequestData(workFlowTask.isExecuted())) continue;
                    actionNameList.put(reqMonitorTaskId.toString(), (Object)rb.getString(workFlowTask.getReqActionName()));
                    taskDetailsIdList.add(reqMonitorTaskId);
                }
            }
            String taskDetailsIdString = taskDetailsIdList.toString();
            taskDetailsIdString = taskDetailsIdString.substring(1, taskDetailsIdString.length() - 1).replaceAll("\\s", "");
            HashMap requestDetails = WorkFlow.getRequestWorkflowDetails((Long)requestId);
            Long ruleId = (Long)requestDetails.get("ruleId");
            Integer wFstatusId = (Integer)requestDetails.get("WFStatus");
            Long wFCount = (Long)requestDetails.get("WFCount");
            int currentWorkFlow = BusinessWorkflowRule.getBusinessWorkflowRule((Long)ruleId).getNextElement(wFstatusId, wFCount);
            Boolean isAuthorizedToManage = WorkFlowUserHandler.isAssignedWorkflowTechnician((Long)requestId, (Integer)wFstatusId, (Long)new Long("" + currentWorkFlow), (Long)loginId);
            request.setAttribute("actionNameList", (Object)actionNameList);
            request.setAttribute("taskDetailsIdList", (Object)taskDetailsIdString);
            request.setAttribute("fromIndex", (Object)fromIndex);
            request.setAttribute("attributeId", (Object)attributeId);
            request.setAttribute("ascending", (Object)sortingOrder);
            request.setAttribute("RANGE", (Object)range);
            request.setAttribute("pageNumber", (Object)pageNumber);
            request.setAttribute("recordsCount", (Object)count);
            request.setAttribute("requestId", (Object)requestId);
            request.setAttribute("taskDetailsId", (Object)taskDetailsId);
            request.setAttribute("reportId", (Object)reportId);
            request.setAttribute("htmlEscapeAttributeIs", (Object)htmlEscapeAttributeIs);
            request.setAttribute("isAuthorizedToManage", (Object)isAuthorizedToManage);
            if (reqActionId.compareTo(WorkFlowUtil.PASSWORD_ACTION_ID) == 0) {
                block8: for (AdmpInput admpInput : wfTask.getInputList()) {
                    if (!admpInput.getIsMultiple().booleanValue()) continue;
                    ArrayList multiInputDetailsMap = admpInput.getMultipleInput();
                    for (FcOption fcOption : multiInputDetailsMap) {
                        String label = fcOption.getLabel();
                        if (!label.equalsIgnoreCase("PasswordType")) continue;
                        String pwdType = fcOption.getValue();
                        if (pwdType == null) continue block8;
                        request.setAttribute("pwdType", (Object)pwdType);
                        continue block8;
                    }
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("resultRows");
    }

    public ActionForward getReqTaskResult(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = new Long(request.getParameter("requestId"));
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            BusinessWorkflow businessWF = new BusinessWorkflow(requestId, loginId);
            boolean isAllowToModifyRequestData = businessWF.isAllowToModifyRequestData(wfTask.isExecuted());
            request.setAttribute("isAllowToModifyRequestData", (Object)isAllowToModifyRequestData);
            request.setAttribute("subject", (Object)wfViewRequest.getSubject());
            request.setAttribute("wfTask", (Object)wfTask);
            request.setAttribute("requestId", (Object)requestId);
            request.setAttribute("isUnclosedCommittedRequest", (Object)wfViewRequest.isUnclosedCommittedRequest());
            boolean canResendRequest = loginId.equals(wfViewRequest.getRequester());
            request.setAttribute("canResendRequest", (Object)canResendRequest);
            request.setAttribute("domainName", (Object)wfViewRequest.getDomainName());
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return mapping.findForward("workflowResult");
    }

    public ActionForward viewRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        DynaValidatorForm bean = (DynaValidatorForm)form;
        Long requestId = (Long)bean.get("requestId");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String isAssociateAssigningRuleCompleted = ADSMPersUtil.getSyMParameter((String)"IsAssociateAssigningRuleCompleted");
        if (isAssociateAssigningRuleCompleted.equalsIgnoreCase("false")) {
            WFRuleHandler.checkAndAssociateAssigningRule((Long)requestId);
        }
        WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
        WorkFlowClientUtil.viewRequest(wfviRequest, request, response);
        request.setAttribute("htmlEscapeRequestActionIds", (Object)htmlEscapeRequestActionIds);
        return mapping.findForward("viewRequest");
    }

    public ActionForward approveRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String action = request.getParameter("actionName");
        String wfExecutionValue = "Immediately";
        if (!action.equalsIgnoreCase("apply") || WorkFlowUtil.checkBoardMember((Long)loginId, (Long)3L)) {
            Long requestId = new Long(request.getParameter("requestId"));
            String comment = request.getParameter("Comments");
            wfExecutionValue = request.getParameter("wfExecutionValue");
            String additionalActionsSt = request.getParameter("additionalActions");
            if (wfExecutionValue == null || wfExecutionValue.equalsIgnoreCase("undefined") || wfExecutionValue.equals("")) {
                wfExecutionValue = "Immediately";
            }
            out.log(Level.INFO, "approve Request in WorkFlowAction: comment" + comment + "requestId:" + requestId + "wfExecutionValue: " + wfExecutionValue);
            String message = "";
            boolean commited = false;
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if (action != null) {
                Integer wFStatusId = null;
                try {
                    if (action.equalsIgnoreCase("apply")) {
                        if (wfExecutionValue.equalsIgnoreCase("Immediately")) {
                            wFStatusId = wfviRequest.getWorkflowStatus();
                            if (WorkFlowClientUtil.isAllowToModifyWFStatus(wfviRequest, WorkFlowUtil.WORKFLOW_STATUS_APPROVED) || wFStatusId == WorkFlowUtil.WORKFLOW_STATUS_SCHEDULED) {
                                wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_APPROVED;
                                Hashtable hash = WorkFlow.modifyRequestWorkflowWithCount((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, null);
                                System.out.println("Hash " + hash);
                                if (hash.get("isModified") != null && ((Boolean)hash.get("isModified")).booleanValue()) {
                                    WFTask wfTask;
                                    boolean isTemplateBasedActionAvailable = wfviRequest.isTemplateBasedWFActionAvailable();
                                    if (isTemplateBasedActionAvailable && (wfTask = wfviRequest.getTemplateBasedWFTask()) != null) {
                                        HashMap resultMap = wfTask.getRequestUserCreationDetails();
                                        Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                                        WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
                                        auditActivities.setCurrentWFStatus(wFStatusId);
                                        AdmpInput admpInput = new AdmpInput("templateName", layoutId.toString(), false);
                                        auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                                    }
                                    message = rb.getString("admp.workflow.viewrequest.statmsg.approved_success");
                                    Long wfProcessedCount = wfviRequest.getwFProcessedCount();
                                    boolean isWFStatusChanged = false;
                                    Boolean isNotificationNeeded = true;
                                    if (hash.get("isWFStatusChanged") != null) {
                                        isWFStatusChanged = (Boolean)hash.get("isWFStatusChanged");
                                    }
                                    if (isWFStatusChanged && BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId()).getNextElement(Integer.valueOf(WorkFlowUtil.WORKFLOW_STATUS_APPROVED), wfProcessedCount) == 0) {
                                        JSONObject status;
                                        System.out.println("Approve request, but going to commit");
                                        boolean canCommit = true;
                                        if (WorkFlowUtil.anySSPApprovalTask((WFViewRequest)wfviRequest) && (status = JumpToHandler.getProductStatus((String)"ManageEngine ADSelfService Plus")) != null && !"00000000".equalsIgnoreCase(status.getString("ERROR_CODE"))) {
                                            message = "admp.workflow.viewrequest.statmsg.execute_failed_ssp_down";
                                            canCommit = false;
                                        }
                                        if (canCommit) {
                                            ArrayList<Long> additionExecutionActions = new ArrayList<Long>();
                                            JSONArray jsonArray = additionalActionsSt != null ? new JSONArray(additionalActionsSt) : new JSONArray();
                                            for (int i = 0; i < jsonArray.length(); ++i) {
                                                String actionIdObj = String.valueOf(jsonArray.get(i));
                                                Long actionId = Long.valueOf(actionIdObj);
                                                additionExecutionActions.add(actionId);
                                            }
                                            wfviRequest.setAdditionalExecutionActions(additionExecutionActions);
                                            if (wfviRequest.getRequestMode() == 1L) {
                                                Long automationId = AutomationUtil.getAutomationIdFromRaisedId((Long)wfviRequest.getRaisedRequestId());
                                                AutomationNotificationMacro notificationMacro = new AutomationNotificationMacro();
                                                Hashtable<String, Object> ids = new Hashtable<String, Object>();
                                                ids.put("automationId", automationId);
                                                ids.put("autoRaisedId", wfviRequest.getRaisedRequestId());
                                                ids.put("requestId", requestId);
                                                ids.put("errorMessage", rb.getString("admp.automation.notification.success_message"));
                                                notificationMacro.init(ids);
                                                NotificationTemplateHandler.macroMap.put(requestId, notificationMacro);
                                                if (AutomationUtil.isNotifyEnabledAutomation((Long)automationId)) {
                                                    isNotificationNeeded = false;
                                                }
                                            }
                                            String statusMessage = wfviRequest.commitRequestedTask(loginId, comment, rb);
                                            message = message + " & " + rb.getString(statusMessage);
                                            commited = true;
                                            this.isSuccessfullyExecuted(requestId, rb, statusMessage);
                                        }
                                    }
                                    if (isWFStatusChanged) {
                                        WFRuleExecutor ruleExecutor = new WFRuleExecutor(wFStatusId, requestId, rb, loginId, wfviRequest.getWfRuleId(), isNotificationNeeded);
                                        ruleExecutor.start();
                                        while (ruleExecutor.isAlive()) {
                                            Thread.sleep(100L);
                                        }
                                    } else {
                                        WFAssigningRuleUtil.removePreviousAssignee((Long)requestId, (Long)loginId);
                                    }
                                } else {
                                    message = rb.getString("admp.workflow.viewrequest.statmsg.exception_occurred");
                                }
                            } else {
                                System.out.println("Else block.. Approval request skipped");
                            }
                        } else {
                            if (additionalActionsSt == null) {
                                additionalActionsSt = "";
                            }
                            String exeTime = WorkFlowUtil.createWFRequestScheduleTask((Long)requestId, (String)wfExecutionValue, (Long)loginId, (String)comment, (Long)WorkFlowUtil.WORKFLOW_PRE_STAUS_APPROVER, (String)additionalActionsSt);
                            if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)WorkFlowUtil.WORKFLOW_STATUS_SCHEDULED, (Integer)WorkFlowUtil.WORKFLOW_REQUEST_STAUS_OPEN)) {
                                WorkFlowUtil.scheduleSuccessiveTask((Long)requestId, (String)exeTime);
                                out.log(Level.INFO, "Sucussfully updated the WFRequestExecution audit entries for approver");
                            }
                        }
                    } else {
                        WFNotificationMacro macro;
                        Integer statusId = wfviRequest.getWorkflowStatus();
                        BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId());
                        int currentWorkFlow = businessWorkflowRule.getNextElement(statusId, wfviRequest.getwFProcessedCount());
                        WFAssignToRule ruledetails = new WFAssignToRule(wfviRequest.getWfRuleId(), rb);
                        ruledetails.initRuleResultData(true);
                        Long[] rejectedNotificationTemplateIds = ruledetails.getRejectedNotificationTemplateIdList(Long.valueOf(currentWorkFlow));
                        ArrayList<NotificationTemplate> associatedTemplates = new ArrayList<NotificationTemplate>();
                        if (rejectedNotificationTemplateIds != null) {
                            for (Long notificationTemplateId : rejectedNotificationTemplateIds) {
                                JSONObject jsonObject = NotificationTemplateHandler.getTemplateDetails((Long)notificationTemplateId, (AdventNetResourceBundle)rb);
                                NotificationTemplate notificationTemplate = new NotificationTemplate(notificationTemplateId, jsonObject);
                                associatedTemplates.add(notificationTemplate);
                            }
                        }
                        if (action.equalsIgnoreCase("cancel") && WorkFlowClientUtil.isAllowToRejectRequeset(requestId)) {
                            wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_CANCELED;
                            wfviRequest.updateRejectRequestTaskStatus();
                            if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, (Integer)WorkFlowUtil.WORKFLOW_REQUEST_STAUS_CANCELLED)) {
                                message = rb.getString("admp.workflow.viewrequest.statmsg.canceled_success");
                                macro = new WFNotificationMacro();
                                Hashtable<String, Long> macroDetailsMap = new Hashtable<String, Long>();
                                macroDetailsMap.put("requestId", requestId);
                                macroDetailsMap.put("triggerId", Long.valueOf(currentWorkFlow));
                                macroDetailsMap.put("adsmWorkFlowStatusID", Long.valueOf(WFRuleConstants.WORKFLOW_REQUEST_STAUS_CLOSED));
                                macro.init(macroDetailsMap);
                                NotificationTrigger trigger = new NotificationTrigger(null, null, rb, loginId, (NotificationMacro)macro, "Workflow", null);
                                trigger.setNotificationTemplates(associatedTemplates);
                                trigger.start();
                                new PushNotificationTrigger(loginId, Long.valueOf(currentWorkFlow), requestId, new JSONObject().put("NA", 1).put("REQUEST_ID", (Object)requestId), rb).start();
                            } else {
                                message = rb.getString("admp.workflow.viewrequest.statmsg.exception_occurred");
                            }
                        } else if (WorkFlowClientUtil.isAllowToRejectRequeset(requestId)) {
                            wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_REJECTED;
                            wfviRequest.updateRejectRequestTaskStatus();
                            if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, null)) {
                                message = rb.getString("admp.workflow.viewrequest.statmsg.rejected_success");
                                macro = new WFNotificationMacro();
                                Hashtable<String, Long> macroDetailsMap = new Hashtable<String, Long>();
                                macroDetailsMap.put("requestId", requestId);
                                macroDetailsMap.put("triggerId", Long.valueOf(currentWorkFlow));
                                macroDetailsMap.put("adsmWorkFlowStatusID", Long.valueOf(WFRuleConstants.WORKFLOW_REQUEST_STAUS_CLOSED));
                                macro.init(macroDetailsMap);
                                NotificationTrigger trigger = new NotificationTrigger(null, null, rb, loginId, (NotificationMacro)macro, "Workflow", null);
                                trigger.setNotificationTemplates(associatedTemplates);
                                trigger.start();
                                new PushNotificationTrigger(loginId, Long.valueOf(currentWorkFlow), requestId, new JSONObject().put("NA", 1).put("REQUEST_ID", (Object)requestId), rb).start();
                            } else {
                                message = rb.getString("admp.workflow.viewrequest.statmsg.exception_occurred");
                            }
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                request.setAttribute("message", (Object)message);
                WorkFlowClientUtil.viewRequest(new WFViewRequest(requestId, rb), request, response);
                return mapping.findForward("viewRequest");
            }
            out.log(Level.INFO, "action can not be null");
            WorkFlowClientUtil.viewRequest(wfviRequest, request, response);
        } else {
            out.log(Level.INFO, "Technician not having a permission to process the request");
            response.sendError(403);
        }
        return mapping.findForward("viewRequest");
    }

    public ActionForward resendRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        DynaValidatorForm bean = (DynaValidatorForm)form;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = new Long(request.getParameter("requestId"));
        bean.set("requestId", (Object)requestId);
        String comment = request.getParameter("Comments");
        String action = request.getParameter("actionName");
        String message = "";
        if (action != null) {
            Integer wFStatusId = null;
            try {
                wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_CREATED;
                WFViewRequest wfviewRequest = new WFViewRequest(requestId, rb);
                Hashtable hash = WorkFlow.modifyRequestWorkflowWithCount((WFViewRequest)wfviewRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, null);
                if (hash.get("isModified") != null && ((Boolean)hash.get("isModified")).booleanValue()) {
                    message = rb.getString("admp.workflow.viewrequest.statmsg.resend_success");
                    WFRuleExecutor ruleExecutor = new WFRuleExecutor(wFStatusId, requestId, rb, loginId, (Long)hash.get("ruleId"));
                    ruleExecutor.start();
                    while (ruleExecutor.isAlive()) {
                        Thread.sleep(100L);
                    }
                } else {
                    message = rb.getString("admp.workflow.viewrequest.statmsg.exception_occurred");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            request.setAttribute("message", (Object)message);
        } else {
            out.log(Level.INFO, "action can not be null");
        }
        WorkFlowClientUtil.viewRequest(new WFViewRequest(requestId, rb), request, response);
        return mapping.findForward("viewRequest");
    }

    public ActionForward closeRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = new Long(request.getParameter("requestId"));
        String comment = request.getParameter("Comments");
        String action = request.getParameter("actionName");
        String message = "";
        WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
        String[] requestIdStr = new String[]{Long.toString(requestId)};
        if (action != null) {
            Integer wFStatusId = null;
            try {
                wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_CLOSED;
                if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, (Integer)WorkFlowUtil.WORKFLOW_REQUEST_STAUS_CLOSED)) {
                    message = rb.getString("admp.workflow.viewrequest.statmsg.close_success");
                    WorkFlowUtil.deleteWFRequestSchedule((String[])requestIdStr, (String)"close");
                } else {
                    message = rb.getString("admp.workflow.viewrequest.statmsg.exception_occurred");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            request.setAttribute("message", (Object)message);
        } else {
            out.log(Level.INFO, "action can not be null");
        }
        WorkFlowClientUtil.viewRequest(wfviRequest, request, response);
        return mapping.findForward("viewRequest");
    }

    public ActionForward reviewRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        if (WorkFlowUtil.checkBoardMember((Long)loginId, (Long)2L)) {
            Long requestId = new Long(request.getParameter("requestId"));
            Integer wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_REVIEWED;
            String comment = request.getParameter("Comments");
            out.log(Level.INFO, "ReviewRequest in WorkFlowAction: comment" + comment + "requestId:" + requestId);
            String action = request.getParameter("actionName");
            WFViewRequest wfviRequest = new WFViewRequest(requestId, rb);
            if ("apply".equalsIgnoreCase(action) && WorkFlowClientUtil.isAllowToModifyWFStatus(wfviRequest, wFStatusId)) {
                String message = "";
                Hashtable hash = WorkFlow.modifyRequestWorkflowWithCount((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)wFStatusId, null);
                if (hash.get("isModified") != null && ((Boolean)hash.get("isModified")).booleanValue()) {
                    WFTask wfTask;
                    boolean isTemplateBasedActionAvailable = wfviRequest.isTemplateBasedWFActionAvailable();
                    if (isTemplateBasedActionAvailable && (wfTask = wfviRequest.getTemplateBasedWFTask()) != null) {
                        HashMap resultMap = wfTask.getRequestUserCreationDetails();
                        Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                        WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
                        auditActivities.setCurrentWFStatus(wFStatusId);
                        AdmpInput admpInput = new AdmpInput("templateName", layoutId.toString(), false);
                        auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                    }
                    message = rb.getString("admp.workflow.viewrequest.statmsg.reviewed_success");
                } else {
                    message = rb.getString("admp.workflow.viewrequest.statmsg.reviewed_failure");
                }
                if (hash.get("isWFStatusChanged") != null) {
                    Boolean isWFStatusChanged = (Boolean)hash.get("isWFStatusChanged");
                    if (isWFStatusChanged.booleanValue()) {
                        WFRuleExecutor ruleExecutor = new WFRuleExecutor(wFStatusId, requestId, rb, loginId, (Long)hash.get("ruleId"));
                        ruleExecutor.start();
                        while (ruleExecutor.isAlive()) {
                            Thread.sleep(100L);
                        }
                    } else {
                        WFAssigningRuleUtil.removePreviousAssignee((Long)requestId, (Long)loginId);
                    }
                }
                request.setAttribute("message", (Object)message);
            }
            WorkFlowClientUtil.viewRequest(wfviRequest, request, response);
        } else {
            out.log(Level.INFO, "Technician not having a permission to process the request");
            response.sendError(403);
        }
        return mapping.findForward("viewRequest");
    }

    public ActionForward updateWFExecutionTime(ActionMapping mapping, ActionForm form, HttpServletRequest httpRequest, HttpServletResponse response) throws Exception {
        String message = "--";
        Locale locale = httpRequest.getLocale();
        String executionTime = "";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long requestId = new Long(httpRequest.getParameter("requestId"));
        Long scheduleId = 0L;
        String WFExecutionValue = httpRequest.getParameter("wfExecutionValue");
        executionTime = WorkFlowUtil.getWFReqExecutionTime((String)WFExecutionValue);
        WorkFlowUtil.updateWFRequestExecutionTime((Long)requestId, (String)executionTime);
        message = executionTime;
        SimpleDateFormat formatter1 = new SimpleDateFormat("dd-MMM-yyyy HH:mm:ss", Locale.US);
        Date executeDate = formatter1.parse(executionTime);
        SimpleDateFormat formatter2 = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.US);
        String executeDateValue = formatter2.format(executeDate);
        out.log(Level.INFO, "updateWFExecutionTime - Modified Date object for task input - executionDate :: " + executeDateValue);
        Hashtable requestDetails = WorkFlowUtil.getWFReqestScheduleMapping((String)"REQUEST_ID", (Long)requestId);
        if (requestDetails.size() > 0) {
            scheduleId = (Long)requestDetails.get("SCHEDULE_ID");
        }
        WorkFlowUtil.updateTaskInputSchedulerTime((Long)scheduleId, (String)executeDateValue);
        WorkFlowUtil.scheduleSuccessiveTask((Long)requestId, (String)executionTime);
        ClientUtil.setStatusXMLElement(response, "success", message);
        return null;
    }

    public ActionForward commitRequest(ActionMapping mapping, ActionForm form, HttpServletRequest httpRequest, HttpServletResponse response) throws Exception {
        Locale locale = httpRequest.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = httpRequest.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String message = "";
        if (WorkFlowUtil.checkBoardMember((Long)loginId, (Long)4L)) {
            WFViewRequest wfviRequest;
            Long requestId = new Long(httpRequest.getParameter("requestId"));
            String comment = httpRequest.getParameter("Comments");
            String additionalActionsSt = httpRequest.getParameter("additionalActions");
            String WFExecutionValue = httpRequest.getParameter("wfExecutionValue");
            ArrayList<Long> additionExecutionActions = new ArrayList<Long>();
            JSONArray jsonArray = additionalActionsSt != null ? new JSONArray(additionalActionsSt) : new JSONArray();
            for (int i = 0; i < jsonArray.length(); ++i) {
                String actionIdObj = String.valueOf(jsonArray.get(i));
                Long actionId = Long.valueOf(actionIdObj);
                additionExecutionActions.add(actionId);
            }
            String action = httpRequest.getParameter("actionName");
            boolean canCommit = true;
            if (WFExecutionValue.equalsIgnoreCase("Immediately")) {
                if ("apply".equalsIgnoreCase(action) && WorkFlowClientUtil.isAllowToRejectRequeset(requestId)) {
                    try {
                        JSONObject status;
                        wfviRequest = new WFViewRequest(requestId, rb);
                        if (WorkFlowUtil.anySSPApprovalTask((WFViewRequest)wfviRequest) && (status = JumpToHandler.getProductStatus((String)"ManageEngine ADSelfService Plus")) != null && !"00000000".equalsIgnoreCase(status.getString("ERROR_CODE"))) {
                            message = rb.getString("admp.workflow.viewrequest.statmsg.execute_failed_ssp_down");
                            canCommit = false;
                        }
                        if (canCommit) {
                            boolean savePassword;
                            WFTask wfTask;
                            boolean isTemplateBasedActionAvailable;
                            Boolean isNotificationNeeded = true;
                            Integer wFStatusId = WorkFlowUtil.WORKFLOW_STATUS_COMMITED;
                            wfviRequest.setAdditionalExecutionActions(additionExecutionActions);
                            if (wfviRequest.getRequestMode() == 1L) {
                                Long automationId = AutomationUtil.getAutomationIdFromRaisedId((Long)wfviRequest.getRaisedRequestId());
                                AutomationNotificationMacro notificationMacro = new AutomationNotificationMacro();
                                Hashtable<String, Object> ids = new Hashtable<String, Object>();
                                ids.put("automationId", automationId);
                                ids.put("autoRaisedId", wfviRequest.getRaisedRequestId());
                                ids.put("requestId", requestId);
                                ids.put("errorMessage", rb.getString("admp.automation.notification.success_message"));
                                notificationMacro.init(ids);
                                NotificationTemplateHandler.macroMap.put(requestId, notificationMacro);
                                if (AutomationUtil.isNotifyEnabledAutomation((Long)automationId)) {
                                    isNotificationNeeded = false;
                                }
                            }
                            Long objectCreationID = wfviRequest.getADMPTaskForNotification();
                            HashMap audit_info = new HashMap();
                            message = wfviRequest.commitRequestedTask(loginId, comment, rb);
                            this.isSuccessfullyExecuted(requestId, rb, message);
                            boolean isResetPasswordAction = wfviRequest.getIsResetPasswordAction();
                            if (isNotificationNeeded.booleanValue()) {
                                if (isResetPasswordAction) {
                                    audit_info = wfviRequest.getResetPasswordNotification();
                                } else if (objectCreationID != null) {
                                    audit_info = FcLayoutViewHandler.getUserObjectDetails((Long)objectCreationID);
                                }
                            }
                            if ((isTemplateBasedActionAvailable = wfviRequest.isTemplateBasedWFActionAvailable()) && (wfTask = wfviRequest.getTemplateBasedWFTask()) != null) {
                                HashMap resultMap = wfTask.getRequestUserCreationDetails();
                                Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                                WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
                                auditActivities.setCurrentWFStatus(wFStatusId);
                                AdmpInput admpInput = new AdmpInput("templateName", layoutId.toString(), false);
                                auditActivities.updateReqMonitorTaskToWFBoradStatus(admpInput);
                            }
                            out.log(Level.INFO, "Message : while committing " + message);
                            if (isNotificationNeeded.booleanValue()) {
                                Integer statusId = wfviRequest.getWorkflowStatus();
                                BusinessWorkflowRule businessWorkflowRule = BusinessWorkflowRule.getBusinessWorkflowRule((Long)wfviRequest.getWfRuleId());
                                int currentWorkFlow = businessWorkflowRule.getNextElement(statusId, wfviRequest.getwFProcessedCount());
                                WFAssignToRule ruledetails = new WFAssignToRule(wfviRequest.getWfRuleId(), rb);
                                ruledetails.initRuleResultData(true);
                                Long[] notificationTemplateIds = ruledetails.getNotificationTemplateIdList(Long.valueOf(currentWorkFlow));
                                ArrayList<NotificationTemplate> associatedTemplates = new ArrayList<NotificationTemplate>();
                                if (notificationTemplateIds != null) {
                                    for (Long notificationTemplateId : notificationTemplateIds) {
                                        JSONObject jsonObject = NotificationTemplateHandler.getTemplateDetails((Long)notificationTemplateId, (AdventNetResourceBundle)rb);
                                        NotificationTemplate notificationTemplate = new NotificationTemplate(notificationTemplateId, jsonObject);
                                        associatedTemplates.add(notificationTemplate);
                                    }
                                }
                                WFNotificationMacro macro = new WFNotificationMacro();
                                Hashtable<String, Serializable> macroDetailsMap = new Hashtable<String, Serializable>();
                                macroDetailsMap.put("requestId", requestId);
                                macroDetailsMap.put("triggerId", Long.valueOf(currentWorkFlow));
                                macroDetailsMap.put("adsmWorkFlowStatusID", Long.valueOf(WorkFlowUtil.WORKFLOW_STATUS_COMMITED));
                                macroDetailsMap.put("audit_info", audit_info);
                                macro.init(macroDetailsMap);
                                NotificationTrigger trigger = new NotificationTrigger(null, null, rb, loginId, (NotificationMacro)macro, "Workflow", null);
                                trigger.setNotificationTemplates(associatedTemplates);
                                trigger.start();
                            }
                            if (!(savePassword = PasswordUtil.getSavePasswordValue())) {
                                if (isResetPasswordAction) {
                                    wfviRequest.deletePasswordFromDBForResetPasswordAction();
                                }
                                if (objectCreationID != null) {
                                    ArrayList objectIndexIds = FcLayoutViewHandler.getObjectIndexIds((Long)objectCreationID);
                                    FcLayoutUpdateHandler.updatePwdInUserMgmtAction((ArrayList)objectIndexIds, null);
                                }
                            }
                            new PushNotificationTrigger(loginId, Long.valueOf(wFStatusId.longValue()), requestId, new JSONObject().put("NA", 1).put("REQUEST_ID", (Object)requestId), rb).start();
                        }
                    }
                    catch (RuntimeException e) {
                        e.printStackTrace();
                    }
                }
            } else {
                wfviRequest = new WFViewRequest(requestId, rb);
                if (additionalActionsSt == null) {
                    additionalActionsSt = "";
                }
                String exeTime = WorkFlowUtil.createWFRequestScheduleTask((Long)requestId, (String)WFExecutionValue, (Long)loginId, (String)comment, (Long)WorkFlowUtil.WORKFLOW_PRE_STAUS_EXECUTOR, (String)additionalActionsSt);
                if (WorkFlow.modifyRequestWorkflow((WFViewRequest)wfviRequest, (Long)loginId, (String)comment, (Integer)WorkFlowUtil.WORKFLOW_STATUS_SCHEDULED, (Integer)WorkFlowUtil.WORKFLOW_REQUEST_STAUS_OPEN)) {
                    WorkFlowUtil.scheduleSuccessiveTask((Long)requestId, (String)exeTime);
                    message = rb.getString("admp.workflow.viewrequest.statmsg.scheduled_success");
                    out.log(Level.INFO, "Sucussfully updated the WFRequestExecution audit entries for Executor");
                }
            }
        } else {
            out.log(Level.INFO, "Technician not having a permission to process the request");
            response.sendError(403);
        }
        ClientUtil.setStatusXMLElement(response, "success", message);
        return null;
    }

    public ActionForward checkObjectCount(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        String[] selectedSidList;
        String taskDetailsId;
        String selectedSid;
        boolean isReqMonitorFlow = true;
        Integer categoryId = 0;
        String emptyTaskId = new String();
        Long requestId = new Long(request.getParameter("requestId"));
        SelectQueryImpl reqMonitorFlowCheckQuery = new SelectQueryImpl(Table.getTable((String)"ADSMRequests"));
        Join join1 = new Join("ADSMRequests", "ADSMRequestDetails", new String[]{"REQUEST_ID"}, new String[]{"REQUEST_ID"}, 1);
        reqMonitorFlowCheckQuery.addJoin(join1);
        reqMonitorFlowCheckQuery.addSelectColumn(Column.getColumn(null, (String)"*"));
        reqMonitorFlowCheckQuery.setCriteria(new Criteria(Column.getColumn((String)"ADSMRequests", (String)"REQUEST_ID"), (Object)requestId, 0));
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)reqMonitorFlowCheckQuery);
            if (!dataObject.isEmpty()) {
                Row requestRow = dataObject.getRow("ADSMRequests");
                isReqMonitorFlow = (Boolean)requestRow.get("IS_REQ_MONITOR_FOLLOWED");
                Row reqDetailsRow = dataObject.getRow("ADSMRequestDetails");
                categoryId = (Integer)reqDetailsRow.get("CATEGORY");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (categoryId.equals(WorkFlowUtil.WF_CATEGORY_PERMISSION_MANAGEMENT)) {
            selectedSid = request.getParameter("selectedSid").toString();
            taskDetailsId = request.getParameter("taskDetailsId").toString();
            selectedSidList = selectedSid.split(",");
            String[] taskDetailsIdList = taskDetailsId.split(",");
            for (int i = 0; i < taskDetailsIdList.length; ++i) {
                try {
                    Long taskId = Long.parseLong(taskDetailsIdList[i]);
                    DataObject dObj = WorkFlowUtil.getCVCDataObject((Long)taskId);
                    Criteria c = new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"UNIQUE_ID"), (Object)selectedSidList, 9);
                    c = c.and(new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"REQ_MONITOR_TASK_ID"), (Object)taskId, 0));
                    c = c.and(new Criteria(Column.getColumn((String)"WFCVCDataSummary", (String)"IS_REMOVED"), (Object)false, 0));
                    Iterator it = dObj.getRows("WFCVCDataSummary", c);
                    if (it.hasNext()) continue;
                    if (emptyTaskId.length() != 0) {
                        emptyTaskId = emptyTaskId + ",";
                    }
                    emptyTaskId = emptyTaskId + taskId;
                    continue;
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        } else if (isReqMonitorFlow) {
            selectedSid = request.getParameter("selectedSid").toString();
            taskDetailsId = request.getParameter("taskDetailsId").toString();
            selectedSidList = selectedSid.split(",");
            String[] taskDetailsIdList = taskDetailsId.split(",");
            for (int i = 0; i < taskDetailsIdList.length; ++i) {
                int rowCount = 0;
                Long taskId = Long.parseLong(taskDetailsIdList[i]);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"REQMONITORTASKRESULTDETAILS"));
                Column col = Column.getColumn(null, (String)"*").count();
                Criteria c = new Criteria(Column.getColumn((String)"REQMONITORTASKRESULTDETAILS", (String)"OBJECT_GUID"), (Object)selectedSidList, 9);
                c = c.and(new Criteria(Column.getColumn((String)"REQMONITORTASKRESULTDETAILS", (String)"REQ_MONITOR_TASK_ID"), (Object)taskId, 0));
                query.addSelectColumn(col);
                query.setCriteria(c);
                rowCount = DBUtil.getCount((SelectQuery)query);
                if (rowCount != 0) continue;
                if (emptyTaskId.length() != 0) {
                    emptyTaskId = emptyTaskId + ",";
                }
                emptyTaskId = emptyTaskId + taskId;
            }
        } else {
            emptyTaskId = "false";
        }
        try {
            PrintWriter writer = response.getWriter();
            writer.print(emptyTaskId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward deleteWFResultRows(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        JSONObject jsonObject = new JSONObject(request.getParameter("selectedObjectGuid").toString());
        JSONArray selectedGuidList = jsonObject.getJSONArray("selectedSid");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = new Long(request.getParameter("requestId"));
        String wfTaskDetails = request.getParameter("wfTaskDetails");
        JSONObject wfTaskDetailsJson = new JSONObject(wfTaskDetails);
        String comments = wfTaskDetailsJson.getString("comments");
        String[] taskDetailsIdList = wfTaskDetailsJson.getString("taskDetailsId").split(",");
        String message = rb.getString("admp.workflow.workflow_result.text.successfully_removed_objects");
        for (int i = 0; i < taskDetailsIdList.length; ++i) {
            Long taskDetailsId = Long.parseLong(taskDetailsIdList[i]);
            out.log(Level.INFO, "Going the delete guid from request by " + loginId + " , for the  RequestId : " + requestId + " taskDetailsId : " + taskDetailsId + " Comments ::: " + comments);
            WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, taskDetailsId, loginId);
            auditActivities.updateBoardId();
            auditActivities.updateIsCSVImportActionType();
            auditActivities.setIsCVCRequest();
            auditActivities.setComments(comments);
            if (auditActivities.isCVCRequest().booleanValue()) {
                auditActivities.setAuditActivityType(WFRequestUtil.CVC_ROW_REMOVED);
            }
            Boolean isSuccess = auditActivities.updateAuditActivities(new JSONObject(), Long.valueOf(-1L), new JSONArray(), selectedGuidList);
            out.log(Level.INFO, "Delete object guid operation status : " + isSuccess + " currentWorkFlow status : " + auditActivities.getBoardId());
            if (isSuccess.booleanValue()) continue;
            message = rb.getString("admp.workflow.workflow_result.text.error_occurred_while_delete");
        }
        ClientUtil.setStatusXMLElement(response, "success", message);
        return null;
    }

    public ActionForward getDeletedObjectHistory(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
        Long requestId = new Long(request.getParameter("requestId"));
        Integer reportId = new Integer(request.getParameter("reportId"));
        Long reqActionId = new Long(request.getParameter("requestAction"));
        request.setAttribute("requestId", (Object)requestId);
        request.setAttribute("taskDetailsId", (Object)taskDetailsId);
        request.setAttribute("reportId", (Object)reportId);
        request.setAttribute("requestAction", (Object)reqActionId);
        return mapping.findForward("objectHistory");
    }

    public ActionForward getUserDetails(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        Long requestId = new Long(request.getParameter("requestId"));
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
        String forwardPage = "userDetails";
        WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
        wfViewRequest.updateWFTaskDetails();
        WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
        BusinessWorkflow businessWF = new BusinessWorkflow(requestId, loginId);
        request.setAttribute("WORKFLOW_STATUS", (Object)businessWF.getCurrentWorkFlowStatus());
        request.setAttribute("BusinessWorkflow", (Object)businessWF);
        request.setAttribute("taskDetailsId", (Object)taskDetailsId);
        try {
            HashMap resultMap = wfTask.getRequestUserCreationDetails();
            ArrayList taskInputDetails = wfTask.getUserDetailsInputs(rb);
            request.setAttribute("taskInputDetails", (Object)taskInputDetails);
            request.setAttribute("requestActionId", (Object)wfTask.getRequestActionId());
            request.setAttribute("requestId", (Object)requestId);
            Long userCreationID = wfTask.getUserCreationId();
            ArrayList creationStatusList = new ArrayList();
            if (wfTask.getRequestActionId().compareTo(WorkFlowUtil.MODIFY_USERATTIBUTES_ACTION_ID) == 0) {
                ArrayList attributeList = wfTask.getUserDetailsAttribList();
                ArrayList userDetailsList = AddUserHandler.getInstance().getUserDetailsList(userCreationID, attributeList);
                int attribSize = 0;
                attribSize = attributeList.size();
                request.setAttribute("attribSize", (Object)attribSize);
                request.setAttribute("userDetailsList", (Object)userDetailsList);
                Hashtable customAttributes = AddUserHandler.getInstance().getCustomAttributesList(userCreationID);
                request.setAttribute("customAttributes", (Object)customAttributes);
                ArrayList customAttributeList = new ArrayList();
                if (!customAttributes.isEmpty()) {
                    Enumeration enumeration = customAttributes.keys();
                    while (enumeration.hasMoreElements()) {
                        Object key = enumeration.nextElement();
                        Hashtable nameVsValues = (Hashtable)customAttributes.get(key);
                        if (nameVsValues.isEmpty()) continue;
                        Enumeration enumeration2 = nameVsValues.keys();
                        while (enumeration2.hasMoreElements()) {
                            Object object = enumeration2.nextElement();
                            if (customAttributeList.contains(object)) continue;
                            customAttributeList.add(object);
                        }
                    }
                }
                request.setAttribute("customAttributeList", customAttributeList);
                String[] resultAttributeArray = wfTask.getUserDetailsResultAttribList();
                ArrayList attribList = AddUserHandler.getInstance().getAttributeTableMap(resultAttributeArray);
                Hashtable<String, Object> hash1 = new Hashtable<String, Object>();
                hash1.put("RELATIONAL_TYPE", new Integer(0));
                hash1.put("ATTRIB_COLUMN_NAME", "CREATION_STATUS");
                hash1.put("ATTRIB_LDAP_NAME", "Creation Status");
                hash1.put("ATTRIB_DISP_NAME", "Creation Status");
                attribList.add(hash1);
                Hashtable<String, Object> hash2 = new Hashtable<String, Object>();
                hash2.put("RELATIONAL_TYPE", new Integer(0));
                hash2.put("ATTRIB_COLUMN_NAME", "CREATION_MESSAGE");
                hash2.put("ATTRIB_LDAP_NAME", "Status");
                hash2.put("ATTRIB_DISP_NAME", "admp.mgmt.common.text.status");
                attribList.add(hash2);
                creationStatusList = AddUserHandler.getInstance().getCreationStatus(userCreationID, attribList);
                if (creationStatusList != null && !creationStatusList.isEmpty()) {
                    ArrayList resultAttributeList = ReportAttributesUtil.getAttributeProps((String[])resultAttributeArray, (String)"ATTRIB_COLUMN_NAME", (String)"User");
                    request.setAttribute("resultAttributeList", (Object)resultAttributeList);
                    request.setAttribute("creationStatusList", (Object)creationStatusList);
                }
                forwardPage = "modifyUserDetails";
            } else {
                try {
                    Long templateCategoryId = null;
                    for (AdmpInput admpInput : wfTask.getInputList()) {
                        if (!admpInput.getName().equalsIgnoreCase("templateCategoryId")) continue;
                        templateCategoryId = new Long(admpInput.getValue());
                    }
                    FcBulkExecuteFormBean fcBulkExecuteFormBean = new FcBulkExecuteFormBean();
                    String domainName = (String)resultMap.get("DOMAIN_NAME");
                    String containerName = (String)resultMap.get("CONTAINER_NAME");
                    String templateName = (String)resultMap.get("TEMPLATE_NAME");
                    Long layoutId = (Long)resultMap.get("LAYOUT_ID");
                    if (templateName != null && templateName.equals("") && layoutId == -1L) {
                        layoutId = FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)false);
                        templateName = FcLayoutViewHandler.getLayoutName((Long)layoutId, null);
                    }
                    if (businessWF.getNextWorkflowStatus().compareTo(0) == 0 && (businessWF.getCurrentWorkFlowStatus() != WorkFlowUtil.WORKFLOW_STATUS_REJECTED || wfViewRequest.getRequestStatus() != WorkFlowUtil.WORKFLOW_REQUEST_STAUS_OPEN)) {
                        ArrayList objectStatusList = new ArrayList();
                        if (wfTask.getRequestActionId().compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0 || wfTask.getRequestActionId().compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0) {
                            objectStatusList = FcLayoutBulkViewHandler.getBulkMgmtStatusForExport((Long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (Long)userCreationID, null, (AdventNetResourceBundle)rb, (boolean)false);
                            ArrayList columnList = ColumnConfiguration.getColumnList((long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (int)2);
                            HashMap<Integer, Properties> mapList = new HashMap<Integer, Properties>();
                            int i = 0;
                            for (int k = 0; k < columnList.size(); ++k) {
                                Properties propList = new Properties();
                                HashMap map = (HashMap)columnList.get(k);
                                if (!((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkUserSingleVals") && !((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkObjectIndexDetails") && !((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkUserSelectContainerVals") && !((String)map.get("TABLE_NAME")).equalsIgnoreCase("FcBulkUserManagerVals")) continue;
                                propList.put((String)map.get("COL_NAME"), (String)map.get("COLUMN_NAME"));
                                mapList.put(i, propList);
                                ++i;
                            }
                            request.setAttribute("mapList", mapList);
                            request.setAttribute("objectStatusList", (Object)objectStatusList);
                        } else {
                            objectStatusList = FcLayoutBulkViewHandler.getBulkMgmtStatusForExport((Long)userCreationID);
                            request.setAttribute("objectStatusList", (Object)objectStatusList);
                        }
                        fcBulkExecuteFormBean.setTemplateCategoryId(templateCategoryId.toString());
                        request.setAttribute("templateCategoryId", (Object)templateCategoryId);
                        request.setAttribute("CONTAINER_NAME", (Object)"");
                    } else {
                        fcBulkExecuteFormBean.initBean(request, templateCategoryId.toString(), userCreationID, layoutId, domainName, false, true);
                        WorkFlowClientUtil.setUserDetailsRows(request, fcBulkExecuteFormBean, resultMap, rb, businessWF.getCurrentWorkFlowStatus(), taskDetailsId);
                        request.setAttribute("CONTAINER_NAME", (Object)containerName);
                    }
                    session.setAttribute("FcBulkExecuteFormBean", (Object)fcBulkExecuteFormBean);
                    request.setAttribute("DOMAIN_NAME", (Object)domainName);
                    request.setAttribute("TEMPLATE_NAME", (Object)rb.getString(templateName));
                    request.setAttribute("LAYOUT_ID", (Object)layoutId);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward applyTemplate(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        HttpSession session = request.getSession();
        String forwardPage = "userDetails";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Long templateId = new Long(request.getParameter("templateId"));
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            Long requestId = new Long(request.getParameter("requestId"));
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
            String workflowStatus = rb.getString((String)requestDetails.get("workflowStatus"));
            out.log(Level.INFO, " Workflow status " + workflowStatus + " Going to apply the template " + templateId + " by loginId : " + loginId);
            Long userCreationID = wfTask.getUserCreationId();
            out.log(Level.INFO, " WOrkflow Apply Template UserCreationId " + userCreationID + " RequestId " + requestId);
            HashMap resultMap = wfTask.getRequestUserCreationDetails();
            Long templateCategoryId = null;
            for (AdmpInput admpInput : wfTask.getInputList()) {
                if (!admpInput.getName().equalsIgnoreCase("templateCategoryId")) continue;
                templateCategoryId = new Long(admpInput.getValue());
            }
            String domainName = (String)resultMap.get("DOMAIN_NAME");
            String containerName = (String)resultMap.get("CONTAINER_NAME");
            Long layoutId = (Long)resultMap.get("LAYOUT_ID");
            FcBulkExecuteFormBean fcBulkExecuteFormBean = (FcBulkExecuteFormBean)session.getAttribute("FcBulkExecuteFormBean");
            fcBulkExecuteFormBean.setDefaultLayoutId(templateId);
            Long oldLayoutId = 1L;
            oldLayoutId = layoutId == -1L ? FcLayoutViewHandler.getDefaultLayoutId((Long)templateCategoryId, (boolean)false) : layoutId;
            String templateName = FcLayoutViewHandler.getLayoutName((Long)templateId, (AdventNetResourceBundle)rb);
            boolean status = FcBulkExecuteFormFlow.applyTemplateForBulkObjects(request, oldLayoutId, fcBulkExecuteFormBean);
            WorkFlowClientUtil.setUserDetailsRows(request, fcBulkExecuteFormBean, resultMap, rb, (Integer)requestDetails.get("WFStatus"), taskDetailsId);
            BusinessWorkflow businessWF = new BusinessWorkflow(requestId, loginId);
            request.setAttribute("BusinessWorkflow", (Object)businessWF);
            request.setAttribute("WORKFLOW_STATUS", requestDetails.get("WFStatus"));
            request.setAttribute("requestDetails", (Object)requestDetails);
            session.setAttribute("FcBulkExecuteFormBean", (Object)fcBulkExecuteFormBean);
            request.setAttribute("requestActionId", (Object)wfTask.getRequestActionId());
            request.setAttribute("DOMAIN_NAME", (Object)domainName);
            request.setAttribute("CONTAINER_NAME", (Object)containerName);
            request.setAttribute("TEMPLATE_NAME", (Object)rb.getString(templateName));
            request.setAttribute("requestId", (Object)requestId);
            request.setAttribute("LAYOUT_ID", (Object)templateId);
        }
        catch (Exception ex) {
            out.log(Level.INFO, "Exception occurred while apply template in workflow mode " + ex);
            ex.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward deleteUserCreationRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Long userRequestID = new Long(request.getParameter("Id"));
            WorkFlowUtil.deleteUserCreationRequest((Long)userRequestID);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    public ActionForward exportWFRequests(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        try {
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + "showAllUsersReport.xml";
            HttpSession session = request.getSession();
            String searchFilter = request.getParameter("searchFilter");
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            HashMap<String, String> inputParams = new HashMap<String, String>();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String genTime = DateTimeUtil.getDateFormat((Long)loginId).format(new Date(System.currentTimeMillis()));
            String fullName = rb.getString(WorkFlowUtil.getFullName((Long)loginId));
            inputParams.put("desc", MessageFormat.format(rb.getString("admp.workflow.export.description"), fullName));
            inputParams.put("date", genTime);
            inputParams.put("Description", rb.getString("admp.reports_export.pageheader.description"));
            ArrayList defaultColumnList = WFAttributeHandler.getInstance().getListReqDefaultColumnListProps(loginId);
            String reportType = request.getParameter("exportType");
            if (reportType == null) {
                reportType = "";
            }
            WorkFlowClientUtil.exportRequests(reportFileName, reportType, searchFilter, defaultColumnList, inputParams, request, response);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward exportData(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        System.out.println(" Export Data is started");
        try {
            Long requestId = new Long(request.getParameter("requestId"));
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            String reportType = request.getParameter("reportType");
            if (reportType == null) {
                reportType = "";
            }
            String basepath = request.getSession().getServletContext().getRealPath("/");
            String reportFileName = "";
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            HashMap<String, Object> inputParams = new HashMap<String, Object>();
            inputParams.put("loginId", loginId);
            ArrayList resultList = new ArrayList();
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            wfTask.setReportId();
            ArrayList attributelist = wfTask.getAttributeListForExport();
            Long requestAction = wfTask.getRequestActionId();
            if (requestAction != null && (requestAction.compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CREATE_GROUP_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CREATE_CONTACT_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.MODIFY_USER_ACTION_ID) == 0)) {
                HashMap resultMap = wfTask.getRequestUserCreationDetails();
                String domainName = (String)resultMap.get("DOMAIN_NAME");
                Long userCreationID = (Long)resultMap.get("USER_CREATION_ID");
                String containerName = (String)resultMap.get("CONTAINER_NAME");
                String workflowStatus = rb.getString((String)requestDetails.get("workflowStatus"));
                String status = (String)requestDetails.get("status");
                reportFileName = basepath + "jasper" + File.separator + "UserCreationStatus.jasper";
                inputParams.put("domainName", domainName);
                inputParams.put("domainText", rb.getString("admp.common.text.domain"));
                inputParams.put("userNameText", rb.getString("admp.common.attrib_disp_name.user_name"));
                inputParams.put("logonNameText", rb.getString("admp.common.attrib_disp_name.logon_name"));
                inputParams.put("passwordText", rb.getString("admp.common.attrib_disp_name.password"));
                inputParams.put("descriptionText", rb.getString("admp.common.attrib_disp_name.desc"));
                inputParams.put("groupTypeText", rb.getString("admp.common.attrib_disp_name.group_type"));
                inputParams.put("groupScopeText", rb.getString("admp.common.attrib_disp_name.group_scope"));
                inputParams.put("managerText", rb.getString("admp.common.attrib_disp_name.manager"));
                inputParams.put("ouNameText", rb.getString("admp.common.attrib_disp_name.ou_name"));
                inputParams.put("statusText", rb.getString("admp.common.text.status"));
                inputParams.put("isWorkFlow", true);
                inputParams.put("wfStatusText", rb.getString("admp.workflow.attrib_disp_name.workflow_status"));
                inputParams.put("wfStatus", workflowStatus);
                inputParams.put("reqStatusText", rb.getString("admp.workflow.attrib_disp_name.request_status"));
                inputParams.put("reqStatus", rb.getString(status));
                inputParams.put("requestIdText", rb.getString("admp.workflow.attrib_disp_name.requestid"));
                inputParams.put("requestId", wfViewRequest.getRequestId().toString());
                if (requestAction.compareTo(WorkFlowUtil.MODIFY_USER_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0 || requestAction.compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0) {
                    Properties prop = FcLayoutViewHandler.getObjectCreationIdDetails((Long)userCreationID);
                    containerName = (String)prop.get("CONTAINER_NAME");
                    resultList = FcLayoutBulkViewHandler.getBulkMgmtStatusForExport((Long)FcExecuteActionConstants.BUC_LAYOUT_VIEW_ID, (Long)userCreationID, (String)containerName, (AdventNetResourceBundle)rb);
                } else {
                    resultList = FcLayoutBulkViewHandler.getBulkMgmtStatusForExport((Long)userCreationID, (AdventNetResourceBundle)rb);
                }
                FcBulkExecuteFormAction.exportResults(reportFileName, reportType, resultList, inputParams, request, response);
            } else {
                String creationTime = (String)requestDetails.get("creationTime");
                String workflowStatus = rb.getString((String)requestDetails.get("workflowStatus"));
                String status = (String)requestDetails.get("status");
                HashMap updateInputDetails = wfTask.setActionInputValue(rb);
                reportFileName = "WFRequestDetails.xml";
                reportFileName = basepath + "jasperreports" + File.separator + "jrxml" + File.separator + reportFileName;
                inputParams.put("wfStatusText", rb.getString("admp.workflow.attrib_disp_name.workflow_status"));
                inputParams.put("wfStatus", workflowStatus);
                inputParams.put("reqStatusText", rb.getString("admp.workflow.attrib_disp_name.request_status"));
                inputParams.put("reqStatus", rb.getString(status));
                inputParams.put("createdByText", rb.getString("admp.workflow.attrib_disp_name.createdby"));
                inputParams.put("createdBy", rb.getString(WorkFlowUtil.getFullName((Long)loginId)));
                inputParams.put("subjectText", rb.getString("admp.workflow.attrib_disp_name.subject"));
                inputParams.put("subject", wfViewRequest.getSubject());
                inputParams.put("createdTimeText", rb.getString("admp.common.attrib_disp_name.cre_time"));
                inputParams.put("creationTime", creationTime);
                inputParams.put("domainTxt", rb.getString("admp.common.attrib_disp_name.domain_name"));
                inputParams.put("domain", wfViewRequest.getDomainName());
                inputParams.put("requestTypeText", rb.getString("admp.workflow.robo_requester.view_robo_requester.request_type"));
                inputParams.put("requestType", rb.getString(AutomationUtil.getActionName((Long)requestAction)));
                inputParams.put("inputDetailsText", rb.getString("admp.auto.auto_policy.view_policy.text.input_details"));
                inputParams.put("inputDetails", wfTask.getReqActionInputDisplayValue());
                inputParams.put("requestIdText", rb.getString("admp.workflow.attrib_disp_name.requestid"));
                inputParams.put("requestId", wfViewRequest.getRequestId().toString());
                Long count = wfTask.getReqActionResultCount();
                String tableKey = ReportsUtil.TABLE_KEY;
                if (wfTask.getRequestActionId().equals(WorkFlowUtil.REMOVE_O365_LICENSES_ID)) {
                    tableKey = "OBJECT_ID";
                }
                Hashtable multipleValuesSids = new Hashtable();
                if (count != null && count.intValue() != 0) {
                    ArrayList columnList = wfTask.getColumnList();
                    Integer attributeId = 0;
                    String sortColumnNameStr = request.getParameter("attributeId");
                    attributeId = sortColumnNameStr != null ? new Integer(sortColumnNameStr) : wfTask.getSortColumnId();
                    String sortingOrder = "true";
                    if (request.getParameter("ascending") != null) {
                        sortingOrder = request.getParameter("ascending");
                    }
                    resultList = wfTask.getRequestResult(attributelist, multipleValuesSids, attributeId, sortingOrder);
                    WFAttributeHandler.getInstance();
                    WFAttributeHandler.getMultipleValues((ArrayList)columnList, multipleValuesSids, (String)tableKey, null);
                    ReportResultUtil.getCustomizedO365Values(multipleValuesSids, rb);
                    ReportResultUtil.getCustomizedMultipleValues(multipleValuesSids);
                }
                WorkFlowClientUtil.export(reportFileName, reportType, attributelist, resultList, inputParams, request, response, multipleValuesSids);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println(" Export Data is finished");
        return null;
    }

    public ActionForward modifyAttribute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        boolean saveFlag = true;
        try {
            Long requestId = new Long(request.getParameter("requestId"));
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            String index = request.getParameter("index");
            String attribute = request.getParameter("attribute");
            String value = request.getParameter("value");
            HttpSession session = request.getSession();
            String tableName = "ADSMAUNamingAttributes";
            Long longIndex = new Long(index);
            UpdateQueryImpl updateQuery = new UpdateQueryImpl(tableName);
            Criteria criteria = new Criteria(new Column(tableName, "USER_INDEX"), (Object)longIndex, 0);
            updateQuery.setCriteria(criteria);
            updateQuery.setUpdateColumn(attribute, (Object)value);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update((UpdateQuery)updateQuery);
        }
        catch (Exception e) {
            saveFlag = false;
            e.printStackTrace();
        }
        if (saveFlag) {
            ClientUtil.setStatusXMLElement(response, "Success", "");
        } else {
            ClientUtil.setStatusXMLElement(response, "Error", "");
        }
        return null;
    }

    public ActionForward getSSPWFRequest(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "sspWFRequest";
        try {
            JSONObject attribute;
            Iterator it;
            Long requestId = new Long(request.getParameter("requestId"));
            Long taskDetailsId = new Long(request.getParameter("taskDetailsId"));
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(taskDetailsId);
            Hashtable<String, Object> requestProperties = new Hashtable<String, Object>();
            requestProperties.put("RANGE", new Integer(1));
            requestProperties.put("FROM_INDEX", 1L);
            requestProperties.put("ascending", "true");
            requestProperties.put("attributeId", wfTask.getSortColumnId());
            ArrayList columnList = wfTask.getColumnList();
            Hashtable multipleValuesSids = new Hashtable();
            ArrayList resultList = wfTask.getRequestResultRows(requestProperties, columnList, multipleValuesSids);
            if (resultList != null && !resultList.isEmpty()) {
                request.setAttribute("message", ((HashMap)resultList.get(0)).get(1101454));
            }
            AdmpInput admpInputDetails = (AdmpInput)wfTask.getInputList().get(0);
            int i = 0;
            JSONObject inputDetails = new JSONObject();
            String[] ldapName = new String[admpInputDetails.getMultipleInput().size()];
            for (FcOption admpDetails : admpInputDetails.getMultipleInput()) {
                ldapName[i++] = admpDetails.getLabel();
                inputDetails.put(admpDetails.getLabel(), (Object)admpDetails.getValue());
            }
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADMPObjects", new Criteria(Column.getColumn((String)"ADMPObjects", (String)"OBJECT_CLASS"), (Object)"user", 0));
            Row row = dataObject.getFirstRow("ADMPObjects");
            Integer startIndex = (Integer)row.get("START_ATTRIB_ID");
            Integer endIndex = (Integer)row.get("END_ATTRIB_ID");
            Criteria c = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_LDAP_NAME"), (Object)ldapName, 8);
            c = c.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)startIndex, 4));
            c = c.and(new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"ATTRIB_ID"), (Object)endIndex, 6));
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMAttributeDetails", c);
            JSONObject attributes = new JSONObject();
            LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
            if (!dataObject.isEmpty()) {
                it = dataObject.getRows("ADSMAttributeDetails");
                while (it.hasNext()) {
                    attribute = new JSONObject();
                    row = (Row)it.next();
                    attribute.put("ATTRIB_COLUMN_NAME", (Object)((String)row.get("ATTRIB_COLUMN_NAME")));
                    attribute.put("ATTRIB_DISP_NAME", (Object)((String)row.get("ATTRIB_DISP_NAME")));
                    attribute.put("TABLE_NAME", (Object)((String)row.get("TABLE_NAME")));
                    linkedHashSet.add((String)row.get("TABLE_NAME"));
                    attributes.put((String)row.get("ATTRIB_LDAP_NAME"), (Object)attribute);
                }
            }
            columnList = WFAttributeHandler.getInstance().getCommitColumnList(requestId);
            HashMap h = (HashMap)columnList.get(0);
            resultList = WorkFlowCommit.getReqMonitorTaskGUIDResult((Long)taskDetailsId, (Long)requestId, (ArrayList)columnList, (String)((String)h.get("TABLE_NAME")));
            HashMap result = new HashMap();
            if (resultList != null && !resultList.isEmpty()) {
                result = (HashMap)resultList.get(0);
                ArrayList tableList = new ArrayList(linkedHashSet);
                c = new Criteria(Column.getColumn((String)"ADSMUserGeneralDetails", (String)"OBJECT_GUID"), (Object)((String)result.get("OBJECT_GUID")), 0);
                for (String tableName : linkedHashSet) {
                    if (tableName.equalsIgnoreCase("ADSMUserGeneralDetails")) continue;
                    c = c.and(new Criteria(Column.getColumn((String)tableName, (String)"OBJECT_GUID"), (Object)((String)result.get("OBJECT_GUID")), 0));
                }
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableList, c);
                it = attributes.keys();
                while (it.hasNext()) {
                    attribute = attributes.getJSONObject((String)it.next());
                    row = dataObject.getFirstRow(attribute.getString("TABLE_NAME"));
                    attribute.put("ATTRIB_VALUE", row.get(attribute.getString("ATTRIB_COLUMN_NAME").toString()));
                }
            }
            request.setAttribute("inputDetails", (Object)inputDetails);
            request.setAttribute("actualDetails", (Object)attributes);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward(forwardPage);
    }

    public ActionForward getResultRowEditActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String objectIdStr = request.getParameter("objectId");
        Long objectId = Long.valueOf(objectIdStr);
        String reqTableName = request.getParameter("reqTableName");
        String reqColumnName = request.getParameter("reqColumnName");
        String subCategoryStr = request.getParameter("subCategory");
        Integer subCategory = Integer.parseInt(subCategoryStr);
        ArrayList editActions = WorkFlowUtil.getRequestRowEditActions((Integer)subCategory, (String)reqTableName, (String)reqColumnName, (Long)objectId, (Boolean)true);
        request.setAttribute("editActions", (Object)editActions);
        return mapping.findForward("editActions");
    }

    public ActionForward applyResultRowEditAtions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = rb.getString("admp.mgmt.common.statmsg.successfully_updated");
        String status = "Success";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String selectedActionsStr = request.getParameter("selectedActions");
            JSONObject selectedActions = new JSONObject(selectedActionsStr);
            String uniqueIdStr = request.getParameter("uniqueId");
            Long uniqueId = Long.valueOf(uniqueIdStr);
            String taskDetailsIdStr = request.getParameter("taskDetailsId");
            Long taskDetailsId = Long.valueOf(taskDetailsIdStr);
            String requestIdStr = request.getParameter("requestId");
            Long requestId = Long.valueOf(requestIdStr);
            ArrayList changedRows = WorkFlowUtil.updateRequestRowEditActions((JSONObject)selectedActions, (Long)uniqueId, (Long)taskDetailsId);
            if (!changedRows.isEmpty()) {
                WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, taskDetailsId, loginId);
                auditActivities.setAuditActivityType(WFRequestUtil.REQ_ROW_EDIT_ACTION_MODIFIED);
                auditActivities.updateBoardId();
                auditActivities.updateIsCSVImportActionType();
                auditActivities.setIsCVCRequest();
                JSONArray changesJSON = new JSONArray();
                for (Properties changesProp : changedRows) {
                    changesJSON.put((Object)changesProp);
                }
                auditActivities.updateAuditActivities(new JSONObject(), Long.valueOf(-1L), changesJSON, new JSONArray());
            }
        }
        catch (Exception e) {
            status = "Error";
            message = rb.getString("admp.workflow.view_request.fsm.error_in_modifying_the_request");
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, status, message);
        return null;
    }

    public ActionForward editAdditionalExecutionActions(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Long requestId = new Long(request.getParameter("requestId"));
        Long reqMonitorTaskId = new Long(request.getParameter("reqMonitorTaskId"));
        Long actionId = new Long(request.getParameter("actionId"));
        String valueStr = request.getParameter("value");
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = rb.getString("admp.mgmt.common.statmsg.successfully_updated");
        String status = "Success";
        try {
            String actionValue;
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ReqExeAdditionalActionDetails"));
            query.addJoin(new Join("ReqExeAdditionalActionDetails", "ReqExeAdditionalActions", new String[]{"ACTION_ID"}, new String[]{"ACTION_ID"}, 2));
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            Criteria c = new Criteria(Column.getColumn((String)"ReqExeAdditionalActionDetails", (String)"REQUEST_ID"), (Object)requestId, 0);
            c = c.and(new Criteria(Column.getColumn((String)"ReqExeAdditionalActionDetails", (String)"ACTION_ID"), (Object)actionId, 0));
            query.setCriteria(c);
            DataObject dObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)query);
            Row r = dObj.getFirstRow("ReqExeAdditionalActionDetails");
            Properties prop = new Properties();
            if (r != null && !valueStr.equals(actionValue = (String)r.get("ACTION_VALUE"))) {
                r.set("ACTION_VALUE", (Object)valueStr);
                dObj.updateRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dObj);
                Row actionRow = dObj.getFirstRow("ReqExeAdditionalActions");
                Properties auditProp = new Properties();
                auditProp.put("ACTION_NAME", (String)actionRow.get("INPUT_NAME"));
                auditProp.put("ACTION_ID", actionId);
                auditProp.put("OLD_ACTION_VALUE", actionValue);
                auditProp.put("NEW_ACTION_VALUE", valueStr);
                JSONArray changesJSON = new JSONArray();
                changesJSON.put((Object)auditProp);
                WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, reqMonitorTaskId, loginId);
                auditActivities.setAuditActivityType(WFRequestUtil.REQ_ADDITIONAL_EXE_ACTION_MODIFIED);
                auditActivities.updateBoardId();
                auditActivities.updateIsCSVImportActionType();
                auditActivities.setIsCVCRequest();
                auditActivities.updateAuditActivities(new JSONObject(), Long.valueOf(-1L), changesJSON, new JSONArray());
                if (actionId.equals(AdditionalExecutionActions.REVERT_PERMISSION_DURATION)) {
                    JSONObject durationJSON = new JSONObject(valueStr);
                    String selectedDuration = durationJSON.has("duration") ? durationJSON.getString("duration") : "";
                    String selectedDurationType = durationJSON.has("durationType") ? durationJSON.getString("durationType") : "";
                    prop.put("value", selectedDuration);
                    prop.put("valueType", selectedDurationType);
                    prop.put("valueText", WorkFlowUtil.getDurationDescription((String)valueStr, (AdventNetResourceBundle)rb));
                }
            }
            ClientUtil.setStatusXMLElement(response, status, message, prop);
        }
        catch (Exception e) {
            status = "Error";
            message = rb.getString("admp.workflow.view_request.fsm.error_in_modifying_the_request");
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward updateAssignee(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        String message = rb.getString("admp.mgmt.common.statmsg.successfully_updated");
        String status = "Success";
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            String requestIdStr = request.getParameter("requestId");
            Long requestId = Long.valueOf(requestIdStr);
            String assigneeIdStr = request.getParameter("assigneeId");
            if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
                Integer statusId;
                BusinessWorkflowRule bwf;
                Integer nextWorkFlow;
                HashMap requestDetails = WorkFlow.getRequestDetails((Long)requestId, (Long)loginId);
                Integer wFstatusId = (Integer)requestDetails.get("WFStatus");
                Long ruleId = (Long)requestDetails.get("ruleId");
                Long wFCount = (Long)requestDetails.get("WFCount");
                String[] assigneeIdList = assigneeIdStr.split(",");
                ArrayList<Properties> assigneeList = new ArrayList<Properties>();
                if (!assigneeIdList[0].equals("")) {
                    for (int i = 0; i < assigneeIdList.length; ++i) {
                        Properties props = new Properties();
                        props.setProperty("LOGIN_ID", assigneeIdList[i]);
                        assigneeList.add(props);
                    }
                }
                if ((nextWorkFlow = (bwf = BusinessWorkflowRule.getBusinessWorkflowRule((Long)ruleId)).getNextElement(wFstatusId, wFCount)).equals(statusId = wFstatusId)) {
                    wFstatusId = bwf.getPrevWFElementId(statusId);
                }
                WFAssigningRuleUtil.assignRequestToTechnician(assigneeList, (Long)requestId, (Long)0L, (Long)((Object)wFstatusId));
                WorkFlow.updateAssigneeAudit(assigneeList, (Long)requestId, (Integer)wFstatusId);
            }
        }
        catch (Exception e) {
            status = "Error";
            message = rb.getString("admp.workflow.view_request.fsm.error_in_modifying_the_request");
            e.printStackTrace();
        }
        ClientUtil.setStatusXMLElement(response, status, message);
        return null;
    }

    public ActionForward updateInputs(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String forwardPage = "";
        try {
            Long requestId = new Long(request.getParameter("requestId"));
            Long reqMonitorTaskId = new Long(request.getParameter("reqMonitorTaskId"));
            String paramName = request.getParameter("paramName");
            String paramValue = request.getParameter("paramValue");
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            WFViewRequest wfViewRequest = new WFViewRequest(requestId, rb);
            wfViewRequest.updateWFTaskDetails();
            WFTask wfTask = wfViewRequest.getWFTask(reqMonitorTaskId);
            wfTask.updateInputValues(paramName, paramValue);
            Long reqActionId = wfTask.getRequestActionId();
            String detailsString = request.getParameter("inputDetails");
            JSONObject detailsJson = new JSONObject(detailsString);
            String oldValue = detailsJson.getString("oldValue");
            JSONObject fieldChangesHistory = new JSONObject();
            fieldChangesHistory.put("filedName", (Object)rb.getString("admp.mgmt.fc_layout_common.text_container"));
            fieldChangesHistory.put("oldValue", (Object)oldValue);
            fieldChangesHistory.put("newValue", (Object)paramValue);
            WFTaskAuditActivities auditActivities = new WFTaskAuditActivities(requestId, wfTask.getReqMonitorTaskId(), loginId);
            auditActivities.updateBoardId();
            auditActivities.updateIsCSVImportActionType();
            if (reqActionId.compareTo(WorkFlowUtil.CREATE_USER_ACTION_ID) == 0 || reqActionId.compareTo(WorkFlowUtil.MODIFY_USER_ACTION_ID) == 0 || reqActionId.compareTo(WorkFlowUtil.CREATE_GROUP_ACTION_ID) == 0 || reqActionId.compareTo(WorkFlowUtil.CREATE_CONTACT_ACTION_ID) == 0 || reqActionId.compareTo(WorkFlowUtil.CREATE_BULK_USER_ACTION_ID) == 0) {
                auditActivities.setAuditActivityType(WFRequestUtil.TASK_OBJECT_ACTIVITY_TYPE);
                auditActivities.setAuditActivitySubType(WFRequestUtil.TASK_OBJECT_MODIFIED);
            } else if (Arrays.asList(WorkFlowUtil.MOVE_OBJECT_ACTION_IDS).contains(reqActionId)) {
                auditActivities.setAuditActivityType(WFRequestUtil.TASK_ACTIVITY_TYPE);
            }
            auditActivities.updateAuditActivities(fieldChangesHistory, Long.valueOf(-1L), new JSONArray(), new JSONArray());
            PrintWriter writer = response.getWriter();
            writer.print(paramValue);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public void isSuccessfullyExecuted(Long requestId, AdventNetResourceBundle rb, String status) {
        String message = rb.getString("admp.workflow.viewrequest.statmsg.executed_success");
        if (status.equalsIgnoreCase(message)) {
            Long scheduleTime = System.currentTimeMillis();
            WorkFlowUtil.checkForSuccessiveTask((Long)requestId, (Long)scheduleTime);
        }
    }
}

