/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.webclient.workflow;

import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.LicenseMgr;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUserHandler;
import com.adventnet.sym.adsm.common.server.workflow.WorkFlowUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.util.ArrayList;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONObject;

public class WorkFlowConfigAction
extends DispatchAction {
    public ActionForward requestersConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (request.getParameter("operation") != null && request.getParameter("operation").equalsIgnoreCase("save")) {
            Long requester = new Long(request.getParameter("requesters"));
            ArrayList requestTypeList = WorkFlowUtil.getAllRequestTypes(null, null);
            Long[] requestTypes = new Long[requestTypeList.size()];
            for (int i = 0; i < requestTypeList.size(); ++i) {
                requestTypes[i] = (Long)requestTypeList.get(i);
            }
            String message = "";
            message = LicenseMgr.getInstance().isModuleLicensed("Workflow") ? WorkFlowUserHandler.addRequester((Long)requester, (Long[])requestTypes) : "admp.workflow.common.license_error";
            if (!WorkFlowUserHandler.isReportsDelegated((Long)requester).booleanValue()) {
                message = "admp.workflow.requester.add_requester.warning.report_not_delegated";
            }
            request.setAttribute("message", (Object)rb.getString(message));
        } else if (request.getParameter("operation") != null && request.getParameter("operation").equalsIgnoreCase("delete")) {
            Long requester = new Long(request.getParameter("requesterId"));
            String message = WorkFlowUserHandler.removeRequester((Long)requester);
            request.setAttribute("message", (Object)rb.getString(message));
        }
        request.setAttribute("usersList", (Object)WorkFlowUserHandler.getHelpDeskUsersList((String)"HelpDeskUser"));
        request.setAttribute("requestersList", (Object)WorkFlowUserHandler.getRequesters());
        return mapping.findForward("workFlowUsers");
    }

    public ActionForward workFlowAdminConfig(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        if (ClientUtil.checkAuthorization(request, new long[]{8000L})) {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Boolean result = false;
            String messageType = "Error";
            String message = "";
            if (request.getParameter("operation") != null && request.getParameter("operation").equalsIgnoreCase("add")) {
                String workFlowAdminIds = request.getParameter("workFlowAdminIds");
                String adminType = request.getParameter("workFlowadminType");
                if (adminType != null) {
                    Boolean isLicensed;
                    Long boardId = 0L;
                    if (adminType.equalsIgnoreCase("approvers")) {
                        boardId = 3L;
                    }
                    if (adminType.equalsIgnoreCase("reviewers")) {
                        boardId = 2L;
                    }
                    if (adminType.equalsIgnoreCase("committers")) {
                        boardId = 4L;
                    }
                    if ((isLicensed = Boolean.valueOf(LicenseMgr.getInstance().isModuleLicensed("Workflow"))).booleanValue()) {
                        JSONObject json = new JSONObject(workFlowAdminIds);
                        Iterator itr = json.keys();
                        int count = 0;
                        int successCount = 0;
                        int errorCount = 0;
                        while (itr.hasNext()) {
                            ++count;
                            Long workFlowAdminId = Long.parseLong((String)itr.next());
                            if (WorkFlowUserHandler.isWorkflowTechnician((Long)boardId, (Long)workFlowAdminId).booleanValue()) continue;
                            result = WorkFlowUserHandler.addWorkFlowAdmin((Long)boardId, (Long)workFlowAdminId);
                            if (result.booleanValue()) {
                                ++successCount;
                                messageType = "Success";
                                continue;
                            }
                            ++errorCount;
                        }
                        message = count == 0 ? rb.getString("admp.reports.sche_report.share_scheduler.select_atleast_one_technician") : (successCount == 0 && errorCount != 0 ? rb.getString("admp.workflow.requestor.configurations_error_occurred") : (successCount == 0 ? rb.getString("admp.workflow.requestor.configurations_technician_exists") : (successCount == count ? rb.getString("admp.workflow.requestor.configurations_technicians_added_to_group") : rb.getString("admp.workflow.requestor.configurations_partial_technician_exists"))));
                    } else {
                        message = rb.getString("admp.workflow.common.license_error");
                    }
                }
            } else if (request.getParameter("operation") != null && request.getParameter("operation").equalsIgnoreCase("remove")) {
                String deleteIds = request.getParameter("deleteIds");
                String[] deleteId = deleteIds.split(",");
                Long[] loginId = new Long[deleteId.length];
                for (int i = 0; i < deleteId.length; ++i) {
                    loginId[i] = new Long(deleteId[i]);
                }
                String adminType = request.getParameter("workFlowadminType");
                if (adminType != null) {
                    Long boardId = 0L;
                    if (adminType.equalsIgnoreCase("approvers")) {
                        boardId = 3L;
                    }
                    if (adminType.equalsIgnoreCase("reviewers")) {
                        boardId = 2L;
                    }
                    if (adminType.equalsIgnoreCase("committers")) {
                        boardId = 4L;
                    }
                    if ((result = WorkFlowUserHandler.removeBoardMembers((Long)boardId, (Long[])loginId)).booleanValue()) {
                        messageType = "Success";
                        message = rb.getString("admp.workflow.requestor.configurations_technician_removed");
                    } else {
                        message = rb.getString("admp.workflow.requestor.configurations_error_occurred");
                    }
                }
            }
            ClientUtil.setStatusXMLElement(response, messageType, message);
        } else {
            response.sendError(403);
        }
        return null;
    }

    public ActionForward workFlowAdmins(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        if (ClientUtil.checkAuthorization(request, new long[]{8000L})) {
            request.setAttribute("approversList", (Object)WorkFlowUserHandler.getBoardMembers((Long)3L));
            request.setAttribute("reviewersList", (Object)WorkFlowUserHandler.getBoardMembers((Long)2L));
            request.setAttribute("committersList", (Object)WorkFlowUserHandler.getBoardMembers((Long)4L));
            request.setAttribute("usersList", (Object)ADMPUserHandler.getADMPUsers((AdventNetResourceBundle)rb, (String)"HelpDeskUser", null, null));
        } else {
            response.sendError(403);
        }
        return mapping.findForward("workFlowAdmins");
    }
}

