/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.mobilesso;

import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import com.adventnet.sym.adsm.mobilesso.TicketCache;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Logger;

public class TicketCacheImpl
implements TicketCache {
    private static Logger out = Logger.getLogger("TicketCacheImpl");
    protected static HashMap tickets = new HashMap();

    @Override
    public void init() {
        System.out.println("Ticket Cache Provider Init called");
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("AdmpMobileAuthTokens", (Criteria)null);
            if (dataObj != null && !dataObj.isEmpty()) {
                Iterator itr = dataObj.getRows("AdmpMobileAuthTokens");
                while (itr.hasNext()) {
                    Row r = (Row)itr.next();
                    String authToken = (String)r.get("AuthToken");
                    Long loginId = (Long)r.get("LoginId");
                    String loginName = (String)r.get("LoginName");
                    String hostName = (String)r.get("HostName");
                    Long validDate = (Long)r.get("ValidDate");
                    if (authToken == null) continue;
                    Ticket ticket = new Ticket(authToken);
                    ticket.setHostName(hostName);
                    ticket.setValidDate(validDate);
                    ticket.setLoginId(loginId);
                    ticket.setLoginName(loginName);
                    this.add(ticket);
                }
            }
        }
        catch (DataAccessException e) {
            e.printStackTrace();
        }
        System.out.println("Init in TicketCache Existing ticket size :" + tickets.size());
    }

    @Override
    public Ticket get(String ticket) {
        return (Ticket)tickets.get(ticket);
    }

    @Override
    public void add(Ticket t) {
        tickets.put(t.ticket, t);
    }

    @Override
    public void update(Ticket t) {
        tickets.put(t.ticket, t);
    }

    @Override
    public void delete(String ticket) {
        tickets.remove(ticket);
    }

    @Override
    public void close() {
    }
}

