/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.mobilesso;

import com.adventnet.authentication.Credential;
import com.adventnet.sym.adsm.common.server.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticatorForMobile;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.mobilesso.CommonUtil;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import java.util.Calendar;
import java.util.Collection;
import java.util.Date;
import java.util.Properties;
import java.util.UUID;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;

public class TicketGenerator {
    private String ticketId;
    private Ticket ticketObj;

    public String generateTicket(HttpServletRequest request, Credential cred) {
        this.ticketId = UUID.randomUUID().toString();
        this.ticketObj = new Ticket(this.ticketId);
        try {
            String appName = CommonUtil.getProductName();
            String appDN = CommonUtil.getApplicationDomainName();
            this.ticketObj.userId = cred.getUserId();
            this.ticketObj.loginId = cred.getLoginId();
            this.ticketObj.loginName = cred.getLoginName();
            this.ticketObj.roles = new JSONArray((Collection)cred.getRoles());
            if (cred.getDomainName() != null) {
                this.ticketObj.domainName = cred.getDomainName();
            }
            this.ticketObj.localeId = cred.getLocaleId();
            this.ticketObj.localeLanguage = cred.getUserLocale().getLanguage();
            this.ticketObj.localeCountry = cred.getUserLocale().getCountry();
            this.ticketObj.ticket = this.ticketId;
            this.ticketObj.applicationName = appName;
            this.ticketObj.hostName = cred.getHostName();
            this.ticketObj.ipAddress = request.getRemoteAddr();
            this.ticketObj.serviceName = cred.getServiceName();
            this.ticketObj.isValidTicket = true;
            if (this.ticketObj.domainName.equals("") || this.ticketObj.domainName.equals(appDN)) {
                this.ticketObj.isDomainAuthentication = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.ticketId;
    }

    public Ticket getTicketObject() {
        return this.ticketObj;
    }

    public String generateTicket(HttpServletRequest request, ADMPADAuthenticatorForMobile adAuthenticator) {
        this.ticketId = UUID.randomUUID().toString();
        this.ticketObj = new Ticket(this.ticketId);
        try {
            String appName = CommonUtil.getProductName();
            String appDN = CommonUtil.getApplicationDomainName();
            this.ticketObj.loginId = adAuthenticator.getLoginId();
            this.ticketObj.loginName = adAuthenticator.getLoginName();
            if (adAuthenticator.getDomainName() != null) {
                this.ticketObj.domainName = adAuthenticator.getDomainName();
            }
            String domainName = adAuthenticator.getDomainName();
            Long loginId = adAuthenticator.getLoginId();
            if (domainName.equals("ADManager Plus Authentication")) {
                if (HDTDomainHandler.getDomainNamesList((Long)loginId).isEmpty()) {
                    return this.ticketId;
                }
                domainName = (String)HDTDomainHandler.getDomainNamesList((Long)loginId).get(0);
            } else if (domainName != null && !domainName.equals("ADManager Plus Authentication")) {
                Properties domainProp = DomainUtil.getDomainDetails((String)domainName);
                domainName = domainProp.getProperty("DOMAIN_NAME");
            }
            Properties passwordProp = PolicyHandler.getPolicies((String)domainName, (Long)loginId);
            Integer passwordAge = new Integer(30);
            try {
                passwordAge = new Integer(passwordProp.getProperty("maxPwdAge"));
            }
            catch (Exception e) {
                // empty catch block
            }
            if (passwordAge <= 0) {
                passwordAge = new Integer(30);
            }
            Calendar c = Calendar.getInstance();
            c.setTime(new Date());
            c.add(5, passwordAge);
            this.ticketObj.localeLanguage = request.getLocale().getLanguage();
            this.ticketObj.localeCountry = request.getLocale().getCountry();
            this.ticketObj.ticket = this.ticketId;
            this.ticketObj.applicationName = appName;
            this.ticketObj.serviceName = adAuthenticator.getServiceName();
            this.ticketObj.setValidDate(c.getTimeInMillis());
            this.ticketObj.isValidTicket = true;
            if (this.ticketObj.domainName.equals("") || this.ticketObj.domainName.equals(appDN)) {
                this.ticketObj.isDomainAuthentication = false;
            }
            String mobileType = "";
            String isRestAPI = (String)request.getAttribute("IS_REST_API");
            String userAgent = request.getHeader("user-agent");
            mobileType = isRestAPI != null && isRestAPI.equals("true") ? "restAPI" : (userAgent != null && (userAgent.equals("ADMPAndroid") || userAgent.contains("Apache-HttpClient/UNAVAILABLE")) ? "android" : "iPhone");
            this.ticketObj.setMobileType(mobileType);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return this.ticketId;
    }
}

