/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.mobilesso;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.persistence.WritableDataObject;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPADAuthenticatorForMobile;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.mobilesso.CustomSSOConstants;
import com.adventnet.sym.adsm.mobilesso.Ticket;
import com.adventnet.sym.adsm.mobilesso.TicketCache;
import com.adventnet.sym.adsm.mobilesso.TicketCacheImpl;
import com.adventnet.sym.adsm.mobilesso.TicketGenerator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONArray;
import org.json.JSONObject;

public class TicketHandler
implements CustomSSOConstants {
    private static Logger out = Logger.getLogger("MobileApiFilter");
    private static TicketHandler ticketHandler = null;
    private static TicketCache ticketCache = null;
    private static TicketGenerator ticketGenerator = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TicketHandler getInstance() {
        Class<TicketHandler> clazz = TicketHandler.class;
        synchronized (TicketHandler.class) {
            if (ticketHandler == null) {
                ticketHandler = new TicketHandler();
                ticketCache = new TicketCacheImpl();
                ticketCache.init();
                ticketGenerator = new TicketGenerator();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            System.out.println(" Ticket Handler initialization finished ");
            return ticketHandler;
        }
    }

    public String generateTicket() {
        Long cT = System.currentTimeMillis();
        return cT.toString();
    }

    public Ticket getTicketFrmCache(String ticket) {
        return ticketCache.get(ticket);
    }

    private Ticket getJSONToTicket(JSONObject obj) {
        Ticket ticketObj = new Ticket();
        try {
            ticketObj.userId = obj.getLong("userId");
            ticketObj.loginId = obj.getLong("loginId");
            ticketObj.loginName = obj.getString("loginName");
            ticketObj.domainName = obj.getString("domainName");
            ticketObj.roles = new JSONArray(obj.getString("roles"));
            ticketObj.localeId = obj.getLong("localeId");
            ticketObj.localeLanguage = obj.getString("localeLanguage");
            ticketObj.localeCountry = obj.getString("localeCountry");
            ticketObj.ticket = obj.getString("ticket");
            ticketObj.applicationName = obj.getString("applicationName");
            ticketObj.serviceName = obj.getString("serviceName");
            ticketObj.hostName = obj.getString("hostName");
            ticketObj.ipAddress = obj.getString("ipAddress");
            ticketObj.isValidTicket = Boolean.parseBoolean(obj.getString("isValidTicket"));
            ticketObj.isDomainAuthentication = Boolean.parseBoolean(obj.getString("isDomainAuthentication"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ticketObj;
    }

    public JSONObject getTicketToJSON(Ticket ticketObj) {
        JSONObject jsonObj = new JSONObject();
        try {
            jsonObj.put("userId", (Object)ticketObj.userId);
            jsonObj.put("loginId", (Object)ticketObj.loginId);
            jsonObj.put("loginName", (Object)ticketObj.loginName);
            jsonObj.put("domainName", (Object)ticketObj.domainName);
            jsonObj.put("roles", (Object)ticketObj.roles);
            jsonObj.put("localeId", (Object)ticketObj.localeId);
            jsonObj.put("localeLanguage", (Object)ticketObj.localeLanguage);
            jsonObj.put("localeCountry", (Object)ticketObj.localeCountry);
            jsonObj.put("ticket", (Object)ticketObj.ticket);
            jsonObj.put("applicationName", (Object)ticketObj.applicationName);
            jsonObj.put("hostName", (Object)ticketObj.hostName);
            jsonObj.put("ipAddress", (Object)ticketObj.ipAddress);
            jsonObj.put("serviceName", (Object)ticketObj.serviceName);
            jsonObj.put("isValidTicket", ticketObj.isValidTicket);
            jsonObj.put("isDomainAuthentication", ticketObj.isDomainAuthentication);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Ticket setTicket(HttpServletRequest request, HttpServletResponse response, ADMPADAuthenticatorForMobile adAuthenticator) {
        Ticket ticketObj = null;
        try {
            Class<TicketHandler> clazz = TicketHandler.class;
            synchronized (TicketHandler.class) {
                String authToken = ticketGenerator.generateTicket(request, adAuthenticator);
                ticketObj = ticketGenerator.getTicketObject();
                ticketCache.add(ticketObj);
                System.out.println(" Ticket Cache Added AuthToken " + ticketObj.getTicket());
                WritableDataObject d = new WritableDataObject();
                Row r = new Row("AdmpMobileAuthTokens");
                r.set("AuthToken", (Object)authToken);
                r.set("LoginId", (Object)ticketObj.loginId);
                r.set("LoginName", (Object)ticketObj.loginName);
                r.set("MobileType", (Object)ticketObj.getMobileType());
                r.set("ValidDate", (Object)ticketObj.getValidDate());
                d.addRow(r);
                CommonUtil.getPersistence((boolean[])new boolean[0]).update((DataObject)d);
                System.out.println(" Added one entry AdmpMobileAuthTokens table AuthToken " + ticketObj.getTicket() + " LoginId " + ticketObj.getLoginId() + " LoginName " + ticketObj.getLoginName());
                // ** MonitorExit[var5_5] (shouldn't be in output)
            }
        }
        catch (Exception e) {
            out.log(Level.WARNING, "", e);
        }
        {
            return ticketObj;
        }
    }

    public void updateTicket(Ticket ticketObj) {
        ticketCache.update(ticketObj);
    }

    public void removeTicket(String ticket) {
        if (ticket != null) {
            ticketCache.delete(ticket);
            try {
                Criteria cri = new Criteria(Column.getColumn((String)"AdmpMobileAuthTokens", (String)"AuthToken"), (Object)ticket, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(cri);
            }
            catch (DataAccessException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println(" Unable to remove ticket :" + ticket + " This should not happen ");
        }
    }
}

