/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient;

import com.adventnet.authentication.PasswordException;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.iam.security.UploadedFileItem;
import com.adventnet.persistence.Row;
import com.adventnet.start.StartupUtil;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.admin.constants.AdminConfigConstants;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mail.SendMailAPI;
import com.adventnet.sym.adsm.common.server.o365.OMPIntegrationHandler;
import com.adventnet.sym.adsm.common.server.sms.SendSMSAPI;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.HelpdeskUtil;
import com.adventnet.sym.adsm.common.server.util.I18NUtil;
import com.adventnet.sym.adsm.common.server.util.MailServerUtil;
import com.adventnet.sym.adsm.common.server.util.PasswordUtil;
import com.adventnet.sym.adsm.common.server.util.SMSServerUtil;
import com.adventnet.sym.adsm.common.server.util.SchedulerUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientAuthorizationUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import com.adventnet.sym.adsm.common.webclient.util.SchedulerInputsUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.model.TemplateBean;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import com.manageengine.ads.fw.authentication.tfa.ADSTFAHandler;
import com.manageengine.ads.fw.authentication.tfa.TFABaseAuthenticator;
import com.manageengine.ads.fw.instanotification.InstaNotificationHandler;
import com.manageengine.ads.fw.mail.MailHandler;
import com.manageengine.o365.server.admin.ProductHandler;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;
import org.apache.struts.action.DynaActionForm;
import org.apache.struts.actions.DispatchAction;
import org.json.JSONArray;
import org.json.JSONObject;

public class ChangePasswordAction
extends DispatchAction {
    private static Logger logger = Logger.getLogger(ChangePasswordAction.class.getName());

    public ActionForward showPersonalisePopUp(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            Integer time;
            Locale buildLocale;
            Locale locale = request.getLocale();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            Hashtable timeZoneProps = DateTimeUtil.getTimeZoneList((HttpServletRequest)request);
            String dateFormats = "\"MM/dd/yy\", \"MM/dd/yyyy\", \"MMM dd, yy\", \"MMMM dd, yyyy\", \"dd-MMM-yy\", \"yyyy-MM-dd\", \"yyyy/MM/dd\", \"M/d/yy\", \"EEEE, MMMM dd, yyyy\", \"EEE MMM, dd yyyy\"";
            String timeFormats = "\"HH:mm\", \"hh:mm a\", \"HH:mm:ss\", \"HH:mm z\", \"h:mm a\", \"H:mm\", \"h:mm:ss a\", \"hh:mm:ss a\", \"H:mm:ss\"";
            Properties prop = ADSMPersUtil.getLocaleSettings();
            ArrayList labelList = (ArrayList)prop.get("labelList");
            ArrayList<String> localeDisplayName = new ArrayList<String>();
            for (int z = 0; z < labelList.size(); ++z) {
                String localeName = rb.getString((String)labelList.get(z));
                localeDisplayName.add(localeName);
            }
            Long localeId = I18NUtil.getClientLocaleId((Long)loginId);
            if (localeId == -1L && (buildLocale = I18NUtil.getLocale((Long)(localeId = I18NUtil.getBuildLocaleId()))).toLanguageTag().equalsIgnoreCase("en-US")) {
                localeId = 0L;
            }
            Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
            request.setAttribute("timeZoneList", timeZoneProps.get("timeZoneList"));
            request.setAttribute("timeZoneDispList", timeZoneProps.get("timeZoneDispList"));
            request.setAttribute("dateFormats", (Object)dateFormats);
            request.setAttribute("timeFormats", (Object)timeFormats);
            request.setAttribute("localeName", localeDisplayName);
            request.setAttribute("localeIds", prop.get("valueList"));
            request.setAttribute("localeId", (Object)localeId);
            if (!props.isEmpty()) {
                request.setAttribute("usertimezone", (Object)((String)props.get("timeZone")));
                request.setAttribute("userdateformat", (Object)((String)props.get("dateFormat")));
                request.setAttribute("usertimeformat", (Object)((String)props.get("timeFormat")));
            }
            Row row = ADSMPersUtil.getUserAccountSettings((Long)loginId);
            String[] times = new String[]{rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_ten_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fifteen_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_thirty_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fortyfive_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_one_hr"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_two_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_three_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_four_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_five_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_never")};
            String[] times_min = new String[]{"10", "15", "30", "45", "60", "120", "180", "240", "300", "never"};
            if (row != null) {
                Integer timeout = (Integer)row.get("SESSION_EXPIRY_TIME");
                time = timeout / 60;
            } else {
                time = request.getSession().getMaxInactiveInterval();
                time = time / 60;
            }
            String finalTime = time.toString();
            for (int i = 0; i < times.length; ++i) {
                if (time == -1) {
                    request.setAttribute("SESSION_EXPIRY_TIME", (Object)rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_never"));
                    continue;
                }
                if (!finalTime.equalsIgnoreCase(times_min[i])) continue;
                request.setAttribute("SESSION_EXPIRY_TIME", (Object)times[i]);
            }
            request.setAttribute("times", (Object)times);
            Row userRow = ADSMPersUtil.getUserPersonalSettings((Long)loginId);
            if (userRow != null) {
                request.setAttribute("encodingformat", (Object)((String)userRow.get("ENCODING_FORMAT")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return mapping.findForward("PersonaliseSettings");
    }

    public ActionForward savePersonaliseSettings(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            String exportFilePwd;
            Locale locale = request.getLocale();
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            if (CommonUtil.isDemo()) {
                JSONObject jsonObj = new JSONObject();
                jsonObj.put("resMsg", (Object)rb.getString("admp.common.text.this_option_disable_for_online_demo"));
                response.setContentType("application/json");
                PrintWriter writer = response.getWriter();
                writer.print(jsonObj.toString());
                return null;
            }
            String resMsg = "";
            Boolean isPasswordUpdated = Boolean.TRUE;
            Boolean isSessionUpdated = Boolean.TRUE;
            Boolean isTimeZoneUpdated = Boolean.TRUE;
            Boolean isReload = Boolean.FALSE;
            String passwordErrorMsg = "";
            String sessionErrorMsg = "";
            String timeZoneErrorMsg = "";
            String loginName = request.getUserPrincipal().getName();
            String oldpass = request.getParameter("oldpasswd");
            String newpass = request.getParameter("newpasswd");
            String timeZone = request.getParameter("timeZone");
            String dateFormat = request.getParameter("dateformat");
            String timeFormat = request.getParameter("timeformat");
            Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
            if (!(oldpass == null || oldpass.equals("-") || oldpass.equals("") || newpass == null || newpass.equals("-") || newpass.equals(""))) {
                try {
                    this.changePassword(loginName, oldpass, newpass);
                    resMsg = resMsg + rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd");
                    String isPasswordChanged = ADSMPersUtil.getSyMParameter((String)"IS_PASSWORD_CHANGED");
                    if (isPasswordChanged.equals("false")) {
                        ADSMPersUtil.updateSyMParameter((String)"IS_PASSWORD_CHANGED", (String)"true");
                    }
                }
                catch (Exception ex) {
                    resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.error_to_update_your_settings");
                    String message = ex.getMessage();
                    if (message.equalsIgnoreCase("Old password specified does not match")) {
                        message = rb.getString("admp.admin.gen_settgs.person.statmsg.old_password_specified_does_not_match");
                    }
                    passwordErrorMsg = passwordErrorMsg + message;
                    isPasswordUpdated = Boolean.FALSE;
                    logger.log(Level.WARNING, "Exception while changing the password", ex);
                }
            }
            if (ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SESSION_ACTION_ID).booleanValue()) {
                Row userSettingsRow = ADSMPersUtil.getUserAccountSettings((Long)loginId);
                if (userSettingsRow == null) {
                    userSettingsRow = new Row("UserSettings");
                    userSettingsRow.set("USER_ACCOUNT_ID", (Object)loginId);
                }
                String[] times = new String[]{rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_ten_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fifteen_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_twenty_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_twenty_five_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_thirty_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fortyfive_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_one_hr"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_two_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_three_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_four_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_five_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_never")};
                String[] times_min = new String[]{"10", "15", "20", "25", "30", "45", "60", "120", "180", "240", "300", "never"};
                String time = request.getParameter("SESSION_EXPIRY_TIME");
                for (int i = 0; i < times.length; ++i) {
                    if (!time.equalsIgnoreCase(times[i])) continue;
                    time = times_min[i];
                }
                int timeout = 0;
                timeout = time.equals("never") ? -60 : new Integer(time) * 60;
                try {
                    Integer currentTimeOut = (Integer)userSettingsRow.get("SESSION_EXPIRY_TIME");
                    if (currentTimeOut == null || currentTimeOut != timeout) {
                        userSettingsRow.set("SESSION_EXPIRY_TIME", (Object)timeout);
                        request.getSession().setMaxInactiveInterval(timeout);
                        ADSMPersUtil.addOrUpdateUserAccountSettings((Row)userSettingsRow);
                        resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_settings");
                    }
                }
                catch (Exception ex) {
                    String message;
                    sessionErrorMsg = message = ex.getMessage();
                    isSessionUpdated = Boolean.FALSE;
                }
            }
            if (ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.PERSONALIZE_ACTION_ID).booleanValue()) {
                String encodingformat;
                Long localeId;
                Locale buildLocale;
                Long currentLocaleId;
                if (!(props.get("timeZone").equals(timeZone) && props.get("dateFormat").equals(dateFormat) && props.get("timeFormat").equals(timeFormat))) {
                    if (ChangePasswordAction.checkFormatPattern(dateFormat, timeFormat)) {
                        DateTimeUtil.updateDateTimeFormats((Long)loginId, (String)timeZone, (String)dateFormat, (String)timeFormat);
                        resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_settings");
                    } else {
                        timeZoneErrorMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.invalid_date_time_format");
                        isTimeZoneUpdated = Boolean.FALSE;
                    }
                }
                if ((currentLocaleId = I18NUtil.getClientLocaleId((Long)loginId)) == -1L && (buildLocale = I18NUtil.getLocale((Long)(currentLocaleId = I18NUtil.getBuildLocaleId()))).toLanguageTag().equalsIgnoreCase("en-US")) {
                    currentLocaleId = 0L;
                }
                if (!currentLocaleId.equals(localeId = new Long(request.getParameter("localeId")))) {
                    ADSMPersUtil.updateLocaleId((Long)loginId, (Long)localeId);
                    Locale newLocale = null;
                    newLocale = localeId != null ? I18NUtil.getLocale((Long)localeId, (HttpServletRequest)request) : request.getLocale();
                    OMPIntegrationHandler.setUserLocale((Long)loginId, (Locale)newLocale);
                    session.setAttribute("USER_LOCALE", (Object)newLocale);
                    resMsg = "reload";
                    isReload = Boolean.TRUE;
                }
                if ((encodingformat = request.getParameter("encodingformat")) != null && !encodingformat.equals("-")) {
                    Row userRow = ADSMPersUtil.getUserPersonalSettings((Long)loginId);
                    String oldEncoding = null;
                    if (userRow != null) {
                        oldEncoding = (String)userRow.get("ENCODING_FORMAT");
                    }
                    if (!oldEncoding.equalsIgnoreCase(encodingformat)) {
                        ADSMPersUtil.updateEncodingFormat((Long)loginId, (String)encodingformat);
                    }
                }
            }
            if ((exportFilePwd = request.getParameter("exportFilePwd")) != null && !exportFilePwd.equals("")) {
                ADMPUserHandler.setUserPersonalDetails((Long)loginId, (String)"EXPORT_PASSWORD", (String)exportFilePwd);
                if (loginId.equals(CommonUtil.ADMIN_LOGIN_ID)) {
                    PasswordUtil.setExportFilePassword((String)exportFilePwd);
                }
            }
            if (!(isPasswordUpdated.booleanValue() && isSessionUpdated.booleanValue() && isTimeZoneUpdated.booleanValue() || isReload.booleanValue())) {
                resMsg = timeZoneErrorMsg + sessionErrorMsg + passwordErrorMsg;
            }
            if (resMsg.equals("")) {
                resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_settings");
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("resMsg", (Object)resMsg);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static int readInt(InputStream is, int noOfBytes, boolean bigEndian) throws IOException {
        int ret = 0;
        int sv = bigEndian ? (noOfBytes - 1) * 8 : 0;
        int cnt = bigEndian ? -8 : 8;
        for (int i = 0; i < noOfBytes; ++i) {
            ret |= is.read() << sv;
            sv += cnt;
        }
        return ret;
    }

    public static void validateMimeType(InputStream is) throws IOException {
        int c1 = is.read();
        int c2 = is.read();
        int c3 = is.read();
        String mimeType = null;
        int width = -1;
        int height = -1;
        if (c1 == 71 && c2 == 73 && c3 == 70) {
            is.skip(3L);
            width = ChangePasswordAction.readInt(is, 2, false);
            height = ChangePasswordAction.readInt(is, 2, false);
            mimeType = "image/gif";
        } else if (c1 == 255 && c2 == 216) {
            while (c3 == 255) {
                int marker = is.read();
                int len = ChangePasswordAction.readInt(is, 2, true);
                if (marker == 192 || marker == 193 || marker == 194) {
                    is.skip(1L);
                    height = ChangePasswordAction.readInt(is, 2, true);
                    width = ChangePasswordAction.readInt(is, 2, true);
                    mimeType = "image/jpeg";
                    break;
                }
                is.skip(len - 2);
                c3 = is.read();
            }
        } else if (c1 == 137 && c2 == 80 && c3 == 78 || c1 == 137 && c2 == 80 && c3 == 65) {
            is.skip(15L);
            width = ChangePasswordAction.readInt(is, 2, true);
            is.skip(2L);
            height = ChangePasswordAction.readInt(is, 2, true);
            mimeType = "image/png";
        }
        if (mimeType == null) {
            throw new IOException("Unsupported image type");
        }
    }

    public ActionForward showPersonalisePage(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String option = request.getParameter("selectedTile");
        String tile = "";
        try {
            DynaActionForm personaliseForm = (DynaActionForm)actionform;
            String loginName = request.getUserPrincipal().getName();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties domainDetails = HelpdeskUtil.getLoginUserDetails((Long)loginId);
            String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
            logger.log(Level.INFO, "The account Id : " + loginId + " for the login NAme " + loginName);
            if (option.equalsIgnoreCase("ServerSettings")) {
                String showlogonto;
                String showRememberPassword;
                if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SERVER_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                tile = "ServerSettings";
                request.setAttribute("SMS_SETTINGS", (Object)SMSServerUtil.getSMSSettings());
                JSONObject mailProp = MailServerUtil.getMailServerSettings();
                request.setAttribute("mailProp", (Object)mailProp);
                request.setAttribute("LAUNCH_DEFAULT_BROWSER", (Object)new Boolean(this.getDefaultClientSettings()));
                request.setAttribute("START_SERVER_ON_BOOTUP", (Object)new Boolean(this.isStartServerOnBootup()));
                boolean hidePasswordValue = PasswordUtil.getShowPasswordValue();
                request.setAttribute("HIDE_PASSWORD", (Object)hidePasswordValue);
                String licenseExpiry = ADSMPersUtil.getSyMParameter((String)"LICENSE_EXPIRY");
                if (licenseExpiry == null) {
                    licenseExpiry = "true";
                }
                request.setAttribute("LICENSE_EXPIRY", (Object)new Boolean(licenseExpiry));
                request.setAttribute("LOG_LEVEL", (Object)ADSMPersUtil.getCurrentLogLevel());
                String upgradeNotif = ADSMPersUtil.getSyMParameter((String)"UpgradeNotification");
                if (upgradeNotif == null) {
                    upgradeNotif = "true";
                }
                request.setAttribute("UpgradeNotification", (Object)new Boolean(upgradeNotif));
                request.setAttribute("ServerSettings", (Object)"true");
                String instaNotif = ADSMPersUtil.getSyMParameter((String)"InstaNotification");
                if (instaNotif == null) {
                    instaNotif = "true";
                }
                request.setAttribute("InstaNotification", (Object)new Boolean(instaNotif));
                String showInstaNotifTypes = ADSMPersUtil.getSyMParameter((String)"SHOW_INSTA_NOTIFY_TYPES");
                if (showInstaNotifTypes == null) {
                    showInstaNotifTypes = "false";
                }
                request.setAttribute("SHOW_INSTA_NOTIFY_TYPES", (Object)new Boolean(showInstaNotifTypes));
                JSONArray allNotifyTypes = InstaNotificationHandler.getAllNotificationTypes();
                JSONObject notifyStatus = new JSONObject();
                JSONArray requiredNotifyTypes = new JSONArray();
                for (int i = 0; i < allNotifyTypes.length(); ++i) {
                    JSONObject notifyObj = allNotifyTypes.getJSONObject(i);
                    if (!notifyObj.has("NOTIFICATION_PARENT_NAME")) continue;
                    notifyStatus.put(notifyObj.getString("ID"), notifyObj.getBoolean("IS_ENABLED"));
                    requiredNotifyTypes.put((Object)notifyObj);
                }
                request.setAttribute("INSTA_NOTIFICATION_TYPES", (Object)requiredNotifyTypes);
                request.setAttribute("INSTA_NOTIFICATION_TYPES_STATUS", (Object)notifyStatus);
                String showForgetPassword = ADSMPersUtil.getSyMParameter((String)"showForgetPassword");
                if (showForgetPassword == null) {
                    showForgetPassword = "true";
                }
                if ((showRememberPassword = ADSMPersUtil.getSyMParameter((String)"showRememberPassword")) == null) {
                    showRememberPassword = "true";
                }
                if ((showlogonto = ADSMPersUtil.getSyMParameter((String)"showLogonToOption")) == null) {
                    showlogonto = "true";
                }
                request.setAttribute("SHOW_FORGOT_PASSWORD", (Object)new Boolean(showForgetPassword));
                request.setAttribute("REMEMBER_ME", (Object)new Boolean(showRememberPassword));
                request.setAttribute("LOG_ON_TO", (Object)new Boolean(showlogonto));
                request.setAttribute("THEME", (Object)ADSMPersUtil.getSyMParameter((String)"THEME"));
            } else if (option.equalsIgnoreCase("ConnectionSettings")) {
                Integer time;
                if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.CONNECTION_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                tile = "ConnectionSettings";
                Row row = ADSMPersUtil.getUserAccountSettings((Long)loginId);
                String[] times = new String[]{rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_ten_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fifteen_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_thirty_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fortyfive_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_one_hr"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_two_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_three_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_four_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_five_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_never")};
                String[] times_min = new String[]{"10", "15", "30", "45", "60", "120", "180", "240", "300", "never"};
                if (row != null) {
                    Integer timeout = (Integer)row.get("SESSION_EXPIRY_TIME");
                    String timing = timeout.toString();
                    time = timeout / 60;
                } else {
                    time = request.getSession().getMaxInactiveInterval();
                    System.out.println("exp time::" + time);
                    time = time / 60;
                }
                String finalTime = time.toString();
                for (int i = 0; i < times.length; ++i) {
                    if (time == -1) {
                        personaliseForm.set("SESSION_EXPIRY_TIME", (Object)rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_never"));
                        continue;
                    }
                    if (!finalTime.equalsIgnoreCase(times_min[i])) continue;
                    personaliseForm.set("SESSION_EXPIRY_TIME", (Object)times[i]);
                }
                personaliseForm.set("times", (Object)times);
                personaliseForm.set("PORT_NUMBER", (Object)new Integer(SDInstallUtil.getWebServerPort()));
                boolean enableSSL = ADSMPersUtil.checkSSL();
                personaliseForm.set("enableSSL", (Object)enableSSL);
                Integer sslPort = new Integer(SDInstallUtil.getSSLPort());
                if (sslPort != -1) {
                    System.out.println("SSL Port is Open:");
                    personaliseForm.set("SSLPortNo", (Object)sslPort);
                } else if (sslPort == -1) {
                    System.out.println("SSL Port is Closed:");
                    sslPort = new Integer(SDInstallUtil.getSSLPortForWebServerPort((int)SDInstallUtil.getWebServerPort()));
                    personaliseForm.set("SSLPortNo", (Object)sslPort);
                }
                String enableLDAPSSL = ADSMPersUtil.checkLDAPSSL();
                if (enableLDAPSSL == null) {
                    enableLDAPSSL = "true";
                    ADSMPersUtil.updateSyMParameter((String)"LdapSSL", (String)enableLDAPSSL);
                }
                personaliseForm.set("enableLDAPSSL", (Object)enableLDAPSSL);
            } else if (option.equalsIgnoreCase("PersonaliseSettings")) {
                String saveTFA;
                Locale buildLocale;
                if (!ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.PERSONALIZE_ACTION_ID).booleanValue()) {
                    throw new Exception(rb.getString("admp.mgmt.common.statmsg.access_denied"));
                }
                tile = "PersonaliseSettings";
                Hashtable timeZoneProps = DateTimeUtil.getTimeZoneList((HttpServletRequest)request);
                String dateFormats = "\"MM/dd/yy\", \"MM/dd/yyyy\", \"MMM dd, yy\", \"MMMM dd, yyyy\", \"dd-MMM-yy\", \"yyyy-MM-dd\", \"yyyy/MM/dd\", \"M/d/yy\", \"EEEE, MMMM dd, yyyy\", \"EEE MMM, dd yyyy\"";
                String timeFormats = "\"HH:mm\", \"hh:mm a\", \"HH:mm:ss\", \"HH:mm z\", \"h:mm a\", \"H:mm\", \"h:mm:ss a\", \"hh:mm:ss a\", \"H:mm:ss\"";
                personaliseForm.set("timeZoneList", timeZoneProps.get("timeZoneList"));
                personaliseForm.set("timeZoneDispList", timeZoneProps.get("timeZoneDispList"));
                personaliseForm.set("dateFormats", (Object)dateFormats);
                personaliseForm.set("timeFormats", (Object)timeFormats);
                Properties prop = ADSMPersUtil.getLocaleSettings();
                ArrayList labelList = (ArrayList)prop.get("labelList");
                ArrayList<String> localeDisplayName = new ArrayList<String>();
                for (int z = 0; z < labelList.size(); ++z) {
                    String localeName = rb.getString((String)labelList.get(z));
                    localeDisplayName.add(localeName);
                }
                personaliseForm.set("localeName", localeDisplayName);
                personaliseForm.set("localeIds", prop.get("valueList"));
                Long localeId = I18NUtil.getUserLocaleId((Long)loginId);
                if (localeId == -1L && (buildLocale = I18NUtil.getLocale((Long)(localeId = I18NUtil.getBuildLocaleId()))).toLanguageTag().equalsIgnoreCase("en-US")) {
                    localeId = 0L;
                }
                personaliseForm.set("localeId", (Object)localeId);
                personaliseForm.set("THEME", (Object)ADSMPersUtil.getSyMParameter((String)"THEME"));
                String showForgetPassword = ADSMPersUtil.getSyMParameter((String)"showForgetPassword");
                if (showForgetPassword != null && showForgetPassword.equalsIgnoreCase("false")) {
                    personaliseForm.set("showForgetPassword", (Object)false);
                } else {
                    ADSMPersUtil.updateSyMParameter((String)"showForgetPassword", (String)"true");
                    personaliseForm.set("showForgetPassword", (Object)true);
                }
                String showRememberPassword = ADSMPersUtil.getSyMParameter((String)"showRememberPassword");
                if (showRememberPassword != null && showRememberPassword.equalsIgnoreCase("false")) {
                    personaliseForm.set("showRememberPassword", (Object)false);
                } else {
                    ADSMPersUtil.updateSyMParameter((String)"showRememberPassword", (String)"true");
                    personaliseForm.set("showRememberPassword", (Object)true);
                }
                Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
                Properties exProps = new Properties();
                if (!props.isEmpty()) {
                    personaliseForm.set("timeZone", (Object)((String)props.get("timeZone")));
                    personaliseForm.set("DATEFORMAT", (Object)((String)props.get("dateFormat")));
                    personaliseForm.set("TIMEFORMAT", (Object)((String)props.get("timeFormat")));
                }
                if ((saveTFA = request.getParameter("saveTFA")) != null && saveTFA.equalsIgnoreCase("true")) {
                    try {
                        JSONObject json = new JSONObject();
                        String modeId = request.getParameter("modeId");
                        String modeName = request.getParameter("modeName");
                        String className = ADSTFAHandler.getTFAClassName((String)modeName);
                        prop = CommonUtil.getUserDetails((Long)loginId);
                        Long userId = (Long)prop.get("USER_ID");
                        TFABaseAuthenticator tfaClassImpl = (TFABaseAuthenticator)CommonUtil.createClassInstance((String)className);
                        JSONObject responseJson = tfaClassImpl.validate(userId, request, response, Boolean.TRUE);
                        String statusMessage = rb.getString("admp.admin.tfa.tfa_successfully_updated");
                        Boolean isValidCode = Boolean.FALSE;
                        if (responseJson.has("IS_VALID") && (isValidCode = Boolean.valueOf(responseJson.getBoolean("IS_VALID"))).booleanValue()) {
                            JSONObject secretjson = TFABaseAuthenticator.getKey((Long)userId);
                            String secretKey = "";
                            if (secretjson.has("KEY")) {
                                secretKey = (String)secretjson.get("KEY");
                            }
                            if (modeName.equals("TFA_MAIL_AUTHENTICATOR")) {
                                secretKey = (String)secretjson.get("VALUE");
                            }
                            ADSTFAHandler.enrollUser((Long)userId, (String)modeId, (String)secretKey);
                            ADSTFAHandler.enrollTFAMode((Long)userId, (String)modeName);
                            json.put("RefreshSelfUpdateTFAView", (Object)isValidCode);
                        }
                        if (!isValidCode.booleanValue()) {
                            statusMessage = rb.getString("ads.authentication.tfa.invalid_code");
                        }
                        json.put("statusMessage", (Object)statusMessage);
                        json.put("SetTFASelfUpdateStatus", (Object)isValidCode);
                        json.put("USER_ID", (Object)userId);
                        request.setAttribute("RESPONSE_JSON", (Object)json);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            } else if (option.equalsIgnoreCase("NTServiceSettings")) {
                tile = "NTServiceSettings";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.log(Level.WARNING, "Exception while loading personalise page", e);
            throw new Exception("Exception while loading personalise page");
        }
        logger.log(Level.FINE, "Forwarding to Personalise");
        return actionmapping.findForward(tile);
    }

    public ActionForward personalise(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String option = request.getParameter("selectedTile");
        StringBuffer buf = new StringBuffer();
        String tile = "";
        try {
            HttpSession session = request.getSession();
            TemplateBean bean = (TemplateBean)((Object)session.getAttribute("TemplateBean"));
            ServletContext context = session.getServletContext();
            DynaActionForm personaliseForm = (DynaActionForm)actionform;
            boolean update = false;
            Row userSettingsRow = null;
            String loginName = request.getUserPrincipal().getName();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            Properties domainDetails = HelpdeskUtil.getLoginUserDetails((Long)loginId);
            String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
            userSettingsRow = ADSMPersUtil.getUserAccountSettings((Long)loginId);
            if (userSettingsRow == null) {
                userSettingsRow = new Row("UserSettings");
                userSettingsRow.set("USER_ACCOUNT_ID", (Object)loginId);
            }
            if (option.equalsIgnoreCase("PersonaliseSettings")) {
                String themeDb;
                tile = "PersonaliseSettings";
                String theme = (String)personaliseForm.get("THEME");
                if (!theme.equals(themeDb = ADSMPersUtil.getSyMParameter((String)"THEME"))) {
                    ADSMPersUtil.updateSyMParameter((String)"THEME", (String)theme);
                    request.setAttribute("themeMessage", (Object)MessageFormat.format(rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_theme"), theme));
                }
                context.setAttribute("selectedTheme", (Object)theme);
                personaliseForm.set("THEME", (Object)theme);
            }
            if (option.equalsIgnoreCase("ConnectionSettings")) {
                String ldapssl;
                tile = "ConnectionSettings";
                if (ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.SESSION_ACTION_ID).booleanValue()) {
                    String[] times = new String[]{rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_ten_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fifteen_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_twenty_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_twenty_five_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_thirty_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_fortyfive_mins"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_one_hr"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_two_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_three_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_four_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_five_hours"), rb.getString("admp.admin.gen_settgs.connection.text.session_expiry_never")};
                    String[] times_min = new String[]{"10", "15", "20", "25", "30", "45", "60", "120", "180", "240", "300", "never"};
                    String time = personaliseForm.get("SESSION_EXPIRY_TIME").toString();
                    for (int i = 0; i < times.length; ++i) {
                        if (!time.equalsIgnoreCase(times[i])) continue;
                        time = times_min[i];
                    }
                    int timeout = 0;
                    timeout = time.equals("never") ? -60 : new Integer(time) * 60;
                    try {
                        userSettingsRow.set("SESSION_EXPIRY_TIME", (Object)timeout);
                        request.getSession().setMaxInactiveInterval(timeout);
                        request.setAttribute("sessionexpirymessage", (Object)"0");
                        ADSMPersUtil.addOrUpdateUserAccountSettings((Row)userSettingsRow);
                    }
                    catch (Exception ex) {
                        String message = ex.getMessage();
                        request.setAttribute("sessionexpirymessage", (Object)message);
                        logger.log(Level.WARNING, "Exception while setting the session expiry time ", ex);
                    }
                    System.out.println("Changing Connection settings");
                }
                if (ClientAuthorizationUtil.isAuthorized(request, AdminConfigConstants.PORT_ACTION_ID).booleanValue()) {
                    boolean formSSL;
                    boolean dbSSL;
                    int currentPort = SDInstallUtil.getWebServerPort();
                    int newPort = (Integer)personaliseForm.get("PORT_NUMBER");
                    logger.log(Level.INFO, "New port value: " + newPort + "  currPort: " + currentPort);
                    if (currentPort != newPort) {
                        int result = SDInstallUtil.changeWebServerPort((int)newPort);
                        if (result == 0) {
                            request.setAttribute("portsettingsmessage", (Object)"0");
                        } else if (result == 1) {
                            request.setAttribute("portsettingsmessage", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.port_already_in_use_some_other_port"));
                        } else if (result == 3) {
                            request.setAttribute("portsettingsmessage", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.port_out_of_range_provide_valid_port"));
                        }
                    }
                    if ((dbSSL = ADSMPersUtil.checkSSL()) != (formSSL = ((Boolean)personaliseForm.get("enableSSL")).booleanValue())) {
                        if (formSSL) {
                            int sslPortNo = (Integer)personaliseForm.get("SSLPortNo");
                            System.out.println("enableSSL is changed to:" + formSSL + "with port no" + sslPortNo);
                            ADSMPersUtil.updateSyMParameter((String)"SSL", (String)"true");
                            ADSMPersUtil.enableSSLPort((int)sslPortNo);
                        } else {
                            System.out.println("enableSSL is changed to:" + formSSL);
                            ADSMPersUtil.updateSyMParameter((String)"SSL", (String)"false");
                            ADSMPersUtil.disableSSLPort();
                        }
                        request.setAttribute("Securitymessage", (Object)"0");
                    } else if (dbSSL && formSSL) {
                        int currentSSLPort = SDInstallUtil.getSSLPort();
                        int newSSLPort = (Integer)personaliseForm.get("SSLPortNo");
                        System.out.println("Changing SSL port to: " + newSSLPort + "from:" + currentSSLPort);
                        if (currentSSLPort != newSSLPort) {
                            int result = SDInstallUtil.changeSSLPort((int)newSSLPort);
                            if (result == 0) {
                                request.setAttribute("Securitymessage", (Object)"0");
                            } else if (result == 1) {
                                request.setAttribute("Securitymessage", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.port_already_in_use_some_other_port"));
                            } else if (result == 3) {
                                request.setAttribute("Securitymessage", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.port_out_of_range_provide_valid_port"));
                            }
                        }
                    }
                    String keystorePassword = request.getParameter("keystorePass");
                    String pwdMacro = "${admp.keystorePass}";
                    if (request.getParameter("ENABLE_ENCRYPTION") != null) {
                        logger.log(Level.INFO, "Updating keystore password");
                        ADSMPersUtil.setEncryptedKeyStorePassword((String)keystorePassword);
                        ADSMPersUtil.updateSyMParameter((String)"IS_ENCRYPTION_ENABLED", (String)"true");
                        ADSMPersUtil.setKeyStorePassword((String)"..\\conf\\Server.xml", (String)pwdMacro);
                    } else {
                        ADSMPersUtil.updateSyMParameter((String)"IS_ENCRYPTION_ENABLED", (String)"false");
                        pwdMacro = ADSMPersUtil.getEncryptedKeyStorePassword();
                        String keystorePassInXML = ADSMPersUtil.getKeyStorePassword((String)"..\\conf\\Server.xml");
                        if (keystorePassInXML != null && keystorePassInXML.equals("${admp.keystorePass}")) {
                            ADSMPersUtil.setKeyStorePassword((String)"..\\conf\\Server.xml", (String)pwdMacro);
                        }
                    }
                }
                if ((ldapssl = (String)personaliseForm.get("enableLDAPSSL")) != null) {
                    logger.log(Level.INFO, "Updating LDAPs to " + ldapssl);
                    ADSMPersUtil.updateSyMParameter((String)"LdapSSL", (String)ldapssl);
                    request.setAttribute("LDAPS", (Object)"0");
                }
            }
            if (option.equalsIgnoreCase("ServerSettings")) {
                tile = "ServerSettings";
                try {
                    String smsParam;
                    String serverParams;
                    String notificationParamsStr;
                    String mailParam = request.getParameter("mailParams");
                    if (mailParam != null && !mailParam.equals("")) {
                        ArrayList filesList;
                        String newLogLevel;
                        String oldLogLevel;
                        JSONObject mailParams = new JSONObject(mailParam);
                        boolean clientSetting = this.getDefaultClientSettings();
                        boolean clientSettingCurrVal = (Boolean)mailParams.get("LAUNCH_DEFAULT_BROWSER");
                        logger.log(Level.INFO, "Current clientSetting : " + clientSetting);
                        logger.log(Level.INFO, "UI clientSetting : " + (Boolean)personaliseForm.get("LAUNCH_DEFAULT_BROWSER"));
                        if (clientSetting != clientSettingCurrVal) {
                            this.clientSettings(clientSettingCurrVal);
                            buf.append(" " + rb.getString("admp.admin.gen_settgs.server.statmsg.general"));
                            request.setAttribute("generalsettingsmessage", (Object)rb.getString("admp.admin.gen_settgs.server.statmsg.successfully_updated_general_settings"));
                        }
                        boolean startServerCurrVal = this.isStartServerOnBootup();
                        boolean startServerNewVal = (Boolean)mailParams.get("START_SERVER_ON_BOOTUP");
                        logger.log(Level.INFO, "Curr val Server start : " + startServerCurrVal + " & New value : " + startServerNewVal);
                        if (startServerCurrVal != startServerNewVal) {
                            this.setServerStartOnBootup(startServerNewVal);
                            request.setAttribute("generalsettingsmessage", (Object)rb.getString("admp.admin.gen_settgs.server.statmsg.successfully_updated_general_settings"));
                            if (buf.length() == 0) {
                                buf.append(" " + rb.getString("admp.admin.gen_settgs.server.statmsg.general"));
                            }
                        }
                        boolean currentValueBool = (Boolean)mailParams.get("HIDE_PASSWORD");
                        boolean initialValue = PasswordUtil.getShowPasswordValue();
                        if (initialValue != currentValueBool) {
                            ADSMPersUtil.updateSyMParameter((String)"HIDE_PASSWORD", (String)String.valueOf(currentValueBool));
                        }
                        request.setAttribute("generalsettingsmessage", (Object)rb.getString("admp.admin.gen_settgs.server.statmsg.successfully_updated_general_settings"));
                        JSONObject modifiedProperty = this.setMailProps(mailParams);
                        boolean isUpdated = MailServerUtil.setMailServerSettings((JSONObject)modifiedProperty);
                        if (isUpdated) {
                            ADSMPersUtil.updateSyMParameter((String)"IS_SMTP_SERVER_CONFIGURED", (String)"true");
                            if (buf.length() == 0) {
                                buf.append(" " + rb.getString("admp.admin.gen_settgs.server.statmsg.mail_server"));
                            } else {
                                buf.append(", " + rb.getString("admp.admin.gen_settgs.server.statmsg.mail_server"));
                            }
                        }
                        if (!(oldLogLevel = ADSMPersUtil.getCurrentLogLevel()).equalsIgnoreCase(newLogLevel = (String)mailParams.get("LOG_LEVEL"))) {
                            ADSMPersUtil.changeLogLevel((String)newLogLevel);
                            ProductHandler.updateLoggerSettings((String)newLogLevel);
                            request.setAttribute("loglevelmessage", (Object)rb.getString("admp.admin.gen_settgs.server.statmsg.suceesfully_updated_log_level_settings"));
                            if (buf.length() == 0) {
                                buf.append(" " + rb.getString("admp.admin.gen_settgs.server.statmsg.log_level"));
                            } else {
                                buf.append(", " + rb.getString("admp.admin.gen_settgs.server.statmsg.log_level"));
                            }
                        }
                        UploadedFileItem uploadedFileItem = null;
                        if (request.getAttribute("MULTIPART_FORM_REQUEST") != null && (filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST")).size() > 0) {
                            uploadedFileItem = (UploadedFileItem)filesList.get(0);
                            File file = uploadedFileItem.getUploadedFile();
                            String fileName = null;
                            String logoPath = null;
                            Integer imageWidth = -1;
                            Integer imageHeight = -1;
                            if (file != null) {
                                FileInputStream is = new FileInputStream(file);
                                ChangePasswordAction.validateMimeType(is);
                            }
                            if (file != null) {
                                fileName = uploadedFileItem.getFileName();
                            }
                            if (fileName != null && !fileName.equals("")) {
                                logoPath = ChangePasswordAction.storeFile(fileName, file, request);
                                Properties p = ClientUtil.getImageDimension(logoPath, 200, 45);
                                imageWidth = (Integer)p.get("ImageWidth");
                                imageHeight = (Integer)p.get("ImageHeight");
                                p.put("LogoName", logoPath);
                                String imgPath = "images/logos/" + fileName;
                                ClientUtil.updateLogoImage(imgPath, imageWidth.toString(), imageHeight.toString());
                                if (buf.length() == 0) {
                                    buf.append(" " + rb.getString("admp.admin.gen_settgs.server.statmsg.change_logo"));
                                } else {
                                    buf.append(", " + rb.getString("admp.admin.gen_settgs.server.statmsg.change_logo"));
                                }
                            }
                        }
                    }
                    if ((notificationParamsStr = request.getParameter("notificationParams")) != null && !notificationParamsStr.equals("")) {
                        JSONObject notificationParams = new JSONObject(notificationParamsStr);
                        Boolean licenseExpiry = (Boolean)notificationParams.get("LICENSE_EXPIRY");
                        String currentLicenseExpiryStr = ADSMPersUtil.getSyMParameter((String)"LICENSE_EXPIRY");
                        boolean currLicenseExpiry = new Boolean(currentLicenseExpiryStr);
                        logger.log(Level.INFO, "The licenseExpiry " + licenseExpiry + " and currLicenseExpiry is " + currLicenseExpiry);
                        if (currLicenseExpiry != licenseExpiry || currentLicenseExpiryStr == null) {
                            ADSMPersUtil.updateSyMParameter((String)"LICENSE_EXPIRY", (String)licenseExpiry.toString());
                            SchedulerUtil.enableDisableTaskByName((String)"LicenseExpiryTask", (Boolean)licenseExpiry);
                            if (buf.length() == 0) {
                                buf.append(" " + rb.getString("admp.admin.server_settings.notification_settings.tab_name"));
                            }
                        }
                        Boolean upgradeNotif = (Boolean)notificationParams.get("UpgradeNotification");
                        String currentUpgradeNotifStr = ADSMPersUtil.getSyMParameter((String)"UpgradeNotification");
                        boolean currUpgradeNotif = new Boolean(currentUpgradeNotifStr);
                        logger.log(Level.INFO, "The updateNotif " + upgradeNotif + " and currUpdateNotif is " + currUpgradeNotif);
                        if (currUpgradeNotif != upgradeNotif || currentUpgradeNotifStr == null) {
                            ADSMPersUtil.updateSyMParameter((String)"UpgradeNotification", (String)upgradeNotif.toString());
                            SchedulerUtil.enableDisableTaskByName((String)"UpgradeNotificationTask", (Boolean)upgradeNotif);
                            if (buf.length() == 0) {
                                buf.append(" " + rb.getString("admp.admin.server_settings.notification_settings.tab_name"));
                            }
                        }
                        Boolean instaNotif = (Boolean)notificationParams.get("InstaNotification");
                        String currentInstaNotifStr = ADSMPersUtil.getSyMParameter((String)"InstaNotification");
                        boolean currInstaNotif = new Boolean(currentInstaNotifStr);
                        logger.log(Level.INFO, "The instaNotif " + instaNotif + " and currInstaNotif is " + currInstaNotif);
                        if (currInstaNotif != instaNotif || currentInstaNotifStr == null) {
                            ADSMPersUtil.updateSyMParameter((String)"InstaNotification", (String)instaNotif.toString());
                            SchedulerUtil.enableDisableTaskByName((String)"InstaNotificationTask", (Boolean)instaNotif);
                            if (buf.length() == 0) {
                                buf.append(" " + rb.getString("admp.admin.server_settings.notification_settings.tab_name"));
                            }
                        }
                        JSONObject mailObj = MailServerUtil.getNotificationSettings();
                        JSONObject oldNotifyStatus = (JSONObject)mailObj.get("INSTA_NOTIFICATION_TYPES_STATUS");
                        JSONObject updatedNotifyStatus = (JSONObject)notificationParams.get("INSTA_NOTIFICATION_TYPES_STATUS");
                        Iterator itStr = updatedNotifyStatus.keys();
                        while (itStr.hasNext()) {
                            boolean updatedNotifyValue;
                            String notifyId = (String)itStr.next();
                            boolean oldNotifyValue = oldNotifyStatus.getBoolean(notifyId);
                            if (oldNotifyValue == (updatedNotifyValue = updatedNotifyStatus.getBoolean(notifyId))) continue;
                            InstaNotificationHandler.updateNotificationTypeDetails((JSONObject)updatedNotifyStatus);
                            break;
                        }
                    }
                    if ((serverParams = request.getParameter("serverParams")) != null && !serverParams.equals("")) {
                        JSONObject serverJSON = new JSONObject(serverParams);
                        Boolean forgotpassword = (Boolean)serverJSON.get("SHOW_FORGOT_PASSWORD");
                        Boolean rememberme = (Boolean)serverJSON.get("REMEMBER_ME");
                        Boolean logonto = (Boolean)serverJSON.get("LOG_ON_TO");
                        String theme = (String)serverJSON.get("THEME");
                        String[] jsonSymKeys = new String[]{"SHOW_FORGOT_PASSWORD", "REMEMBER_ME", "LOG_ON_TO"};
                        String[] symKeys = new String[]{"showForgetPassword", "showRememberPassword", "showLogonToOption"};
                        for (int i = 0; i < jsonSymKeys.length; ++i) {
                            String symValue;
                            String jsonSymKey = String.valueOf(serverJSON.getBoolean(jsonSymKeys[i]));
                            if (jsonSymKey.equalsIgnoreCase(symValue = ADSMPersUtil.getSyMParameter((String)symKeys[i]))) continue;
                            ADSMPersUtil.updateSyMParameter((String)symKeys[i], (String)jsonSymKey);
                            if (buf.length() != 0) continue;
                            buf.append(" " + rb.getString("admp.admin.custom_settgs.heading_general_settings"));
                        }
                        String themeDb = ADSMPersUtil.getSyMParameter((String)"THEME");
                        if (!theme.equals(themeDb)) {
                            ADSMPersUtil.updateSyMParameter((String)"THEME", (String)theme);
                            if (buf.length() == 0) {
                                buf.append(" " + MessageFormat.format(rb.getString("admp.admin.gen_settgs.person.statmsg.theme"), theme));
                            } else {
                                buf.append(", " + MessageFormat.format(rb.getString("admp.admin.gen_settgs.person.statmsg.theme"), theme));
                            }
                        }
                        context.setAttribute("selectedTheme", (Object)theme);
                    }
                    if ((smsParam = request.getParameter("smsParams")) != null && !smsParam.equals("")) {
                        JSONObject smsSettings = new JSONObject(smsParam);
                        SMSServerUtil.setSMSSettings((JSONObject)smsSettings);
                        if (buf.length() == 0) {
                            buf.append(" " + rb.getString("admp.admin.server_settings.sms_settings.succesfully_updated"));
                        } else {
                            buf.append(", " + rb.getString("admp.admin.server_settings.sms_settings.succesfully_updated"));
                        }
                    }
                    if (buf.length() != 0) {
                        buf.append(".");
                        buf.insert(0, rb.getString("admp.admin.gen_settgs.server.statmsg.successfully_updated_the_following_settings"));
                    } else {
                        buf.append(rb.getString("admp.admin.gen_settgs.server.statmsg.successfully_update_the_following_settings"));
                    }
                    request.setAttribute("errorMessage", (Object)buf.toString());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    request.setAttribute("errorMessage", (Object)e.getMessage());
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while personalising ", e);
            throw new Exception("Exception while personalising");
        }
        return this.showPersonalisePage(actionmapping, actionform, request, response);
    }

    public static String storeFile(String fileName, File formfile, HttpServletRequest request) throws Exception {
        String imageDir = System.getProperty("user.dir") + File.separator + ".." + File.separator + "webapps" + File.separator + "adsm" + File.separator + "images" + File.separator + "logos";
        FileOutputStream fout = null;
        File saveFile = null;
        try {
            Object file;
            int count;
            FileInputStream fileInputStream = null;
            UploadedFileItem uploadedFileItem = null;
            File file1 = new File(fileName);
            FileOutputStream os = new FileOutputStream(file1);
            FileInputStream is = new FileInputStream(formfile);
            byte[] buf = new byte[4096];
            while ((count = ((InputStream)is).read(buf)) > -1) {
                ((OutputStream)os).write(buf, 0, count);
            }
            ((InputStream)is).close();
            ((OutputStream)os).close();
            if (request.getAttribute("MULTIPART_FORM_REQUEST") != null) {
                ArrayList filesList = (ArrayList)request.getAttribute("MULTIPART_FORM_REQUEST");
                uploadedFileItem = (UploadedFileItem)filesList.get(0);
                file = uploadedFileItem.getUploadedFile();
                fileInputStream = new FileInputStream((File)file);
            } else {
                fileInputStream = new FileInputStream(formfile);
            }
            FileInputStream fileInput = fileInputStream;
            file = new byte[((InputStream)fileInput).available()];
            ((InputStream)fileInput).read((byte[])file);
            File saveDir = new File(imageDir);
            if (!saveDir.exists()) {
                saveDir.mkdirs();
            }
            saveFile = new File(imageDir + File.separator + fileName);
            fout = new FileOutputStream(saveFile);
            fout.write((byte[])file);
            fout.close();
            return saveFile.getAbsolutePath();
        }
        catch (FileNotFoundException ex) {
            logger.log(Level.WARNING, "Exception while storing the logo ", ex);
            throw ex;
        }
        catch (IOException ex) {
            logger.log(Level.WARNING, "Exception while storing the logo ", ex);
            throw ex;
        }
    }

    private boolean getDefaultClientSettings() throws Exception {
        String confFile = "../conf/client_params.conf";
        try {
            Properties props = StartupUtil.getProperties((String)confFile);
            logger.log(Level.INFO, "client settings prop : " + props);
            String launchBrowser = props.getProperty("LAUNCH_BROWSER_CLIENT");
            logger.log(Level.INFO, "Launch Browser value in Conf File: " + launchBrowser);
            return launchBrowser == null || !launchBrowser.equalsIgnoreCase("false");
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while getting client startup settings from conf file: " + confFile, e);
            throw new Exception("Exception while getting startup settings");
        }
    }

    private void clientSettings(Boolean launchDefaultBrowser) throws Exception {
        String confFile = "../conf/client_params.conf";
        try {
            logger.log(Level.INFO, "Launch Browser value from client: " + launchDefaultBrowser);
            Properties props = new Properties();
            props.setProperty("LAUNCH_BROWSER_CLIENT", launchDefaultBrowser.toString());
            logger.log(Level.INFO, "Launch Browser value from client: " + props + " & FILE " + confFile);
            StartupUtil.storeProperties((Properties)props, (String)confFile);
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Exception while updating launch browser client flag in conf file: " + confFile, e);
            throw new Exception("Exception while updating launch browser client");
        }
    }

    private void changePassword(String loginName, String oldPasswd, String newPasswd) throws Exception {
        try {
            String serviceName = ADSMPersUtil.getServiceName((String)loginName);
            AuthUtil.changePassword((String)loginName, (String)serviceName, (String)oldPasswd, (String)newPasswd, (String)"ADManager Plus Authentication");
        }
        catch (PasswordException ex) {
            logger.log(Level.WARNING, "Exception while changing password ", ex);
            throw ex;
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Exception while changing password ", ex);
            throw ex;
        }
    }

    private boolean isStartServerOnBootup() throws Exception {
        String startServerOnBootup = null;
        try {
            String startupType = ADHandler.getServiceStartupType((String)"ADManager Plus");
            logger.log(Level.INFO, "Service startup type retrieved using native call is: " + startupType);
            startServerOnBootup = startupType != null && startupType.equalsIgnoreCase("Manual") ? "false" : (startupType != null && startupType.equalsIgnoreCase("Automatic") ? "true" : null);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Caught exception while getting service startup type from the native.", ex);
        }
        String startUpTypeFromDB = ADSMPersUtil.getSyMParameter((String)"START_SERVER_ON_BOOTUP");
        if (startServerOnBootup == null && startUpTypeFromDB != null) {
            startServerOnBootup = startUpTypeFromDB;
        }
        if (startServerOnBootup == null) {
            startServerOnBootup = "true";
        }
        if (startUpTypeFromDB == null || !startUpTypeFromDB.equalsIgnoreCase(startServerOnBootup)) {
            startUpTypeFromDB = startServerOnBootup;
            ADSMPersUtil.updateSyMParameter((String)"START_SERVER_ON_BOOTUP", (String)startServerOnBootup);
        }
        return new Boolean(startServerOnBootup);
    }

    private void setServerStartOnBootup(boolean bool) throws Exception {
        String startupType = "Automatic";
        if (!bool) {
            startupType = "Manual";
        }
        logger.log(Level.INFO, "Going to change the startup type of service: ADManager Plus to: " + startupType);
        ADHandler.setServiceStartupType((String)"ADManager Plus", (boolean)bool);
        ADSMPersUtil.updateSyMParameter((String)"START_SERVER_ON_BOOTUP", (String)String.valueOf(bool));
    }

    public ActionForward changeADMPUserPassword(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        DynaActionForm personaliseForm = (DynaActionForm)actionform;
        String oldpass = (String)personaliseForm.get("OLD_PASSWORD");
        String newpass = (String)personaliseForm.get("NEW_PASSWORD");
        String loginName = request.getUserPrincipal().getName();
        if (oldpass != null && !oldpass.equals("") && newpass != null && !newpass.equals("")) {
            try {
                this.changePassword(loginName, oldpass, newpass);
                request.setAttribute("changepassmessage", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd"));
                String isPasswordChanged = ADSMPersUtil.getSyMParameter((String)"IS_PASSWORD_CHANGED");
                logger.log(Level.INFO, "is pass changed" + isPasswordChanged);
                if (isPasswordChanged.equals("false")) {
                    ADSMPersUtil.updateSyMParameter((String)"IS_PASSWORD_CHANGED", (String)"true");
                }
            }
            catch (Exception ex) {
                String message = ex.getMessage();
                request.setAttribute("changepassmessage", (Object)message);
                logger.log(Level.WARNING, "Exception while changing the password", ex);
            }
        }
        return actionmapping.findForward("changePasswordPopUp");
    }

    public static String getFormatExample(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) {
        String formatExample = "";
        try {
            String formatPattern = request.getParameter("formatPattern");
            String timeZone = request.getParameter("timeZone");
            SimpleDateFormat sdf = new SimpleDateFormat(formatPattern);
            sdf.setTimeZone(TimeZone.getTimeZone(timeZone));
            formatExample = sdf.format(new Date());
            ClientUtil.setFormatXMLElement(response, formatExample);
        }
        catch (Exception ex) {
            String message = ex.getMessage();
            System.out.println("Invalid Pattern Character. " + message);
            ClientUtil.setFormatXMLElement(response, "Error");
        }
        return null;
    }

    public static boolean checkFormatPattern(String dateFormat, String timeFormat) {
        boolean validate = true;
        try {
            SimpleDateFormat sdf = new SimpleDateFormat(dateFormat + " " + timeFormat);
        }
        catch (Exception ex) {
            System.out.println(ex.getMessage());
            validate = false;
        }
        return validate;
    }

    public ActionForward changeAdminPassword(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String resMsg = "";
        try {
            DynaActionForm personaliseForm = (DynaActionForm)actionform;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String loginName = request.getUserPrincipal().getName();
            String oldpass = request.getParameter("oldpasswd");
            String newpass = request.getParameter("newpasswd");
            Boolean showForgetPassword = (Boolean)personaliseForm.get("showForgetPassword");
            String showForgetPasswordDB = ADSMPersUtil.getSyMParameter((String)"showForgetPassword");
            if (showForgetPassword != null && showForgetPasswordDB != null) {
                if (!showForgetPasswordDB.equalsIgnoreCase(showForgetPassword.toString())) {
                    ADSMPersUtil.updateSyMParameter((String)"showForgetPassword", (String)showForgetPassword.toString());
                }
                resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_settings");
            }
            Boolean showRememberPassword = (Boolean)personaliseForm.get("showRememberPassword");
            String showRememberPasswordDB = ADSMPersUtil.getSyMParameter((String)"showRememberPassword");
            if (showRememberPassword != null && showRememberPasswordDB != null) {
                if (!showRememberPasswordDB.equalsIgnoreCase(showRememberPassword.toString())) {
                    ADSMPersUtil.updateSyMParameter((String)"showRememberPassword", (String)showRememberPassword.toString());
                }
                resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_settings");
            }
            if (oldpass != null && !oldpass.equals("") && newpass != null && !newpass.equals("")) {
                try {
                    this.changePassword(loginName, oldpass, newpass);
                    resMsg = resMsg + rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_the_pwd");
                    String isPasswordChanged = ADSMPersUtil.getSyMParameter((String)"IS_PASSWORD_CHANGED");
                    logger.log(Level.INFO, "is pass changed" + isPasswordChanged);
                    if (isPasswordChanged.equals("false")) {
                        ADSMPersUtil.updateSyMParameter((String)"IS_PASSWORD_CHANGED", (String)"true");
                    }
                }
                catch (Exception ex) {
                    resMsg = rb.getString("admp.admin.gen_settgs.person.statmsg.error_to_update_your_settings");
                    String message = ex.getMessage();
                    if (message.equalsIgnoreCase("Old password specified does not match")) {
                        message = rb.getString("admp.admin.gen_settgs.person.statmsg.old_password_specified_does_not_match");
                    }
                    resMsg = resMsg + message;
                    logger.log(Level.WARNING, "Exception while changing the password", ex);
                }
            }
            JSONObject jsonObj = new JSONObject();
            jsonObj.put("resMsg", (Object)resMsg);
            response.setContentType("application/json");
            PrintWriter writer = response.getWriter();
            writer.print(jsonObj.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward saveDateLanguage(ActionMapping actionmapping, ActionForm actionform, HttpServletRequest request, HttpServletResponse response) throws Exception {
        String tile = "PersonaliseSettings";
        try {
            DynaActionForm personaliseForm = (DynaActionForm)actionform;
            HttpSession session = request.getSession();
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String timeZone = (String)personaliseForm.get("timeZone");
            String dateFormat = (String)personaliseForm.get("DATEFORMAT");
            String timeFormat = (String)personaliseForm.get("TIMEFORMAT");
            Hashtable props = DateTimeUtil.getDateTimeFormats((Long)loginId);
            if (!(props.get("timeZone").equals(timeZone) && props.get("dateFormat").equals(dateFormat) && props.get("timeFormat").equals(timeFormat))) {
                if (ChangePasswordAction.checkFormatPattern(dateFormat, timeFormat)) {
                    DateTimeUtil.updateDateTimeFormats((Long)loginId, (String)timeZone, (String)dateFormat, (String)timeFormat);
                    request.setAttribute("timeZoneMsg", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.successfully_updated_your_settings"));
                    request.setAttribute("DATEFORMAT", (Object)dateFormat);
                    request.setAttribute("TIMEFORMAT", (Object)timeFormat);
                } else {
                    request.setAttribute("timeZoneMsg", (Object)rb.getString("admp.admin.gen_settgs.person.statmsg.invalid_date_time_format"));
                }
            }
            Long localeId = (Long)personaliseForm.get("localeId");
            if (!CommonUtil.isDemo()) {
                ADSMPersUtil.updateLocaleId((Long)loginId, (Long)localeId);
                Locale newLocale = null;
                newLocale = localeId != null ? I18NUtil.getLocale((Long)localeId, (HttpServletRequest)request) : request.getLocale();
                session.setAttribute("USER_LOCALE", (Object)newLocale);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new ActionForward("/personalisePage.do?methodToCall=showPersonalisePage&selectedTab=admp_admin&selectedTile=" + tile);
    }

    public ActionForward sendTestMessage(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            String mobNo = (String)json.get("testMobileNo");
            mobNo = mobNo.replaceAll(" ", "+");
            String smsParamsStr = (String)json.get("smsParams");
            JSONObject smsParams = new JSONObject(smsParamsStr);
            Long providerId = smsParams.getLong("PROVIDER_ID");
            Properties msgProps = new Properties();
            msgProps.put("MESSAGE", (String)json.get("testMessage"));
            msgProps.put("NUMBERS", mobNo.split(","));
            String className = (String)SMSServerUtil.getProviderDetails((Long)providerId).get("CLASS_NAME");
            Class<?> classToInvoke = Class.forName(className.trim());
            SMSServerUtil.setSMSProps((JSONObject)smsParams);
            JSONObject providerProps = new JSONObject();
            providerProps = smsParams.getJSONObject("API_SETTINGS");
            providerProps.put("PROXY_SETTINGS", (Object)SMSServerUtil.getProxySettings());
            HashMap acKnowledgeProps = SendSMSAPI.sendSMS(classToInvoke, (JSONObject)providerProps, (Properties)msgProps);
            String acKnowledge = (String)acKnowledgeProps.get("statusMessage");
            if (acKnowledge.equals("admp.common.text.smssent")) {
                providerProps.remove("PROXY_SETTINGS");
                SMSServerUtil.setSMSSettings((JSONObject)smsParams);
            } else if (acKnowledge.equalsIgnoreCase("admp.reports.schedule_report.statmsg.sending_failed")) {
                acKnowledge = "admp.reports.schedule_report.alert.sending_failed";
            }
            SchedulerInputsUtil.getMsgXMLElement(response, rb.getString(acKnowledge));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public ActionForward sendTestMail(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) throws Exception {
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            String params = request.getParameter("params");
            JSONObject json = new JSONObject(params);
            String mailParamsStr = (String)json.get("mailParams");
            JSONObject mailParams = new JSONObject(mailParamsStr);
            Properties mailServerProp = new Properties();
            mailServerProp.put("MAIL_SERVER", (String)mailParams.get("SERVER_NAME"));
            mailServerProp.put("SMTP_PORT", (String)mailParams.get("PORT"));
            String userName = (String)mailParams.get("USER_NAME");
            String password = (String)mailParams.get("PASSWORD");
            if ((password == null || "".equals(password)) && userName != null && !"".equals(userName)) {
                password = (String)MailServerUtil.getMailServerSettings().get("PASSWORD");
            }
            mailServerProp.put("MAIL_SERVER_USER", userName);
            mailServerProp.put("MAIL_SERVER_PWD", password);
            mailServerProp.put("FROM_ADDRESS", (String)mailParams.get("FROM_MAIL_ID"));
            mailServerProp.put("USE_SECURE_CONNECTION", (String)mailParams.get("CONNECTION_SECURITY_ID"));
            mailServerProp.put("HTML_FORMAT", "true");
            String mailId = (String)mailParams.get("ADMIN_MAIL_ID");
            ArrayList<String> mailIdList = new ArrayList<String>();
            StringTokenizer token = new StringTokenizer(mailId, ",");
            while (token.hasMoreElements()) {
                String s = (String)token.nextElement();
                mailIdList.add(s);
            }
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("MAIL_SUBJECT", rb.getString("admp.reports.sched_reports.sch_create.test_mail"));
            map.put("MAIL_CONTENT", rb.getString("admp.reports.sched_reports.sch_create.test_mail_content"));
            map.put("MAIL_IDS", mailIdList.toArray(new String[mailIdList.size()]));
            String acKnowledge = SendMailAPI.sendMail(map, new Hashtable(), (Properties)mailServerProp);
            if (acKnowledge.equals("admp.common.text.smssent")) {
                acKnowledge = "admp.reports.schedule_report.statmsg.successfully_sent";
                JSONObject modifiedProperty = this.setMailProps(mailParams);
                boolean isUpdated = MailServerUtil.setMailServerSettings((JSONObject)modifiedProperty);
                if (isUpdated) {
                    ADSMPersUtil.updateSyMParameter((String)"IS_SMTP_SERVER_CONFIGURED", (String)"true");
                }
            } else if (acKnowledge.equalsIgnoreCase("admp.reports.schedule_report.statmsg.sending_failed")) {
                acKnowledge = "admp.reports.schedule_report.alert.sending_failed";
            }
            SchedulerInputsUtil.getMsgXMLElement(response, rb.getString(acKnowledge));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    private JSONObject setMailProps(JSONObject mailParams) {
        JSONObject modifiedProperty = new JSONObject();
        try {
            for (String str : MailServerUtil.mailServerAttr) {
                String val = (String)mailParams.get(str);
                if (val != null && !val.equals("")) {
                    modifiedProperty.put(str, (Object)val);
                }
                if (str.equalsIgnoreCase("USER_NAME") && val != null) {
                    modifiedProperty.put(str, (Object)val);
                }
                if (!str.equalsIgnoreCase("PASSWORD") || val == null || !val.equals("")) continue;
                JSONObject passwordProps = MailHandler.getMailSettings();
                String passwordValue = passwordProps.has(str) ? passwordProps.getString(str) : "";
                String usernameValue = modifiedProperty.getString("USER_NAME");
                if (usernameValue.equalsIgnoreCase("")) {
                    passwordValue = "";
                }
                modifiedProperty.put(str, (Object)passwordValue);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modifiedProperty;
    }
}

