/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.DomainUtil;
import com.adventnet.sym.adsm.common.webclient.util.ClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.struts.action.Action;
import org.apache.struts.action.ActionForm;
import org.apache.struts.action.ActionForward;
import org.apache.struts.action.ActionMapping;

public class HomeAction
extends Action {
    public ActionForward execute(ActionMapping mapping, ActionForm form, HttpServletRequest request, HttpServletResponse response) {
        Properties selectedDomain;
        String domain;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        String operation = request.getParameter("operation");
        if (operation != null && operation.equalsIgnoreCase("encryptPassword")) {
            Cookie[] cookies = request.getCookies();
            for (int i = 0; i < cookies.length; ++i) {
                if (cookies[i].getName().equalsIgnoreCase("password")) {
                    cookies[i].setValue(AuthUtil.encryptString((String)cookies[i].getValue()));
                    cookies[i].setMaxAge(31536000);
                    cookies[i].setPath("/");
                    response.addCookie(cookies[i]);
                }
                if (!cookies[i].getName().equalsIgnoreCase("encryptedPass")) continue;
                cookies[i].setValue("true");
                cookies[i].setMaxAge(31536000);
                cookies[i].setPath("/");
                response.addCookie(cookies[i]);
            }
            return null;
        }
        Credential cred = AuthUtil.getUserCredential();
        if (cred.getRoles().contains("DomainUser")) {
            return mapping.findForward("selfService");
        }
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        ArrayList tabList = authObject.getTabList();
        String url = "";
        if (!tabList.isEmpty()) {
            Hashtable tabs = (Hashtable)tabList.get(0);
            url = (String)tabs.get("url");
        }
        String domainName = request.getParameter("domainName");
        if (operation != null) {
            if (operation.equals("connect")) {
                try {
                    DomainUtil.setDefaultDomain((String)domainName, (boolean[])new boolean[0]);
                    request.setAttribute("message", (Object)MessageFormat.format(rb.getString("admp.home.change_default_domain_message"), domainName));
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            } else if (operation.equals("change")) {
                request.setAttribute("selectedDomain", (Object)domainName);
            } else if (operation.equals("updateDomainData")) {
                String[] selectedUpdates = request.getParameterValues("updates");
                String message = rb.getString("client.DomainAction.refresh_request_is_being_processed_the_data_will_be_updated_in_a_few_moments");
                try {
                    DomainHandler.updateDomain((String)domainName, (Long)loginId, (String[])selectedUpdates);
                }
                catch (Exception e) {
                    message = e.getMessage();
                }
                request.setAttribute("message", (Object)message);
            }
        }
        domainName = (String)session.getAttribute("DOMAIN_NAME");
        ArrayList list = new ArrayList();
        try {
            list = HDTDomainHandler.getConfiguredList((Long)loginId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("list", (Object)list);
        if ((domainName == null || domainName.equals("ADManager Plus Authentication")) && (domain = (selectedDomain = HDTDomainHandler.getSelectedDomain((Long)loginId)).getProperty("DOMAIN_NAME")) != null) {
            domainName = domain;
        }
        request.setAttribute("domainName", (Object)domainName);
        if (url.contains("UserAdmin.do")) {
            return mapping.findForward("Management");
        }
        if (url.contains("Report.do")) {
            return mapping.findForward("Reports");
        }
        if (url.contains("Delegation.do")) {
            return mapping.findForward("Delegation");
        }
        if (url.contains("Office365Tab.do")) {
            return mapping.findForward("Office365");
        }
        if (url.contains("WorkFlowAdmin.do")) {
            return mapping.findForward("WorkFlow");
        }
        if (url.contains("Automation.do")) {
            return mapping.findForward("Automation");
        }
        if (url.contains("Admin.do")) {
            return mapping.findForward("Admin");
        }
        if (url.contains("home.do")) {
            return mapping.findForward("success");
        }
        if (ClientUtil.checkAuthorization(request, 6000L)) {
            return mapping.findForward("Explorer");
        }
        if (ClientUtil.checkAuthorization(request, 7000L)) {
            return mapping.findForward("DomainSettings");
        }
        return mapping.findForward("failure");
    }
}

