/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.jreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.idioms.tablenavigator.TableNavigatorModel;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.DelegationDetailsDataProvider;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportBaseClass;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class TemplateDataProvider
extends ReportBaseClass {
    private Logger logger = Logger.getLogger(TemplateDataProvider.class.getName());
    private TableNavigatorModel tableModel = null;
    private int index = -1;
    public static AdventNetResourceBundle rb;
    Locale locale;
    private Long loginId = 0L;
    public HttpServletRequest request = null;
    public DelegationDetailsDataProvider delegationDataProvider = null;

    public TemplateDataProvider(HttpServletRequest request) {
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        this.request = request;
        try {
            this.tableModel = this.getDefaultTableModel(request);
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    @Override
    public Map getReportParams() {
        String basePath = this.request.getSession().getServletContext().getRealPath("/");
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("TEMPLATE_NAME", "name");
        hm.put("MODIFIED_TIME", new Long(0L));
        hm.put("MODIFIED_BY", "owner");
        hm.put("TEMPLATE_ID", new Long(0L));
        hm.put("DESCRIPTION", "desc");
        hm.put("ACE_ID", new Long(0L));
        hm.put("TYPE_STRING", "type");
        hm.put("PERMISSION_STRING", "perm");
        hm.put("APPLIESTO_STRING", "appl");
        hm.put("delegationDetailsFile", basePath + "jasper" + File.separator + "delegationDetailsReport.jasper");
        hm.put("delegationDetailsDataSource", this.getDelegationDataSource());
        hm.put("delegationDetailsParams", this.delegationDataProvider.getReportParams());
        hm.put("role_details", rb.getString("admp.deleg.security_deleg.view_sec_role.export_role_details"));
        hm.put("role_name", rb.getString("admp.deleg.security_deleg.view_sec_role.export_role_name"));
        hm.put("role_description", rb.getString("admp.deleg.security_deleg.view_sec_role.export_description"));
        hm.put("role_modified_by", rb.getString("admp.deleg.security_deleg.view_sec_role.export_modified_by"));
        hm.put("role_last_modified", rb.getString("admp.deleg.security_deleg.view_sec_role.export_last_modified"));
        hm.put("role_permissions_defined", rb.getString("admp.deleg.security_deleg.view_sec_role.export_permissions_defined"));
        hm.put("role_type", rb.getString("admp.deleg.security_deleg.view_sec_role.export_type"));
        hm.put("role_permission", rb.getString("admp.deleg.security_deleg.view_sec_role.export_permission"));
        hm.put("role_apply_permission_to", rb.getString("admp.deleg.security_deleg.view_sec_role.export_apply_permission_to"));
        return hm;
    }

    public JRDataSource getDelegationDataSource() {
        this.delegationDataProvider = new DelegationDetailsDataProvider(this.request);
        return this.delegationDataProvider;
    }

    public TableNavigatorModel getDefaultTableModel(HttpServletRequest request) throws Exception {
        String templateNameString = null;
        if (request.getAttribute("templateNameString") != null) {
            templateNameString = (String)request.getAttribute("templateNameString");
        } else if (request.getParameter("templateNameString") != null) {
            templateNameString = request.getParameter("templateNameString");
        }
        System.out.println("templateNameString : " + templateNameString);
        Table baseTable = new Table("ADSMTemplates");
        Table aceJoinTable = new Table("ADSMACEList");
        SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
        Join aceJoin = new Join(baseTable, aceJoinTable, new String[]{"TEMPLATE_ID"}, new String[]{"TEMPLATE_ID"}, 2);
        selectQuery.addJoin(aceJoin);
        ArrayList<Column> columnList = new ArrayList<Column>();
        Column templateID = new Column("ADSMTemplates", "TEMPLATE_ID");
        Column templateName = new Column("ADSMTemplates", "TEMPLATE_NAME");
        Column modifiedTime = new Column("ADSMTemplates", "MODIFIED_TIME");
        Column modifiedBy = new Column("ADSMTemplates", "MODIFIED_BY");
        Column description = new Column("ADSMTemplates", "DESCRIPTION");
        Column aceID = new Column("ADSMACEList", "ACE_ID");
        Column typeString = new Column("ADSMACEList", "TYPE_STRING");
        Column permissionString = new Column("ADSMACEList", "PERMISSION_STRING");
        Column appliesToString = new Column("ADSMACEList", "APPLIESTO_STRING");
        columnList.add(templateID);
        columnList.add(templateName);
        columnList.add(modifiedTime);
        columnList.add(modifiedBy);
        columnList.add(description);
        columnList.add(aceID);
        columnList.add(typeString);
        columnList.add(permissionString);
        columnList.add(appliesToString);
        selectQuery.addSelectColumns(columnList);
        Criteria criteria = new Criteria(templateName, (Object)templateNameString, 0);
        selectQuery.setCriteria(criteria);
        SortColumn sortColumn = new SortColumn("ADSMACEList", "ACE_ID", true);
        selectQuery.addSortColumn(sortColumn);
        this.tableModel = SecurityClientUtil.getTableNavigatorModel((SelectQuery)selectQuery);
        this.tableModel.showRange(this.tableModel.getStartIndex(), this.tableModel.getTotalRecordsCount());
        if (this.tableModel.getTotalRecordsCount() > 0L) {
            this.data_available = true;
        } else {
            System.out.println("No Data available");
        }
        return this.tableModel;
    }

    @Override
    public JRDataSource getJRDataSource() {
        return this;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String desc;
        String fieldname = jRField.getName();
        Object value = this.getFieldValue(this.tableModel, fieldname, this.index);
        if (fieldname.equals("MODIFIED_TIME")) {
            Long longObj = (Long)value;
            SimpleDateFormat simpleDateFormat = DateTimeUtil.getDateFormat((Long)this.loginId);
            return simpleDateFormat.format(longObj);
        }
        if (fieldname.equals("DESCRIPTION") && ((desc = (String)value).equals("") || desc == null)) {
            return new String("--");
        }
        return value;
    }

    public Object getFieldValue(TableNavigatorModel tm, String fieldname, int idx) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            String colname = tm.getColumnName(i);
            if (!colname.equalsIgnoreCase(fieldname)) continue;
            return tm.getValueAt(idx, i);
        }
        return null;
    }

    public TableNavigatorModel getTableModel() {
        return this.tableModel;
    }

    public boolean next() throws JRException {
        ++this.index;
        return this.index < this.tableModel.getRowCount();
    }

    @Override
    public String getDesignFileName() {
        return "templateReport";
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }
}

