/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.jreport;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.idioms.tablenavigator.TableNavigatorModel;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.security.server.TemplateHandler;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import com.adventnet.sym.adsm.security.webclient.jreport.ReportBaseClass;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import net.sf.jasperreports.engine.JRDataSource;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRField;

public class TemplateListDataProvider
extends ReportBaseClass {
    private Logger logger = Logger.getLogger(TemplateListDataProvider.class.getName());
    private TableNavigatorModel tableModel = null;
    private int index = -1;
    public static AdventNetResourceBundle rb;
    Locale locale;
    private Long loginId = 0L;
    private boolean showSerialNo = false;
    private int startingSerialNo = 0;

    public TemplateListDataProvider(HttpServletRequest request) {
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.tableModel = this.getDefaultTableModel(request);
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    public TemplateListDataProvider(HttpServletRequest request, boolean showSerialNo, int startingSerialNo) {
        Locale locale = request.getLocale();
        rb = ResourceBundleMgr.getInstance().getBundle(locale);
        this.loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
        try {
            this.tableModel = this.getDefaultTableModel(request);
            this.showSerialNo = showSerialNo;
            this.startingSerialNo = startingSerialNo;
        }
        catch (Exception e) {
            this.data_available = false;
            e.printStackTrace();
        }
    }

    @Override
    public Map getReportParams() {
        HashMap<String, Object> hm = new HashMap<String, Object>();
        hm.put("TEMPLATE_NAME", "name");
        hm.put("MODIFIED_TIME", new Long(0L));
        hm.put("TEMPLATE_ID", new Long(0L));
        hm.put("DELEGATION_PATH", "path");
        hm.put("DELEGATION_ID", new Long(0L));
        hm.put("title", rb.getString("admp.ad_delegation.view_security_role.export.title"));
        hm.put("colName", rb.getString("admp.ad_delegation.view_security_role.export.col_name"));
        hm.put("colLastModified", rb.getString("admp.ad_delegation.view_security_role.export.col_last_modified"));
        hm.put("colDelegObj", rb.getString("admp.ad_delegation.view_security_role.export.col_delegated_AD_objects"));
        return hm;
    }

    public TableNavigatorModel getDefaultTableModel(HttpServletRequest request) throws Exception {
        Table baseTable = new Table("ADSMTemplates");
        Table joinTable = new Table("ADSMDelegationDetails");
        SelectQueryImpl selectQuery = new SelectQueryImpl(baseTable);
        Join join = null;
        int joinType = 1;
        System.out.println("Join type 1 is " + joinType);
        String filter = null;
        if (request.getAttribute("filter") != null) {
            filter = (String)request.getAttribute("filter");
        } else if (request.getParameter("filter") != null) {
            filter = request.getParameter("filter");
        }
        if (filter != null) {
            System.out.println("The Filter si " + filter);
            if (filter.equals("applied")) {
                joinType = 2;
            }
        }
        System.out.println("Join type 2 is " + joinType);
        join = new Join(baseTable, joinTable, new String[]{"TEMPLATE_ID"}, new String[]{"TEMPLATE_ID"}, joinType);
        selectQuery.addJoin(join);
        SortColumn sortColumn = new SortColumn("ADSMTemplates", "CREATION_TIME", true);
        selectQuery.addSortColumn(sortColumn);
        ArrayList<Column> columnList = new ArrayList<Column>();
        Column templateID = new Column("ADSMTemplates", "TEMPLATE_ID");
        Column templateName = new Column("ADSMTemplates", "TEMPLATE_NAME");
        Column modifiedTime = new Column("ADSMTemplates", "MODIFIED_TIME");
        Column delegationID = new Column("ADSMDelegationDetails", "DELEGATION_ID");
        Column delegationPath = new Column("ADSMDelegationDetails", "DELEGATION_PATH");
        columnList.add(templateID);
        columnList.add(templateName);
        columnList.add(modifiedTime);
        columnList.add(delegationID);
        columnList.add(delegationPath);
        selectQuery.addSelectColumns(columnList);
        if (filter != null && filter.equals("recent")) {
            System.out.println("Setting Range ...");
            Range range = new Range(1, 5);
            selectQuery.setRange(range);
        }
        this.tableModel = SecurityClientUtil.getTableNavigatorModel((SelectQuery)selectQuery);
        this.tableModel.showRange(this.tableModel.getStartIndex(), this.tableModel.getTotalRecordsCount());
        if (this.tableModel.getTotalRecordsCount() > 0L) {
            this.data_available = true;
        }
        return this.tableModel;
    }

    @Override
    public JRDataSource getJRDataSource() {
        return this;
    }

    public Object getFieldValue(JRField jRField) throws JRException {
        String fieldname = jRField.getName();
        Object value = null;
        if (fieldname.equalsIgnoreCase("serialNo") && this.showSerialNo) {
            return this.startingSerialNo + "";
        }
        value = this.getFieldValue(this.tableModel, fieldname, this.index);
        if (fieldname.equals("MODIFIED_TIME")) {
            Long longObj = (Long)value;
            SimpleDateFormat simpleDateFormat = DateTimeUtil.getDateFormat((Long)this.loginId);
            return simpleDateFormat.format(longObj);
        }
        if (fieldname.equals("DELEGATION_PATH")) {
            String strObj = (String)value;
            if (strObj == null) {
                return " -- ";
            }
            return TemplateHandler.getObjectDisplayName((String)strObj);
        }
        return value;
    }

    public Object getFieldValue(TableNavigatorModel tm, String fieldname, int idx) {
        for (int i = 0; i < tm.getColumnCount(); ++i) {
            String colname = tm.getColumnName(i);
            if (!colname.equalsIgnoreCase(fieldname)) continue;
            if (fieldname.equals("TEMPLATE_NAME")) {
                return rb.getString((String)tm.getValueAt(idx, i));
            }
            return tm.getValueAt(idx, i);
        }
        return null;
    }

    public TableNavigatorModel getTableModel() {
        return this.tableModel;
    }

    public boolean next() throws JRException {
        ++this.index;
        if (this.index != 0) {
            ++this.startingSerialNo;
        }
        return this.index < this.tableModel.getRowCount();
    }

    @Override
    public String getDesignFileName() {
        return "templateListReport";
    }

    @Override
    public int getRowCount() {
        return this.tableModel.getRowCount();
    }
}

