/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.model;

import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.helpdesk.ADMPAuthObject;
import com.adventnet.sym.adsm.common.server.helpdesk.HDTDomainHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.model.TreeObject;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeModel;
import com.adventnet.sym.adsm.common.webclient.tree.DirectoryObjectTreeNode;
import com.adventnet.sym.adsm.security.server.TemplateHandler;
import com.adventnet.sym.adsm.security.server.model.PermissionObject;
import com.adventnet.sym.adsm.security.webclient.util.SecurityClientUtil;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class TemplateBean
extends DynaValidatorForm {
    private ArrayList aceList = new ArrayList();
    private PermissionObject permissionObject = null;
    private String warningMessage = null;
    private static Long DELEGATE_ROLE_ACTION_ID = 1805L;

    public void setPermissionObject(PermissionObject object) {
        this.permissionObject = object;
    }

    public PermissionObject getPermissionObject() {
        return this.permissionObject;
    }

    public void setAceList(ArrayList l) {
        this.aceList = l;
    }

    public ArrayList getAceList() {
        return this.aceList;
    }

    private String getDomain(Long loginId, Hashtable domainVsactions) {
        Properties selectedDomain = HDTDomainHandler.getDefaultDomainForTechinician((Long)loginId, (Hashtable)domainVsactions, (Long)DELEGATE_ROLE_ACTION_ID);
        return selectedDomain.getProperty("DOMAIN_NAME");
    }

    public void init(HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        try {
            String operation = (String)this.get("operation");
            String cardName = (String)this.get("cardName");
            Long loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID");
            if (operation.equals("modify") && !this.get("TEMPLATE_NAME").equals(this.get("previousTemplateName"))) {
                this.aceList = new ArrayList();
                Hashtable p = TemplateHandler.get((Long)((Long)this.get("TEMPLATE_ID")), (Long)loginId);
                this.set("TEMPLATE_NAME", rb.getString((String)this.get("TEMPLATE_NAME")));
                this.set("DESCRIPTION", rb.getString((String)p.get("DESCRIPTION")));
                this.aceList = (ArrayList)p.get("aceList");
                request.setAttribute("operation", (Object)operation);
            } else if (operation.equals("new") && cardName.equals("introduction")) {
                this.set("operation", operation);
                this.set("cardName", cardName);
                this.aceList = new ArrayList();
            } else if (operation.equals("new") && cardName.equals("description")) {
                this.set("TEMPLATE_NAME", (String)this.get("TEMPLATE_NAME"));
                this.set("DESCRIPTION", (String)this.get("DESCRIPTION"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("new") && cardName.equals("schemaobjects")) {
                this.set("TEMPLATE_NAME", (String)this.get("TEMPLATE_NAME"));
                this.set("DESCRIPTION", (String)this.get("DESCRIPTION"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("new") && cardName.equals("summary")) {
                this.set("TEMPLATE_NAME", (String)this.get("TEMPLATE_NAME"));
                this.set("DESCRIPTION", (String)this.get("DESCRIPTION"));
                this.set("operation", operation);
                this.set("cardName", cardName);
            } else if (operation.equals("save")) {
                this.set("operation", operation);
            }
            this.set("previousTemplateName", this.get("TEMPLATE_NAME"));
            this.initSchemaValues(request);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
    }

    public void initSchemaValues(HttpServletRequest request) throws Exception {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
        Hashtable domainVsactions = authObject.getDomainActionMap();
        try {
            String domainName = this.getDomain(loginId, domainVsactions);
            ArrayList<String> schemaObjects = (ArrayList<String>)this.get("schemaObjects");
            ArrayList schemaIDGuidList = (ArrayList)this.get("schemaIDGuidList");
            ArrayList adsPathList = (ArrayList)this.get("adsPathList");
            if (schemaObjects == null || schemaObjects.size() == 0) {
                schemaObjects = new ArrayList<String>();
                ArrayList schemaList = ADHandler.getSchemaObjects((String)domainName, (Long)loginId);
                Properties displayProp = ADHandler.getDisplaySpecifiers((String)domainName, (Long)loginId);
                this.set("previousDomainName", domainName);
                ArrayList<String> l1 = new ArrayList<String>();
                ArrayList<String> l2 = new ArrayList<String>();
                ArrayList<String> l3 = new ArrayList<String>();
                Properties displayValuesCaseSensitiveMap = new Properties();
                for (int i = 0; i < schemaList.size(); ++i) {
                    Properties p = (Properties)schemaList.get(i);
                    String ldapDisplayName = this.getString(p, "lDAPDisplayName");
                    String schemaId = this.getString(p, "schemaIDGUID");
                    String distinguishedName = this.getString(p, "distinguishedName");
                    if (displayProp.get(ldapDisplayName + "-display") != null) {
                        ArrayList values = (ArrayList)displayProp.get(ldapDisplayName + "-display");
                        displayValuesCaseSensitiveMap.put(values.get(0), MessageFormat.format(rb.getString("admp.mgmt.security_mgmt.cre_sec_role.text.schema_objects"), values.get(1)));
                        ldapDisplayName = (String)values.get(0);
                    } else {
                        displayValuesCaseSensitiveMap.put(this.getString(p, "lDAPDisplayName"), MessageFormat.format(rb.getString("admp.mgmt.security_mgmt.cre_sec_role.text.schema_objects"), this.getString(p, "lDAPDisplayName", 1)));
                    }
                    l1.add(ldapDisplayName);
                    l2.add(schemaId);
                    l3.add(distinguishedName);
                }
                TreeSet sort = new TreeSet((ArrayList)l1.clone());
                for (String s : sort) {
                    int index = l1.indexOf(s);
                    String ldapDisplayName = (String)l1.get(index);
                    if (displayValuesCaseSensitiveMap.get(ldapDisplayName) != null) {
                        ldapDisplayName = displayValuesCaseSensitiveMap.getProperty(ldapDisplayName);
                    }
                    schemaObjects.add(ldapDisplayName);
                    schemaIDGuidList.add(l2.get(index));
                    adsPathList.add(l3.get(index));
                }
                schemaObjects.add(0, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.text.generic_rights"));
                schemaIDGuidList.add(0, "null");
                adsPathList.add(0, "null");
                this.set("schemaObjects", schemaObjects);
                this.set("schemaIDGuidList", schemaIDGuidList);
                this.set("adsPathList", adsPathList);
            } else if (!domainName.equals(this.get("previousDomainName"))) {
                this.set("schemaObjects", new ArrayList());
                this.set("schemaIDGuidList", new ArrayList());
                this.set("adsPathList", new ArrayList());
                this.initSchemaValues(request);
                this.set("previousDomainName", domainName);
            }
            ArrayList<Object> commonSchemaIDGuidList = new ArrayList<Object>();
            ArrayList<Object> commonSchemaObjects = new ArrayList<Object>();
            ArrayList commonSchemasList = SecurityClientUtil.getCommonSchemas(request);
            for (int i = 0; i < commonSchemasList.size(); ++i) {
                Properties prop = (Properties)commonSchemasList.get(i);
                commonSchemaIDGuidList.add(prop.get("SCHEMAID_GUID"));
                commonSchemaObjects.add(prop.get("SCHEMA_OBJECT"));
            }
            ArrayList<String> appliesToList = new ArrayList<String>();
            ArrayList<String> appliesToListValues = new ArrayList<String>();
            appliesToList.add("0x0");
            appliesToList.add("0x2");
            appliesToList.add("0xA");
            appliesToListValues.add(rb.getString("client.model.template_bean.thisobjectonly"));
            appliesToListValues.add(rb.getString("client.model.template_bean.thisobjectandallchildobjects"));
            appliesToListValues.add(rb.getString("client.model.template_bean.childobjectonly"));
            this.set("appliesToList", appliesToList);
            this.set("appliesToListValues", appliesToListValues);
            this.set("appliesTo", (String)appliesToList.get(0));
            this.set("schemaIDGuid", schemaIDGuidList.get(0));
            this.set("commonSchemaObjects", commonSchemaObjects);
            this.set("commonSchemaIDGuidList", commonSchemaIDGuidList);
            this.set("commonSchemaIDGuid", (String)commonSchemaIDGuidList.get(0));
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = "";
            message = e.getMessage() != null ? rb.getString("admp.delegation.security_deleg.cre_sec_role.error_msg.schema_error") + e.getMessage() : rb.getString("admp.delegation.security_deleg.cre_sec_role.error_msg.schema_error");
            throw new Exception(message);
        }
    }

    private String getString(Properties p, String key) {
        return this.getString(p, key, 0);
    }

    private String getString(Properties p, String key, int index) {
        ArrayList l = (ArrayList)p.get(key);
        return (String)l.get(index);
    }

    public void getPermissions(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
            ADMPAuthObject authObject = (ADMPAuthObject)session.getAttribute("ADMP_AUTH_OBJECT");
            Hashtable domainVsactions = authObject.getDomainActionMap();
            String schemaIDGuid = (String)this.get("schemaIDGuid");
            String previousSchemaIDGuid = (String)this.get("previousSchemaIDGuid");
            PermissionObject object = null;
            ArrayList pathList = new ArrayList();
            if (!previousSchemaIDGuid.equals(schemaIDGuid)) {
                if (schemaIDGuid.equals("null")) {
                    object = this.getGenericRights(request, pathList);
                } else {
                    ArrayList adsPathList = (ArrayList)this.get("adsPathList");
                    ArrayList schemaIDGuidList = (ArrayList)this.get("schemaIDGuidList");
                    Properties permissions = ADHandler.getPermissions((String)this.getDomain(loginId, domainVsactions), (Long)loginId, (String)((String)adsPathList.get(schemaIDGuidList.indexOf(schemaIDGuid))), (String)schemaIDGuid);
                    pathList = new ArrayList();
                    object = this.getPermissionObjects(request, permissions, pathList);
                }
                DirectoryObjectTreeModel model = new DirectoryObjectTreeModel((TreeObject)object);
                request.setAttribute("PermissionObject", (Object)object);
                session.setAttribute("PermissionModel", (Object)model);
                request.setAttribute("path", pathList);
                request.setAttribute("scriptString", (Object)object.getScriptString("0"));
                request.setAttribute("treeScriptString", (Object)object.getTreeScriptString("0"));
                ArrayList schemaObjects = (ArrayList)this.get("schemaObjects");
                this.permissionObject = object;
                this.set("previousSchemaIDGuid", schemaIDGuid);
            } else {
                DirectoryObjectTreeModel model = (DirectoryObjectTreeModel)session.getAttribute("PermissionModel");
                object = (PermissionObject)((DirectoryObjectTreeNode)model.getRoot()).getUserObject();
                request.setAttribute("scriptString", (Object)object.getScriptString("0"));
                request.setAttribute("treeScriptString", (Object)object.getTreeScriptString("0"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void searchPermissions(HttpServletRequest request) {
        int i;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject object = this.permissionObject;
        String searchPermission = (String)this.get("searchPermission");
        searchPermission = searchPermission.toLowerCase();
        String searchPattern = null;
        StringBuffer searchBuffer = new StringBuffer();
        boolean flag = false;
        for (i = 0; i < searchPermission.length(); ++i) {
            if (searchPermission.charAt(i) != '*') continue;
            flag = true;
        }
        if (flag) {
            for (i = 0; i < searchPermission.length(); ++i) {
                if (searchPermission.charAt(i) == '*') {
                    searchBuffer.append(".*");
                    continue;
                }
                searchBuffer.append(searchPermission.charAt(i));
            }
            searchPattern = searchBuffer.toString();
        } else {
            searchPattern = ".*" + searchPermission + ".*";
        }
        ArrayList searchList = new ArrayList();
        this.searchPermissionObject(object, searchPattern, searchList);
        request.setAttribute("scriptString", (Object)object.getScriptString("0"));
        int searchSize = searchList.size();
        if (searchSize > 0) {
            ArrayList<Properties> searchPermissionList = new ArrayList<Properties>();
            for (int i2 = 0; i2 < searchList.size(); ++i2) {
                Properties properties = new Properties();
                properties.put("Permission_Name", ((PermissionObject)searchList.get(i2)).getName());
                properties.put("Permission_ID", ((PermissionObject)searchList.get(i2)).getActionLink());
                searchPermissionList.add(properties);
            }
            request.setAttribute("searchPermissionList", searchPermissionList);
            request.setAttribute("searchLength", (Object)new Integer(searchPermissionList.size()));
        } else {
            System.out.println("Entering Search with no result");
            request.setAttribute("searchPermissionList", new ArrayList());
            request.setAttribute("searchLength", (Object)rb.getString("usermanagement.terminal_environment.no"));
        }
    }

    private void searchPermissionObject(PermissionObject permission, String regex, ArrayList list) {
        ArrayList childList;
        String displayName = permission.getName();
        if (Pattern.matches(regex, displayName = displayName.toLowerCase())) {
            list.add(permission);
        }
        if ((childList = permission.getChildObjectList()) != null) {
            for (int i = 0; i < childList.size(); ++i) {
                this.searchPermissionObject((PermissionObject)childList.get(i), regex, list);
            }
        }
    }

    public String saveTemplate(HttpServletRequest request) {
        String operation = (String)this.get("operation");
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        String message = rb.getString("admp.create_security_role.successfully_created.message");
        Hashtable<String, Object> p = new Hashtable<String, Object>();
        p.put("TEMPLATE_NAME", this.get("TEMPLATE_NAME"));
        if (operation.equals("modify")) {
            p.put("TEMPLATE_ID", this.get("TEMPLATE_ID"));
        }
        p.put("DESCRIPTION", this.get("DESCRIPTION"));
        System.out.println("Modified By : " + request.getUserPrincipal().getName());
        p.put("MODIFIED_BY", request.getUserPrincipal().getName());
        p.put("aceList", this.aceList);
        System.out.println("From TemplateBean Properties : " + p);
        int statusCode = 0;
        try {
            if (operation.equals("modify")) {
                statusCode = TemplateHandler.modify(p, (Long)loginId);
                System.out.println("Status Code is " + statusCode);
                message = statusCode == 5 ? rb.getString("admp.create_security_role.successfully_modified.message") : (statusCode == 0 ? rb.getString("admp.create_security_role.successfully_modified_delegated.message") : MessageFormat.format(rb.getString("admp.create_security_role.status_code.message"), statusCode));
            } else {
                TemplateHandler.add(p);
            }
        }
        catch (Exception e) {
            message = e.getMessage();
        }
        return message;
    }

    public void allowDeny(HttpServletRequest request) {
        String aceOperation = (String)this.get("aceOperation");
        if (aceOperation.equals("")) {
            String action = request.getParameter("allow");
            if (action == null) {
                return;
            }
            action = action.equals("true") ? "admp.mgmt.security_mgmt.permission.allow" : "admp.mgmt.security_mgmt.permission.deny";
            String selectedValues = request.getParameter("selectedValues");
            if (selectedValues == null) {
                return;
            }
            StringTokenizer token = new StringTokenizer(selectedValues, ",");
            ArrayList<String> schemaIDGuidList = new ArrayList<String>();
            ArrayList<Long> permissionIdList = new ArrayList<Long>();
            ArrayList<String> schemaNameList = new ArrayList<String>();
            Long aceType = null;
            while (token.hasMoreTokens()) {
                String str = (String)token.nextElement();
                int andIndex = str.indexOf("~");
                int index = str.indexOf("=");
                String schemaIDGuid = str.substring(0, andIndex);
                String schemaName = str.substring(andIndex + 1, index);
                String permissionId = str.substring(index + 1, str.length());
                schemaIDGuidList.add(schemaIDGuid);
                schemaNameList.add(schemaName);
                if (action.equals("admp.mgmt.security_mgmt.permission.allow")) {
                    aceType = schemaIDGuid.equals("null") ? new Long(0L) : new Long(5L);
                } else if (action.equals("admp.mgmt.security_mgmt.permission.deny")) {
                    aceType = schemaIDGuid.equals("null") ? new Long(1L) : new Long(6L);
                }
                permissionIdList.add(new Long(permissionId));
            }
            PermissionObject object = this.permissionObject;
            this.addToACEList(request, object, schemaIDGuidList, schemaNameList, permissionIdList, action, aceType);
        } else if (aceOperation.equals("DeleteAll")) {
            this.aceList.clear();
        } else {
            String selectedACEListValue = request.getParameter("aceListValue");
            for (int i = 0; i < this.aceList.size(); ++i) {
                Hashtable p = (Hashtable)this.aceList.get(i);
                String schemaIDGuid = (String)p.get("PERMISSION_GUID");
                String appliesGuid = (String)p.get("APPLIES_GUID");
                Long accessMask = (Long)p.get("ACCESS_MASK");
                String str = selectedACEListValue;
                String schemaId = str.substring(0, str.indexOf(","));
                Long acsMask = new Long(str.substring(str.indexOf(",") + 1, str.indexOf("=")));
                if (!schemaId.equals(schemaIDGuid) || !acsMask.equals(accessMask)) continue;
                if (aceOperation.equals("delete")) {
                    this.aceList.remove(i);
                    --i;
                    break;
                }
                Long aceType = null;
                if (aceOperation.equals("admp.mgmt.security_mgmt.permission.allow")) {
                    aceType = schemaId.equals("null") && appliesGuid.equals("null") ? new Long(0L) : new Long(5L);
                } else if (aceOperation.equals("admp.mgmt.security_mgmt.permission.deny")) {
                    aceType = schemaId.equals("null") && appliesGuid.equals("null") ? new Long(1L) : new Long(6L);
                }
                p.put("TYPE_STRING", aceOperation);
                p.put("ACE_TYPE", aceType);
            }
        }
        request.setAttribute("warningMessage", (Object)this.warningMessage);
    }

    private void addToACEList(HttpServletRequest request, PermissionObject object, ArrayList schemaIDGuidList, ArrayList schemaNameList, ArrayList permissionIdList, String action, Long aceType) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        boolean check = false;
        ArrayList objectschemaIDGuidList = (ArrayList)this.get("schemaIDGuidList");
        ArrayList objectSchemaObjects = (ArrayList)this.get("schemaObjects");
        String appliesTo = (String)this.get("appliesTo");
        String appliesGuid = null;
        Long inheritFlag = null;
        String appliesToString = null;
        if (appliesTo.equals("0x0")) {
            appliesGuid = "null";
            inheritFlag = new Long(0L);
            appliesToString = rb.getString("client.model.template_bean.thisobjectonly");
        } else if (appliesTo.equals("0xA")) {
            appliesGuid = "null";
            inheritFlag = new Long(10L);
            appliesToString = rb.getString("client.model.template_bean.childobjectonly");
        } else if (appliesTo.equals("0x2")) {
            appliesGuid = "null";
            inheritFlag = new Long(2L);
            appliesToString = rb.getString("conf.temp_det.key13");
        } else {
            appliesGuid = appliesTo;
            inheritFlag = new Long(10L);
            appliesToString = (String)objectSchemaObjects.get(objectschemaIDGuidList.indexOf(appliesTo));
            if (aceType.equals(new Long(0L))) {
                aceType = new Long(5L);
            } else if (aceType.equals(new Long(1L))) {
                aceType = new Long(6L);
            }
        }
        if (schemaIDGuidList.size() > 0) {
            for (int i = 0; i < schemaIDGuidList.size(); ++i) {
                String schemaIDGuid = (String)schemaIDGuidList.get(i);
                Long permissionId = (Long)permissionIdList.get(i);
                String schemaName = (String)schemaNameList.get(i);
                check = this.checkForAdd(this.aceList, schemaIDGuid, permissionId, appliesToString, action, object, rb);
                if (!check) continue;
                Hashtable<String, Object> p = new Hashtable<String, Object>();
                p.put("PERMISSION_GUID", schemaIDGuid);
                p.put("APPLIES_GUID", appliesGuid);
                p.put("ACCESS_MASK", permissionId);
                p.put("ACE_TYPE", aceType);
                p.put("TYPE_STRING", action);
                p.put("PERMISSION_STRING", schemaName);
                p.put("APPLIESTO_STRING", appliesToString);
                p.put("INHERIT_TYPE_FLAG", inheritFlag);
                p.put("OBJECT_TYPE_FLAG", "1");
                this.aceList.add(0, p);
            }
        }
    }

    private boolean checkForAdd(ArrayList list, String schemaId, Long maskLong, String appliesToString, String aceString, PermissionObject object, AdventNetResourceBundle rb) {
        boolean flag = true;
        PermissionObject obj = this.getPermissionObject(object, schemaId, maskLong);
        ArrayList parentList = new ArrayList();
        this.getParentObjects(obj, parentList);
        if (list.size() > 0) {
            for (int i = 0; i < list.size(); ++i) {
                Hashtable prop = (Hashtable)list.get(i);
                String schemaid = (String)prop.get("PERMISSION_GUID");
                Long mask = (Long)prop.get("ACCESS_MASK");
                String allow = (String)prop.get("TYPE_STRING");
                String appliesToStr = (String)prop.get("APPLIESTO_STRING");
                if (schemaId.equals(schemaid) && mask.equals(maskLong) && appliesToStr.equals(appliesToString)) {
                    if (allow.equals("Deny")) {
                        this.warningMessage = aceString.equals("admp.mgmt.security_mgmt.permission.allow") ? rb.getString("admp.delegation.security_deleg.cre_sec_role.warning_msg.deny_ace_already_exists") : rb.getString("admp.delegation.security_deleg.cre_sec_role.warning_msg.ace_already_exists");
                        flag = false;
                    } else if (aceString.equals("admp.mgmt.security_mgmt.permission.allow")) {
                        this.warningMessage = rb.getString("admp.delegation.security_deleg.cre_sec_role.warning_msg.ace_already_exists");
                        flag = false;
                    } else if (aceString.equals("admp.mgmt.security_mgmt.permission.deny")) {
                        list.remove(i);
                        this.warningMessage = null;
                        flag = true;
                    }
                }
                if (!flag || parentList.size() <= 0) continue;
                for (int j = 0; j < parentList.size(); ++j) {
                    PermissionObject parentObj = (PermissionObject)parentList.get(j);
                    String parentId = parentObj.getID();
                    Long parentMask = new Long(parentObj.getAccessMask());
                    if (!parentId.equals(schemaid) || !mask.equals(parentMask) || !appliesToStr.equals(appliesToString)) continue;
                    if (allow.equals("Deny")) {
                        this.warningMessage = rb.getString("admp.delegation.security_deleg.cre_sec_role.warning_msg.parent_deny_ace_exists");
                        flag = false;
                        continue;
                    }
                    if (aceString.equals("admp.mgmt.security_mgmt.permission.allow")) {
                        this.warningMessage = rb.getString("admp.delegation.security_deleg.cre_sec_role.warning_msg.parent_allow_ace_exists");
                        flag = false;
                        continue;
                    }
                    if (!aceString.equals("admp.mgmt.security_mgmt.permission.deny")) continue;
                    this.warningMessage = null;
                    flag = true;
                }
            }
        }
        if (flag) {
            if (obj.getChildObjectList().size() > 0) {
                this.deleteChildObjects(obj, list, appliesToString);
            }
            this.warningMessage = null;
        }
        return flag;
    }

    private void deleteChildObjects(PermissionObject object, ArrayList list, String appliesToString) {
        ArrayList childList = object.getChildObjectList();
        if (childList.size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                PermissionObject childObject = (PermissionObject)childList.get(i);
                String childId = childObject.getID();
                Long childMask = new Long(childObject.getAccessMask());
                for (int j = 0; j < list.size(); ++j) {
                    Hashtable prop = (Hashtable)list.get(j);
                    String schemaid = (String)prop.get("PERMISSION_GUID");
                    Long mask = (Long)prop.get("ACCESS_MASK");
                    String appliesToStr = (String)prop.get("APPLIESTO_STRING");
                    if (!schemaid.equals(childId) || !mask.equals(childMask) || !appliesToStr.equals(appliesToString)) continue;
                    list.remove(j);
                }
                if (childObject.getChildObjectList().size() <= 0) continue;
                this.deleteChildObjects(childObject, list, appliesToString);
            }
        }
    }

    private int getSelectedValueIndex(ArrayList schemaIDGuidList, ArrayList permissionIdList, String id, long permissionId) {
        int index = 0;
        while (true) {
            if ((index = this.listIndexOf(schemaIDGuidList, index, id)) == -1) {
                return -1;
            }
            if (((Long)permissionIdList.get(index)).equals(new Long(permissionId))) break;
            ++index;
        }
        return index;
    }

    private int listIndexOf(ArrayList list, int index, String id) {
        for (int i = index; i < list.size(); ++i) {
            if (!list.get(i).equals(id)) continue;
            return i;
        }
        return -1;
    }

    private PermissionObject getGenericRights(HttpServletRequest request, ArrayList pathList) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject fullControl = new PermissionObject(null, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.fullcontrol"), "null", 983551L);
        pathList.add("FullControl");
        ArrayList<PermissionObject> list = new ArrayList<PermissionObject>();
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.listcontents"), "null", 4L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.readallproperties"), "null", 16L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.writeallproperties"), "null", 32L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.delete"), "null", 65536L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.deletesubtree"), "null", 64L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.readpermissions"), "null", 131072L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.modifypermissions"), "null", 262144L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.modifyowner"), "null", 524288L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.allvalidatedwrites"), "null", 8L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.allextendedrights"), "null", 256L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.createallchildobjects"), "null", 1L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.deleteallchildobjects"), "null", 2L));
        list.add(new PermissionObject(fullControl, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.listobject"), "null", 128L));
        fullControl.setChildObjectList(list);
        return fullControl;
    }

    private PermissionObject getPermissionObjects(HttpServletRequest request, Properties prop, ArrayList pathList) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject fullControl = new PermissionObject(null, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.fullcontrol"), "null", 983551L);
        pathList.add(rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.fullcontrol"));
        ArrayList<PermissionObject> list = new ArrayList<PermissionObject>();
        list.add(this.getListContents(request, pathList, fullControl));
        list.add(this.getReadAll(request, prop, pathList, fullControl));
        list.add(this.getWriteAll(request, prop, pathList, fullControl));
        list.add(this.getDelete(request, pathList, fullControl));
        list.add(this.getDeleteSubtree(request, pathList, fullControl));
        list.add(this.getReadPermissions(request, pathList, fullControl));
        list.add(this.getModifyPermissions(request, pathList, fullControl));
        list.add(this.getModifyOwner(request, pathList, fullControl));
        list.add(this.getValidatedWrites(request, prop, pathList, fullControl));
        list.add(this.getExtendedRights(request, prop, pathList, fullControl));
        list.add(this.getCreateAllChildObjects(request, prop, pathList, fullControl));
        list.add(this.getDeleteAllChildObjects(request, prop, pathList, fullControl));
        list.add(this.getListObject(request, pathList, fullControl));
        fullControl.setChildObjectList(list);
        return fullControl;
    }

    private PermissionObject getListContents(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject listContents = new PermissionObject(parentObject, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.listcontents"), "null", 4L);
        pathList.add("listContents");
        return listContents;
    }

    private PermissionObject getReadAll(HttpServletRequest request, Properties permissions, ArrayList pathList, PermissionObject parentObject) {
        ArrayList list;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject readAll = new PermissionObject(parentObject, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.readallproperties"), "null", 16L);
        pathList.add("readAll");
        ArrayList<PermissionObject> readAllChildList = new ArrayList<PermissionObject>();
        PermissionObject readPropertySet = new PermissionObject(readAll, rb.getString("admp.ad_delegation.create_security_role.available_permission.read_property_set"), "null", 16L, true);
        ArrayList<PermissionObject> readPropertySetChildList = new ArrayList<PermissionObject>();
        ArrayList extendedList = (ArrayList)permissions.get("extendedPermission");
        for (int i = 0; i < extendedList.size(); ++i) {
            Properties p = (Properties)extendedList.get(i);
            String validAccesses = this.getString(p, "validAccesses");
            String displayName = this.getString(p, "displayName");
            String rightsGUID = this.getString(p, "rightsGUID");
            list = (ArrayList)p.get("properties");
            if (!validAccesses.equals("48")) continue;
            PermissionObject readObj = new PermissionObject(readPropertySet, rb.getString("admp.ad_delegation.create_security_role.available_permission.read") + displayName, rightsGUID, 16L);
            if (list.size() > 0) {
                readObj.setChildObjectList(this.getPropertyObjects(list, rb.getString("admp.ad_delegation.create_security_role.available_permission.read"), 16L, readObj));
            }
            readPropertySetChildList.add(readObj);
        }
        readPropertySet.setChildObjectList(readPropertySetChildList);
        readAllChildList.add(readPropertySet);
        PermissionObject readPropertyPermissions = new PermissionObject(readAll, rb.getString("admp.ad_delegation.create_security_role.available_permission.read_property_permissions"), "null", 16L, true);
        ArrayList<PermissionObject> readPropertyChildList = new ArrayList<PermissionObject>();
        String[] arr = new String[]{"mayContain", "mustContain", "systemMayContain", "systemMustContain"};
        Properties property = (Properties)permissions.get("schemaPermission");
        for (int i = 0; i < arr.length; ++i) {
            list = (ArrayList)property.get(arr[i]);
            for (int j = 0; j < list.size(); ++j) {
                Properties p = (Properties)list.get(j);
                String displayName = this.getString(p, "ldapDisplayName");
                String schemaIDGuid = this.getString(p, "schemaIDGUID");
                PermissionObject read = new PermissionObject(readPropertyPermissions, rb.getString("admp.ad_delegation.create_security_role.available_permission.read") + displayName, schemaIDGuid, 16L);
                readPropertyChildList.add(read);
            }
        }
        readPropertyPermissions.setChildObjectList(readPropertyChildList);
        readAllChildList.add(readPropertyPermissions);
        readAll.setChildObjectList(readAllChildList);
        return readAll;
    }

    private PermissionObject getWriteAll(HttpServletRequest request, Properties permissions, ArrayList pathList, PermissionObject parentObject) {
        ArrayList list;
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject writeAll = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.write_all_properties"), "null", 32L);
        pathList.add("writeAll");
        ArrayList<PermissionObject> writeAllChildList = new ArrayList<PermissionObject>();
        PermissionObject writePropertySet = new PermissionObject(writeAll, rb.getString("admp.ad_delegation.create_security_role.available_permission.write_property_set"), "null", 32L, true);
        ArrayList<PermissionObject> writePropertySetChildList = new ArrayList<PermissionObject>();
        ArrayList extendedList = (ArrayList)permissions.get("extendedPermission");
        for (int i = 0; i < extendedList.size(); ++i) {
            Properties p = (Properties)extendedList.get(i);
            String validAccesses = this.getString(p, "validAccesses");
            String displayName = this.getString(p, "displayName");
            String rightsGUID = this.getString(p, "rightsGUID");
            list = (ArrayList)p.get("properties");
            if (!validAccesses.equals("48")) continue;
            PermissionObject writeObj = new PermissionObject(writePropertySet, rb.getString("admp.ad_delegation.create_security_role.available_permission.write") + displayName, rightsGUID, 32L);
            if (list.size() > 0) {
                writeObj.setChildObjectList(this.getPropertyObjects(list, rb.getString("admp.ad_delegation.create_security_role.available_permission.write"), 32L, writeObj));
            }
            writePropertySetChildList.add(writeObj);
        }
        writePropertySet.setChildObjectList(writePropertySetChildList);
        writeAllChildList.add(writePropertySet);
        PermissionObject writePropertyPermissions = new PermissionObject(writeAll, rb.getString("admp.ad_delegation.create_security_role.available_permission.write_property_permissions"), "null", 32L, true);
        ArrayList<PermissionObject> writePropertyChildList = new ArrayList<PermissionObject>();
        String[] arr = new String[]{"mayContain", "mustContain", "systemMayContain", "systemMustContain"};
        Properties property = (Properties)permissions.get("schemaPermission");
        for (int i = 0; i < arr.length; ++i) {
            list = (ArrayList)property.get(arr[i]);
            for (int j = 0; j < list.size(); ++j) {
                Properties p = (Properties)list.get(j);
                String displayName = this.getString(p, "ldapDisplayName");
                String schemaIDGuid = this.getString(p, "schemaIDGUID");
                PermissionObject write = new PermissionObject(writePropertyPermissions, rb.getString("admp.ad_delegation.create_security_role.available_permission.write") + displayName, schemaIDGuid, 32L);
                writePropertyChildList.add(write);
            }
        }
        writePropertyPermissions.setChildObjectList(writePropertyChildList);
        writeAllChildList.add(writePropertyPermissions);
        writeAll.setChildObjectList(writeAllChildList);
        return writeAll;
    }

    private PermissionObject getDelete(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject deletePermission = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.delete"), "null", 65536L);
        pathList.add("deletePermission");
        return deletePermission;
    }

    private PermissionObject getDeleteSubtree(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject deleteSubtree = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.delete_subtree"), "null", 64L);
        pathList.add("deleteSubtree");
        return deleteSubtree;
    }

    private PermissionObject getReadPermissions(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject readPermissions = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.read_permissions"), "null", 131072L);
        pathList.add("readPermissions");
        return readPermissions;
    }

    private PermissionObject getModifyPermissions(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject modifyPermissions = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.modify_permissions"), "null", 262144L);
        pathList.add("modifyPermissions");
        return modifyPermissions;
    }

    private PermissionObject getModifyOwner(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject modifyOwner = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.modify_owner"), "null", 524288L);
        pathList.add("modifyOwner");
        return modifyOwner;
    }

    private PermissionObject getValidatedWrites(HttpServletRequest request, Properties permissions, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject validatedWrites = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.all_validated_writes"), "null", 8L);
        pathList.add("validatedWrites");
        ArrayList<PermissionObject> childList = new ArrayList<PermissionObject>();
        ArrayList extendedList = (ArrayList)permissions.get("extendedPermission");
        for (int i = 0; i < extendedList.size(); ++i) {
            Properties p = (Properties)extendedList.get(i);
            String validAccesses = this.getString(p, "validAccesses");
            String displayName = this.getString(p, "displayName");
            String rightsGUID = this.getString(p, "rightsGUID");
            ArrayList list = (ArrayList)p.get("properties");
            if (!validAccesses.equals("8")) continue;
            PermissionObject obj = new PermissionObject(validatedWrites, displayName, rightsGUID, 8L);
            if (list.size() > 0) {
                obj.setChildObjectList(this.getPropertyObjects(list, null, 8L, obj));
            }
            childList.add(obj);
        }
        validatedWrites.setChildObjectList(childList);
        return validatedWrites;
    }

    private PermissionObject getExtendedRights(HttpServletRequest request, Properties permissions, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject extendedRights = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.all_extended_rights"), "null", 256L);
        pathList.add("extendedRights");
        ArrayList<PermissionObject> childList = new ArrayList<PermissionObject>();
        ArrayList extendedList = (ArrayList)permissions.get("extendedPermission");
        for (int i = 0; i < extendedList.size(); ++i) {
            Properties p = (Properties)extendedList.get(i);
            String validAccesses = this.getString(p, "validAccesses");
            String displayName = this.getString(p, "displayName");
            String rightsGUID = this.getString(p, "rightsGUID");
            ArrayList list = (ArrayList)p.get("properties");
            if (!validAccesses.equals("256")) continue;
            PermissionObject obj = new PermissionObject(extendedRights, displayName, rightsGUID, 256L);
            if (list.size() > 0) {
                obj.setChildObjectList(this.getPropertyObjects(list, null, 256L, obj));
            }
            childList.add(obj);
        }
        extendedRights.setChildObjectList(childList);
        return extendedRights;
    }

    private PermissionObject getCreateAllChildObjects(HttpServletRequest request, Properties permissions, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject createObjectsPermissions = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.create_all_child_objects"), "null", 1L);
        pathList.add("createObjectsPermissions");
        ArrayList<PermissionObject> childList = new ArrayList<PermissionObject>();
        ArrayList list = (ArrayList)permissions.get("objectClasses");
        for (int i = 0; i < list.size(); ++i) {
            Properties p = (Properties)list.get(i);
            String ldapDisplayName = this.getString(p, "lDAPDisplayName", 1);
            String rightsGUID = this.getString(p, "schemaIDGUID");
            PermissionObject createObj = new PermissionObject(createObjectsPermissions, MessageFormat.format(rb.getString("admp.ad_delegation.create_security_role.available_permission.create_objects"), ldapDisplayName), rightsGUID, 1L);
            childList.add(createObj);
        }
        createObjectsPermissions.setChildObjectList(childList);
        return createObjectsPermissions;
    }

    private PermissionObject getDeleteAllChildObjects(HttpServletRequest request, Properties permissions, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject deleteObjectsPermissions = new PermissionObject(parentObject, rb.getString("admp.ad_delegation.create_security_role.available_permission.delete_all_child_objects"), "null", 2L);
        pathList.add("deleteObjectsPermissions");
        ArrayList<PermissionObject> childList = new ArrayList<PermissionObject>();
        ArrayList list = (ArrayList)permissions.get("objectClasses");
        for (int i = 0; i < list.size(); ++i) {
            Properties p = (Properties)list.get(i);
            String ldapDisplayName = this.getString(p, "lDAPDisplayName", 1);
            String rightsGUID = this.getString(p, "schemaIDGUID");
            PermissionObject deleteObj = new PermissionObject(deleteObjectsPermissions, MessageFormat.format(rb.getString("admp.ad_delegation.create_security_role.available_permission.delete_objects"), ldapDisplayName), rightsGUID, 2L);
            childList.add(deleteObj);
        }
        deleteObjectsPermissions.setChildObjectList(childList);
        return deleteObjectsPermissions;
    }

    private PermissionObject getListObject(HttpServletRequest request, ArrayList pathList, PermissionObject parentObject) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        PermissionObject listObject = new PermissionObject(parentObject, rb.getString("admp.mgmt.security_mgmt.cre_sec_role.permission.listobject"), "null", 128L);
        pathList.add("listObject");
        return listObject;
    }

    private ArrayList getPropertyObjects(ArrayList list, String readWrite, long accessMask, PermissionObject parentObject) {
        ArrayList<PermissionObject> childList = new ArrayList<PermissionObject>();
        for (int i = 0; i < list.size(); ++i) {
            Properties p = (Properties)list.get(i);
            String displayName = this.getString(p, "ldapDisplayName");
            String schemaIDGuid = this.getString(p, "schemaIDGUID");
            if (readWrite != null) {
                displayName = readWrite + " " + displayName;
            }
            PermissionObject o = new PermissionObject(parentObject, displayName, schemaIDGuid, accessMask);
            childList.add(o);
        }
        return childList;
    }

    private PermissionObject getPermissionObject(PermissionObject object, String schemaId, long accessMask) {
        ArrayList childList;
        boolean ret = false;
        String id = object.getID();
        long mask = object.getAccessMask();
        if (id.equals(schemaId) && mask == accessMask) {
            ret = true;
            return object;
        }
        if (!ret && (childList = object.getChildObjectList()).size() > 0) {
            for (int i = 0; i < childList.size(); ++i) {
                PermissionObject res = this.getPermissionObject((PermissionObject)childList.get(i), schemaId, accessMask);
                if (res == null) continue;
                return res;
            }
        }
        return null;
    }

    private void getParentObjects(PermissionObject object, ArrayList list) {
        PermissionObject parentObject = object.getParent();
        if (parentObject != null) {
            list.add(parentObject);
            this.getParentObjects(parentObject, list);
        }
    }
}

