/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.security.webclient.util;

import com.adventnet.customview.CustomViewManager;
import com.adventnet.customview.CustomViewRequest;
import com.adventnet.customview.ViewData;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.idioms.tablenavigator.TableNavigatorModel;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.security.server.util.DateTimeUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class SecurityClientUtil {
    public static ArrayList getTemplates(Long loginId) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMTemplates", (Row)null);
            Iterator it = dataObj.getRows("ADSMTemplates");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                p.put("TEMPLATE_NAME", r.get("TEMPLATE_NAME"));
                p.put("MODIFIED_BY", r.get("MODIFIED_BY"));
                p.put("DESCRIPTION", r.get("DESCRIPTION"));
                Long modifiedOn = (Long)r.get("MODIFIED_TIME");
                p.put("MODIFIED_TIME", DateTimeUtil.formatDate((Long)modifiedOn, (Long)loginId));
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getTemplateDetails(HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Criteria crit = new Criteria(new Column("ADSMTemplates", "TEMPLATE_NAME"), (Object)"", 1);
            DataObject dataObj = CommonUtil.getPersistence((boolean[])new boolean[0]).getForPersonality("ADSMTemplates", crit);
            Iterator it = dataObj.getRows("ADSMTemplates");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Iterator aceIt = dataObj.getRows("ADSMACEList", r);
                StringBuffer buf = new StringBuffer();
                while (aceIt.hasNext()) {
                    Row ace = (Row)aceIt.next();
                    if (buf.length() > 0) {
                        buf.append(", ");
                    }
                    String typeString = (String)ace.get("TYPE_STRING");
                    buf.append(rb.getString(typeString) + "-" + rb.getString((String)ace.get("PERMISSION_STRING")) + "-" + rb.getString((String)ace.get("APPLIESTO_STRING")));
                }
                String description = (String)r.get("DESCRIPTION");
                Properties p = new Properties();
                p.put("TEMPLATE_NAME", (String)r.get("TEMPLATE_NAME"));
                p.put("TEMPLATE_ID", r.get("TEMPLATE_ID"));
                if (description != null && !description.equals("")) {
                    p.put("DESCRIPTION", rb.getString(description));
                } else {
                    p.put("DESCRIPTION", description);
                }
                p.put("ACEs", buf.toString());
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getRecentTemplates(Long loginId) {
        ArrayList<Properties> templateList = new ArrayList<Properties>();
        try {
            Table table = new Table("ADSMTemplates");
            Column templateName = new Column("ADSMTemplates", "TEMPLATE_NAME");
            SortColumn sortColumn = new SortColumn("ADSMTemplates", "CREATION_TIME", false);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            selectColumnList.add(new Column("ADSMTemplates", "TEMPLATE_NAME"));
            selectColumnList.add(new Column("ADSMTemplates", "TEMPLATE_ID"));
            selectColumnList.add(new Column("ADSMTemplates", "CREATION_TIME"));
            selectColumnList.add(new Column("ADSMTemplates", "MODIFIED_TIME"));
            selectColumnList.add(new Column("ADSMTemplates", "MODIFIED_BY"));
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            selectQuery.addSortColumn(sortColumn);
            selectQuery.addSelectColumns(selectColumnList);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            int size = dataObject.size("ADSMTemplates");
            if (size > 5) {
                Range range = new Range(1, 5);
                selectQuery.setRange(range);
                dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            }
            Iterator itr = dataObject.getRows("ADSMTemplates");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Properties templateProperties = new Properties();
                templateProperties.put("TEMPLATE_NAME", row.get("TEMPLATE_NAME"));
                Long createdOn = (Long)row.get("CREATION_TIME");
                templateProperties.put("CREATION_TIME", DateTimeUtil.formatDate((Long)createdOn, (Long)loginId));
                Long modifiedOn = (Long)row.get("MODIFIED_TIME");
                templateProperties.put("MODIFIED_TIME", DateTimeUtil.formatDate((Long)modifiedOn, (Long)loginId));
                templateProperties.put("MODIFIED_BY", row.get("MODIFIED_BY"));
                templateList.add(templateProperties);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return templateList;
    }

    public static ArrayList getCommonSchemas(HttpServletRequest request) {
        Locale locale = request.getLocale();
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(locale);
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            Table table = new Table("ADSMCommonSchemas");
            Column schemaIdGuid = new Column("ADSMCommonSchemas", "SCHEMAID_GUID");
            Column schemaObject = new Column("ADSMCommonSchemas", "SCHEMA_OBJECT");
            Criteria criteria = new Criteria(schemaIdGuid, (Object)"null", 0);
            ArrayList<Column> selectColumnList = new ArrayList<Column>();
            selectColumnList.add(schemaIdGuid);
            selectColumnList.add(schemaObject);
            SelectQueryImpl selectQuery = new SelectQueryImpl(table);
            selectQuery.setCriteria(criteria);
            selectQuery.addSelectColumns(selectColumnList);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            Iterator it = dataObject.getRows("ADSMCommonSchemas");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                p.setProperty("SCHEMAID_GUID", (String)r.get("SCHEMAID_GUID"));
                p.setProperty("SCHEMA_OBJECT", rb.getString((String)r.get("SCHEMA_OBJECT")));
                list.add(p);
            }
            criteria = new Criteria(schemaIdGuid, (Object)"null", 1, false);
            SortColumn sortColumn = new SortColumn("ADSMCommonSchemas", "SCHEMA_OBJECT", true);
            selectQuery = new SelectQueryImpl(table);
            selectQuery.setCriteria(criteria);
            selectQuery.addSortColumn(sortColumn);
            selectQuery.addSelectColumns(selectColumnList);
            dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get((SelectQuery)selectQuery);
            it = dataObject.getRows("ADSMCommonSchemas");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                p.setProperty("SCHEMAID_GUID", (String)r.get("SCHEMAID_GUID"));
                p.setProperty("SCHEMA_OBJECT", rb.getString((String)r.get("SCHEMA_OBJECT")));
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void updateCommonSchema(ArrayList schemaList) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("ADSMCommonSchemas", (Row)null);
            Iterator it = dataObject.getRows("ADSMCommonSchemas");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                p.setProperty("SCHEMAID_GUID", (String)r.get("SCHEMAID_GUID"));
                p.setProperty("SCHEMA_OBJECT", (String)r.get("SCHEMA_OBJECT"));
                list.add(p);
            }
            ArrayList additionList = new ArrayList();
            ArrayList deletionList = new ArrayList();
            additionList = SecurityClientUtil.getResultList(schemaList, list);
            deletionList = SecurityClientUtil.getResultList(list, schemaList);
            System.out.println("additionList : " + additionList);
            System.out.println("deletionList : " + deletionList);
            if (additionList.size() > 0) {
                SecurityClientUtil.addRows(additionList);
            }
            if (deletionList.size() > 0) {
                SecurityClientUtil.deleteRows(deletionList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void addRows(ArrayList list) {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < list.size(); ++i) {
                Properties p = new Properties();
                p = (Properties)list.get(i);
                Row row = new Row("ADSMCommonSchemas");
                row.set("SCHEMAID_GUID", (Object)p.getProperty("SCHEMAID_GUID"));
                System.out.println("Adding row - schema id : " + p.getProperty("SCHEMAID_GUID"));
                row.set("SCHEMA_OBJECT", (Object)p.getProperty("SCHEMA_OBJECT"));
                System.out.println("Adding row - schema name : " + p.getProperty("SCHEMA_OBJECT"));
                dataObject.addRow(row);
            }
            CommonUtil.getPersistence((boolean[])new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void deleteRows(ArrayList list) {
        try {
            for (int i = 0; i < list.size(); ++i) {
                Properties p = new Properties();
                p = (Properties)list.get(i);
                String schemaId = p.getProperty("SCHEMAID_GUID");
                Column column = new Column("ADSMCommonSchemas", "SCHEMAID_GUID");
                Criteria criteria = new Criteria(column, (Object)schemaId, 0);
                CommonUtil.getPersistence((boolean[])new boolean[0]).delete(criteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static ArrayList getResultList(ArrayList list1, ArrayList list2) {
        ArrayList<Properties> resultList = new ArrayList<Properties>();
        for (int i = 0; i < list1.size(); ++i) {
            boolean flag = true;
            Properties p = new Properties();
            p = (Properties)list1.get(i);
            String string1 = p.getProperty("SCHEMAID_GUID");
            for (int j = 0; j < list2.size(); ++j) {
                Properties prop = new Properties();
                prop = (Properties)list2.get(j);
                String string2 = prop.getProperty("SCHEMAID_GUID");
                if (!string1.equals(string2)) continue;
                flag = false;
            }
            if (!flag) continue;
            resultList.add(p);
        }
        return resultList;
    }

    public static TableNavigatorModel getTableNavigatorModel(SelectQuery selectQuery) {
        TableNavigatorModel tableModel = null;
        try {
            CustomViewManager cvMan = (CustomViewManager)BeanUtil.lookup((String)"TableViewManager");
            CustomViewRequest cvReq = new CustomViewRequest(selectQuery);
            ViewData vData = cvMan.getData(cvReq);
            tableModel = (TableNavigatorModel)vData.getModel();
            return tableModel;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return tableModel;
        }
    }

    public static ArrayList getMyList() {
        try {
            DataObject dobj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("testtable", (Row)null);
            Iterator itr = dobj.getRows("testtable");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                System.out.println("column1" + row.get("column1"));
                System.out.println("column2" + row.get("column2"));
            }
        }
        catch (Exception e) {
            System.out.println("My Exception is +" + e);
        }
        return new ArrayList();
    }
}

