/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.sym.adsm.common.server.DCConfiguration.DCConfigUtil;
import com.adventnet.sym.adsm.common.server.DomainDatas;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.LocalizedException;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;

public class ADHandler {
    private static Logger nativeLogger = Logger.getLogger("ADSMLogger");
    private static Logger admangLogger = Logger.getLogger("ADMangLogger");
    private static Logger delegLogger = Logger.getLogger("DelegLogger");
    private static final String LIBRARY_NAME = "ADSMSecurity";
    private static final String MANAGED_LIBRARY_NAME = "ADSMManaged";
    private static ADHandler handler = null;
    public static final long ADMIN_LOGIN_ID = 1L;
    private static Logger logger = Logger.getLogger(ADHandler.class.getName());
    private static Hashtable domainValidDetails = new Hashtable();

    public static boolean isdebugLogLevel() {
        String loglevel = "";
        boolean isdebug = false;
        try {
            loglevel = ADSMPersUtil.getCurrentLogLevel();
            isdebug = loglevel.equalsIgnoreCase("DEBUG");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isdebug;
    }

    public static void log(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        nativeLogger.log(l, message);
    }

    public static Object getValidDC(String domainName, Object obj) {
        ArrayList arr = (ArrayList)obj;
        if (!domainValidDetails.containsKey(domainName)) {
            return null;
        }
        Hashtable dcValidDetails = (Hashtable)domainValidDetails.get(domainName);
        for (String dc : arr) {
            if (!dcValidDetails.containsKey(dc)) continue;
            ArrayList arr1 = (ArrayList)dcValidDetails.get(dc);
            String DWReservedStr = String.valueOf(arr1.get(0));
            Long time = (Long)arr1.get(1);
            if (time + 30000L > System.currentTimeMillis()) {
                Properties prop = new Properties();
                prop.put("dc", dc);
                prop.put("DWReservedStr", DWReservedStr);
                return prop;
            }
            dcValidDetails.remove(dc);
        }
        return null;
    }

    public static void addValidDC(String domainName, String dc, int dWReserved) {
        if (!domainValidDetails.containsKey(domainName)) {
            domainValidDetails.put(domainName, new Hashtable());
        }
        Hashtable dcValidDetails = (Hashtable)domainValidDetails.get(domainName);
        dcValidDetails.put(dc, new ArrayList());
        ArrayList arr = (ArrayList)dcValidDetails.get(dc);
        arr.add(0, dWReserved);
        arr.add(1, System.currentTimeMillis());
    }

    public static void admanglog(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        admangLogger.log(l, message);
    }

    public static void deleglog(int level, String message) {
        Level l = null;
        if (level == 1) {
            l = Level.INFO;
        } else if (level == 2) {
            l = Level.WARNING;
        } else if (level == 3) {
            l = Level.FINE;
        }
        delegLogger.log(l, message);
    }

    private static void handleError(NativeError errHdlr, Object objectName) throws Exception {
        errHdlr.checkForException(objectName);
    }

    public static void getValidDomains() throws Exception {
        ADHandler.GetValidDomains();
    }

    public static native void InitializeClassIDsManaged();

    public static native String ValidateUserCredentials(String var0, String var1, String var2);

    public static native void UploadPhoto(String var0, String var1, String var2, Properties var3, NativeError var4);

    public static native void GetUserPhoto(String var0, String var1, String var2, Properties var3, NativeError var4);

    public static native void RemovePhoto(String var0, String var1, String var2, Properties var3, NativeError var4);

    public static native ArrayList GetDCName(String var0);

    public static native void CleanupClassIDs();

    public static native String GetServiceStartupType(String var0, NativeError var1);

    public static native void SetServiceStartupType(String var0, boolean var1, NativeError var2);

    private static native long GetLocaleID(int var0, int var1, NativeError var2);

    private static native void InitializeClassIDs();

    private static native void GetValidDomains();

    private static native ArrayList GetObjectsWithOutListener(Properties var0, String var1, ArrayList var2, String var3, NativeError var4);

    private static native void GetObjects(Properties var0, String var1, ArrayList var2, String var3, NativeListener var4, NativeError var5);

    private static native void GetServiceAccounts(Properties var0, String var1, ArrayList var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native Object GetADObjects(Properties var0, String var1, String var2, NativeError var3);

    private static native long ChangePassword(Properties var0, String var1, String var2, String var3, String var4, NativeError var5);

    private static native long UserMustChangePassword(Properties var0, String var1, String var2, String var3, NativeError var4);

    private static native long SetPassword(Properties var0, String var1, String var2, NativeError var3);

    private static native Properties GetPasswordPolicy(Properties var0, NativeError var1);

    private static native Properties GetAccountLockOutPolicy(Properties var0, NativeError var1);

    private static native boolean CheckServerStatus(Properties var0, NativeError var1);

    private static native ArrayList GetGroups(Properties var0, ArrayList var1, NativeError var2);

    private static native void SearchSIDs(Properties var0, String var1, String var2, NativeListener var3, NativeError var4);

    private static native Properties GetObjectProperties(Properties var0, String var1, ArrayList var2, NativeError var3);

    public static native Properties GetDomainDetails(Properties var0, NativeError var1);

    private static native long SearchAndModifyUser(Properties var0, String var1, String var2, String var3, ArrayList var4, ArrayList var5, ArrayList var6, ArrayList var7, ArrayList var8, NativeError var9);

    private static native long ModifyGroup(Properties var0, String var1, ArrayList var2, ArrayList var3, NativeError var4);

    private static native long ModifyUserFullName(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native boolean CreateFolder(Properties var0, String var1, NativeError var2);

    private static native boolean SetFolderPermission(Properties var0, ArrayList var1, long var2, String var4, NativeError var5);

    private static native long MoveObject(Properties var0, String var1, String var2, NativeError var3);

    private static native Properties GetUserObject(Properties var0, String var1, ArrayList var2, NativeError var3);

    private static native boolean CheckCantChangePassword(Properties var0, String var1, NativeError var2);

    private static native boolean CheckPasswordNeverExpires(Properties var0, String var1, NativeError var2);

    private static native long ModifyUser(Properties var0, String var1, String var2, ArrayList var3, ArrayList var4, ArrayList var5, ArrayList var6, NativeListener var7, NativeError var8);

    private static native ArrayList GetOUs(Properties var0, NativeError var1);

    private static native ArrayList GetPasswordSettingObjects(Properties var0, NativeError var1);

    private static native void GetLockedOutAccounts(Properties var0, String var1, ArrayList var2, ArrayList var3, long var4, NativeListener var6, NativeError var7, Properties var8);

    private static native void GetSoonToExpireUsers(Properties var0, String var1, ArrayList var2, long var3, NativeListener var5, NativeError var6, Properties var7);

    private static native void GetSoonToPasswordExpireUsers(Properties var0, String var1, long var2, long var4, ArrayList var6, NativeListener var7, NativeError var8, Properties var9);

    private static native void GetSoonToPasswordExpireUsersForW2K8(Properties var0, String var1, ArrayList var2, ArrayList var3, long var4, long var6, NativeListener var8, NativeError var9, Properties var10);

    private static native void GetPasswordExpiredUsers(Properties var0, String var1, long var2, ArrayList var4, NativeListener var5, NativeError var6, Properties var7);

    private static native void GetPasswordExpiredUsersForW2K8(Properties var0, String var1, ArrayList var2, ArrayList var3, long var4, NativeListener var6, NativeError var7, Properties var8);

    private static native void GetInActiveComputers(Properties var0, String var1, long var2, ArrayList var4, NativeListener var5, NativeError var6);

    private static native void GetInActiveObjects(Properties var0, String var1, String var2, long var3, ArrayList var5, NativeListener var6, NativeError var7);

    private static native void GetInActiveUsers(Properties var0, String var1, String var2, long var3, ArrayList var5, NativeListener var6, NativeError var7);

    private static native void GetAccountExpiredUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4, Properties var5);

    private static native void GetDisabledAccounts(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetSmartcardAccounts(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void GetRecentlyDeletedUsers(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    private static native void Search(Properties var0, String var1, String var2, ArrayList var3, NativeListener var4, NativeError var5);

    private static native Properties GetObjectFromGUID(Properties var0, String var1, ArrayList var2, boolean var3, NativeError var4);

    private static native String UpdateRemoteRegistry(String var0, Properties var1, Properties var2, NativeError var3);

    private static native String CopyFile(String var0, String var1, String var2, Properties var3, String var4, NativeError var5);

    private static native boolean SetScriptPath(Properties var0, String var1, String var2, NativeError var3);

    private static native boolean RemoveScriptPath(Properties var0, String var1, String var2, NativeError var3);

    private static native long AddComputer(Properties var0, String var1, String var2, String var3, String var4, ArrayList var5, ArrayList var6, ArrayList var7, NativeError var8);

    private static native long UpdateComputer(Properties var0, String var1, ArrayList var2, NativeListener var3, NativeError var4);

    public static void getAccountExpiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAccountExpiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getRecentlyDeletedUsers(String domainName, Long loginId, ArrayList attributeList, NativeListener listener, String time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetRecentlyDeletedUsers(ADHandler.getDomainDetails(domainName, loginId), time, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getDisabledAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetDisabledAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSmartcardAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetSmartcardAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getAccountExpiredUsers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, long time, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetAccountExpiredUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getInActiveUsers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attributeList, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetInActiveUsers(domainDetails, CommonUtil.escapeDN(distinguishedName), dcName, time, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    private static native Properties authenticateADLogon(String var0, String var1, Properties var2, NativeError var3, String var4);

    private static native boolean authenticateSSPLogon(String var0, String var1, Properties var2, NativeError var3, String var4);

    public static Object getDomainObject(String domainName, Long loginId, String path) throws Exception {
        return ADHandler.getDomainObject(domainName, loginId, path, "false");
    }

    public static Object getDomainObject(String domainName, Long loginId, String path, String isGuidPassed) throws Exception {
        NativeError errHdlr = new NativeError();
        if (isGuidPassed == null) {
            isGuidPassed = "false";
        }
        Object object = ADHandler.GetADObjects(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(path), isGuidPassed, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return object;
    }

    public static ArrayList getObjectsWithOutListener(String domainName, ArrayList attributeList, String searchString) {
        ArrayList list = null;
        try {
            Properties domainDetails = ADHandler.getDomainDetails(domainName, 1L);
            String distinguishedName = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            NativeError errHdlr = new NativeError();
            list = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, searchString, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getOUs(String domainName, Long loginId) throws Exception {
        ArrayList list = new ArrayList();
        NativeError errHdlr = new NativeError();
        Properties p = ADHandler.getDomainDetails(domainName, loginId);
        list = ADHandler.GetOUs(p, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return list;
    }

    public static boolean checkServerStatus(String domainName, Long loginId) throws Exception {
        boolean serverRunning = false;
        NativeError errHdlr = new NativeError();
        serverRunning = ADHandler.CheckServerStatus(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return serverRunning;
    }

    public static boolean CheckServerStatus(String domainName, Long loginId) throws Exception {
        boolean serverRunning = false;
        NativeError errHdlr = new NativeError();
        serverRunning = ADHandler.CheckServerStatus(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        if (!errHdlr.getErrorMessage(domainName).isEmpty() && errHdlr.getErrorMessage(domainName).get(0).toString().equalsIgnoreCase("adssp.error.native.domainutil.servers_not_operational")) {
            return false;
        }
        return serverRunning;
    }

    public static String getServiceStartupType(String serviceName) throws Exception {
        String type = null;
        try {
            NativeError errHdlr = new NativeError();
            type = ADHandler.GetServiceStartupType(serviceName, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return type;
    }

    public static void getInActiveComputers(Properties domainDetails, String distinguishedName, String dcName, ArrayList attrB, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetInActiveObjects(domainDetails, CommonUtil.escapeDN(distinguishedName), dcName, time, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
    }

    public static void getInActiveComputers(String domainName, Long loginId, String distinguishedName, ArrayList attrB, NativeListener listener, long time) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetInActiveComputers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), time, attrB, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void setServiceStartupType(String serviceName, boolean type) throws Exception {
        try {
            NativeError errHdlr = new NativeError();
            ADHandler.SetServiceStartupType(serviceName, type, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static long getLocaleID(int primarylangId, int sublangId) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetLocaleID(primarylangId, sublangId, errHdlr);
    }

    public static void getObjects(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, String searchString, NativeListener listener) throws Exception {
        ADHandler.getObjects(ADHandler.getDomainDetails(domainName, loginId), distinguishedName, attributeList, searchString, listener);
    }

    public static void getObjects(Properties domainDetails, String distinguishedName, ArrayList attributeList, String searchString, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetObjects(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, searchString, listener, errHdlr);
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getServiceAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, ArrayList computerList, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetServiceAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, computerList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static ArrayList getObjectsWithOutListener(Properties domainDetails, String distinguishedName, ArrayList attributeList, String searchString) throws Exception {
        ArrayList list = null;
        NativeError errHdlr = new NativeError();
        list = ADHandler.GetObjectsWithOutListener(domainDetails, CommonUtil.escapeDN(distinguishedName), attributeList, searchString, errHdlr);
        ADHandler.handleError(errHdlr, domainDetails.get("DOMAIN_NAME"));
        return list;
    }

    public static ArrayList getPasswordSettingObjects(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList psoList = ADHandler.GetPasswordSettingObjects(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return psoList;
    }

    public static Properties getPasswordPolicy(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties p = ADHandler.GetPasswordPolicy(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return p;
    }

    public static Properties getAccountLockOutPolicy(String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties p = ADHandler.GetAccountLockOutPolicy(ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return p;
    }

    public static NativeError uploadPhoto(String userDN, String objGuid, String photoAttribute, String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.UploadPhoto(CommonUtil.escapeDN(userDN), objGuid, photoAttribute, ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        return errHdlr;
    }

    public static NativeError getUserPhoto(String userDN, String objGuid, String photoAttribute, String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetUserPhoto(CommonUtil.escapeDN(userDN), objGuid, photoAttribute, ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        return errHdlr;
    }

    public static NativeError removePhoto(String userDN, String objGuid, String photoAttribute, String domainName, Long loginId) throws Exception {
        NativeError errHdlr = new NativeError();
        try {
            ADHandler.RemovePhoto(CommonUtil.escapeDN(userDN), objGuid, photoAttribute, ADHandler.getDomainDetails(domainName, loginId), errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return errHdlr;
    }

    public static void setPassword(Long loginId, Hashtable userDetails, String updateInAllDCs) throws Exception {
        String domainName = (String)userDetails.get("DOMAIN_NAME");
        String userSID = (String)userDetails.get("USER_SID");
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.getDomainDetails(domainName, loginId);
        ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
        JSONArray dcsToBeUpdated = DCConfigUtil.getDCsToBeUpdated(dcList, userDetails, updateInAllDCs);
        int dcListSize = dcsToBeUpdated.length();
        boolean isSucceed = false;
        for (int index = 0; index < dcListSize; ++index) {
            ArrayList<Object> singleDcList = new ArrayList<Object>();
            singleDcList.add(dcsToBeUpdated.get(index));
            properties.put("DOMAIN_CONTROLLER_LIST", singleDcList);
            admangLogger.log(Level.INFO, "DC no : " + index + " = " + dcsToBeUpdated.get(index));
            long returnValue = ADHandler.SetPassword(properties, userSID, (String)userDetails.get("PASSWORD"), errHdlr);
            if (returnValue != 0L) continue;
            isSucceed = true;
        }
        if (!isSucceed) {
            ADHandler.HandleErrorForMultipleDCs(errHdlr, userSID, domainName);
        }
    }

    public static void changePassword(Long loginId, String updateInAllDCs, Hashtable userDetails) throws Exception {
        String domainName = (String)userDetails.get("DOMAIN_NAME");
        String userSID = (String)userDetails.get("USER_SID");
        String oldPassword = (String)userDetails.get("OLD_PASSWORD");
        String userName = (String)userDetails.get("USER_NAME");
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.getDomainDetails(domainName, 1L, oldPassword);
        ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
        JSONArray dcsToBeUpdated = DCConfigUtil.getDCsToBeUpdated(dcList, userDetails, updateInAllDCs);
        int dcListSize = dcsToBeUpdated.length();
        boolean isSucceed = false;
        for (int index = 0; index < dcListSize; ++index) {
            ArrayList<Object> singleDcList = new ArrayList<Object>();
            singleDcList.add(dcsToBeUpdated.get(index));
            properties.put("DOMAIN_CONTROLLER_LIST", singleDcList);
            admangLogger.log(Level.INFO, "DC no : " + index + " = " + dcsToBeUpdated.get(index));
            long returnValue = ADHandler.ChangePassword(properties, (String)userDetails.get("USER_SID"), userName, oldPassword, (String)userDetails.get("NEW_PASSWORD"), errHdlr);
            if (returnValue != 0L) continue;
            isSucceed = true;
        }
        if (!isSucceed) {
            ArrayList errorMsg = errHdlr.getErrorMessage((String)userDetails.get("USER_SID"));
            if (errorMsg.contains("adssp.native.err.changepassword")) {
                errHdlr = new NativeError();
                if (!ADHandler.powerShellChangePassword(userDetails, updateInAllDCs, errHdlr, false, false)) {
                    ADHandler.HandleErrorForMultipleDCs(errHdlr, userSID, domainName);
                }
            } else {
                ADHandler.HandleErrorForMultipleDCs(errHdlr, userSID, domainName);
            }
        }
    }

    public static void userMustChangePassword(Long loginId, String updateInAllDCs, Hashtable userDetails) throws Exception {
        String domainName = (String)userDetails.get("DOMAIN_NAME");
        String userSID = (String)userDetails.get("USER_SID");
        String oldPassword = (String)userDetails.get("OLD_PASSWORD");
        String userName = (String)userDetails.get("USER_NAME");
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.getDomainDetails(domainName, 1L, oldPassword);
        ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
        JSONArray dcsToBeUpdated = DCConfigUtil.getDCsToBeUpdated(dcList, userDetails, updateInAllDCs);
        int dcListSize = dcsToBeUpdated.length();
        boolean isSucceed = false;
        for (int index = 0; index < dcListSize; ++index) {
            ArrayList<Object> singleDcList = new ArrayList<Object>();
            singleDcList.add(dcsToBeUpdated.get(index));
            properties.put("DOMAIN_CONTROLLER_LIST", singleDcList);
            admangLogger.log(Level.INFO, "DC no : " + index + " = " + dcsToBeUpdated.get(index));
            long returnValue = ADHandler.UserMustChangePassword(properties, (String)userDetails.get("USER_SID"), oldPassword, (String)userDetails.get("NEW_PASSWORD"), errHdlr);
            if (returnValue != 0L) continue;
            isSucceed = true;
        }
        if (!isSucceed) {
            ArrayList errorMsg = errHdlr.getErrorMessage((String)userDetails.get("USER_SID"));
            if (errorMsg.contains("adssp.native.err.changepassword")) {
                errHdlr = new NativeError();
                if (!ADHandler.powerShellUserMustChangePassword(userDetails, updateInAllDCs, errHdlr, false)) {
                    ADHandler.HandleErrorForMultipleDCs(errHdlr, userSID, domainName);
                }
            } else {
                ADHandler.HandleErrorForMultipleDCs(errHdlr, userSID, domainName);
            }
        }
    }

    public static Properties getDomainDetails(String domainName, Long loginId) throws Exception {
        return ADHandler.getDomainDetails(domainName, loginId, null);
    }

    public static Properties getDomainDetails(String domainName, Long loginId, String oldPassword) throws Exception {
        return DomainHandler.getConfiguredValues(domainName, loginId, oldPassword);
    }

    public static ArrayList getGroups(String domainName, Long loginId, ArrayList attrB) throws Exception {
        NativeError errHdlr = new NativeError();
        ArrayList list = ADHandler.GetGroups(ADHandler.getDomainDetails(domainName, loginId), attrB, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return list;
    }

    public static void searchSIDs(String domainName, Long loginId, String container, String searchString, NativeListener listener) {
        try {
            NativeError errHdlr = new NativeError();
            ADHandler.SearchSIDs(ADHandler.getDomainDetails(domainName, loginId), container, searchString, listener, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getObjectProperties(String domainName, Long loginId, String objDN, ArrayList attributeList) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.GetObjectProperties(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(objDN), attributeList, errHdlr);
        if (errHdlr != null) {
            ADHandler.handleError(errHdlr, domainName);
        }
        return properties;
    }

    public static NativeError searchAndModifyUser(String domainName, Long loginId, String distinguishedName, String searchString, String password, ArrayList propList, ArrayList modifyList, ArrayList tsList, ArrayList winNTAttributeList, ArrayList groupList) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.SearchAndModifyUser(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), searchString, password, propList, modifyList, tsList, winNTAttributeList, groupList, errHdlr);
        return errHdlr;
    }

    public static long modifyGroup(String domainName, Long loginId, String sid, ArrayList propList, ArrayList groupList) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.ModifyGroup(ADHandler.getDomainDetails(domainName, loginId), sid, propList, groupList, errHdlr);
        ADHandler.handleError(errHdlr, sid);
        return val;
    }

    public static long modifyUserFullName(String domainName, Long loginId, String userDN, String modifyValue, ArrayList attr) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        NativeListener listener = null;
        val = ADHandler.ModifyUserFullName(ADHandler.getDomainDetails(domainName, loginId), userDN, modifyValue, attr, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static NativeError createFolder(String domainName, Long loginId, String directoryPath, String trusteeSid, String trusteeDn, ArrayList acList, long ineritFromParent) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
        boolean isFolderCreated = ADHandler.CreateFolder(domainDetails, directoryPath, errHdlr);
        if (isFolderCreated) {
            ADHandler.SetFolderPermission(domainDetails, acList, ineritFromParent, directoryPath, errHdlr);
        }
        return errHdlr;
    }

    public static void moveObject(String domainName, Long loginId, String sourceDN, String destinationDN) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.MoveObject(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(sourceDN), CommonUtil.escapeDN(destinationDN), errHdlr);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static long unlockUser(Long loginId, String updateInAllDCs, Hashtable userDetails) throws Exception {
        long returnValue = 0L;
        NativeError errHdlr = new NativeError();
        int dcListSize = 0;
        String domainName = (String)userDetails.get("DOMAIN_NAME");
        String userSID = (String)userDetails.get("USER_SID");
        boolean isSucceed = false;
        try {
            Properties properties = ADHandler.getDomainDetails(domainName, loginId);
            ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
            ArrayList<Properties> propList = new ArrayList<Properties>();
            Properties attribProps = new Properties();
            attribProps.put("DATA_HANDLER_TYPE", new Long(10L));
            attribProps.put("ATTRIB_VALUE_COUNT", new Long(1L));
            attribProps.put("ATTRIB_LDAP_NAME", "lockoutTime");
            attribProps.put("ATTRIB_VALUE", new Long(0L));
            propList.add(attribProps);
            JSONArray dcsToBeUpdated = DCConfigUtil.getDCsToBeUpdated(dcList, userDetails, updateInAllDCs);
            dcListSize = dcsToBeUpdated.length();
            for (int index = 0; index < dcListSize; ++index) {
                ArrayList<Object> singleDcList = new ArrayList<Object>();
                singleDcList.add(dcsToBeUpdated.get(index));
                properties.put("DOMAIN_CONTROLLER_LIST", singleDcList);
                admangLogger.log(Level.INFO, "DC no : " + index + " = " + dcsToBeUpdated.get(index));
                returnValue = ADHandler.ModifyUser(properties, userSID, (String)userDetails.get("USER_NAME"), propList, new ArrayList(), null, new ArrayList(), null, errHdlr);
                if (returnValue != 0L) continue;
                isSucceed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!isSucceed) {
            ADHandler.HandleErrorForMultipleDCs(errHdlr, userSID, domainName);
        }
        return returnValue;
    }

    public static long modifyUser(String domainName, Long loginId, String sid, String userName, ArrayList propList, ArrayList modifyList, ArrayList winNTAttributeList, ArrayList attributeList, NativeListener listener, String allDC) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = ADHandler.getDomainDetails(domainName, loginId);
        ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
        long returnValue = ADHandler.ModifyUser(properties, sid, userName, propList, modifyList, winNTAttributeList, attributeList, listener, errHdlr);
        ADHandler.handleError(errHdlr, domainName);
        return returnValue;
    }

    public static void HandleErrorForMultipleDCs(NativeError errHdlr, String sid, String domainName) throws Exception {
        ArrayList messageList = errHdlr.getErrorMessage(sid);
        ArrayList domainMsgList = errHdlr.getErrorMessage(domainName);
        if (messageList.size() == 0) {
            sid = domainName;
        }
        ADHandler.handleError(errHdlr, sid);
    }

    public static Properties getUserTerminalObjects(String domainName, Long loginId, String guid, ArrayList tsList) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.GetUserObject(ADHandler.getDomainDetails(domainName, loginId), guid, tsList, errHdlr);
    }

    public static boolean checkCantChangePassword(String domainName, Long loginId, String userName) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.CheckCantChangePassword(ADHandler.getDomainDetails(domainName, loginId), userName, errHdlr);
    }

    public static boolean checkPasswordNeverExpires(String domainName, Long loginId, String sid) throws Exception {
        NativeError errHdlr = new NativeError();
        return ADHandler.CheckPasswordNeverExpires(ADHandler.getDomainDetails(domainName, loginId), sid, errHdlr);
    }

    public static void getLockedOutAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, ArrayList psoList, long domLockDur, NativeListener listener, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.GetLockedOutAccounts(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, psoList, domLockDur, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getLockedOutAccounts(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, ArrayList psoList, long domLockDur, NativeListener listener) throws Exception {
        ADHandler.getLockedOutAccounts(domainName, loginId, distinguishedName, attributeList, psoList, domLockDur, listener, new Properties());
    }

    public static void getPasswordExpiredUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxpwdtime, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        if (filterProps == null) {
            filterProps = new Properties();
        }
        ADHandler.GetPasswordExpiredUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), maxpwdtime, attributeList, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getPasswordExpiredUsersForW2K8(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, ArrayList psoList, long domMaxPwdTime, NativeListener listener, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        if (filterProps == null) {
            filterProps = new Properties();
        }
        ADHandler.GetPasswordExpiredUsersForW2K8(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, psoList, domMaxPwdTime, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSoonToExpireUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long time, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        if (filterProps == null) {
            filterProps = new Properties();
        }
        ADHandler.GetSoonToExpireUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, time, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSoonToPasswordExpireUsers(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, NativeListener listener, long maxpwdtime, long expiretime, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        if (filterProps == null) {
            filterProps = new Properties();
        }
        ADHandler.GetSoonToPasswordExpireUsers(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), maxpwdtime, expiretime, attributeList, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void getSoonToPasswordExpireUsersForW2K8(String domainName, Long loginId, String distinguishedName, ArrayList attributeList, ArrayList psoList, long domMaxPwdAgeTime, long reportTime, NativeListener listener, Properties filterProps) throws Exception {
        NativeError errHdlr = new NativeError();
        if (filterProps == null) {
            filterProps = new Properties();
        }
        ADHandler.GetSoonToPasswordExpireUsersForW2K8(ADHandler.getDomainDetails(domainName, loginId), CommonUtil.escapeDN(distinguishedName), attributeList, psoList, domMaxPwdAgeTime, reportTime, listener, errHdlr, filterProps);
        ADHandler.handleError(errHdlr, domainName);
    }

    public static void searchACE(String domainName, Long loginId, String adsPath, String trustee, ArrayList aceList, Properties dnSIDMap, NativeListener listener) throws Exception {
        NativeError errHdlr = new NativeError();
        ADHandler.Search(ADHandler.getDomainDetails(domainName, loginId), adsPath, trustee, aceList, listener, errHdlr);
    }

    public static synchronized boolean DomainUserSSPLogonAuth(String serverName, String domainName, String loginName, String password, String isSSL) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
        String dnName = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
        loginName = StrUtil.ldapEscape(loginName);
        String searchString = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + loginName + "))";
        return ADHandler.authenticateSSPLogon(loginName, password, domainDetails, errHdlr, searchString);
    }

    public static Properties DomainUserADAuth(String serverName, String domainName, String loginName, String password, String isSSL) throws Exception {
        admangLogger.log(Level.INFO, "DomainUserAuthenticate invoked");
        NativeError errHdlr = new NativeError();
        Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
        String dnName = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
        String searchString = "(&(objectClass=user)(objectCategory=person)(samAccountName=" + StrUtil.ldapEscape(loginName) + "))";
        Properties retVal = ADHandler.authenticateADLogon(loginName, password, domainDetails, errHdlr, searchString);
        ArrayList messageList = errHdlr.getErrorMessage(domainName);
        if (!messageList.isEmpty()) {
            String statusMessage = (String)messageList.get(0);
            retVal.put("Bind_Error", statusMessage);
        }
        return retVal;
    }

    public static Properties getObjectFromGUID(Properties p, String guid, ArrayList attributeList) throws Exception {
        return ADHandler.getObjectFromGUID(p, guid, attributeList, false);
    }

    public static Properties getObjectFromGUID(Properties p, String guid, ArrayList attributeList, boolean needDN) throws Exception {
        NativeError errHdlr = new NativeError();
        Properties properties = null;
        try {
            properties = ADHandler.GetObjectFromGUID(p, guid, attributeList, needDN, errHdlr);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return properties;
    }

    public static String UpdateRegistry(String compName, Properties prop, String domainName) throws Exception {
        NativeError errHdlr = new NativeError();
        String destPath = "\\\\" + compName + "\\ADMIN$\\System32\\reset_icon.bmp";
        prop.put("DESTINATION", destPath);
        Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
        prop.put("PORT_NO", String.valueOf(prop.get("PORT_NO")));
        String retStatus = ADHandler.UpdateRemoteRegistry(compName, prop, domainDetails, errHdlr);
        ADHandler.handleError(errHdlr, compName);
        return retStatus;
    }

    public static String CopyFileToClient(String srcPath, String destPath) throws Exception {
        return ADHandler.CopyFileToClient(srcPath, destPath, null, null);
    }

    public static String CopyFileToClient(String srcPath, String destPath, String machineName, String domainName) throws Exception {
        NativeError errHdlr = new NativeError();
        String currTime = String.valueOf(System.currentTimeMillis());
        Properties domainDetails = null;
        if (domainName != null) {
            domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
        }
        String status = ADHandler.CopyFile(srcPath, destPath, machineName, domainDetails, currTime, errHdlr);
        admangLogger.log(Level.INFO, "The status is " + status);
        if (status != null && !status.equalsIgnoreCase("adssp.config.management.agent_scheduler.file_copy_success")) {
            ADHandler.handleError(errHdlr, currTime);
        }
        return status;
    }

    public static String setScriptPath(String domainName, String jSid, String attributeValue) {
        String status = "adssp.common.text.success";
        try {
            NativeError errHdlr = new NativeError();
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
            ADHandler.SetScriptPath(domainDetails, jSid, attributeValue, errHdlr);
            ADHandler.handleError(errHdlr, jSid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static String removeScriptPath(String domainName, String jSid, String attributeValue) {
        String status = "adssp.common.text.success";
        try {
            NativeError errHdlr = new NativeError();
            Properties domainDetails = (Properties)DomainDatas.getInstance().getValue(domainName, "DomainDetails");
            if (domainDetails == null) {
                domainDetails = DomainHandler.getConfiguredValues(domainName, 1L);
                DomainDatas.getInstance().setValue(domainName, "DomainDetails", domainDetails);
            }
            if (!ADHandler.RemoveScriptPath(domainDetails, jSid, attributeValue, errHdlr)) {
                status = "adssp.common.text.failure";
            }
            ADHandler.handleError(errHdlr, jSid);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static NativeError addComputer(String domainName, Long loginId, String containerName, String compName, String samAccountName, String password, ArrayList propList, ArrayList modifyList, ArrayList groupList) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        containerName = CommonUtil.escapeDN(containerName);
        val = ADHandler.AddComputer(ADHandler.getDomainDetails(domainName, loginId), containerName, compName, samAccountName, password, propList, modifyList, groupList, errHdlr);
        return errHdlr;
    }

    public static long updateComputer(String domainName, Long loginId, String sid, ArrayList attributeList, NativeListener listener) throws Exception {
        long val = 0L;
        NativeError errHdlr = new NativeError();
        val = ADHandler.UpdateComputer(ADHandler.getDomainDetails(domainName, loginId), sid, attributeList, listener, errHdlr);
        ArrayList messageList = errHdlr.getErrorMessage(sid);
        if (messageList != null) {
            throw new LocalizedException(messageList);
        }
        ADHandler.handleError(errHdlr, domainName);
        return val;
    }

    public static boolean powerShellChangePassword(Hashtable userDetails, String updateInAllDCs, NativeError errHdlr, boolean triedAlready, boolean umcp) throws Exception {
        try {
            String command = "powershell.exe -Command -";
            String domainName = (String)userDetails.get("DOMAIN_NAME");
            String userSID = (String)userDetails.get("USER_SID");
            String oldPassword = (String)userDetails.get("OLD_PASSWORD");
            String userName = (String)userDetails.get("USER_NAME");
            String newPassword = (String)userDetails.get("NEW_PASSWORD");
            Properties properties = ADHandler.getDomainDetails(domainName, 1L, oldPassword);
            ArrayList dcList = (ArrayList)properties.get("DOMAIN_CONTROLLER_LIST");
            JSONArray dcsToBeUpdated = DCConfigUtil.getDCsToBeUpdated(dcList, userDetails, updateInAllDCs);
            int dcListSize = dcsToBeUpdated.length();
            boolean isSucceed = false;
            String outputText = "";
            properties.put("DC_LIST", dcsToBeUpdated);
            for (int index = 0; index < dcListSize; ++index) {
                String line;
                outputText = "";
                ArrayList<Object> singleDcList = new ArrayList<Object>();
                singleDcList.add(dcsToBeUpdated.get(index));
                properties.put("DOMAIN_CONTROLLER_LIST", singleDcList);
                Process powerShellProcess = Runtime.getRuntime().exec(command);
                PrintWriter writer = new PrintWriter((Writer)new OutputStreamWriter(new BufferedOutputStream(powerShellProcess.getOutputStream())), true);
                String script = "";
                if (properties.getProperty("USER_NAME") != null && !properties.getProperty("USER_NAME").equalsIgnoreCase("")) {
                    script = "$User = \"" + StrUtil.powerShellEscape(properties.getProperty("DOMAIN_NAME")) + "\\" + StrUtil.powerShellEscape(properties.getProperty("USER_NAME")) + "\";" + "$PWord = ConvertTo-SecureString -String \"" + StrUtil.powerShellEscape(properties.getProperty("PASSWORD")) + "\" -AsPlainText -Force;" + "$Credential = New-Object -TypeName \"System.Management.Automation.PSCredential\" -ArgumentList $User, $PWord;";
                }
                script = script + "Invoke-Command -ComputerName " + StrUtil.powerShellEscape((String)dcsToBeUpdated.get(index)) + " -ScriptBlock {" + "$User = \"" + StrUtil.powerShellEscape(userName) + "\";" + "$PWord = ConvertTo-SecureString -String \"" + StrUtil.powerShellEscape(oldPassword) + "\" -AsPlainText -Force;" + "$cred = New-Object -TypeName \"System.Management.Automation.PSCredential\" -ArgumentList $User, $PWord;" + "$newpassword = ConvertTo-SecureString -String \"" + StrUtil.powerShellEscape(newPassword) + "\" -AsPlainText -Force;" + "$oldpassword = ConvertTo-SecureString -String \"" + StrUtil.powerShellEscape(oldPassword) + "\" -AsPlainText -Force;" + "try{import-module ActiveDirectory;Set-ADAccountPassword -Identity $User -NewPassword $newpassword -OldPassword $oldpassword ";
                if (!umcp) {
                    script = script + "-Credential $cred";
                }
                script = script + ";\"CHANGESUCCESS\"}catch{$_.Exception.ErrorCode}}";
                if (properties.getProperty("USER_NAME") != null && !properties.getProperty("USER_NAME").equalsIgnoreCase("")) {
                    script = script + " -Credential $Credential";
                }
                writer.println(script);
                writer.flush();
                powerShellProcess.getOutputStream().close();
                BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream()));
                while ((line = stdout.readLine()) != null) {
                    outputText = outputText + line;
                }
                stdout.close();
                BufferedReader stderr = new BufferedReader(new InputStreamReader(powerShellProcess.getErrorStream()));
                while ((line = stderr.readLine()) != null) {
                    outputText = outputText + line;
                }
                logger.log(Level.INFO, "ChangePasswordError:" + outputText);
                stderr.close();
                String errorCode = ADHandler.getErrorCodeFromPowerShell(outputText);
                if (errorCode.equals("")) continue;
                if (!errorCode.equals("0")) {
                    errHdlr.setErrorList(userSID, "SEVERE", errorCode, "adssp.native.err.powershell.changepassword_troubleshoot", null);
                    return false;
                }
                return true;
            }
            if (triedAlready) {
                errHdlr.setErrorList(userSID, "SEVERE", "", "adssp.native.err.powershell.changepassword_troubleshoot", null);
                return false;
            }
            ADHandler.powerShellSetupCommands(properties);
            logger.log(Level.INFO, "trying change password again");
            return ADHandler.powerShellChangePassword(userDetails, updateInAllDCs, errHdlr, true, umcp);
        }
        catch (Exception e) {
            errHdlr.setErrorList((String)userDetails.get("USER_SID"), "SEVERE", "", "adssp.native.err.powershell.changepassword_troubleshoot", null);
            e.printStackTrace();
            return false;
        }
    }

    public static boolean powerShellUserMustChangePassword(Hashtable userDetails, String updateInAllDCs, NativeError errHdlr, boolean triedAlready) throws Exception {
        return ADHandler.powerShellChangePassword(userDetails, updateInAllDCs, errHdlr, triedAlready, true);
    }

    public static String executeLocalCommandAsAdmin(String command, boolean asAdmin) {
        String sysout = "";
        try {
            String line;
            String commandToExecute = "";
            commandToExecute = asAdmin ? "adselfservice.exe " : "powershell.exe ";
            commandToExecute = commandToExecute + command;
            logger.log(Level.INFO, "commandToExecute:" + commandToExecute);
            Process powerShellProcess = Runtime.getRuntime().exec(commandToExecute);
            powerShellProcess.getOutputStream().close();
            logger.log(Level.INFO, "Standard Output:");
            BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream()));
            while ((line = stdout.readLine()) != null) {
                sysout = sysout + line;
                logger.log(Level.INFO, "The systemOutput value is" + line);
            }
            stdout.close();
            logger.log(Level.INFO, "Standard Error:");
            BufferedReader stderr = new BufferedReader(new InputStreamReader(powerShellProcess.getErrorStream()));
            while ((line = stderr.readLine()) != null) {
                logger.log(Level.INFO, "The SystemError " + line);
            }
            stderr.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
        return sysout;
    }

    public static String executeRemoteCommandAsAdmin(String clientMachine, String domainName, String userName, String passWord, String command) {
        String sysout = "";
        try {
            String line;
            String commandToExecute = "paexec.exe \\\\" + clientMachine;
            if (userName != null && !userName.equals("")) {
                commandToExecute = commandToExecute + " -u \"" + domainName + "\\" + userName + "\" -p \"" + passWord + "\"";
            }
            commandToExecute = commandToExecute + " -h -to 120 " + command;
            logger.log(Level.INFO, "commandToExecute:" + command);
            Process powerShellProcess = Runtime.getRuntime().exec(commandToExecute);
            powerShellProcess.getOutputStream().close();
            logger.log(Level.INFO, "Standard Output:");
            BufferedReader stdout = new BufferedReader(new InputStreamReader(powerShellProcess.getInputStream()));
            while ((line = stdout.readLine()) != null) {
                sysout = sysout + line;
                logger.log(Level.INFO, "The systemOutput value is" + line);
            }
            stdout.close();
            logger.log(Level.INFO, "Standard Error:");
            BufferedReader stderr = new BufferedReader(new InputStreamReader(powerShellProcess.getErrorStream()));
            while ((line = stderr.readLine()) != null) {
                logger.log(Level.INFO, "The SystemError " + line);
            }
            stderr.close();
        }
        catch (Exception e1) {
            e1.printStackTrace();
            return "";
        }
        return sysout;
    }

    public static void powerShellSetupCommands(Properties properties) throws InterruptedException, UnknownHostException {
        try {
            String append;
            JSONArray dcsToBeUpdated = (JSONArray)properties.get("DC_LIST");
            int dcListSize = dcsToBeUpdated.length();
            String hostname = InetAddress.getLocalHost().getHostName();
            for (int i = 0; i < dcListSize; ++i) {
                logger.log(Level.INFO, "DCList (" + i + "):" + (String)dcsToBeUpdated.get(i));
                append = ",";
                String trustedHosts = ADHandler.executeRemoteCommandAsAdmin((String)dcsToBeUpdated.get(i), properties.getProperty("DOMAIN_NAME"), properties.getProperty("USER_NAME"), properties.getProperty("PASSWORD"), "powershell.exe \"$hosts = (Get-item wsman:/localhost/client/TrustedHosts -Force).value;\\\"trustedHosts=\\\"+$hosts \"");
                trustedHosts = trustedHosts.replaceAll("trustedHosts=", "");
                if (trustedHosts.equalsIgnoreCase("")) {
                    append = "";
                }
                if (!trustedHosts.contains(hostname) && !trustedHosts.equals("*")) {
                    trustedHosts = trustedHosts + append + hostname;
                }
                ADHandler.executeRemoteCommandAsAdmin((String)dcsToBeUpdated.get(i), properties.getProperty("DOMAIN_NAME"), properties.getProperty("USER_NAME"), properties.getProperty("PASSWORD"), "powershell.exe \" Enable-PSRemoting -Force;Set-Item wsman:/localhost/client/TrustedHosts \\\"" + trustedHosts + "\\\" -Force;Restart-Service WinRM;Set-Service -Name ADWS -StartupType Automatic -Status running;Set-Service -Name WinRM -StartupType Automatic -Status running \"");
            }
            String trustedHosts = ADHandler.executeLocalCommandAsAdmin("\"$hosts = (Get-Item wsman:/localhost/Client/TrustedHosts -Force).value;\\\"trustedhosts=\\\"+$hosts\"", false);
            trustedHosts = trustedHosts.replaceAll("trustedhosts=", "");
            trustedHosts = trustedHosts.replace(",", "`,");
            append = "`,";
            if (trustedHosts.equalsIgnoreCase("")) {
                append = "";
            }
            String dcString = "";
            for (int i = 0; i < dcListSize; ++i) {
                logger.log(Level.INFO, "DCList (" + i + "):" + (String)dcsToBeUpdated.get(i));
                if (dcString.equals("") && !trustedHosts.contains((String)dcsToBeUpdated.get(i))) {
                    dcString = (String)dcsToBeUpdated.get(i);
                    continue;
                }
                if (dcString.equals("") || trustedHosts.contains((String)dcsToBeUpdated.get(i))) continue;
                dcString = dcString + "`," + (String)dcsToBeUpdated.get(i);
            }
            if (!trustedHosts.equals("*")) {
                ADHandler.executeLocalCommandAsAdmin("powershell.exe \"Set-Item wsman:/localhost/Client/TrustedHosts \\\"" + trustedHosts + append + dcString + "\\\" -Force\"", true);
            }
            ADHandler.executeLocalCommandAsAdmin("powershell.exe \" Restart-Service WinRM \"", true);
            ADHandler.executeLocalCommandAsAdmin("powershell.exe \" Set-Service -Name WinRM -StartupType Automatic -Status running \"", true);
            Thread.sleep(10000L);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getErrorCodeFromPowerShell(String output) {
        if (output.contains("CHANGESUCCESS")) {
            return "0";
        }
        if (output.equals("86")) {
            return "80070056";
        }
        if (output.equals("1325")) {
            return "800708c5";
        }
        if (output.equals("1909")) {
            return "80070775";
        }
        if (output.equals("")) {
            return "80070005";
        }
        return "";
    }

    public static ArrayList getComputers(String domainName, String[] props, String searchQuery, String ouDN) throws Exception {
        ArrayList list = new ArrayList();
        ArrayList<String> attributeList = new ArrayList<String>();
        for (int i = 0; i < props.length; ++i) {
            attributeList.add(props[i]);
        }
        Properties domainDetails = DomainHandler.getConfiguredValues(domainName, new Long(1L));
        try {
            list = ADHandler.getObjectsWithOutListener(domainDetails, ouDN, attributeList, searchQuery);
        }
        catch (NativeException ne) {
            ne.printStackTrace();
            throw new Exception(ne.getExceptionMsg());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return list;
    }

    static {
        try {
            admangLogger.log(Level.INFO, "Thread.....");
            System.loadLibrary(LIBRARY_NAME);
            Properties pdtDetails = LicenseUtil.getProductDetails();
            admangLogger.log(Level.INFO, "Calling Initialize classIDs from java in Static Block..");
            admangLogger.log(Level.INFO, "Build Number : " + pdtDetails.getProperty("product.build_number"));
            ADHandler.InitializeClassIDs();
        }
        catch (Exception e) {
            admangLogger.log(Level.INFO, "Exception.....");
            e.printStackTrace();
        }
    }
}

