/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;

public class ADSSPException
extends Exception {
    private static Logger logger = Logger.getLogger(ADSSPException.class.getName());
    private String detailMessage;
    private ArrayList msgList;
    private Object[] replaceArgument;
    private Hashtable hash;

    public ADSSPException(Hashtable h) {
        this.hash = h;
    }

    public ADSSPException(String message) {
        this.detailMessage = message;
    }

    public ADSSPException(String message, Object[] arg) {
        this.detailMessage = message;
        this.replaceArgument = arg;
    }

    public ADSSPException(ArrayList messageList) {
        this.msgList = messageList;
    }

    public Hashtable getMultipleException() {
        Hashtable<String, String> h = new Hashtable<String, String>();
        Enumeration e = this.hash.keys();
        while (e.hasMoreElements()) {
            String nextKey = (String)e.nextElement();
            Object nextVal = this.hash.get(nextKey);
            String value = "";
            if (nextVal instanceof NativeException) {
                NativeException ne = (NativeException)nextVal;
                value = ne.getExceptionMsg();
            } else {
                value = nextVal.toString();
            }
            h.put(nextKey, value);
        }
        logger.log(Level.INFO, "Returning List of Native Exception Pairs : " + h);
        return h;
    }

    @Override
    public String getMessage() {
        return this.detailMessage;
    }

    public String getMessage(HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        return this.retErrorMsg(rb);
    }

    private String retErrorMsg(AdventNetResourceBundle rb) {
        StringBuilder strBuilder = new StringBuilder();
        if (this.msgList != null && !this.msgList.isEmpty()) {
            for (Object errorMsg : this.msgList) {
                strBuilder.append(rb.getString(errorMsg.toString()));
            }
            return strBuilder.toString();
        }
        if (this.replaceArgument != null) {
            return MessageFormat.format(rb.getString(this.detailMessage), this.replaceArgument);
        }
        logger.log(Level.INFO, "ADSSP Exception occured :" + rb.getString(this.detailMessage));
        return rb.getString(this.detailMessage);
    }
}

