/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;

public class CategoryHandler {
    private static Logger reportLogger = Logger.getLogger("ReportLogger");
    private static String[] reportColumns = new String[]{"REPORT_NAME", "DESCRIPTION", "CLASS_NAME", "TILE_NAME", "REPORT_FILE_NAME", "BASE_TABLE_NAME", "ONCLICK_TEXT", "RESULT_TABLE_NAME", "REPORT_ID", "PRIORITY", "URL"};
    private static Hashtable menuProps = null;

    public static ArrayList getCategories(DataObject reportObject, DataObject categoryObject) {
        ArrayList list = new ArrayList();
        try {
            String tableName = "ADSMSubCategory";
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            Column col1 = new Column(tableName, "*");
            query.addSelectColumn(col1);
            Column col = new Column(tableName, "PRIORITY");
            SortColumn sort = new SortColumn(col, true);
            query.addSortColumn(sort);
            DataObject subCatObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Iterator it = categoryObject.getRows("ADSMReportCategory");
            while (it.hasNext()) {
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                Row r = (Row)it.next();
                Long categoryId = (Long)r.get("REPORT_CATEGORY_ID");
                hash.put("CATEGORY_NAME", r.get("REPORT_CATEGORY_NAME"));
                hash.put("ICON_NAME", r.get("ICON_NAME"));
                hash.put("BIG_ICON_NAME", r.get("BIG_ICON_NAME"));
                hash.put("DESCRIPTION", r.get("DESCRIPTION"));
                hash.put("REPORT_CATEGORY_ID", categoryId);
                Criteria crit = new Criteria(new Column("ADSMSubCategory", "PARENT_ID"), (Object)categoryId, 0);
                ArrayList l = CategoryHandler.getSubCategories(subCatObj, reportObject, crit);
                if (l.isEmpty()) continue;
                hash.put("CHILD_LIST", l);
                list.add(hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getSubCategories(DataObject obj, DataObject reportObj, Criteria crit) {
        ArrayList l = new ArrayList();
        try {
            Iterator it = obj.getRows("ADSMSubCategory", crit);
            while (it.hasNext()) {
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                Row r = (Row)it.next();
                hash.put("CATEGORY_NAME", r.get("SUB_CATEGORY_NAME"));
                hash.put("ICON_NAME", r.get("ICON_NAME"));
                hash.put("BIG_ICON_NAME", r.get("BIG_ICON_NAME"));
                hash.put("BIG_ICON_WIDTH", r.get("BIG_ICON_WIDTH"));
                hash.put("DESCRIPTION", r.get("DESCRIPTION"));
                Long catId = (Long)r.get("SUB_CATEGORY_ID");
                hash.put("SUB_CATEGORY_ID", catId);
                Criteria c = new Criteria(new Column("ADSMSubCategory", "PARENT_ID"), (Object)catId, 0);
                c = c.and(new Criteria(new Column("ADSMSubCategory", "ISCHILD"), (Object)"true", 0));
                ArrayList child = CategoryHandler.getSubCategories(obj, reportObj, c);
                if (child.size() > 0) {
                    hash.put("CHILD_LIST", child);
                }
                ArrayList items = new ArrayList();
                Criteria c1 = new Criteria(new Column("ADSMReports", "SUB_CATEGORY_ID"), (Object)catId, 0);
                Iterator it1 = reportObj.getRows("ADSMReports", c1);
                while (it1.hasNext()) {
                    Row r1 = (Row)it1.next();
                    Hashtable<String, Object> h = new Hashtable<String, Object>();
                    for (int i = 0; i < reportColumns.length; ++i) {
                        if (r1.get(reportColumns[i]) == null) continue;
                        h.put(reportColumns[i], r1.get(reportColumns[i]));
                    }
                    items.add(h);
                }
                if (items.size() <= 0) continue;
                hash.put("ACTION_ITEMS", items);
                l.add(hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return l;
    }

    public static DataObject getReportCategories() {
        DataObject dataObj = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ADSMReportCategory"));
            Column id = new Column("ADSMReportCategory", "REPORT_CATEGORY_ID");
            Column name = new Column("ADSMReportCategory", "REPORT_CATEGORY_NAME");
            Column icon = new Column("ADSMReportCategory", "ICON_NAME");
            Column bigIcon = new Column("ADSMReportCategory", "BIG_ICON_NAME");
            Column description = new Column("ADSMReportCategory", "DESCRIPTION");
            ArrayList<Column> l = new ArrayList<Column>();
            l.add(id);
            l.add(name);
            l.add(icon);
            l.add(bigIcon);
            l.add(description);
            query.addSelectColumns(l);
            Column col = new Column("ADSMReportCategory", "PRIORITY");
            SortColumn sort = new SortColumn(col, true);
            query.addSortColumn(sort);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static DataObject getReports(HttpServletRequest request) {
        HttpSession session = request.getSession();
        Hashtable aaaDetails = (Hashtable)session.getAttribute("ADMP_AAA_DETAILS");
        ArrayList actionIds = (ArrayList)aaaDetails.get("ACTION_IDS_OF_USER");
        Long[] ids = actionIds.toArray(new Long[0]);
        return CategoryHandler.getReports(ids);
    }

    public static DataObject getReports(Long[] actionIds) {
        DataObject dataObj = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ADSMReports"));
            Column id = new Column("ADSMReports", "REPORT_ID");
            Column name = new Column("ADSMReports", "REPORT_NAME");
            Column categoryId = new Column("ADSMReports", "SUB_CATEGORY_ID");
            Column description = new Column("ADSMReports", "DESCRIPTION");
            Column priority = new Column("ADSMReports", "PRIORITY");
            Column url = new Column("ADSMReports", "URL");
            ArrayList<Column> l = new ArrayList<Column>();
            l.add(id);
            l.add(name);
            l.add(categoryId);
            l.add(description);
            l.add(priority);
            l.add(url);
            query.addSelectColumns(l);
            Column col = new Column("ADSMReports", "PRIORITY");
            SortColumn sort = new SortColumn(col, true);
            query.addSortColumn(sort);
            query.setCriteria(CommonUtil.getActionCriteria("ADSMReports", actionIds));
            ArrayList purchasedReports = LicenseUtil.getPurchasedComponentReports();
            if (purchasedReports != null && !purchasedReports.isEmpty()) {
                query.setCriteria(query.getCriteria().and(new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)purchasedReports.toArray(new Integer[purchasedReports.size()]), 8)));
            }
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static DataObject getReports(Long categoryId) {
        DataObject obj = null;
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMReports"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMReports", (String)"SUB_CATEGORY_ID"), (Object)categoryId, 0);
            Column column = Column.getColumn((String)"ADSMReports", (String)"PRIORITY");
            SortColumn sort = new SortColumn(column, true);
            query.addSortColumn(sort);
            query.addSelectColumn(Column.getColumn((String)"ADSMReports", (String)"*"));
            query.setCriteria(crit);
            ArrayList purchasedReports = LicenseUtil.getPurchasedComponentReports();
            if (purchasedReports != null && !purchasedReports.isEmpty()) {
                query.setCriteria(query.getCriteria().and(new Criteria(Column.getColumn((String)"ADSMReports", (String)"REPORT_ID"), (Object)purchasedReports.toArray(new Integer[purchasedReports.size()]), 8)));
            }
            obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }

    public static DataObject getReportDetails(Integer reportId) {
        DataObject dataObj = null;
        try {
            Column col = new Column("ADSMReports", "REPORT_ID");
            Criteria criteria = new Criteria(col, (Object)new Long(reportId.intValue()), 0);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMReports", criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static ArrayList getReportActions(Long categoryId, Long[] actionIds) {
        ArrayList list = new ArrayList();
        try {
            DataObject reportObject = CategoryHandler.getReports(actionIds);
            String tableName = "ADSMSubCategory";
            SelectQueryImpl query = new SelectQueryImpl(new Table(tableName));
            Column col1 = new Column(tableName, "*");
            query.addSelectColumn(col1);
            Column col = new Column(tableName, "PRIORITY");
            SortColumn sort = new SortColumn(col, true);
            query.addSortColumn(sort);
            Criteria crit = new Criteria(new Column("ADSMSubCategory", "PARENT_ID"), (Object)categoryId, 0);
            query.setCriteria(crit);
            DataObject subCatObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            list = CategoryHandler.getSubCategories(subCatObj, reportObject, crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getReportMenus(Integer reportId, Long[] actionIds) {
        ArrayList ret = new ArrayList();
        try {
            String tableName = "ADSMMenu";
            Table baseTable = new Table(tableName);
            Table joinTable = new Table("ADSMReportMenu");
            Column col = new Column("ADSMReportMenu", "REPORT_ID");
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"MENU_ID"}, new String[]{"MENU_ID"}, 2);
            sq.addJoin(join);
            Criteria criteria = new Criteria(col, (Object)new Long(reportId.intValue()), 0);
            criteria = criteria.and(CommonUtil.getActionCriteria("ADSMMenu", actionIds));
            sq.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMMenu", criteria);
            Iterator it = dataObj.getRows("ADSMMenu");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("MENU_NAME", r.get("MENU_NAME"));
                hash.put("ONCLICK_TEXT", r.get("ONCLICK_TEXT"));
                hash.put("CLASS_NAME", r.get("CLASS_NAME"));
                ret.add(hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Hashtable getMenuProps(Long menuId) {
        if (menuProps == null) {
            try {
                menuProps = new Hashtable();
                Criteria crit = new Criteria(new Column("ADSMMenu", "MENU_ID"), null, 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMMenu", crit);
                Iterator it = obj.getRows("ADSMMenu");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long id = (Long)r.get("MENU_ID");
                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                    props.put("MENU_NAME", r.get("MENU_NAME"));
                    if (r.get("ACTION_ID") != null) {
                        props.put("ACTION_ID", r.get("ACTION_ID"));
                    }
                    menuProps.put(id, props);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return (Hashtable)menuProps.get(menuId);
    }

    public static ArrayList getSubCategIds(Long categoryId) {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            Criteria crit = new Criteria(new Column("ADSMSubCategory", "PARENT_ID"), (Object)categoryId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMSubCategory", crit);
            Iterator it = dataObj.getRows("ADSMSubCategory");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                list.add((Long)r.get("SUB_CATEGORY_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

