/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.DCConfiguration;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DCConfiguration.DCConfigUtil;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DCConfigHandler {
    private static Logger logger = Logger.getLogger(DCConfigHandler.class.getName());

    public static JSONObject getDCConfigDetails(String domainGuid) {
        JSONObject domainDetails = new JSONObject();
        try {
            Hashtable domainGenDetails = DomainUtil.getDomainGenDetails("OBJECT_GUID", domainGuid, new String[]{"NAME", "DISTINGUISHED_NAME"});
            String domainName = (String)domainGenDetails.get("NAME");
            String dnName = (String)domainGenDetails.get("DISTINGUISHED_NAME");
            domainDetails.put("ALL_DCs", (Object)DCConfigUtil.getDCsOfDomain(domainName, null));
            DCConfigHandler.getDCsForOUDN(domainName, dnName, domainDetails);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainDetails;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList<Hashtable> getAllDomains(Long loginId) {
        ArrayList<Hashtable> domainList = new ArrayList<Hashtable>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"ADSMDomainConfiguration"));
            Join join = new Join("ADSMDomainConfiguration", "ADSMDomainGeneralDetails", new String[]{"DOMAIN_NAME"}, new String[]{"NAME"}, 2);
            selQuery.addJoin(join);
            Criteria crit = DomainUtil.getCritForLoggedInUser(loginId);
            selQuery.setCriteria(crit);
            selQuery.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"), true));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DEFAULT_NAMING_CONTEXT"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DISPLAY_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"IS_DEFAULT_DOMAIN"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"OBJECT_GUID"));
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                Hashtable<String, String> domainDatas = new Hashtable<String, String>();
                String objGuid = (String)dataSet.getValue("OBJECT_GUID");
                domainDatas.put("OBJECT_GUID", objGuid);
                domainDatas.put("DOMAIN_NAME", (String)dataSet.getValue("DOMAIN_NAME"));
                domainDatas.put("DEFAULT_NAMING_CONTEXT", (String)dataSet.getValue("DEFAULT_NAMING_CONTEXT"));
                domainDatas.put("IS_DEFAULT_DOMAIN", (String)dataSet.getValue("IS_DEFAULT_DOMAIN"));
                domainDatas.put("DOMAIN_DISPLAY_NAME", (String)dataSet.getValue("DOMAIN_DISPLAY_NAME"));
                domainList.add(domainDatas);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return domainList;
    }

    public static String getDefDomainGuidByLoginId(long loginId) {
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADSMDomainConfiguration");
            tablesList.add("ADSMDomainGeneralDetails");
            Criteria crit = DomainUtil.getCritForLoggedInUser(loginId);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tablesList, crit);
            if (!dObj.isEmpty()) {
                Iterator itAdsmDC = dObj.getRows("ADSMDomainConfiguration");
                while (itAdsmDC.hasNext()) {
                    Row r = (Row)itAdsmDC.next();
                    String isDefDomain = (String)r.get("IS_DEFAULT_DOMAIN");
                    if (!isDefDomain.equals("true")) continue;
                    String domainName = (String)r.get("DOMAIN_NAME");
                    Iterator itAdsmDGD = dObj.getRows("ADSMDomainGeneralDetails");
                    while (itAdsmDGD.hasNext()) {
                        r = (Row)itAdsmDGD.next();
                        if (!((String)r.get("NAME")).equals(domainName)) continue;
                        return (String)r.get("OBJECT_GUID");
                    }
                }
                return (String)dObj.getFirstValue("ADSMDomainGeneralDetails", "OBJECT_GUID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String getDefDomainGuid() {
        try {
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("ADSMDomainConfiguration");
            tablesList.add("ADSMDomainGeneralDetails");
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0, false);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tablesList, crit);
            if (!dObj.isEmpty()) {
                return (String)dObj.getFirstValue("ADSMDomainGeneralDetails", "OBJECT_GUID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }

    public static void updateOUDCDetails(JSONObject ouDCDetails, String domainName) throws Exception {
        String[] objGuids = JSONObject.getNames((JSONObject)ouDCDetails);
        String[] modGuids = new String[objGuids.length];
        DataObject dObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
        int x = 0;
        int y = 0;
        for (String guid : objGuids) {
            JSONObject dcDetails = new JSONObject((String)ouDCDetails.get(guid));
            if (((String)dcDetails.get("IS_MODIFIED")).equalsIgnoreCase("true")) {
                modGuids[y++] = objGuids[x];
                JSONArray dcArray = (JSONArray)dcDetails.get("SEL_DCs");
                String isInherit = (String)dcDetails.get("INHERIT");
                Row row = new Row("SSPOUConfiguration");
                row.set("OBJECT_GUID", (Object)guid);
                row.set("INHERIT_CHILD_OUS", (Object)Boolean.parseBoolean(isInherit));
                row.set("DOMAIN_NAME", (Object)domainName);
                dObj.addRow(row);
                for (int index = 0; index < dcArray.length(); ++index) {
                    Row ouMapRow = new Row("SSPOUDCMapping");
                    ouMapRow.set("CONFIG_ID", row.get("CONFIG_ID"));
                    ouMapRow.set("DC_NAME", dcArray.get(index));
                    ouMapRow.set("PRIORITY_ID", (Object)(index + 1));
                    dObj.addRow(ouMapRow);
                }
            }
            ++x;
        }
        Criteria crit = new Criteria(Column.getColumn((String)"SSPOUConfiguration", (String)"OBJECT_GUID"), (Object)modGuids, 8, false);
        CommonUtil.getPersistence(new boolean[0]).delete(crit);
        CommonUtil.getPersistence(new boolean[0]).add(dObj);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static JSONObject getSelDCsForGuid(String selGuid, String domainName) {
        JSONObject selDCs = new JSONObject();
        String ouDN = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
            Join join = new Join("ADSMOUDetails", "ADSMDomainGeneralDetails", new String[]{"DOMAIN_NAME"}, new String[]{"NAME"}, 2);
            selQuery.addJoin(join);
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"DISTINGUISHED_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"OBJECT_GUID"));
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)selGuid, 0, false);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"OBJECT_GUID"), (Object)selGuid, 0, false));
            selQuery.setCriteria(crit);
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selQuery, connection);
            logger.log(Level.FINE, "QUERY TO GET  DN IS ::" + RelationalAPI.getInstance().getSelectSQL((Query)selQuery));
            while (dataSet.next()) {
                ouDN = (String)dataSet.getValue(2);
                if (ouDN != null) continue;
                ouDN = (String)dataSet.getValue(1);
            }
            DCConfigHandler.getDCsForOUDN(domainName, ouDN, selDCs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return selDCs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getDCsForOUDN(String domainName, String ouDN, JSONObject dcDetails) {
        JSONArray dcList = new JSONArray();
        Boolean inheritChildOUs = true;
        Long configId = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"SSPOUConfiguration"));
            Join join = new Join("SSPOUConfiguration", "ADSMOUDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(join);
            Join domGenDetailJoin = new Join("SSPOUConfiguration", "ADSMDomainGeneralDetails", new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 1);
            selQuery.addJoin(domGenDetailJoin);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            crit = crit.or(new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"), (Object)domainName, 0, false));
            selQuery.setCriteria(crit);
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"DISTINGUISHED_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"OBJECT_GUID"));
            selQuery.addSelectColumn(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"));
            selQuery.addSelectColumn(Column.getColumn((String)"SSPOUConfiguration", (String)"*"));
            connection = RelationalAPI.getInstance().getConnection();
            dataSet = RelationalAPI.getInstance().executeQuery((Query)selQuery, connection);
            Boolean isOUAvail = false;
            String dcDN = "";
            logger.log(Level.FINE, "QUERY TO GET THE DCS FOR DN" + ouDN + " IS ::" + RelationalAPI.getInstance().getSelectSQL((Query)selQuery));
            ouDN = ouDN.toLowerCase();
            while (dataSet.next()) {
                String allOUs = (String)dataSet.getValue(1);
                if (allOUs == null) {
                    allOUs = (String)dataSet.getValue(2);
                }
                allOUs = allOUs.toLowerCase();
                Boolean isInherit = (Boolean)dataSet.getValue("INHERIT_CHILD_OUS");
                if (ouDN.equalsIgnoreCase(allOUs)) {
                    configId = (Long)dataSet.getValue("CONFIG_ID");
                    isOUAvail = true;
                    inheritChildOUs = isInherit;
                    continue;
                }
                if (!ouDN.endsWith(allOUs) || isOUAvail.booleanValue() || dcDN.equals(allOUs) || allOUs.indexOf(dcDN) == -1 || !(inheritChildOUs = isInherit).booleanValue() && dcDN.equals("")) continue;
                dcDN = allOUs;
                configId = (Long)dataSet.getValue("CONFIG_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        try {
            dcList = configId != null ? DCConfigUtil.getDCsForID(configId) : DCConfigUtil.getDefaultDCsOfDomain(domainName);
            dcDetails.put("SEL_DCs", (Object)dcList);
            dcDetails.put("ALL_DCs", (Object)DCConfigUtil.getDCsOfDomain(domainName, null));
            dcDetails.put("INHERIT", (Object)inheritChildOUs);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

