/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.DCConfiguration;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.Range;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DCConfiguration.DCConfigHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class DCConfigUtil {
    private static Logger logger = Logger.getLogger(DCConfigUtil.class.getName());
    public static final String DC_TABLE = "ADSMDCConfiguration";
    public static final String OU_DC_MAPPING_TABLE = "SSPOUDCMapping";
    public static final String OU_CONFIG_TABLE = "SSPOUConfiguration";
    public static final Integer DEF_DCS_COUNT = 3;

    public static ArrayList getDCNames(String domainName) {
        ArrayList<String> dcNameList = new ArrayList<String>();
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)DC_TABLE));
            selQuery.addSelectColumn(Column.getColumn((String)DC_TABLE, (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)DC_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            selQuery.setCriteria(criteria);
            SortColumn srtCol = new SortColumn(Column.getColumn((String)DC_TABLE, (String)"PRIORITY_ID"), true);
            selQuery.addSortColumn(srtCol);
            DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            if (dcDataObj.isEmpty()) {
                return dcNameList;
            }
            Iterator ite = dcDataObj.getRows(DC_TABLE);
            while (ite.hasNext()) {
                Row rw = (Row)ite.next();
                dcNameList.add((String)rw.get("DOMAIN_CONTROLLER_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcNameList;
    }

    public static String getDCDetails(String domainName, ArrayList dcsList) {
        String firstDC = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)DC_TABLE));
            selQuery.addSelectColumn(Column.getColumn((String)DC_TABLE, (String)"*"));
            Criteria criteria = new Criteria(Column.getColumn((String)DC_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            selQuery.setCriteria(criteria);
            SortColumn srtCol = new SortColumn(Column.getColumn((String)DC_TABLE, (String)"PRIORITY_ID"), true);
            selQuery.addSortColumn(srtCol);
            DataObject dcDataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            Iterator ite = dcDataObj.getRows(DC_TABLE, criteria);
            while (ite.hasNext()) {
                Row rw = (Row)ite.next();
                String dcName = (String)rw.get("DOMAIN_CONTROLLER_NAME");
                if (firstDC == null && (Long)rw.get("PRIORITY_ID") == 1L) {
                    firstDC = dcName;
                }
                Properties dcProps = new Properties();
                String msg = (String)rw.get("MESSAGE");
                if (msg == null) {
                    dcProps.put("MESSAGE", "null");
                } else {
                    dcProps.put("MESSAGE", msg);
                }
                dcProps.put("DCS", dcName);
                dcProps.put("PRIORITY_ID", rw.get("PRIORITY_ID"));
                dcProps.put("DC_ID", rw.get("DOMAIN_CONTROLLER_ID"));
                dcsList.add(dcProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return firstDC;
    }

    public static void deleteDCDetails(String domainName) {
        try {
            Criteria dcCriteria = new Criteria(Column.getColumn((String)DC_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(dcCriteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getDefaultDCsOfDomain(String domainName) {
        Range range = new Range(0, DEF_DCS_COUNT.intValue());
        return DCConfigUtil.getDCsOfDomain(domainName, range);
    }

    public static String getFirstDC(String domainName) {
        String dcName = null;
        try {
            Range range = new Range(0, 1);
            JSONArray dcArray = DCConfigUtil.getDCsOfDomain(domainName, range);
            dcName = (String)dcArray.get(0);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcName;
    }

    public static JSONArray getDCsOfDomain(String domainName, Range range) {
        JSONArray dcList = new JSONArray();
        try {
            SelectQueryImpl dcQuery = new SelectQueryImpl(Table.getTable((String)DC_TABLE));
            Criteria crit = new Criteria(Column.getColumn((String)DC_TABLE, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            dcQuery.setCriteria(crit);
            dcQuery.addSortColumn(new SortColumn(Column.getColumn((String)DC_TABLE, (String)"PRIORITY_ID"), true));
            dcQuery.addSelectColumn(Column.getColumn((String)DC_TABLE, (String)"*"));
            if (range != null) {
                dcQuery.setRange(range);
            }
            logger.log(Level.FINE, "SEL QUERY TO GET ALL DCS :: " + RelationalAPI.getInstance().getSelectSQL((Query)dcQuery));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)dcQuery);
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows(DC_TABLE);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    String dcName = (String)row.get("DOMAIN_CONTROLLER_NAME");
                    dcList.put((Object)dcName);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcList;
    }

    public static JSONArray getDCsToBeUpdated(ArrayList dcList, Hashtable userDetails, String updateInAllDCs) {
        JSONArray dcsToBeUpdated = new JSONArray();
        try {
            if (updateInAllDCs != null && updateInAllDCs.equals("1")) {
                dcsToBeUpdated = new JSONArray((Collection)dcList);
            } else {
                JSONObject dcJSONObject = new JSONObject();
                DCConfigHandler.getDCsForOUDN((String)userDetails.get("DOMAIN_NAME"), (String)userDetails.get("USER_DN"), dcJSONObject);
                dcsToBeUpdated = (JSONArray)dcJSONObject.get("SEL_DCs");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcsToBeUpdated;
    }

    public static JSONArray getDCsForID(Long configId) {
        JSONArray dcsList = new JSONArray();
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)OU_DC_MAPPING_TABLE));
            selQuery.addSelectColumn(Column.getColumn((String)OU_DC_MAPPING_TABLE, (String)"*"));
            SortColumn srtCol = new SortColumn(Column.getColumn((String)OU_DC_MAPPING_TABLE, (String)"PRIORITY_ID"), true);
            selQuery.addSortColumn(srtCol);
            Join join = new Join(OU_DC_MAPPING_TABLE, DC_TABLE, new String[]{"DC_NAME"}, new String[]{"DOMAIN_CONTROLLER_NAME"}, 2);
            selQuery.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)OU_DC_MAPPING_TABLE, (String)"CONFIG_ID"), (Object)configId, 0);
            selQuery.setCriteria(crit);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows(OU_DC_MAPPING_TABLE);
                while (iter.hasNext()) {
                    Row row = (Row)iter.next();
                    dcsList.put((Object)((String)row.get("DC_NAME")));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dcsList;
    }
}

