/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainListener;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.RestrictUsersHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportAttributeHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.CustomPolicyUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Properties;

public class DomainAction {
    public static ArrayList<String> containerAttribList = new ArrayList<String>(Arrays.asList("cn", "distinguishedName", "objectGUID", "canonicalName"));

    public static void addOUs(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, NativeException> hash = new Hashtable<String, NativeException>();
        try {
            if (deleteAndUpdate) {
                Column column = new Column("ADSMOUDetails", "DOMAIN_NAME");
                Criteria criteria = new Criteria(column, (Object)domainName, 0, false);
                CommonUtil.getPersistenceLite().delete(criteria);
            }
            ArrayList ouList = null;
            try {
                ouList = ADHandler.getOUs(domainName, loginId);
            }
            catch (NativeException ae) {
                hash.put("adssp.layout.domain_setting.view_domains.update_ou", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Properties domainDetails = ADHandler.getDomainDetails(domainName, loginId);
            String defaultNamingContext = domainDetails.getProperty("DEFAULT_NAMING_CONTEXT");
            ArrayList userProps = null;
            try {
                userProps = ADHandler.getObjectsWithOutListener(domainDetails, defaultNamingContext, containerAttribList, "(distinguishedName=CN=Users," + defaultNamingContext + ")");
            }
            catch (NativeException ae) {
                hash.put("adssp.layout.domain_setting.view_domains.update_ou", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (userProps != null && !userProps.isEmpty()) {
                Properties userProp = (Properties)userProps.get(0);
                ArrayList l = (ArrayList)userProp.get("cn");
                userProp.put("ou", l);
                DomainUtil.changeGuidFormat(userProp);
                ouList.add(userProp);
            }
            ArrayList compProps = null;
            try {
                compProps = ADHandler.getObjectsWithOutListener(domainDetails, defaultNamingContext, containerAttribList, "(distinguishedName=CN=Computers," + defaultNamingContext + ")");
            }
            catch (NativeException ae) {
                hash.put("adssp.layout.domain_setting.view_domains.update_ou", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (compProps != null && !compProps.isEmpty()) {
                Properties compProp = (Properties)compProps.get(0);
                ArrayList l = (ArrayList)compProp.get("cn");
                compProp.put("ou", l);
                DomainUtil.changeGuidFormat(compProp);
                ouList.add(compProp);
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < ouList.size(); ++i) {
                Properties prop = (Properties)ouList.get(i);
                Row r = new Row("ADSMOUDetails");
                r.set("DOMAIN_NAME", (Object)domainName);
                String[] ar = new String[]{"ou", "distinguishedName", "objectGUID", "canonicalName"};
                String[] ar1 = new String[]{"NAME", "DISTINGUISHED_NAME", "OBJECT_GUID", "CANONICAL_NAME"};
                for (int k = 0; k < ar.length; ++k) {
                    if (prop.containsKey(ar[k])) {
                        ArrayList l = (ArrayList)prop.get(ar[k]);
                        r.set(ar1[k], (Object)((String)l.get(l.size() - 1)));
                        continue;
                    }
                    r.set(ar1[k], null);
                }
                dataObj.addRow(r);
            }
            CommonUtil.getPersistenceLite().add(dataObj);
            PolicyHandler.UpdatePolicyCriteriaOUGroups(domainName, "OU");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addExchangeServers(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, NativeException> hash = new Hashtable<String, NativeException>();
        try {
            if (deleteAndUpdate) {
                Column column = new Column("ADSMExchAdminGroups", "DOMAIN_NAME");
                Criteria criteria = new Criteria(column, (Object)domainName, 0, false);
                CommonUtil.getPersistenceLite().delete(criteria);
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, loginId);
            ArrayList<String> organizationAttributes = new ArrayList<String>();
            organizationAttributes.add("name");
            organizationAttributes.add("distinguishedName");
            System.out.println("Getting msExchOrganizationContainers...");
            ArrayList organizationList = new ArrayList();
            try {
                organizationList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("CONFIGURATION_NAMING_CONTEXT"), organizationAttributes, "(objectCategory=msExchOrganizationContainer)");
            }
            catch (NativeException ae) {
                hash.put("adssp.admin.schedulelist.updateobj.exchange", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Organization Containers for the Domain " + domainName + " is : " + organizationList);
            System.out.println("Organization Containers Count: " + organizationList.size());
            for (int i = 0; i < organizationList.size(); ++i) {
                Properties p = (Properties)organizationList.get(i);
                String organizationName = StrUtil.getString(p, "name");
                String organizationDN = StrUtil.getString(p, "distinguishedName");
                ArrayList<String> adminGrpContAttrs = new ArrayList<String>();
                adminGrpContAttrs.add("name");
                adminGrpContAttrs.add("distinguishedName");
                System.out.println("Getting msExchAdminGroupContainers...");
                ArrayList adminGrpContList = new ArrayList();
                try {
                    adminGrpContList = ADHandler.getObjectsWithOutListener(domainDetails, organizationDN, adminGrpContAttrs, "(objectCategory=msExchAdminGroupContainer)");
                }
                catch (NativeException ae) {
                    hash.put("adssp.admin.schedulelist.updateobj.exchange", ae);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("AdminGroup Containers for the Organization Container " + organizationDN + " is : " + adminGrpContList);
                System.out.println("AdminGroup Containers Count: " + adminGrpContList.size());
                for (int a = 0; a < adminGrpContList.size(); ++a) {
                    Properties adminGrpCont = (Properties)adminGrpContList.get(a);
                    String adminGrpContName = StrUtil.getString(adminGrpCont, "name");
                    String adminGrpContDN = StrUtil.getString(adminGrpCont, "distinguishedName");
                    ArrayList<String> adminGroupAttributes = new ArrayList<String>();
                    adminGroupAttributes.add("name");
                    adminGroupAttributes.add("distinguishedName");
                    adminGroupAttributes.add("legacyExchangeDN");
                    System.out.println("Getting msExchAdminGroups...");
                    ArrayList adminGroupList = new ArrayList();
                    try {
                        adminGroupList = ADHandler.getObjectsWithOutListener(domainDetails, adminGrpContDN, adminGroupAttributes, "(objectCategory=msExchAdminGroup)");
                    }
                    catch (NativeException ae) {
                        hash.put("adssp.admin.schedulelist.updateobj.exchange", ae);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("AdminGroups for the AdminGroup Container " + adminGrpContDN + " is : " + adminGroupList);
                    System.out.println("AdminGroups Count : " + adminGroupList.size());
                    for (int j = 0; j < adminGroupList.size(); ++j) {
                        Properties p1 = (Properties)adminGroupList.get(j);
                        String adminGroupName = StrUtil.getString(p1, "name");
                        String adminGroupDN = StrUtil.getString(p1, "distinguishedName");
                        String adminGroupLegacyDN = StrUtil.getString(p1, "legacyExchangeDN");
                        Row row = new Row("ADSMExchAdminGroups");
                        row.set("DOMAIN_NAME", (Object)domainName);
                        row.set("ADMIN_GROUP_NAME", (Object)(organizationName + "/" + adminGroupName));
                        row.set("ADMIN_GROUP_DN", (Object)adminGroupDN);
                        row.set("ADMIN_GRP_LEGACYDN", (Object)adminGroupLegacyDN);
                        dataObj.addRow(row);
                        ArrayList<String> serverContAttrs = new ArrayList<String>();
                        serverContAttrs.add("distinguishedName");
                        serverContAttrs.add("adminDisplayName");
                        System.out.println("Getting msExchServersContainers...");
                        ArrayList serverContList = new ArrayList();
                        try {
                            serverContList = ADHandler.getObjectsWithOutListener(domainDetails, adminGroupDN, serverContAttrs, "(objectCategory=msExchServersContainer)");
                        }
                        catch (NativeException ae) {
                            hash.put("adssp.admin.schedulelist.updateobj.exchange", ae);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        System.out.println("Exch Servers Containers for the AdminGroup" + adminGroupDN + " is : " + serverContList);
                        System.out.println("Exch Servers Containers Count :" + serverContList.size());
                        for (int b = 0; b < serverContList.size(); ++b) {
                            Properties serverCont = (Properties)serverContList.get(b);
                            String serverContName = StrUtil.getString(serverCont, "adminDisplayName");
                            String serverContDN = StrUtil.getString(serverCont, "distinguishedName");
                            ArrayList<String> serverListAttributes = new ArrayList<String>();
                            serverListAttributes.add("distinguishedName");
                            serverListAttributes.add("adminDisplayName");
                            serverListAttributes.add("legacyExchangeDN");
                            System.out.println("Getting msExchExchangeServers...");
                            ArrayList serverList = new ArrayList();
                            try {
                                serverList = ADHandler.getObjectsWithOutListener(domainDetails, serverContDN, serverListAttributes, "(objectCategory=msExchExchangeServer)");
                            }
                            catch (NativeException ae) {
                                hash.put("adssp.admin.schedulelist.updateobj.exchange", ae);
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            System.out.println("Server List for the server Container " + serverContDN + " is : " + serverList);
                            System.out.println("Server Count: " + serverList.size());
                            for (int k = 0; k < serverList.size(); ++k) {
                                Properties p2 = (Properties)serverList.get(k);
                                String serverName = StrUtil.getString(p2, "adminDisplayName");
                                String serverDN = StrUtil.getString(p2, "distinguishedName");
                                String legacyExchangeDN = StrUtil.getString(p2, "legacyExchangeDN");
                                Row r = new Row("ADSMExchangeServers");
                                r.set("DOMAIN_EXCH_ADMIN_GRP_ID", row.get("DOMAIN_EXCH_ADMIN_GRP_ID"));
                                r.set("DOMAIN_NAME", (Object)domainName);
                                r.set("SERVER_NAME", (Object)(organizationName + "/" + adminGroupName + "/" + serverName));
                                r.set("SERVER_DISTINGUISHED_NAME", (Object)serverDN);
                                r.set("LEGACY_EXCHANGE_DN", (Object)legacyExchangeDN);
                                dataObj.addRow(r);
                                DomainAction.addMailBoxStores(r.get("DOMAIN_EXCHANGE_SERVER_ID"), dataObj, domainName, serverDN, loginId);
                            }
                        }
                    }
                }
            }
            if (!dataObj.isEmpty()) {
                CommonUtil.getPersistenceLite().add(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addMailBoxStores(Object id, DataObject dataObj, String domainName, String serverDistinguishedName, Long loginId) throws Exception {
        try {
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, loginId);
            ArrayList<String> informStoreAtts = new ArrayList<String>();
            informStoreAtts.add("adminDisplayName");
            informStoreAtts.add("distinguishedName");
            informStoreAtts.add("name");
            System.out.println("Getting msExchInformationStores..");
            ArrayList informationStores = new ArrayList();
            try {
                informationStores = ADHandler.getObjectsWithOutListener(domainDetails, serverDistinguishedName, informStoreAtts, "(objectCategory=msExchInformationStore)");
            }
            catch (NativeException ae) {
                ae.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("Information Stores for the Exchange server: " + serverDistinguishedName + " is " + informationStores);
            System.out.println("Information Stores Count: " + informationStores.size());
            for (int a = 0; a < informationStores.size(); ++a) {
                Properties informStore = (Properties)informationStores.get(a);
                String informStoreName = StrUtil.getString(informStore, "adminDisplayName");
                String informStoreDN = StrUtil.getString(informStore, "distinguishedName");
                ArrayList<String> storageGroupAttributes = new ArrayList<String>();
                storageGroupAttributes.add("adminDisplayName");
                storageGroupAttributes.add("distinguishedName");
                storageGroupAttributes.add("name");
                System.out.println("Getting msExchStorageGroups..");
                ArrayList storageGroups = new ArrayList();
                try {
                    storageGroups = ADHandler.getObjectsWithOutListener(domainDetails, informStoreDN, storageGroupAttributes, "(objectCategory=msExchStorageGroup)");
                }
                catch (NativeException ae) {
                    ae.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                System.out.println("StorageGroups for the information store " + informStoreDN + " is " + storageGroups);
                System.out.println("StorageGroups Count :" + storageGroups.size());
                for (int i = 0; i < storageGroups.size(); ++i) {
                    Properties p = (Properties)storageGroups.get(i);
                    String storageGroupName = StrUtil.getString(p, "adminDisplayName");
                    if (storageGroupName == null || storageGroupName.equals("")) {
                        storageGroupName = StrUtil.getString(p, "name");
                    }
                    String storageGroupDN = StrUtil.getString(p, "distinguishedName");
                    ArrayList<String> storeAttributes = new ArrayList<String>();
                    storeAttributes.add("name");
                    storeAttributes.add("distinguishedName");
                    System.out.println("Getting msExchPrivateMDB...");
                    ArrayList storeList = new ArrayList();
                    try {
                        storeList = ADHandler.getObjectsWithOutListener(domainDetails, storageGroupDN, storeAttributes, "(objectCategory=msExchPrivateMDB)");
                    }
                    catch (NativeException ae) {
                        ae.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    System.out.println("Store List for the Storage Group " + storageGroupDN + " is : " + storeList);
                    System.out.println("storeList count " + storeList.size());
                    for (int k = 0; k < storeList.size(); ++k) {
                        Properties p1 = (Properties)storeList.get(k);
                        String storeName = StrUtil.getString(p1, "name");
                        String storeDN = StrUtil.getString(p1, "distinguishedName");
                        Row r = new Row("ADSMMailBoxStores");
                        r.set("DOMAIN_EXCHANGE_SERVER_ID", id);
                        r.set("STORE_NAME", (Object)(storageGroupName + "/" + storeName));
                        r.set("STORE_DISTINGUISHED_NAME", (Object)storeDN);
                        dataObj.addRow(r);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addExchangeOfflineAddressList(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, NativeException> hash = new Hashtable<String, NativeException>();
        try {
            if (deleteAndUpdate) {
                Column column = new Column("ADSMExchOfflineAddress", "DOMAIN_NAME");
                Criteria criteria = new Criteria(column, (Object)domainName, 0, false);
                CommonUtil.getPersistenceLite().delete(criteria);
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Properties domainDetails = DomainHandler.getConfiguredValues(domainName, loginId);
            ArrayList<String> offlineAddAttr = new ArrayList<String>();
            offlineAddAttr.add("name");
            offlineAddAttr.add("distinguishedName");
            ArrayList offlineAddressList = new ArrayList();
            try {
                offlineAddressList = ADHandler.getObjectsWithOutListener(domainDetails, domainDetails.getProperty("CONFIGURATION_NAMING_CONTEXT"), offlineAddAttr, "(objectCategory=msExchOAB)");
            }
            catch (NativeException ae) {
                hash.put("adssp.admin.schedulelist.updateobj.exchange", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.out.println("addExchangeOfflineAddressList for" + domainName + " is : " + offlineAddressList);
            for (int i = 0; i < offlineAddressList.size(); ++i) {
                Properties p = (Properties)offlineAddressList.get(i);
                String offlineAddListName = StrUtil.getString(p, "name");
                String offlineAddListDN = StrUtil.getString(p, "distinguishedName");
                Row row = new Row(DomainHandler.exchOfflineAddressTable);
                row.set("DOMAIN_NAME", (Object)domainName);
                row.set("OFFLINE_ADDLIST_NAME", (Object)offlineAddListName);
                row.set("OFFLINE_ADDLIST_DN", (Object)offlineAddListDN);
                dataObj.addRow(row);
            }
            if (!dataObj.isEmpty()) {
                CommonUtil.getPersistenceLite().add(dataObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addSIDs(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            ArrayList<DomainListener> listeners = new ArrayList<DomainListener>();
            if (deleteAndUpdate) {
                Column column = new Column(CommonUtil.getDomainUserTableName(domainName), "OBJECT_GUID");
                Criteria criteria = new Criteria(column, (Object)"", 1);
                CommonUtil.getPersistenceLite().delete(criteria);
            }
            ReportAttributeHandler.getInstance().resetValues();
            DomainListener listener = new DomainListener();
            listener.addUsers(domainName, loginId);
            listeners.add(listener);
            if (deleteAndUpdate) {
                Column column = new Column(CommonUtil.getDomainGroupTableName(domainName), "OBJECT_GUID");
                Criteria criteria = new Criteria(column, (Object)"", 1);
                CommonUtil.getPersistenceLite().delete(criteria);
            }
            DomainListener listener1 = new DomainListener();
            listener1.addGroups(domainName, loginId);
            listeners.add(listener1);
            ReportHandler.executeDomainReports(domainName, loginId, new int[]{10001});
            while (listeners.size() != 0) {
                DomainListener list = (DomainListener)listeners.get(0);
                list.waitForCompletion();
                String errorMsg = list.getErrorMessage();
                if (listeners.size() > 1) {
                    if (errorMsg != null) {
                        hash.put("adssp.layout.domain_setting.view_domains.update_user", errorMsg);
                    }
                    if (RestrictUsersHandler.isUnrestrictSchedulerEnabled(domainName)) {
                        RestrictUsersHandler.unRestrict(domainName);
                    }
                } else if (errorMsg != null) {
                    hash.put("adssp.layout.domain_setting.view_domains.update_group", errorMsg);
                }
                listeners.remove(0);
            }
            PolicyHandler.UpdatePolicyCriteriaOUGroups(domainName, "GROUP");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addUsers(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            String errorMsg;
            String sidTableName = CommonUtil.getDomainUserTableName(domainName);
            if (deleteAndUpdate) {
                Column column = new Column(sidTableName, "OBJECT_GUID");
                Criteria crit = new Criteria(column, (Object)"", 1);
                CommonUtil.getPersistenceLite().delete(crit);
            }
            DomainListener listener = new DomainListener();
            listener.addUsers(domainName, loginId);
            listener.waitForCompletion();
            if (RestrictUsersHandler.isUnrestrictSchedulerEnabled(domainName)) {
                RestrictUsersHandler.unRestrict(domainName);
            }
            if ((errorMsg = listener.getErrorMessage()) != null) {
                hash.put("adssp.layout.domain_setting.view_domains.update_user", errorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addComputers(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            if (deleteAndUpdate) {
                Column column = new Column(CommonUtil.getDomainComputerTableName(domainName), "OBJECT_GUID");
                Criteria criteria = new Criteria(column, (Object)"", 1);
                CommonUtil.getPersistenceLite().delete(criteria);
            }
            DomainListener listener = new DomainListener();
            listener.addComputers(domainName, loginId, deleteAndUpdate);
            listener.waitForCompletion();
            String errorMsg = listener.getErrorMessage();
            if (errorMsg != null) {
                hash.put("adssp.layout.domain_setting.view_domains.update_computer", errorMsg);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addGroups(String domainName, Long loginId, boolean deleteAndUpdate) throws Exception {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            if (deleteAndUpdate) {
                Column column = new Column(CommonUtil.getDomainGroupTableName(domainName), "OBJECT_GUID");
                Criteria criteria = new Criteria(column, (Object)"", 1);
                CommonUtil.getPersistence(new boolean[0]).delete(criteria);
            }
            DomainListener listener = new DomainListener();
            listener.addGroups(domainName, loginId);
            listener.waitForCompletion();
            String errorMsg = listener.getErrorMessage();
            if (errorMsg != null) {
                hash.put("adssp.layout.domain_setting.view_domains.update_group", errorMsg);
            }
            PolicyHandler.UpdatePolicyCriteriaOUGroups(domainName, "GROUP");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addPolicies(String domainName, Long loginId) throws Exception {
        Hashtable<String, NativeException> hash = new Hashtable<String, NativeException>();
        try {
            Properties p1 = new Properties();
            try {
                p1 = ADHandler.getPasswordPolicy(domainName, loginId);
            }
            catch (NativeException ae) {
                hash.put("adssp.admin.schedulelist.updateobj.domainpolicy", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Properties p2 = new Properties();
            try {
                p2 = ADHandler.getAccountLockOutPolicy(domainName, loginId);
            }
            catch (NativeException ae) {
                hash.put("adssp.admin.schedulelist.updateobj.domainpolicy", ae);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Row r = new Row("ADSMDomainPolicies");
            boolean check = false;
            for (int i = 0; i < DomainHandler.policyNames.length; ++i) {
                String str = (String)p1.get(DomainHandler.policyNames[i]);
                if (str == null) {
                    str = (String)p2.get(DomainHandler.policyNames[i]);
                }
                if (str == null) continue;
                check = true;
                r.set(DomainHandler.columnNames[i], (Object)str);
            }
            r.set("DOMAIN_NAME", (Object)domainName);
            if (check) {
                Criteria criteria = new Criteria(new Column("ADSMDomainPolicies", "DOMAIN_NAME"), (Object)domainName, 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPolicies", criteria);
                if (dataObj.isEmpty()) {
                    dataObj.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                } else {
                    dataObj.updateRow(r);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                }
                CustomPolicyUtil.writePwdPolicy(domainName, p1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                String domainFuncLevel = CommonUtil.getDomainFunctionalLevel(domainName, loginId);
                if (domainFuncLevel != null && (domainFuncLevel.equalsIgnoreCase("Windows Server 2008") || domainFuncLevel.equalsIgnoreCase("Windows Server 2008 R2"))) {
                    DomainAction.addPwdSettingObjects(domainName, loginId);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (!hash.isEmpty()) {
            throw new ADSSPException(hash);
        }
    }

    public static void addPwdSettingObjects(String domainName, Long loginId) {
        try {
            ArrayList psoList = ADHandler.getPasswordSettingObjects(domainName, loginId);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (psoList != null && psoList.size() != 0) {
                for (int i = 0; i < psoList.size(); ++i) {
                    Row r = new Row("ADSMDomainPSObjects");
                    r.set("DOMAIN_NAME", (Object)domainName);
                    Properties pso = (Properties)psoList.get(i);
                    r.set("PSO_NAME", ((ArrayList)pso.get("name")).get(0));
                    r.set("PSO_DIS_NAME", ((ArrayList)pso.get("distinguishedName")).get(0));
                    for (int j = 0; j < DomainHandler.psoNames.length; ++j) {
                        String str = (String)((ArrayList)pso.get(DomainHandler.psoNames[j])).get(0);
                        if (DomainHandler.psoNames[j].equalsIgnoreCase("msDS-MinimumPasswordAge") || DomainHandler.psoNames[j].equalsIgnoreCase("msDS-MaximumPasswordAge") || DomainHandler.psoNames[j].equalsIgnoreCase("msDS-LockoutDuration")) {
                            r.set(DomainHandler.psoColNames[j], (Object)Long.parseLong(str));
                            continue;
                        }
                        if (DomainHandler.psoNames[j].equalsIgnoreCase("msDS-PasswordHistoryLength") || DomainHandler.psoNames[j].equalsIgnoreCase("msDS-MinimumPasswordLength") || DomainHandler.psoNames[j].equalsIgnoreCase("msDS-LockoutThreshold")) {
                            r.set(DomainHandler.psoColNames[j], (Object)Integer.parseInt(str));
                            continue;
                        }
                        r.set(DomainHandler.psoColNames[j], (Object)str);
                    }
                    dataObj.addRow(r);
                }
                Criteria criteria = new Criteria(new Column("ADSMDomainPSObjects", "DOMAIN_NAME"), (Object)domainName, 0, false);
                DataObject dbObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPSObjects", criteria);
                if (!dbObj.isEmpty()) {
                    CommonUtil.getPersistence(new boolean[0]).delete(criteria);
                }
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static void deleteDomainDatas(String domainName) {
        try {
            Column column = new Column("ADSMDomainConfiguration", "DOMAIN_NAME");
            Criteria criteria = new Criteria(column, (Object)domainName, 0, false);
            CommonUtil.getPersistence(new boolean[0]).delete(criteria);
            if (MetaDataUtil.getTableDefinitionByName((String)CommonUtil.getDomainUserTableName(domainName)) != null) {
                CommonUtil.getPersistence(new boolean[0]).dropTable(CommonUtil.getDomainUserTableName(domainName));
            }
            if (MetaDataUtil.getTableDefinitionByName((String)CommonUtil.getDomainGroupTableName(domainName)) != null) {
                CommonUtil.getPersistence(new boolean[0]).dropTable(CommonUtil.getDomainGroupTableName(domainName));
            }
            if (MetaDataUtil.getTableDefinitionByName((String)CommonUtil.getDomainComputerTableName(domainName)) != null) {
                CommonUtil.getPersistence(new boolean[0]).dropTable(CommonUtil.getDomainComputerTableName(domainName));
            }
            column = new Column("AgentComputerDetails", "DOMAIN_NAME");
            criteria = new Criteria(column, (Object)domainName, 0, false);
            CommonUtil.getPersistence(new boolean[0]).delete(criteria);
            column = new Column("SSPGroupSubscriptions", "DOMAIN_NAME");
            criteria = new Criteria(column, (Object)domainName, 0, false);
            CommonUtil.getPersistence(new boolean[0]).delete(criteria);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties addDomainGeneralDetails(String domainName) {
        String objectGUID = "";
        String distinguishedName = "";
        try {
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("objectSID");
            attributeList.add("objectGUID");
            attributeList.add("distinguishedName");
            attributeList.add("canonicalName");
            ArrayList domainPropsList = new ArrayList();
            try {
                domainPropsList = ADHandler.getObjectsWithOutListener(domainName, attributeList, "(objectClass=domainDNS)");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            Row row = new Row("ADSMDomainGeneralDetails");
            if (domainPropsList != null && !domainPropsList.isEmpty()) {
                ArrayList canonList;
                ArrayList dnList;
                ArrayList guidList;
                Properties properties = (Properties)domainPropsList.get(0);
                ArrayList sidList = (ArrayList)properties.get("objectSID");
                if (sidList != null && !sidList.isEmpty()) {
                    row.set("SID_STRING", sidList.get(0));
                }
                if ((guidList = (ArrayList)properties.get("objectGUID")) != null && !guidList.isEmpty()) {
                    objectGUID = (String)guidList.get(0);
                    row.set("OBJECT_GUID", (Object)objectGUID);
                }
                if ((dnList = (ArrayList)properties.get("distinguishedName")) != null && !dnList.isEmpty()) {
                    distinguishedName = (String)dnList.get(0);
                    row.set("DISTINGUISHED_NAME", (Object)distinguishedName);
                }
                if ((canonList = (ArrayList)properties.get("canonicalName")) != null && !canonList.isEmpty()) {
                    row.set("CANONICAL_NAME", canonList.get(0));
                    row.set("NAME", (Object)domainName);
                }
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            dataObject.addRow(row);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        Properties domainProps = new Properties();
        domainProps.setProperty("DOMAIN_NAME", domainName);
        domainProps.setProperty("OBJECT_GUID", objectGUID);
        domainProps.setProperty("DISTINGUISHED_NAME", distinguishedName);
        return domainProps;
    }
}

