/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.IndexDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.DerivedColumn;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.PersistenceInitializer;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DCConfiguration.DCConfigUtil;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainListener;
import com.adventnet.sym.adsm.common.server.DomainProcess;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.NativeError;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.PPEHandler;
import com.adventnet.sym.adsm.common.server.selfservice.MultiADDomainHandler;
import com.adventnet.sym.adsm.common.server.taskengine.SchedulerConfiguration;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.authentication.smartcard.SmartCardHandler;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class DomainHandler {
    private static Logger admangLogger = Logger.getLogger("ADMangLogger");
    public static String tableName = "ADSMDomainConfiguration";
    public static String tableDCName = "ADSMDCConfiguration";
    public static String[] mailServerAttr = new String[]{"MAIL_SERVER", "SMTP_PORT", "FROM_ADDRESS", "MAIL_SERVER_USER", "MAIL_SERVER_PWD", "USE_SECURE_CONNECTION", "HTML_FORMAT"};
    private static int i = 0;
    private static Hashtable domainNameVsDNSDomainName = null;
    public static String exchOfflineAddressTable = "ADSMExchOfflineAddress";
    public static String[] policyNames = new String[]{"minPwdAge", "maxPwdAge", "minPwdlength", "pwdHistoryLength", "pwdProperties", "lockoutDuration", "lockoutThreshold"};
    public static String[] columnNames = new String[]{"MIN_PWD_AGE", "MAX_PWD_AGE", "MIN_PWD_LENGTH", "PWD_HISTORY_LENGTH", "PWD_PROPS", "LOCK_OUT_DURATION", "LOCK_OUT_THRESHOLD"};
    public static String[] psoNames = new String[]{"msDS-MinimumPasswordAge", "msDS-MaximumPasswordAge", "msDS-MinimumPasswordLength", "msDS-PasswordHistoryLength", "msDS-PasswordComplexityEnabled", "msDS-LockoutDuration", "msDS-LockoutThreshold"};
    public static String[] psoColNames = new String[]{"MIN_PWD_AGE", "MAX_PWD_AGE", "MIN_PWD_LENGTH", "PWD_HISTORY_LENGTH", "PWD_COMPLEXITY", "LOCK_OUT_DURATION", "LOCK_OUT_THRESHOLD"};
    public static String[] defSecondaryAttributes = new String[]{"mail", "mobile", "otherMobile"};
    private static Object syncObj = new Object();
    private static Hashtable<String, ArrayList> selfServiceQueue = new Hashtable();

    public static void addDomain(String domainName, ArrayList domainControllerName) {
        System.out.println(" Add Domains called from Native..... " + domainName + " and the DC : " + domainControllerName);
        if (domainName == null || domainControllerName == null) {
            return;
        }
        Properties p = new Properties();
        p.put("DOMAIN_NAME", domainName);
        p.put("DOMAIN_CONTROLLER_LIST", domainControllerName);
        p.put("IS_AUTHENTICATION_REQUIRED", "false");
        if (DomainHandler.getSelectedDomain(1L).size() > 0) {
            p.put("IS_DEFAULT_DOMAIN", "false");
        } else {
            p.put("IS_DEFAULT_DOMAIN", "true");
        }
        try {
            DomainHandler.addDomain(p, false, new boolean[0]);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean addDomainDetails(Properties domainDetails, boolean ... flags) throws Exception {
        boolean status = true;
        try {
            DomainHandler.addDomain(domainDetails, true, flags);
        }
        catch (ADSSPException ae) {
            admangLogger.log(Level.INFO, ae.getMessage());
            throw new ADSSPException(ae.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
            status = false;
        }
        return status;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean checkNoOfDomains() throws Exception {
        Object object = syncObj;
        synchronized (object) {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", (Row)null);
            ArrayList domainList = CommonUtil.getList(dataObject, new String[]{"DOMAIN_NAME"}, "ADSMDomainConfiguration");
            int no = LicenseUtil.getPurchasedDomains();
            if (domainList.size() >= no) {
                if (LicenseManager.getInstance().isTrial()) {
                    throw new ADSSPException("adssp.login.common.error.trial_license_exceeded");
                }
                if (LicenseManager.getInstance().isFree() && !LicenseManager.getInstance().isFreeTool()) {
                    if (domainList.size() == 1) {
                        throw new ADSSPException("adssp.login.common.error.free_license_exceeded");
                    }
                    if (domainList.size() >= 2) {
                        throw new ADSSPException("adssp.login.common.error.cannot_add_more_domains");
                    }
                } else if (LicenseManager.getInstance().isRegistered()) {
                    throw new ADSSPException("adssp.login.common.error.license_limit_exceeded", new Object[]{no});
                }
            }
        }
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static synchronized void addDomain(Properties domainDetails, boolean contextValues, boolean ... flags) throws Exception {
        ArrayList dcList = (ArrayList)domainDetails.get("DOMAIN_CONTROLLER_LIST");
        if (!DomainHandler.checkNoOfDomains()) {
            throw new ADSSPException("adssp.login.common.error.exception_occured");
        }
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        boolean caseSensitivity = false;
        Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
        Criteria crit = new Criteria(col, (Object)domainName, 0, caseSensitivity);
        Criteria criter = crit.or(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainName, 0, caseSensitivity));
        Criteria criteria = criter.or(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, caseSensitivity));
        DataObject dataObj = CommonUtil.getPersistence(flags).get(tableName, criteria);
        if (!dataObj.isEmpty()) throw new ADSSPException("adssp.login.common.error.domain_already_exists");
        domainDetails = DomainHandler.getDomainDetails(domainDetails, contextValues);
        domainDetails.put("DOMAIN_DISPLAY_NAME", (String)domainDetails.get("DOMAIN_FLAT_NAME"));
        if (!DomainHandler.isDomainDataFetchable(domainName, domainDetails, dcList)) {
            throw new ADSSPException("adssp.login.common.error.exception_adding_domain");
        }
        dataObj = CommonUtil.getPersistence(flags).constructDataObject();
        if (!DomainHandler.addUpdateDomains(domainDetails, dataObj, "add", flags)) throw new ADSSPException("adssp.login.common.error.exception_adding_domain");
        DomainUtil.addUpdateLogonDomains(domainName, new String[]{"MOBILE_DISPLAY_STATUS", "DISPLAY_STATUS"}, new int[]{1, 1});
        if (!DomainHandler.createDomainTables(domainName)) return;
        Properties prop = DomainAction.addDomainGeneralDetails(domainName);
        DomainHandler.addDefaultSecAttributes(domainName);
        PolicyHandler.addDefaultPolicy(prop);
        SchedulerConfiguration.populateDashBoardScheduler(domainName, 1L);
        AgentSchedulerUtil.populateTaskSchedulers(domainName);
        DomainHandler.populateTable(domainName);
    }

    public static boolean isDomainDataFetchable(String domainName, Properties dDetails, ArrayList dcList) {
        boolean isFetchable = false;
        try {
            Properties details = new Properties();
            details.put("MESSAGE", dDetails.get("MESSAGE"));
            details.put("DOMAIN_FUNCTIONAL_LEVEL", dDetails.get("DOMAIN_FUNCTIONAL_LEVEL"));
            if (dDetails.get("USER_DOMAIN_FLAT_NAME") != null) {
                details.put("USER_DOMAIN_FLAT_NAME", dDetails.get("USER_DOMAIN_FLAT_NAME"));
            }
            details.put("IS_AUTHENTICATION_REQUIRED", dDetails.get("IS_AUTHENTICATION_REQUIRED"));
            if (dDetails.get("USER_DISTINGUISHED_NAME") != null) {
                details.put("USER_DISTINGUISHED_NAME", dDetails.get("USER_DISTINGUISHED_NAME"));
            }
            details.put("DOMAIN_FLAT_NAME", dDetails.get("DOMAIN_FLAT_NAME"));
            details.put("ROOT_DOMAIN_NAMING_CONTEXT", dDetails.get("ROOT_DOMAIN_NAMING_CONTEXT"));
            details.put("DOMAIN_DNS_NAME", dDetails.get("DOMAIN_DNS_NAME"));
            details.put("SSL", ADSMPersUtil.checkLDAPSSL());
            details.put("IS_DEFAULT_DOMAIN", dDetails.get("IS_DEFAULT_DOMAIN"));
            details.put("CONFIGURATION_NAMING_CONTEXT", dDetails.get("CONFIGURATION_NAMING_CONTEXT"));
            details.put("USER_DOMAIN_DNS_NAME", dDetails.get("USER_DOMAIN_DNS_NAME"));
            details.put("DOMAIN_NAME", dDetails.get("DOMAIN_NAME"));
            details.put("DOMAIN_DISPLAY_NAME", dDetails.get("DOMAIN_DISPLAY_NAME"));
            details.put("SCHEMA_NAMING_CONTEXT", dDetails.get("SCHEMA_NAMING_CONTEXT"));
            details.put("DOMAIN_CONTROLLER_LIST", dcList);
            details.put("NEED_DN", (Object)false);
            details.put("USER_DOMAIN_NAME", dDetails.get("DOMAIN_DNS_NAME"));
            if (dDetails.get("USER_NAME") != null) {
                details.put("USER_NAME", dDetails.get("USER_NAME"));
            }
            if (dDetails.get("PASSWORD") != null) {
                details.put("PASSWORD", dDetails.get("PASSWORD"));
            }
            details.put("DEFAULT_NAMING_CONTEXT", dDetails.get("DEFAULT_NAMING_CONTEXT"));
            ArrayList<String> attributeList = new ArrayList<String>();
            attributeList.add("objectSID");
            attributeList.add("objectGUID");
            attributeList.add("distinguishedName");
            attributeList.add("canonicalName");
            ArrayList domainPropsList = new ArrayList();
            String distinguishedName = (String)dDetails.get("DEFAULT_NAMING_CONTEXT");
            domainPropsList = ADHandler.getObjectsWithOutListener(details, CommonUtil.escapeDN(distinguishedName), attributeList, "(objectClass=domainDNS)");
            if (domainPropsList != null && !domainPropsList.isEmpty()) {
                Properties properties = (Properties)domainPropsList.get(0);
                ArrayList sidList = (ArrayList)properties.get("objectSID");
                ArrayList guidList = (ArrayList)properties.get("objectGUID");
                ArrayList dnList = (ArrayList)properties.get("distinguishedName");
                ArrayList canonList = (ArrayList)properties.get("canonicalName");
                isFetchable = sidList == null || sidList.isEmpty() ? false : (guidList == null || guidList.isEmpty() ? false : (dnList == null || dnList.isEmpty() ? false : canonList != null && !canonList.isEmpty()));
            } else {
                isFetchable = false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isFetchable;
    }

    public static boolean updateDomainDetails(Properties domainDetails, boolean ... flags) throws Exception {
        boolean status = true;
        domainDetails = DomainHandler.getDomainDetails(domainDetails, true);
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
        Criteria criteria = new Criteria(col, (Object)domainName, 0);
        DataObject dataObj = CommonUtil.getPersistence(flags).get(tableName, criteria);
        DCConfigUtil.deleteDCDetails(domainName);
        status = DomainHandler.addUpdateDomains(domainDetails, dataObj, "update", flags);
        return status;
    }

    private static synchronized boolean addUpdateDomains(Properties domainDetails, DataObject dataObj, String operation, boolean ... flags) throws Exception {
        boolean status = true;
        ArrayList dcDetails = (ArrayList)domainDetails.remove("DOMAIN_CONTROLLER_LIST");
        String domainName = domainDetails.getProperty("DOMAIN_NAME");
        try {
            Row row = new Row(tableName);
            for (int j = 0; j < dcDetails.size(); ++j) {
                Row dcRow = new Row(tableDCName);
                Properties dconList = (Properties)dcDetails.get(j);
                Long priorityId = (Long)dconList.get("PRIORITY_ID");
                if (priorityId == 1L) {
                    domainDetails.put("DOMAIN_CONTROLLER_ID", dcRow.get("DOMAIN_CONTROLLER_ID"));
                    CommonUtil.updateRow(row, domainDetails);
                    if (operation.equals("add")) {
                        dataObj.addRow(row);
                    } else {
                        dataObj.updateRow(row);
                    }
                }
                CommonUtil.updateRow(dcRow, dconList);
                dataObj.addRow(dcRow);
            }
            CommonUtil.getPersistence(flags).update(dataObj);
            SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)"ADSMDCConfiguration"));
            selectQuery.addSelectColumn(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_CONTROLLER_NAME"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"ADSMDCConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            DerivedColumn dc = new DerivedColumn("DOMAIN_CONTROLLER_NAME", (SelectQuery)selectQuery);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPOUDCMapping", (String)"DC_NAME"), (Object)dc, 9);
            selectQuery = new SelectQueryImpl(Table.getTable((String)"SSPOUConfiguration"));
            selectQuery.addSelectColumn(Column.getColumn((String)"SSPOUConfiguration", (String)"CONFIG_ID"));
            selectQuery.setCriteria(new Criteria(Column.getColumn((String)"SSPOUConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0));
            dc = new DerivedColumn("CONFIG_ID", (SelectQuery)selectQuery);
            Criteria crit2 = new Criteria(Column.getColumn((String)"SSPOUDCMapping", (String)"CONFIG_ID"), (Object)dc, 8);
            CommonUtil.getPersistence(new boolean[0]).delete(crit.and(crit2));
            selectQuery = new SelectQueryImpl(Table.getTable((String)"SSPOUDCMapping"));
            selectQuery.addSelectColumn(Column.getColumn((String)"SSPOUDCMapping", (String)"CONFIG_ID"));
            dc = new DerivedColumn("CONFIG_ID", (SelectQuery)selectQuery);
            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"SSPOUConfiguration", (String)"CONFIG_ID"), (Object)dc, 9));
        }
        catch (Exception e) {
            status = false;
            e.printStackTrace();
        }
        return status;
    }

    public static Properties getDomainDetails(Properties domainDetails, boolean contextValues) throws Exception {
        NativeError nativeError = new NativeError();
        String userName = "";
        String userDNName = (String)domainDetails.get("USER_DISTINGUISHED_NAME");
        String userDomain = (String)domainDetails.get("DOMAIN_NAME");
        if (userDNName != null) {
            int pos;
            if (userDNName.contains("@")) {
                pos = userDNName.indexOf(64);
                userName = userDNName.substring(0, pos);
                userDomain = userDNName.substring(pos + 1, userDNName.length());
                domainDetails.put("USER_NAME", userName);
            } else if (userDNName.contains("\\")) {
                pos = userDNName.indexOf(92);
                userDomain = userDNName.substring(0, pos);
                userName = userDNName.substring(pos + 1, userDNName.length());
                userDNName = userDomain + "\\" + userName;
                domainDetails.put("USER_NAME", userName);
            } else {
                domainDetails.put("USER_NAME", userDNName);
            }
        }
        domainDetails.put("USER_DOMAIN_NAME", userDomain);
        domainDetails.put("SSL", ADSMPersUtil.checkLDAPSSL());
        Properties details = ADHandler.GetDomainDetails(domainDetails, nativeError);
        domainDetails.putAll((Map<?, ?>)details);
        String domainName = (String)domainDetails.get("DOMAIN_NAME");
        Hashtable domainError = nativeError.getError(domainName);
        ArrayList<Properties> dcs = new ArrayList<Properties>();
        if (domainError != null) {
            String mess = (String)domainError.get("ERROR_SEVERITY");
            String level = (String)domainError.get("ERROR_MESSAGE");
            if (mess.equals("SEVERE") && contextValues) {
                throw new ADSSPException(level);
            }
            domainDetails.put("MESSAGE", level);
        } else {
            domainDetails.put("MESSAGE", "Success");
        }
        domainDetails.remove("SSL");
        ArrayList dcDetails = (ArrayList)domainDetails.remove("DOMAIN_CONTROLLER_LIST");
        int priorityId = 1;
        for (int i = 0; i < dcDetails.size(); ++i) {
            String domainControllerName = (String)dcDetails.get(i);
            Hashtable error = nativeError.getError(domainControllerName);
            Properties p = new Properties();
            p.put("DOMAIN_CONTROLLER_NAME", domainControllerName);
            p.put("DOMAIN_NAME", domainName);
            if (error != null) {
                p.put("MESSAGE", error.get("ERROR_MESSAGE"));
                p.put("PRIORITY_ID", new Long(dcDetails.size() - i + (priorityId - 1)));
            } else {
                p.put("PRIORITY_ID", new Long(priorityId));
                ++priorityId;
            }
            dcs.add(p);
        }
        domainDetails.put("DOMAIN_CONTROLLER_LIST", dcs);
        String passWord = (String)domainDetails.get("PASSWORD");
        if (passWord != null) {
            domainDetails.put("PASSWORD", passWord);
        }
        domainDetails.remove("USER_DOMAIN_NAME");
        return domainDetails;
    }

    public static boolean createDomainTables(String domainName) {
        try {
            String[] tables = new String[]{CommonUtil.getDomainUserTableName(domainName), CommonUtil.getDomainGroupTableName(domainName), CommonUtil.getDomainComputerTableName(domainName)};
            String[][] columns = new String[][]{DomainListener.userColumns, DomainListener.groupColumns, DomainListener.computerColumns};
            String[][] desc = new String[][]{DomainListener.userDesc, DomainListener.groupDesc, DomainListener.computerDesc};
            String[][] dataType = new String[][]{DomainListener.userDataType, DomainListener.groupDataType, DomainListener.computerDataType};
            int[][] len = new int[][]{DomainListener.userLen, DomainListener.groupLen, DomainListener.computerLen};
            boolean[][] nullable = new boolean[][]{DomainListener.userNullable, DomainListener.groupNullable, DomainListener.computerNullable};
            for (int j = 0; j < tables.length; ++j) {
                String tableName = tables[j];
                TableDefinition tableDef = new TableDefinition();
                tableDef.setTableName(tableName);
                for (int i = 0; i < columns[j].length; ++i) {
                    ColumnDefinition coldef = new ColumnDefinition();
                    coldef.setColumnName(columns[j][i]);
                    coldef.setDescription(desc[j][i]);
                    coldef.setDataType(dataType[j][i]);
                    if (len[j][i] != -1) {
                        coldef.setMaxLength(len[j][i]);
                    }
                    if (columns[j][i].equalsIgnoreCase("DOMAIN_NAME")) {
                        coldef.setDefaultValue((Object)domainName);
                    }
                    if (coldef.getDefaultValue() != null && dataType[j][i] == "BIGINT") {
                        coldef.setDefaultValue((Object)0L);
                    }
                    coldef.setNullable(nullable[j][i]);
                    tableDef.addColumnDefinition(coldef);
                }
                PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
                pkDef.setName(tableName + "_PK");
                pkDef.addColumnName("OBJECT_GUID");
                pkDef.setTableName(tableName);
                tableDef.setPrimaryKey(pkDef);
                if (j == 0) {
                    IndexDefinition iDef = new IndexDefinition();
                    iDef.addColumn("SAM_ACCOUNT_NAME");
                    String indexName = "SAMIndex" + tableName;
                    if (indexName.length() > 25) {
                        indexName = indexName.substring(0, 24);
                    }
                    iDef.setName(indexName);
                    tableDef.addIndex(iDef);
                }
                CommonUtil.getPersistence(new boolean[0]).createTable("adssp", tableDef);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            String message = e.getMessage();
            System.out.println("Exception message :  " + message);
            return false;
        }
        return true;
    }

    public static void updateDomain(String domainName, Long loginId, String[] selectedUpdates) throws Exception {
        Hashtable props = new Hashtable();
        ArrayList<String> updates = new ArrayList<String>();
        for (String selectedUpdate : selectedUpdates) {
            updates.add(selectedUpdate);
        }
        props.put("actionList", updates);
        Long time = new Long(System.currentTimeMillis());
        DomainProcess.getInstance().process(time.toString(), domainName, loginId, "update", props);
    }

    public static void scheduleUpdate(String domainName, Long scheduleId) {
        try {
            System.out.println("Populating table .............");
            Hashtable<String, Long> props = new Hashtable<String, Long>();
            props.put("SCHEDULE_ID", scheduleId);
            Long time = new Long(System.currentTimeMillis());
            DomainProcess.getInstance().process(time.toString(), domainName, 1L, "scheduleUpdate", props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean populateTable(String domainName) {
        try {
            System.out.println("Populating table .............");
            Long time = new Long(System.currentTimeMillis());
            DomainProcess.getInstance().process(time.toString(), domainName, 1L, "add", null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean deleteDomain(String domainName) throws Exception {
        boolean status = true;
        Object object = syncObj;
        synchronized (object) {
            String domainDnsName = DomainHandler.getDomainDetails(domainName).getString("DOMAIN_DNS_NAME");
            PolicyHandler.deletePolicyScheduler(domainName);
            PPEHandler.deleteAllDictsForDomain(domainName);
            PolicyHandler.deleteSTEPScheduler(domainName);
            String key = new Long(System.currentTimeMillis()).toString();
            DomainProcess.getInstance().set(key, domainName, "delete");
            ADMPUserHandler.deleteDomainADMPusers(domainName);
            DomainAction.deleteDomainDatas(domainName);
            DomainProcess.getInstance().finished(key, domainName);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
            if (!dataObj.isEmpty() && dataObj.getRow(tableName, new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0)) == null) {
                Row r = dataObj.getFirstRow(tableName);
                domainName = (String)r.get("DOMAIN_NAME");
                DomainHandler.setDefaultDomain(domainName, new boolean[0]);
            }
            int noOfDomainstoShow = DomainUtil.getDropDownDomains().size();
            if ("true".equalsIgnoreCase(ADSMPersUtil.getSyMParameter("selectDomainOption"))) {
                --noOfDomainstoShow;
            }
            if (noOfDomainstoShow == 0) {
                DomainUtil.addUpdateLogonDomains(DomainHandler.getDefaultDomain(), new String[]{"MOBILE_DISPLAY_STATUS", "DISPLAY_STATUS"}, new int[]{1, 1});
            }
            MultiADDomainHandler.deleteADHost(domainName);
            SmartCardHandler.deleteSmartCardDetails((String)domainDnsName);
        }
        return status;
    }

    public static synchronized boolean startDomainDiscovery() {
        return DomainHandler.startDomainDiscovery(false);
    }

    public static synchronized boolean startDomainDiscovery(boolean forceFully) {
        boolean status = false;
        try {
            Column col = Column.getColumn((String)"ADSMSchedulerStatus", (String)"SCHEDULER_NAME");
            Criteria criteria = new Criteria(col, (Object)"DomainDiscovery", 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMSchedulerStatus", criteria);
            if (dataObj.isEmpty()) {
                Row row = new Row("ADSMSchedulerStatus");
                row.set("SCHEDULER_NAME", (Object)"DomainDiscovery");
                row.set("STATUS", (Object)"false");
                dataObj.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                new Thread(new GetDomains()).start();
                status = true;
            } else {
                Row row = dataObj.getRow("ADSMSchedulerStatus");
                String stat = (String)row.get("STATUS");
                if (stat.equals("false")) {
                    if (forceFully) {
                        new Thread(new GetDomains()).start();
                    }
                    status = true;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static ArrayList getConfiguredList(Long loginID) {
        Table baseTable = Table.getTable((String)tableName);
        Table joinTable = Table.getTable((String)tableDCName);
        ArrayList<Properties> ret = new ArrayList<Properties>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            sq.addJoin(join);
            Criteria criter = DomainUtil.getCritForLoggedInUser(loginID);
            sq.setCriteria(criter);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String domainName = (String)r.get("DOMAIN_NAME");
                Properties p = new Properties();
                p.put("DOMAIN_NAME", domainName);
                String uName = (String)r.get("USER_DISTINGUISHED_NAME");
                if (uName == null || uName.equals("")) {
                    uName = "-";
                }
                p.put("DEFAULT_NAMING_CONTEXT", r.get("DEFAULT_NAMING_CONTEXT"));
                p.put("USER_DISTINGUISHED_NAME", uName);
                p.put("IS_DEFAULT_DOMAIN", (String)r.get("IS_DEFAULT_DOMAIN"));
                p.put("MESSAGE", (String)r.get("MESSAGE"));
                p.put("DOMAIN_DNS_NAME", (String)r.get("DOMAIN_DNS_NAME"));
                p.put("DOMAIN_FLAT_NAME", (String)r.get("DOMAIN_FLAT_NAME"));
                p.put("DOMAIN_DISPLAY_NAME", (String)r.get("DOMAIN_DISPLAY_NAME"));
                p.put("DOMAIN_NAME", (String)r.get("DOMAIN_NAME"));
                ArrayList dcDetails = new ArrayList();
                String defaultDC = DCConfigUtil.getDCDetails(domainName, dcDetails);
                p.put("DOMAINCONTROLLERS", dcDetails);
                p.put("DOMAIN_CONTROLLER_NAME", defaultDC);
                ret.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static ArrayList getForestDomains(String rootDomainNamingContext, Long loginID) {
        ArrayList forestDomains = new ArrayList();
        try {
            String[] props;
            Object logonUserProps = null;
            Table table = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(table);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"ROOT_DOMAIN_NAMING_CONTEXT"), (Object)rootDomainNamingContext, 0);
            if (ADMPRoleHandler.isAdminUser(loginID) && (LicenseManager.getInstance().isFree() || LicenseUtil.getPurchasedDomains() == 1)) {
                criteria = criteria.and(new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0));
            }
            query.setCriteria(criteria);
            for (String string : props = new String[]{"DOMAIN_NAME", "DOMAIN_DISPLAY_NAME", "DOMAIN_DNS_NAME", "DOMAIN_FLAT_NAME", "DEFAULT_NAMING_CONTEXT", "ROOT_DOMAIN_NAMING_CONTEXT"}) {
                query.addSelectColumn(Column.getColumn((String)tableName, (String)string));
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObj.isEmpty()) {
                forestDomains = CommonUtil.getList(dataObj, props, tableName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forestDomains;
    }

    public static ArrayList getForestDomainNames(String rootDomainNamingContext, Long loginID) {
        ArrayList<String> forestDomains = new ArrayList<String>();
        try {
            ArrayList forestDomainDetails = DomainHandler.getForestDomains(rootDomainNamingContext, loginID);
            for (int i = 0; i < forestDomainDetails.size(); ++i) {
                Properties p = (Properties)forestDomainDetails.get(i);
                forestDomains.add((String)p.get("DOMAIN_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forestDomains;
    }

    public static String getDefaultDomain(Long loginId) {
        String domainName = "";
        try {
            Hashtable domains = DomainHandler.getDomainsAndOUs(loginId);
            ArrayList domainList = (ArrayList)domains.get("domainList");
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProps = (Properties)domainList.get(i);
                domainName = domainProps.getProperty("DOMAIN_NAME");
                String defaultDomain = domainProps.getProperty("IS_DEFAULT_DOMAIN");
                if (!defaultDomain.equals("true")) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static DataObject getDomainObjects(String domainName, Long loginId, String objectType, Criteria crit) {
        return DomainHandler.getDomainObjects(domainName, loginId, objectType, crit, false);
    }

    public static DataObject getDomainObjects(String domainName, Long loginId, String objectType, Criteria crit, boolean sortByName) {
        DataObject objs;
        block26: {
            objs = null;
            try {
                if ("OU".equalsIgnoreCase(objectType)) {
                    Criteria c = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"DOMAIN_NAME"), (Object)domainName, 0);
                    if (crit != null) {
                        c = c.and(crit);
                    }
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"ADSMOUDetails"));
                    query.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"*"));
                    query.setCriteria(c);
                    if (sortByName) {
                        query.addSortColumn(new SortColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"), true));
                    }
                    objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    if (crit == null && objs.isEmpty()) {
                        try {
                            DomainAction.addOUs(domainName, loginId, true);
                        }
                        catch (ADSSPException ae) {
                            ae.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    }
                    return objs;
                }
                if ("USER".equalsIgnoreCase(objectType)) {
                    String userTableName = CommonUtil.getDomainUserTableName(domainName);
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)userTableName));
                    query.addSelectColumn(Column.getColumn((String)userTableName, (String)"*"));
                    query.setCriteria(crit);
                    if (sortByName) {
                        query.addSortColumn(new SortColumn(Column.getColumn((String)userTableName, (String)"NAME"), true));
                    }
                    objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    if (crit == null && objs.isEmpty()) {
                        try {
                            DomainAction.addUsers(domainName, loginId, true);
                        }
                        catch (ADSSPException ae) {
                            ae.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    }
                    return objs;
                }
                if ("GROUP".equalsIgnoreCase(objectType)) {
                    String groupTableName = CommonUtil.getDomainGroupTableName(domainName);
                    SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)groupTableName));
                    query.addSelectColumn(Column.getColumn((String)groupTableName, (String)"*"));
                    query.setCriteria(crit);
                    if (sortByName) {
                        query.addSortColumn(new SortColumn(Column.getColumn((String)groupTableName, (String)"DISPLAY_NAME"), true));
                    }
                    objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    if (crit == null && objs.isEmpty()) {
                        try {
                            DomainAction.addGroups(domainName, loginId, true);
                        }
                        catch (ADSSPException ae) {
                            ae.printStackTrace();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                    }
                    return objs;
                }
                if (!"COMPUTER".equalsIgnoreCase(objectType)) break block26;
                String compTableName = CommonUtil.getDomainComputerTableName(domainName);
                SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)compTableName));
                query.addSelectColumn(Column.getColumn((String)compTableName, (String)"*"));
                query.setCriteria(crit);
                if (sortByName) {
                    query.addSortColumn(new SortColumn(Column.getColumn((String)compTableName, (String)"NAME"), true));
                }
                objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                if (crit == null && objs.isEmpty()) {
                    try {
                        DomainAction.addComputers(domainName, loginId, true);
                    }
                    catch (ADSSPException ae) {
                        ae.printStackTrace();
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    objs = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
                }
                return objs;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return objs;
    }

    public static Hashtable getDomainsAndOUs(Long loginId) throws Exception {
        Hashtable<String, Cloneable> domains = new Hashtable<String, Cloneable>();
        Hashtable<Object, String> dnDomainNameMap = new Hashtable<Object, String>();
        try {
            Criteria criteria = null;
            Properties logonUserProps = null;
            if (loginId == null || ADMPRoleHandler.isADSSPUser(loginId)) {
                criteria = DomainUtil.getCriteriaForLicensedDomains();
            } else {
                logonUserProps = ADAuthHandler.getLoginUserDetails(loginId);
                String domainName = logonUserProps.getProperty("LOGIN_DOMAIN_NAME");
                criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Iterator it = dataObj.getRows(tableName);
            ArrayList<Properties> domainList = new ArrayList<Properties>();
            while (it.hasNext()) {
                Properties domainProp = new Properties();
                Row r = (Row)it.next();
                String domainName = (String)r.get("DOMAIN_NAME");
                domainProp.put("DOMAIN_NAME", domainName);
                domainProp.put("DEFAULT_NAMING_CONTEXT", r.get("DEFAULT_NAMING_CONTEXT"));
                domainProp.put("IS_DEFAULT_DOMAIN", r.get("IS_DEFAULT_DOMAIN"));
                domainProp.put("DOMAIN_FLAT_NAME", r.get("DOMAIN_FLAT_NAME"));
                domainProp.put("DOMAIN_DISPLAY_NAME", r.get("DOMAIN_DISPLAY_NAME"));
                dnDomainNameMap.put(r.get("DEFAULT_NAMING_CONTEXT"), domainName);
                String domGenTable = "ADSMDomainGeneralDetails";
                Criteria domGencrit = new Criteria(Column.getColumn((String)domGenTable, (String)"NAME"), (Object)domainName, 0);
                DataObject domGenDObj = CommonUtil.getPersistence(new boolean[0]).get(domGenTable, domGencrit);
                Row domGenRow = domGenDObj.getFirstRow(domGenTable);
                domainProp.put("OBJECT_GUID", domGenRow.get("OBJECT_GUID"));
                ArrayList<Properties> ouList = new ArrayList<Properties>();
                DataObject ouObj = DomainHandler.getDomainObjects(domainName, loginId, "OU", null, true);
                if (ouObj != null) {
                    Iterator ouIterations = ouObj.getRows("ADSMOUDetails");
                    while (ouIterations.hasNext()) {
                        Properties ouProp = new Properties();
                        Row ou = (Row)ouIterations.next();
                        ouProp.put("DISTINGUISHED_NAME", ou.get("DISTINGUISHED_NAME"));
                        ouProp.put("OU_NAME", ou.get("NAME"));
                        ouProp.put("OBJECT_GUID", ou.get("OBJECT_GUID"));
                        ouList.add(ouProp);
                        dnDomainNameMap.put(ou.get("DISTINGUISHED_NAME"), domainName);
                    }
                }
                domainProp.put("ouList", ouList);
                domainList.add(domainProp);
            }
            domains.put("domainList", domainList);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        domains.put("dnDomainNameMap", dnDomainNameMap);
        return domains;
    }

    public static ArrayList getOUs(String domainName, Long loginId) {
        ArrayList<Properties> ouList = new ArrayList<Properties>();
        try {
            DataObject obj = DomainHandler.getDomainObjects(domainName, loginId, "OU", null);
            if (obj != null) {
                Iterator it = obj.getRows("ADSMOUDetails");
                while (it.hasNext()) {
                    Properties ouProp = new Properties();
                    Row ou = (Row)it.next();
                    ouProp.put("DISTINGUISHED_NAME", ou.get("DISTINGUISHED_NAME"));
                    ouProp.put("OU_NAME", ou.get("NAME"));
                    ouProp.put("OBJECT_GUID", ou.get("OBJECT_GUID"));
                    ouList.add(ouProp);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ouList;
    }

    public static Hashtable getConfiguredDomains() throws Exception {
        Hashtable<String, Properties> domains = new Hashtable<String, Properties>();
        try {
            Criteria criteria = null;
            criteria = DomainUtil.getCriteriaForLicensedDomains();
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Properties p = new Properties();
                List columnNames = r.getColumns();
                for (int i = 0; i < columnNames.size(); ++i) {
                    String columnName = (String)columnNames.get(i);
                    if (r.get(columnName) == null) continue;
                    p.put(columnName, r.get(columnName));
                }
                String encryptedPassword = (String)p.get("PASSWORD");
                if (encryptedPassword != null) {
                    p.put("PASSWORD", encryptedPassword);
                }
                String distinguishedName = (String)p.get("DEFAULT_NAMING_CONTEXT");
                domains.put(distinguishedName, p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return domains;
    }

    public static Properties getConfiguredValues(String domainName, Long loginId) throws Exception {
        return DomainHandler.getConfiguredValues(domainName, loginId, null);
    }

    public static Properties getConfiguredValues(String domainName, Long loginId, String oldPassword) throws Exception {
        Properties p = new Properties();
        try {
            Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            p = CommonUtil.getProperties(dataObj, tableName);
            String encryptedPassword = (String)p.get("PASSWORD");
            if (encryptedPassword != null) {
                p.put("PASSWORD", encryptedPassword);
            }
            p.put("DOMAIN_CONTROLLER_LIST", DCConfigUtil.getDCNames(domainName));
            String userDNName = (String)p.get("USER_DISTINGUISHED_NAME");
            String userDomain = (String)p.get("DOMAIN_NAME");
            if (userDNName != null) {
                int pos;
                if (userDNName.contains("@")) {
                    pos = userDNName.indexOf(64);
                    userDomain = userDNName.substring(pos + 1, userDNName.length());
                } else if (userDNName.contains("\\")) {
                    pos = userDNName.indexOf(92);
                    userDomain = userDNName.substring(0, pos);
                }
            }
            if (userDomain != null) {
                p.put("USER_DOMAIN_NAME", userDomain);
            }
            if (ADMPRoleHandler.isAdminUser(loginId)) {
                String Credential;
                if (!loginId.equals(1L) && (Credential = ADMPUserHandler.getUserCredential(loginId, "USER_CREDENTIAL")).equalsIgnoreCase("false")) {
                    Properties properties = ADAuthHandler.getLoginUserDetails(loginId);
                    p.put("USER_NAME", properties.getProperty("LOGIN_NAME"));
                    p.put("USER_DISTINGUISHED_NAME", properties.getProperty("LOGIN_NAME"));
                    String userDomainName = properties.getProperty("LOGIN_DOMAIN_NAME");
                    Properties properties2 = ADAuthHandler.getDomainDetails(userDomainName, "DOMAIN_NAME");
                    String userDomainFlatName = properties2.getProperty("DOMAIN_FLAT_NAME");
                    p.put("USER_DOMAIN_FLAT_NAME", userDomainFlatName);
                    p.put("USER_DOMAIN_NAME", userDomainFlatName);
                    p.put("USER_DOMAIN_DNS_NAME", DomainHandler.getDomainDNSName(userDomainName));
                    p.put("IS_AUTHENTICATION_REQUIRED", "true");
                }
            } else {
                String Credential = ADMPUserHandler.getUserCredential(loginId, "USER_CREDENTIAL");
                if (Credential.equalsIgnoreCase("false")) {
                    Properties properties = ADAuthHandler.getLoginUserDetails(loginId);
                    p.put("USER_NAME", properties.getProperty("LOGIN_NAME"));
                    p.put("USER_DISTINGUISHED_NAME", properties.getProperty("LOGIN_NAME"));
                    p.put("USER_DOMAIN_NAME", domainName);
                    if (oldPassword != null) {
                        p.put("PASSWORD", oldPassword);
                    }
                }
            }
            p.put("SSL", ADSMPersUtil.checkLDAPSSL());
            p.put("NEED_DN", "false");
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        admangLogger.log(Level.INFO, "Debug User Domain Name passed .... : " + p.get("USER_DOMAIN_NAME"));
        return p;
    }

    public static Properties getUnAuthenticatedDomainDetails(String domainName, String columnName) throws Exception {
        Properties p = new Properties();
        try {
            Column col = Column.getColumn((String)tableName, (String)columnName);
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            p = CommonUtil.getProperties(dataObj, tableName);
            String encryptedPassword = (String)p.get("PASSWORD");
            if (encryptedPassword != null) {
                p.put("PASSWORD", encryptedPassword);
            }
            p.put("DOMAIN_CONTROLLER_LIST", DCConfigUtil.getDCNames(p.getProperty("DOMAIN_NAME")));
            String userDNName = (String)p.get("USER_DISTINGUISHED_NAME");
            String userDomain = (String)p.get("DOMAIN_NAME");
            if (userDNName != null) {
                if (userDNName.contains("@")) {
                    int pos = userDNName.indexOf(64);
                    userDomain = userDNName.substring(pos + 1, userDNName.length());
                } else if (userDNName.contains("\\")) {
                    int pos = userDNName.indexOf(92);
                    userDomain = userDNName.substring(0, pos);
                }
            }
            p.put("USER_DOMAIN_NAME", userDomain);
            p.put("SSL", ADSMPersUtil.checkLDAPSSL());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return p;
    }

    public static Properties getConfiguredValuesForModify(String domainName) throws Exception {
        Properties p = new Properties();
        try {
            Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            p = CommonUtil.getProperties(dataObj, tableName);
            String encryptedPassword = (String)p.get("PASSWORD");
            if (encryptedPassword != null) {
                p.put("PASSWORD", encryptedPassword);
            }
            p.put("DOMAIN_CONTROLLER_LIST", DCConfigUtil.getDCNames(domainName));
            String userDNName = (String)p.get("USER_DISTINGUISHED_NAME");
            String userDomain = (String)p.get("DOMAIN_NAME");
            if (userDNName != null) {
                if (userDNName.contains("@")) {
                    int pos = userDNName.indexOf(64);
                    userDomain = userDNName.substring(pos + 1, userDNName.length());
                } else if (userDNName.contains("\\")) {
                    int pos = userDNName.indexOf(92);
                    userDomain = userDNName.substring(0, pos);
                }
            }
            p.put("USER_DOMAIN_NAME", userDomain);
            p.put("SSL", ADSMPersUtil.checkLDAPSSL());
        }
        catch (Exception e) {
            e.printStackTrace();
            throw e;
        }
        return p;
    }

    public static boolean setDefaultDomain(String domainName, boolean ... flags) throws Exception {
        try {
            Column col = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria criteria = new Criteria(col, (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(flags).get(tableName, criteria);
            Row r = dataObj.getRow(tableName);
            r.set("IS_DEFAULT_DOMAIN", (Object)"true");
            dataObj.updateRow(r);
            CommonUtil.getPersistence(flags).update(dataObj);
            DomainHandler.updateOtherDomainDefaultStatus(domainName, "false", flags);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void updateOtherDomainDefaultStatus(String domainName, String status, boolean ... flags) {
        try {
            DataObject dataObj = DomainHandler.getDefaultDomainDO(domainName);
            Iterator it = dataObj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                r.set("IS_DEFAULT_DOMAIN", (Object)status);
                dataObj.updateRow(r);
            }
            CommonUtil.getPersistence(flags).update(dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static DataObject getDefaultDomainDO(String domainName) {
        DataObject dataObj = null;
        try {
            Table table = Table.getTable((String)tableName);
            Column col1 = Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN");
            Criteria criteria = new Criteria(col1, (Object)"true", 0);
            Column domainCol = Column.getColumn((String)tableName, (String)"DOMAIN_NAME");
            Criteria domainCriteria = new Criteria(domainCol, (Object)domainName, 1);
            Criteria res = criteria.and(domainCriteria);
            SelectQueryImpl query = new SelectQueryImpl(table);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.setCriteria(res);
            dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dataObj;
    }

    public static Properties getPolicies(String domainName, Long loginId) {
        Properties p = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainPolicies", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPolicies", crit);
            if (obj.isEmpty()) {
                DomainAction.addPolicies(domainName, loginId);
                obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPolicies", crit);
            }
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("ADSMDomainPolicies");
                for (int i = 0; i < policyNames.length; ++i) {
                    p.put(policyNames[i], r.get(columnNames[i]));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getPSObjects(String domainName) {
        ArrayList psoList = new ArrayList();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainPSObjects", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPSObjects", crit);
            admangLogger.log(Level.INFO, "The data object for PSObject is " + dataObj);
            if (dataObj != null) {
                psoList = CommonUtil.getList(dataObj, "ADSMDomainPSObjects");
                admangLogger.log(Level.INFO, "the PSO Object List is " + psoList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return psoList;
    }

    public static long getPSOProp(String domainName, String resultantPSO, String property) {
        long value = -1L;
        try {
            Hashtable prop = DomainHandler.getPSOProp(domainName, resultantPSO, new String[]{property});
            if (prop.containsKey(property)) {
                value = (Long)prop.get(property);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return value;
    }

    public static Hashtable getPSOProp(String domainName, String resultantPSO, String[] properties) {
        Hashtable<String, Object> prop = new Hashtable<String, Object>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainPSObjects", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"ADSMDomainPSObjects", (String)"PSO_DIS_NAME"), (Object)resultantPSO, 0));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPSObjects", crit);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getFirstRow("ADSMDomainPSObjects");
                for (String property : properties) {
                    prop.put(property, r.get(property));
                }
            } else {
                admangLogger.log(Level.INFO, "The specified PSO object [" + resultantPSO + "] is not in the table ADSMDomainPSObjects.\nReason: Domain Policies not refreshed recently or the credentials under Domain Settings doesn't have enough permissions to read PSO from Active Directory.");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static String getDefaultNamingContext(String domainName) {
        return DomainHandler.getDomainData("DOMAIN_NAME", domainName, "DEFAULT_NAMING_CONTEXT");
    }

    public static String getDomainName(String defaultNamingContext) {
        return DomainHandler.getDomainName("DEFAULT_NAMING_CONTEXT", defaultNamingContext);
    }

    public static String getDomainName(Long loginID) {
        return DomainHandler.getDomainName(loginID, "LOGIN_ID");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getDomainName(Long loginID, String column) {
        Connection connection = null;
        DataSet dataSet = null;
        String domainName = null;
        try {
            Table baseTable = Table.getTable((String)"AaaLogin");
            Table joinTable = Table.getTable((String)tableName);
            SelectQueryImpl query = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAINNAME"}, new String[]{"DOMAIN_NAME"}, 2);
            query.addJoin(join);
            query.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
            Criteria criteria = new Criteria(Column.getColumn((String)"AaaLogin", (String)column), (Object)loginID, 0);
            query.setCriteria(criteria);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)query, connection);
            while (dataSet.next()) {
                domainName = (String)dataSet.getValue("DOMAIN_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return domainName;
    }

    public static Boolean isAccessableDomain(Long loginID, String domainName) {
        String domainOfLoginID = DomainHandler.getDomainName(loginID);
        if (ADMPRoleHandler.isADSSPUser(loginID)) {
            return true;
        }
        if (domainOfLoginID != null && domainName.equalsIgnoreCase(domainOfLoginID)) {
            return true;
        }
        return false;
    }

    public static String getDomainData(String columnName, String columnValue, String requiredColumn) {
        String retValue = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)columnName), (Object)columnValue, 0, false);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow("ADSMDomainConfiguration");
                retValue = (String)r.get(requiredColumn);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return retValue;
    }

    public static String getDomainName(String columnName, String columnValue) {
        return DomainHandler.getDomainData(columnName, columnValue, new String("DOMAIN_NAME"));
    }

    public static Properties getSelectedDomain(Long loginId) {
        Properties p = new Properties();
        Table baseTable = Table.getTable((String)tableName);
        Table joinTable = Table.getTable((String)tableDCName);
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)tableDCName, (String)"PRIORITY_ID"), (Object)new Long(1L), 0);
            Criteria criter = null;
            Properties logonUserProps = ADAuthHandler.getLoginUserDetails(loginId);
            String domainName = logonUserProps.getProperty("LOGIN_DOMAIN_NAME");
            criter = ADMPRoleHandler.isAdminUser(loginId) && domainName.equalsIgnoreCase("ADSelfService Plus Authentication") ? new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0) : crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0));
            sq.setCriteria(criter);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Row r = dataObj.getRow(tableName);
                domainName = (String)r.get("DOMAIN_NAME");
                p.put("DOMAIN_NAME", domainName);
                p.put("DOMAIN_DNS_NAME", (String)r.get("DOMAIN_DNS_NAME"));
                p.put("DOMAIN_FLAT_NAME", (String)r.get("DOMAIN_FLAT_NAME"));
                p.put("DOMAIN_DISPLAY_NAME", (String)r.get("DOMAIN_DISPLAY_NAME"));
                p.put("DEFAULT_NAMING_CONTEXT", (String)r.get("DEFAULT_NAMING_CONTEXT"));
                p.put("ROOT_DOMAIN_NAMING_CONTEXT", (String)r.get("ROOT_DOMAIN_NAMING_CONTEXT"));
                p.put("IS_DEFAULT_DOMAIN", (String)r.get("IS_DEFAULT_DOMAIN"));
                p.put("DOMAIN_CONTROLLER_NAME", DCConfigUtil.getFirstDC(domainName));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getDomainList() {
        return DomainHandler.getDomainList(true);
    }

    public static ArrayList getDomainList(boolean includeLicense) {
        ArrayList domainList = new ArrayList();
        try {
            Criteria criter = includeLicense ? DomainUtil.getCriteriaForLicensedDomains() : null;
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", criter);
            domainList = CommonUtil.getList(dataObject, new String[]{"DOMAIN_NAME"}, "ADSMDomainConfiguration");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainList;
    }

    public static String getDomainDNSName(String domainName) {
        String domainDNSName = null;
        try {
            if (domainNameVsDNSDomainName == null) {
                domainNameVsDNSDomainName = new Hashtable();
            }
            if (domainNameVsDNSDomainName.get(domainName) == null) {
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Iterator it = obj.getRows("ADSMDomainConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainNameVsDNSDomainName.put(r.get("DOMAIN_NAME"), r.get("DOMAIN_DNS_NAME"));
                }
            }
            domainDNSName = (String)domainNameVsDNSDomainName.get(domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainDNSName;
    }

    public static String getDomainController(String domainFlatName) {
        String domainName = DomainHandler.getDomainName("DOMAIN_FLAT_NAME", domainFlatName);
        return DCConfigUtil.getFirstDC(domainName);
    }

    public static String getDefaultDomain() {
        String domainName = "";
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                domainName = (String)r.get("DOMAIN_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static void updateDomainConfigParam(String domainName, String columnName, String columnValue) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                r.set(columnName, (Object)columnValue);
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDomainConfigParam(String domainName, String columnName) {
        String columnValue = "";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow(tableName);
                columnValue = (String)r.get(columnName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return columnValue;
    }

    public static String getDnFlatName(String defaultNamingContext) {
        return DomainHandler.getDomainData("DEFAULT_NAMING_CONTEXT", defaultNamingContext, "DOMAIN_FLAT_NAME");
    }

    public static ArrayList<String> getConfiguredDomainsList() {
        ArrayList<String> arrayList = new ArrayList<String>();
        SelectQueryImpl selectQuery = new SelectQueryImpl(Table.getTable((String)tableName));
        Criteria criteria = DomainUtil.getCriteriaForLicensedDomains();
        selectQuery.setCriteria(criteria);
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
        selectQuery.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"));
        selectQuery.addSortColumn(new SortColumn(Column.getColumn((String)tableName, (String)"IS_DEFAULT_DOMAIN"), false));
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!dataObject.isEmpty()) {
                Iterator iterator = dataObject.getRows(tableName);
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    arrayList.add((String)row.get("DOMAIN_FLAT_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return arrayList;
    }

    public static Properties getPSOProp(String domainName, String psoName) {
        Properties prop = new Properties();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainPSObjects", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(Column.getColumn((String)"ADSMDomainPSObjects", (String)"PSO_DIS_NAME"), (Object)psoName, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainPSObjects", crit);
            if (!dObj.isEmpty()) {
                Row r = dObj.getFirstRow("ADSMDomainPSObjects");
                for (int i = 0; i < policyNames.length; ++i) {
                    String columnValue;
                    String policyName = policyNames[i];
                    String columnName = psoColNames[i];
                    String columnType = r.getColumnType(columnName);
                    if (columnType.equalsIgnoreCase("bigint")) {
                        columnValue = new String();
                        Long maxPwdAge = -1L * (Long)r.get(columnName);
                        if ((Long)r.get(columnName) == Long.MIN_VALUE) {
                            maxPwdAge = 0L;
                            columnValue = maxPwdAge.toString();
                        } else if (maxPwdAge != Long.MIN_VALUE) {
                            maxPwdAge = maxPwdAge / 10000L;
                        }
                        ArrayList<String> list = new ArrayList<String>(Arrays.asList("${adssp.common.text.days}", "${adssp.common.text.hours}", "${adssp.common.text.minutes}", "${adssp.common.text.seconds}"));
                        ArrayList<Long> dateList = new ArrayList<Long>();
                        dateList.add(maxPwdAge / 86400000L);
                        dateList.add(maxPwdAge / 3600000L % 24L);
                        dateList.add(maxPwdAge / 60000L % 60L);
                        dateList.add(maxPwdAge / 1000L % 60L);
                        for (int j = 0; j < list.size(); ++j) {
                            if ((Long)dateList.get(j) == 0L) continue;
                            columnValue = columnValue + Long.toString((Long)dateList.get(j)) + " " + list.get(j) + " ";
                        }
                    } else {
                        columnValue = columnType.equalsIgnoreCase("integer") ? Integer.toString((Integer)r.get(columnName)) : (String)r.get(columnName);
                    }
                    prop.setProperty(policyName, columnValue);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static JSONObject getDomainDetails(String domainName) {
        JSONObject domainDetails = new JSONObject();
        try {
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainName, 0, false);
            criteria = criteria.or(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, false);
            criteria = criteria.or(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow(tableName);
                List columns = row.getColumns();
                for (String col : columns) {
                    domainDetails.put(col, row.get(col));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return domainDetails;
    }

    public static boolean isDomainExists() {
        try {
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", (Criteria)null);
            if (dataobject.isEmpty()) {
                return false;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return true;
    }

    public static void addDefaultSecAttributes(String domainName) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecondaryAttributes", (Criteria)null);
            Long order = 1L;
            for (i = 0; i < defSecondaryAttributes.length; ++i) {
                Row r = new Row("SSPSecondaryAttributes");
                r.set("DOMAIN_NAME", (Object)domainName);
                if (defSecondaryAttributes[i].equalsIgnoreCase("mail")) {
                    r.set("ATTRIBUTE_TYPE", (Object)"MAIL");
                    r.set("ORDER_ID", (Object)1L);
                } else {
                    r.set("ATTRIBUTE_TYPE", (Object)"MOBILE");
                    Long l = order;
                    Long l2 = order = Long.valueOf(order + 1L);
                    r.set("ORDER_ID", (Object)l);
                }
                r.set("ATTRIBUTE_NAME", (Object)defSecondaryAttributes[i]);
                r.set("IS_ENABLED", (Object)true);
                r.set("IS_PREDEFINED", (Object)true);
                obj.addRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getDefaultDomainName() {
        String domainName = "";
        try {
            Long loggedOnLoginId = AuthUtil.getUserCredential().getLoginId();
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                domainName = DomainHandler.getDomainName(loggedOnLoginId);
            } else {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0, false);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Row r = obj.getFirstRow("ADSMDomainConfiguration");
                domainName = (String)r.get("DOMAIN_NAME");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainName;
    }

    public static void addToSSQueue(String domainName, String userName, String operation) {
        ArrayList<String> arr = selfServiceQueue.get(domainName + "\\" + userName);
        if (arr == null) {
            arr = new ArrayList<String>();
        }
        arr.add(operation);
        selfServiceQueue.put(domainName + "\\" + userName, arr);
    }

    public static void removeFromSSQueue(String domainName, String userName, String operation) {
        ArrayList arr = selfServiceQueue.get(domainName + "\\" + userName);
        if (arr != null) {
            arr.remove(operation);
            selfServiceQueue.put(domainName + "\\" + userName, arr);
        }
    }

    public static boolean isSSOperationExist(String domainName, String userName, String operation) {
        ArrayList<String> operations = new ArrayList<String>();
        operations.add(operation);
        return DomainHandler.isSSOperationExist(domainName, userName, operations);
    }

    public static boolean isSSOperationExist(String domainName, String userName, ArrayList<String> operations) {
        ArrayList arr = selfServiceQueue.get(domainName + "\\" + userName);
        if (arr != null) {
            for (String operation : operations) {
                if (!arr.contains(operation)) continue;
                return true;
            }
        }
        return false;
    }

    public static Properties getDomainCredentialValues(String domainDNSName) {
        Properties p = new Properties();
        try {
            String domainName = DomainHandler.getDomainName("DOMAIN_DNS_NAME", domainDNSName);
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainDNSName, 0, false);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Column c1 = new Column(tableName, "*");
            Column c2 = new Column(tableDCName, "*");
            ArrayList<Column> colList = new ArrayList<Column>();
            colList.add(c1);
            colList.add(c2);
            sq.addSelectColumns(colList);
            sq.setCriteria(criteria);
            Join join1 = new Join(tableName, tableDCName, new String[]{"DOMAIN_CONTROLLER_ID"}, new String[]{"DOMAIN_CONTROLLER_ID"}, 1);
            sq.addJoin(join1);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Row r = dataObj.getRow(tableName);
            List columnNames = r.getColumns();
            for (int i = 0; i < columnNames.size(); ++i) {
                String columnName = (String)columnNames.get(i);
                if (r.get(columnName) == null) continue;
                p.put(columnName, r.get(columnName));
            }
            if (p.getProperty("IS_AUTHENTICATION_REQUIRED").equalsIgnoreCase("true")) {
                String encryptedPassword = (String)p.get("PASSWORD");
                if (encryptedPassword != null) {
                    p.put("PASSWORD", encryptedPassword);
                }
                String userName = (String)p.get("USER_NAME");
                p.put("USER_DISTINGUISHED_NAME", userName);
                int backSlashindex = userName.indexOf("\\");
                int atIndex = userName.indexOf("@");
                if (backSlashindex != -1) {
                    userName = userName.substring(backSlashindex + 1);
                } else if (atIndex != -1) {
                    userName = userName.substring(0, atIndex);
                }
                p.put("USER_NAME", userName);
            } else {
                p.put("USER_NAME", "****");
                p.put("USER_DISTINGUISHED_NAME", "****");
                p.put("PASSWORD", "****");
            }
            p.put("DOMAIN_CONTROLLER_LIST", DCConfigUtil.getDCNames(domainName));
            String userDomain = (String)p.get("DOMAIN_NAME");
            p.put("USER_DOMAIN_NAME", userDomain);
            p.put("SSL", "false");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    static class GetDomains
    implements Runnable {
        GetDomains() {
        }

        @Override
        public void run() {
            try {
                ADHandler.getValidDomains();
                Column col = Column.getColumn((String)"ADSMSchedulerStatus", (String)"SCHEDULER_NAME");
                Criteria criteria = new Criteria(col, (Object)"DomainDiscovery", 0);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMSchedulerStatus", criteria);
                Row row = new Row("ADSMSchedulerStatus");
                row.set("SCHEDULER_NAME", (Object)"DomainDiscovery");
                row.set("STATUS", (Object)"true");
                if (dataObj.isEmpty()) {
                    dataObj.addRow(row);
                    CommonUtil.getPersistence(new boolean[0]).add(dataObj);
                } else {
                    dataObj.updateRow(row);
                    CommonUtil.getPersistence(new boolean[0]).update(dataObj);
                }
                if (PersistenceInitializer.isColdStart()) {
                    Long time = new Long(System.currentTimeMillis());
                    ADSMPersUtil.updateSyMParameter("INSTALL_TIME", time.toString());
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

