/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.db.persistence.metadata.ColumnDefinition;
import com.adventnet.db.persistence.metadata.PrimaryKeyDefinition;
import com.adventnet.db.persistence.metadata.TableDefinition;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.TableUpdate;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.model.NativeListener;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GinaReportUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DomainListener
implements NativeListener {
    public static String[] userColumns = new String[]{"OBJECT_GUID", "SID_STRING", "DISPLAY_NAME", "DN_STRING", "OU_NAME", "SAM_ACCOUNT_NAME", "CREATION_TIME", "MODIFIED_TIME", "MAILBOX_STORE", "MAILBOX_SERVER", "MAIL_NICK_NAME", "NAME", "E_MAIL", "PSO_RESULTANT", "PRIMARY_GROUP_ID", "MOBILE_NUMBER", "OTHER_MOBILE", "USER_ACCOUNT_CONTROL", "ACCOUNT_EXPIRY_DATE", "LAST_LOGON_TIMESTAMP"};
    public static String[] userAttribs = new String[]{"objectGuid", "objectSid", "displayName", "distinguishedName", "distinguishedName", "samAccountName", "whenCreated", "whenChanged", "homeMDB", "msExchHomeServerName", "mailnickname", "name", "mail", "msDS-ResultantPSO", "primaryGroupID", "mobile", "otherMobile", "userAccountControl", "accountExpires", "lastLogonTimestamp"};
    public static String[] userDesc = new String[]{"Column to Store Guid", "Column to Store SID", "Column to Store SID Name", "Column to Store Distinguished Name", "Column to Store Fully Qualified Display Name", "Column to Store Fully Qualified Display Name", "Column to Store Fully Qualified Display Name", "Column to Store Fully Qualified Display Name", "Column to Store MailBox Store", "Column to Store MailBox Server", "Column to Store Mail Nick Name", "Column to Store Full Name", "Email Address of the User", "Resultant PSO of the user", "Column to Store PrimaryGroupId", "Column to Store Mobile Number", "Column to Store Other Mobile", "User Account Control", "Account Expires", "Last Logon Time Stamp"};
    public static String[] userDataType = new String[]{"NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "BIGINT", "BIGINT", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "INTEGER", "BIGINT", "BIGINT"};
    public static int[] userLen = new int[]{100, 100, 300, 1000, 1000, 255, -1, -1, 500, 500, 255, 255, 255, 1000, 50, 500, 500, -1, -1, -1};
    public static boolean[] userNullable = new boolean[]{false, false, true, true, true, false, true, true, true, true, true, true, true, true, true, true, true, true, true, true};
    public static String[] groupColumns = new String[]{"OBJECT_GUID", "SID_STRING", "DISPLAY_NAME", "DN_STRING", "OU_NAME", "CREATION_TIME", "MODIFIED_TIME", "GROUP_TYPE", "GROUP_SCOPE", "DESCRIPTION", "E_MAIL", "OBJECT_CLASS", "DOMAIN_NAME"};
    public static String[] groupAttribs = new String[]{"objectGuid", "objectSid", "cn", "distinguishedName", "distinguishedName", "whenCreated", "whenChanged", "groupType", "groupType", "description", "mail", "objectClass", "domainName"};
    public static String[] groupDesc = new String[]{"Column to Store Guid", "Column to Store SID", "Column to Store SID Name", "Column to Store Distinguished Name", "Column to Store Fully Qualified Display Name", "Column to Store Fully Qualified Display Name", "Column to Store Fully Qualified Display Name", "Column to Store Group Type", "Column to Store Group Scope", "Description about the group", "mail ID of the group", "objClass attribute specified in AD", "Domain name"};
    public static String[] groupDataType = new String[]{"NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "BIGINT", "BIGINT", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR"};
    public static int[] groupLen = new int[]{100, 100, 255, 1000, 1000, -1, -1, 50, 50, 1024, 256, 100, 100};
    public static boolean[] groupNullable = new boolean[]{false, false, true, true, true, true, true, true, true, true, true, true, false};
    public static String[] computerColumns = new String[]{"OBJECT_GUID", "DN_STRING", "OU_NAME", "NAME", "DNS_NAME", "OS", "OS_VERSION", "LOCATION"};
    public static String[] computerAttribs = new String[]{"objectGuid", "distinguishedName", "distinguishedName", "name", "dNSHostName", "operatingSystem", "operatingSystemVersion", "canonicalName"};
    public static String[] computerDesc = new String[]{"Column to Store Guid", "Column to Store Distinguished Name", "Column to Store Fully Qualified Display Name", "Column to Store Full Name", "Column to Store DNS_NAME", "operatingSystem of the computer", "operatingSystem version of the computer", "Column to Store Location"};
    public static String[] computerDataType = new String[]{"NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR"};
    public static int[] computerLen = new int[]{100, 1000, 1000, 255, 255, 255, 255, 1000};
    public static boolean[] computerNullable = new boolean[]{false, false, false, false, true, true, true, true};
    private String tableName = null;
    private String domainName = null;
    private String key = null;
    private String[] columns = null;
    private String[] attribs = null;
    private String[] mobAttribs = null;
    private String[] mailAttribs = null;
    private String errorMessage = null;
    private int attribLen = 0;
    private static Logger logger = Logger.getLogger(DomainListener.class.getName());

    @Override
    public boolean isCompleted() {
        return false;
    }

    public void waitForCompletion() {
        while (!TableUpdate.getInstance().isCompleted(this.key)) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private Long getLong(String s) {
        Long t = System.currentTimeMillis();
        try {
            t = new Long(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    @Override
    public void addRow(Properties prop) {
        try {
            Row r = new Row(this.tableName);
            String tableKey = null;
            String GUID = (String)((ArrayList)prop.get("objectGuid")).get(0);
            this.attribLen = 0;
            if (GUID != null && !GUID.equals("") && !GUID.equals("null")) {
                for (int i = 0; i < this.columns.length; ++i) {
                    String attrVal;
                    int k;
                    ArrayList list = (ArrayList)prop.get(this.attribs[i]);
                    if (!(list != null && list.size() != 0 || this.columns[i].equals("E_MAIL") || this.columns[i].equals("MOBILE_NUMBER"))) {
                        if (this.columns[i].equals("CREATION_TIME") || this.columns[i].equals("MODIFIED_TIME") || this.columns[i].equals("CREATED_ON") || this.columns[i].equals("CHANGED_ON") || this.columns[i].equalsIgnoreCase("LAST_LOGON_TIMESTAMP") || this.columns[i].equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                            r.set(this.columns[i], (Object)new Long(0L));
                            continue;
                        }
                        if (!this.columns[i].equals("DOMAIN_NAME")) continue;
                        r.set(this.columns[i], (Object)this.domainName);
                        continue;
                    }
                    if (this.columns[i].equals("MOBILE_NUMBER") || this.columns[i].equals("OTHER_MOBILE")) {
                        String value = "";
                        if (this.mobAttribs == null) continue;
                        for (int j = this.attribLen; j < this.mobAttribs.length; ++j) {
                            String mobStr = "";
                            ArrayList mobList = (ArrayList)prop.get(this.mobAttribs[j]);
                            if (mobList == null) {
                                ++this.attribLen;
                                continue;
                            }
                            for (k = 0; k < mobList.size(); ++k) {
                                attrVal = mobList.get(k).toString().trim();
                                if (!(value.equals("") && mobStr.equals("") || attrVal.equals(""))) {
                                    mobStr = mobStr + ",";
                                }
                                mobStr = mobStr + attrVal;
                            }
                            if (value.length() + mobStr.length() > userLen[i]) break;
                            value = value + mobStr;
                            ++this.attribLen;
                        }
                        if (value.equals("")) {
                            value = "-";
                        }
                        r.set(this.columns[i], (Object)value);
                        continue;
                    }
                    if (this.columns[i].equals("E_MAIL")) {
                        String value = "";
                        if (this.mailAttribs == null) continue;
                        for (int j = 0; j < this.mailAttribs.length; ++j) {
                            String mailStr = "";
                            ArrayList mailList = (ArrayList)prop.get(this.mailAttribs[j]);
                            if (mailList == null) continue;
                            for (k = 0; k < mailList.size(); ++k) {
                                attrVal = mailList.get(k).toString().trim();
                                if (!(value.equals("") && mailStr.equals("") || attrVal.equals(""))) {
                                    mailStr = mailStr + ",";
                                }
                                mailStr = mailStr + attrVal;
                            }
                            if (value.length() + mailStr.length() > userLen[i]) break;
                            value = value + mailStr;
                        }
                        if (value.equals("")) {
                            value = "-";
                        }
                        r.set(this.columns[i], (Object)value);
                        continue;
                    }
                    if (list == null || list.size() == 0) continue;
                    if (this.columns[i].equals("CREATION_TIME") || this.columns[i].equals("MODIFIED_TIME") || this.columns[i].equals("CREATED_ON") || this.columns[i].equals("CHANGED_ON") || this.columns[i].equalsIgnoreCase("LAST_LOGON_TIMESTAMP") || this.columns[i].equalsIgnoreCase("ACCOUNT_EXPIRY_DATE")) {
                        Long time = this.getLong((String)list.get(list.size() - 1));
                        if (this.columns[i].equalsIgnoreCase("ACCOUNT_EXPIRY_DATE") && time >= 5223372036854775807L) {
                            time = new Long(0L);
                        }
                        r.set(this.columns[i], (Object)time);
                        continue;
                    }
                    if (this.columns[i].equals("OU_NAME")) {
                        String dn = (String)list.get(list.size() - 1);
                        r.set(this.columns[i], (Object)StrUtil.getCanonicalName(dn, 1));
                        continue;
                    }
                    if (this.columns[i].equals("OBJECT_CLASS")) {
                        String objClass = (String)list.get(list.size() - 1);
                        r.set(this.columns[i], (Object)objClass);
                        continue;
                    }
                    if (this.columns[i].equals("OS_VERSION")) {
                        String osVersion = (String)list.get(0);
                        ArrayList osList = (ArrayList)prop.get("operatingSystem");
                        String osName = (String)osList.get(0);
                        if ("Mac OS X".equals(osName)) {
                            String osVerNam;
                            int first;
                            int second = (osVersion = osVersion.split(" ")[0]).indexOf(".", (first = osVersion.indexOf(".")) + 1);
                            if (second > first) {
                                osVersion = osVersion.substring(0, second);
                            }
                            if ((osVerNam = GinaReportUtil.getOSName(GinaReportUtil.MAC_OS_TYPE, osVersion)) != null && !"".equals(osVerNam)) {
                                osVersion = osVerNam;
                            }
                        }
                        r.set(this.columns[i], (Object)osVersion);
                        continue;
                    }
                    if (this.columns[i].equals("LOCATION")) {
                        String canonicalName = (String)list.get(0);
                        if (canonicalName != null && canonicalName.lastIndexOf("/") != -1) {
                            canonicalName = canonicalName.substring(0, canonicalName.lastIndexOf("/"));
                        }
                        r.set(this.columns[i], (Object)canonicalName);
                        continue;
                    }
                    if (this.columns[i].equalsIgnoreCase("USER_ACCOUNT_CONTROL")) {
                        Integer obj = new Integer((String)list.get(0));
                        int val = obj;
                        r.set(this.columns[i], (Object)val);
                        continue;
                    }
                    String value = (String)list.get(0);
                    r.set(this.columns[i], (Object)value);
                    if (!this.columns[i].equals("OBJECT_GUID")) continue;
                    tableKey = value;
                }
                TableUpdate.getInstance().add(this.key, tableKey, r);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addRowForGina(Properties prop, String str) {
        System.out.println("AddRowForGina in DomainListener");
    }

    public void addUsers(String domainName, Long loginId) {
        try {
            this.tableName = CommonUtil.getDomainUserTableName(domainName);
            this.key = this.tableName + new Long(System.currentTimeMillis()).toString();
            this.domainName = domainName;
            this.columns = userColumns;
            this.attribs = userAttribs;
            ArrayList mobileAttr = SecondaryAttributesHandler.getAttributes(domainName, "MOBILE");
            String[] mobAttribs = new String[mobileAttr.size()];
            for (int i = 0; i < mobileAttr.size(); ++i) {
                mobAttribs[i] = (String)mobileAttr.get(i);
            }
            this.mobAttribs = mobAttribs;
            ArrayList mailAttr = SecondaryAttributesHandler.getAttributes(domainName, "MAIL");
            String[] mailAttribs = new String[mailAttr.size()];
            for (int i = 0; i < mailAttr.size(); ++i) {
                mailAttribs[i] = (String)mailAttr.get(i);
            }
            this.mailAttribs = mailAttribs;
            String searchString = "(&(objectCategory=person)(objectClass=user))";
            logger.log(Level.INFO, "Domain Sync Adding users for the domain " + domainName + " started...............");
            TableUpdate.getInstance().registerForUpdation(this.tableName, this.key);
            Action action = new Action(domainName, searchString, loginId, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addComputers(String domainName, Long loginId, boolean updateEnrollment) {
        try {
            this.tableName = CommonUtil.getDomainComputerTableName(domainName);
            this.key = this.tableName + new Long(System.currentTimeMillis()).toString();
            this.domainName = domainName;
            this.columns = computerColumns;
            this.attribs = computerAttribs;
            String searchString = "(&(objectCategory=computer)(objectClass=computer))";
            logger.log(Level.INFO, "Domain Sync Adding computers for the domain " + domainName + " started...............");
            TableUpdate.getInstance().registerForUpdation(this.tableName, this.key);
            Action action = new Action(domainName, searchString, loginId, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addDomainComputerTable(String domainName) {
        try {
            this.tableName = CommonUtil.getDomainComputerTableName(domainName);
            String[] computerDesc = new String[]{"Column to Store Guid", "Column to Store Distinguished Name", "Column to Store Fully Qualified Display Name", "Column to Store Full Name", "Column to Store DNS_NAME"};
            String[] computerDataType = new String[]{"NCHAR", "NCHAR", "NCHAR", "NCHAR", "NCHAR"};
            int[] computerLen = new int[]{100, 1000, 1000, 255, 255};
            boolean[] computerNullable = new boolean[]{false, false, false, false, true};
            TableDefinition tableDef = new TableDefinition();
            tableDef.setTableName(this.tableName);
            for (int i = 0; i < computerColumns.length; ++i) {
                ColumnDefinition coldef = new ColumnDefinition();
                coldef.setColumnName(computerColumns[i]);
                coldef.setDescription(computerDesc[i]);
                coldef.setDataType(computerDataType[i]);
                if (computerLen[i] != -1) {
                    coldef.setMaxLength(computerLen[i]);
                }
                if (computerDataType[i] == "BIGINT") {
                    coldef.setDefaultValue((Object)0L);
                }
                coldef.setNullable(computerNullable[i]);
                tableDef.addColumnDefinition(coldef);
            }
            PrimaryKeyDefinition pkDef = new PrimaryKeyDefinition();
            pkDef.setName(this.tableName + "_PK");
            pkDef.addColumnName("OBJECT_GUID");
            pkDef.setTableName(this.tableName);
            tableDef.setPrimaryKey(pkDef);
            CommonUtil.getPersistence(new boolean[0]).createTable("adssp", tableDef);
            this.addComputers(domainName, 1L, true);
        }
        catch (Exception e) {
            System.out.println("Exception");
        }
    }

    public void addGroups(String domainName, Long loginId) {
        try {
            this.domainName = domainName;
            this.tableName = CommonUtil.getDomainGroupTableName(domainName);
            this.key = this.tableName + new Long(System.currentTimeMillis()).toString();
            this.columns = groupColumns;
            this.attribs = groupAttribs;
            String searchString = "(&(objectCategory=Group)(objectClass=group))";
            logger.log(Level.INFO, "Domain Sync Adding groups for the domain " + domainName + " started...............");
            TableUpdate.getInstance().registerForUpdation(this.tableName, this.key);
            Action action = new Action(domainName, searchString, loginId, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addObjectsToTable(String domainName, String tableName, String[] columns, String[] attribs, String objType, Long loginId) {
        try {
            this.domainName = domainName;
            this.tableName = tableName;
            this.key = tableName + Long.toString(System.currentTimeMillis());
            this.columns = columns;
            this.attribs = attribs;
            String searchString = "";
            logger.log(Level.INFO, "Domain Sync Adding objects to table");
            if (objType.equalsIgnoreCase("group")) {
                searchString = "(&(objectCategory=Group)(objectClass=group))";
                logger.log(Level.INFO, "Domain Sync Adding Groups for the domain " + domainName + " started...............");
            } else if (objType.equalsIgnoreCase("user")) {
                searchString = "(&(objectCategory=person)(objectClass=user))";
                logger.log(Level.INFO, "Domain Sync Adding Users for the domain " + domainName + " started...............");
            } else if (objType.equalsIgnoreCase("computer")) {
                searchString = "(&(objectCategory=computer)(objectClass=computer))";
                logger.log(Level.INFO, "Domain Sync Adding Computers for the domain " + domainName + " started...............");
            }
            if (searchString.equals("")) {
                return;
            }
            TableUpdate.getInstance().registerForUpdation(tableName, this.key);
            Action action = new Action(domainName, searchString, loginId, this);
            action.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private ArrayList getAttributeList(String searchString) {
        ArrayList<String> list = new ArrayList<String>();
        for (int i = 0; i < this.attribs.length; ++i) {
            int j;
            if (list.contains(this.attribs[i])) continue;
            if (searchString.indexOf("(objectClass=user)") != -1 && (this.attribs[i].equals("mobile") || this.attribs[i].equals("otherMobile"))) {
                ArrayList mobileAttr = SecondaryAttributesHandler.getAttributes(this.domainName, "MOBILE");
                for (j = 0; j < mobileAttr.size(); ++j) {
                    if (list.contains((String)mobileAttr.get(j))) continue;
                    list.add((String)mobileAttr.get(j));
                }
                continue;
            }
            if (searchString.indexOf("(objectClass=user)") != -1 && this.attribs[i].equals("mail")) {
                ArrayList mailAttr = SecondaryAttributesHandler.getAttributes(this.domainName, "MAIL");
                for (j = 0; j < mailAttr.size(); ++j) {
                    if (list.contains((String)mailAttr.get(j))) continue;
                    list.add((String)mailAttr.get(j));
                }
                continue;
            }
            list.add(this.attribs[i]);
        }
        return list;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public String getPrimaryGroupToken(String domainName, String groupDn) {
        return null;
    }

    private class Action
    extends Thread {
        private String searchString = null;
        private Long loginId = null;
        private String domainName = null;
        private NativeListener listener = null;

        public Action(String s1, String s2, Long l, NativeListener list) {
            this.domainName = s1;
            this.searchString = s2;
            this.loginId = l;
            this.listener = list;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                Properties domainDetails = DomainHandler.getConfiguredValues(this.domainName, this.loginId);
                domainDetails.put("NEED_DN", "true");
                ADHandler.getObjects(domainDetails, domainDetails.getProperty("DEFAULT_NAMING_CONTEXT"), DomainListener.this.getAttributeList(this.searchString), this.searchString, this.listener);
            }
            catch (NativeException ne) {
                DomainListener.this.errorMessage = ne.getExceptionMsg();
                ne.printStackTrace();
                TableUpdate.getInstance().deRegister(DomainListener.this.key);
            }
            catch (Exception e) {
                DomainListener.this.errorMessage = e.getMessage();
                e.printStackTrace();
                TableUpdate.getInstance().deRegister(DomainListener.this.key);
            }
            finally {
                DomainListener.this.waitForCompletion();
                TableUpdate.getInstance().deRegister(DomainListener.this.key);
                if (this.searchString.equalsIgnoreCase("(&(objectCategory=person)(objectClass=user))")) {
                    logger.log(Level.INFO, "Domain Sync Adding Users for the domain " + this.domainName + " completed...............");
                } else if (this.searchString.equalsIgnoreCase("(&(objectCategory=Group)(objectClass=group))")) {
                    logger.log(Level.INFO, "Domain Sync Adding Groups for the domain " + this.domainName + " completed...............");
                } else if (this.searchString.equalsIgnoreCase("(&(objectCategory=computer)(objectClass=computer))")) {
                    logger.log(Level.INFO, "Domain Sync Adding Computers for the domain " + this.domainName + " completed...............");
                }
            }
        }
    }
}

