/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.ProcessObject;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

public class DomainProcess {
    private static DomainProcess instance = null;
    private Hashtable hash = new Hashtable();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DomainProcess getInstance() {
        if (instance != null) return instance;
        Class<DomainProcess> clazz = DomainProcess.class;
        synchronized (DomainProcess.class) {
            if (instance != null) return instance;
            instance = new DomainProcess();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean isAnyDomainUpdateInProgress() {
        try {
            Hashtable domains = DomainHandler.getConfiguredDomains();
            Enumeration enumer = domains.keys();
            while (enumer.hasMoreElements()) {
                ArrayList currentActions;
                String distinName = (String)enumer.nextElement();
                Properties p = (Properties)domains.get(distinName);
                String domainName = p.getProperty("DOMAIN_NAME");
                ProcessObject process = null;
                if (this.hash.get(domainName) == null || !(currentActions = (process = (ProcessObject)this.hash.get(domainName)).getCurrentActions()).contains("scheduleUpdate") && !currentActions.contains("update")) continue;
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public void set(String key, String domainName, String action) throws Exception {
        ProcessObject process = null;
        process = this.hash.get(domainName) == null ? new ProcessObject(domainName) : (ProcessObject)this.hash.get(domainName);
        ArrayList currentActions = process.getCurrentActions();
        System.out.println(" List of current actions in domain process for the domain " + domainName + " is : " + currentActions);
        if (currentActions.size() > 0) {
            throw new ADSSPException("adssp.exception.java.domainp_update_domain");
        }
        process.set(key, action);
        this.hash.put(domainName, process);
    }

    public void finished(String key, String domainName) {
        ProcessObject process = (ProcessObject)this.hash.get(domainName);
        process.finished(key);
    }

    public boolean process(String key, String domainName, Long loginId, String action, Hashtable props) throws Exception {
        ProcessObject process = null;
        process = this.hash.get(domainName) == null ? new ProcessObject(domainName) : (ProcessObject)this.hash.get(domainName);
        this.hash.put(domainName, process);
        ArrayList currentActions = process.getCurrentActions();
        System.out.println(" List of current actions in domain process for the domain " + domainName + " is : " + currentActions);
        if (currentActions.contains("add")) {
            throw new ADSSPException("adssp.exception.java.domainp_update_domain");
        }
        if (currentActions.contains("update")) {
            throw new ADSSPException("adssp.exception.java.domainp_update_domain");
        }
        if (currentActions.contains("delete")) {
            throw new ADSSPException("adssp.exception.java.domainp_delete_domain");
        }
        if (currentActions.contains("scheduleUpdate")) {
            throw new ADSSPException("adssp.exception.java.domainp_update_domain");
        }
        process.startProcess(key, loginId, action, props);
        return true;
    }
}

