/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainDatas;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;

public class DomainUtil {
    public static Criteria getCritForLoggedInUser(Long loginId) {
        Criteria crit = null;
        if (ADMPRoleHandler.isADSSPUser(loginId)) {
            crit = DomainUtil.getCriteriaForLicensedDomains();
        } else {
            Properties logonUserProps = ADAuthHandler.getLoginUserDetails(loginId);
            String domainName = logonUserProps.getProperty("LOGIN_DOMAIN_NAME");
            crit = new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
        }
        return crit;
    }

    public static Criteria getCriteriaForLicensedDomains() {
        Criteria criteria = null;
        criteria = LicenseManager.getInstance().isFree() && !LicenseManager.getInstance().isFreeTool() && !LicenseManager.getInstance().wasFreeTool() ? new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0) : new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)"", 1);
        return criteria;
    }

    public static Hashtable getContainersForExecuteReport(String domain) {
        Hashtable<String, Cloneable> domainContainer = new Hashtable<String, Cloneable>();
        try {
            Criteria criteria = DomainUtil.getCriteriaForLicensedDomains();
            criteria = criteria.and(new Criteria(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"), (Object)domain, 0));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(DomainHandler.tableName, criteria);
            Iterator it = dataObj.getRows(DomainHandler.tableName);
            Hashtable<String, String> hash = new Hashtable<String, String>();
            while (it.hasNext()) {
                ArrayList<String> containerList = new ArrayList<String>();
                Row r = (Row)it.next();
                String dn = (String)r.get("DEFAULT_NAMING_CONTEXT");
                String domainName = (String)r.get("DOMAIN_NAME");
                hash.put(dn, domainName);
                containerList.add(dn);
                domainContainer.put(domainName, containerList);
            }
            domainContainer.put("dnDomainNameMap", hash);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainContainer;
    }

    public static void addUpdateLogonDomains(String domainName, String[] displayStatusKeys, int[] showStatus) {
        String tableName = "SSPLogonDomains";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (dObj.isEmpty()) {
                Row row = new Row(tableName);
                row.set("DOMAIN_NAME", (Object)domainName);
                for (int index = 0; index < displayStatusKeys.length; ++index) {
                    row.set(displayStatusKeys[index], (Object)showStatus[index]);
                }
                dObj.addRow(row);
            } else {
                Row row = dObj.getFirstRow(tableName);
                for (int index = 0; index < displayStatusKeys.length; ++index) {
                    row.set(displayStatusKeys[index], (Object)showStatus[index]);
                }
                dObj.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getDomainShowStatus() {
        ArrayList<Properties> logonList = new ArrayList<Properties>();
        String tableName = "SSPLogonDomains";
        Table baseTable = Table.getTable((String)DomainHandler.tableName);
        Table joinTable = Table.getTable((String)tableName);
        try {
            Join join = new Join(baseTable, joinTable, new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 2);
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addSelectColumn(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)DomainHandler.tableName, (String)"IS_DEFAULT_DOMAIN"));
            sq.addSelectColumn(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_DISPLAY_NAME"));
            sq.addSelectColumn(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_FLAT_NAME"));
            sq.addSelectColumn(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_DNS_NAME"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"DISPLAY_STATUS"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"MOBILE_DISPLAY_STATUS"));
            sq.addJoin(join);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)DomainHandler.tableName, (String)"DOMAIN_DISPLAY_NAME"), true));
            sq.setCriteria(DomainUtil.getCriteriaForLicensedDomains());
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = obj.getRows(DomainHandler.tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String domName = (String)r.get("DOMAIN_NAME");
                String domDisplayName = (String)r.get("DOMAIN_DISPLAY_NAME");
                String domFlatName = (String)r.get("DOMAIN_FLAT_NAME");
                String isDefault = (String)r.get("IS_DEFAULT_DOMAIN");
                String domDnsName = (String)r.get("DOMAIN_DNS_NAME");
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domName, 0);
                Row lR = obj.getRow(tableName, crit);
                if (lR == null) continue;
                Properties p = new Properties();
                p.put("DOMAIN_NAME", domName);
                p.put("DOMAIN_DISPLAY_NAME", domDisplayName);
                p.put("DOMAIN_FLAT_NAME", domFlatName);
                p.put("DOMAIN_DNS_NAME", domDnsName);
                p.put("DISPLAY_STATUS", (Integer)lR.get("DISPLAY_STATUS"));
                p.put("MOBILE_DISPLAY_STATUS", (Object)(lR.get("MOBILE_DISPLAY_STATUS") == null ? 1 : (Integer)lR.get("MOBILE_DISPLAY_STATUS")));
                p.put("IS_DEFAULT_DOMAIN", isDefault);
                logonList.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logonList;
    }

    public static ArrayList getDropDownDomains() {
        return DomainUtil.getDropDownDomains(false);
    }

    public static ArrayList getDropDownDomains(boolean isMobileShow) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        ArrayList<Properties> logonDomainList = new ArrayList<Properties>();
        try {
            String showSelectDom;
            ArrayList showList = DomainUtil.getDomainShowStatus();
            String string = showSelectDom = isMobileShow ? String.valueOf(MobileUtil.getSelectDomainOption()) : ADSMPersUtil.getSyMParameter("selectDomainOption");
            if ("true".equalsIgnoreCase(showSelectDom)) {
                Properties domProps = new Properties();
                domProps.put("DOMAIN_FLAT_NAME", "--");
                domProps.put("DOMAIN_DISPLAY_NAME", rb.getString("adssp.admin.general.custom_disp_settgs.select_domain_disp"));
                domProps.put("SELECT_DOMAIN", "true");
                domProps.put("DOMAIN_NAME", "--");
                domProps.put("DOMAIN_DNS_NAME", "--");
                logonDomainList.add(domProps);
            }
            String displayStatus = "DISPLAY_STATUS";
            if (isMobileShow) {
                displayStatus = "MOBILE_DISPLAY_STATUS";
            }
            for (int i = 0; i < showList.size(); ++i) {
                Properties p = (Properties)showList.get(i);
                String domName = (String)p.get("DOMAIN_NAME");
                int show = (Integer)p.get(displayStatus);
                if (show == 0) continue;
                Properties domProps = new Properties();
                domProps.put("DOMAIN_FLAT_NAME", (String)p.get("DOMAIN_FLAT_NAME"));
                domProps.put("DOMAIN_DISPLAY_NAME", (String)p.get("DOMAIN_DISPLAY_NAME"));
                domProps.put("DOMAIN_NAME", (String)p.get("DOMAIN_NAME"));
                domProps.put("DOMAIN_DNS_NAME", (String)p.get("DOMAIN_DNS_NAME"));
                String selectDomain = "true".equalsIgnoreCase(showSelectDom) ? "false" : (String)p.get("IS_DEFAULT_DOMAIN");
                domProps.put("SELECT_DOMAIN", selectDomain);
                logonDomainList.add(domProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return logonDomainList;
    }

    public static String getDnFlatName(String domainName) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
            Row r = obj.getFirstRow("ADSMDomainConfiguration");
            return (String)r.get("DOMAIN_FLAT_NAME");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    public static String getDomainDN(ArrayList domainList, String domainName) {
        for (int i = 0; i < domainList.size(); ++i) {
            Properties p = (Properties)domainList.get(i);
            String domain = p.getProperty("DOMAIN_NAME");
            if (!domainName.equalsIgnoreCase(domain)) continue;
            return p.getProperty("DEFAULT_NAMING_CONTEXT");
        }
        return null;
    }

    public static String getDomainData(String domainName, String domainData) {
        String domainDataValue = (String)DomainDatas.getInstance().getValue(domainName, domainData);
        if (domainDataValue == null) {
            domainDataValue = DomainHandler.getDomainData("DOMAIN_NAME", domainName, domainData);
            DomainDatas.getInstance().setValue(domainName, domainData, domainDataValue);
        }
        return domainDataValue;
    }

    public static Hashtable getDomainGenDetails(String inputColumn, String inputValue, String[] outputColumns) {
        Hashtable<String, String> outData = new Hashtable<String, String>();
        try {
            String domGenTable = "ADSMDomainGeneralDetails";
            Criteria domGencrit = new Criteria(Column.getColumn((String)domGenTable, (String)inputColumn), (Object)inputValue, 0);
            DataObject domGenDObj = CommonUtil.getPersistence(new boolean[0]).get(domGenTable, domGencrit);
            if (!domGenDObj.isEmpty()) {
                Row domGenRow = domGenDObj.getFirstRow(domGenTable);
                for (String column : outputColumns) {
                    outData.put(column, (String)domGenRow.get(column));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return outData;
    }

    public static void changeGuidFormat(Properties userProp) {
        ArrayList guidList = (ArrayList)userProp.get("objectGUID");
        int listSize = guidList.size();
        String objectGUID = (String)guidList.remove(listSize - 1);
        int length = objectGUID.length() - 1;
        if (objectGUID.charAt(0) == '{' && objectGUID.charAt(length) == '}') {
            guidList.add(listSize - 1, objectGUID.substring(1, length));
        }
    }

    public static ArrayList getLoginAttributeList() {
        ArrayList<Properties> loginAttrList = new ArrayList<Properties>();
        String tableName = "SSPLoginAttributes";
        Table baseTable = Table.getTable((String)tableName);
        try {
            SelectQueryImpl sq = new SelectQueryImpl(baseTable);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"LDAP_NAME"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"ENABLE_STATUS"));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"PREDEFINED"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = obj.getRows(tableName);
            while (it.hasNext()) {
                Row r = (Row)it.next();
                if (r == null) continue;
                String ldapName = (String)r.get("LDAP_NAME");
                Boolean enableStatus = (Boolean)r.get("ENABLE_STATUS");
                Boolean isPredefined = (Boolean)r.get("PREDEFINED");
                Properties p = new Properties();
                p.put("LDAP_NAME", ldapName);
                p.put("ENABLE_STATUS", enableStatus);
                p.put("PREDEFINED", isPredefined);
                loginAttrList.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return loginAttrList;
    }

    public static void setLoginAttributeList(ArrayList loginAttrList) {
        String tableName = "SSPLoginAttributes";
        ArrayList<String> ldapNameList = new ArrayList<String>();
        DataObject dObj = null;
        for (int j = 0; j < loginAttrList.size(); ++j) {
            Properties p = (Properties)loginAttrList.get(j);
            String ldapName = (String)p.get("LDAP_NAME");
            ldapNameList.add(ldapName);
        }
        if (ldapNameList.size() > 0) {
            try {
                String[] ldapNameArr = ldapNameList.toArray(new String[ldapNameList.size()]);
                Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"LDAP_NAME"), (Object)ldapNameArr, 8);
                dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
                if (!dObj.isEmpty()) {
                    for (int j = 0; j < loginAttrList.size(); ++j) {
                        Criteria crit1;
                        Row row;
                        Properties p = (Properties)loginAttrList.get(j);
                        String ldapName = (String)p.get("LDAP_NAME");
                        Boolean enableStatus = (Boolean)p.get("ENABLE_STATUS");
                        Boolean isPredefined = (Boolean)p.get("PREDEFINED");
                        if (ldapName.equals("sAMAccountName")) {
                            enableStatus = true;
                        }
                        if ((row = dObj.getRow(tableName, crit1 = new Criteria(Column.getColumn((String)tableName, (String)"LDAP_NAME"), (Object)ldapName, 0))) == null) {
                            Row newRow = new Row(tableName);
                            newRow.set("LDAP_NAME", (Object)ldapName);
                            newRow.set("ENABLE_STATUS", (Object)enableStatus);
                            newRow.set("PREDEFINED", (Object)isPredefined);
                            dObj.addRow(newRow);
                            continue;
                        }
                        row.set("ENABLE_STATUS", (Object)enableStatus);
                        dObj.updateRow(row);
                    }
                } else {
                    Properties p = (Properties)loginAttrList.get(0);
                    String ldapName = (String)p.get("LDAP_NAME");
                    Boolean enableStatus = (Boolean)p.get("ENABLE_STATUS");
                    Boolean isPredefined = (Boolean)p.get("PREDEFINED");
                    Row row = new Row(tableName);
                    row.set("LDAP_NAME", (Object)ldapName);
                    row.set("ENABLE_STATUS", (Object)enableStatus);
                    row.set("PREDEFINED", (Object)isPredefined);
                    dObj.addRow(row);
                }
                CommonUtil.getPersistence(new boolean[0]).update(dObj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void deleteFromLoginAttributeList(Properties attrProperty) {
        String tableName = "SSPLoginAttributes";
        String ldapName = (String)attrProperty.get("LDAP_NAME");
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"LDAP_NAME"), (Object)ldapName, 0);
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!dObj.isEmpty()) {
                Row row = dObj.getFirstRow(tableName);
                dObj.deleteRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

