/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.sym.adsm.common.server.NativeException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class NativeError {
    private Hashtable errors = null;
    private static Logger logger = Logger.getLogger(NativeError.class.getName());

    public Hashtable getErrors() {
        return this.errors;
    }

    public Hashtable getError(Object key) {
        logger.log(Level.INFO, "The key on error is : " + key + " t error e" + this.errors);
        if (this.errors != null) {
            ArrayList errorList = (ArrayList)this.errors.get(key);
            if (errorList != null) {
                return (Hashtable)errorList.get(0);
            }
            return null;
        }
        return null;
    }

    public String getSeverityLevel(Object key) {
        ArrayList errorList;
        String s = null;
        if (this.errors != null && (errorList = (ArrayList)this.errors.get(key)) != null && !errorList.isEmpty()) {
            Hashtable h = (Hashtable)errorList.get(0);
            s = (String)h.get("ERROR_SEVERITY");
        }
        return s;
    }

    public void checkForException(Object key) throws Exception {
        Hashtable h;
        String severity;
        ArrayList errorList;
        if (this.errors != null && (errorList = (ArrayList)this.errors.get(key)) != null && !errorList.isEmpty() && "SEVERE".equalsIgnoreCase(severity = (String)(h = (Hashtable)errorList.get(0)).get("ERROR_SEVERITY"))) {
            String code = (String)h.get("ERROR_CODE");
            String message = (String)h.get("ERROR_MESSAGE");
            logger.log(Level.INFO, "Throwing Native Exception : " + message + "::::: For the Key :::" + key);
            throw new NativeException(severity, code, message, key);
        }
    }

    public ArrayList getErrorMessage(Object key) {
        ArrayList<String> throwList = new ArrayList<String>();
        if (this.errors != null) {
            ArrayList errorList = (ArrayList)this.errors.get(key);
            StringBuilder stringBuilder = new StringBuilder();
            if (errorList != null && !errorList.isEmpty()) {
                for (Hashtable hashtable : errorList) {
                    throwList.add((String)hashtable.get("ERROR_MESSAGE"));
                    if (hashtable.get("NATIVE_ERROR_MESSAGE") != null) {
                        throwList.add((String)hashtable.get("NATIVE_ERROR_MESSAGE"));
                    }
                    if (hashtable.get("ERROR_CODE") == null) continue;
                    throwList.add(" - ");
                    throwList.add("adssp.error.native.error_code");
                    throwList.add(" : ");
                    throwList.add((String)hashtable.get("ERROR_CODE"));
                    throwList.add("&&");
                }
            }
        }
        return throwList;
    }

    public ArrayList<Hashtable> getErrorList(Object key) {
        ArrayList errorList = new ArrayList();
        if (this.errors != null) {
            errorList = (ArrayList)this.errors.get(key);
        }
        return errorList;
    }

    public void setErrorList(Object key, String errorSeverity, Object errorCode, Object errorMessage, Object nativeErrorMessage) {
        ArrayList errorList;
        if (this.errors == null) {
            this.errors = new Hashtable();
        }
        if ((errorList = (ArrayList)this.errors.get(key)) == null) {
            errorList = new ArrayList();
        }
        Hashtable<String, Object> errorTable = new Hashtable<String, Object>();
        errorTable.put("ERROR_SEVERITY", errorSeverity);
        if (errorCode != null) {
            errorTable.put("ERROR_CODE", errorCode);
        }
        logger.log(Level.INFO, "setErrorList errorMessage : " + errorMessage);
        String frerr = null;
        if (errorMessage != null) {
            frerr = this.findReasonableErrorMessage((String)errorCode, errorMessage);
            logger.log(Level.INFO, " findReason Error Message " + errorMessage);
            errorTable.put("ERROR_MESSAGE", frerr);
        } else if (nativeErrorMessage != null) {
            frerr = this.findReasonableErrorMessage((String)errorCode, nativeErrorMessage);
            logger.log(Level.INFO, " findReason Error Message(nativeErrorMessage) " + errorMessage);
            errorTable.put("ERROR_MESSAGE", frerr);
        } else {
            errorTable.put("ERROR_MESSAGE", (String)errorMessage);
        }
        errorList.add(errorTable);
        logger.log(Level.INFO, "setting error lists : " + errorTable + " for the key : " + key);
        this.errors.put(key, errorList);
    }

    public static String findNonADNativeError(String errorCode, String error) {
        if (error.equals("adssp.native.error.adlds")) {
            if (errorCode.equals("0x8007203a")) {
                return "adssp.nonad.pwdsync.adlds.host_unreachable";
            }
            if (errorCode.equals("0x8007052e")) {
                return "adssp.nonad.pwdsync.adlds.user_password_invalid";
            }
            if (errorCode.equals("0x31")) {
                return "adssp.nonad.pwdsync.adlds.invalid_oldpassword";
            }
            if (errorCode.equals("0x80005009") || errorCode.equals("0x8007202f")) {
                return "adssp.nonad.pwdsync.adlds.invalid_password";
            }
            if (errorCode.equals("0x80070005")) {
                return "adssp.nonad.pwdsync.adlds.insufficient_rights";
            }
            if (errorCode.equals("User Not Locked")) {
                return "adssp.nonad.pwdsync.adlds.user_not_locked";
            }
        } else if (error.equals("adssp.native.error.openldap")) {
            if (errorCode.equals("0x51")) {
                return "adssp.nonad.pwdsync.openldap.host_unreachable";
            }
            if (errorCode.equals("0x31_admin") || errorCode.equals("0x22")) {
                return "adssp.nonad.pwdsync.openldap.user_password_invalid";
            }
            if (errorCode.equals("0x31_user")) {
                return "adssp.nonad.pwdsync.openldap.invalid_oldpassword";
            }
            if (errorCode.equals("0x31_newpass")) {
                return "adssp.nonad.pwdsync.openldap.invalid_password";
            }
            if (errorCode.equals("0x32")) {
                return "adssp.nonad.pwdsync.openldap.insufficient_rights";
            }
        }
        return errorCode;
    }

    public String findReasonableErrorMessage(String errorCode, Object errorMessage) {
        String reasonMsg = (String)errorMessage;
        if (((String)errorMessage).equalsIgnoreCase("adssp.error.native.useradmin.set_attribute")) {
            reasonMsg = "adssp.error.native.useradmin.set_attribute";
        } else if (((String)errorMessage).equalsIgnoreCase("adssp.error.native.domainutil.invalid_user_pwd")) {
            reasonMsg = "adssp.native.err.old_pwd_wrong_or_domainsettings_wrong";
        } else if (((String)errorMessage).equalsIgnoreCase("adssp.native.err.changepassword") || ((String)errorMessage).equalsIgnoreCase("adssp.native.err.powershell.changepassword_troubleshoot")) {
            if (errorCode.equalsIgnoreCase("80070056")) {
                reasonMsg = "specified_network_password_not_correct";
            } else if (errorCode.equalsIgnoreCase("80070005")) {
                reasonMsg = "user_cannot_change_password_flag_on_ad";
            } else if (errorCode.equalsIgnoreCase("800708c5")) {
                reasonMsg = "adssp.error.native.change_password_policy";
            } else if (errorCode.equalsIgnoreCase("80072030")) {
                reasonMsg = "adssp.error.native.nosuch_object_on_the_server";
            } else if (errorCode.equalsIgnoreCase("8007202f")) {
                reasonMsg = "adssp.error.native.change_pwd_min_pwd_age_set";
            } else if (errorCode.equalsIgnoreCase("80072035")) {
                reasonMsg = "adssp.custom.error.text.change_password_policy";
            } else if (errorCode.equalsIgnoreCase("80070775")) {
                reasonMsg = "adssp.error.native.referenced_acc_locked_out";
            } else if (errorCode.equalsIgnoreCase("8007052e")) {
                reasonMsg = "specified_network_password_not_correct";
            }
        } else if (((String)errorMessage).equalsIgnoreCase("adssp.native.err.setpassword")) {
            if (errorCode.equalsIgnoreCase("8007203a")) {
                reasonMsg = "adssp.error.native.domain_settgs_credential_incorrect";
            } else if (errorCode.equalsIgnoreCase("80070005")) {
                reasonMsg = "adssp.error.native.no_reset_priviledge";
            } else if (errorCode.equalsIgnoreCase("8007202f")) {
                reasonMsg = "adssp.error.native.minimum_password_age_set";
            } else if (errorCode.equalsIgnoreCase("800708c5")) {
                reasonMsg = "adssp.error.native.reset.password_policy";
            } else if (errorCode.equalsIgnoreCase("80072030")) {
                reasonMsg = "adssp.error.native.nosuch_object_on_the_server";
            } else if (errorCode.equalsIgnoreCase("80072035")) {
                reasonMsg = "adssp.custom.error.text.reset_password_policy";
            }
        } else if (((String)errorMessage).equalsIgnoreCase("adssp.native.err.modifyuser")) {
            if (errorCode.equalsIgnoreCase("80070005")) {
                reasonMsg = "adssp.error.native.no_unlock_priviledge";
            } else if (errorCode.equalsIgnoreCase("80072030")) {
                reasonMsg = "adssp.error.native.nosuch_object_on_the_server";
            } else if (errorCode.equalsIgnoreCase("80072035")) {
                reasonMsg = "adssp.error.native.modify_server_unwilling_process";
            }
        }
        return reasonMsg;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        if (this.errors != null) {
            Enumeration enumeration = this.errors.keys();
            while (enumeration.hasMoreElements()) {
                String key = (String)enumeration.nextElement();
                ArrayList list = (ArrayList)this.errors.get(key);
                builder.append("key is " + key);
                builder.append("error values = ");
                if (list == null || list.isEmpty()) continue;
                for (Hashtable hashtable : list) {
                    builder.append("{");
                    builder.append("ERROR_SEVERITY : " + hashtable.get("ERROR_SEVERITY"));
                    builder.append("ERROR_CODE : " + hashtable.get("ERROR_CODE"));
                    builder.append("ERROR_MESSAGE : " + hashtable.get("ERROR_MESSAGE"));
                    builder.append("}, ");
                }
            }
            return builder.toString();
        }
        return "Error Object is  null";
    }
}

