/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.ADSSPException;
import com.adventnet.sym.adsm.common.server.DomainAction;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.NativeException;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.taskengine.SchedulerConfiguration;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;

public class ProcessObject {
    private String domainName = null;
    private Hashtable hash = null;

    public ProcessObject(String str) {
        this.domainName = str;
        this.hash = new Hashtable();
    }

    public ArrayList getCurrentActions() {
        ArrayList<String> list = new ArrayList<String>();
        System.out.println(" Properties in the Process Object for the domain " + this.domainName + " is : " + this.hash);
        Enumeration e = this.hash.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            Hashtable stat = (Hashtable)this.hash.get(key);
            String action = (String)stat.get("action");
            String isCompleted = (String)stat.get("isCompleted");
            if (!isCompleted.equalsIgnoreCase("false")) continue;
            list.add(action);
        }
        return list;
    }

    public void set(String key, String action) {
        Hashtable<String, String> status = new Hashtable<String, String>();
        status.put("action", action);
        status.put("isCompleted", "false");
        this.hash.put(key, status);
    }

    public void finished(String key) {
        Hashtable stat = (Hashtable)this.hash.get(key);
        stat.put("isCompleted", "true");
    }

    public void startProcess(String key, Long loginId, String action, Hashtable props) {
        Hashtable<String, String> status = new Hashtable<String, String>();
        status.put("action", action);
        status.put("isCompleted", "false");
        this.hash.put(key, status);
        Action thr = new Action(key, action, loginId, props);
    }

    public void addDomainData(String domainName, Long loginId) {
        try {
            DomainAction.addOUs(domainName, loginId, false);
        }
        catch (ADSSPException ae) {
            ae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DomainAction.addSIDs(domainName, loginId, false);
        }
        catch (ADSSPException ae) {
            ae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DomainAction.addPolicies(domainName, loginId);
        }
        catch (ADSSPException ae) {
            ae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            DomainAction.addComputers(domainName, loginId, false);
        }
        catch (ADSSPException ae) {
            ae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        ReportHandler.executeDomainReports(domainName, 1L);
    }

    public void scheduleUpdate(String domainName, Long loginId, Hashtable props) {
        ArrayList<Hashtable> errorList;
        String cumMsg;
        block17: {
            cumMsg = "";
            errorList = new ArrayList<Hashtable>();
            try {
                if (!ADHandler.checkServerStatus(domainName, loginId)) break block17;
                try {
                    DomainAction.addOUs(domainName, loginId, true);
                }
                catch (ADSSPException ae) {
                    errorList.add(ae.getMultipleException());
                    ae.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    DomainAction.addSIDs(domainName, loginId, true);
                }
                catch (ADSSPException ae) {
                    errorList.add(ae.getMultipleException());
                    ae.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    DomainAction.addPolicies(domainName, loginId);
                }
                catch (ADSSPException ae) {
                    errorList.add(ae.getMultipleException());
                    ae.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                try {
                    DomainAction.addComputers(domainName, loginId, true);
                }
                catch (ADSSPException ae) {
                    errorList.add(ae.getMultipleException());
                    ae.printStackTrace();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            catch (NativeException ne) {
                try {
                    Hashtable<String, NativeException> hash = new Hashtable<String, NativeException>();
                    hash.put("adssp.common.text.domain", ne);
                    throw new ADSSPException(hash);
                }
                catch (ADSSPException ae) {
                    errorList.add(ae.getMultipleException());
                    ae.printStackTrace();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        cumMsg = !errorList.isEmpty() ? StrUtil.getJSONString(errorList) : "adssp.admin.schedulelist.column.status_msg_success";
        SchedulerConfiguration.updateScheduleStatus(domainName, (Long)props.get("SCHEDULE_ID"), cumMsg);
    }

    public void updateDomainData(String domainName, Long loginId, Hashtable props) {
        try {
            String message = "Success";
            String tableDCName = DomainHandler.tableDCName;
            try {
                if (ADHandler.checkServerStatus(domainName, loginId)) {
                    ArrayList updates = (ArrayList)props.get("actionList");
                    Object column = null;
                    Object criteria = null;
                    for (int i = 0; i < updates.size(); ++i) {
                        String update = (String)updates.get(i);
                        if (update.equalsIgnoreCase("Exchange")) {
                            try {
                                DomainAction.addPolicies(domainName, loginId);
                            }
                            catch (ADSSPException ae) {
                                ae.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (update.equalsIgnoreCase("Group")) {
                            try {
                                DomainAction.addGroups(domainName, loginId, true);
                            }
                            catch (ADSSPException ae) {
                                ae.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (update.equalsIgnoreCase("OU")) {
                            try {
                                DomainAction.addOUs(domainName, loginId, true);
                            }
                            catch (ADSSPException ae) {
                                ae.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (update.equalsIgnoreCase("Others")) {
                            try {
                                DomainAction.addUsers(domainName, loginId, true);
                            }
                            catch (ADSSPException ae) {
                                ae.printStackTrace();
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            continue;
                        }
                        if (!update.equalsIgnoreCase("Computers")) continue;
                        try {
                            DomainAction.addComputers(domainName, loginId, true);
                            continue;
                        }
                        catch (ADSSPException ae) {
                            ae.printStackTrace();
                            continue;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                    ReportHandler.executeDomainReports(domainName, 1L);
                }
            }
            catch (NativeException ne) {
                ne.printStackTrace();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                Criteria criteria = new Criteria(new Column(tableDCName, "DOMAIN_NAME"), (Object)domainName, 0);
                criteria = criteria.and(new Criteria(new Column(tableDCName, "PRIORITY_ID"), (Object)1, 0));
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get(tableDCName, criteria);
                if (!dataObject.isEmpty()) {
                    Iterator it = dataObject.getRows(tableDCName, criteria);
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        r.set("MESSAGE", (Object)message);
                        dataObject.updateRow(r);
                    }
                    CommonUtil.getPersistenceLite().update(dataObject);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class Action
    extends Thread {
        private String action = null;
        private String key = null;
        private Long loginId = null;
        private Hashtable props = null;

        public Action(String k, String ac, Long l, Hashtable p) {
            this.key = k;
            this.loginId = l;
            this.action = ac;
            this.props = p;
            this.start();
        }

        @Override
        public void run() {
            if (this.action.equalsIgnoreCase("add")) {
                ProcessObject.this.addDomainData(ProcessObject.this.domainName, this.loginId);
            } else if (this.action.equalsIgnoreCase("update")) {
                ProcessObject.this.updateDomainData(ProcessObject.this.domainName, this.loginId, this.props);
            } else if (this.action.equalsIgnoreCase("scheduleUpdate")) {
                ProcessObject.this.scheduleUpdate(ProcessObject.this.domainName, this.loginId, this.props);
            } else if (this.action.equalsIgnoreCase("delete")) {
                DomainAction.deleteDomainDatas(ProcessObject.this.domainName);
            }
            Hashtable status = (Hashtable)ProcessObject.this.hash.get(this.key);
            status.put("isCompleted", "true");
        }
    }
}

