/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Properties;

public class SidQueue
extends Thread {
    private boolean isCompleted = false;
    private ArrayList sidList = null;
    private ArrayList list = null;
    private static String[] sidListProp = new String[]{"SID_STRING", "DISPLAY_NAME", "TYPE_STRING", "DN_STRING", "FQDN", "FOLDER", "IMAGE_ICON", "SID_IDENTIFIER", "CREATION_TIME", "MODIFIED_TIME"};
    private boolean shutDown = false;
    private Object object1 = new Object();
    private Object object2 = new Object();

    public SidQueue() {
        this.sidList = new ArrayList();
        this.list = new ArrayList();
    }

    public boolean isCompleted() {
        if (this.shutDown) {
            return true;
        }
        return this.isCompleted;
    }

    public void shutDown() {
        this.shutDown = true;
    }

    private Long getLong(String s) {
        Long t = System.currentTimeMillis();
        try {
            t = new Long(s);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return t;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueue(Properties prop) {
        this.isCompleted = false;
        Object object = this.object1;
        synchronized (object) {
            ArrayList objectSID = (ArrayList)prop.get("objectSID");
            String SID_STRING = (String)objectSID.get(0);
            prop.setProperty("SID_STRING", SID_STRING);
            ArrayList distinguishedName = (ArrayList)prop.get("distinguishedName");
            String DN_STRING = (String)distinguishedName.get(0);
            prop.setProperty("DN_STRING", DN_STRING);
            ArrayList objectClass = (ArrayList)prop.get("objectClass");
            String TYPE_STRING = (String)objectClass.get(objectClass.size() - 1);
            prop.setProperty("TYPE_STRING", TYPE_STRING);
            ArrayList whenCreated = (ArrayList)prop.get("whenCreated");
            Long creationTime = this.getLong((String)whenCreated.get(whenCreated.size() - 1));
            prop.put("CREATION_TIME", creationTime);
            ArrayList whenChanged = (ArrayList)prop.get("whenChanged");
            Long modifiedTime = this.getLong((String)whenChanged.get(whenChanged.size() - 1));
            prop.put("MODIFIED_TIME", modifiedTime);
            ArrayList l = (ArrayList)prop.get("cn");
            prop.setProperty("DISPLAY_NAME", (String)l.get(0));
            String fqdn = prop.getProperty("FQDN");
            String FOLDER = "";
            if (fqdn == null) {
                fqdn = "";
                FOLDER = "";
                prop.setProperty("FQDN", fqdn);
            } else {
                int index = fqdn.lastIndexOf("/");
                if (index != -1) {
                    FOLDER = fqdn.substring(0, fqdn.lastIndexOf("/"));
                }
            }
            prop.setProperty("FOLDER", FOLDER);
            if (TYPE_STRING.equals("computer")) {
                prop.setProperty("IMAGE_ICON", "images/computer-small.gif");
                prop.put("SID_IDENTIFIER", new Integer(3));
            } else if (TYPE_STRING.equals("user")) {
                prop.setProperty("IMAGE_ICON", "images/user.gif");
                prop.put("SID_IDENTIFIER", new Integer(1));
            } else if (TYPE_STRING.equals("group")) {
                prop.setProperty("IMAGE_ICON", "images/group.gif");
                prop.put("SID_IDENTIFIER", new Integer(2));
            } else {
                prop.setProperty("IMAGE_ICON", "images/closed_dir.png");
                prop.put("SID_IDENTIFIER", new Integer(4));
            }
            this.sidList.add(prop);
            if (this.sidList.size() >= 500) {
                this.object1.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            Object object = this.object2;
            synchronized (object) {
                if (this.sidList.isEmpty()) {
                    return;
                }
                this.list.clear();
                this.list.addAll(this.sidList);
                this.sidList.clear();
            }
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < this.list.size(); ++i) {
                Properties p = new Properties();
                p = (Properties)this.list.get(i);
                String sidTableName = (String)p.remove("sidTableName");
                Row sidRow = CommonUtil.getRowObject(p, sidListProp, sidTableName);
                dataObject.addRow(sidRow);
            }
            CommonUtil.getPersistenceLite().add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void waitForCompletion() {
        while (!this.isCompleted) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void waitForUpdate(long t) {
        try {
            Object object = this.object1;
            synchronized (object) {
                this.object1.wait(t);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public void run() {
        try {
            while (!this.shutDown) {
                this.waitForUpdate(500L);
                this.process();
                if (this.sidList.size() != 0) continue;
                this.isCompleted = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

