/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.logging.Level;
import java.util.logging.Logger;

public class TableQueue
extends Thread {
    private static Logger logger = Logger.getLogger(TableQueue.class.getName());
    private ArrayList tableKeyList = null;
    private Hashtable keyVsProp = null;
    private ArrayList rows = null;
    private boolean shutDown = false;
    private Object obj = new Object();

    public TableQueue() {
        this.tableKeyList = new ArrayList();
        this.keyVsProp = new Hashtable();
        this.rows = new ArrayList();
        this.start();
    }

    public boolean isCompleted(Object key) {
        if (this.shutDown) {
            if (this.tableKeyList.size() > 0) {
                logger.log(Level.INFO, "BUG : It Should not happen " + this.tableKeyList);
            }
            return true;
        }
        Hashtable keyProp = (Hashtable)this.keyVsProp.get(key);
        ArrayList tableKeys = (ArrayList)keyProp.get("tableKeys");
        if (tableKeys != null && tableKeys.size() > 0) {
            return false;
        }
        return !keyProp.get("isCompleted").equals("false");
    }

    public void shutDown() {
        this.shutDown = true;
    }

    public void setProps(Object key) {
        Hashtable<String, String> keyProp = (Hashtable<String, String>)this.keyVsProp.get(key);
        if (keyProp == null) {
            keyProp = new Hashtable<String, String>();
        }
        keyProp.put("isCompleted", "false");
        this.keyVsProp.put(key, keyProp);
    }

    public synchronized void waitForUpdate(long t) {
        try {
            super.wait(t);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void addToQueue(Object key, String tableKey, Row r) {
        Object object = this.obj;
        synchronized (object) {
            if (!this.tableKeyList.contains(tableKey)) {
                this.tableKeyList.add(tableKey);
            }
            this.rows.add(r);
            Hashtable keyProp = (Hashtable)this.keyVsProp.get(key);
            ArrayList<String> tableKeys = (ArrayList<String>)keyProp.get("tableKeys");
            keyProp.put("isCompleted", "false");
            if (tableKeys == null) {
                tableKeys = new ArrayList<String>();
            }
            tableKeys.add(tableKey);
            keyProp.put("tableKeys", tableKeys);
            if (this.tableKeyList.size() >= 500) {
                this.notifyAll();
            }
        }
    }

    public void checkForNextUpdate() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void process() {
        try {
            ArrayList l = null;
            Object object = this.obj;
            synchronized (object) {
                if (this.tableKeyList.size() == 0) {
                    return;
                }
                l = this.rows;
                this.tableKeyList = new ArrayList();
                this.rows = new ArrayList();
                Enumeration e = this.keyVsProp.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    Hashtable keyProp = (Hashtable)this.keyVsProp.get(key);
                    ArrayList tableKeys = (ArrayList)keyProp.remove("tableKeys");
                }
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < l.size(); ++i) {
                dataObj.addRow((Row)l.get(i));
            }
            CommonUtil.getPersistenceLite().add(dataObj);
            this.waitForUpdate(300L);
            this.updateStatus();
            logger.log(Level.INFO, "Completing the Updation with the total count of " + l.size());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStatus() {
        Object object = this.obj;
        synchronized (object) {
            Enumeration e = this.keyVsProp.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                Hashtable keyProp = (Hashtable)this.keyVsProp.get(key);
                ArrayList tableKeys = (ArrayList)keyProp.remove("tableKeys");
                if (tableKeys != null && tableKeys.size() != 0) continue;
                keyProp.put("isCompleted", "true");
            }
        }
    }

    public void checkAndProcess() {
        this.waitForUpdate(300L);
        this.process();
    }

    @Override
    public void run() {
        try {
            while (!this.shutDown) {
                this.checkAndProcess();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

