/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.Hashtable;
import java.util.Iterator;

public class UrlClicksHandler {
    private static UrlClicksHandler handler = null;
    private DataObject dataObj = null;
    private int noOfClicks = 0;

    private UrlClicksHandler() {
        this.getURLs();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static UrlClicksHandler getInstance() {
        if (handler != null) return handler;
        Class<UrlClicksHandler> clazz = UrlClicksHandler.class;
        synchronized (UrlClicksHandler.class) {
            if (handler != null) return handler;
            handler = new UrlClicksHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    public void updateClicks(String url) {
        url = url.substring(1);
        try {
            Iterator rows = this.dataObj.getRows("ADSMUrlClicks");
            int minRemainCount = -1;
            Row matchRow = null;
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                String s = (String)r.get("URL_STRING");
                if (!url.startsWith(s)) continue;
                int remainCount = url.compareTo(s);
                if (minRemainCount != -1 && remainCount > minRemainCount) continue;
                minRemainCount = remainCount;
                matchRow = r;
            }
            if (matchRow != null) {
                Long val = (Long)matchRow.get("NO_OF_CLICKS");
                matchRow.set("NO_OF_CLICKS", (Object)new Long(val + 1L));
                this.dataObj.updateRow(matchRow);
                ++this.noOfClicks;
            }
            if (this.noOfClicks == 10) {
                this.update();
                this.noOfClicks = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void reset() {
        try {
            Iterator rows = this.dataObj.getRows("ADSMUrlClicks");
            while (rows.hasNext()) {
                Row r = (Row)rows.next();
                r.set("NO_OF_CLICKS", (Object)new Long(0L));
                this.dataObj.updateRow(r);
            }
            this.update();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void update() {
        try {
            CommonUtil.getPersistence(new boolean[0]).update(this.dataObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String getString() {
        StringBuffer buf = new StringBuffer();
        try {
            Long val;
            Integer featureId;
            Row r;
            Iterator rows = this.dataObj.getRows("ADSMUrlClicks");
            Hashtable<Integer, Long> hash = new Hashtable<Integer, Long>();
            while (rows.hasNext()) {
                r = (Row)rows.next();
                featureId = (Integer)r.get("FEATURE_ID");
                val = (Long)r.get("NO_OF_CLICKS");
                if (hash.get(featureId) != null) {
                    val = val + (Long)hash.get(featureId);
                }
                hash.put(featureId, val);
            }
            rows = this.dataObj.getRows("ADSMUrlClicks");
            while (rows.hasNext()) {
                r = (Row)rows.next();
                featureId = (Integer)r.get("FEATURE_ID");
                if (hash.get(featureId) == null) continue;
                val = (Long)hash.remove(featureId);
                String s = Long.toHexString(val);
                if (s.length() > 3) {
                    s = s.substring(0, 3);
                } else if (s.length() == 2) {
                    s = "0" + s;
                } else if (s.length() == 1) {
                    s = "00" + s;
                }
                buf.append(s);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.reset();
        return buf.toString();
    }

    private void getURLs() {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("ADSMUrlClicks"));
            Criteria criter = new Criteria(new Column("ADSMUrlClicks", "URL_STRING"), (Object)"", 1);
            query.setCriteria(criter);
            query.addSortColumn(new SortColumn("ADSMUrlClicks", "FEATURE_ID", true));
            query.addSelectColumn(new Column("ADSMUrlClicks", "URL_ID"));
            query.addSelectColumn(new Column("ADSMUrlClicks", "FEATURE_ID"));
            query.addSelectColumn(new Column("ADSMUrlClicks", "URL_STRING"));
            query.addSelectColumn(new Column("ADSMUrlClicks", "NO_OF_CLICKS"));
            this.dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

