/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.sym.adsm.common.server.admin.AgentSchedulerHandler;
import com.adventnet.sym.adsm.common.server.notifications.PolicyNotifications;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.start.util.SDInstallUtil;
import com.manageengine.ads.fw.api.RestAPIUtil;
import com.manageengine.ads.fw.util.CommonUtil;
import com.manageengine.ads.fw.util.jumpto.JumpToHandler;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class AdminHandler {
    public static final String HOST = "HOST";
    public static final String PORT = "PORT";
    public static final String PROTOCOL = "PROTOCOL";
    public static final String CONTEXT = "CONTEXT";
    private static Logger logger = Logger.getLogger(AdminHandler.class.getName());

    public static Properties getAddOnRow(String productName) {
        Properties p = null;
        try {
            JSONObject integratedProducts = JumpToHandler.getProductSettings((String)productName);
            Iterator it = integratedProducts.keys();
            while (it.hasNext()) {
                String key = (String)it.next();
                JSONObject settings = integratedProducts.getJSONObject(key);
                if (!settings.has("IS_INTEGRATED")) continue;
                p = new Properties();
                p.put(HOST, settings.getString(HOST));
                p.put(PORT, (Integer)settings.get(PORT));
                p.put(PROTOCOL, settings.getString(PROTOCOL));
                p.put("productName", settings.getString("PRODUCT_NAME"));
                p.put(CONTEXT, settings.getString(CONTEXT));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return p;
    }

    public static ArrayList getAddOnList(ArrayList productList) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        try {
            JSONObject integratedProducts = JumpToHandler.getProductSettingsWOP();
            Iterator it = integratedProducts.keys();
            while (it.hasNext()) {
                String productName;
                String key = (String)it.next();
                JSONObject settings = integratedProducts.getJSONObject(key);
                if (!settings.has("IS_INTEGRATED") || !productList.contains(productName = settings.getString("PRODUCT_NAME"))) continue;
                Properties p = new Properties();
                p.put(HOST, settings.getString(HOST));
                p.put(PORT, (Integer)settings.get(PORT));
                p.put(PROTOCOL, settings.getString(PROTOCOL));
                p.put("productName", productName);
                list.add(p);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static boolean deleteAddOnRow(String pdtName) {
        boolean deleted = false;
        try {
            if (!pdtName.equalsIgnoreCase("ManageEngine ServiceDesk Plus")) {
                JumpToHandler.removeSettings((String)pdtName);
            }
            deleted = true;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return deleted;
    }

    public static boolean addProductDetails(String productName, Properties prop) throws Exception {
        boolean status;
        block13: {
            status = false;
            try {
                Long productId;
                Long l = productId = productName != null ? CommonUtil.getProductId((String)productName) : null;
                if (productId == null) break block13;
                JSONObject productSettings = new JSONObject();
                productSettings.put("PRODUCT_ID", (Object)productId);
                productSettings.put(PROTOCOL, (Object)prop.getProperty(PROTOCOL));
                String prodprotocol = prop.getProperty(PROTOCOL);
                if (productName.equalsIgnoreCase("ManageEngine ADSelfService Plus") && prodprotocol.equalsIgnoreCase("http")) {
                    AgentSchedulerHandler.setWindowsLogonTFA("FALSE", "FALSE");
                }
                productSettings.put(HOST, (Object)prop.getProperty(HOST));
                productSettings.put(PORT, (Object)((Integer)prop.get(PORT)));
                if (prop.get(CONTEXT) != null) {
                    productSettings.put(CONTEXT, prop.get(CONTEXT));
                }
                productSettings.put("INTEGRATED_PRODUCT_NAME", (Object)CommonUtil.getProductName());
                Boolean isAccessUrl = (Boolean)(prop.containsKey("IS_ACCESS_URL") ? prop.get("IS_ACCESS_URL") : Boolean.valueOf(false));
                if (!"ManageEngine ADSelfService Plus".equalsIgnoreCase(productName) && !JumpToHandler.testConnection((JSONObject)productSettings, (boolean)false)) break block13;
                if (productName.equalsIgnoreCase("ManageEngine ServiceDesk Plus")) {
                    if (prop.getProperty("TECHNICIAN_KEY").equalsIgnoreCase("") || AdminHandler.testSDPConnection(productSettings, prop.getProperty("TECHNICIAN_KEY"))) {
                        JumpToHandler.removeSettings((String)productName);
                        JumpToHandler.addSettings((JSONObject)productSettings);
                        if (!prop.getProperty("TECHNICIAN_KEY").equalsIgnoreCase("")) {
                            CommonUtil.setProductParamValue((String)productId.toString(), (String)"TECHNICIAN_KEY", (String)prop.getProperty("TECHNICIAN_KEY"));
                        }
                        status = true;
                    } else {
                        status = false;
                    }
                    break block13;
                }
                JSONObject versionDetails = new JSONObject();
                try {
                    if (!isAccessUrl.booleanValue()) {
                        StringBuilder url = new StringBuilder(productSettings.getString(PROTOCOL)).append("://").append(productSettings.getString(HOST)).append(":").append(productSettings.getString(PORT)).append("/servlet/GetProductVersion");
                        versionDetails = new JSONObject(RestAPIUtil.getConnectionResult((String)url.toString(), (String)""));
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                if (isAccessUrl.booleanValue() || versionDetails.has("PRODUCT_NAME") && versionDetails.getString("PRODUCT_NAME").equalsIgnoreCase(productName)) {
                    JumpToHandler.updateSettings((JSONObject)productSettings);
                    com.adventnet.sym.adsm.common.server.util.CommonUtil.generateQrForSettingsConfiguration();
                    status = true;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getMessage().toLowerCase().contains("key_not_found")) {
                    throw new Exception(e.getMessage());
                }
                if (!e.getMessage().toLowerCase().contains("access_denied")) break block13;
                throw new Exception(e.getMessage());
            }
        }
        return status;
    }

    public static boolean testSDPConnection(JSONObject productSettings, String technicianKey) throws Exception {
        try {
            Properties prop = new Properties();
            String url = CommonUtil.constructURL((JSONObject)productSettings).toString();
            prop.setProperty("URLSTRING", url);
            prop.setProperty("TECHNICIAN_KEY", technicianKey);
            prop.setProperty("OPERATION_NAME", "GET_REQUESTS");
            prop.setProperty("mailText", "{\r\n    \"operation\": {\r\n        \"details\": {\r\n            \"from\": \"0\",\r\n            \"limit\": \"1\",\r\n            \"filterby\": \"All_Requests\"\r\n        }\r\n    }\r\n}");
            Properties resultProp = PolicyNotifications.callSDPAPI(prop);
            logger.log(Level.INFO, prop.toString());
            if (!resultProp.getProperty("MESSAGE").equalsIgnoreCase("failed") || !resultProp.getProperty("MESSAGE").equals("")) {
                String status = resultProp.getProperty("STATUS");
                if (status.equalsIgnoreCase("success")) {
                    String result = resultProp.getProperty("MESSAGE");
                    JSONObject jsonResult = new JSONObject(result);
                    if ((jsonResult = jsonResult.getJSONObject("operation").getJSONObject("result")).getString("status").equalsIgnoreCase("success")) {
                        return true;
                    }
                    throw new Exception(jsonResult.getString("message"));
                }
                return false;
            }
            return false;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getMessage().toLowerCase().contains("authentication failed")) {
                throw new Exception("adssp.admin.connection.api_key_not_found");
            }
            if (e.getMessage().contains("Technician does not have permissions to view requests")) {
                throw new Exception("adssp.admin.connection.api_key_access_denied");
            }
            return false;
        }
    }

    public static String getAccessURL() {
        String url = "";
        String host = "";
        String protocol = "";
        String context = "";
        Integer port = null;
        Properties accessURLProp = new Properties();
        AgentSchedulerUtil.getAccessURLProperties(accessURLProp);
        host = (String)accessURLProp.get("SERVER_NAME");
        port = (Integer)accessURLProp.get("PORT_NO");
        protocol = (String)accessURLProp.get(PROTOCOL);
        String string = context = accessURLProp.get(CONTEXT) != null ? (String)accessURLProp.get(CONTEXT) : "";
        if (context.equals("")) {
            String productInstallPath = System.getProperty("server.home");
            String webServerPortFile = productInstallPath + "\\conf\\server.xml";
            context = SDInstallUtil.getContextPathName((String)webServerPortFile);
        }
        context = context.trim();
        url = protocol + "://" + host + ":" + port;
        url = url + (context.length() != 0 ? (context.startsWith("/") ? "" : "/") + context : "");
        return url;
    }
}

