/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataAccessException;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.tfa.TFAHandler;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TabCustomization;
import com.manageengine.ads.fw.mail.MailHandler;
import com.manageengine.ads.fw.util.CommonUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class AdvancedPolicyHandler {
    public static final long RESET_PWD_MAIL_NOTIFICATION_ID = 1L;
    public static final long UNLOCK_ACC_MAIL_NOTIFICATION_ID = 2L;
    public static final long CHANGE_PWD_MAIL_NOTIFICATION_ID = 3L;
    public static final long VC_EMAIL_NOTIFICATION_ID = 4L;
    public static final long VC_MOBILE_NOTIFICATION_ID = 5L;
    public static final long RESET_PWD_SMS_NOTIFICATION_ID = 6L;
    public static final long UNLOCK_ACC_SMS_NOTIFICATION_ID = 7L;
    public static final long CHANGE_PWD_SMS_NOTIFICATION_ID = 8L;
    public static final long RESET_PWD_PUSH_NOTIFICATION_ID = 10L;
    public static final long UNLOCK_PUSH_NOTIFICATION_ID = 11L;
    public static final long CHANGE_PWD_PUSH_NOTIFICATION_ID = 12L;
    public static final long ADMIN_NOTIFICATION_ID = 9L;
    public static final long RESET_OPERATION_ID = 1L;
    public static final long UNLOCK_OPERATION_ID = 2L;
    public static final long ENROLLMENT_MAIL_NOTIFICATION_ID = 13L;
    public static final long ENROLLMENT_SMS_NOTIFICATION_ID = 14L;
    public static final long SELF_UPDATE_MAIL_NOTIFICATION_ID = 15L;
    public static final long SELF_UPDATE_SMS_NOTIFICATION_ID = 16L;
    public static final long BLOCKED_USER_MAIL_NOTIFICATION_ID = 17L;
    public static final long BLOCKED_USER_SMS_NOTIFICATION_ID = 18L;
    public static final long ENROLLMENT_PUSH_NOTIFICATION_ID = 19L;
    public static final long BLOCKED_USER_PUSH_NOTIFICATION_ID = 20L;
    public static final long TICKET_GENERATION_ID = 21L;
    public static final long TFA_EMAIL_VERIFICATION_CODE_ID = 22L;
    public static final long TFA_SMS_VERIFICATION_CODE_ID = 23L;
    public static final String[] DIRECT_MAPPING_TABLES = new String[]{"SSPSecurity", "SSPBlocking", "SSPPolicyGeneral"};
    public static final String[] OTHAR_TABLES = new String[]{"PolicyConfiguration", "PolicyNotifications", "SSPCustomScript", "SSPPasswordPolicy", "SSPPolicyDetails", "SSPPolicies", "SSPTabSettings"};
    public static String[] hours = new String[]{"00:00", "01:00", "02:00", "03:00", "04:00", "05:00", "06:00", "07:00", "08:00", "09:00", "10:00", "11:00", "12:00", "13:00", "14:00", "15:00", "16:00", "17:00", "18:00", "19:00", "20:00", "21:00", "22:00", "23:00"};
    public static Long[] hourValues = new Long[]{0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L};
    public static String[] days = new String[]{"adssp.admin.common.text.sunday", "adssp.admin.common.text.monday", "adssp.admin.common.text.tuesday", "adssp.admin.common.text.wednesday", "adssp.admin.common.text.thursday", "adssp.admin.common.text.friday", "adssp.admin.common.text.saturday"};
    public static Integer[] dayValues = new Integer[]{1, 2, 3, 4, 5, 6, 7};
    public static String[] date = new String[]{"01", "02", "03", "04", "05", "06", "07", "08", "09", "10", "11", "12", "13", "14", "15", "16", "17", "18", "19", "20", "21", "22", "23", "24", "25", "26", "27", "28", "29", "30", "31"};
    public static Integer[] dateValues = new Integer[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18, 19, 20, 21, 22, 23, 24, 25, 26, 27, 28, 29, 30, 31};
    public static String[] pwdPolLevels = new String[]{"Custom", "Strong", "Good", "Weak", "Too Short"};
    public static String policyMailNotify = "{1: adssp.reports.audit_report.notification_delivery_report.reset_password_notificaiton,2:adssp.reports.audit_report.notification_delivery_report.unlock_account_notificaiton,3:adssp.reports.audit_report.notification_delivery_report.change_password_notificaiton,4:adssp.reports.audit_report.notification_delivery_report.verification_code_notificaiton,9:adssp.reports.audit_report.notification_delivery_report.mail_to_admin,13:adssp.reports.audit_report.notification_delivery_report.enrollment_ack_notification,15:adssp.reports.audit_report.notification_delivery_report.self_update_ack_notification,17:adssp.reports.audit_report.notification_delivery_report.block_user_notification,21:adssp.reports.audit_report.notification_delivery_report.sdp_ticket}";
    public static String policySMSNotify = "{5: adssp.reports.audit_report.notification_delivery_report.verification_code_notificaiton,6: adssp.reports.audit_report.notification_delivery_report.reset_password_notificaiton, 7:adssp.reports.audit_report.notification_delivery_report.unlock_account_notificaiton, 8:adssp.reports.audit_report.notification_delivery_report.change_password_notificaiton,14:adssp.reports.audit_report.notification_delivery_report.enrollment_ack_notification,16:adssp.reports.audit_report.notification_delivery_report.self_update_ack_notification,18:adssp.reports.audit_report.notification_delivery_report.block_user_notification}";
    static Long[] operationIds = new Long[]{1L, 2L};
    public static String policyPNNotify = "{10: adssp.reports.audit_report.notification_delivery_report.reset_password_notificaiton, 11:adssp.reports.audit_report.notification_delivery_report.unlock_account_notificaiton, 12:adssp.reports.audit_report.notification_delivery_report.change_password_notificaiton,19:adssp.reports.audit_report.notification_delivery_report.enrollment_ack_notification,20:adssp.reports.audit_report.notification_delivery_report.block_user_notification}";

    public static void addAPCRows(Long policyId) {
        try {
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            Row sspSecRow = new Row("SSPSecurity");
            sspSecRow.set("POLICY_ID", (Object)policyId);
            sspSecRow.set("SESSION_EXPIRY_TIME", (Object)new Long(5L));
            dataObject.addRow(sspSecRow);
            Row sspBlockRow = new Row("SSPBlocking");
            sspBlockRow.set("POLICY_ID", (Object)policyId);
            sspBlockRow.set("MAX_ATTEMPTS", (Object)5);
            sspBlockRow.set("RESET_ATTEMPTS", (Object)30);
            sspBlockRow.set("BLOCKING_DURATION", (Object)30);
            dataObject.addRow(sspBlockRow);
            Long[] notificationIds = new Long[]{1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 21L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L};
            String[] notificationType = new String[]{"Reset Password", "Unlock Account", "Change Password", "VERIFICATION_CODE_MAIL", "VERIFICATION_CODE_MOBILE", "Reset Password", "Unlock Account", "Change Password", "Admin Notification", "Ticket Generation", "Reset Password", "Unlock Account", "Change Password", "Enrollment Acknowledgement", "Enrollment Acknowledgement", "Self Update", "Self Update", "Blocked User", "Blocked User", "Enrollment Acknowledgement", "Blocked User"};
            String[] subject = new String[]{"adssp.admin.policies.policy_config.apc_notify_rp_subject", "adssp.admin.policies.policy_config.apc_notify_ua_subject", "adssp.admin.policies.policy_config.apc_notify_cp_subject", "adssp.admin.policies.policy_config.apc_notify_rp_verify_code_subject", "adssp.admin.policies.policy_config.apc_notify_rp_verify_code_subject", "adssp.admin.policies.policy_config.apc_notify_rp_subject", "adssp.admin.policies.policy_config.apc_notify_ua_subject", "adssp.admin.policies.policy_config.apc_notify_cp_subject", "adssp.admin.policies.policy_config.apc_notify_admin_subject", "Ticket Subject", "adssp.admin.policies.policy_config.apc_notify_rp_subject", "adssp.admin.policies.policy_config.apc_notify_ua_subject", "adssp.admin.policies.policy_config.apc_notify_cp_subject", "adssp.reports.filter.enrollment_notification_ack", "adssp.admin.policies.policy_config.aidv_enr_mob_sub", "adssp.reports.audit_report.notification_delivery_report.self_update_ack_notification", "adssp.reports.audit_report.notification_delivery_report.self_update_ack_notification", "adssp.reports.audit_report.notification_delivery_report.block_user_notification", "adssp.reports.audit_report.notification_delivery_report.block_user_notification", "adssp.reports.filter.enrollment_notification_ack", "adssp.reports.audit_report.notification_delivery_report.block_user_notification"};
            String[] mailContent = new String[]{"adssp.admin.policies.policy_config.apc_notify_rp_body", "adssp.admin.policies.policy_config.apc_notify_ua_body", "adssp.admin.policies.policy_config.apc_notify_cp_body", "adssp.admin.policies.policy_config.apc_notify_rp_mail_verify_code_body", "adssp.admin.policies.policy_config.apc_notify_rp_sms_verify_code_body", "adssp.admin.policies.policy_config.apc_sms_notify_rp_body", "adssp.admin.policies.policy_config.apc_sms_notify_ua_body", "adssp.admin.policies.policy_config.apc_sms_notify_cp_body", "adssp.admin.policies.policy_config.apc_notify_admin_body_new", "{\r\n\"operation\": {\r\n\"details\": {\r\n\"requester\": \"%displayName%\",\r\n\"subject\": \"%action%\",\r\n\"description\": \"%action%\", \r\n\"technician\": \"ADSSP Technician\",\r\n\"status\": \"open\"\r\n}\r\n}\r\n}", "adssp.admin.policies.policy_config.apc_sms_notify_rp_body", "adssp.admin.policies.policy_config.apc_sms_notify_ua_body", "adssp.admin.policies.policy_config.apc_sms_notify_cp_body", "adssp.admin.policies.policy_config.aidv_enr_cont", "adssp.admin.policies.policy_config.aidv_enr_mob_cont", "adssp.admin.policies.policy_config.aidv_self_update_content", "adssp.admin.policies.policy_config.aidv_self_update_content_sms", "adssp.admin.policies.policy_config.aidv_user_blcoked_content", "adssp.admin.policies.policy_config.aidv_user_blcoked_content_sms", "adssp.admin.policies.policy_config.aidv_enr_mob_cont", "adssp.admin.policies.policy_config.aidv_user_blcoked_content_sms"};
            String[] sendVia = new String[]{"MAIL", "MAIL", "MAIL", "MAIL", "SMS", "SMS", "SMS", "SMS", "MAIL", "MAIL", "PushNotification", "PushNotification", "PushNotification", "MAIL", "SMS", "MAIL", "SMS", "MAIL", "SMS", "PushNotification", "PushNotification"};
            for (int i = 0; i < notificationIds.length; ++i) {
                Row polNotificationRow = new Row("PolicyNotifications");
                polNotificationRow.set("POLICY_ID", (Object)policyId);
                polNotificationRow.set("NOTIFICATION_ID", (Object)notificationIds[i]);
                polNotificationRow.set("NOTIFICATION_TYPE", (Object)notificationType[i]);
                polNotificationRow.set("SUBJECT", (Object)subject[i]);
                polNotificationRow.set("MAIL_CONTENT", (Object)mailContent[i]);
                polNotificationRow.set("SEND_VIA", (Object)sendVia[i]);
                polNotificationRow.set("ENABLED", (Object)new Long(0L));
                dataObject.addRow(polNotificationRow);
            }
            Row row = new Row("SSPPolicies");
            row.set("POLICYCONFIG_ID", (Object)policyId);
            row.set("POLICY_ID", (Object)SchedulerHandler.RESET_TASK_ID);
            row.set("POLICY_NAME", (Object)"Reset Password Policy");
            dataObject.addRow(row);
            row = new Row("SSPPolicies");
            row.set("POLICYCONFIG_ID", (Object)policyId);
            row.set("POLICY_ID", (Object)SchedulerHandler.UNLOCK_TASK_ID);
            row.set("POLICY_NAME", (Object)"UnLockOut Policy");
            dataObject.addRow(row);
            row = new Row("SSPPolicyDetails");
            row.set("POLICYCONFIG_ID", (Object)policyId);
            row.set("POLICY_ID", (Object)SchedulerHandler.RESET_TASK_ID);
            row.set("PROPERTY_NAME", (Object)"pwdValue");
            row.set("PROPERTY_VALUE", (Object)"%logonName%");
            dataObject.addRow(row);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPQASettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPQASettings", crit);
            if (obj.isEmpty()) {
                Row sspQARow = new Row("SSPQASettings");
                sspQARow.set("POLICY_ID", (Object)policyId);
                dataObject.addRow(sspQARow);
            }
            PolicyHandler.addQuestionDetails(policyId);
            for (int i = 0; i < operationIds.length; ++i) {
                Row sspCustomRow = new Row("SSPCustomScript");
                sspCustomRow.set("POLICY_ID", (Object)policyId);
                sspCustomRow.set("OPERATION_ID", (Object)operationIds[i]);
                dataObject.addRow(sspCustomRow);
            }
            AdvancedPolicyHandler.createPwdPolicyRows(policyId, dataObject);
            Row sspPolGenRow = new Row("SSPPolicyGeneral");
            sspPolGenRow.set("POLICY_ID", (Object)policyId);
            sspPolGenRow.set("PWD_SYNC_ON_SUCCESS", (Object)"1");
            dataObject.addRow(sspPolGenRow);
            JSONObject tabDetails = TabCustomization.getDUTabs();
            Iterator keys = tabDetails.keys();
            while (keys.hasNext()) {
                JSONObject json = (JSONObject)tabDetails.get((String)keys.next());
                Long priority = (Long)json.get("PRIORITY");
                Long tabId = (Long)json.get("TAB_ID");
                if (TabCustomization.PERSONALIZE_TAB_ID.equals(tabId) || TabCustomization.UNAVAILABLE_TAB_ID.equals(tabId)) continue;
                Row sspTabs = new Row("SSPTabSettings");
                sspTabs.set("POLICY_ID", (Object)policyId);
                sspTabs.set("TAB_ID", (Object)tabId);
                sspTabs.set("TAB_DISPLAY_NAME", (Object)((String)json.get("TAB_DISPLAY_NAME")));
                sspTabs.set("PRIORITY", (Object)priority);
                sspTabs.set("IS_DEFAULT", (Object)(priority.equals(1L) ? 1 : 0));
                dataObject.addRow(sspTabs);
            }
            CommonUtil.getPersistenceLite().add(dataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        APCModuleHandler.addRows(policyId);
    }

    public static void createPwdPolicyRows(Long policyId, DataObject dataObject) {
        try {
            String[][] policyPropsValues = new String[][]{{"Strong", "8", "2", "1", "1", "1", "1", "1"}, {"Good", "6", "1", "1", "1", "1", "1"}, {"Weak", "5"}, {"Too Short", "4"}, {"Custom", "8", "2", "1", "1", "1", "1", "1", "-1", "1", "qwerty,asdf,1234"}};
            String[] policyProps = new String[]{"LEVEL_NAME", "MIN_LEN", "NO_OF_SPL_CHARS", "MIXED_CASE", "NUMERAL_REQ", "PREVENT_REPEATED_CHARS", "PALINDROME_REQ", "PREVENT_CHARS_FRM_NAME", "MAX_LEN", "START_WITH_ALPHA", "EXCLUDED_WORDS"};
            Row sspPwdPolRow = new Row();
            for (int i = 0; i < policyPropsValues.length; ++i) {
                sspPwdPolRow = new Row("SSPPasswordPolicy");
                sspPwdPolRow.set("POLICY_ID", (Object)policyId);
                for (int j = 0; j < policyPropsValues[i].length; ++j) {
                    String columnType = sspPwdPolRow.getColumnType(policyProps[j]);
                    Object columnValue = MetaDataUtil.convert((String)policyPropsValues[i][j], (String)columnType);
                    sspPwdPolRow.set(policyProps[j], columnValue);
                }
                dataObject.addRow(sspPwdPolRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getAPCDetails(Long policyId, HttpServletRequest request) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        ArrayList<String> list = new ArrayList<String>();
        JSONObject jsonObject = new JSONObject();
        ArrayList<String> tableNames = new ArrayList<String>();
        tableNames.addAll(Arrays.asList(DIRECT_MAPPING_TABLES));
        tableNames.addAll(Arrays.asList(OTHAR_TABLES));
        ArrayList<String> arrayList = new ArrayList<String>();
        arrayList.add("SSPTabSettings");
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableNames, arrayList, crit);
            if (!dataObject.isEmpty()) {
                List columnList;
                for (int i = 0; i < DIRECT_MAPPING_TABLES.length; ++i) {
                    Row r = dataObject.getFirstRow(DIRECT_MAPPING_TABLES[i]);
                    if (r == null) continue;
                    columnList = r.getColumns();
                    for (int j = 0; j < columnList.size(); ++j) {
                        String column = (String)columnList.get(j);
                        jsonObject.put(column, r.get(column));
                    }
                }
                Iterator it = dataObject.getRows("PolicyNotifications");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    columnList = row.getColumns();
                    Long nId = (Long)row.get("NOTIFICATION_ID");
                    if (nId.equals(4L) || nId.equals(5L)) continue;
                    for (int j = 0; j < columnList.size(); ++j) {
                        String column = (String)columnList.get(j);
                        jsonObject.put(column + "_" + nId, (Object)rb.getString(row.get(column) != null ? row.get(column).toString() : ""));
                    }
                }
                if (!jsonObject.has("NOTIFICATION_ID_9")) {
                    AdvancedPolicyHandler.addAdminNotificationDetails(policyId, jsonObject, request);
                }
                JSONObject adsMailProp = MailHandler.getMailSettings();
                if (((String)jsonObject.get("MAIL_ID_9")).equals("") && adsMailProp.has("ADMIN_MAIL_ID") && adsMailProp.get("ADMIN_MAIL_ID") != null) {
                    jsonObject.put("MAIL_ID_9", adsMailProp.get("ADMIN_MAIL_ID"));
                }
                for (int i = 0; i < operationIds.length; ++i) {
                    Criteria cri = new Criteria(Column.getColumn((String)"SSPCustomScript", (String)"OPERATION_ID"), (Object)operationIds[i], 0);
                    Row row = dataObject.getRow("SSPCustomScript", cri);
                    String isEnabled = "0";
                    String script = "";
                    if (row != null) {
                        isEnabled = (String)row.get("IS_ENABLED");
                        script = row.get("SCRIPT_COMMAND") != null ? (String)row.get("SCRIPT_COMMAND") : script;
                    }
                    jsonObject.put("IS_CUSTOM_SCRIPT_ENABLED_" + operationIds[i], (Object)isEnabled);
                    jsonObject.put("SCRIPT_COMMAND_" + operationIds[i], (Object)script);
                }
                Iterator iterator = dataObject.getRows("SSPPolicies");
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    Long policyConfigId = (Long)row.get("POLICY_ID");
                    String jsonKey = policyConfigId.equals(SchedulerHandler.UNLOCK_TASK_ID) ? "AUTOMATIC_UNLOCK" : "AUTOMATIC_RESET";
                    Boolean isAutomaticSet = ((String)row.get("AUTOMATIC")).equals("1") || ((String)row.get("AUTOMATIC")).equals("true");
                    jsonObject.put(jsonKey, (Object)isAutomaticSet);
                    if (!isAutomaticSet.booleanValue()) continue;
                    SchedulerHandler.getInstance();
                    SchedulerHandler.fillSchedulerPolicy(policyId, policyConfigId, jsonObject);
                }
                Row sspPolDetailsRow = dataObject.getFirstRow("SSPPolicyDetails");
                if (sspPolDetailsRow != null) {
                    String pwdValue = (String)sspPolDetailsRow.get("PROPERTY_VALUE");
                    String propName = (String)sspPolDetailsRow.get("PROPERTY_NAME");
                    if (propName.equals("pwdValue") && (pwdValue == null || pwdValue.equals(""))) {
                        pwdValue = "%logonName%";
                    }
                    jsonObject.put("PWD_TYPE", (Object)propName);
                    jsonObject.put("PWD_VALUE", (Object)pwdValue);
                }
                jsonObject.put("TAB_DETAILS", (Object)TabCustomization.getTabDetails(policyId, request));
                jsonObject.put("tfaProps", (Object)TFAHandler.getTFAProps(policyId));
                jsonObject.put("policyLDAPCriteria", (Collection)AdvancedPolicyHandler.getPolicyLDAPCriteria(policyId));
                AdvancedPolicyHandler.getPasswordPolicy(policyId, jsonObject);
                list.add(jsonObject.toString());
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    private static void addAdminNotificationDetails(Long policyId, JSONObject jsonObject, HttpServletRequest request) {
        String tableName = "PolicyNotifications";
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
        try {
            Criteria crit = null;
            DataObject object = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            Row polNotificationRow = new Row(tableName);
            polNotificationRow.set("POLICY_ID", (Object)policyId);
            polNotificationRow.set("NOTIFICATION_ID", (Object)9L);
            polNotificationRow.set("NOTIFICATION_TYPE", (Object)"Admin Notification");
            polNotificationRow.set("SUBJECT", (Object)"adssp.admin.policies.policy_config.apc_notify_admin_subject");
            polNotificationRow.set("MAIL_CONTENT", (Object)"adssp.admin.policies.policy_config.apc_notify_admin_body");
            polNotificationRow.set("SEND_VIA", (Object)"MAIL");
            polNotificationRow.set("ENABLED", (Object)new Long(0L));
            object.addRow(polNotificationRow);
            CommonUtil.getPersistence((boolean[])new boolean[0]).update(object);
            jsonObject.put("SUBJECT_9", (Object)rb.getString("adssp.admin.policies.policy_config.apc_notify_admin_subject"));
            jsonObject.put("MAIL_CONTENT_9", (Object)rb.getString("adssp.admin.policies.policy_config.apc_notify_admin_body"));
            jsonObject.put("ENABLED_9", 0);
            jsonObject.put("MAIL_ID_9", (Object)"");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject setAPCDetails(HttpServletRequest request) {
        JSONObject status = new JSONObject();
        try {
            int i;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            Long policyId = Long.parseLong(request.getParameter("policyId"));
            String PolicyCriteria = request.getParameter("conditions");
            PolicyCriteria = StrUtil.decodeURIComponent(PolicyCriteria);
            JSONObject PoLDAPCriteria = new JSONObject(PolicyCriteria);
            AdvancedPolicyHandler.setPolicyLDAPCriteria(PoLDAPCriteria, policyId);
            ArrayList<String> tableNames = new ArrayList<String>();
            tableNames.addAll(Arrays.asList(DIRECT_MAPPING_TABLES));
            tableNames.addAll(Arrays.asList(OTHAR_TABLES));
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("SSPTabSettings");
            Boolean isTFASaveSuccess = TFAHandler.saveTFASettings(request);
            if (!isTFASaveSuccess.booleanValue()) {
                status.put("statusType", (Object)"Failure");
                status.put("statusMessage", (Object)rb.getString((String)request.getAttribute("message")));
                return status;
            }
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableNames, arrayList, crit);
            for (int i2 = 0; i2 < DIRECT_MAPPING_TABLES.length; ++i2) {
                Row r = dataObject.getFirstRow(DIRECT_MAPPING_TABLES[i2]);
                if (r == null) continue;
                List columnList = r.getColumns();
                for (int j = 1; j < columnList.size(); ++j) {
                    String column = (String)columnList.get(j);
                    String value = request.getParameter(column);
                    if (value == null) continue;
                    String columnType = r.getColumnType(column);
                    Object columnValue = MetaDataUtil.convert((String)value, (String)columnType);
                    r.set(column, columnValue);
                }
                dataObject.updateRow(r);
            }
            Iterator it = dataObject.getRows("PolicyNotifications");
            while (it.hasNext()) {
                Row row = (Row)it.next();
                if (row == null) continue;
                Long nId = (Long)row.get("NOTIFICATION_ID");
                if (!nId.equals(4L) && !nId.equals(5L)) {
                    List columnList = row.getColumns();
                    for (int j = 0; j < columnList.size(); ++j) {
                        String column = (String)columnList.get(j);
                        String value = request.getParameter(column + "_" + nId);
                        if (value == null) continue;
                        String columnType = row.getColumnType(column);
                        Object columnValue = MetaDataUtil.convert((String)value, (String)columnType);
                        row.set(column, columnValue);
                    }
                }
                dataObject.updateRow(row);
            }
            String tabDetails = request.getParameter("TAB_DETAILS");
            tabDetails = tabDetails.replaceAll("&quot;", "\"");
            JSONObject json = new JSONObject(tabDetails);
            JSONObject tabProp = TabCustomization.getDUTabs();
            for (i = 1; i <= json.length(); ++i) {
                JSONObject jsonObject = (JSONObject)json.get(String.valueOf(i));
                Long tabId = Long.parseLong((String)jsonObject.get("TAB_ID"));
                Long isDefault = Long.parseLong((String)jsonObject.get("IS_DEFAULT"));
                Criteria cri = new Criteria(Column.getColumn((String)"SSPTabSettings", (String)"TAB_ID"), (Object)tabId, 0);
                Row row = dataObject.getRow("SSPTabSettings", cri);
                if (row != null) {
                    row.set("PRIORITY", (Object)new Long(i));
                    row.set("IS_DEFAULT", (Object)isDefault);
                    dataObject.updateRow(row);
                    continue;
                }
                row = new Row("SSPTabSettings");
                row.set("POLICY_ID", (Object)policyId);
                row.set("TAB_ID", (Object)tabId);
                row.set("PRIORITY", (Object)new Long(i));
                row.set("IS_DEFAULT", (Object)isDefault);
                row.set("TAB_DISPLAY_NAME", (Object)((String)((JSONObject)tabProp.get(Long.toString(tabId))).get("TAB_DISPLAY_NAME")));
                dataObject.addRow(row);
            }
            for (i = 0; i < operationIds.length; ++i) {
                Criteria cri = new Criteria(Column.getColumn((String)"SSPCustomScript", (String)"OPERATION_ID"), (Object)operationIds[i], 0);
                Row row = dataObject.getRow("SSPCustomScript", cri);
                if (row == null) {
                    row = new Row("SSPCustomScript");
                    row.set("POLICY_ID", (Object)policyId);
                    row.set("OPERATION_ID", (Object)operationIds[i]);
                    dataObject.addRow(row);
                }
                row.set("IS_ENABLED", MetaDataUtil.convert((String)request.getParameter("IS_CUSTOM_SCRIPT_ENABLED_" + operationIds[i]), (String)row.getColumnType("IS_ENABLED")));
                String scriptCommand = request.getParameter("SCRIPT_COMMAND_" + operationIds[i]);
                row.set("SCRIPT_COMMAND", (Object)(scriptCommand == null ? "" : StrUtil.decodeURIComponent(scriptCommand)));
                dataObject.updateRow(row);
            }
            String[] auto = new String[]{"AUTOMATIC_", "SCHEDULE_", "TIME_OF_DAY_", "DAY_OF_WEEK_", "DATE_OF_MONTH_", "MINS_OF_HOUR_"};
            String autoRP = request.getParameter(auto[0] + "RESET");
            String autoUA = request.getParameter(auto[0] + "UNLOCK");
            AdvancedPolicyHandler.setAutomaticVals(autoRP, autoUA, policyId);
            if (autoRP.equals("1")) {
                String pwdProp = request.getParameter("PWD_TYPE");
                crit = new Criteria(Column.getColumn((String)"SSPPolicyDetails", (String)"POLICYCONFIG_ID"), (Object)policyId, 0);
                Row r4 = dataObject.getRow("SSPPolicyDetails", crit);
                if (pwdProp.equalsIgnoreCase("customPwd")) {
                    r4.set("PROPERTY_VALUE", (Object)"");
                } else {
                    String pwdValue = request.getParameter("PWD_VALUE");
                    r4.set("PROPERTY_VALUE", (Object)pwdValue);
                }
                r4.set("PROPERTY_NAME", (Object)pwdProp);
                dataObject.updateRow(r4);
                Hashtable<String, String> scheduleProps = new Hashtable<String, String>();
                String schType = request.getParameter(auto[1] + "RESET");
                scheduleProps.put(auto[1] + "RESET", schType);
                String timeOfDay = request.getParameter(auto[2] + "RESET");
                scheduleProps.put(auto[2] + "RESET", timeOfDay);
                String minOfHours = request.getParameter(auto[5] + "RESET");
                scheduleProps.put(auto[5] + "RESET", minOfHours);
                if (schType.indexOf("weekly") != -1) {
                    scheduleProps.put(auto[3] + "RESET", request.getParameter(auto[3] + "RESET"));
                } else if (schType.indexOf("monthly") != -1) {
                    scheduleProps.put(auto[4] + "RESET", request.getParameter(auto[4] + "RESET"));
                }
                SchedulerHandler.getInstance().updatePolicyScheduler(scheduleProps, policyId, SchedulerHandler.RESET_TASK_ID, request);
            } else {
                SchedulerHandler.getInstance().deletePolicyScheduler(policyId, SchedulerHandler.RESET_TASK_ID);
            }
            if (autoUA.equals("1")) {
                Hashtable<String, String> scheduleProps = new Hashtable<String, String>();
                String schType = request.getParameter(auto[1] + "UNLOCK");
                scheduleProps.put(auto[1] + "UNLOCK", schType);
                String timeOfDay = request.getParameter(auto[2] + "UNLOCK");
                scheduleProps.put(auto[2] + "UNLOCK", timeOfDay);
                String minOfHours = request.getParameter(auto[5] + "UNLOCK");
                scheduleProps.put(auto[5] + "UNLOCK", minOfHours);
                if (schType.indexOf("weekly") != -1) {
                    scheduleProps.put(auto[3] + "UNLOCK", request.getParameter(auto[3] + "UNLOCK"));
                } else if (schType.indexOf("monthly") != -1) {
                    scheduleProps.put(auto[4] + "UNLOCK", request.getParameter(auto[4] + "UNLOCK"));
                }
                SchedulerHandler.getInstance().updatePolicyScheduler(scheduleProps, policyId, SchedulerHandler.UNLOCK_TASK_ID, request);
            } else {
                SchedulerHandler.getInstance().deletePolicyScheduler(policyId, SchedulerHandler.UNLOCK_TASK_ID);
            }
            CommonUtil.getPersistenceLite().update(dataObject);
            status.put("statusType", (Object)"Success");
            status.put("statusMessage", (Object)"Success");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static void disableSDPTicket() throws DataAccessException {
        UpdateQueryImpl s = new UpdateQueryImpl("PolicyNotifications");
        Criteria c = new Criteria(Column.getColumn((String)"PolicyNotifications", (String)"NOTIFICATION_ID"), (Object)21L, 0);
        s.setCriteria(c);
        s.setUpdateColumn("ENABLED", (Object)0);
        CommonUtil.getPersistenceLite().update((UpdateQuery)s);
        CommonUtil.removeProductParam((Long)CommonUtil.getProductId((String)"ManageEngine ServiceDesk Plus"), (String)"TECHNICIAN_KEY");
    }

    public static void setAutomaticVals(String reset, String unlock, Long policyConfigId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPPolicies", (String)"POLICYCONFIG_ID"), (Object)policyConfigId, 0);
            DataObject dataObject = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPPolicies", c);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("SSPPolicies");
                while (it.hasNext()) {
                    Object columnValue;
                    Row r = (Row)it.next();
                    String columnType = r.getColumnType("AUTOMATIC");
                    if (((Long)r.get("POLICY_ID")).equals(SchedulerHandler.UNLOCK_TASK_ID)) {
                        columnValue = MetaDataUtil.convert((String)unlock, (String)columnType);
                        r.set("AUTOMATIC", columnValue);
                    } else if (((Long)r.get("POLICY_ID")).equals(SchedulerHandler.RESET_TASK_ID)) {
                        columnValue = MetaDataUtil.convert((String)reset, (String)columnType);
                        r.set("AUTOMATIC", columnValue);
                    }
                    dataObject.updateRow(r);
                }
                CommonUtil.getPersistence((boolean[])new boolean[0]).update(dataObject);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public static String getPasswordPolicy(Long policyId, JSONObject pwdPolicy) {
        String forcedLevel = "Strong";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPasswordPolicy", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPPasswordPolicy", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPPasswordPolicy");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    if (row == null) continue;
                    List columnList = row.getColumns();
                    String lN = (String)row.get("LEVEL_NAME");
                    for (int j = 0; j < columnList.size(); ++j) {
                        String column = (String)columnList.get(j);
                        String value = row.get(column) != null ? row.get(column).toString() : "";
                        pwdPolicy.put(column + "_" + lN, (Object)value);
                        if (!column.equals("FORCE_LEVEL") || value.equals("0") || value.equals("000")) continue;
                        forcedLevel = lN;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return forcedLevel;
    }

    public static String getRequiredPCValue(Long policyId, String columnName, String tableName) {
        String ret = "";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow(tableName);
                ret = r.get(columnName).toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Hashtable getCustomScriptValues(Long policyId, Long operationId) {
        Hashtable<String, Object> ret = new Hashtable<String, Object>();
        try {
            String tableName = "SSPCustomScript";
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"OPERATION_ID"), (Object)operationId, 0));
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow(tableName);
                String script = (String)r.get("SCRIPT_COMMAND");
                ret.put("isEnabled", r.get("IS_ENABLED"));
                ret.put("scriptCommand", script != null ? script : "");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static void setPolicyLDAPCriteria(JSONObject rules, Long policyID) {
        try {
            JSONArray conditionsArr = (JSONArray)rules.get("conditions");
            AdvancedPolicyHandler.deletePolicyLDAPAttributes(policyID);
            DataObject ruleObj = CommonUtil.getPersistence((boolean[])new boolean[0]).constructDataObject();
            for (int i = 0; i < conditionsArr.length(); ++i) {
                JSONObject condition = conditionsArr.getJSONObject(i);
                if (!condition.has("ATTRIB_ACTION_ID")) continue;
                Row condRow = new Row("SSPPolicyLDAPCriteria");
                condRow.set("ATTRIB_LDAP_NAME", (Object)((String)condition.get("ATTRIB_ACTION_ID")));
                condRow.set("RELATIONAL_OPERATOR", (Object)((String)condition.get("RELATIONAL_OPERATOR")));
                condRow.set("ATTRIB_VALUE", (Object)((String)condition.get("ATTRIB_ACTION_VALUE")));
                condRow.set("LOGICAL_OPERATOR", (Object)((String)condition.get("LOGICAL_OPERATOR")));
                condRow.set("ORDER_ID", (Object)condition.getLong("ORDER_ID"));
                condRow.set("POLICY_ID", (Object)condition.getLong("POLICY_ID"));
                ruleObj.addRow(condRow);
            }
            CommonUtil.getPersistenceLite().update(ruleObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deletePolicyLDAPAttributes(long policyid) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPolicyLDAPCriteria", (String)"POLICY_ID"), (Object)policyid, 0);
            CommonUtil.getPersistence((boolean[])new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getPolicyLDAPCriteria(Long policyID) {
        ArrayList<JSONObject> conditionsList = new ArrayList<JSONObject>();
        try {
            Criteria condcrit = new Criteria(Column.getColumn((String)"SSPPolicyLDAPCriteria", (String)"POLICY_ID"), (Object)policyID, 0);
            DataObject obj = CommonUtil.getPersistence((boolean[])new boolean[0]).get("SSPPolicyLDAPCriteria", condcrit);
            Iterator conditionItr = obj.getRows("SSPPolicyLDAPCriteria");
            while (conditionItr.hasNext()) {
                JSONObject condition = new JSONObject();
                Row r = (Row)conditionItr.next();
                condition.put("CONDITION_ID", (Object)((Long)r.get("CONDITION_ID")));
                condition.put("ATTRIB_ACTION_ID", (Object)((String)r.get("ATTRIB_LDAP_NAME")));
                condition.put("RELATIONAL_OPERATOR", (Object)((String)r.get("RELATIONAL_OPERATOR")));
                condition.put("ATTRIB_ACTION_VALUE", (Object)((String)r.get("ATTRIB_VALUE")));
                condition.put("LOGICAL_OPERATOR", (Object)((String)r.get("LOGICAL_OPERATOR")));
                condition.put("ORDER_ID", (Object)((Long)r.get("ORDER_ID")));
                condition.put("POLICY_ID", (Object)((Long)r.get("POLICY_ID")));
                conditionsList.add(condition);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return conditionsList;
    }
}

