/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.util.AgentSchedulerUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.struts.validator.DynaValidatorForm;

public class AgentSchedulerHandler {
    private static Logger logger = Logger.getLogger(AgentSchedulerHandler.class.getName());
    public static final String INSTALL_GINA_TASK = new String("adssp.xml.taskflow.gina_installation");
    public static final String CUSTOM_GINA_TASK = new String("adssp.xml.taskflow.gina_cusotmization");
    public static final String REM_ENROL_TASK = new String("adssp.xml.taskflow.enrollment_reminder");
    public static String[] ginacustomOptions = new String[]{"AGENT_ID", "FRAME_TEXT", "BUTTON_TEXT", "ICON", "SHOW_ADSSP_TILE", "SHOW_ADSSP_LINK"};

    public static Properties updateCustomTexts(DynaValidatorForm bean, String path) {
        Properties returnProps = new Properties();
        try {
            Criteria crit = new Criteria(new Column("SSPASCustomValues", "AGENT_ID"), bean.get("AGENT_ID"), 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPASCustomValues", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("SSPASCustomValues");
                if (path == null || path.equals("")) {
                    path = (String)r.get("ICON");
                }
                for (String customOption : ginacustomOptions) {
                    if (customOption.equals("ICON")) {
                        r.set("ICON", (Object)path);
                        continue;
                    }
                    returnProps.put(customOption, bean.get(customOption));
                    r.set(customOption, bean.get(customOption));
                }
                obj.updateRow(r);
            } else {
                Row r = new Row("SSPASCustomValues");
                for (String customOption : ginacustomOptions) {
                    if (customOption.equals("ICON")) {
                        returnProps.put("ICON", path);
                        r.set("ICON", (Object)path);
                        continue;
                    }
                    returnProps.put(customOption, bean.get(customOption));
                    r.set(customOption, bean.get(customOption));
                }
                obj.addRow(r);
            }
            CommonUtil.getPersistenceLite().update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return returnProps;
    }

    public static void setWindowsLogonTFA(String winlogtfa, String bypass) {
        try {
            Criteria crit = new Criteria(new Column("SSPASCustomValues", "AGENT_ID"), (Object)"-1", 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPASCustomValues", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("SSPASCustomValues");
                r.set("WINDOWS_LOGON_TFA", (Object)winlogtfa);
                r.set("BYPASS_ADSSPSERVER_UNREACH", (Object)bypass);
                obj.updateRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteScheduler(Long agentId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPASDomainOUs", (String)"AGENT_ID"), (Object)agentId, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteMobileScheduler(Long agentId, String domainName) {
        try {
            Criteria crit = new Criteria(new Column("SSPMASDomainOUs", "AGENT_ID"), (Object)agentId, 0);
            crit = crit.and(new Criteria(new Column("SSPMASDomainOUs", "DOMAIN_NAME"), (Object)domainName, 0));
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            logger.log(Level.INFO, "All OUs configured for AgentID " + agentId + " under the domain : " + domainName + "has been deleted");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getAgentSchedulerDetails(HttpServletRequest request, DynaValidatorForm bean) {
        AgentSchedulerHandler.getAgentSchedulerDetails(request, bean, "SSPASDomainOUs");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void getAgentSchedulerDetails(HttpServletRequest request, DynaValidatorForm bean, String configTableName) {
        DataSet dataSet = null;
        Connection connection = null;
        Long agentId = Long.parseLong(request.getParameter("agentId"));
        Long scheduleId = Long.parseLong(request.getParameter("scheduleId"));
        try {
            bean.set("AGENT_ID", (Object)agentId);
            bean.set("SCHEDULE_ID", (Object)scheduleId);
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("Schedule"));
            Join scheduleJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            Join taskJoin = new Join("Scheduled_Task", "TaskEngine_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 2);
            selQuery.addJoin(scheduleJoin);
            selQuery.addJoin(taskJoin);
            selQuery.addSelectColumn(new Column(null, "*"));
            Criteria crit = new Criteria(new Column("Schedule", "SCHEDULE_ID"), (Object)scheduleId, 0);
            selQuery.setCriteria(crit);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selQuery, connection);
            String taskName = new String();
            if (dataSet.next()) {
                bean.set("SCHEDULE_NAME", (Object)((String)dataSet.getValue("SCHEDULE_NAME")));
                bean.set("DESCRIPTION", (Object)((String)dataSet.getValue("DESCRIPTION")));
                taskName = (String)dataSet.getValue("TASK_NAME");
                bean.set("TASK_NAME", (Object)taskName);
                bean.set("TASK_ID", (Object)((Long)dataSet.getValue("TASK_ID")));
            }
            AgentSchedulerHandler.setSchedulerProps(bean, scheduleId);
            Table configTable = new Table(configTableName);
            SelectQueryImpl query = new SelectQueryImpl(configTable);
            ArrayList domainList = (ArrayList)bean.get("domainList");
            String[] domains = new String[domainList.size()];
            for (int i = 0; i < domainList.size(); ++i) {
                Properties p = (Properties)domainList.get(i);
                domains[i] = p.getProperty("DOMAIN_NAME");
            }
            crit = new Criteria(Column.getColumn((String)configTableName, (String)"AGENT_ID"), (Object)agentId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)configTableName, (String)"DOMAIN_NAME"), (Object)domains, 8));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dObj.isEmpty()) {
                Iterator it = dObj.getRows(configTableName);
                Hashtable domainOUList = new Hashtable();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String domainDN = DomainUtil.getDomainDN((ArrayList)bean.get("domainList"), (String)r.get("DOMAIN_NAME"));
                    String dn = (String)r.get("OU_DN");
                    ArrayList<String> list = (ArrayList<String>)domainOUList.get(domainDN);
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    if (!list.contains(dn)) {
                        list.add(dn);
                    }
                    domainOUList.put(domainDN, list);
                }
                bean.set("domainOUList", domainOUList);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setSchedulerProps(DynaValidatorForm bean, Long scheduleId) {
        try {
            Criteria crit = new Criteria(new Column("Periodic", "SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Periodic", crit);
            Row row = null;
            if (!obj.isEmpty()) {
                row = obj.getFirstRow("Periodic");
                if ("Minutes".equalsIgnoreCase((String)row.get("UNIT_OF_TIME"))) {
                    bean.set("TIME_PERIOD", (Object)((Long)row.get("TIME_PERIOD") / 60L));
                    bean.set("HOURLY_MINS_OF_HOUR", (Object)((Long)row.get("TIME_PERIOD") % 60L));
                } else {
                    bean.set("TIME_PERIOD", row.get("TIME_PERIOD"));
                    bean.set("HOURLY_MINS_OF_HOUR", (Object)5L);
                }
                bean.set("SCHEDULE_TYPE", (Object)"hourly");
            } else {
                crit = new Criteria(new Column("Calendar", "SCHEDULE_ID"), (Object)scheduleId, 0);
                obj = CommonUtil.getPersistence(new boolean[0]).get("Calendar", crit);
                row = obj.getFirstRow("Calendar");
                if ("Minutes".equalsIgnoreCase((String)row.get("UNIT_OF_TIME"))) {
                    bean.set("TIME_OF_DAY", (Object)((Long)row.get("TIME_OF_DAY") / 60L));
                    bean.set("MINS_OF_HOUR", (Object)((Long)row.get("TIME_OF_DAY") % 60L));
                } else {
                    bean.set("TIME_OF_DAY", row.get("TIME_OF_DAY"));
                    bean.set("MINS_OF_HOUR", (Object)0L);
                }
                Integer dayOfWeek = (Integer)row.get("DAY_OF_WEEK");
                Integer dateOfMonth = (Integer)row.get("DATE_OF_MONTH");
                if (dayOfWeek != -1) {
                    bean.set("DAY_OF_WEEK", (Object)dayOfWeek);
                    bean.set("SCHEDULE_TYPE", (Object)"weekly");
                } else if (dateOfMonth != -1) {
                    bean.set("DATE_OF_MONTH", (Object)dateOfMonth);
                    bean.set("SCHEDULE_TYPE", (Object)"monthly");
                } else {
                    bean.set("SCHEDULE_TYPE", (Object)"daily");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateEnrollRemainder(Object scheduledId, HttpServletRequest request, Properties prop) {
        try {
            HttpSession session = request.getSession();
            Long loginId = prop == null || prop.isEmpty() ? (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID") : (Long)prop.get("LOGIN_ID");
            Long schCreatedTime = prop == null || prop.isEmpty() ? System.currentTimeMillis() : (Long)prop.get("CREATED_TIME");
            Boolean enforceValue = request.getParameter("ENFORCE") != null;
            Long policyId = new Long(request.getParameter("POLICIES"));
            String enrollText = request.getParameter("ENROLL_UI_TEXT");
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPEnrollmentLogonScript");
            r.set("SCHEDULE_ID", scheduledId);
            r.set("POLICY_ID", (Object)policyId);
            r.set("ENROLL_UI_TEXT", (Object)enrollText);
            r.set("ENFORCE", (Object)enforceValue);
            r.set("CREATED_TIME", (Object)schCreatedTime);
            r.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            r.set("LOGIN_ID", (Object)loginId);
            obj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties getEnrollRemainderDetails(Long schId) {
        Properties prop = new Properties();
        try {
            Criteria schCrit = new Criteria(Column.getColumn((String)"SSPEnrollmentLogonScript", (String)"SCHEDULE_ID"), (Object)schId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPEnrollmentLogonScript", schCrit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("SSPEnrollmentLogonScript");
                prop.put("POLICY_ID", r.get("POLICY_ID"));
                prop.put("ENROLL_UI_TEXT", r.get("ENROLL_UI_TEXT"));
                prop.put("ENFORCE", r.get("ENFORCE"));
                prop.put("CREATED_TIME", r.get("CREATED_TIME"));
                prop.put("LOGIN_ID", r.get("LOGIN_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static void updateASConfiguration(Object scheduleId, DynaValidatorForm bean, HttpServletRequest request) {
        try {
            Long agentId = (Long)bean.get("AGENT_ID");
            AgentSchedulerHandler.deleteScheduler(agentId);
            String taskName = (String)bean.get("TASK_NAME");
            Criteria crit = new Criteria(new Column("SSPASConfiguration", "AGENT_ID"), (Object)agentId, 0);
            DataObject asConfobj = CommonUtil.getPersistence(new boolean[0]).get("SSPASConfiguration", crit);
            Row asConfig = asConfobj.getFirstRow("SSPASConfiguration");
            asConfig.set("SCHEDULE_ID", scheduleId);
            asConfobj.updateRow(asConfig);
            CommonUtil.getPersistence(new boolean[0]).update(asConfobj);
            asConfobj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (taskName.equals(REM_ENROL_TASK)) {
                Long[] policyIds;
                crit = new Criteria(new Column("SSPASCustomValues", "AGENT_ID"), (Object)new Long(-1L), 0);
                DataObject asCustomobj = CommonUtil.getPersistence(new boolean[0]).get("SSPASCustomValues", crit);
                Row customRow = asCustomobj.getFirstRow("SSPASCustomValues");
                customRow.set("ENROLL_UI_TEXT", (Object)((String)bean.get("ENROLL_UI_TEXT")));
                customRow.set("ENROLL_URL", (Object)((String)bean.get("ENROLL_URL")));
                customRow.set("NET_SHARE_PATH", (Object)((String)bean.get("NET_SHARE_PATH")));
                asCustomobj.updateRow(customRow);
                CommonUtil.getPersistence(new boolean[0]).update(asCustomobj);
                for (Long policyId : policyIds = (Long[])bean.get("POLICIES")) {
                    Row remEnrlRow = new Row("SSPASPolicies");
                    remEnrlRow.set("AGENT_ID", (Object)((Long)bean.get("AGENT_ID")));
                    remEnrlRow.set("POLICY_ID", (Object)policyId);
                    asConfobj.addRow(remEnrlRow);
                }
            } else {
                ArrayList<Object> selectedDomainList = new ArrayList();
                String[] ar = request.getParameterValues("domains");
                if (ar != null) {
                    selectedDomainList = new ArrayList<String>(Arrays.asList(ar));
                }
                Properties ouGuidsProp = new Properties();
                Hashtable selDomainAndOUs = new Hashtable();
                Hashtable domainOUList = (Hashtable)bean.get("domainOUList");
                ArrayList domainList = (ArrayList)bean.get("domainList");
                for (int j = 0; j < domainList.size(); ++j) {
                    Properties props = (Properties)domainList.get(j);
                    String dn = (String)props.get("DEFAULT_NAMING_CONTEXT");
                    if (!selectedDomainList.contains(dn)) continue;
                    AgentSchedulerHandler.getOUGuids((ArrayList)props.get("ouList"), ouGuidsProp);
                    ouGuidsProp.put(dn, (String)props.get("OBJECT_GUID"));
                    ArrayList<String> list = (ArrayList<String>)domainOUList.get(dn);
                    logger.log(Level.INFO, "List : " + list + " : For DN : " + dn);
                    if (list == null || list.isEmpty()) {
                        list = new ArrayList<String>();
                        list.add(dn);
                    } else if (list.contains(dn) && list.size() != 1) {
                        list.remove(dn);
                    }
                    ArrayList<String> ouList = new ArrayList<String>();
                    for (int i = 0; i < list.size(); ++i) {
                        String ouName = (String)list.get(i);
                        String domainName = (String)props.get("DOMAIN_NAME");
                        Row r = new Row("SSPASDomainOUs");
                        r.set("AGENT_ID", (Object)agentId);
                        r.set("OBJECT_GUID", (Object)ouGuidsProp.getProperty(ouName));
                        r.set("DOMAIN_NAME", (Object)domainName);
                        if (!ouList.contains(ouName)) {
                            ouList.add(ouName);
                        }
                        r.set("OU_DN", (Object)ouName);
                        asConfobj.addRow(r);
                    }
                    selDomainAndOUs.put((String)props.get("DOMAIN_NAME"), ouList);
                }
                if (taskName.equals(CUSTOM_GINA_TASK)) {
                    AgentSchedulerUtil.addToPendingTable(agentId, selDomainAndOUs);
                }
            }
            CommonUtil.getPersistenceLite().add(asConfobj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void getOUGuids(ArrayList ouList, Properties ouGuidsProp) {
        try {
            Properties tempProps = new Properties();
            for (int x = 0; x < ouList.size(); ++x) {
                tempProps = (Properties)ouList.get(x);
                ouGuidsProp.put(tempProps.get("DISTINGUISHED_NAME"), tempProps.get("OBJECT_GUID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getTaskSchedulers(DynaValidatorForm bean) {
        ArrayList<Properties> scheduleConfigList = new ArrayList<Properties>();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String configTableName = new String("SSPASConfiguration");
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("Schedule"));
            Join scheduleJoin = new Join("Schedule", configTableName, new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            Join taskInputJoin = new Join("Schedule", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join calendarJoin = new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join periodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join schTaskJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join taskJoin = new Join("Scheduled_Task", "TaskEngine_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 1);
            selQuery.addSortColumn(new SortColumn(new Column("SSPASConfiguration", "AGENT_ID"), true));
            selQuery.addJoin(scheduleJoin);
            selQuery.addJoin(taskInputJoin);
            selQuery.addJoin(calendarJoin);
            selQuery.addJoin(periodicJoin);
            selQuery.addJoin(schTaskJoin);
            selQuery.addJoin(taskJoin);
            selQuery.addSelectColumn(new Column("SSPASConfiguration", "AGENT_ID"));
            selQuery.addSelectColumn(new Column("Schedule", "SCHEDULE_ID"));
            selQuery.addSelectColumn(new Column("Schedule", "SCHEDULE_NAME"));
            selQuery.addSelectColumn(new Column("Schedule", "DESCRIPTION"));
            selQuery.addSelectColumn(new Column("Task_Input", "SCHEDULE_TIME"));
            selQuery.addSelectColumn(new Column("Calendar", "TIME_OF_DAY"));
            selQuery.addSelectColumn(new Column("Calendar", "UNIT_OF_TIME"));
            selQuery.addSelectColumn(new Column("Calendar", "DAY_OF_WEEK"));
            selQuery.addSelectColumn(new Column("Calendar", "DATE_OF_MONTH"));
            selQuery.addSelectColumn(new Column("Calendar", "REPEAT_FREQUENCY"));
            selQuery.addSelectColumn(new Column("Periodic", "TIME_PERIOD"));
            selQuery.addSelectColumn(new Column("Periodic", "UNIT_OF_TIME"));
            selQuery.addSelectColumn(new Column("Scheduled_Task", "ADMIN_STATUS"));
            selQuery.addSelectColumn(new Column("Scheduled_Task", "TASK_ID"));
            selQuery.addSelectColumn(new Column("TaskEngine_Task", "TASK_NAME"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                Properties taskProps = new Properties();
                Long agentId = (Long)dataSet.getValue("AGENT_ID");
                taskProps.put("AGENT_ID", agentId);
                taskProps.put("SCHEDULE_ID", (Long)dataSet.getValue("SCHEDULE_ID"));
                taskProps.put("SCHEDULE_NAME", (String)dataSet.getValue("SCHEDULE_NAME"));
                taskProps.put("DESCRIPTION", (String)dataSet.getValue("DESCRIPTION"));
                HashMap<String, Object> prop = new HashMap<String, Object>();
                prop.put("TIME_OF_DAY", (Long)dataSet.getValue("TIME_OF_DAY"));
                prop.put("C_UNIT_OF_TIME", (String)dataSet.getValue(7));
                prop.put("DAY_OF_WEEK", (Integer)dataSet.getValue("DAY_OF_WEEK"));
                prop.put("DATE_OF_MONTH", (Integer)dataSet.getValue("DATE_OF_MONTH"));
                Long timePeriod = (Long)dataSet.getValue("TIME_PERIOD");
                prop.put("TIME_PERIOD", timePeriod);
                if (timePeriod != null && timePeriod != -1L) {
                    prop.put("SCHEDULE_TYPE", "Hourly");
                } else {
                    prop.put("SCHEDULE_TYPE", (String)dataSet.getValue("REPEAT_FREQUENCY"));
                }
                prop.put("P_UNIT_OF_TIME", (String)dataSet.getValue(12));
                taskProps.put("SCHEDULED_AT", prop);
                taskProps.put("SCHEDULE_STATUS", (Integer)dataSet.getValue("ADMIN_STATUS"));
                taskProps.put("DOMAINS", AgentSchedulerHandler.getTaskDomains(agentId));
                scheduleConfigList.add(taskProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return scheduleConfigList;
    }

    public static String getTaskDomains(Long agentId) {
        String domains = new String("...");
        try {
            Table domainOU = new Table("SSPASDomainOUs");
            SelectQueryImpl sq = new SelectQueryImpl(domainOU);
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_NAME"));
            Join join = new Join(domainOU, Table.getTable((String)"ADSMDomainConfiguration"), new String[]{"DOMAIN_NAME"}, new String[]{"DOMAIN_NAME"}, 1);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPASDomainOUs", (String)"AGENT_ID"), (Object)agentId, 0);
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn((String)"ADSMDomainConfiguration", (String)"DOMAIN_DISPLAY_NAME"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows("ADSMDomainConfiguration");
                while (iter.hasNext()) {
                    Row filterRow = (Row)iter.next();
                    String domainName = (String)filterRow.get("DOMAIN_DISPLAY_NAME");
                    if (domains.equals("...")) {
                        domains = domainName;
                        continue;
                    }
                    if (domains.indexOf(domainName) == 0 || domains.indexOf(new String("," + domainName)) != -1) continue;
                    domains = domains + "," + domainName;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domains;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getPolicies(Long schId) {
        String policies = new String("...");
        DataSet dataSet = null;
        Connection connection = null;
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("SSPEnrollmentLogonScript"));
            Criteria crit = new Criteria(new Column("SSPEnrollmentLogonScript", "SCHEDULE_ID"), (Object)schId, 0);
            selQuery.setCriteria(crit);
            Join policyJoin = new Join("SSPEnrollmentLogonScript", "PolicyConfiguration", new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2);
            selQuery.addJoin(policyJoin);
            selQuery.addSelectColumn(new Column("PolicyConfiguration", "POLICY_NAME"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                String policyName = (String)dataSet.getValue("POLICY_NAME");
                if (policies == null || policies.equals("...")) {
                    policies = policyName;
                    continue;
                }
                policies = policies + "," + policyName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return policies;
    }

    public static void fillDetailsForEnrollReminder(DynaValidatorForm bean, HttpServletRequest request, Criteria crit) {
        try {
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"SSPEnrollmentLogonScript"));
            Join scheduleJoin = new Join("SSPEnrollmentLogonScript", "Schedule", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            selQuery.addJoin(scheduleJoin);
            selQuery.setCriteria(crit);
            selQuery.addSelectColumn(new Column(null, "*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            if (!dObj.isEmpty()) {
                Properties prop = new Properties();
                Row scheduleRow = dObj.getRow("Schedule");
                Row policyRow = dObj.getRow("SSPEnrollmentLogonScript");
                request.setAttribute("SELECTED_POLICY", policyRow.get("POLICY_ID"));
                request.setAttribute("ENROLL_UI_TEXT", policyRow.get("ENROLL_UI_TEXT"));
                request.setAttribute("ENFORCE", policyRow.get("ENFORCE"));
                prop.setProperty("SCHEDULE_NAME", (String)scheduleRow.get("SCHEDULE_NAME"));
                prop.setProperty("DESCRIPTION", (String)scheduleRow.get("DESCRIPTION"));
                prop.setProperty("SCHEDULE_ID", Long.toString((Long)policyRow.get("SCHEDULE_ID")));
                request.setAttribute("schduleProps", (Object)prop);
                AgentSchedulerHandler.setSchedulerProps(bean, (Long)policyRow.get("SCHEDULE_ID"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getEnrollReminderSchedulerDetails(String domainName) {
        ArrayList scheduleConfigList = new ArrayList();
        DataSet dataSet = null;
        Connection connection = null;
        try {
            String configTableName = new String("SSPEnrollmentLogonScript");
            SelectQueryImpl selQuery = new SelectQueryImpl(new Table("Schedule"));
            Join scheduleJoin = new Join("Schedule", configTableName, new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
            Join calendarJoin = new Join("Schedule", "Calendar", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join periodicJoin = new Join("Schedule", "Periodic", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join schTaskJoin = new Join("Schedule", "Scheduled_Task", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join taskJoin = new Join("Scheduled_Task", "TaskEngine_Task", new String[]{"TASK_ID"}, new String[]{"TASK_ID"}, 1);
            Join taskInputJoin = new Join("Schedule", "Task_Input", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 1);
            Join policyJoin = new Join(configTableName, "PolicyConfiguration", new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 1);
            selQuery.addJoin(scheduleJoin);
            selQuery.addJoin(calendarJoin);
            selQuery.addJoin(periodicJoin);
            selQuery.addJoin(schTaskJoin);
            selQuery.addJoin(taskJoin);
            selQuery.addJoin(taskInputJoin);
            selQuery.addJoin(policyJoin);
            if (domainName != null && !"ADSelfService Plus Authentication".equals(domainName)) {
                Criteria crit = new Criteria(new Column("PolicyConfiguration", "DOMAIN_NAME"), (Object)domainName, 0);
                selQuery.setCriteria(crit);
            }
            selQuery.addSelectColumn(new Column("Schedule", "SCHEDULE_ID"));
            selQuery.addSelectColumn(new Column("Schedule", "SCHEDULE_NAME"));
            selQuery.addSelectColumn(new Column("Schedule", "DESCRIPTION"));
            selQuery.addSelectColumn(new Column("Calendar", "TIME_OF_DAY"));
            selQuery.addSelectColumn(new Column("Calendar", "UNIT_OF_TIME"));
            selQuery.addSelectColumn(new Column("Calendar", "DAY_OF_WEEK"));
            selQuery.addSelectColumn(new Column("Calendar", "DATE_OF_MONTH"));
            selQuery.addSelectColumn(new Column("Calendar", "REPEAT_FREQUENCY"));
            selQuery.addSelectColumn(new Column("Periodic", "TIME_PERIOD"));
            selQuery.addSelectColumn(new Column("Periodic", "UNIT_OF_TIME"));
            selQuery.addSelectColumn(new Column("Task_Input", "ADMIN_STATUS"));
            selQuery.addSelectColumn(new Column("Task_Input", "SCHEDULE_TIME"));
            selQuery.addSelectColumn(new Column("PolicyConfiguration", "POLICY_NAME"));
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)selQuery, connection);
            while (dataSet.next()) {
                HashMap<String, Object> prop = new HashMap<String, Object>();
                prop.put("SCHEDULE_ID", (Long)dataSet.getValue("SCHEDULE_ID"));
                prop.put("SCHEDULE_NAME", (String)dataSet.getValue("SCHEDULE_NAME"));
                prop.put("DESCRIPTION", (String)dataSet.getValue("DESCRIPTION"));
                prop.put("ADMIN_STATUS", (Integer)dataSet.getValue("ADMIN_STATUS"));
                prop.put("TIME_OF_DAY", (Long)dataSet.getValue("TIME_OF_DAY"));
                prop.put("DAY_OF_WEEK", (Integer)dataSet.getValue("DAY_OF_WEEK"));
                prop.put("DATE_OF_MONTH", (Integer)dataSet.getValue("DATE_OF_MONTH"));
                Long timePeriod = (Long)dataSet.getValue("TIME_PERIOD");
                prop.put("TIME_PERIOD", timePeriod);
                if (timePeriod != null && timePeriod != -1L) {
                    prop.put("SCHEDULE_TYPE", "Hourly");
                } else {
                    prop.put("SCHEDULE_TYPE", (String)dataSet.getValue("REPEAT_FREQUENCY"));
                }
                prop.put("C_UNIT_OF_TIME", (String)dataSet.getValue(5));
                prop.put("P_UNIT_OF_TIME", (String)dataSet.getValue(10));
                prop.put("NEXT_SCHEDULE_TIME", (Timestamp)dataSet.getValue("SCHEDULE_TIME"));
                scheduleConfigList.add(prop);
            }
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
        return scheduleConfigList;
    }
}

