/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.SelfServiceHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.configuration.WorkflowConfigHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.reports.AuditLog;
import com.adventnet.sym.adsm.common.server.reports.AuditMgmtUtil;
import com.adventnet.sym.adsm.common.server.reports.AuditQueryGenerator;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.reports.CreateAuditTable;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportsUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.QueryGeneratorFactory;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.workflow.WFConstants;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONArray;
import org.json.JSONObject;

public class AuditAPI
implements WFConstants {
    private static AuditAPI handler = null;
    private Hashtable loginDetails = null;
    private static Logger logger = Logger.getLogger(AuditAPI.class.getName());
    RelationalAPI relationalAPI = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static AuditAPI getInstance() {
        if (handler != null) return handler;
        Class<AuditAPI> clazz = AuditAPI.class;
        synchronized (AuditAPI.class) {
            if (handler != null) return handler;
            handler = new AuditAPI();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    private AuditAPI() {
        try {
            this.relationalAPI = RelationalAPI.getInstance();
            this.loginDetails = new Hashtable();
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", (Criteria)null);
            Iterator it = obj.getRows("AaaLogin");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long loginId = (Long)r.get("LOGIN_ID");
                Properties prop = new Properties();
                prop.put("LOGIN_NAME", (String)r.get("NAME"));
                prop.put("LOGIN_DOMAIN_NAME", (String)r.get("DOMAINNAME"));
                this.loginDetails.put(loginId, prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Properties getUserDetails(Long loginId) {
        if (this.loginDetails.get(loginId) == null) {
            this.loginDetails.put(loginId, ADAuthHandler.getLoginUserDetails(loginId));
        }
        return (Properties)this.loginDetails.get(loginId);
    }

    public void addAuditLog(Long loginId, Long userId, String action, long time, String host, String ip, Hashtable props, Integer status, String statusMessage) {
        this.addAuditLog(loginId, userId, action, time, host, ip, props, status, statusMessage, null);
    }

    public void addAuditLog(Long loginId, Long userId, String action, long time, String host, String ip, Hashtable props, Integer status, String statusMessage, String accessMode) {
        logger.log(Level.INFO, "Entered into addAuditLog !!");
        class Action
        extends Thread {
            Long loginId;
            Long userId;
            String action;
            long time;
            String host;
            String ip;
            Hashtable props;
            Integer status;
            String statusMessage;
            String accessMode;

            Action(Long loginId, Long userId, String action, long time, String host, String ip, Hashtable props, Integer status, String statusMessage, String accessMode) {
                this.loginId = loginId;
                this.userId = userId;
                this.action = action;
                this.time = time;
                this.host = host;
                this.ip = ip;
                this.props = props;
                this.status = status;
                this.statusMessage = statusMessage;
                this.accessMode = accessMode;
            }

            @Override
            public void run() {
                try {
                    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                    DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    String tableName = "SSPAudit";
                    if (!(AuditReportHandler.isAuditTableExist(tableName) || CreateAuditTable.create(tableName) || AuditReportHandler.isAuditTableExist(tableName))) {
                        return;
                    }
                    Row r = new Row(tableName);
                    r.set("LOGIN_ID", (Object)this.loginId);
                    r.set("USER_ID", (Object)this.userId);
                    r.set("TIME", (Object)this.time);
                    r.set("TYPE", (Object)this.action);
                    HashMap result = (HashMap)CommonUtil.getHostDetails(this.ip);
                    r.set("HOST", (Object)((String)result.get("host")));
                    r.set("IP", (Object)((String)result.get("ip")));
                    r.set("STATUS", (Object)this.status);
                    if (this.accessMode != null) {
                        r.set("ACCESS_MODE", (Object)this.accessMode);
                    } else {
                        r.set("ACCESS_MODE", (Object)"NULL");
                    }
                    if (this.statusMessage.equals("adssp.common.text.success")) {
                        r.set("ERROR_MESSAGE", (Object)StrUtil.scriptEscape(this.statusMessage));
                    } else {
                        r.set("ERROR_MESSAGE", (Object)StrUtil.scriptEscape(this.statusMessage));
                    }
                    obj.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(obj);
                    Properties loginProp = com.manageengine.ads.fw.util.CommonUtil.getLoginProperties((Long)this.userId, (String)"USER_ID");
                    JSONObject jsonLog = AuditAPI.getInstance().setAuditProps(loginProp.getProperty("NAME"), loginProp.getProperty("DOMAINNAME"), this.time, this.action, this.ip, (String)result.get("host"), this.accessMode, rb.getString(StrUtil.scriptEscape(this.statusMessage)));
                    if (this.props != null && !this.props.isEmpty()) {
                        jsonLog.put("UPDATED_ATTRIBUTES", (Object)this.props.toString());
                    }
                    logger.log(Level.INFO, "calling logForwarder : " + jsonLog.toString());
                    LogForwarderAPI.getInstance().sendMessage(jsonLog);
                    AuditReportHandler.checkForBackUp(tableName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                logger.log(Level.INFO, "End of addAuditLog !!");
            }
        }
        Action acn = new Action(loginId, userId, action, time, host, ip, props, status, statusMessage, accessMode);
        acn.start();
    }

    public JSONObject setAuditProps(String loginName, String domainName, long time, String action, String ip, String hostname, String accessMode, String statusMessage) {
        JSONObject jsonLog = new JSONObject();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            jsonLog.put("LOGIN NAME", (Object)loginName);
            jsonLog.put("DOMAIN NAME", (Object)domainName);
            jsonLog.put("TIME", time);
            jsonLog.put("DATE_TIME", (Object)TimeZoneUtil.getPresentDateTime((HttpServletRequest)null, null));
            jsonLog.put("ACTION_NAME", (Object)rb.getString(action));
            if (hostname.equalsIgnoreCase("")) {
                HashMap result = (HashMap)CommonUtil.getHostDetails(ip);
                ip = (String)result.get("ip");
                hostname = (String)result.get("host");
            }
            jsonLog.put("HOST", (Object)hostname);
            jsonLog.put("IP", (Object)ip);
            if (accessMode != null && !accessMode.equalsIgnoreCase("")) {
                if (accessMode.equalsIgnoreCase("NApp_Android")) {
                    accessMode = rb.getString("adssp.reports.access_mode.android_app");
                } else if (accessMode.equalsIgnoreCase("MApp")) {
                    accessMode = rb.getString("adssp.reports.access_mode.mobile_site");
                } else if (accessMode.equalsIgnoreCase("NApp_IOS")) {
                    accessMode = rb.getString("adssp.reports.audit_report.notification.ios");
                } else if (accessMode.equalsIgnoreCase("WebPage")) {
                    accessMode = rb.getString("adssp.reports.access_mode.webpage");
                }
                jsonLog.put("ACCESS_MODE", (Object)accessMode);
            }
            jsonLog.put("STATUS", (Object)rb.getString(statusMessage));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonLog;
    }

    public ArrayList getAuditLogs(String domainName, StringBuffer action, long fromTime, long toTime, String sortColumn, boolean ascending, int startIndex, int numOfObjects, String searchString, String filter, HttpServletRequest request) {
        long auditCnt = 0L;
        logger.log(Level.INFO, "Entered into getAuditLogs with domainName :: " + domainName + " action :: " + action);
        ArrayList<ArrayList> list = new ArrayList<ArrayList>();
        ArrayList reportList = new ArrayList();
        ArrayList<Long> countList = new ArrayList<Long>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
            if (!obj.isEmpty()) {
                Long loginId;
                ArrayList techOuList;
                Iterator it = obj.getRows("AaaLogin");
                ArrayList<Object> logIds = new ArrayList<Object>();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    logIds.add(r.get("LOGIN_ID"));
                }
                Hashtable<String, Object> inputHash = new Hashtable<String, Object>();
                inputHash.put("FROM_TIME", new Long(fromTime));
                inputHash.put("TO_TIME", new Long(toTime));
                inputHash.put("SORT_COLUMN", sortColumn);
                inputHash.put("SEARCH_STRING", searchString);
                inputHash.put("FILTER", filter);
                inputHash.put("ASCENDING", ascending);
                inputHash.put("EXPORT", Boolean.FALSE);
                inputHash.put("START_INDEX", startIndex);
                inputHash.put("END_INDEX", numOfObjects);
                inputHash.put("DOMAIN_NAME", domainName);
                if (action != null) {
                    inputHash.put("AUDIT_TYPE", action);
                }
                if ((techOuList = ReportHandler.getUserVsReportOUMapping(loginId = (Long)request.getSession().getAttribute("ADMP_SESSION_LOGIN_ID"), Integer.parseInt(request.getParameter("reportId")), domainName)) != null && techOuList.size() > 0) {
                    techOuList = OUUtil.getParentOUs(techOuList);
                }
                inputHash.put("OULIST", techOuList);
                Hashtable resultHash = AuditAPI.getAuditLogs("SSP_ACTION", inputHash, AuditMgmtUtil.AUDIT_QUERY_COLUMNS, "NO_OF_ATTEMPT", request);
                if (resultHash != null && !resultHash.isEmpty()) {
                    reportList = (ArrayList)resultHash.get("RESULTLIST");
                    auditCnt = (Long)resultHash.get("TOTALCOUNT");
                }
            }
            countList.add(auditCnt);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, "End of getAuditLogs(from dashboard)!!");
        list.add(countList);
        list.add(reportList);
        return list;
    }

    public static void addAuditLogs(Hashtable deliveryProps) {
        logger.log(Level.INFO, "Audit Logs for Mail notication" + deliveryProps);
        class Action
        extends Thread {
            Hashtable deliveryProps;

            Action(Hashtable deliveryProps) {
                this.deliveryProps = deliveryProps;
            }

            @Override
            public void run() {
                try {
                    AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
                    DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    String tableName = "SSPNotificationAudit";
                    if (!AuditReportHandler.isAuditTableExist(tableName) && !CreateAuditTable.create(tableName)) {
                        return;
                    }
                    Enumeration e = this.deliveryProps.keys();
                    while (e.hasMoreElements()) {
                        String objectGuid = (String)e.nextElement();
                        Hashtable mailProps = (Hashtable)this.deliveryProps.get(objectGuid);
                        Long deliveredTime = (Long)mailProps.get("DELIVERED_TIME");
                        if (deliveredTime == null) {
                            deliveredTime = -1L;
                        }
                        Row r = new Row("SSPNotificationAudit");
                        r.set("DOMAIN_NAME", (Object)((String)mailProps.get("DOMAIN_NAME")));
                        r.set("NAME", (Object)((String)mailProps.get("NAME")));
                        r.set("ACTION_NAME", (Object)((String)mailProps.get("ACTION_NAME")));
                        r.set("NOTIFICATION_TYPE", (Object)((String)mailProps.get("NOTIFICATION_TYPE")));
                        r.set("TIME", (Object)((Long)mailProps.get("MAIL_SENT_TIME")));
                        r.set("DELIVERED_TIME", (Object)deliveredTime);
                        if (((String)mailProps.get("STATUS")).equals("adssp.common.text.success") || ((String)mailProps.get("STATUS")).equals("ads.push_notification.pn_sent_success_txt")) {
                            r.set("ERROR_MESSAGE", (Object)StrUtil.scriptEscape((String)mailProps.get("STATUS")));
                        } else {
                            r.set("ERROR_MESSAGE", (Object)StrUtil.scriptEscape(rb.getString((String)mailProps.get("STATUS"))));
                        }
                        obj.addRow(r);
                        String domainList = "";
                        if (mailProps.get("DOMAIN_LIST") != null && !((String)mailProps.get("DOMAIN_LIST")).equalsIgnoreCase("")) {
                            domainList = (String)mailProps.get("DOMAIN_LIST");
                        }
                        JSONObject jsonLog = AuditAPI.getInstance().setNotificationAuditProps((String)mailProps.get("NAME"), (String)mailProps.get("DOMAIN_NAME"), (String)mailProps.get("ACTION_NAME"), (String)mailProps.get("NOTIFICATION_TYPE"), (Long)mailProps.get("MAIL_SENT_TIME"), deliveredTime, (String)mailProps.get("STATUS"), domainList);
                        if (mailProps.get("MAIL_CONTENT") != null) {
                            jsonLog.put("MAIL_CONTENT", (Object)((String)mailProps.get("MAIL_CONTENT")));
                        }
                        if (mailProps.get("MAIL_SUBJECT") != null) {
                            jsonLog.put("MAIL_SUBJECT", (Object)((String)mailProps.get("MAIL_SUBJECT")));
                        }
                        LogForwarderAPI.getInstance().sendMessage(jsonLog);
                        CommonUtil.getPersistence(new boolean[0]).update(obj);
                    }
                    AuditReportHandler.checkForBackUp(tableName);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        Action acn = new Action(deliveryProps);
        acn.start();
    }

    public JSONObject setNotificationAuditProps(String loginName, String domainName, String actionName, String notificationType, Long mailSentTime, Long deliveredTime, String status, String domainList) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject jsonLog = new JSONObject();
        try {
            if (domainList.equalsIgnoreCase("")) {
                jsonLog.put("DOMAIN_NAME", (Object)domainName);
            } else {
                jsonLog.put("DOMAIN_LIST", (Object)domainList);
            }
            jsonLog.put("NAME", (Object)loginName);
            jsonLog.put("ACTION_NAME", (Object)rb.getString(actionName));
            jsonLog.put("NOTIFICATION_TYPE", (Object)rb.getString(notificationType));
            jsonLog.put("TIME", (Object)mailSentTime);
            jsonLog.put("DATE_TIME", (Object)TimeZoneUtil.getPresentDateTime((HttpServletRequest)null, null));
            jsonLog.put("DELIVERED_TIME", (Object)deliveredTime);
            jsonLog.put("STATUS", (Object)StrUtil.scriptEscape(rb.getString(status)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonLog;
    }

    public void addUserAttemptsAuditLog(HttpServletRequest request, String loginName, String domainName, String auditType, String errMsg) {
        this.addUserAttemptsAuditLog(request, loginName, domainName, auditType, errMsg, -1);
    }

    public void addUserAttemptsAuditLog(HttpServletRequest request, String loginName, String domainName, String auditType, String errMsg, int status) {
        try {
            logger.log(Level.INFO, "User attempts Audit :: LoginName : " + loginName + " DomainName : " + domainName + " AuditType : " + auditType + " ErrorMessage : " + errMsg);
            String ipAddress = CommonUtil.getIPAddress(request);
            String accessMode = ReportsUtil.getSSPAccessMode(request);
            AuditLog.addUserAttemptsAuditLog(loginName, domainName, auditType, errMsg, status, ipAddress, accessMode);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int[] getAuditCount(String domain, long startTime, long endTime) {
        HashMap<String, Object> countQueryMap = new HashMap<String, Object>();
        countQueryMap.put("domain", domain);
        countQueryMap.put("startTime", startTime);
        countQueryMap.put("endTime", endTime);
        return this.getAuditCount(countQueryMap, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int[] getAuditCount(Map countQueryMap, boolean includeOUs) {
        Statement stmt = null;
        ResultSet rsltSet = null;
        Connection connect = null;
        List<String> reportType = Arrays.asList("'audit.action.reset_pwd'", "'audit.action.unlocked'", "'audit.action.self_update'", "'audit.action.security_ques','audit.action.verification_code','audit.action.authenticator_code','audit.action.rsa_authentication','audit.action.radius_authentication','audit.action.mobile_app_auth.push','audit.action.mobile_app_auth.finger_print','audit.action.mobile_app_auth.qr_code','audit.action.mobile_app_auth.totp'", "'audit.action.change_pwd'");
        int[] reportIds = new int[]{101, 102, 103, 106, 106, 106, 108};
        int[] reportCount = new int[reportType.size()];
        String cntQuery = "";
        try {
            connect = this.relationalAPI.getConnection();
            stmt = connect.createStatement();
            DatabaseMetaData dbm = connect.getMetaData();
            int dbVersion = dbm.getDatabaseMajorVersion();
            String dbName = dbm.getDatabaseProductName();
            for (int i = 0; i < reportType.size(); ++i) {
                countQueryMap.put("reportType", reportType.get(i));
                if (includeOUs && countQueryMap.containsKey("LOGIN_ID")) {
                    Long loginId = Long.valueOf(String.valueOf(countQueryMap.get("LOGIN_ID")));
                    ArrayList techOuList = ReportHandler.getUserVsReportOUMapping(loginId, reportIds[i], String.valueOf(countQueryMap.get("domain")));
                    if (techOuList != null && techOuList.size() > 0) {
                        techOuList = OUUtil.getParentOUs(techOuList);
                    }
                    countQueryMap.put("OULIST", techOuList);
                }
                new QueryGeneratorFactory();
                AuditQueryGenerator cntObj = QueryGeneratorFactory.getInstance();
                cntQuery = cntObj.getCountQuery(countQueryMap);
                if (!cntQuery.equals("")) {
                    rsltSet = QueryUtil.executeQuery("Getting count from tables", stmt, cntQuery);
                    ResultSetMetaData rsmd = rsltSet.getMetaData();
                    String firstColumnName = rsmd.getColumnName(1);
                    rsltSet.next();
                    if ("MySQL".equalsIgnoreCase(dbName) && dbVersion < 5) {
                        int reportCnt = 0;
                        rsltSet.previous();
                        while (rsltSet.next()) {
                            ++reportCnt;
                        }
                        reportCount[i] = reportCnt;
                        continue;
                    }
                    reportCount[i] = Integer.parseInt(rsltSet.getString(1));
                    continue;
                }
                reportCount[i] = 0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rsltSet != null) {
                    rsltSet.close();
                }
                if (connect != null) {
                    connect.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return reportCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isPrevAuditPresent() {
        boolean isPrevAudit = false;
        Statement stmt = null;
        ResultSet rsltSet = null;
        Connection connect = null;
        try {
            connect = this.relationalAPI.getConnection();
            stmt = connect.createStatement();
            if (AuditReportHandler.isAuditTableExist("SSPAudit")) {
                String prevAuditQuery = "select count(*) from SSPAudit;";
                rsltSet = QueryUtil.executeQuery("Checking for previous audit count", stmt, prevAuditQuery);
                rsltSet.next();
                int prevAuditCount = Integer.parseInt(rsltSet.getString(1));
                if (prevAuditCount > 0) {
                    isPrevAudit = true;
                } else {
                    String prevMetaAuditQuery = "select count(*) from SSPMETATABLE where LOOKUP_TABLENAME like 'SSPAudit%';";
                    rsltSet = QueryUtil.executeQuery("Checking for previous audit count in meta tables", stmt, prevMetaAuditQuery);
                    rsltSet.next();
                    int prevMetaAuditCount = Integer.parseInt(rsltSet.getString(1));
                    isPrevAudit = prevMetaAuditCount > 0;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (stmt != null) {
                    stmt.close();
                }
                if (rsltSet != null) {
                    rsltSet.close();
                }
                if (connect != null) {
                    connect.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return isPrevAudit;
    }

    public static Hashtable getAuditLogs(String actionType, Hashtable inputHash, String[] queryCols, String countColumn) {
        return AuditAPI.getAuditLogs(actionType, inputHash, queryCols, countColumn, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getAuditLogs(String actionType, Hashtable inputHash, String[] queryCols, String countColumn, HttpServletRequest request) {
        Hashtable<String, Serializable> resultHash = new Hashtable<String, Serializable>();
        Connection connection = null;
        Statement statement = null;
        Statement preStatement = null;
        ResultSet resultSetObj = null;
        ResultSet rs = null;
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            new QueryGeneratorFactory();
            AuditQueryGenerator qgObj = QueryGeneratorFactory.getInstance();
            String framedQuery = null;
            statement = connection.createStatement();
            boolean export = (Boolean)inputHash.get("EXPORT");
            if (export) {
                framedQuery = qgObj.exportAuditQuery(actionType, inputHash);
            } else {
                framedQuery = qgObj.generateQuery(actionType, inputHash);
                AuditAPI.printLog("COUNT QUERY :::: ", framedQuery);
                Long totalCount = 0L;
                if (framedQuery != null && !framedQuery.equals("")) {
                    resultSetObj = QueryUtil.executeQuery("Getting count from tables", statement, framedQuery, false);
                    while (resultSetObj.next()) {
                        Long l = totalCount;
                        Long l2 = totalCount = Long.valueOf(totalCount + 1L);
                    }
                    int startIndex = (Integer)inputHash.get("START_INDEX");
                    int numOfObjects = (Integer)inputHash.get("END_INDEX");
                    String sortColumn = (String)inputHash.get("SORT_COLUMN");
                    framedQuery = qgObj.getNavigationQuery(framedQuery, numOfObjects, startIndex, sortColumn);
                }
                resultHash.put("TOTALCOUNT", totalCount);
            }
            AuditAPI.printLog("FRAMED QUERY EXEC :::::::::::::: ", framedQuery);
            HashMap statusMap = new HashMap();
            qgObj.getStatusMessage(framedQuery, statusMap, actionType, inputHash);
            ArrayList resultList = new ArrayList();
            if (framedQuery != null && !framedQuery.equals("")) {
                resultSetObj = QueryUtil.executeQuery("Getting value from tables", statement, framedQuery, false);
                ResultSetMetaData rsmd = resultSetObj.getMetaData();
                while (resultSetObj.next()) {
                    Long time = 0L;
                    Hashtable<String, Object> pro = new Hashtable<String, Object>();
                    for (String col : queryCols) {
                        Object value = null;
                        try {
                            if (!statusMap.isEmpty()) {
                                Long auditId;
                                ArrayList statusList;
                                if ("ERROR_MESSAGE".equalsIgnoreCase(col)) {
                                    Long auditId2 = resultSetObj.getLong("AUDIT_ID");
                                    if (actionType.equalsIgnoreCase("NOTIFICATION")) {
                                        JSONObject notifyType = (JSONObject)statusMap.get(auditId2);
                                        value = notifyType.optString(resultSetObj.getString("ACTION_NAME"));
                                    } else {
                                        statusList = (ArrayList)statusMap.get(auditId2);
                                        if (statusList != null) {
                                            value = statusList.get(0);
                                        }
                                    }
                                } else if ("STATUS".equalsIgnoreCase(col) && (actionType.equalsIgnoreCase("SSP_ACTION") || actionType.equalsIgnoreCase("USER_ATTEMPTS")) && (statusList = (ArrayList)statusMap.get(auditId = Long.valueOf(resultSetObj.getLong("AUDIT_ID")))) != null) {
                                    value = statusList.get(1);
                                }
                            }
                            if ("TIME".equalsIgnoreCase(col)) {
                                time = resultSetObj.getLong("TIME");
                                value = request != null ? TimeZoneUtil.getTimeInCustomFormat(time, request) : TimeZoneUtil.getTimeInCustomFormat(time, TimeZoneUtil.getCustomDateFormat(1L), rb);
                            } else {
                                int colType = rsmd.getColumnType(resultSetObj.findColumn(col));
                                value = DBUtil.convert(resultSetObj.getString(col), colType);
                            }
                        }
                        catch (SQLException sqlEx) {
                            logger.log(Level.INFO, "SQL Exception occured while iterating result set objects....." + sqlEx.getMessage());
                        }
                        if (value == null) continue;
                        pro.put(col, value);
                    }
                    Long countOccurence = 1L;
                    try {
                        countOccurence = resultSetObj.getLong(countColumn);
                    }
                    catch (SQLException sqlEx) {
                        logger.log(Level.INFO, "SQL Exception occured while iterating result set objects....." + sqlEx.getMessage());
                    }
                    pro.put(countColumn, countOccurence);
                    resultList.add(pro);
                }
            }
            resultHash.put("RESULTLIST", resultList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (resultSetObj != null) {
                    resultSetObj.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (preStatement != null) {
                    preStatement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return resultHash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getPreviousAttempts(Properties prop, String actionType, HttpServletRequest request) {
        Connection connection = null;
        Statement preStatement = null;
        ResultSet rs = null;
        Hashtable pro = new Hashtable();
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            new QueryGeneratorFactory();
            AuditQueryGenerator qgObj = QueryGeneratorFactory.getInstance();
            String preAtmtQry = qgObj.getPreviousAttemptQuery(prop, actionType);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            preStatement = connection.createStatement();
            rs = QueryUtil.executeQuery("Getting value from tables", preStatement, preAtmtQry, false);
            ArrayList<String> preTimeList = new ArrayList<String>();
            ArrayList<String> errorMessageList = new ArrayList<String>();
            ArrayList<String> statusList = new ArrayList<String>();
            String statusInt = "";
            String status = "";
            while (rs.next()) {
                preTimeList.add("\"" + TimeZoneUtil.getTimeInCustomFormat(rs.getLong("TIME"), request) + "\"");
                if (rs.getString("ERROR_MESSAGE") == null) {
                    status = "adssp.common.text.success";
                    if (!actionType.equalsIgnoreCase("NOTIFICATION") && rs.getString("STATUS").equals("0")) {
                        status = "adssp.common.text.failed";
                    }
                    errorMessageList.add("\"" + status + "\"");
                } else {
                    status = rs.getString("ERROR_MESSAGE");
                    if (!(status.equals("adssp.common.text.success") || status.equals("adssp.common.text.failed") || status.equals("ads.push_notification.pn_sent_success_txt"))) {
                        status = rb.getString(status);
                    }
                    errorMessageList.add("\"" + status + "\"");
                }
                if (!actionType.equalsIgnoreCase("NOTIFICATION")) {
                    statusList.add(rs.getString("STATUS"));
                    continue;
                }
                statusInt = "0";
                if (status.equals("adssp.common.text.success") || status.equals("ads.push_notification.pn_sent_success_txt")) {
                    statusInt = "1";
                }
                statusList.add(statusInt);
            }
            pro.put("PRE_TIME", preTimeList);
            pro.put("PRE_ERR_MSG", errorMessageList);
            pro.put("PRE_STATUS", statusList);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (rs != null) {
                    rs.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            try {
                if (preStatement != null) {
                    preStatement.close();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return pro;
    }

    private static void printLog(String printName, String printValue) {
        String logLevel = ADSMPersUtil.getSyMParameter("LogLevel");
        if (logLevel.equalsIgnoreCase("DEBUG")) {
            logger.log(Level.INFO, printName + " :: " + printValue);
        }
    }

    public static void updateWorkflowAudit(JSONArray updatedRequests) {
        try {
            if (updatedRequests != null) {
                for (int i = 0; i < updatedRequests.length(); ++i) {
                    String host;
                    JSONObject request = updatedRequests.getJSONObject(i);
                    String previousRequestStatus = request.has("REQUEST_STATUS_PREVIOUS") ? request.getString("REQUEST_STATUS_PREVIOUS") : "";
                    String workflowStatus = request.getString("WORKFLOW_STATUS");
                    String requestStatus = request.getString("REQUEST_STATUS");
                    if (!request.getString("REQUEST_ACTION_TYPE").equals("adssp.config.admin_tools.helpdesk.action_self_update") || previousRequestStatus.equalsIgnoreCase(requestStatus)) continue;
                    Long loginId = request.getLong("LOGIN_ID");
                    Long userId = SelfServiceHandler.getUserId(loginId);
                    JSONObject providerDetail = WorkflowConfigHandler.getProviderDetail(request.getString("WF_PROVIDER_ACTION_ID"));
                    String string = host = providerDetail != null && providerDetail.has("HOST") ? providerDetail.getString("HOST") : "";
                    if (requestStatus.equals("adssp.workflow.request_status.closed") && workflowStatus.equalsIgnoreCase("adssp.workflow.workflow_status.commited")) {
                        AuditAPI.getInstance().addAuditLog(loginId, userId, "audit.action.self_update", request.getLong("UPDATED_TIME"), host, host, new Hashtable(), 1, "adssp.common.text.success", "WebPage");
                        continue;
                    }
                    if (!requestStatus.equals("adssp.workflow.request_status.rejected")) continue;
                    AuditAPI.getInstance().addAuditLog(loginId, userId, "audit.action.self_update", request.getLong("UPDATED_TIME"), host, host, new Hashtable(), -1, "adssp.common.text.rejected", "WebPage");
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.INFO, "", e);
        }
    }

    public JSONObject setBulkAuditProps(String dName, String usersList, String actionName, long currentTimeMillis) {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        JSONObject jsonLog = new JSONObject();
        try {
            jsonLog.put("DOMAIN_NAME", (Object)dName);
            jsonLog.put("USERS_LIST", (Object)usersList.toString());
            jsonLog.put("ACTION_NAME", (Object)rb.getString(actionName));
            jsonLog.put("TIME", System.currentTimeMillis());
            jsonLog.put("DATE_TIME", (Object)TimeZoneUtil.getPresentDateTime((HttpServletRequest)null, null));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonLog;
    }
}

