/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.ProfileBuilder;
import com.adventnet.sym.adsm.common.server.admin.SecondaryAttributesHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.configuration.APCModuleHandler;
import com.adventnet.sym.adsm.common.server.configuration.IdentityVerifyHandler;
import com.adventnet.sym.adsm.common.server.mobile.MobileUtil;
import com.adventnet.sym.adsm.common.server.tfa.MobileOneAuthHandler;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseUtil;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class EnrollmentHandler {
    public static boolean getForceEnrollStatus(Long loginId, HttpServletRequest request) {
        try {
            Hashtable policyHash;
            HttpSession session = request.getSession();
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
            String loginName = domainDetails.getProperty("LOGIN_NAME");
            String userDN = (String)session.getAttribute("USER_DN");
            ArrayList userGroups = (ArrayList)session.getAttribute("userGroups");
            if (userDN != null && userGroups != null && ((Boolean)(policyHash = PolicyHandler.checkUserPermission(domainName, userDN, userGroups)).get("status")).booleanValue()) {
                Long policyId = (Long)policyHash.get("policyId");
                String isReg = EnrollmentHandler.isEnrolled(loginId, request);
                Boolean isEnrolPermitted = PolicyHandler.isEnrollAllowed(policyId);
                JSONObject json = APCModuleHandler.getModuleFlagValues(policyId, "ENROLLMENT");
                Long fE = new Long((String)json.get("FORCE_ENROLLMENT"));
                boolean isPSSPurchased = LicenseUtil.isPSSModulePurchased();
                if (isEnrolPermitted != null && isEnrolPermitted.booleanValue() && !isReg.equals("true") && fE.equals(1L) && isPSSPurchased) {
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static String isEnrolled(Long loginId) {
        return EnrollmentHandler.isEnrolled(loginId, null);
    }

    public static String isEnrolled(Long loginId, HttpServletRequest request) {
        String isEnrolled = "false";
        try {
            Properties domainDetails;
            Long policyId = null;
            Boolean isNativeApp = request != null ? MobileUtil.isNativeApp(request) : false;
            boolean isMFASupported = true;
            if (isNativeApp.booleanValue()) {
                isMFASupported = MobileUtil.isMFASupportedApp(request);
            }
            if (!(domainDetails = ADAuthHandler.getLoginUserDetails(loginId)).isEmpty()) {
                String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
                String logonName = domainDetails.getProperty("LOGIN_NAME");
                if (request != null) {
                    HttpSession session = request.getSession();
                    policyId = (Long)session.getAttribute("POLICY_ID");
                }
                if (policyId == null) {
                    Hashtable policyHash = PolicyHandler.checkPermission(domainName, logonName);
                    policyId = (Long)policyHash.get("policyId");
                }
                Boolean isEnrolPermitted = PolicyHandler.isEnrollAllowed(policyId);
                Hashtable<String, Object> vcParams = new Hashtable<String, Object>();
                vcParams.put("LOGIN_ID", loginId);
                if (policyId != null) {
                    vcParams.put("POLICY_ID", policyId);
                }
                vcParams.put("LOGON_NAME", logonName);
                vcParams.put("DOMAIN_NAME", domainName);
                EnrollmentHandler.verifyVCRegistration(vcParams);
                JSONObject regData = EnrollmentHandler.getEnrollmentData(logonName, domainName, loginId, policyId, request);
                isEnrolled = (String)regData.get("isEnrolled");
                boolean isSQAReg = (Boolean)regData.get("isSQAReg");
                boolean isAuthReg = (Boolean)regData.get("isAuthReg");
                boolean isVCReg = (Boolean)regData.get("isVCReg") != false && (Boolean)vcParams.get("IS_VCREGISTERED") != false;
                boolean isDuoReg = (Boolean)regData.get("isDuoReg") != false && isMFASupported;
                boolean isRSAReg = (Boolean)regData.get("isRSAReg") != false && isMFASupported;
                boolean isRadiusReg = (Boolean)regData.get("isRadiusReg") != false && isMFASupported;
                boolean isPushReg = (Boolean)regData.get("isPushReg") != false && isMFASupported;
                boolean isFPAuthReg = (Boolean)regData.get("isFingerprintReg") != false && isMFASupported;
                boolean isQRAuthReg = (Boolean)regData.get("isQRReg") != false && isMFASupported;
                boolean isTotpAuthReg = (Boolean)regData.get("isTotpReg") != false && isMFASupported;
                boolean isIdentityForced = (Boolean)regData.get("isIdentityForced");
                ArrayList verifyIds = IdentityVerifyHandler.getMandatoryVerifyList(policyId, request, false);
                if (isEnrolled.equals("true")) {
                    if (isIdentityForced) {
                        boolean isSQAForced = verifyIds.contains(IdentityVerifyHandler.SQA_VERIFICATION_ID) ? isSQAReg : true;
                        boolean isVCForced = verifyIds.contains(IdentityVerifyHandler.CODE_VERIFICATION_ID) ? isVCReg : true;
                        boolean isAuthForced = verifyIds.contains(IdentityVerifyHandler.AUTHENTICATOR_VERIFICATION_ID) ? isAuthReg : true;
                        boolean isDuoForced = verifyIds.contains(IdentityVerifyHandler.DUO_VERIFICATION_ID) ? isDuoReg : true;
                        boolean isPushForced = verifyIds.contains(IdentityVerifyHandler.PN_VERIFICATION_ID) ? isPushReg : true;
                        boolean isFPForced = verifyIds.contains(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID) ? isFPAuthReg : true;
                        boolean isQRForced = verifyIds.contains(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID) ? isQRAuthReg : true;
                        boolean isTotpForced = verifyIds.contains(IdentityVerifyHandler.TOTP_VERIFICATION_ID) ? isTotpAuthReg : true;
                        String string = isEnrolled = isSQAForced && isVCForced && isAuthForced && isDuoForced && isPushForced && isFPForced && isQRForced && isTotpForced ? "true" : "false";
                        if (isEnrolled.equals("false")) {
                            isEnrolled = isSQAReg || isVCReg || isAuthReg || isDuoReg || isRSAReg || isRadiusReg || isPushReg || isFPAuthReg || isQRAuthReg || isTotpAuthReg ? "partial" : "false";
                        }
                    } else {
                        String string = isEnrolled = isSQAReg || isVCReg || isAuthReg || isDuoReg || isRSAReg || isRadiusReg || isPushReg || isFPAuthReg || isQRAuthReg || isTotpAuthReg ? "true" : "false";
                    }
                }
                if ("true".equals(isEnrolled) && isEnrolPermitted.booleanValue()) {
                    Long enrollmentType = (Long)vcParams.get("ENROLLMENT_TYPE");
                    if (isSQAReg) {
                        enrollmentType = enrollmentType + 2L;
                    }
                    if (isAuthReg) {
                        enrollmentType = enrollmentType + 16L;
                    }
                    if (isDuoReg) {
                        enrollmentType = enrollmentType + 32L;
                    }
                    if (isRSAReg) {
                        enrollmentType = enrollmentType + 64L;
                    }
                    if (isRadiusReg) {
                        enrollmentType = enrollmentType + 128L;
                    }
                    if (isPushReg) {
                        enrollmentType = enrollmentType + 256L;
                    }
                    if (isFPAuthReg) {
                        enrollmentType = enrollmentType + 512L;
                    }
                    if (isQRAuthReg) {
                        enrollmentType = enrollmentType + 1024L;
                    }
                    if (isTotpAuthReg) {
                        enrollmentType = enrollmentType + 2048L;
                    }
                    EnrollmentHandler.updateEnrollmentType(loginId, enrollmentType);
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return isEnrolled;
    }

    public static boolean isEnrolled(String sAMAccountName, String domainName) {
        Long loginId = null;
        try {
            Row row;
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)sAMAccountName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
            if (!dataObject.isEmpty() && (row = dataObject.getFirstRow("AaaLogin")) != null) {
                loginId = (Long)row.get("LOGIN_ID");
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        boolean isEnroll = EnrollmentHandler.isEnrolled(loginId).equals("true");
        return isEnroll;
    }

    public static boolean isEnrolled(String samAccName, String domainName, String domainDnsName) {
        Long loginId = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)samAccName, 0, false);
            if (domainDnsName != null && !domainDnsName.equals("")) {
                String tableName = "ADSMDomainConfiguration";
                Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_DNS_NAME"), (Object)domainDnsName, 0, false);
                c.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_FLAT_NAME"), (Object)domainName, 0, false));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get(tableName, c);
                if (!dataObj.isEmpty()) {
                    Row r = dataObj.getFirstRow(tableName);
                    domainName = (String)r.get("DOMAIN_NAME");
                }
            }
            crit = crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false));
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Join j = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPUserPropertyMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 2);
            sq.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            sq.addSelectColumn(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"));
            sq.addJoin(j);
            sq.setCriteria(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Row row = obj.getFirstRow("AaaLogin");
            if (row != null) {
                loginId = (Long)row.get("LOGIN_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean isEnroll = EnrollmentHandler.isEnrolled(loginId).equals("true");
        return isEnroll;
    }

    public static void setEnrolled(Long loginId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", c);
            ProfileBuilder.updateEnrollStatusDO(obj, loginId);
            CommonUtil.getPersistenceLite().update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setEnrolledforDuo(Long loginId) {
        try {
            Long time = System.currentTimeMillis();
            Criteria c = new Criteria(Column.getColumn((String)"SSPDuoAuthenticator", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPDuoAuthenticator", c);
            Row row = obj.getRow("SSPDuoAuthenticator", c);
            if (row == null) {
                row = new Row("SSPDuoAuthenticator");
                row.set("ENROLLED_TIME", (Object)time);
                row.set("USER_LOGIN_ID", (Object)loginId);
                obj.addRow(row);
            } else {
                row.set("MODIFIED_TIME", (Object)time);
                obj.updateRow(row);
            }
            CommonUtil.getPersistenceLite().update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isRegistered(HttpServletRequest request, Long loginId, Long identityId) {
        if (identityId.equals(IdentityVerifyHandler.SQA_VERIFICATION_ID)) {
            return EnrollmentHandler.isUserQExist(loginId);
        }
        if (identityId.equals(IdentityVerifyHandler.CODE_VERIFICATION_ID)) {
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
            String logonName = domainDetails.getProperty("LOGIN_NAME");
            Hashtable policyHash = PolicyHandler.checkPermission(domainName, logonName);
            Long policyId = (Long)policyHash.get("policyId");
            return EnrollmentHandler.isVCRegistered(loginId, policyId, logonName, domainName);
        }
        if (identityId.equals(IdentityVerifyHandler.AUTHENTICATOR_VERIFICATION_ID)) {
            return EnrollmentHandler.isMobAuthRegistered(loginId);
        }
        if (identityId.equals(IdentityVerifyHandler.DUO_VERIFICATION_ID)) {
            return EnrollmentHandler.isDuoEnrollmentRegistered(loginId);
        }
        if (identityId.equals(IdentityVerifyHandler.RSA_VERIFICATION_ID) || identityId.equals(IdentityVerifyHandler.RADIUS_VERIFICATION_ID)) {
            return true;
        }
        if (identityId.equals(IdentityVerifyHandler.PN_VERIFICATION_ID)) {
            try {
                JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(request, loginId);
                return mobileAppAuth.getString("PUSH_NOTIFICATION_AUTH").equals("true");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (identityId.equals(IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID)) {
            try {
                JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(request, loginId);
                return mobileAppAuth.getString("FINGER_PRINT_AUTH").equals("true");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (identityId.equals(IdentityVerifyHandler.QR_CODE_VERIFICATION_ID)) {
            try {
                JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(request, loginId);
                return mobileAppAuth.getString("QR_CODE_AUTH").equals("true");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        } else if (identityId.equals(IdentityVerifyHandler.TOTP_VERIFICATION_ID)) {
            try {
                JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(request, loginId);
                return mobileAppAuth.getString("TOTP_AUTH").equals("true");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return false;
    }

    public static boolean isMobAuthRegistered(Long loginId) {
        String tableName = "SSPMobileAuthenticator";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            return !dobj.isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static Boolean isUserQExist(Long loginId) {
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"AaaLogin"));
            Join j = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPBuildInQAMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1);
            Join join = new Join(Table.getTable((String)"AaaLogin"), Table.getTable((String)"SSPCustomQAMap"), new String[]{"LOGIN_ID"}, new String[]{"USER_LOGIN_ID"}, 1);
            sq.addSelectColumn(new Column(null, "*"));
            sq.addJoin(j);
            sq.addJoin(join);
            Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0);
            sq.setCriteria(c);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (o.size("SSPBuildInQAMap") > 0) {
                return true;
            }
            if (o.size("SSPCustomQAMap") > 0) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void verifyVCRegistration(Hashtable vcParams) {
        try {
            Long loginId = (Long)vcParams.get("LOGIN_ID");
            Long policyId = (Long)vcParams.get("POLICY_ID");
            String domainName = (String)vcParams.get("DOMAIN_NAME");
            String logonName = (String)vcParams.get("LOGON_NAME");
            boolean isReg = false;
            JSONObject json = new JSONObject();
            try {
                String[] notIds = new String[]{Long.toString(4L), Long.toString(5L)};
                Hashtable notify = APCUtil.getPolNotVals(policyId, notIds);
                Long isMailEnabled = (Long)((Hashtable)notify.get(4L)).get("ENABLED");
                Long isSmsEnabled = (Long)((Hashtable)notify.get(5L)).get("ENABLED");
                json = APCModuleHandler.getModuleFlagValues(policyId, "VERIFICATION_CODE");
                boolean secMailForced = isMailEnabled.equals(1L) && ((String)json.get("FORCE_SEC_MAIL")).equals("1");
                boolean secMobForced = isSmsEnabled.equals(1L) && ((String)json.get("FORCE_SEC_MOBILE")).equals("1");
                Properties properties = new Properties();
                ArrayList mailList = new ArrayList();
                ArrayList mobileList = new ArrayList();
                if (isMailEnabled.equals(1L) && isSmsEnabled.equals(1L)) {
                    properties = SecondaryAttributesHandler.getNotificationAttributes(logonName, domainName);
                } else if (isMailEnabled.equals(1L) || isSmsEnabled.equals(1L)) {
                    String attributeType = isMailEnabled.equals(1L) ? "MAIL" : "MOBILE";
                    properties = SecondaryAttributesHandler.getNotificationAttributes(logonName, domainName, attributeType);
                }
                ArrayList adMobList = new ArrayList();
                ArrayList adMailList = new ArrayList();
                if (properties.get("MOBILE_NUMBERS") != null) {
                    adMobList = (ArrayList)properties.get("MOBILE_NUMBERS");
                }
                if (properties.get("MAIL_IDS") != null) {
                    adMailList = (ArrayList)properties.get("MAIL_IDS");
                }
                boolean isMailReg = false;
                boolean isMobReg = false;
                String[] ele = new String[]{"EMAIL_ADDRESSES", "MOBILE_NUMBERS"};
                Hashtable secMailMob = UserUtil.getUserPersonal(loginId, ele);
                isMailReg = isMailEnabled.equals(1L) && (!adMailList.isEmpty() || secMailMob.get(ele[0]) != null && !secMailMob.get(ele[0]).equals("")) && (!secMailForced || secMailForced && secMailMob.get(ele[0]) != null && !secMailMob.get(ele[0]).equals(""));
                boolean bl = isMobReg = isSmsEnabled.equals(1L) && (!adMobList.isEmpty() || secMailMob.get(ele[1]) != null && !secMailMob.get(ele[1]).equals("")) && (!secMobForced || secMobForced && secMailMob.get(ele[1]) != null && !secMailMob.get(ele[1]).equals(""));
                isReg = secMailForced && secMobForced ? isMailReg && isMobReg : (secMailForced ? isMailReg : (secMobForced ? isMobReg : isMailReg || isMobReg));
                vcParams.put("IS_VCREGISTERED", isReg);
                Long enrollmentType = 0L;
                if (isReg) {
                    if (isMailReg) {
                        enrollmentType = enrollmentType + 4L;
                    }
                    if (isMobReg) {
                        enrollmentType = enrollmentType + 8L;
                    }
                }
                vcParams.put("ENROLLMENT_TYPE", enrollmentType);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isVCRegistered(Long loginId, Long policyId, String logonName, String domainName) {
        Boolean isReg = false;
        Hashtable<String, Object> vcParams = new Hashtable<String, Object>();
        try {
            vcParams.put("LOGIN_ID", loginId);
            vcParams.put("POLICY_ID", policyId);
            vcParams.put("LOGON_NAME", logonName);
            vcParams.put("DOMAIN_NAME", domainName);
            EnrollmentHandler.verifyVCRegistration(vcParams);
            isReg = (Boolean)vcParams.get("IS_VCREGISTERED");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isReg;
    }

    public static boolean isVCSecMailRegistered(Long loginId) {
        boolean ret = false;
        try {
            Hashtable secMail = UserUtil.getUserPersonal(loginId, new String[]{"EMAIL_ADDRESSES"});
            ret = secMail.get("EMAIL_ADDRESSES") != null && !"".equals(secMail.get("EMAIL_ADDRESSES"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static boolean isVCSecMobRegistered(Long loginId) {
        boolean ret = false;
        try {
            Hashtable secMob = UserUtil.getUserPersonal(loginId, new String[]{"MOBILE_NUMBERS"});
            ret = secMob.get("MOBILE_NUMBERS") != null && !"".equals(secMob.get("MOBILE_NUMBERS"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getEnrollmentType(Long loginId) {
        Long enrollmentType = 0L;
        JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(loginId);
        try {
            if (EnrollmentHandler.isUserQExist(loginId).booleanValue()) {
                enrollmentType = enrollmentType + 2L;
            }
            if (EnrollmentHandler.isVCSecMailRegistered(loginId)) {
                enrollmentType = enrollmentType + 4L;
            }
            if (EnrollmentHandler.isVCSecMobRegistered(loginId)) {
                enrollmentType = enrollmentType + 8L;
            }
            if (EnrollmentHandler.isMobAuthRegistered(loginId)) {
                enrollmentType = enrollmentType + 16L;
            }
            if (EnrollmentHandler.isDuoEnrollmentRegistered(loginId)) {
                enrollmentType = enrollmentType + 32L;
            }
            if (mobileAppAuth.getString("PUSH_NOTIFICATION_AUTH").equals("true")) {
                enrollmentType = enrollmentType + 256L;
            }
            if (mobileAppAuth.getString("FINGER_PRINT_AUTH").equals("true")) {
                enrollmentType = enrollmentType + 512L;
            }
            if (mobileAppAuth.getString("QR_CODE_AUTH").equals("true")) {
                enrollmentType = enrollmentType + 1024L;
            }
            if (mobileAppAuth.getString("TOTP_AUTH").equals("true")) {
                enrollmentType = enrollmentType + 2048L;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return enrollmentType;
    }

    public static void updateEnrollmentType(Long loginId, Long enrollmentType) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", c);
            if (obj.isEmpty()) {
                Row row = new Row("SSPUserPropertyMap");
                row.set("ENROLLED_TIME", (Object)System.currentTimeMillis());
                row.set("USER_LOGIN_ID", (Object)loginId);
                row.set("REGISTRATION_STATUS", (Object)new Integer(1));
                row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                obj.addRow(row);
            } else {
                Row row = obj.getFirstRow("SSPUserPropertyMap");
                row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                obj.updateRow(row);
            }
            CommonUtil.getPersistenceLite().update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isDuoEnrollmentRegistered(Long loginId) {
        boolean ret = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPDuoAuthenticator", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get("SSPDuoAuthenticator", crit);
            return !dobj.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return ret;
        }
    }

    public static Hashtable getEnrollmentMethodsStatus(Long loginId, HttpServletRequest request) {
        Hashtable hash = new Hashtable();
        String isEnrolled = "false";
        ArrayList<String> yetToEnrollList = new ArrayList<String>();
        ArrayList<String> EnrolledList = new ArrayList<String>();
        try {
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            if (!domainDetails.isEmpty()) {
                String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
                String logonName = domainDetails.getProperty("LOGIN_NAME");
                Hashtable policyHash = PolicyHandler.checkPermission(domainName, logonName);
                Long policyId = (Long)policyHash.get("policyId");
                Hashtable<String, Object> vcParams = new Hashtable<String, Object>();
                vcParams.put("LOGIN_ID", loginId);
                vcParams.put("POLICY_ID", policyId);
                vcParams.put("LOGON_NAME", logonName);
                vcParams.put("DOMAIN_NAME", domainName);
                EnrollmentHandler.verifyVCRegistration(vcParams);
                JSONObject regData = EnrollmentHandler.getEnrollmentData(logonName, domainName, loginId, policyId, request);
                isEnrolled = (String)regData.get("isEnrolled");
                boolean isVCReg = (Boolean)regData.get("isVCReg") != false && (Boolean)vcParams.get("IS_VCREGISTERED") != false;
                boolean[] regIds = new boolean[]{(Boolean)regData.get("isSQAReg"), isVCReg, (Boolean)regData.get("isAuthReg"), (Boolean)regData.get("isDuoReg"), (Boolean)regData.get("isRSAReg"), (Boolean)regData.get("isRadiusReg"), (Boolean)regData.get("isPushReg"), (Boolean)regData.get("isFingerprintReg"), (Boolean)regData.get("isQRReg"), (Boolean)regData.get("isTotpReg")};
                boolean isIdentityForced = (Boolean)regData.get("isIdentityForced");
                ArrayList verifyIds = IdentityVerifyHandler.getMandatoryVerifyList(policyId, request, false);
                Long[] allIDs = new Long[]{IdentityVerifyHandler.SQA_VERIFICATION_ID, IdentityVerifyHandler.CODE_VERIFICATION_ID, IdentityVerifyHandler.AUTHENTICATOR_VERIFICATION_ID, IdentityVerifyHandler.DUO_VERIFICATION_ID, IdentityVerifyHandler.RSA_VERIFICATION_ID, IdentityVerifyHandler.RADIUS_VERIFICATION_ID, IdentityVerifyHandler.PN_VERIFICATION_ID, IdentityVerifyHandler.FINGER_PRINT_VERIFICATION_ID, IdentityVerifyHandler.QR_CODE_VERIFICATION_ID, IdentityVerifyHandler.TOTP_VERIFICATION_ID};
                String[] enrollmentMethods = new String[]{"adssp.reports.enrolled_rep.sqa", "adssp.domainuser.selfservice.linkaccounts.verification_code", "adssp.domain_user.enrollment.auth.heading", "adssp.admin.policies.identity_verify.authenticator_duo", "adssp.login.tfa.rsa_heading", "adssp.login.tfa.radius_heading", "adssp.enrollment.push_notification_auth.heading", "adssp.enrollment.finger_print_auth.heading", "adssp.enrollment.qr_code_auth.heading", "adssp.enrollment.totp_auth.heading"};
                if (isEnrolled.equals("true") && isIdentityForced) {
                    for (int i = 0; i < regIds.length; ++i) {
                        if (regIds[i]) {
                            EnrolledList.add(enrollmentMethods[i]);
                            continue;
                        }
                        if (!verifyIds.contains(allIDs[i])) continue;
                        yetToEnrollList.add(enrollmentMethods[i]);
                    }
                }
            }
            hash.put("ENROLLED", EnrolledList);
            hash.put("YET_TO_ENROLL", yetToEnrollList);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return hash;
    }

    public static Long getPrevEnrolledValue(String uniqueToken, Long loginId) {
        try {
            if (uniqueToken != null && !uniqueToken.equals("")) {
                Iterator it;
                Criteria cri = new Criteria(new Column("SSPMobileOneAuthEnrollment", "USER_LOGIN_ID"), (Object)loginId, 0);
                cri = cri.and(new Criteria(new Column("SSPMobileOneAuthEnrollment", "UNIQUE_TOKEN"), (Object)uniqueToken, 0));
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPMobileOneAuthEnrollment", cri);
                if (!dataObj.isEmpty() && (it = dataObj.getRows("SSPMobileOneAuthEnrollment")).hasNext()) {
                    Row row = (Row)it.next();
                    return (Long)row.get("ENROLLED_MODES");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return 0L;
    }

    public static void registerMobileOneAuth(HttpServletRequest request, Long loginId) {
        try {
            JSONArray modeProps = MobileOneAuthHandler.getOneAuthProps();
            String uniqueToken = request.getParameter("ONE_AUTH_UNIQUE_TOKEN");
            Long prevValue = EnrollmentHandler.getPrevEnrolledValue(uniqueToken, loginId);
            Long bitVal = 0L;
            for (int i = 0; i < modeProps.length(); ++i) {
                String modeVal;
                JSONObject mode = modeProps.getJSONObject(i);
                String modeName = mode.getString("MODE_NAME");
                Long modeId = mode.getLong("MODE_ID");
                Long modePos = MobileOneAuthHandler.getModePos(modeId);
                String string = request.getParameter(modeName) != null ? (request.getParameter(modeName).equals("1") ? "1" : "0") : (modeVal = MobileOneAuthHandler.getBitValue(modePos, prevValue));
                if (!modeVal.equals("1")) continue;
                bitVal = bitVal | (long)(1 << (int)modePos.longValue());
            }
            EnrollmentHandler.updateOneAuthEnrollmentStatus(request, uniqueToken, loginId, bitVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateOneAuthEnrollmentStatus(HttpServletRequest request, String uniqueToken, Long loginId, Long bitVal) {
        String oneAuthUniqueToken = uniqueToken;
        try {
            String deviceId = request.getParameter("DEVICE_ID");
            Criteria cri = new Criteria(new Column("SSPMobileOneAuthEnrollment", "UNIQUE_TOKEN"), (Object)oneAuthUniqueToken, 0);
            cri = cri.and(new Criteria(new Column("SSPMobileOneAuthEnrollment", "USER_LOGIN_ID"), (Object)loginId, 0));
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPMobileOneAuthEnrollment", cri);
            Long currentTime = System.currentTimeMillis();
            if (dataObject.isEmpty()) {
                dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                oneAuthUniqueToken = MobileOneAuthHandler.getUniqueToken();
                Row row = new Row("SSPMobileOneAuthEnrollment");
                row.set("USER_LOGIN_ID", (Object)loginId);
                row.set("UNIQUE_TOKEN", (Object)oneAuthUniqueToken);
                row.set("ENROLLED_MODES", (Object)bitVal);
                row.set("DEVICE_ID", (Object)deviceId);
                row.set("ENROLLED_TIME", (Object)currentTime);
                dataObject.addRow(row);
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            } else {
                Iterator it = dataObject.getRows("SSPMobileOneAuthEnrollment");
                Long enrolledTime = 0L;
                if (it.hasNext()) {
                    Row r = (Row)it.next();
                    enrolledTime = (Long)r.get("ENROLLED_TIME");
                }
                Row row = new Row("SSPMobileOneAuthEnrollment");
                row.set("USER_LOGIN_ID", (Object)loginId);
                row.set("UNIQUE_TOKEN", (Object)oneAuthUniqueToken);
                row.set("DEVICE_ID", (Object)deviceId);
                row.set("ENROLLED_MODES", (Object)bitVal);
                row.set("ENROLLED_TIME", (Object)enrolledTime);
                row.set("MODIFIED_TIME", (Object)currentTime);
                dataObject.updateRow(row);
                CommonUtil.getPersistence(new boolean[0]).update(dataObject);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        request.setAttribute("ONE_AUTH_UNIQUE_TOKEN", (Object)oneAuthUniqueToken);
    }

    public static JSONObject getEnrollmentData(String logonName, String domainName, Long loginId, Long policyId, HttpServletRequest request) {
        String isEnrolled = "";
        JSONObject regData = new JSONObject();
        try {
            ArrayList verifyIds = IdentityVerifyHandler.getMandatoryVerifyList(policyId, request, false);
            boolean isIdentityForced = verifyIds.size() != 0;
            JSONObject json = APCModuleHandler.getModuleFlagValues(policyId, "ID_VERIFICATIONS");
            JSONObject mobileAppAuth = MobileOneAuthHandler.getMobileAppAuthRegValues(request, loginId);
            boolean isVCReg = json.getString("VERIFICATION_CODE").equals("1");
            boolean isSQAReg = json.getString("SECURITY_QA_AUTH").equals("1") && EnrollmentHandler.isUserQExist(loginId) != false;
            boolean isAuthReg = json.getString("ENABLE_MOBILE_AUTH").equals("1") && EnrollmentHandler.isMobAuthRegistered(loginId);
            boolean isDuoReg = json.getString("DUO_WEB").equals("1") && EnrollmentHandler.isDuoEnrollmentRegistered(loginId);
            boolean isRSAReg = json.getString("RSA").equals("1");
            boolean isRadiusReg = json.getString("RADIUS").equals("1");
            boolean isPushAuthReg = json.getString("PUSH_NOTIFICATION_AUTH").equals("1") && mobileAppAuth.getString("PUSH_NOTIFICATION_AUTH").equals("true");
            boolean isFPAuthReg = json.getString("FINGER_PRINT_AUTH").equals("1") && mobileAppAuth.getString("FINGER_PRINT_AUTH").equals("true");
            boolean isQRAuthReg = json.getString("QR_CODE_AUTH").equals("1") && mobileAppAuth.getString("QR_CODE_AUTH").equals("true");
            boolean isTotpAuthReg = json.getString("TOTP_AUTH").equals("1") && mobileAppAuth.getString("TOTP_AUTH").equals("true");
            Criteria crit = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("SSPUserPropertyMap", crit);
                Integer regStatus = (Integer)r.get("REGISTRATION_STATUS");
                if (regStatus.equals(1)) {
                    isEnrolled = "true";
                }
            } else {
                isEnrolled = isSQAReg || isAuthReg || isVCReg || isRSAReg || isDuoReg || isRadiusReg || isPushAuthReg || isFPAuthReg || isQRAuthReg || isTotpAuthReg ? "true" : "false";
            }
            regData.put("isEnrolled", (Object)isEnrolled);
            regData.put("isVCReg", isVCReg);
            regData.put("isSQAReg", isSQAReg);
            regData.put("isAuthReg", isAuthReg);
            regData.put("isDuoReg", isDuoReg);
            regData.put("isRSAReg", isRSAReg);
            regData.put("isRadiusReg", isRadiusReg);
            regData.put("isPushReg", isPushAuthReg);
            regData.put("isFingerprintReg", isFPAuthReg);
            regData.put("isQRReg", isQRAuthReg);
            regData.put("isTotpReg", isTotpAuthReg);
            regData.put("isIdentityForced", isIdentityForced);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return regData;
    }
}

