/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.TechnicianUtil;
import com.manageengine.ads.fw.iamapps.handler.sso.SSOSAMLHandler;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import jespa.http.HttpSecurityService;
import org.json.JSONObject;

public class FilterHandler {
    private static Logger logger = Logger.getLogger(FilterHandler.class.getName());
    private static FilterHandler handler = null;
    private static Properties uRLVsActionIds = null;
    private JSONObject domainVsService = new JSONObject();
    public final String[] defaultAllowedURLs = new String[]{"/login.cc", "/showLogin.cc", "/adminLogin.cc", "/errorPage.cc", "/AccountsSignOut.cc", "/404Error.cc", "/UnAuthAction.cc", "/OrgChartLink.cc", "/authorization.do", "/logout.do", "/home.do", "/inputDC.do", "/errorPage.do", "/404Error.do", "/AgentStatusUpdate.cc", "/UserMustChangePwd.cc", "/umcpLogin.cc", "/GinaProfessionalPage.do", "/GinaProfessionalPage.cc", "/checkURL.do", "/CheckEnrollment.cc", "/inputDC.do", "/RestAPIResponse.do", "/LoadFrame.do", "/JumpToAction.do", "/PasswordSelfService.do", "/mPasswordSelfService.do", "/mSessionExpiry.do", "/twofactor.cc", "/mTwofactor.cc", "/PasswordPolicyEnforcer.cc", "/AccountSession.cc"};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static FilterHandler getInstance() {
        if (handler != null) return handler;
        Class<FilterHandler> clazz = FilterHandler.class;
        synchronized (FilterHandler.class) {
            if (handler != null) return handler;
            handler = new FilterHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return handler;
        }
    }

    private FilterHandler() {
    }

    public boolean isAuthorizedURL(String path, HttpServletRequest servletReq) {
        if (path.endsWith(".cc")) {
            path.replace(".cc", ".do");
        }
        if (uRLVsActionIds == null) {
            uRLVsActionIds = TechnicianUtil.getURLVsActionIds(servletReq);
        }
        ArrayList roleActionsList = ADMPUserHandler.getRoleActions(servletReq);
        String getActionIdOfPath = uRLVsActionIds.getProperty(path);
        if (getActionIdOfPath != null) {
            long actionId = Long.valueOf(getActionIdOfPath);
            if (roleActionsList.contains(actionId)) {
                return true;
            }
            logger.log(Level.INFO, "Not Authorized URL :: ", path);
            return false;
        }
        return true;
    }

    public Hashtable getESAndOCProps(Long spId) {
        Hashtable<String, Object> ESAndOCProps = new Hashtable<String, Object>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMSearchProfile", (String)"SEARCH_PROFILE_ID"), (Object)spId, 0);
            DataObject dataObj = CommonUtil.getCachedPersistence().get("ADSMSearchProfile", crit);
            Row row = dataObj.getFirstRow("ADSMSearchProfile");
            ESAndOCProps.put("IS_ENABLED", row.get("IS_ENABLED"));
            ESAndOCProps.put("SHOW_ON_LOGIN_PAGE", row.get("SHOW_ON_LOGIN_PAGE"));
            ESAndOCProps.put("ENABLE_OU_CHART", row.get("ENABLE_OU_CHART"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ESAndOCProps;
    }

    public boolean isAuthorizedURLBL(String path, HttpServletRequest request, JSONObject additionalParams) throws Exception {
        boolean isAuthorized = false;
        Hashtable searchProfile = this.getESAndOCProps(1L);
        String showOnLoginPage = (String)searchProfile.get("SHOW_ON_LOGIN_PAGE");
        if (path.equals("/OrganizationChart.cc")) {
            String isOCEnabled = (String)searchProfile.get("ENABLE_OU_CHART");
            if (isOCEnabled.equals("1") && showOnLoginPage.equals("1")) {
                isAuthorized = true;
            }
        } else if (path.equals("/EmployeeSearch.cc") || path.equals("/EmpSearch.cc")) {
            String isESEnabled = (String)searchProfile.get("IS_ENABLED");
            if (isESEnabled.equals("1") && showOnLoginPage.equals("1")) {
                isAuthorized = true;
            }
        } else if (path.equals("/LanguageList.cc") || path.contains("/SSOSAMLAuthenticator.cc") || path.contains("iamapps/ssologout")) {
            isAuthorized = true;
        } else if (path.contains("iamapps/ssologin")) {
            isAuthorized = SSOSAMLHandler.isValidToSAMLLogin((HttpServletRequest)request, (JSONObject)additionalParams);
        }
        return isAuthorized;
    }

    public HttpSecurityService getNTLMService(String domain) {
        HttpSecurityService service = null;
        try {
            if (this.domainVsService.has(domain)) {
                service = (HttpSecurityService)this.domainVsService.get(domain);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return service;
    }

    public void setNTLMService(String domain, HttpSecurityService service) {
        try {
            if (this.domainVsService.has(domain)) {
                try {
                    ((HttpSecurityService)this.domainVsService.get(domain)).destroy();
                }
                catch (Exception e) {
                    logger.log(Level.INFO, "Exception in destroying jespa service : " + e.getMessage());
                }
                this.domainVsService.remove(domain);
            }
            if (service != null) {
                this.domainVsService.put(domain, (Object)service);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setSAMLSSOProps(HttpServletRequest request, JSONObject samlSSOAttribs) {
        try {
            HttpSession sess = request.getSession();
            Iterator it = samlSSOAttribs.keys();
            while (it.hasNext()) {
                String samlProp = (String)it.next();
                sess.setAttribute(samlProp, samlSSOAttribs.get(samlProp));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

