/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.ADHandler;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.ModificationRuleHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.usermanagement.AddUserHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class LayoutHandler {
    public static final int TEXT_BOX = 1;
    public static final int TEXT_AREA = 2;
    public static final int DROP_DOWN = 3;
    public static final int CHECK_BOX = 4;
    public static final int RADIO_BUTTON = 5;
    public static final int BUILD_IN = 6;
    public static final int PHOTO_UPLOAD_ATTRIB = 1956;
    public static final int UPDATE_JPEG_ATTRIB = 1957;
    public static final int FORCE_UPDATE = 1958;
    public static final int EMAIL_VALIDATION = 2;
    public static final int PHOTO_NUM_VALIDATION = 4;
    public static final int NUMBER_VALIDATION = 8;
    public static final int LETTER_VALIDATION = 16;
    public static final String SU_LAYOUT_TABLE = "SULayout";
    private static Logger logger = Logger.getLogger("serverout");
    public static final Integer GROUP_OBJECT_TYPE_ID = 1;
    public static final Integer USER_OBJECT_TYPE_ID = 2;
    public static final Integer OU_OBJECT_TYPE_ID = 3;
    public static final Integer COMPUTER_OBJECT_TYPE_ID = 4;
    public static final Integer DOMAIN_OBJECT_TYPE_ID = 5;

    public static HashMap getLayouts() {
        LinkedHashMap<String, JSONObject> lNProps = new LinkedHashMap<String, JSONObject>();
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)SU_LAYOUT_TABLE));
            sq.addSelectColumn(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"));
            sq.addSelectColumn(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_NAME"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), true));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Iterator it = obj.getRows(SU_LAYOUT_TABLE);
            while (it.hasNext()) {
                JSONObject lNObj = new JSONObject();
                Row r = (Row)it.next();
                lNObj.put("LAYOUT_ID", (Object)((Long)r.get("LAYOUT_ID")));
                lNObj.put("LAYOUT_NAME", (Object)((String)r.get("LAYOUT_NAME")));
                lNProps.put(((Long)r.get("LAYOUT_ID")).toString(), lNObj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return lNProps;
    }

    public static JSONObject getPolicyLayoutDetails() throws JSONException {
        JSONObject lNProps;
        block7: {
            lNProps = new JSONObject();
            JSONObject policyVsLayout = new JSONObject();
            ArrayList<Long> appliedLayoutIds = new ArrayList<Long>();
            ArrayList<Long> layoutIds = new ArrayList<Long>();
            try {
                SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)SU_LAYOUT_TABLE));
                sq.addSelectColumn(new Column(null, "*"));
                sq.addSortColumn(new SortColumn(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), true));
                sq.addJoin(new Join(Table.getTable((String)SU_LAYOUT_TABLE), Table.getTable((String)"PolicySULayout"), new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"PolicySULayout"), Table.getTable((String)"PolicyConfiguration"), new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 1));
                DataObject obj = CommonUtil.getPersistenceLite().get((SelectQuery)sq);
                Iterator it = obj.getRows(SU_LAYOUT_TABLE);
                while (it.hasNext()) {
                    JSONObject lNObj = new JSONObject();
                    Row r = (Row)it.next();
                    Long layoutId = (Long)r.get("LAYOUT_ID");
                    layoutIds.add(layoutId);
                    lNObj.put("LAYOUT_ID", (Object)layoutId);
                    lNObj.put("LAYOUT_NAME", (Object)((String)r.get("LAYOUT_NAME")));
                    lNObj.put("CREATED_TIME", (Object)((Long)r.get("CREATED_TIME")));
                    lNObj.put("MODIFIED_TIME", (Object)((Long)r.get("MODIFIED_TIME")));
                    Criteria crit = new Criteria(Column.getColumn((String)"PolicySULayout", (String)"LAYOUT_ID"), (Object)layoutId, 0);
                    StringBuilder policiesTxt = new StringBuilder();
                    Iterator itr = obj.getRows("PolicySULayout", crit);
                    while (itr.hasNext()) {
                        if (!appliedLayoutIds.contains(layoutId)) {
                            appliedLayoutIds.add(layoutId);
                        }
                        Row row = (Row)itr.next();
                        Long policyId = (Long)row.get("POLICY_ID");
                        Criteria policyCrit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
                        Row policyRow = obj.getRow("PolicyConfiguration", policyCrit);
                        String policyName = (String)policyRow.get("POLICY_NAME");
                        policiesTxt.append(policyName).append(",");
                        policyVsLayout.put(policyId.toString(), (Object)layoutId.toString());
                    }
                    if (policiesTxt.length() > 0) {
                        policiesTxt.setLength(policiesTxt.length() - 1);
                    } else {
                        policiesTxt.append("-");
                    }
                    lNObj.put("APPLIED_POLICIES_TEXT", (Object)policiesTxt);
                    lNProps.put(layoutId.toString(), (Object)lNObj.toString());
                    lNProps.put("POLICY_VS_LAYOUT", (Object)policyVsLayout);
                    lNProps.put("APPLIED_LAYOUTS", appliedLayoutIds);
                    lNProps.put("LAYOUT_IDS", layoutIds);
                    lNProps.put("STATUS", (Object)"SUCCESS");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (e.getMessage() == null) break block7;
                lNProps.put("STATUS", (Object)e.getMessage());
            }
        }
        return lNProps;
    }

    public static JSONObject getLayoutByName(String layoutName) {
        JSONObject layoutDetails = null;
        try {
            DataObject layoutObjs = CommonUtil.getPersistence(new boolean[0]).get(SU_LAYOUT_TABLE, new Criteria(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_NAME"), (Object)layoutName, 0, false));
            if (!layoutObjs.isEmpty()) {
                layoutDetails = new JSONObject();
                Row r = layoutObjs.getFirstRow(SU_LAYOUT_TABLE);
                layoutDetails.put("LAYOUT_ID", (Object)((Long)r.get("LAYOUT_ID")));
                layoutDetails.put("LAYOUT_NAME", (Object)((String)r.get("LAYOUT_NAME")));
                layoutDetails.put("CREATED_TIME", (Object)((Long)r.get("CREATED_TIME")));
                layoutDetails.put("MODIFIED_TIME", (Object)((Long)r.get("MODIFIED_TIME")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layoutDetails;
    }

    public static boolean isManagerSearchAllowed(Long layoutID) {
        boolean isManagerSearchAllowed = false;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("SUSections"));
            sq.addJoin(new Join(Table.getTable((String)"SUSections"), Table.getTable((String)"SUFields"), new String[]{"SECTION_ID"}, new String[]{"SECTION_ID"}, 1));
            Criteria crit = new Criteria(Column.getColumn((String)"SUSections", (String)"LAYOUT_ID"), (Object)layoutID, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SUFields", (String)"ATTRIB_ACTION_ID"), (Object)1213L, 0));
            crit = crit.and(new Criteria(Column.getColumn((String)"SUFields", (String)"FIELD_ID"), (Object)6L, 0));
            sq.setCriteria(crit);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            DataObject obj = CommonUtil.getPersistenceLite().get((SelectQuery)sq);
            if (!obj.isEmpty()) {
                isManagerSearchAllowed = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isManagerSearchAllowed;
    }

    public static Hashtable getLayoutDetails(HashMap layoutProps) {
        Hashtable<String, Object> hash;
        block38: {
            hash = new Hashtable<String, Object>();
            try {
                Long loginId = AuthUtil.getUserCredential() != null ? AuthUtil.getUserCredential().getLoginId() : (Long)layoutProps.get("LOGIN_ID");
                Long layoutID = (Long)layoutProps.get("LAYOUT_ID");
                Boolean adminView = (Boolean)layoutProps.get("ADMIN_VIEW");
                AdventNetResourceBundle rb = (AdventNetResourceBundle)layoutProps.get("RESOURCE_BUNDLE");
                ArrayList<Long> actionList = new ArrayList<Long>();
                ArrayList<Long> mandatoryAttribs = new ArrayList<Long>();
                DataObject aNameObj = CommonUtil.getPersistence(new boolean[0]).get("ADSMAttributeDetails", (Criteria)null);
                String layoutName = "";
                Criteria lC = new Criteria(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), (Object)layoutID, 0);
                SelectQueryImpl sq = new SelectQueryImpl(new Table(SU_LAYOUT_TABLE));
                sq.addJoin(new Join(Table.getTable((String)SU_LAYOUT_TABLE), Table.getTable((String)"SUSections"), new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)SU_LAYOUT_TABLE), Table.getTable((String)"SUNonCustomFields"), new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)SU_LAYOUT_TABLE), Table.getTable((String)"SUPhotoUploadConfig"), new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUSections"), Table.getTable((String)"SUDropDownVals"), new String[]{"SECTION_ID"}, new String[]{"SECTION_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUSections"), Table.getTable((String)"SUCheckBoxVals"), new String[]{"SECTION_ID"}, new String[]{"SECTION_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUSections"), Table.getTable((String)"SURadioButVals"), new String[]{"SECTION_ID"}, new String[]{"SECTION_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUSections"), Table.getTable((String)"SUFields"), new String[]{"SECTION_ID"}, new String[]{"SECTION_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUFields"), Table.getTable((String)"SUFieldVsDomainMapping"), new String[]{"UNIQUE_ID"}, new String[]{"UNIQUE_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUFieldVsDomainMapping"), Table.getTable((String)"SUFieldSearchContainers"), new String[]{"CONFIG_ID"}, new String[]{"CONFIG_ID"}, 1));
                sq.addJoin(new Join(Table.getTable((String)"SUFieldSearchContainers"), Table.getTable((String)"ADSMOUDetails"), new String[]{"OBJECT_VALUE"}, new String[]{"OBJECT_GUID"}, 1));
                Set<String> domainSet = PolicyHandler.getSUDomains();
                for (String domainName : domainSet) {
                    String grpTable = CommonUtil.getDomainGroupTableName(domainName);
                    sq.addJoin(new Join(Table.getTable((String)"SUFieldSearchContainers"), Table.getTable((String)grpTable), new String[]{"OBJECT_VALUE"}, new String[]{"OBJECT_GUID"}, 1));
                }
                sq.setCriteria(lC);
                sq.addSelectColumn(Column.getColumn(null, (String)"*"));
                sq.addSortColumn(new SortColumn(Column.getColumn((String)"SUSections", (String)"SECTION_SEQ"), true));
                sq.addSortColumn(new SortColumn(Column.getColumn((String)"SUFields", (String)"ATTRIB_SEQ"), true));
                DataObject lObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                if (lObj.isEmpty()) break block38;
                Row r = lObj.getFirstRow(SU_LAYOUT_TABLE);
                layoutName = rb.getString((String)r.get("LAYOUT_NAME"));
                String sIdArr = "new Array(";
                JSONObject groups = new JSONObject();
                JSONObject fields = new JSONObject();
                int index = 0;
                Iterator sIt = lObj.getRows("SUSections");
                while (sIt.hasNext()) {
                    JSONObject sN = new JSONObject();
                    Row sR = (Row)sIt.next();
                    sN.put("SECTION_NAME", (Object)rb.getString((String)sR.get("SECTION_NAME")));
                    sN.put("SECTION_SEQ", (Object)((Long)sR.get("SECTION_SEQ")));
                    if (index != 0) {
                        sIdArr = sIdArr + ",";
                    }
                    sIdArr = sIdArr + "\"" + ((Long)sR.get("SECTION_SEQ")).toString() + "\"";
                    ++index;
                    groups.put(((Long)sR.get("SECTION_SEQ")).toString(), (Object)sN.toString());
                    Criteria fC = new Criteria(Column.getColumn((String)"SUFields", (String)"SECTION_ID"), sR.get("SECTION_ID"), 0);
                    StringBuilder fAs = new StringBuilder();
                    fAs.append("[");
                    int ch = 0;
                    Iterator fIt = lObj.getRows("SUFields", fC);
                    while (fIt.hasNext()) {
                        Row fR = (Row)fIt.next();
                        List cL = fR.getColumns();
                        actionList.add((Long)fR.get("ATTRIB_ACTION_ID"));
                        if (((Boolean)fR.get("ISMANDATORY")).booleanValue()) {
                            mandatoryAttribs.add((Long)fR.get("ATTRIB_ACTION_ID"));
                        }
                        if (ch != 0) {
                            fAs.append(",");
                        }
                        JSONObject fA = new JSONObject();
                        for (int i = 0; i < cL.size(); ++i) {
                            if (((String)cL.get(i)).equals("ATTRIB_DISPLAY_TEXT")) {
                                fA.put((String)cL.get(i), (Object)rb.getString((String)fR.get((String)cL.get(i))));
                            } else {
                                fA.put((String)cL.get(i), fR.get((String)cL.get(i)));
                            }
                            if ((Long)fR.get("ATTRIB_ACTION_ID") == 1213L && "DEFAULT_VALUE".equals((String)cL.get(i))) {
                                String domName;
                                String managerDN = (String)fR.get("DEFAULT_VALUE");
                                String managerText = "";
                                try {
                                    String getDNCfromManagerDN;
                                    String dName;
                                    if (managerDN != null && managerDN.indexOf("DC=") != -1 && (dName = DomainHandler.getDomainName(getDNCfromManagerDN = managerDN.substring(managerDN.indexOf("DC="), managerDN.length()))) != null) {
                                        Hashtable<String, Object> queryData = new Hashtable<String, Object>();
                                        queryData.put("SEARCH_STRING", managerDN);
                                        queryData.put("SEARCH_COLUMNS", new String[]{"DN_STRING"});
                                        queryData.put("DOMAIN_NAME", dName);
                                        ArrayList objectList = UserUtil.getUsersList(queryData);
                                        if (!objectList.isEmpty()) {
                                            Properties userProp = (Properties)objectList.get(0);
                                            managerText = (String)userProp.get("SAM_ACCOUNT_NAME");
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                fA.put("DEFAULT_MANAGER_TEXT", (Object)managerText);
                                JSONObject managerContainers = new JSONObject();
                                Criteria domainCrit = null;
                                if (loginId != null && !ADMPRoleHandler.isADSSPUser(loginId)) {
                                    if (adminView.booleanValue()) {
                                        domainCrit = new Criteria(Column.getColumn((String)"SUFieldVsDomainMapping", (String)"DOMAIN_NAME"), (Object)DomainHandler.getDomainName(loginId), 0, false);
                                    } else {
                                        String rootDomainNamingcontext = DomainHandler.getDomainData("DOMAIN_NAME", DomainHandler.getDomainName(loginId), "ROOT_DOMAIN_NAMING_CONTEXT");
                                        ArrayList domainList = DomainHandler.getForestDomains(rootDomainNamingcontext, loginId);
                                        for (Properties domainProp : domainList) {
                                            domName = domainProp.get("DOMAIN_NAME").toString();
                                            if (domainCrit == null) {
                                                domainCrit = new Criteria(Column.getColumn((String)"SUFieldVsDomainMapping", (String)"DOMAIN_NAME"), (Object)domName, 0, false);
                                                continue;
                                            }
                                            domainCrit = domainCrit.or(new Criteria(Column.getColumn((String)"SUFieldVsDomainMapping", (String)"DOMAIN_NAME"), (Object)domName, 0, false));
                                        }
                                    }
                                }
                                Iterator cItr = lObj.getRows("SUFieldVsDomainMapping", domainCrit);
                                while (cItr.hasNext()) {
                                    Row ouRow;
                                    Criteria guidCrit;
                                    String objGuid;
                                    Row contRow;
                                    JSONObject cont;
                                    JSONObject containers = new JSONObject();
                                    JSONArray containerDetails = new JSONArray();
                                    Row cRow = (Row)cItr.next();
                                    domName = (String)cRow.get("DOMAIN_NAME");
                                    String grpTable = CommonUtil.getDomainGroupTableName(domName);
                                    Long configId = (Long)cRow.get("CONFIG_ID");
                                    Criteria c = new Criteria(Column.getColumn((String)"SUFieldSearchContainers", (String)"CONFIG_ID"), (Object)configId, 0);
                                    Criteria ouCrit = new Criteria(Column.getColumn((String)"SUFieldSearchContainers", (String)"OBJECT_TYPE_ID"), (Object)OU_OBJECT_TYPE_ID, 0);
                                    Criteria grpCrit = new Criteria(Column.getColumn((String)"SUFieldSearchContainers", (String)"OBJECT_TYPE_ID"), (Object)GROUP_OBJECT_TYPE_ID, 0);
                                    Criteria domCrit = new Criteria(Column.getColumn((String)"SUFieldSearchContainers", (String)"OBJECT_TYPE_ID"), (Object)DOMAIN_OBJECT_TYPE_ID, 0);
                                    ArrayList<String> ouGuids = new ArrayList<String>();
                                    ArrayList<String> grpGuids = new ArrayList<String>();
                                    JSONArray contDetails = new JSONArray();
                                    Iterator itr = lObj.getRows("SUFieldSearchContainers", c.and(ouCrit));
                                    while (itr.hasNext()) {
                                        cont = new JSONObject();
                                        contRow = (Row)itr.next();
                                        objGuid = (String)contRow.get("OBJECT_VALUE");
                                        ouGuids.add(objGuid);
                                        guidCrit = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)objGuid, 0, false);
                                        if (lObj.getRow("ADSMOUDetails", guidCrit) == null) continue;
                                        ouRow = lObj.getRow("ADSMOUDetails", guidCrit);
                                        cont.put("OBJECT_CLASS", (Object)"ou");
                                        cont.put("OBJECT_GUID", (Object)objGuid);
                                        cont.put("OBJECT_NAME", (Object)((String)ouRow.get("NAME")));
                                        contDetails.put((Object)cont);
                                    }
                                    itr = lObj.getRows("SUFieldSearchContainers", c.and(grpCrit));
                                    while (itr.hasNext()) {
                                        cont = new JSONObject();
                                        contRow = (Row)itr.next();
                                        objGuid = (String)contRow.get("OBJECT_VALUE");
                                        grpGuids.add(objGuid);
                                        guidCrit = new Criteria(Column.getColumn((String)grpTable, (String)"OBJECT_GUID"), (Object)objGuid, 0, false);
                                        if (lObj.getRow(grpTable, guidCrit) == null) continue;
                                        ouRow = lObj.getRow(grpTable, guidCrit);
                                        cont.put("OBJECT_CLASS", (Object)"group");
                                        cont.put("OBJECT_GUID", (Object)objGuid);
                                        cont.put("OBJECT_NAME", (Object)((String)ouRow.get("DISPLAY_NAME")));
                                        contDetails.put((Object)cont);
                                    }
                                    itr = lObj.getRows("SUFieldSearchContainers", c.and(domCrit));
                                    JSONArray domDetails = new JSONArray();
                                    if (itr.hasNext()) {
                                        contRow = (Row)itr.next();
                                        String domainName = (String)contRow.get("OBJECT_VALUE");
                                        domDetails.put((Object)domainName);
                                        JSONObject cont2 = new JSONObject();
                                        cont2.put("OBJECT_CLASS", (Object)"domain");
                                        cont2.put("OBJECT_GUID", (Object)domainName);
                                        cont2.put("OBJECT_NAME", (Object)domainName);
                                        contDetails.put((Object)cont2);
                                    }
                                    if (domDetails.length() > 0) {
                                        containers.put(DOMAIN_OBJECT_TYPE_ID.toString(), (Object)domDetails);
                                    }
                                    containers.put(OU_OBJECT_TYPE_ID.toString(), ouGuids);
                                    containers.put(GROUP_OBJECT_TYPE_ID.toString(), grpGuids);
                                    containers.put("CONTAINER_DETAILS", (Object)contDetails);
                                    managerContainers.put(domName, (Object)containers);
                                }
                                fA.put("MANAGER_CONTAINERS", (Object)managerContainers);
                            }
                            if (!((String)cL.get(i)).equals("ATTRIB_ACTION_ID")) continue;
                            Criteria aNC = new Criteria(Column.getColumn((String)"ADSMAttributeDetails", (String)"MODIFY_ID"), fR.get((String)cL.get(i)), 0);
                            Row aNR = aNameObj.getRow("ADSMAttributeDetails", aNC);
                            fA.put("ATTRIB_ACTION_NAME", (Object)rb.getString((String)aNR.get("ATTRIB_COLUMN_NAME")));
                            fA.put("ATTRIB_DATA_HANDLER_TYPE", aNR.get("DATA_HANDLER_TYPE"));
                        }
                        Long fId = (Long)fR.get("FIELD_ID");
                        if (fId == 3L || fId == 4L || fId == 5L) {
                            String mulVal = "[";
                            String tN = "SUDropDownVals";
                            if (fId == 4L) {
                                tN = "SUCheckBoxVals";
                            } else if (fId == 5L) {
                                tN = "SURadioButVals";
                            }
                            Criteria mVC = new Criteria(Column.getColumn((String)tN, (String)"ATTRIB_ACTION_ID"), fR.get("ATTRIB_ACTION_ID"), 0);
                            mVC = mVC.and(Column.getColumn((String)tN, (String)"SECTION_ID"), sR.get("SECTION_ID"), 0);
                            lObj.sortRows(tN, new SortColumn[]{new SortColumn(Column.getColumn((String)tN, (String)"UNIQUE_ID"), true)});
                            int ch1 = 0;
                            Iterator mVIt = lObj.getRows(tN, mVC);
                            while (mVIt.hasNext()) {
                                if (ch1 != 0) {
                                    mulVal = mulVal + ",";
                                }
                                Row mVR = (Row)mVIt.next();
                                String orgVal = (String)mVR.get("ORIGINAL_VAL");
                                String disVal = (String)mVR.get("DISPLAY_VAL");
                                Boolean selected = (Boolean)mVR.get("ISSELECTED");
                                JSONObject vals = new JSONObject();
                                vals.put("ORIGINAL_VAL", (Object)orgVal);
                                vals.put("DISPLAY_VAL", (Object)disVal);
                                vals.put("ISSELECTED", (Object)selected);
                                mulVal = mulVal + vals.toString();
                                ++ch1;
                            }
                            mulVal = mulVal + "]";
                            fA.put(tN, (Object)mulVal);
                        }
                        fAs.append(fA.toString());
                        ++ch;
                    }
                    fAs.append("]");
                    fields.put(((Long)sR.get("SECTION_SEQ")).toString(), (Object)new String(fAs));
                }
                sIdArr = sIdArr + ")";
                JSONObject nonCustomFields = new JSONObject();
                if (lObj.containsTable("SUNonCustomFields")) {
                    Iterator fIt = lObj.getRows("SUNonCustomFields");
                    while (fIt.hasNext()) {
                        Row fR = (Row)fIt.next();
                        nonCustomFields.put(((Long)fR.get("ATTRIB_ACTION_ID")).toString(), (Object)((String)fR.get("IS_ENABLED")));
                    }
                } else {
                    nonCustomFields.put("EMPTY_ELEMENT", (Object)"TO_AVOID_NULLABLE_JSON");
                }
                JSONObject photoUploadConfig = new JSONObject();
                if (lObj.containsTable("SUPhotoUploadConfig")) {
                    Iterator fIt = lObj.getRows("SUPhotoUploadConfig");
                    while (fIt.hasNext()) {
                        Row fR = (Row)fIt.next();
                        photoUploadConfig.put("SIZE", fR.get("SIZE"));
                        photoUploadConfig.put("WIDTH", fR.get("WIDTH"));
                        photoUploadConfig.put("HEIGHT", fR.get("HEIGHT"));
                        photoUploadConfig.put("EXTENSIONS", fR.get("EXTENSIONS"));
                    }
                } else {
                    photoUploadConfig.put("EMPTY_ELEMENT", (Object)"TO_AVOID_NULLABLE_JSON");
                }
                hash.put("layoutName", layoutName);
                hash.put("seqIds", sIdArr);
                hash.put("groups", groups.toString());
                hash.put("fields", fields.toString());
                hash.put("actionList", actionList);
                hash.put("mandatoryAttribs", mandatoryAttribs);
                hash.put("nonCustomFields", nonCustomFields.toString());
                hash.put("photoUploadConfig", photoUploadConfig.toString());
                hash.put("rules", ModificationRuleHandler.getLayoutRules(layoutID, adminView, rb));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return hash;
    }

    public static ArrayList saveLayout(Hashtable layoutDet) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String lIdStr = (String)layoutDet.get("layoutID");
            Long layoutID = 0L;
            if (!lIdStr.equals("")) {
                layoutID = new Long(lIdStr);
            }
            String operation = (String)layoutDet.get("operation");
            String layoutName = (String)layoutDet.get("layoutName");
            String groupsName = ((String)layoutDet.get("groupsName")).replace("\\", "\\\\");
            String fieldProps = ((String)layoutDet.get("fieldProps")).replace("\\", "\\\\").replace("\n", "\\n");
            String rules = (String)layoutDet.get("rules");
            JSONObject gNObj = new JSONObject(groupsName);
            JSONObject fPObj = new JSONObject(fieldProps);
            JSONObject rulesObj = new JSONObject(rules);
            Row r = null;
            JSONObject layoutDetails = LayoutHandler.getLayoutByName(layoutName);
            if (layoutDetails != null && (operation.equals("add") || layoutID.longValue() != layoutDetails.getLong("LAYOUT_ID"))) {
                layoutDetails.put("OPERATION", (Object)operation);
                layoutDetails.put("STATUS", (Object)"FAILURE");
                list.add(layoutDetails);
                return list;
            }
            DataObject searchContainersObj = null;
            if (operation.equals("add")) {
                r = new Row(SU_LAYOUT_TABLE);
                r.set("LAYOUT_NAME", (Object)layoutName);
                r.set("CREATED_TIME", (Object)System.currentTimeMillis());
                r.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
                obj.addRow(r);
            } else {
                Criteria lC = new Criteria(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), (Object)layoutID, 0);
                DataObject lObj = CommonUtil.getPersistence(new boolean[0]).get(SU_LAYOUT_TABLE, lC);
                r = lObj.getFirstRow(SU_LAYOUT_TABLE);
                r.set("LAYOUT_NAME", (Object)layoutName);
                r.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
                lObj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(lObj);
                Criteria delC = new Criteria(Column.getColumn((String)"SUSections", (String)"LAYOUT_ID"), (Object)layoutID, 0);
                if (!ADMPRoleHandler.isADSSPUser(AuthUtil.getUserCredential().getLoginId())) {
                    searchContainersObj = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("SUSections", "SUFields", "SUFieldVsDomainMapping", "SUFieldSearchContainers")), delC);
                }
                CommonUtil.getPersistence(new boolean[0]).delete(delC);
            }
            JSONArray gNSeqs = gNObj.names();
            for (int i = 0; i < gNSeqs.length(); ++i) {
                String gNSeq = gNSeqs.getString(i);
                Row r1 = new Row("SUSections");
                r1.set("LAYOUT_ID", r.get("LAYOUT_ID"));
                r1.set("SECTION_NAME", (Object)StrUtil.htmlUnescape(gNObj.getString(gNSeq)));
                r1.set("SECTION_SEQ", (Object)new Long(gNSeq));
                obj.addRow(r1);
                JSONArray fPArr = new JSONArray(fPObj.getString(gNSeq));
                for (int j = 0; j < fPArr.length(); ++j) {
                    JSONObject fAObj = new JSONObject(fPArr.getString(j));
                    JSONArray keysName = fAObj.names();
                    Row r2 = new Row("SUFields");
                    r2.set("SECTION_ID", r1.get("SECTION_ID"));
                    for (int k = 0; k < keysName.length(); ++k) {
                        String keyName = keysName.getString(k);
                        if (keyName.equals("SUDropDownVals") || keyName.equals("SUCheckBoxVals") || keyName.equals("SURadioButVals")) {
                            JSONObject dDArr = new JSONObject(fAObj.getString(keyName));
                            JSONArray dDFSeq = dDArr.names();
                            for (int v = 0; v < dDFSeq.length(); ++v) {
                                JSONObject dDFDets = new JSONObject(dDArr.getString(Integer.toString(v + 1)));
                                String orgVal = StrUtil.htmlUnescape(dDFDets.getString("ORIGINAL_VAL"));
                                String disVal = StrUtil.htmlUnescape(dDFDets.getString("DISPLAY_VAL"));
                                String isSel = dDFDets.getString("ISSELECTED");
                                Row dDRow = new Row(keyName);
                                dDRow.set("SECTION_ID", r1.get("SECTION_ID"));
                                dDRow.set("ATTRIB_ACTION_ID", (Object)Long.parseLong(fAObj.getString("ATTRIB_ACTION_ID")));
                                dDRow.set("DISPLAY_VAL", (Object)disVal);
                                dDRow.set("ORIGINAL_VAL", (Object)orgVal);
                                dDRow.set("ISSELECTED", (Object)Boolean.parseBoolean(isSel));
                                obj.addRow(dDRow);
                            }
                            continue;
                        }
                        if (keyName.equals("MANAGER_FIELD_CONTAINERS")) {
                            JSONObject fieldContainers = new JSONObject(fAObj.getString(keyName));
                            Iterator domains = fieldContainers.keys();
                            while (domains.hasNext()) {
                                String domainName = (String)domains.next();
                                if (searchContainersObj != null && !searchContainersObj.isEmpty()) {
                                    Row suFDMOldRow = searchContainersObj.getRow("SUFieldVsDomainMapping", new Criteria(Column.getColumn((String)"SUFieldVsDomainMapping", (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
                                    searchContainersObj.deleteRows("SUFieldSearchContainers", new Criteria(Column.getColumn((String)"SUFieldSearchContainers", (String)"CONFIG_ID"), (Object)((Long)suFDMOldRow.get("CONFIG_ID")), 0, false));
                                    searchContainersObj.deleteRow(suFDMOldRow);
                                }
                                JSONObject containers = new JSONObject(fieldContainers.getString(domainName));
                                Row r3 = new Row("SUFieldVsDomainMapping");
                                r3.set("UNIQUE_ID", r2.get("UNIQUE_ID"));
                                r3.set("DOMAIN_NAME", (Object)domainName);
                                obj.addRow(r3);
                                Iterator objectTypeIds = containers.keys();
                                while (objectTypeIds.hasNext()) {
                                    String objectTypeIdStr = (String)objectTypeIds.next();
                                    Integer objectTypeId = new Integer(objectTypeIdStr);
                                    JSONArray guids = (JSONArray)containers.get(objectTypeId.toString());
                                    for (int l = 0; l < guids.length(); ++l) {
                                        Row r4 = new Row("SUFieldSearchContainers");
                                        r4.set("CONFIG_ID", r3.get("CONFIG_ID"));
                                        r4.set("OBJECT_TYPE_ID", (Object)objectTypeId);
                                        r4.set("OBJECT_VALUE", (Object)guids.get(l).toString());
                                        obj.addRow(r4);
                                    }
                                }
                                if (searchContainersObj == null) continue;
                                Iterator oldSUFDMRows = searchContainersObj.getRows("SUFieldVsDomainMapping");
                                while (oldSUFDMRows.hasNext()) {
                                    Row oldSUFDMRow = (Row)oldSUFDMRows.next();
                                    oldSUFDMRow.set("UNIQUE_ID", r2.get("UNIQUE_ID"));
                                    obj.addRow(oldSUFDMRow);
                                }
                                Iterator oldSUFSCRows = searchContainersObj.getRows("SUFieldSearchContainers");
                                while (oldSUFSCRows.hasNext()) {
                                    Row oldSUFSCRow = (Row)oldSUFSCRows.next();
                                    obj.addRow(oldSUFSCRow);
                                }
                            }
                            continue;
                        }
                        String columnType = r2.getColumnType(keyName);
                        Object columnValue = DBUtil.convert(StrUtil.htmlUnescape(fAObj.getString(keyName)), columnType);
                        r2.set(keyName, columnValue);
                    }
                    obj.addRow(r2);
                }
            }
            CommonUtil.getPersistence(new boolean[0]).add(obj);
            Long lID = (Long)r.get("LAYOUT_ID");
            if (operation.equals("add")) {
                LayoutHandler.addAdvanceLayoutDetails(lID);
            }
            JSONObject toShow = new JSONObject();
            String lName = (String)r.get("LAYOUT_NAME");
            toShow.put("LAYOUT_ID", (Object)lID);
            toShow.put("LAYOUT_NAME", (Object)layoutName);
            toShow.put("CREATED_TIME", (Object)((Long)r.get("CREATED_TIME")));
            toShow.put("MODIFIED_TIME", (Object)((Long)r.get("MODIFIED_TIME")));
            toShow.put("OPERATION", (Object)operation);
            toShow.put("STATUS", (Object)"SUCCESS");
            list.add(toShow);
            ModificationRuleHandler.saveModificationRules(lID, rulesObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void deleteLayout(Long layoutID) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"PolicySULayout", (String)"LAYOUT_ID"), (Object)layoutID, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicySULayout", c);
            if (obj.isEmpty()) {
                ModificationRuleHandler.deleteModificationRules(layoutID);
                Criteria delC = new Criteria(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), (Object)layoutID, 0);
                CommonUtil.getPersistence(new boolean[0]).delete(delC);
            } else {
                logger.log(Level.INFO, "Unable to delete. This layout is assigned to a policy/policies. Layout ID:" + layoutID);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getLayoutID(Long policyId) {
        Long layoutId = 0L;
        try {
            Criteria lC = new Criteria(Column.getColumn((String)"PolicySULayout", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject lObj = CommonUtil.getPersistence(new boolean[0]).get("PolicySULayout", lC);
            if (lObj != null && !lObj.isEmpty()) {
                Row r = lObj.getFirstRow("PolicySULayout");
                layoutId = (Long)r.get("LAYOUT_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return layoutId;
    }

    public static void updatePSULayout(Long policyId, Long layoutId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicySULayout", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicySULayout", crit);
            if (obj.isEmpty()) {
                DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                Row r = new Row("PolicySULayout");
                r.set("POLICY_ID", (Object)policyId);
                r.set("LAYOUT_ID", (Object)layoutId);
                dataObject.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            } else {
                Row r = obj.getFirstRow("PolicySULayout");
                r.set("LAYOUT_ID", (Object)layoutId);
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deletePSULayout(Long policyId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicySULayout", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicySULayout", crit);
            if (!obj.isEmpty()) {
                CommonUtil.getPersistence(new boolean[0]).delete(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getAdvanceLayoutDetails(Long layoutID) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            JSONObject nonCustomFields = new JSONObject();
            Criteria nCFC = new Criteria(Column.getColumn((String)"SUNonCustomFields", (String)"LAYOUT_ID"), (Object)layoutID, 0);
            DataObject nCFObj = CommonUtil.getPersistence(new boolean[0]).get("SUNonCustomFields", nCFC);
            if (!nCFObj.isEmpty()) {
                Iterator fIt = nCFObj.getRows("SUNonCustomFields");
                while (fIt.hasNext()) {
                    Row fR = (Row)fIt.next();
                    nonCustomFields.put(((Long)fR.get("ATTRIB_ACTION_ID")).toString(), (Object)((String)fR.get("IS_ENABLED")));
                }
            } else {
                nonCustomFields.put("EMPTY_ELEMENT", (Object)"TO_AVOID_NULLABLE_JSON");
            }
            JSONObject photoUploadConfig = new JSONObject();
            Criteria pUCC = new Criteria(Column.getColumn((String)"SUPhotoUploadConfig", (String)"LAYOUT_ID"), (Object)layoutID, 0);
            DataObject pUCObj = CommonUtil.getPersistence(new boolean[0]).get("SUPhotoUploadConfig", pUCC);
            if (!pUCObj.isEmpty()) {
                Iterator fIt = pUCObj.getRows("SUPhotoUploadConfig");
                while (fIt.hasNext()) {
                    Row fR = (Row)fIt.next();
                    photoUploadConfig.put("SIZE", fR.get("SIZE"));
                    photoUploadConfig.put("WIDTH", fR.get("WIDTH"));
                    photoUploadConfig.put("HEIGHT", fR.get("HEIGHT"));
                    photoUploadConfig.put("EXTENSIONS", fR.get("EXTENSIONS"));
                }
            } else {
                photoUploadConfig.put("EMPTY_ELEMENT", (Object)"TO_AVOID_NULLABLE_JSON");
            }
            hash.put("nonCustomFields", nonCustomFields.toString());
            hash.put("photoUploadConfig", photoUploadConfig.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static ArrayList setAdvanceLayoutDetails(Hashtable layoutDet, AdventNetResourceBundle rb) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String lIdStr = (String)layoutDet.get("layoutID");
            Long layoutID = 0L;
            if (!lIdStr.equals("")) {
                layoutID = new Long(lIdStr);
            }
            String nonCustomFields = (String)layoutDet.get("nonCustomFields");
            String photoUploadConfig = (String)layoutDet.get("photoUploadConfig");
            nonCustomFields = StrUtil.htmlUnescape(nonCustomFields);
            photoUploadConfig = StrUtil.htmlUnescape(photoUploadConfig);
            JSONObject nCObj = new JSONObject(nonCustomFields);
            Criteria lC = new Criteria(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), (Object)layoutID, 0);
            DataObject lObj = CommonUtil.getPersistence(new boolean[0]).get(SU_LAYOUT_TABLE, lC);
            Row r = lObj.getFirstRow(SU_LAYOUT_TABLE);
            r.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            lObj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(lObj);
            Criteria delNCF = new Criteria(Column.getColumn((String)"SUNonCustomFields", (String)"LAYOUT_ID"), (Object)layoutID, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(delNCF);
            JSONArray nCFields = nCObj.names();
            if (nCFields != null) {
                for (int i = 0; i < nCFields.length(); ++i) {
                    String nCFName = nCFields.getString(i);
                    Row r1 = new Row("SUNonCustomFields");
                    r1.set("LAYOUT_ID", r.get("LAYOUT_ID"));
                    r1.set("ATTRIB_ACTION_ID", (Object)Long.parseLong(nCObj.getString(nCFName)));
                    r1.set("IS_ENABLED", (Object)1L);
                    obj.addRow(r1);
                }
            }
            Criteria delPUC = new Criteria(Column.getColumn((String)"SUPhotoUploadConfig", (String)"LAYOUT_ID"), (Object)layoutID, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(delPUC);
            JSONObject pUCObj = new JSONObject(photoUploadConfig);
            JSONArray pUCFields = pUCObj.names();
            if (pUCFields != null) {
                Long photoWidth = Long.parseLong(pUCObj.getString("PHOTOWIDTH"));
                Long photoHeight = Long.parseLong(pUCObj.getString("PHOTOHEIGHT"));
                Row r2 = new Row("SUPhotoUploadConfig");
                r2.set("LAYOUT_ID", r.get("LAYOUT_ID"));
                r2.set("SIZE", (Object)Long.parseLong(pUCObj.getString("PHOTOSIZE")));
                r2.set("WIDTH", (Object)photoWidth);
                r2.set("HEIGHT", (Object)photoHeight);
                r2.set("EXTENSIONS", (Object)pUCObj.getString("PHOTOEXTENSION"));
                obj.addRow(r2);
            }
            CommonUtil.getPersistence(new boolean[0]).add(obj);
            JSONObject toShow = new JSONObject();
            Long lID = (Long)r.get("LAYOUT_ID");
            String lName = (String)r.get("LAYOUT_NAME");
            toShow.put("LAYOUT_ID", (Object)lID);
            toShow.put("LAYOUT_NAME", (Object)rb.getString(lName));
            toShow.put("CREATED_TIME", (Object)((Long)r.get("CREATED_TIME")));
            toShow.put("MODIFIED_TIME", (Object)((Long)r.get("MODIFIED_TIME")));
            toShow.put("OPERATION", (Object)"edit");
            list.add(toShow);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void addAdvanceLayoutDetails(Long layoutID) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r1 = new Row("SUNonCustomFields");
            r1.set("LAYOUT_ID", (Object)layoutID);
            r1.set("ATTRIB_ACTION_ID", (Object)1956);
            r1.set("IS_ENABLED", (Object)1L);
            obj.addRow(r1);
            Row r2 = new Row("SUPhotoUploadConfig");
            r2.set("LAYOUT_ID", (Object)layoutID);
            obj.addRow(r2);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updatePolicyLayouts(JSONObject policyVsLayout) {
        try {
            ArrayList<Long> policyIds = new ArrayList<Long>();
            Iterator policyIdsItr = policyVsLayout.keys();
            while (policyIdsItr.hasNext()) {
                policyIds.add(Long.parseLong((String)policyIdsItr.next()));
            }
            Criteria crit = new Criteria(Column.getColumn((String)"PolicySULayout", (String)"POLICY_ID"), (Object)policyIds.toArray(), 8);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicySULayout", crit);
            Iterator itr = obj.getRows("PolicySULayout");
            while (itr.hasNext()) {
                Row row = (Row)itr.next();
                Long policyId = (Long)row.get("POLICY_ID");
                Long layoutId = Long.parseLong(policyVsLayout.get(policyId.toString()).toString());
                row.set("LAYOUT_ID", (Object)layoutId);
                obj.updateRow(row);
            }
            CommonUtil.getPersistenceLite().update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isFieldPresent(Long actionId) {
        boolean isPresent = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SUFields", (String)"ATTRIB_ACTION_ID"), (Object)actionId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SUFields", crit);
            if (!obj.isEmpty()) {
                isPresent = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return isPresent;
    }

    public static void updateValidationFlag(Long actionId, String dataType) {
        int validationFlag = 0;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SUFields", (String)"ATTRIB_ACTION_ID"), (Object)actionId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SUFields", crit);
            if (!obj.isEmpty()) {
                if (dataType.equalsIgnoreCase("INTEGER") || dataType.equalsIgnoreCase("BIGINT")) {
                    validationFlag = 8;
                }
                Iterator itr = obj.getRows("SUFields");
                while (itr.hasNext()) {
                    Row row = (Row)itr.next();
                    row.set("VALIDATION_FLAG", (Object)validationFlag);
                    obj.updateRow(row);
                }
                CommonUtil.getPersistenceLite().update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getAttributeDisplayText(Long actionId, Long layoutId) {
        String displayText = "";
        try {
            Row row;
            Iterator it;
            Criteria c = new Criteria(Column.getColumn((String)"SUSections", (String)"LAYOUT_ID"), (Object)layoutId, 0);
            DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get("SUSections", c);
            ArrayList<Long> sectionsList = new ArrayList<Long>();
            if (!dobj.isEmpty()) {
                it = dobj.getRows("SUSections");
                while (it.hasNext()) {
                    row = (Row)it.next();
                    sectionsList.add((Long)row.get("SECTION_ID"));
                }
            }
            c = new Criteria(Column.getColumn((String)"SUFields", (String)"ATTRIB_ACTION_ID"), (Object)actionId, 0);
            dobj = CommonUtil.getPersistence(new boolean[0]).get("SUFields", c);
            if (!dobj.isEmpty()) {
                it = dobj.getRows("SUFields");
                while (it.hasNext()) {
                    row = (Row)it.next();
                    if (!sectionsList.contains((Long)row.get("SECTION_ID"))) continue;
                    displayText = (String)row.get("ATTRIB_DISPLAY_TEXT");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return displayText;
    }

    public static Hashtable getUserMFDetails(String userName, String domainName, Long policyId) {
        Hashtable<String, Boolean> MFprop = new Hashtable<String, Boolean>();
        Boolean isAllMFPopulated = true;
        Boolean isMFUpdateForced = false;
        try {
            String isEnabled;
            Hashtable LayoutDet;
            String str;
            JSONObject nonCustomFields;
            Long layoutId = LayoutHandler.getLayoutID(policyId);
            ArrayList mandatoryAttribs = LayoutHandler.getMandatoryAttribs(layoutId);
            String userDN = "";
            String tableName = CommonUtil.getDomainUserTableName(domainName);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"SAM_ACCOUNT_NAME"), (Object)userName, 0);
            DataObject dobj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (dobj != null && !dobj.isEmpty()) {
                Row row = dobj.getFirstRow(tableName);
                userDN = (String)row.get("DN_STRING");
            }
            Properties userDetails = ADHandler.getObjectProperties(domainName, 1L, userDN, mandatoryAttribs);
            for (Object value : mandatoryAttribs) {
                ArrayList vlist = (ArrayList)userDetails.get((String)value);
                if (vlist != null) continue;
                isAllMFPopulated = false;
                break;
            }
            if ((nonCustomFields = new JSONObject(str = (String)(LayoutDet = LayoutHandler.getAdvanceLayoutDetails(layoutId)).get("nonCustomFields"))).has(Integer.toString(1958)) && (isEnabled = nonCustomFields.getString(Integer.toString(1958))).equals("1")) {
                isMFUpdateForced = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        MFprop.put("isAllMFPopulated", isAllMFPopulated);
        MFprop.put("isMFUpdateForced", isMFUpdateForced);
        return MFprop;
    }

    public static ArrayList getMandatoryAttribs(Long layoutId) {
        ArrayList<Long> mandatoryAttribs = new ArrayList<Long>();
        ArrayList<String> list = new ArrayList<String>();
        try {
            Criteria lC = new Criteria(Column.getColumn((String)SU_LAYOUT_TABLE, (String)"LAYOUT_ID"), (Object)layoutId, 0);
            SelectQueryImpl sq = new SelectQueryImpl(new Table(SU_LAYOUT_TABLE));
            sq.addJoin(new Join(Table.getTable((String)SU_LAYOUT_TABLE), Table.getTable((String)"SUSections"), new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 1));
            sq.addJoin(new Join(Table.getTable((String)SU_LAYOUT_TABLE), Table.getTable((String)"SUNonCustomFields"), new String[]{"LAYOUT_ID"}, new String[]{"LAYOUT_ID"}, 1));
            sq.addJoin(new Join(Table.getTable((String)"SUSections"), Table.getTable((String)"SUFields"), new String[]{"SECTION_ID"}, new String[]{"SECTION_ID"}, 1));
            sq.setCriteria(lC);
            sq.addSelectColumn(Column.getColumn(null, (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"SUSections", (String)"SECTION_SEQ"), true));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"SUFields", (String)"ATTRIB_SEQ"), true));
            DataObject lObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!lObj.isEmpty()) {
                Iterator sIt = lObj.getRows("SUSections");
                while (sIt.hasNext()) {
                    Row sR = (Row)sIt.next();
                    Criteria fC = new Criteria(Column.getColumn((String)"SUFields", (String)"SECTION_ID"), sR.get("SECTION_ID"), 0);
                    Iterator fIt = lObj.getRows("SUFields", fC);
                    while (fIt.hasNext()) {
                        Row fR = (Row)fIt.next();
                        if (!((Boolean)fR.get("ISMANDATORY")).booleanValue()) continue;
                        mandatoryAttribs.add((Long)fR.get("ATTRIB_ACTION_ID"));
                    }
                }
            }
            ArrayList<Hashtable> attribList = AddUserHandler.getInstance().getAttributeDetailsForActionIds(mandatoryAttribs);
            for (Hashtable hash : attribList) {
                String ldapName = (String)hash.get("ATTRIB_LDAP_NAME");
                list.add(ldapName);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }
}

