/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.json.JSONArray;
import org.json.JSONObject;

public class ModificationRuleHandler {
    public static final String SULAYOUTVSMODIFYRULE = "SULayoutVsModifyRule";
    public static final String SUMODIFYRULES = "SUModifyRules";
    public static final String SUMRCONDITIONS = "SUMRConditions";
    public static final String SUMRASSIGNVALUES = "SUMRAssignValues";
    public static final String SUMRRELATIONALOPERATORS = "SUMRRelationalOperators";
    public static final String LAYOUT_ID = "LAYOUT_ID";
    public static final String MOD_RULE_ID = "MOD_RULE_ID";
    public static final String MOD_RULE_NAME = "MOD_RULE_NAME";
    public static final String IS_ENABLED = "IS_ENABLED";
    public static final String CONDITION_ID = "CONDITION_ID";
    public static final String ATTRIB_ACTION_ID = "ATTRIB_ACTION_ID";
    public static final String RELATIONAL_OPERATOR = "RELATIONAL_OPERATOR";
    public static final String ATTRIB_ACTION_VALUE = "ATTRIB_ACTION_VALUE";
    public static final String LOGICAL_OPERATOR = "LOGICAL_OPERATOR";
    public static final String ORDER_ID = "ORDER_ID";
    public static final String REL_OPERATOR_ID = "REL_OPERATOR_ID";
    public static final String REL_OPERATOR_NAME = "REL_OPERATOR_NAME";
    public static final String DISPLAY_NAME = "DISPLAY_NAME";
    public static final long CUSTOM_ATTRIBUTES = 8800L;
    public static final long GENERAL_ATTRIBUTES = 8000L;

    public static ArrayList getFields(AdventNetResourceBundle rb) {
        ArrayList<JSONObject> fieldsList = new ArrayList<JSONObject>();
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPActionDetails", (Criteria)null);
            if (!obj.isEmpty()) {
                Criteria crit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"PARENT_ID"), (Object)new Long[]{8000L, 8800L}, 8);
                Iterator itr = obj.getRows("ADMPActionDetails", crit);
                while (itr.hasNext()) {
                    JSONObject section = new JSONObject();
                    Row r = (Row)itr.next();
                    Long aId = (Long)r.get("ACTION_ID");
                    section.put("SECTION_NAME", (Object)rb.getString((String)r.get("ACTION_NAME")));
                    Criteria attribCrit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"PARENT_ID"), (Object)aId, 0);
                    ArrayList<JSONObject> fields = new ArrayList<JSONObject>();
                    Iterator itr1 = obj.getRows("ADMPActionDetails", attribCrit);
                    while (itr1.hasNext()) {
                        JSONObject field = new JSONObject();
                        Row row = (Row)itr1.next();
                        field.put("FIELD_NAME", (Object)rb.getString((String)row.get("ACTION_NAME")));
                        field.put("FIELD_ID", (Object)((Long)row.get("ACTION_ID")));
                        fields.add(field);
                    }
                    section.put("SECTION_FIELDS", fields);
                    fieldsList.add(section);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return fieldsList;
    }

    public static SelectQuery getRulesQuery(Long layoutId, boolean adminView) {
        SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)SULAYOUTVSMODIFYRULE));
        Criteria crit = new Criteria(Column.getColumn((String)SULAYOUTVSMODIFYRULE, (String)LAYOUT_ID), (Object)layoutId, 0);
        if (!adminView) {
            crit = crit.and(new Criteria(Column.getColumn((String)SUMODIFYRULES, (String)IS_ENABLED), (Object)true, 0));
        }
        Join layoutRuleJoin = new Join(Table.getTable((String)SULAYOUTVSMODIFYRULE), Table.getTable((String)SUMODIFYRULES), new String[]{MOD_RULE_ID}, new String[]{MOD_RULE_ID}, 2);
        Join ruleConditionJoin = new Join(Table.getTable((String)SUMODIFYRULES), Table.getTable((String)SUMRCONDITIONS), new String[]{MOD_RULE_ID}, new String[]{MOD_RULE_ID}, 1);
        Join ruleModifyJoin = new Join(Table.getTable((String)SUMODIFYRULES), Table.getTable((String)SUMRASSIGNVALUES), new String[]{MOD_RULE_ID}, new String[]{MOD_RULE_ID}, 1);
        query.addSelectColumn(new Column(null, "*"));
        query.addJoin(layoutRuleJoin);
        query.addJoin(ruleConditionJoin);
        query.addJoin(ruleModifyJoin);
        query.setCriteria(crit);
        query.addSortColumn(new SortColumn(Column.getColumn((String)SUMODIFYRULES, (String)MOD_RULE_ID), true));
        query.addSortColumn(new SortColumn(Column.getColumn((String)SUMRCONDITIONS, (String)ORDER_ID), true));
        return query;
    }

    public static ArrayList getMRRelationalOperators(AdventNetResourceBundle rb) {
        ArrayList<JSONObject> critList = new ArrayList<JSONObject>();
        try {
            DataObject critObj = CommonUtil.getPersistence(new boolean[0]).get(SUMRRELATIONALOPERATORS, (Criteria)null);
            if (!critObj.isEmpty()) {
                Iterator itr = critObj.getRows(SUMRRELATIONALOPERATORS);
                while (itr.hasNext()) {
                    JSONObject crit = new JSONObject();
                    Row row = (Row)itr.next();
                    crit.put(REL_OPERATOR_ID, (Object)((Long)row.get(REL_OPERATOR_ID)));
                    crit.put(REL_OPERATOR_NAME, (Object)rb.getString((String)row.get(REL_OPERATOR_NAME)));
                    crit.put(DISPLAY_NAME, (Object)rb.getString((String)row.get(DISPLAY_NAME)));
                    critList.add(crit);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return critList;
    }

    public static ArrayList<JSONObject> getLayoutRules(Long layoutID, boolean adminView, AdventNetResourceBundle rb) {
        ArrayList<JSONObject> rulesList = new ArrayList<JSONObject>();
        try {
            DataObject obj = ModificationRuleHandler.getRulesDataObject(layoutID, adminView);
            DataObject fieldsObj = CommonUtil.getPersistence(new boolean[0]).get("ADMPActionDetails", (Criteria)null);
            Iterator itr = obj.getRows(SUMODIFYRULES);
            while (itr.hasNext()) {
                Row r;
                JSONObject ruleDetails = new JSONObject();
                Row row = (Row)itr.next();
                Long ruleId = (Long)row.get(MOD_RULE_ID);
                Criteria Condcrit = new Criteria(Column.getColumn((String)SUMRCONDITIONS, (String)MOD_RULE_ID), (Object)ruleId, 0);
                Criteria assignValCrit = new Criteria(Column.getColumn((String)SUMRASSIGNVALUES, (String)MOD_RULE_ID), (Object)ruleId, 0);
                ruleDetails.put(MOD_RULE_ID, (Object)ruleId);
                ruleDetails.put(MOD_RULE_NAME, (Object)((String)row.get(MOD_RULE_NAME)));
                ruleDetails.put(IS_ENABLED, (Object)((Boolean)row.get(IS_ENABLED)));
                ArrayList<JSONObject> conditions = new ArrayList<JSONObject>();
                ArrayList<JSONObject> modifyList = new ArrayList<JSONObject>();
                Iterator conditionItr = obj.getRows(SUMRCONDITIONS, Condcrit);
                while (conditionItr.hasNext()) {
                    JSONObject condition = new JSONObject();
                    r = (Row)conditionItr.next();
                    condition.put(CONDITION_ID, (Object)((Long)r.get(CONDITION_ID)));
                    condition.put(ATTRIB_ACTION_ID, (Object)((Long)r.get(ATTRIB_ACTION_ID)));
                    condition.put(RELATIONAL_OPERATOR, (Object)((String)r.get(RELATIONAL_OPERATOR)));
                    condition.put(ATTRIB_ACTION_VALUE, (Object)((String)r.get(ATTRIB_ACTION_VALUE)));
                    condition.put(LOGICAL_OPERATOR, (Object)((String)r.get(LOGICAL_OPERATOR)));
                    condition.put(ORDER_ID, (Object)((Long)r.get(ORDER_ID)));
                    conditions.add(condition);
                }
                Iterator modifyItr = obj.getRows(SUMRASSIGNVALUES, assignValCrit);
                while (modifyItr.hasNext()) {
                    JSONObject modifyDetails = new JSONObject();
                    r = (Row)modifyItr.next();
                    Long actionId = (Long)r.get(ATTRIB_ACTION_ID);
                    Criteria fieldCrit = new Criteria(Column.getColumn((String)"ADMPActionDetails", (String)"ACTION_ID"), (Object)actionId, 0);
                    Row fieldRow = fieldsObj.getRow("ADMPActionDetails", fieldCrit);
                    modifyDetails.put(ATTRIB_ACTION_ID, (Object)((Long)r.get(ATTRIB_ACTION_ID)));
                    modifyDetails.put(ATTRIB_ACTION_VALUE, (Object)((String)r.get(ATTRIB_ACTION_VALUE)));
                    modifyDetails.put("MODIFY_FIELD", (Object)rb.getString((String)fieldRow.get("ACTION_NAME")));
                    modifyList.add(modifyDetails);
                }
                ruleDetails.put("CONDITIONS", conditions);
                ruleDetails.put("MODIFY", modifyList);
                if (rb != null) {
                    ruleDetails.put("FIELDS", (Collection)ModificationRuleHandler.getFields(rb));
                }
                rulesList.add(ruleDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return rulesList;
    }

    public static void deleteModificationRules(Long layoutID) throws Exception {
        Criteria crit = new Criteria(Column.getColumn((String)SULAYOUTVSMODIFYRULE, (String)LAYOUT_ID), (Object)layoutID, 0);
        DataObject rulesObj = CommonUtil.getPersistence(new boolean[0]).get(SULAYOUTVSMODIFYRULE, crit);
        if (!rulesObj.isEmpty()) {
            ArrayList<Long> ruleIds = new ArrayList<Long>();
            Iterator itr = rulesObj.getRows(SULAYOUTVSMODIFYRULE);
            while (itr.hasNext()) {
                Row r = (Row)itr.next();
                ruleIds.add((Long)r.get(MOD_RULE_ID));
            }
            Criteria delCrit = new Criteria(Column.getColumn((String)SUMODIFYRULES, (String)MOD_RULE_ID), (Object)ruleIds.toArray(), 8);
            CommonUtil.getPersistence(new boolean[0]).delete(delCrit);
        }
    }

    public static void saveModificationRules(Long layoutID, JSONObject rules) {
        try {
            ModificationRuleHandler.deleteModificationRules(layoutID);
            JSONArray rulesArr = (JSONArray)rules.get("rules");
            for (int i = 0; i < rulesArr.length(); ++i) {
                JSONObject rule = rulesArr.getJSONObject(i);
                ModificationRuleHandler.updateRule(layoutID, rule);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateRule(Long layoutID, JSONObject rule) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            DataObject ruleObj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            String ruleName = (String)rule.get(MOD_RULE_NAME);
            Boolean ruleStatus = (Boolean)rule.get(IS_ENABLED);
            Row row = new Row(SUMODIFYRULES);
            row.set(MOD_RULE_NAME, (Object)ruleName);
            row.set(IS_ENABLED, (Object)ruleStatus);
            obj.addRow(row);
            CommonUtil.getPersistenceLite().update(obj);
            Long ruleId = (Long)row.get(MOD_RULE_ID);
            row = new Row(SULAYOUTVSMODIFYRULE);
            row.set(MOD_RULE_ID, (Object)ruleId);
            row.set(LAYOUT_ID, (Object)layoutID);
            ruleObj.addRow(row);
            JSONArray conditions = (JSONArray)rule.get("CONDITIONS");
            for (int i = 0; i < conditions.length(); ++i) {
                JSONObject condition = conditions.getJSONObject(i);
                if (!condition.has(ATTRIB_ACTION_ID)) continue;
                Row condRow = new Row(SUMRCONDITIONS);
                condRow.set(MOD_RULE_ID, (Object)ruleId);
                condRow.set(ATTRIB_ACTION_ID, (Object)condition.getLong(ATTRIB_ACTION_ID));
                condRow.set(RELATIONAL_OPERATOR, (Object)((String)condition.get(RELATIONAL_OPERATOR)));
                condRow.set(ATTRIB_ACTION_VALUE, (Object)((String)condition.get(ATTRIB_ACTION_VALUE)));
                condRow.set(LOGICAL_OPERATOR, (Object)((String)condition.get(LOGICAL_OPERATOR)));
                condRow.set(ORDER_ID, (Object)condition.getLong(ORDER_ID));
                ruleObj.addRow(condRow);
            }
            JSONArray modifications = (JSONArray)rule.get("MODIFY");
            for (int i = 0; i < modifications.length(); ++i) {
                JSONObject modify = modifications.getJSONObject(i);
                Row modifyRow = new Row(SUMRASSIGNVALUES);
                modifyRow.set(MOD_RULE_ID, (Object)ruleId);
                modifyRow.set(ATTRIB_ACTION_ID, (Object)modify.getLong(ATTRIB_ACTION_ID));
                modifyRow.set(ATTRIB_ACTION_VALUE, (Object)((String)modify.get(ATTRIB_ACTION_VALUE)));
                ruleObj.addRow(modifyRow);
            }
            CommonUtil.getPersistenceLite().update(ruleObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String getCountriesTxt() {
        StringBuilder str = new StringBuilder();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMCountriesList", (String)"countryCode"), (Object)-1, 1);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMCountriesList", crit);
            Iterator it = obj.getRows("ADSMCountriesList");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                str.append(r.get("countryCode").toString()).append(",");
                str.append((String)r.get("co")).append("(");
                str.append((String)r.get("c")).append(")%");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new String(str);
    }

    public static DataObject getRulesDataObject(long layoutId, boolean adminView) {
        DataObject obj = null;
        try {
            SelectQuery query = ModificationRuleHandler.getRulesQuery(layoutId, adminView);
            obj = CommonUtil.getPersistence(new boolean[0]).get(query);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return obj;
    }
}

