/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.json.JSONArray;
import org.json.JSONObject;

public class NamingFormatHandler {
    private static final String REGEX = "%{1}\\w+%{1}";
    private static Pattern p = Pattern.compile("%{1}\\w+%{1}");
    private static Matcher m = null;

    public static JSONArray getNamingFormats() {
        JSONArray namingFormats = new JSONArray();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPNamingFormats", (Criteria)null);
            Iterator iterator = dataObject.getRows("SSPNamingFormats");
            while (iterator.hasNext()) {
                Row row = (Row)iterator.next();
                JSONObject namingFormat = new JSONObject();
                namingFormat.put("FORMAT_ID", row.get("FORMAT_ID"));
                namingFormat.put("FORMAT_NAME", row.get("FORMAT_NAME"));
                namingFormat.put("isDefault", row.get("IS_DEFAULT"));
                namingFormats.put((Object)namingFormat);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return namingFormats;
    }

    public static JSONArray getNamingFormats(Long loginId, String domainName, String loginName) {
        JSONArray namingFormats = new JSONArray();
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPNamingFormats", (Criteria)null);
            Properties attribDetails = NamingFormatHandler.getNamingProperties(loginName, domainName, dataObject);
            Properties attribValues = (Properties)attribDetails.get("attribValues");
            String[] allAttrib = (String[])attribDetails.get("attribList");
            Iterator iterator = dataObject.getRows("SSPNamingFormats");
            try {
                while (iterator.hasNext()) {
                    Row row = (Row)iterator.next();
                    String name = (String)row.get("FORMAT_VALUE");
                    if ((name = NamingFormatHandler.replaceNames(allAttrib, attribValues, name)) == null) continue;
                    JSONObject namingFormat = new JSONObject();
                    namingFormat.put("FORMAT_ID", row.get("FORMAT_ID"));
                    namingFormat.put("FORMAT_NAME", (Object)StrUtil.encodeURIComponent(name));
                    namingFormat.put("isDefault", row.get("IS_DEFAULT"));
                    namingFormats.put((Object)namingFormat);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return namingFormats;
    }

    public static Object getDefaultNamingFormat(String column) {
        Object defaulNamingDetails = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPNamingFormats", (String)"IS_DEFAULT"), (Object)1, 0);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get("SSPNamingFormats", crit);
            if (!dataObject.isEmpty()) {
                Row r = dataObject.getFirstRow("SSPNamingFormats");
                defaulNamingDetails = r.get(column);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return defaulNamingDetails;
    }

    public static String getUserDisplayName(HttpServletRequest request) {
        String displayName = null;
        HttpSession session = request.getSession();
        Long loginId = (Long)session.getAttribute("ADMP_SESSION_LOGIN_ID");
        if (ADMPRoleHandler.isADSSPUser(loginId)) {
            displayName = AuthUtil.getUserCredential().getLoginName();
            session.setAttribute("WELCOME_NAME", (Object)displayName);
            return displayName;
        }
        String tN = "ADMPUsersPersonal";
        Long[] userIds = new Long[]{loginId, 1L};
        Long formatId = null;
        DataObject o = null;
        try {
            for (Long userId : userIds) {
                Criteria c = new Criteria(Column.getColumn((String)tN, (String)"LOGIN_ID"), (Object)userId, 0);
                o = CommonUtil.getPersistence(new boolean[0]).get(tN, c);
                if (!o.isEmpty()) {
                    Row r = o.getFirstRow(tN);
                    formatId = (Long)r.get("NAMING_FORMAT_ID");
                }
                if (formatId != null && userId != 1L) break;
            }
            if (formatId == null) {
                formatId = (Long)NamingFormatHandler.getDefaultNamingFormat("FORMAT_ID");
            }
            Criteria c = new Criteria(Column.getColumn((String)"SSPNamingFormats", (String)"FORMAT_ID"), (Object)formatId, 0);
            c = c.or(new Criteria(Column.getColumn((String)"SSPNamingFormats", (String)"IS_DEFAULT"), (Object)"1", 0));
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
            String loginName = domainDetails.getProperty("LOGIN_NAME");
            o = CommonUtil.getPersistence(new boolean[0]).get("SSPNamingFormats", c);
            Properties attribDetails = NamingFormatHandler.getNamingProperties(loginName, domainName, o);
            Properties attribValues = (Properties)attribDetails.get("attribValues");
            String[] allAttrib = (String[])attribDetails.get("attribList");
            if (!o.isEmpty()) {
                Row r = o.getRow("SSPNamingFormats", new Criteria(Column.getColumn((String)"SSPNamingFormats", (String)"FORMAT_ID"), (Object)formatId, 0));
                if (r != null) {
                    displayName = r.get("FORMAT_VALUE") != null ? (String)r.get("FORMAT_VALUE") : "1";
                    if ((displayName = NamingFormatHandler.replaceNames(allAttrib, attribValues, displayName)) == null) {
                        displayName = (String)NamingFormatHandler.getDefaultNamingFormat("FORMAT_VALUE");
                        if ((displayName = NamingFormatHandler.replaceNames(allAttrib, attribValues, displayName)) == null) {
                            displayName = loginName;
                        }
                    }
                } else {
                    displayName = loginName;
                }
            } else {
                displayName = loginName;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        displayName = StrUtil.encodeURIComponent(displayName);
        session.setAttribute("WELCOME_NAME", (Object)displayName);
        return displayName;
    }

    public static Properties getNamingProperties(String loginName, String domainName, DataObject dataObject) {
        p = Pattern.compile(REGEX);
        StringBuffer allFormatValue = new StringBuffer();
        Properties attributeDetails = new Properties();
        try {
            Iterator ite = dataObject.get("SSPNamingFormats", "FORMAT_VALUE");
            while (ite.hasNext()) {
                allFormatValue.append((String)ite.next());
            }
            m = p.matcher(allFormatValue);
            Properties attribValues = null;
            ArrayList<String> allAttribList = new ArrayList<String>();
            while (m.find()) {
                String attribute = allFormatValue.substring(m.start() + 1, m.end() - 1);
                allAttribList.add(attribute);
            }
            String[] allAttrib = allAttribList.toArray(new String[allAttribList.size()]);
            attribValues = UserUtil.getUserObjectDetails(loginName, domainName, allAttrib);
            attributeDetails.put("attribValues", attribValues);
            attributeDetails.put("attribList", allAttrib);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return attributeDetails;
    }

    public static String replaceNames(String[] allAttrib, Properties attribValues, String displayName) {
        for (String attrib : allAttrib) {
            p = Pattern.compile("%" + attrib + "%");
            m = p.matcher(displayName);
            String value = (String)attribValues.get(attrib);
            if (value == null && displayName.indexOf(attrib) != -1) {
                displayName = null;
                break;
            }
            displayName = m.replaceAll(Matcher.quoteReplacement(attribValues.getProperty(attrib, "")));
        }
        return displayName;
    }
}

