/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.db.persistence.metadata.util.MetaDataUtil;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.SortColumn;
import com.adventnet.ds.query.Table;
import com.adventnet.ds.query.UpdateQuery;
import com.adventnet.ds.query.UpdateQueryImpl;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.AdvancedPolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.SchedulerHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADAuthHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.IdentityVerifyHandler;
import com.adventnet.sym.adsm.common.server.configuration.PPEHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mailalias.GSSelfServiceHandler;
import com.adventnet.sym.adsm.common.server.selfservice.LinkAccountsHandler;
import com.adventnet.sym.adsm.common.server.usermanagement.UserMgmtUtil;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.common.server.util.licensing.LicenseManager;
import com.manageengine.ads.fw.i18n.ADSResourceBundle;
import com.manageengine.ads.fw.i18n.I18N;
import com.manageengine.ads.fw.iamapps.handler.IAMAppHandler;
import java.io.Serializable;
import java.sql.Connection;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.apache.struts.validator.DynaValidatorForm;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PolicyHandler {
    private static Logger logger = Logger.getLogger(PolicyHandler.class.getName());

    public static void addDefaultPolicy(Properties prop) {
        try {
            String domainName = prop.getProperty("DOMAIN_NAME");
            String objectGUID = prop.getProperty("OBJECT_GUID");
            String distinguishedName = prop.getProperty("DISTINGUISHED_NAME");
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("PolicyConfiguration");
            r.set("POLICY_NAME", (Object)domainName);
            r.set("RESET_PASSWORD", (Object)"true");
            r.set("UNLOCK_ACCOUNT", (Object)"true");
            r.set("SELF_UPDATE", (Object)"true");
            r.set("CHANGE_PASSWORD", (Object)"true");
            r.set("DOMAIN_NAME", (Object)domainName);
            dataObject.addRow(r);
            Row r1 = new Row("PolicyCriteria");
            r1.set("POLICY_ID", r.get("POLICY_ID"));
            r1.set("OBJECT_GUID", (Object)objectGUID);
            r1.set("DISTINGUISHED_NAME", (Object)distinguishedName);
            r1.set("DOMAIN_NAME", (Object)domainName);
            dataObject.addRow(r1);
            Row r2 = new Row("SSPQASettings");
            r2.set("POLICY_ID", r.get("POLICY_ID"));
            dataObject.addRow(r2);
            Row r6 = new Row("PolicySULayout");
            r6.set("POLICY_ID", r.get("POLICY_ID"));
            r6.set("LAYOUT_ID", (Object)new Long(1L));
            dataObject.addRow(r6);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQ", (Criteria)null);
            Iterator it = o.getRows("SSPBuildInQ");
            while (it.hasNext()) {
                Row r12 = (Row)it.next();
                Row r11 = new Row("SSPSecretQues");
                r11.set("POLICY_ID", r.get("POLICY_ID"));
                r11.set("QUESTION_TEXT", (Object)((String)r12.get("QUESTION_TEXT")));
                dataObject.addRow(r11);
            }
            CommonUtil.getPersistenceLite().add(dataObject);
            AdvancedPolicyHandler.addAPCRows((Long)r.get("POLICY_ID"));
            IdentityVerifyHandler.addIDRows((Long)r.get("POLICY_ID"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static DataObject getDefaultQuestions() {
        try {
            return CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQ", (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Hashtable getPolicyInfo(Long policyConfigId, Long policyId) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPolicies", (String)"POLICYCONFIG_ID"), (Object)policyConfigId, 0);
            crit = crit.and(Column.getColumn((String)"SSPPolicies", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPPolicies", crit);
            if (!obj.isEmpty()) {
                hash.put("policy", obj.getFirstRow("SSPPolicies"));
            }
            Criteria c = new Criteria(Column.getColumn((String)"SSPPolicyDetails", (String)"POLICYCONFIG_ID"), (Object)policyConfigId, 0);
            c = c.and(Column.getColumn((String)"SSPPolicyDetails", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPPolicyDetails", c);
            if (!o.isEmpty()) {
                Iterator it = o.getRows("SSPPolicyDetails");
                Hashtable<String, Object> policyProps = new Hashtable<String, Object>();
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    policyProps.put("PWD_TYPE", r.get("PROPERTY_NAME"));
                    policyProps.put("PWD_VALUE", r.get("PROPERTY_VALUE"));
                }
                hash.put("policyProps", policyProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static Long getDefaultDomainID() {
        Long policyId = new Long(0L);
        try {
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = cred.getLoginId();
            Criteria criteria = null;
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"PolicyConfiguration"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), true));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"PolicyConfiguration", (String)"PRIORITY"), true));
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                criteria = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            } else {
                Criteria crit = new Criteria(Column.getColumn((String)"ADSMDomainConfiguration", (String)"IS_DEFAULT_DOMAIN"), (Object)"true", 0, false);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainConfiguration", crit);
                Row r = obj.getFirstRow("ADSMDomainConfiguration");
                criteria = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), r.get("DOMAIN_NAME"), 0, false);
            }
            sq.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            Row row = dataObj.getFirstRow("PolicyConfiguration");
            policyId = (Long)row.get("POLICY_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable getDefaultDomainPolicy(Long policyId) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        ArrayList<String> OUList = new ArrayList<String>();
        ArrayList<String> GroupList = new ArrayList<String>();
        Connection connection = null;
        DataSet dataSet = null;
        ArrayList<JSONObject> selGuids = new ArrayList<JSONObject>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
            hash.put("policyConfig", obj.getFirstRow("PolicyConfiguration"));
            String domainName = (String)obj.getFirstValue("PolicyConfiguration", "DOMAIN_NAME");
            String groupTN = CommonUtil.getDomainGroupTableName(domainName);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"PolicyCriteria"));
            Join ouJoin = new Join("PolicyCriteria", "ADSMOUDetails", new String[]{"DISTINGUISHED_NAME"}, new String[]{"DISTINGUISHED_NAME"}, 1);
            Join groupJoin = new Join("PolicyCriteria", groupTN, new String[]{"DISTINGUISHED_NAME"}, new String[]{"DN_STRING"}, 1);
            sq.addJoin(ouJoin);
            sq.addJoin(groupJoin);
            sq.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_CLASS"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"DISTINGUISHED_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"DISTINGUISHED_NAME"));
            sq.addSelectColumn(Column.getColumn((String)"ADSMOUDetails", (String)"NAME"));
            sq.addSelectColumn(Column.getColumn((String)groupTN, (String)"OBJECT_GUID"));
            sq.addSelectColumn(Column.getColumn((String)groupTN, (String)"DN_STRING"));
            sq.addSelectColumn(Column.getColumn((String)groupTN, (String)"DISPLAY_NAME"));
            crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"), (Object)policyId, 0, false);
            sq.setCriteria(crit);
            RelationalAPI relationalAPI = RelationalAPI.getInstance();
            connection = relationalAPI.getConnection();
            dataSet = relationalAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                JSONObject jsonobj = new JSONObject();
                if ("OU".equalsIgnoreCase((String)dataSet.getValue("OBJECT_CLASS"))) {
                    OUList.add((String)dataSet.getValue(4));
                    jsonobj.put("OBJECT_CLASS", (Object)"ou");
                    jsonobj.put("OBJECT_GUID", (Object)((String)dataSet.getValue(1)));
                    String dn = (String)dataSet.getValue(4);
                    if (dn.toUpperCase().startsWith("DC")) {
                        jsonobj.put("OBJECT_NAME", (Object)dn);
                    } else if (dataSet.getValue("NAME") == null) {
                        jsonobj.put("OBJECT_NAME", (Object)dn);
                    } else {
                        jsonobj.put("OBJECT_NAME", dataSet.getValue("NAME"));
                    }
                } else {
                    GroupList.add((String)dataSet.getValue(1));
                    jsonobj.put("OBJECT_CLASS", (Object)"group");
                    jsonobj.put("OBJECT_GUID", (Object)((String)dataSet.getValue(1)));
                    if (dataSet.getValue("DISPLAY_NAME") == null) {
                        jsonobj.put("OBJECT_NAME", (Object)((String)dataSet.getValue(4)));
                    } else {
                        jsonobj.put("OBJECT_NAME", (Object)((String)dataSet.getValue("DISPLAY_NAME")));
                    }
                }
                selGuids.add(jsonobj);
            }
            hash.put("OUList", OUList);
            hash.put("GroupList", GroupList);
            hash.put("selGuids", selGuids);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return hash;
    }

    public static Hashtable getPolicyProps() {
        Hashtable policyDetails = new Hashtable();
        ArrayList<Object> policyIds = new ArrayList<Object>();
        ArrayList<Object> policyNames = new ArrayList<Object>();
        ArrayList<Object> resetPwd = new ArrayList<Object>();
        ArrayList<Object> unlockAcc = new ArrayList<Object>();
        ArrayList<Object> selfUpdate = new ArrayList<Object>();
        ArrayList<Object> changePwd = new ArrayList<Object>();
        ArrayList<Object> domainNames = new ArrayList<Object>();
        Properties props = new Properties();
        try {
            ArrayList domainlist = DomainHandler.getDomainList();
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = cred.getLoginId();
            Criteria criteria = null;
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"PolicyConfiguration"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"*"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), true));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"PolicyConfiguration", (String)"PRIORITY"), true));
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                criteria = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            sq.setCriteria(criteria);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows("PolicyConfiguration");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    props.setProperty("DOMAIN_NAME", (String)r.get("DOMAIN_NAME"));
                    if (!domainlist.contains(props)) continue;
                    policyIds.add(r.get("POLICY_ID"));
                    policyNames.add(r.get("POLICY_NAME"));
                    resetPwd.add(r.get("RESET_PASSWORD"));
                    unlockAcc.add(r.get("UNLOCK_ACCOUNT"));
                    selfUpdate.add(r.get("SELF_UPDATE"));
                    changePwd.add(r.get("CHANGE_PASSWORD"));
                    domainNames.add(r.get("DOMAIN_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        policyDetails.put("POLICY_IDS", policyIds);
        policyDetails.put("POLICY_NAMES", policyNames);
        policyDetails.put("RESET_PWD_LIST", resetPwd);
        policyDetails.put("UNLOCK_ACC_LIST", unlockAcc);
        policyDetails.put("SELF_UPDATE_LIST", selfUpdate);
        policyDetails.put("CHANGE_PWD_LIST", changePwd);
        policyDetails.put("DOMAIN_NAMES", domainNames);
        return policyDetails;
    }

    public static Long addPolicyConfig(Hashtable prop) {
        Long policyId = new Long(0L);
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("PolicyConfiguration");
            Enumeration e = prop.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                r.set(key, prop.get(key));
            }
            dataObject.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            policyId = (Long)r.get("POLICY_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyId;
    }

    public static void updatePolicyConfig(Long policyId, Hashtable prop) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
            Row r = obj.getFirstRow("PolicyConfiguration");
            Enumeration e = prop.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                r.set(key, prop.get(key));
            }
            obj.updateRow(r);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addPolicyCri(Long policyId, String domainName, String[] groupGuids, String[] ouGuids, Long loginId, String dontInherit) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c = new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"), (Object)domainName, 0, false);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", c);
            Row domainRow = o.getRow("ADSMDomainGeneralDetails");
            PolicyHandler.updateGRPPolicyCriteriaDO(obj, groupGuids, domainName, policyId, null);
            PolicyHandler.updateOUPolicyCriteriaDO(obj, ouGuids, domainName, policyId, loginId, domainRow, null);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            Hashtable<String, String> keyVal = new Hashtable<String, String>();
            keyVal.put("DONT_INHERIT_OUS", dontInherit);
            APCUtil.setRequestedPCValues(policyId, "SSPPolicyGeneral", keyVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateOUPolicyCriteriaDO(DataObject obj, String[] ouGuids, String domainName, Long policyId, Long loginId, Row domainRow, ArrayList selOUsList) {
        try {
            String domainGuid = (String)domainRow.get("OBJECT_GUID");
            if (ouGuids != null && ouGuids.length > 0) {
                ArrayList<String> selOUsGuids = new ArrayList<String>(Arrays.asList(ouGuids));
                if (selOUsGuids.contains(domainGuid)) {
                    Row row = new Row("PolicyCriteria");
                    row.set("POLICY_ID", (Object)policyId);
                    row.set("OBJECT_GUID", (Object)((String)domainRow.get("OBJECT_GUID")));
                    row.set("DISTINGUISHED_NAME", (Object)((String)domainRow.get("DISTINGUISHED_NAME")));
                    row.set("DOMAIN_NAME", (Object)domainName);
                    row.set("OBJECT_CLASS", (Object)"OU");
                    obj.addRow(row);
                    if (selOUsList != null) {
                        selOUsList.add((String)domainRow.get("DISTINGUISHED_NAME"));
                    }
                } else {
                    for (String ouGuid : ouGuids) {
                        String dn = OUUtil.getOUProp("OBJECT_GUID", ouGuid, "DISTINGUISHED_NAME", domainName, loginId);
                        if (dn == null) continue;
                        Row row = new Row("PolicyCriteria");
                        row.set("POLICY_ID", (Object)policyId);
                        row.set("OBJECT_GUID", (Object)ouGuid);
                        row.set("DISTINGUISHED_NAME", (Object)dn);
                        row.set("DOMAIN_NAME", (Object)domainName);
                        row.set("OBJECT_CLASS", (Object)"OU");
                        obj.addRow(row);
                        if (selOUsList == null) continue;
                        selOUsList.add(dn);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateGRPPolicyCriteriaDO(DataObject obj, String[] groupGuids, String domainName, Long policyId, ArrayList selGrpList) {
        try {
            if (groupGuids != null && groupGuids.length > 0) {
                JSONObject grpData = UserMgmtUtil.getGroupData(domainName, "OBJECT_GUID", groupGuids, new ArrayList<String>(Arrays.asList("DN_STRING")));
                for (String groupGuid : groupGuids) {
                    if (!grpData.has(groupGuid)) continue;
                    Row row = new Row("PolicyCriteria");
                    row.set("POLICY_ID", (Object)policyId);
                    row.set("OBJECT_GUID", (Object)groupGuid);
                    row.set("DISTINGUISHED_NAME", (Object)grpData.getJSONObject(groupGuid).getString("DN_STRING"));
                    row.set("DOMAIN_NAME", (Object)domainName);
                    row.set("OBJECT_CLASS", (Object)"GROUP");
                    obj.addRow(row);
                    if (selGrpList == null) continue;
                    selGrpList.add(groupGuid);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getPolicyCriteria(Long policyId, String domainName) {
        Hashtable<String, ArrayList> policyCriteriaDet = new Hashtable<String, ArrayList>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"), (Object)policyId, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyCriteria", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("PolicyCriteria");
                while (it.hasNext()) {
                    Properties prop = new Properties();
                    Row r = (Row)it.next();
                    String objClass = (String)r.get("OBJECT_CLASS");
                    String dn = (String)r.get("DISTINGUISHED_NAME");
                    ArrayList list = policyCriteriaDet.get(objClass) != null ? (ArrayList)policyCriteriaDet.get(objClass) : new ArrayList();
                    list.add(dn);
                    policyCriteriaDet.put(objClass, list);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyCriteriaDet;
    }

    public static void updatePolicyCri(Long policyId, String domainName, String[] groupGuids, String[] ouGuids, Hashtable deSelObjs, Long loginId, String dontInherit) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Criteria c = new Criteria(Column.getColumn((String)"ADSMDomainGeneralDetails", (String)"NAME"), (Object)domainName, 0, false);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", c);
            Row domainRow = o.getRow("ADSMDomainGeneralDetails");
            String domainGuid = (String)domainRow.get("OBJECT_GUID");
            String domainDN = (String)domainRow.get("DISTINGUISHED_NAME");
            ArrayList selOUsList = new ArrayList();
            ArrayList selGrpList = new ArrayList();
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"), (Object)policyId, 0, false);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            PolicyHandler.updateGRPPolicyCriteriaDO(obj, groupGuids, domainName, policyId, selGrpList);
            PolicyHandler.updateOUPolicyCriteriaDO(obj, ouGuids, domainName, policyId, loginId, domainRow, selOUsList);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            Hashtable<String, String> keyVal = new Hashtable<String, String>();
            keyVal.put("DONT_INHERIT_OUS", dontInherit);
            APCUtil.setRequestedPCValues(policyId, "SSPPolicyGeneral", keyVal);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addADMPRole(Long policyId, String[] actions, HttpServletRequest request) {
        try {
            ArrayList<Long> actionsArr = new ArrayList<Long>();
            for (String str : actions) {
                actionsArr.add(Long.parseLong(str));
            }
            DataObject addDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (!actionsArr.isEmpty() && actionsArr.size() != 0) {
                Row r = new Row("UpdatePermissions");
                for (int i = 0; i < actionsArr.size(); ++i) {
                    r = new Row("UpdatePermissions");
                    r.set("POLICY_ID", (Object)policyId);
                    r.set("ACTION_ID", (Object)((Long)actionsArr.get(i)));
                    addDataObject.addRow(r);
                }
            }
            CommonUtil.getPersistenceLite().add(addDataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void updateADMPRole(Long roleId, Long policyId, String name, String desc, String[] actions, HttpServletRequest request) {
        try {
            ArrayList<Long> actionsArr = new ArrayList<Long>();
            for (String str : actions) {
                actionsArr.add(Long.parseLong(str));
            }
            Criteria criteria = new Criteria(Column.getColumn((String)"ADMPRoles", (String)"ADMP_ROLE_ID"), (Object)roleId, 0);
            DataObject updateDataObject = CommonUtil.getPersistence(new boolean[0]).get("ADMPRoles", criteria);
            Row row = updateDataObject.getRow("ADMPRoles");
            row.set("ADMP_ROLE_NAME", (Object)name);
            row.set("ADMP_ROLE_DESCRIPTION", (Object)desc);
            row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
            updateDataObject.updateRow(row);
            CommonUtil.getPersistence(new boolean[0]).update(updateDataObject);
            DataObject addDataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (!actionsArr.isEmpty() && actionsArr.size() != 0) {
                Criteria delCri = new Criteria(Column.getColumn((String)"UpdatePermissions", (String)"POLICY_ID"), (Object)policyId, 0);
                CommonUtil.getPersistence(new boolean[0]).delete(delCri);
                for (int i = 0; i < actionsArr.size(); ++i) {
                    Row row2 = new Row("UpdatePermissions");
                    row2.set("POLICY_ID", (Object)policyId);
                    row2.set("ACTION_ID", (Object)((Long)actionsArr.get(i)));
                    addDataObject.addRow(row2);
                }
            }
            CommonUtil.getPersistenceLite().add(addDataObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isSortAllowed() {
        try {
            ArrayList<String> listn = new ArrayList<String>();
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSMDomainGeneralDetails");
                while (it.hasNext()) {
                    Properties prop = new Properties();
                    Row r = (Row)it.next();
                    String name = (String)r.get("NAME");
                    listn.add(name);
                }
                for (int i = 0; i < listn.size(); ++i) {
                    Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), listn.get(i), 0, false);
                    DataObject o = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
                    if (o.size("PolicyConfiguration") <= 1) continue;
                    return true;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public static Boolean isPolicyUpdated() {
        Boolean check = false;
        try {
            DataObject o;
            Criteria crit;
            int i;
            ArrayList<String> listn = new ArrayList<String>();
            ArrayList<String> listdn = new ArrayList<String>();
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADSMDomainGeneralDetails", (Criteria)null);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("ADSMDomainGeneralDetails");
                while (it.hasNext()) {
                    Properties prop = new Properties();
                    Row r = (Row)it.next();
                    String disName = (String)r.get("DISTINGUISHED_NAME");
                    String name = (String)r.get("NAME");
                    listdn.add(disName);
                    listn.add(name);
                }
            }
            for (i = 0; i < listdn.size(); ++i) {
                crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DISTINGUISHED_NAME"), listdn.get(i), 0, false);
                o = CommonUtil.getPersistence(new boolean[0]).get("PolicyCriteria", crit);
                if (!o.isEmpty()) continue;
                check = true;
                break;
            }
            if (!check.booleanValue()) {
                for (i = 0; i < listn.size(); ++i) {
                    crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), listn.get(i), 0, false);
                    o = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
                    if (o.size("PolicyConfiguration") <= 1) continue;
                    check = true;
                    break;
                }
                if (i == listn.size()) {
                    check = false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return check;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getQuestionDetails(Long pId) {
        ArrayList<Properties> list = new ArrayList<Properties>();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String tN = "SSPSecretQues";
            Criteria crit = new Criteria(Column.getColumn((String)tN, (String)"POLICY_ID"), (Object)pId, 0);
            if (pId == 0L) {
                crit = null;
                tN = "SSPBuildInQ";
            }
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tN));
            sq.addSelectColumn(Column.getColumn((String)tN, (String)"*"));
            sq.setCriteria(crit);
            sq.addSortColumn(new SortColumn(Column.getColumn((String)tN, (String)"QUESTION_ID"), true));
            RelationalAPI relApi = RelationalAPI.getInstance();
            connection = relApi.getConnection();
            dataSet = relApi.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Properties prop = new Properties();
                prop.put("QUESTION_ID", (Object)dataSet.getLong("QUESTION_ID"));
                String qT = dataSet.getString("QUESTION_TEXT");
                prop.put("QUESTION_TEXT", qT);
                prop.put("QUESTION_TYPE", "PreDefined");
                if (pId != 0L) {
                    prop.put("MANDATORY", dataSet.getString("MANDATORY"));
                } else {
                    prop.put("MANDATORY", "No");
                }
                list.add(prop);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return list;
    }

    public static void addQuestionDetails(Long pId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"POLICY_ID"), (Object)pId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPSecretQues", c);
            if (o.isEmpty()) {
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                o = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQ", (Criteria)null);
                Iterator it = o.getRows("SSPBuildInQ");
                while (it.hasNext()) {
                    Row buildInQRow = (Row)it.next();
                    Row newRow = new Row("SSPSecretQues");
                    newRow.set("POLICY_ID", (Object)pId);
                    newRow.set("QUESTION_TEXT", (Object)((String)buildInQRow.get("QUESTION_TEXT")));
                    obj.addRow(newRow);
                }
                CommonUtil.getPersistenceLite().add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deletePolicyScheduler(String domainName) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", c);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows("SchedulerConfiguration");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), r.get("SCHEDULE_ID"), 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteSTEPScheduler(String domainName) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerReportOUs", c);
            if (!dataObj.isEmpty()) {
                Iterator iterator = dataObj.getRows("SSPSchedulerReportOUs");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    Long schedulerId = (Long)r.get("SCHEDULE_ID");
                    c = new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"SCHEDULE_ID"), (Object)schedulerId, 0, false);
                    DataObject dO = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerReportOUs", c);
                    if (dO.isEmpty() || dO.size("SSPSchedulerReportOUs") != 1) continue;
                    Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)schedulerId, 0);
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String deletePolicy(Long policyId, String policyName, String domainName, HttpServletRequest request) throws Exception {
        String message = "";
        try {
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle(request);
            if (policyId != null) {
                PolicyHandler.disableMappedPolicy(policyId);
                ArrayList<Object> policyIds = new ArrayList<Object>();
                Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
                DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
                if (!dataObj.isEmpty()) {
                    Iterator iterator = dataObj.getRows("PolicyConfiguration");
                    while (iterator.hasNext()) {
                        Row r = (Row)iterator.next();
                        policyIds.add(r.get("POLICY_ID"));
                    }
                }
                if (policyIds.size() != 1) {
                    Row r;
                    Criteria c = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
                    dataObj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", c);
                    Iterator iterator = dataObj.getRows("SchedulerConfiguration");
                    while (iterator.hasNext()) {
                        r = (Row)iterator.next();
                        c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), r.get("SCHEDULE_ID"), 0);
                        dataObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", c);
                        CommonUtil.getPersistence(new boolean[0]).delete(c);
                    }
                    c = new Criteria(Column.getColumn((String)"SSPSchedulerPolicyMapping", (String)"POLICY_ID"), (Object)policyId, 0);
                    dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerPolicyMapping", c);
                    iterator = dataObj.getRows("SSPSchedulerPolicyMapping");
                    while (iterator.hasNext()) {
                        r = (Row)iterator.next();
                        Long schId = (Long)r.get("SCHEDULE_ID");
                        Criteria criteria = new Criteria(Column.getColumn((String)"SSPSchedulerPolicyMapping", (String)"SCHEDULE_ID"), (Object)schId, 0);
                        dataObj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerPolicyMapping", criteria);
                        if (dataObj.size("SSPSchedulerPolicyMapping") != 1) continue;
                        c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), r.get("SCHEDULE_ID"), 0);
                        dataObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", c);
                        CommonUtil.getPersistence(new boolean[0]).delete(c);
                    }
                    crit = crit.and(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0));
                    CommonUtil.getPersistence(new boolean[0]).delete(crit);
                    message = MessageFormat.format(rb.getString("adssp.admin.policies.policy_config.policy_success_deleted"), StrUtil.encodeURIComponent(policyName));
                } else {
                    message = rb.getString("adssp.admin.policies.policy_config.status_unable.message");
                }
            }
            PPEHandler.deleteAllDictsForPolicy(policyId);
        }
        catch (Exception e) {
            e.printStackTrace();
            message = e.getMessage();
        }
        return message;
    }

    public static ArrayList getLoginQuestions(Long loginId, HttpServletRequest request) {
        ArrayList questionList = new ArrayList();
        try {
            questionList = PolicyHandler.getQuestionList(loginId, request);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPCustomQAMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPCustomQAMap", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPCustomQAMap", crit);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    JSONObject prop = new JSONObject();
                    prop.put("QUESTION_ID", r.get("QUESTION_ID"));
                    prop.put("QUESTION_TEXT", r.get("QUESTION_TEXT"));
                    prop.put("QUESTION_TYPE", (Object)"CustomDefined");
                    questionList.add(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return questionList;
    }

    public static int getNewPolicyPriority(String domainName) {
        int priority = 0;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"PolicyConfiguration"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"PRIORITY"));
            sq.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"));
            sq.addSortColumn(new SortColumn(Column.getColumn((String)"PolicyConfiguration", (String)"PRIORITY"), false));
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            sq.setCriteria(crit);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            priority = (Integer)obj.getFirstValue("PolicyConfiguration", "PRIORITY") + 1;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return priority;
    }

    public static ArrayList getQuestionList(Long loginId, HttpServletRequest request) {
        ArrayList<JSONObject> list = new ArrayList<JSONObject>();
        try {
            Locale locale = ResourceBundleMgr.getInstance().getClientLocale(loginId, request);
            ADSResourceBundle rb = I18N.getInstance().getBundle("adssp/ApplicationResources", locale);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQAMap", crit);
            if (!o.isEmpty()) {
                Iterator it = o.getRows("SSPBuildInQAMap");
                while (it.hasNext()) {
                    JSONObject prop = new JSONObject();
                    Row r = (Row)it.next();
                    Long qId = (Long)r.get("QUESTION_ID");
                    Criteria c = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_ID"), (Object)qId, 0);
                    DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecretQues", c);
                    Row row = dObj.getFirstRow("SSPSecretQues");
                    String qT = (String)row.get("QUESTION_TEXT");
                    String qText = rb.getString(qT);
                    prop.put("QUESTION_ID", (Object)qId);
                    prop.put("QUESTION_TEXT", (Object)qText);
                    prop.put("QUESTION_TYPE", (Object)"PreDefined");
                    list.add(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getUsedQuestions(Long policyId) {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQAMap", (Criteria)null);
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecretQues", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("SSPSecretQues");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long qId = (Long)r.get("QUESTION_ID");
                    Criteria c = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"QUESTION_ID"), (Object)qId, 0);
                    Row r1 = o.getRow("SSPBuildInQAMap", c);
                    if (r1 == null || list.contains(qId)) continue;
                    list.add(qId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void deleteUserQuestions(Long loginId) {
        try {
            Criteria preCrit = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0, false);
            CommonUtil.getPersistence(new boolean[0]).delete(preCrit);
            Criteria userCrit = new Criteria(Column.getColumn((String)"SSPCustomQAMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0, false);
            CommonUtil.getPersistence(new boolean[0]).delete(userCrit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addBuildInQA(Long loginId, Long policyId, HashMap ansProp) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (obj.isEmpty()) {
                Set st = ansProp.keySet();
                for (Long qId : st) {
                    Row r = new Row("SSPBuildInQAMap");
                    r.set("USER_LOGIN_ID", (Object)loginId);
                    r.set("QUESTION_ID", (Object)qId);
                    PolicyHandler.addAnswer(policyId, (String)ansProp.get(qId), r);
                    obj.addRow(r);
                }
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList addBuildInQA(ArrayList enrollList, ArrayList failure) throws Exception {
        try {
            DataObject objS = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQAMap", (Criteria)null);
            DataObject objR = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", (Criteria)null);
            for (int i = 0; i < enrollList.size(); ++i) {
                Hashtable hash = (Hashtable)enrollList.get(i);
                Long polId = (Long)hash.get("PId");
                Long loginId = (Long)hash.get("LoginId");
                Long qId = (Long)hash.get("QId");
                Boolean update = (Boolean)hash.get("Delete_Pre");
                String sAN = (String)hash.get("samAccName");
                Criteria crit = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
                Row r = objS.getRow("SSPBuildInQAMap", crit = crit.and(Column.getColumn((String)"SSPBuildInQAMap", (String)"QUESTION_ID"), (Object)qId, 0));
                if (r == null) {
                    r = new Row("SSPBuildInQAMap");
                    r.set("USER_LOGIN_ID", (Object)loginId);
                    r.set("QUESTION_ID", (Object)qId);
                    PolicyHandler.addAnswer(polId, (String)hash.get("Answer"), r);
                    objS.addRow(r);
                } else if (update.booleanValue()) {
                    PolicyHandler.addAnswer(polId, (String)hash.get("Answer"), r);
                    objS.updateRow(r);
                } else {
                    failure.add(sAN);
                    continue;
                }
                Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
                Row row = objR.getRow("SSPUserPropertyMap", c);
                if (row == null) {
                    row = new Row("SSPUserPropertyMap");
                    row.set("ENROLLED_TIME", (Object)System.currentTimeMillis());
                    row.set("USER_LOGIN_ID", (Object)loginId);
                    row.set("REGISTRATION_STATUS", (Object)new Integer(1));
                    objR.addRow(row);
                    continue;
                }
                row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
                objR.updateRow(row);
            }
            CommonUtil.getPersistence(new boolean[0]).update(objS);
            CommonUtil.getPersistence(new boolean[0]).update(objR);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return failure;
    }

    public static void addCustomQA(Long loginId, Long policyId, ArrayList qaList) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            if (obj.isEmpty()) {
                for (int i = 0; i < qaList.size(); ++i) {
                    Properties p = (Properties)qaList.get(i);
                    Row r = new Row("SSPCustomQAMap");
                    r.set("USER_LOGIN_ID", (Object)loginId);
                    r.set("QUESTION_TEXT", p.get("Q_TEXT"));
                    PolicyHandler.addAnswer(policyId, (String)p.get("A_TEXT"), r);
                    obj.addRow(r);
                }
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Properties addQuestion(Long policyId, String question, ArrayList buildInQues) {
        Long questionId = 0L;
        Properties prop = new Properties();
        try {
            questionId = PolicyHandler.buildInQID(buildInQues, question);
            if (!questionId.equals(0L)) {
                prop.put("QUESTION_ID", questionId);
                prop.put("QUESTION_LIST", buildInQues);
                return prop;
            }
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_TEXT"), (Object)question, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecretQues", crit);
            if (obj.isEmpty()) {
                Row r = new Row("SSPSecretQues");
                r.set("POLICY_ID", (Object)policyId);
                r.set("QUESTION_TEXT", (Object)question);
                r.set("MANDATORY", (Object)"NO");
                obj.addRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
            Row row = obj.getRow("SSPSecretQues");
            questionId = (Long)row.get("QUESTION_ID");
            Properties quesProp = new Properties();
            quesProp.put("QUESTION_ID", questionId);
            quesProp.put("QUESTION_TEXT", question);
            quesProp.put("MANDATORY", "NO");
            quesProp.put("QUESTION_TYPE", "PreDefined");
            buildInQues.add(quesProp);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        prop.put("QUESTION_ID", questionId);
        prop.put("QUESTION_LIST", buildInQues);
        return prop;
    }

    public static Long buildInQID(ArrayList list, String question) {
        Long questionId = 0L;
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        for (int i = 0; i < list.size(); ++i) {
            Properties quesProps = (Properties)list.get(i);
            Enumeration<Object> e = quesProps.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                if (!key.equals("QUESTION_TEXT") || !rb.getString((String)quesProps.get("QUESTION_TEXT")).equalsIgnoreCase(question)) continue;
                return (Long)quesProps.get("QUESTION_ID");
            }
        }
        return questionId;
    }

    public static Hashtable getQASettings(Long policyId) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPQASettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPQASettings", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("SSPQASettings");
                hash.put("PRE_DEFINED_QUESTIONS", (Integer)r.get("PRE_DEFINED_QUESTIONS"));
                hash.put("USER_DEFINED_QUESTIONS", (Integer)r.get("USER_DEFINED_QUESTIONS"));
                hash.put("QUES_MIN_LENGTH", (Integer)r.get("QUES_MIN_LENGTH"));
                hash.put("QUES_MAX_LENGTH", (Integer)r.get("QUES_MAX_LENGTH"));
                hash.put("ANS_MIN_LENGTH", (Integer)r.get("ANS_MIN_LENGTH"));
                hash.put("ANS_MAX_LENGTH", (Integer)r.get("ANS_MAX_LENGTH"));
                hash.put("DENY_DUP_ANS", (String)r.get("DENY_DUP_ANS"));
                hash.put("DENY_WORD_FRM_QUE", (String)r.get("DENY_WORD_FRM_QUE"));
                hash.put("DENY_USER_NAME_AS_ANS", (String)r.get("DENY_USER_NAME_AS_ANS"));
            }
            hash.put("HIDE_ANSWER", AdvancedPolicyHandler.getRequiredPCValue(policyId, "HIDE_ANSWER", "SSPSecurity"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static void setQASettings(Long policyId, Hashtable hash) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPQASettings", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPQASettings", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("SSPQASettings");
                Enumeration e = hash.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    r.set(key, hash.get(key));
                }
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            } else {
                PolicyHandler.addQASettings(policyId, hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addQASettings(Long policyId, Hashtable hash) {
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPQASettings");
            r.set("POLICY_ID", (Object)policyId);
            Enumeration e = hash.keys();
            while (e.hasMoreElements()) {
                String key = (String)e.nextElement();
                r.set(key, hash.get(key));
            }
            obj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
            PolicyHandler.addQuestionDetails(policyId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean verifyAnswers(Long loginId, Long qId, String ansText, String tableName, Long policyId) {
        boolean status = false;
        try {
            Hashtable hash = new Hashtable();
            hash = PolicyHandler.getProps(loginId);
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"QUESTION_ID"), (Object)qId, 0));
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!o.isEmpty()) {
                Row r = o.getFirstRow(tableName);
                String salt = (String)r.get("SALT");
                String algorithm = (String)r.get("ALGORITHM");
                String ansDBText = "";
                String caseSensitive = AdvancedPolicyHandler.getRequiredPCValue(policyId, "SQA_CASE_SENSITIVE", "SSPQASettings");
                if (!caseSensitive.equals("1")) {
                    ansText = ansText.toLowerCase();
                }
                if (!salt.equals("")) {
                    ansDBText = (String)r.get("ANSWER_TEXT");
                    String encAnswer = AuthUtil.getEncryptedPassword((String)ansText, (String)salt, (String)algorithm);
                    if (encAnswer.equals(ansDBText)) {
                        status = true;
                    }
                } else {
                    ansDBText = (String)r.get("ANSWER_TWO_WAY");
                    if (!caseSensitive.equals("1")) {
                        ansDBText = ansDBText.toLowerCase();
                    }
                    if (ansText.equals(ansDBText)) {
                        status = true;
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static Hashtable checkPermission(String domainName, String samAccName) {
        Boolean status = false;
        try {
            Properties userPro = UserUtil.getUserObjectDetails(samAccName, domainName, new String[]{"distinguishedName", "objectGUID", "memberOf", "primaryGroupID", "objectSID"}, true);
            String userDN = ((String)((ArrayList)userPro.get("distinguishedName")).get(0)).toLowerCase();
            ArrayList userGroups = (ArrayList)userPro.get("memberOf");
            String primaryGroup = GroupUtil.getPrimaryGroup(domainName, (String)((ArrayList)userPro.get("primaryGroupID")).get(0));
            if (primaryGroup != null) {
                userGroups.add(primaryGroup);
            }
            return PolicyHandler.checkUserPermission(domainName, userDN, userGroups);
        }
        catch (NullPointerException ne) {
            ne.getMessage();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return new Hashtable();
    }

    public static Hashtable checkPermission(String domainName, String samAccName, ArrayList userGroups) {
        Boolean status = false;
        try {
            String userOUDN = UserUtil.getUserDNFrmDB(domainName, samAccName);
            return PolicyHandler.checkUserPermission(domainName, userOUDN, userGroups);
        }
        catch (Exception e) {
            e.printStackTrace();
            return new Hashtable();
        }
    }

    public static Hashtable checkUserPermission(String domainName, String userOUDN, ArrayList groupsDN) {
        Hashtable hashOU = new Hashtable();
        Hashtable hashGroup = new Hashtable();
        try {
            hashOU = PolicyHandler.checkDNPermission(domainName, userOUDN);
            hashGroup.put("status", false);
            if (groupsDN != null && !groupsDN.isEmpty()) {
                hashGroup = PolicyHandler.checkGroupDNPermission(domainName, groupsDN.toArray(new String[groupsDN.size()]), userOUDN);
            }
            if (((Boolean)hashGroup.get("status")).booleanValue()) {
                if (((Boolean)hashOU.get("status")).booleanValue()) {
                    if ((Integer)hashGroup.get("priority") < (Integer)hashOU.get("priority")) {
                        return hashGroup;
                    }
                    return hashOU;
                }
                return hashGroup;
            }
            return hashOU;
        }
        catch (Exception e) {
            e.printStackTrace();
            return hashOU;
        }
    }

    public static Hashtable checkGroupDNPermission(String domainName, String[] groupsDN) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        Boolean status = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DISTINGUISHED_NAME"), (Object)groupsDN, 8, false));
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_CLASS"), (Object)"GROUP", 0, false));
            Join j = new Join(Table.getTable((String)"PolicyCriteria"), Table.getTable((String)"PolicyConfiguration"), new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"PolicyCriteria"));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"));
            query.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"));
            query.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"PRIORITY"));
            query.addSortColumn(new SortColumn("PolicyConfiguration", "PRIORITY", true));
            query.addJoin(j);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                status = true;
                hash.put("policyId", dataObject.getFirstValue("PolicyCriteria", "POLICY_ID"));
                hash.put("priority", dataObject.getFirstValue("PolicyConfiguration", "PRIORITY"));
            }
            hash.put("status", status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static Hashtable checkGroupDNPermission(String domainName, String[] groupsDN, String userOUDN) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        Boolean status = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DISTINGUISHED_NAME"), (Object)groupsDN, 8, false));
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_CLASS"), (Object)"GROUP", 0, false));
            Join j = new Join(Table.getTable((String)"PolicyCriteria"), Table.getTable((String)"PolicyConfiguration"), new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2);
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"PolicyCriteria"));
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"POLICY_ID"));
            query.addSelectColumn(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_GUID"));
            query.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"));
            query.addSelectColumn(Column.getColumn((String)"PolicyConfiguration", (String)"PRIORITY"));
            query.addSortColumn(new SortColumn("PolicyConfiguration", "PRIORITY", true));
            query.addJoin(j);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows("PolicyCriteria");
                while (it.hasNext()) {
                    Row polCriRow = (Row)it.next();
                    Long policyId = (Long)polCriRow.get("POLICY_ID");
                    Object priority = dataObject.getValue("PolicyConfiguration", "PRIORITY", new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0));
                    Hashtable PLDAPCriteria = PolicyHandler.checkPolicyLDAPCriteria(policyId, domainName, userOUDN);
                    if (((Boolean)PLDAPCriteria.get("PLDAPCriStatus")).booleanValue()) {
                        if (((Boolean)PLDAPCriteria.get("status")).booleanValue()) {
                            status = true;
                            hash.put("policyId", policyId);
                            hash.put("priority", priority);
                            break;
                        }
                        status = false;
                        continue;
                    }
                    status = true;
                    hash.put("policyId", policyId);
                    hash.put("priority", priority);
                    break;
                }
            }
            hash.put("status", status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static Hashtable checkDNPermission(String domainName, String userOUDN) {
        Hashtable hash = new Hashtable();
        try {
            SelectQueryImpl query = new SelectQueryImpl(Table.getTable((String)"PolicyCriteria"));
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_CLASS"), (Object)"OU", 0, false));
            Join j = new Join(Table.getTable((String)"PolicyCriteria"), Table.getTable((String)"PolicyConfiguration"), new String[]{"POLICY_ID"}, new String[]{"POLICY_ID"}, 2);
            query.addJoin(j);
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn(null, (String)"*"));
            query.addSortColumn(new SortColumn("PolicyConfiguration", "PRIORITY", true));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            hash = PolicyHandler.checkDNPermission(obj, userOUDN, domainName);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static Hashtable checkDNPermission(DataObject polConDO, String userOUDN, String domainName) {
        Hashtable<String, Object> hash = new Hashtable<String, Object>();
        Boolean status = false;
        try {
            DataObject polGenDO = CommonUtil.getPersistence(new boolean[0]).get("SSPPolicyGeneral", (Criteria)null);
            if (!polConDO.isEmpty()) {
                Iterator it = polConDO.getRows("PolicyCriteria");
                Boolean dontInherit = false;
                while (it.hasNext()) {
                    Row polCriRow = (Row)it.next();
                    Long policyId = (Long)polCriRow.get("POLICY_ID");
                    String ou = ((String)polCriRow.get("DISTINGUISHED_NAME")).toLowerCase();
                    Criteria crit = new Criteria(Column.getColumn((String)"SSPPolicyGeneral", (String)"POLICY_ID"), (Object)policyId, 0);
                    Row polGenRow = polGenDO.getRow("SSPPolicyGeneral", crit);
                    dontInherit = polGenRow.get("DONT_INHERIT_OUS").equals("1");
                    if (!userOUDN.endsWith(ou)) continue;
                    Object priority = polConDO.getValue("PolicyConfiguration", "PRIORITY", new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0));
                    Hashtable PLDAPCriteria = PolicyHandler.checkPolicyLDAPCriteria(policyId, domainName, userOUDN);
                    if (dontInherit.booleanValue()) {
                        if (!PolicyHandler.isUserDNPermitted(ou, userOUDN)) continue;
                        if (((Boolean)PLDAPCriteria.get("PLDAPCriStatus")).booleanValue()) {
                            if (((Boolean)PLDAPCriteria.get("status")).booleanValue()) {
                                status = true;
                                hash.put("policyId", policyId);
                                hash.put("priority", priority);
                                break;
                            }
                            status = false;
                            continue;
                        }
                        status = true;
                        hash.put("policyId", policyId);
                        hash.put("priority", priority);
                        break;
                    }
                    if (((Boolean)PLDAPCriteria.get("PLDAPCriStatus")).booleanValue()) {
                        if (((Boolean)PLDAPCriteria.get("status")).booleanValue()) {
                            status = true;
                            hash.put("policyId", policyId);
                            hash.put("priority", priority);
                            break;
                        }
                        status = false;
                        continue;
                    }
                    status = true;
                    hash.put("policyId", policyId);
                    hash.put("priority", priority);
                    break;
                }
            }
            hash.put("status", status);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Hashtable checkPolicyLDAPCriteria(long policyID, String domainName, String userDN) {
        Hashtable<String, Serializable> hash = new Hashtable<String, Serializable>();
        Boolean status = false;
        Boolean PLDAPCriStatus = false;
        try {
            ArrayList<String> ldapAttributes = new ArrayList<String>();
            JSONArray conditions = PolicyHandler.getPolicyLDAPCriteria(policyID);
            for (int i = 0; i < conditions.length() && conditions.getJSONObject(i).has("ATTRIB_LDAP_NAME"); ++i) {
                ldapAttributes.add(conditions.getJSONObject(i).getString("ATTRIB_LDAP_NAME"));
            }
            Properties attributeProps = new Properties();
            attributeProps = UserUtil.getObjValList(userDN, DomainHandler.getConfiguredValues(domainName, new Long(1L)), ldapAttributes, "distinguishedName");
            boolean isPolicyCriteriaTrue = false;
            if (conditions.length() > 0) {
                PLDAPCriStatus = true;
            }
            for (int i = 0; i < conditions.length() && conditions.getJSONObject(i).has("ATTRIB_LDAP_NAME"); ++i) {
                JSONObject condition = conditions.getJSONObject(i);
                String ldapName = condition.getString("ATTRIB_LDAP_NAME");
                String relationalOperator = condition.getString("RELATIONAL_OPERATOR");
                String logicalOpr = condition.getString("LOGICAL_OPERATOR");
                String attributeValue = condition.getString("ATTRIB_VALUE");
                int policyPriority = condition.getInt("PRIORITY");
                boolean isConditionTrue = false;
                ArrayList directoryValues = new ArrayList();
                directoryValues = (ArrayList)attributeProps.get(ldapName);
                String directoryValue = null;
                if (directoryValues != null && !directoryValues.isEmpty()) {
                    String Value = (String)directoryValues.get(0);
                    for (int j = 1; j < directoryValues.size(); ++j) {
                        Value = Value + "," + (String)directoryValues.get(j);
                    }
                    if (Value.length() > 0) {
                        directoryValue = Value;
                    }
                }
                if (directoryValue != null) {
                    directoryValue = directoryValue.toLowerCase();
                }
                attributeValue = attributeValue.toLowerCase();
                switch (relationalOperator) {
                    case "equals": {
                        if (directoryValue == null || !(isConditionTrue = attributeValue.equalsIgnoreCase(directoryValue))) break;
                        break;
                    }
                    case "not_equals": {
                        if (directoryValue != null) {
                            isConditionTrue = !attributeValue.equalsIgnoreCase(directoryValue);
                            break;
                        }
                        isConditionTrue = true;
                        break;
                    }
                    case "contains": {
                        if (directoryValue == null) break;
                        isConditionTrue = directoryValue.contains(attributeValue);
                        break;
                    }
                    case "not_contains": {
                        if (directoryValue != null) {
                            isConditionTrue = !directoryValue.contains(attributeValue);
                            break;
                        }
                        isConditionTrue = true;
                        break;
                    }
                    case "starts_with": {
                        if (directoryValue == null) break;
                        isConditionTrue = directoryValue.startsWith(attributeValue);
                        break;
                    }
                    case "ends_with": {
                        if (directoryValue == null) break;
                        isConditionTrue = directoryValue.endsWith(attributeValue);
                        break;
                    }
                    case "empty": {
                        if (directoryValue != null) break;
                        isConditionTrue = true;
                        break;
                    }
                    case "not_empty": {
                        if (directoryValue == null) break;
                        isConditionTrue = true;
                    }
                }
                if (i == 0) {
                    isPolicyCriteriaTrue = isConditionTrue;
                } else if ("or".equals(logicalOpr)) {
                    isPolicyCriteriaTrue = isPolicyCriteriaTrue || isConditionTrue;
                } else {
                    boolean bl = isPolicyCriteriaTrue = isPolicyCriteriaTrue && isConditionTrue;
                }
                if (i != conditions.length() - 1 || !isPolicyCriteriaTrue) continue;
                status = true;
                hash.put("policyId", Long.valueOf(policyID));
                hash.put("priority", Integer.valueOf(policyPriority));
            }
        }
        catch (JSONException e) {
            e.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            hash.put("status", status);
            hash.put("PLDAPCriStatus", PLDAPCriStatus);
        }
        return hash;
    }

    /*
     * Exception decompiling
     */
    public static JSONArray getPolicyLDAPCriteria(long policyID) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public static void setPolicyPriority(JSONObject policyPriorityMap) {
        try {
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = cred.getLoginId();
            Criteria criteria = null;
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                criteria = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", criteria);
            Iterator it = dObj.getRows("PolicyConfiguration");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String policyId = r.get("POLICY_ID").toString();
                if (!policyPriorityMap.has(policyId)) continue;
                r.set("PRIORITY", (Object)policyPriorityMap.getInt(policyId));
                dObj.updateRow(r);
            }
            CommonUtil.getPersistence(new boolean[0]).update(dObj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static boolean isUserDNPermitted(String ouDN, String userDN) {
        return userDN.endsWith(ouDN) && userDN.replace("," + ouDN, "").indexOf(",ou=") == -1;
    }

    public static boolean isUserDNPermitted(ArrayList ouList, String userOuDN, Boolean inherit) {
        boolean ret = false;
        String userOUDN = userOuDN.toLowerCase();
        for (int i = 0; i < ouList.size(); ++i) {
            if (inherit.booleanValue()) {
                if (!userOUDN.endsWith(((String)ouList.get(i)).toLowerCase())) continue;
                return true;
            }
            ret = ret || PolicyHandler.isUserDNPermitted(((String)ouList.get(i)).toLowerCase(), userOUDN);
        }
        return ret;
    }

    public static Boolean isUserRestricted(String objGuid) {
        Boolean status = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"StaleAccountUsers", (String)"OBJECT_GUID"), (Object)objGuid, 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("StaleAccountUsers", crit);
            if (!obj.isEmpty()) {
                status = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        logger.log(Level.INFO, objGuid + " isRestricted USER :: " + status);
        return status;
    }

    public static Boolean isAccountRestricted(DataObject staleAccDO, String objectGuid) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"StaleAccountUsers", (String)"OBJECT_GUID"), (Object)objectGuid, 0, false);
            return staleAccDO.getRow("StaleAccountUsers", crit) != null;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void checkLicense(ArrayList sAMAccountNames, String domainName) throws Exception {
        AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
        int count = sAMAccountNames.size();
        String[] sANArr = sAMAccountNames.toArray(new String[count]);
        int enrollCount = count - PolicyHandler.getLicensedCount(sANArr, domainName);
        int userCount = ADMPUserHandler.getADMPUsersCount();
        int licensedUser = Integer.parseInt(CommonUtil.getLicenseProperty("DomainUsers", "NumberOfUsers"));
        logger.log(Level.INFO, "License-Used : " + userCount + ". Gonna Enroll : " + enrollCount + ". Purchased for : " + licensedUser);
        if (userCount + enrollCount > licensedUser) {
            if (LicenseManager.getInstance().isFree() || LicenseManager.getInstance().isTrial()) {
                throw new Exception("adssp.exception.java.license.trial_restrict");
            }
            if (LicenseManager.getInstance().isRegistered()) {
                throw new Exception(MessageFormat.format(rb.getString("adssp.exception.java.license.purchase_restrict_array"), licensedUser));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getLicensedCount(String[] samAcNames, String domainName) {
        int count = 0;
        Criteria crit = null;
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String tableName = "AaaLogin";
            crit = new Criteria(Column.getColumn((String)tableName, (String)"NAME"), (Object)samAcNames, 8, false);
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Column col = Column.getColumn(null, (String)"*").count();
            sq.addSelectColumn(col);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAINNAME"), (Object)domainName, 0, false));
            sq.setCriteria(crit);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                count = (Integer)dataSet.getValue(1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            if (dataSet != null) {
                try {
                    dataSet.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
        return count;
    }

    public static Long getResestQId(Long policyId) {
        Long resQId = 0L;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"POLICY_ID"), (Object)policyId, 0, false);
            crit = crit.and(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_TEXT"), (Object)"adssp.xml.qadesign.alert_select_qn", 0, false);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecretQues", crit);
            Iterator it = obj.getRows("SSPSecretQues");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                resQId = (Long)r.get("QUESTION_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resQId;
    }

    public static Hashtable getProps(Long loginId) {
        Hashtable<String, String> hash = new Hashtable<String, String>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("AaaLogin", crit);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    hash.put("SamAccountName", (String)r.get("NAME"));
                    hash.put("DomainName", (String)r.get("DOMAINNAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return hash;
    }

    public static void addAnswer(Long policyId, String answer, Row row) {
        try {
            String twoWay = AdvancedPolicyHandler.getRequiredPCValue(policyId, "ENCRYPT_TWO_WAY", "SSPSecurity");
            String caseSensitive = AdvancedPolicyHandler.getRequiredPCValue(policyId, "SQA_CASE_SENSITIVE", "SSPQASettings");
            if (!caseSensitive.equals("1")) {
                answer = answer.toLowerCase();
            }
            if (twoWay.equals("1")) {
                row.set("ANSWER_TWO_WAY", (Object)answer);
                row.set("SALT", (Object)"");
                row.set("ANSWER_TEXT", (Object)"");
            } else {
                String salt = String.valueOf(System.currentTimeMillis());
                String algorithm = APCUtil.getAlgorithm(policyId);
                row.set("ALGORITHM", (Object)algorithm);
                row.set("ANSWER_TEXT", (Object)AuthUtil.getEncryptedPassword((String)answer, (String)salt, (String)algorithm));
                row.set("SALT", (Object)salt);
                row.set("ANSWER_TWO_WAY", (Object)"");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Criteria getCriteriaForPoliciesWithEnrollPermission() {
        Criteria criteria = null;
        try {
            criteria = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"RESET_PASSWORD"), (Object)"true", 0, false);
            criteria = criteria.or(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"UNLOCK_ACCOUNT"), (Object)"true", 0, false));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return criteria;
    }

    public static Properties getPoliciesWithEnrollPermission() {
        Properties prop = new Properties();
        try {
            Long loggedOnLoginId;
            Credential cred = AuthUtil.getUserCredential();
            Criteria criteria = PolicyHandler.getCriteriaForPoliciesWithEnrollPermission();
            if (cred != null && (loggedOnLoginId = cred.getLoginId()) != null && !ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                criteria = criteria.and(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
            }
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", criteria);
            Iterator it = dataObj.getRows("PolicyConfiguration");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                prop.put(r.get("POLICY_ID"), (String)r.get("POLICY_NAME"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return prop;
    }

    public static boolean isEnrollAllowed(Long policyId) {
        try {
            Criteria criteria = PolicyHandler.getCriteriaForPoliciesWithEnrollPermission();
            criteria = criteria.and(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0));
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", criteria);
            return !dataobject.isEmpty();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    public static void fillPolicyProps(DynaValidatorForm bean) {
        try {
            bean.set("AVAIL_POLICIES", (Object)PolicyHandler.getPoliciesWithEnrollPermission());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONArray getAllPolicies() {
        return PolicyHandler.getAllPolicies((Criteria)null);
    }

    public static JSONArray getAllPolicies(String domainName) {
        JSONArray policyarray = new JSONArray();
        String tableName = "PolicyConfiguration";
        Criteria c = null;
        try {
            DataObject dataobject;
            if (!domainName.equals("")) {
                c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            if (!(dataobject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c)).isEmpty()) {
                Iterator it = dataobject.getRows(tableName);
                while (it.hasNext()) {
                    JSONObject policy = new JSONObject();
                    Row r = (Row)it.next();
                    policy.put("POLICY_ID", r.get("POLICY_ID"));
                    policy.put("POLICY_NAME", (Object)StrUtil.encodeURIComponent((String)r.get("POLICY_NAME")));
                    policy.put("DOMAIN_NAME", r.get("DOMAIN_NAME"));
                    policyarray.put((Object)policy);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyarray;
    }

    public static ArrayList getAllPolicyIdsForDomain(String domainName) {
        ArrayList<Object> policyIds = new ArrayList<Object>();
        String tableName = "PolicyConfiguration";
        Criteria c = null;
        try {
            DataObject dataobject;
            domainName = DomainHandler.getDomainDetails(domainName).getString("DOMAIN_NAME");
            if (!domainName.equals("")) {
                c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            if (!(dataobject = CommonUtil.getPersistence(new boolean[0]).get(tableName, c)).isEmpty()) {
                Iterator it = dataobject.getRows(tableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    policyIds.add(r.get("POLICY_ID"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyIds;
    }

    public static JSONArray getAllPolicies(Criteria criteria) {
        JSONArray policyarray = new JSONArray();
        String tableName = "PolicyConfiguration";
        try {
            DataObject dataobject;
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = cred.getLoginId();
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                Criteria c = new Criteria(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
                Criteria criteria2 = criteria = criteria == null ? c : criteria.and(c);
            }
            if (!(dataobject = CommonUtil.getPersistence(new boolean[0]).get(tableName, criteria)).isEmpty()) {
                Iterator it = dataobject.getRows(tableName);
                while (it.hasNext()) {
                    JSONObject policy = new JSONObject();
                    Row r = (Row)it.next();
                    List columnList = r.getColumns();
                    for (int j = 0; j < columnList.size(); ++j) {
                        policy.put((String)columnList.get(j), r.get((String)columnList.get(j)));
                    }
                    policyarray.put((Object)policy);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyarray;
    }

    public static ArrayList getAllPolicyIds() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            DataObject dataobject = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", (Criteria)null);
            if (!dataobject.isEmpty()) {
                Iterator it = dataobject.getRows("PolicyConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long policyId = (Long)r.get("POLICY_ID");
                    list.add(policyId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static ArrayList getAllDomainPolicyIds() {
        ArrayList<Long> list = new ArrayList<Long>();
        try {
            DataObject dataobject;
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = cred.getLoginId();
            Criteria c = null;
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                c = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false);
            }
            if (!(dataobject = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", c)).isEmpty()) {
                Iterator it = dataobject.getRows("PolicyConfiguration");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long policyId = (Long)r.get("POLICY_ID");
                    list.add(policyId);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public static void updateQuestionDetails(Properties queDetails) {
        try {
            Long queId = (Long)queDetails.get("QUESTION_ID");
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_ID"), (Object)queId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSecretQues", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("SSPSecretQues");
                r.set("QUESTION_TEXT", queDetails.get("QUESTION_TEXT"));
                r.set("MANDATORY", queDetails.get("MANDATORY"));
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteQuestion(Long queId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSecretQues", (String)"QUESTION_ID"), (Object)queId, 0);
            Criteria c = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"QUESTION_ID"), (Object)queId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQAMap", c);
            if (obj.isEmpty()) {
                CommonUtil.getPersistence(new boolean[0]).delete(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long addQuestion(Long policyId, String question) {
        Long qId = 0L;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPSecretQues");
            r.set("POLICY_ID", (Object)policyId);
            r.set("QUESTION_TEXT", (Object)question);
            r.set("MANDATORY", (Object)"No");
            dataObject.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            qId = (Long)r.get("QUESTION_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return qId;
    }

    public static ArrayList getPolicyIdsWithEnrollPermission(String domainName) {
        ArrayList<Long> policyIds = new ArrayList<Long>();
        try {
            Criteria criteria = PolicyHandler.getCriteriaForPoliciesWithEnrollPermission();
            criteria = criteria.and(new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"DOMAIN_NAME"), (Object)domainName, 0, false));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", criteria);
            Iterator it = dataObj.getRows("PolicyConfiguration");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                Long policyId = (Long)r.get("POLICY_ID");
                policyIds.add(policyId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return policyIds;
    }

    public static JSONArray getSUPolicies() {
        Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"SELF_UPDATE"), (Object)"true", 0);
        return PolicyHandler.getAllPolicies(crit);
    }

    public static boolean isAlreayExists(String policyName) {
        String tableName = "PolicyConfiguration";
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_NAME"), (Object)policyName, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", crit);
            return !obj.isEmpty();
        }
        catch (Exception e) {
            e.printStackTrace();
            return true;
        }
    }

    public static Set<String> getSUDomains() {
        HashSet<String> domainSet = new HashSet<String>();
        String tableName = "PolicyConfiguration";
        try {
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            Criteria criteria = new Criteria(Column.getColumn((String)tableName, (String)"SELF_UPDATE"), (Object)"true", 0, false);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAIN_NAME"));
            sq.setDistinct(true);
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"POLICY_ID"));
            sq.setCriteria(criteria);
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dataObject.isEmpty()) {
                Iterator it = dataObject.getRows(tableName);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    domainSet.add((String)r.get("DOMAIN_NAME"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return domainSet;
    }

    public static void UpdatePolicyCriteriaOUGroups(String domainName, String ouGroup) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"DOMAIN_NAME"), (Object)domainName, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_CLASS"), (Object)ouGroup, 0, false));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("PolicyCriteria", crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows("PolicyCriteria");
                while (it.hasNext()) {
                    DataObject Dataobj;
                    Criteria criteria;
                    String DistinguishName;
                    String BaseTable;
                    Row r = (Row)it.next();
                    String Object_GUID = (String)r.get("OBJECT_GUID");
                    String OldGUID = (String)r.get("DISTINGUISHED_NAME");
                    if (ouGroup.equals("OU")) {
                        BaseTable = "ADSMOUDetails";
                        DistinguishName = "DISTINGUISHED_NAME";
                        criteria = new Criteria(Column.getColumn((String)BaseTable, (String)"DOMAIN_NAME"), (Object)domainName, 0);
                        criteria = criteria.and(new Criteria(Column.getColumn((String)BaseTable, (String)"OBJECT_GUID"), (Object)Object_GUID, 0, false));
                        Dataobj = CommonUtil.getPersistence(new boolean[0]).get(BaseTable, criteria);
                    } else {
                        BaseTable = CommonUtil.getDomainTableName(domainName) + "_Groups";
                        DistinguishName = "DN_STRING";
                        criteria = new Criteria(Column.getColumn((String)BaseTable, (String)"OBJECT_GUID"), (Object)Object_GUID, 0);
                        Dataobj = CommonUtil.getPersistence(new boolean[0]).get(BaseTable, criteria);
                    }
                    if (Dataobj.isEmpty()) continue;
                    Iterator it1 = Dataobj.getRows(BaseTable);
                    while (it1.hasNext()) {
                        Row r1 = (Row)it1.next();
                        String NewGuid = (String)r1.get(DistinguishName);
                        if (OldGUID.equals(NewGuid)) continue;
                        UpdateQueryImpl updateQuery = new UpdateQueryImpl("PolicyCriteria");
                        Criteria criteria1 = new Criteria(Column.getColumn((String)"PolicyCriteria", (String)"OBJECT_GUID"), (Object)Object_GUID, 0);
                        updateQuery.setCriteria(criteria1);
                        updateQuery.setUpdateColumn("DISTINGUISHED_NAME", (Object)NewGuid);
                        CommonUtil.getPersistence(new boolean[0]).update((UpdateQuery)updateQuery);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void disableMappedPolicy(Long policyId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dO = CommonUtil.getPersistence(new boolean[0]).get("SSPPSPolicies", crit);
            if (!dO.isEmpty()) {
                Iterator it = dO.getRows("SSPPSPolicies");
                while (it.hasNext()) {
                    Row row = (Row)it.next();
                    Long appConfigId = (Long)row.get("APP_CONFIG_ID");
                    crit = new Criteria(Column.getColumn((String)"SSPPSPolicies", (String)"APP_CONFIG_ID"), (Object)appConfigId, 0);
                    dO = CommonUtil.getPersistence(new boolean[0]).get("SSPPSPolicies", crit);
                    if (dO.size("SSPPSPolicies") != 1) continue;
                    JSONArray appConfigIds = new JSONArray();
                    appConfigIds.put((Object)appConfigId);
                    IAMAppHandler.setHostStatus((JSONArray)appConfigIds, (boolean)false);
                    dO = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                    Row r = new Row("ADSIAMAppConfigParams");
                    r.set("APP_CONFIG_ID", (Object)appConfigId);
                    r.set("PARAM_NAME", (Object)"NO_POLICY_MAPPED");
                    r.set("PARAM_VALUE", (Object)"true");
                    dO.addRow(r);
                    CommonUtil.getPersistence(new boolean[0]).add(dO);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static ArrayList getUserPermissionsfromPId(Long policyId, Long loginId) {
        ArrayList<Object> permit = new ArrayList<Object>();
        try {
            String resetPwd = "false";
            String unlockAcc = "false";
            String selfUpdate = "false";
            String changePwd = "false";
            String isDefault = "true";
            Hashtable h = PolicyHandler.getDefaultDomainPolicy(policyId);
            Row r = (Row)h.get("policyConfig");
            Properties domainDetails = ADAuthHandler.getLoginUserDetails(loginId);
            String domainName = domainDetails.getProperty("LOGIN_DOMAIN_NAME");
            String loginName = domainDetails.getProperty("LOGIN_NAME");
            resetPwd = (String)r.get("RESET_PASSWORD");
            unlockAcc = (String)r.get("UNLOCK_ACCOUNT");
            changePwd = (String)r.get("CHANGE_PASSWORD");
            selfUpdate = (String)r.get("SELF_UPDATE");
            permit.add(policyId);
            permit.add(resetPwd);
            permit.add(unlockAcc);
            permit.add(selfUpdate);
            permit.add(changePwd);
            Boolean MyGroup = GSSelfServiceHandler.isGroupsAvailableForUser(domainName, loginName);
            permit.add(MyGroup);
            JSONArray otherUserAccounts = LinkAccountsHandler.getOtherUserAccounts(policyId);
            Boolean linkAcc = LinkAccountsHandler.getOtherUserAccounts(policyId).length() > 0;
            permit.add(linkAcc);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return permit;
    }

    public static void copyPolicyScheduler(Long newpolId, Long oldPolId) {
        Long[] taskIds = new Long[]{SchedulerHandler.UNLOCK_TASK_ID, SchedulerHandler.RESET_TASK_ID};
        String[] schedulerName = new String[]{"LockedOutScheduler_", "PwdExpiredScheduler_"};
        String[] schedulerDesc = new String[]{"Takes a database incremental backup.", "Report Scheduled Task"};
        try {
            for (int i = 0; i < taskIds.length; ++i) {
                Long copySchedId = 0L;
                Long scheduleId = 0L;
                copySchedId = PolicyHandler.getCopyScheduleId(oldPolId, taskIds[i]);
                if (copySchedId == 0L) continue;
                scheduleId = SchedulerHandler.createSchedule(schedulerName[i] + newpolId, schedulerDesc[i]);
                ArrayList<String> policyTables = new ArrayList<String>(Arrays.asList("Calendar", "Periodic", "Scheduled_Task", "TASK_INPUT"));
                PolicyHandler.copyPolicy(policyTables, "SCHEDULE_ID", copySchedId, scheduleId);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
                SchedulerHandler.addScheduleConfiguration(obj, newpolId, scheduleId, taskIds[i]);
                CommonUtil.getPersistence(new boolean[0]).add(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long getCopyScheduleId(Long copyPolId, Long taskId) {
        Long copySchedId = new Long(0L);
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"POLICY_ID"), (Object)copyPolId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"TASK_ID"), (Object)taskId, 0, false));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", crit);
            if (!obj.isEmpty()) {
                Iterator itr = obj.getRows("SchedulerConfiguration");
                Row r1 = (Row)itr.next();
                copySchedId = (Long)r1.get("SCHEDULE_ID");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return copySchedId;
    }

    public static String clonePolicy(JSONObject polDetails) {
        String status = "";
        try {
            ArrayList<String> policyTables = new ArrayList<String>(Arrays.asList("SSPQASettings", "SSPSecurity", "SSPBlocking", "PolicyNotifications", "SSPPolicies", "SSPPolicyDetails", "SSPCustomScript", "SSPPasswordPolicy", "SSPPolicyGeneral", "SSPTabSettings", "SSPPCPOLICYVSMODULES", "SSPTFAModesVsPolicies", "SSPVerificationsSettings", "SSPPolicyLDAPCriteria", "SSPPPECustomizedRules"));
            Long oldPolId = new Long((Long)polDetails.get("OLD_POLICY_ID"));
            Long newPolId = new Long((Long)polDetails.get("NEW_POLICY_ID"));
            String criteriaCol = "POLICY_ID";
            status = PolicyHandler.copyPolicy(policyTables, criteriaCol, oldPolId, newPolId);
            ArrayList SecretQuesVal = PolicyHandler.getQuestionDetails(oldPolId);
            status = PolicyHandler.setReqMultPolicyRow(SecretQuesVal, "SSPSecretQues", newPolId, criteriaCol);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return status;
    }

    public static String copyPolicy(ArrayList policyTables, String criteriaCol, Long oldPolId, Long newPolId) {
        String status = "";
        String tempCritCol = criteriaCol;
        for (int i = 0; i < policyTables.size(); ++i) {
            if (policyTables.get(i).equals("SSPPolicies") || policyTables.get(i).equals("SSPPolicyDetails")) {
                criteriaCol = "POLICYCONFIG_ID";
            }
            ArrayList polRowVal = PolicyHandler.getReqMultPolicyValues((String)policyTables.get(i), oldPolId, criteriaCol);
            status = PolicyHandler.setReqMultPolicyRow(polRowVal, (String)policyTables.get(i), newPolId, criteriaCol);
            criteriaCol = tempCritCol;
        }
        return status;
    }

    public static ArrayList getReqMultPolicyValues(String tableName, Long policyId, String criteriaCol) {
        ArrayList<Properties> al = new ArrayList<Properties>();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)tableName, (String)criteriaCol), (Object)policyId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(tableName, crit);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(tableName);
                while (it.hasNext()) {
                    Properties prop = new Properties();
                    Row row = (Row)it.next();
                    if (row == null) continue;
                    List columnList = row.getColumns();
                    for (int j = 0; j < columnList.size(); ++j) {
                        String column = (String)columnList.get(j);
                        String value = String.valueOf(row.get(column));
                        if (row.get(column) == null) continue;
                        String columnType = row.getColumnType(column);
                        Object columnValue = MetaDataUtil.convert((String)value, (String)columnType);
                        prop.put(column, columnValue);
                    }
                    al.add(prop);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return al;
    }

    public static String setReqMultPolicyRow(ArrayList al, String tableName, Long policyId, String policyIdCol) {
        String status = "Success";
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < al.size(); ++i) {
                Row r = new Row(tableName);
                Properties props = (Properties)al.get(i);
                Enumeration<Object> e = props.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    if (key.equals("CONDITION_ID") && tableName.equals("SSPPolicyLDAPCriteria") || (key.equals("QUESTION_ID") || key.equals("QUESTION_TYPE")) && tableName.equals("SSPSecretQues") || key.equals("INSTANCE_ID") && tableName.equals("TASK_INPUT")) continue;
                    if (key.equals(policyIdCol)) {
                        r.set(key, (Object)policyId);
                        continue;
                    }
                    r.set(key, props.get(key));
                }
                if (tableName.equals("SSPSecretQues")) {
                    r.set("POLICY_ID", (Object)policyId);
                }
                dataObject.addRow(r);
            }
            CommonUtil.getPersistenceLite().add(dataObject);
        }
        catch (Exception e) {
            status = "Failure";
            e.printStackTrace();
        }
        return status;
    }

    public static JSONObject getSelGuids(ArrayList domainList, ArrayList selGuids, String dN) throws Exception {
        JSONObject result = new JSONObject();
        JSONObject domainPropsObj = new JSONObject();
        String SelGuids = "";
        try {
            for (int i = 0; i < domainList.size(); ++i) {
                Properties domainProp = (Properties)domainList.get(i);
                ArrayList domainOUList = (ArrayList)domainProp.get("ouList");
                String domainName = domainProp.getProperty("DOMAIN_NAME");
                String defaultNamingContext = domainProp.getProperty("DEFAULT_NAMING_CONTEXT");
                String objectGuid = domainProp.get("OBJECT_GUID").toString();
                JSONObject tempJson = new JSONObject();
                tempJson.put("OBJECT_GUID", (Object)objectGuid);
                tempJson.put("DN", (Object)defaultNamingContext);
                domainPropsObj.put(domainName, (Object)tempJson);
                if (!dN.equals(domainName) || selGuids == null) continue;
                for (int j = 0; j < selGuids.size(); ++j) {
                    JSONObject jsonobj = (JSONObject)selGuids.get(j);
                    if (!defaultNamingContext.equalsIgnoreCase(jsonobj.getString("OBJECT_NAME"))) continue;
                    selGuids.remove(j);
                    ArrayList<String> ouDNList = new ArrayList<String>();
                    for (int it = 0; it < domainOUList.size(); ++it) {
                        ouDNList.add(((Properties)domainOUList.get(it)).get("DISTINGUISHED_NAME").toString());
                    }
                    ArrayList domainParentOUs = OUUtil.getParentOUs(ouDNList);
                    for (int it = 0; it < domainOUList.size(); ++it) {
                        Properties ouProp = (Properties)domainOUList.get(it);
                        JSONObject inputSelectionData = new JSONObject();
                        inputSelectionData.put("OBJECT_CLASS", (Object)"ou");
                        inputSelectionData.put("OBJECT_GUID", (Object)ouProp.get("OBJECT_GUID").toString());
                        inputSelectionData.put("OBJECT_NAME", (Object)ouProp.get("OU_NAME").toString());
                        String selOUDN = ouProp.get("DISTINGUISHED_NAME").toString();
                        if (!domainParentOUs.contains(selOUDN)) continue;
                        selGuids.add(inputSelectionData);
                    }
                    break;
                }
                SelGuids = selGuids.toString();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        result.put("domainPropsObj", (Object)domainPropsObj);
        result.put("SelGuids", (Object)SelGuids);
        return result;
    }
}

