/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.admin.EnrollmentHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPUserHandler;
import com.adventnet.sym.adsm.common.server.configuration.IdentityVerifyHandler;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.notifications.PolicyNotifications;
import com.adventnet.sym.adsm.common.server.reports.LicensedUsersHandler;
import com.adventnet.sym.adsm.common.server.util.APCUtil;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.TimeZoneUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.lang.constant.Constable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProfileBuilder {
    public static final int QUESTION = 1;
    public static final int ANSWER = 2;
    public static final int MOBILE_NUMBER = 4;
    public static final int MAIL_ID = 8;
    public static final int DUO_USERS = 16;
    private static Logger logger = Logger.getLogger(ProfileBuilder.class.getName());
    private static String[] cols = new String[]{"SAM_ACCOUNT_NAME", "NAME", "DISPLAY_NAME", "E_MAIL", "NAME", "NAME", "NAME", "DN_STRING", "OBJECT_GUID", "PRIMARY_GROUP_ID"};
    private static String[] keys = new String[]{"sAMAccountName", "name", "displayName", "mail", "givenName", "initials", "sn", "distinguishedName", "objectGuid", "primaryGroupID"};
    private static int freeLicenseCount;

    public static ArrayList buildProfile(ArrayList list, Long polId, Boolean delPre) {
        ArrayList<String> failure = new ArrayList<String>();
        try {
            freeLicenseCount = LicensedUsersHandler.getAvailableLicenseCount();
            String names = APCUtil.getDomainName(polId);
            String dName = new JSONObject(names).getString("DOMAIN_NAME");
            String userTN = CommonUtil.getDomainUserTableName(dName);
            DataObject staleAccDO = CommonUtil.getPersistence(new boolean[0]).get("StaleAccountUsers", (Criteria)null);
            ArrayList quesList = PolicyHandler.getQuestionDetails(polId);
            JSONObject needToEnroll = new JSONObject();
            int size = list.size();
            int poolSize = size > 2000 ? 2000 : size;
            String[] str = new String[poolSize];
            Iterator iterator = list.iterator();
            ArrayList<Hashtable> tempList = new ArrayList<Hashtable>();
            while (iterator.hasNext()) {
                for (int i = 0; i < poolSize; ++i) {
                    Hashtable userProp = (Hashtable)iterator.next();
                    String userName = ((String)userProp.get("NAME")).trim();
                    tempList.add(userProp);
                    str[i] = userName;
                }
                DataObject usersDO = CommonUtil.getPersistence(new boolean[0]).get(userTN, new Criteria(Column.getColumn((String)userTN, (String)"SAM_ACCOUNT_NAME"), (Object)str, 8, false));
                Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)str, 8, false);
                DataObject accountDO = CommonUtil.getPersistence(new boolean[0]).get("AaaLogin", crit.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)dName, 0, false)));
                for (int i = 0; i < tempList.size(); ++i) {
                    Hashtable enrollProps = (Hashtable)tempList.get(i);
                    String name = ((String)enrollProps.get("NAME")).trim();
                    String que = ((String)enrollProps.get("QUESTION")).trim();
                    String ans = ((String)enrollProps.get("ANSWER")).trim();
                    String mailId = ((String)enrollProps.get("MAIL")).trim();
                    String mobileNo = ((String)enrollProps.get("MOBILE")).trim();
                    Boolean needToEnrollDuo = (Boolean)enrollProps.get("ENROLL_DUO");
                    ArrayList<Long> methodsChosen = new ArrayList<Long>();
                    if (ans != null && !"-".equals(ans)) {
                        methodsChosen.add(IdentityVerifyHandler.SQA_VERIFICATION_ID);
                    }
                    if (mailId != null && !"-".equals(mailId)) {
                        methodsChosen.add(IdentityVerifyHandler.CODE_VERIFICATION_ID);
                    }
                    if (mobileNo != null && !"-".equals(mobileNo)) {
                        methodsChosen.add(IdentityVerifyHandler.CODE_VERIFICATION_ID);
                    }
                    if (needToEnrollDuo != null && needToEnrollDuo.booleanValue()) {
                        methodsChosen.add(IdentityVerifyHandler.DUO_VERIFICATION_ID);
                    }
                    Long queId = enrollProps.get("QUESTION_ID") == null ? new Long(0L) : (Long)enrollProps.get("QUESTION_ID");
                    try {
                        Properties props = UserUtil.getUserProps(usersDO, userTN, name, cols, keys);
                        if (ProfileBuilder.isUserPermitted(props, name, polId, dName, staleAccDO).booleanValue()) {
                            Long loginId = null;
                            if (freeLicenseCount > 0) {
                                Hashtable loginInfo = ProfileBuilder.getUserLoginInfo(name, accountDO, props, dName);
                                loginId = (Long)loginInfo.get("loginId");
                                if (!((Boolean)loginInfo.get("isLicensed")).booleanValue()) {
                                    --freeLicenseCount;
                                }
                            } else {
                                loginId = ProfileBuilder.getUserLoginId(name, accountDO, props, dName);
                                if (loginId == null) {
                                    failure.add(name);
                                    logger.log(Level.INFO, "License Count Exceeded! User skipped from enrollment : " + name);
                                    continue;
                                }
                                logger.log(Level.INFO, "User Name already exist, updating it : " + name);
                            }
                            Hashtable<String, Object> hash = new Hashtable<String, Object>();
                            if (queId == 0L && !que.equals("")) {
                                Properties prop = PolicyHandler.addQuestion(polId, que, quesList);
                                queId = (Long)prop.get("QUESTION_ID");
                                quesList = (ArrayList)prop.get("QUESTION_LIST");
                            }
                            hash.put("Answer", ans);
                            hash.put("QId", queId);
                            hash.put("PId", polId);
                            hash.put("LoginId", loginId);
                            hash.put("Delete_Pre", delPre);
                            hash.put("samAccName", name);
                            hash.put("Mobile", mobileNo);
                            hash.put("MailId", mailId);
                            hash.put("enrollDuo", needToEnrollDuo);
                            hash.put("methodsChosen", methodsChosen);
                            needToEnroll.append(Long.toString(loginId), hash);
                            continue;
                        }
                        failure.add(name);
                        logger.log(Level.INFO, "User " + name + " is not permitted to enroll! Reason : Restricted from Product or not in domain or user not under selected policy");
                        continue;
                    }
                    catch (Exception e) {
                        failure.add(name);
                    }
                }
                if (needToEnroll.length() != 0) {
                    ProfileBuilder.enrollUsers(needToEnroll, failure, delPre);
                }
                poolSize = (size -= poolSize) > 2000 ? 2000 : size;
                str = new String[poolSize];
                tempList = new ArrayList();
                needToEnroll = new JSONObject();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return failure;
    }

    private static Boolean isUserPermitted(Properties props, String samAccountName, Long policyId, String dName, DataObject staleAccDO) {
        try {
            Hashtable hash;
            String objGuid;
            String groupTN = CommonUtil.getDomainGroupTableName(dName);
            ArrayList groupsDN = new ArrayList();
            String userDN = props != null && !props.isEmpty() ? ((String)props.get("distinguishedName")).toLowerCase() : null;
            String string = objGuid = props != null && !props.isEmpty() ? (String)props.get("objectGuid") : null;
            if (userDN != null && ((Boolean)(hash = PolicyHandler.checkUserPermission(dName, userDN, groupsDN = GroupUtil.getAllGroupsOfUser(dName, objGuid, (String)props.get("primaryGroupID")))).get("status")).booleanValue() && ((Long)hash.get("policyId")).equals(policyId) && !PolicyHandler.isAccountRestricted(staleAccDO, objGuid).booleanValue()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    private static Long getUserLoginId(String sAN, DataObject accountDO, Properties props, String dName) {
        Long userLoginId = null;
        try {
            Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)sAN, 0, false);
            c = c.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)dName, 0, false));
            Row r = accountDO.getRow("AaaLogin", c);
            userLoginId = r == null ? null : (Long)r.get("LOGIN_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userLoginId;
    }

    private static synchronized Hashtable getUserLoginInfo(String sAN, DataObject accountDO, Properties props, String dName) {
        Long userLoginId = null;
        Hashtable<String, Constable> userLoginInfo = new Hashtable<String, Constable>();
        Boolean isLicensed = true;
        try {
            userLoginId = ProfileBuilder.getUserLoginId(sAN, accountDO, props, dName);
            if (userLoginId == null) {
                userLoginId = ADMPUserHandler.addDomainUser(props, dName);
                isLicensed = false;
                Row r = new Row("AaaLogin");
                r.set("LOGIN_ID", (Object)userLoginId);
                r.set("USER_ID", (Object)userLoginId);
                r.set("NAME", (Object)sAN);
                r.set("DOMAINNAME", (Object)dName);
                accountDO.addRow(r);
            }
            userLoginInfo.put("loginId", userLoginId);
            userLoginInfo.put("isLicensed", isLicensed);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return userLoginInfo;
    }

    private static void enrollUsers(JSONObject enrollList, ArrayList failure, Boolean delPre) {
        try {
            DataObject objR = CommonUtil.getPersistence(new boolean[0]).get("SSPUserPropertyMap", (Criteria)null);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("ADMPUsersPersonal", (Criteria)null);
            DataObject objS = CommonUtil.getPersistence(new boolean[0]).get("SSPBuildInQAMap", (Criteria)null);
            DataObject objC = CommonUtil.getPersistence(new boolean[0]).get("SSPCustomQAMap", (Criteria)null);
            Long polId = null;
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            HashMap dateFormatMap = TimeZoneUtil.getCustomDateFormat(1L);
            Iterator keys = enrollList.keys();
            ArrayList<Long> loginIds = new ArrayList<Long>();
            ArrayList<String> enrolledUsers = new ArrayList<String>();
            ArrayList methodsChosen = new ArrayList();
            while (keys.hasNext()) {
                String key = (String)keys.next();
                JSONArray list = (JSONArray)enrollList.get(key);
                for (int j = 0; j < list.length(); ++j) {
                    Hashtable hash = (Hashtable)list.get(j);
                    Long loginId = (Long)hash.get("LoginId");
                    methodsChosen = (ArrayList)hash.get("methodsChosen");
                    polId = (Long)hash.get("PId");
                    String sAN = (String)hash.get("samAccName");
                    if (delPre.booleanValue() && hash.containsKey("Answer") && !"-".equals((String)hash.get("Answer")) && !loginIds.contains(loginId)) {
                        objS.deleteRows("SSPBuildInQAMap", new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"), (Object)Long.valueOf(key), 0));
                        objC.deleteRows("SSPCustomQAMap", new Criteria(Column.getColumn((String)"SSPCustomQAMap", (String)"USER_LOGIN_ID"), (Object)Long.valueOf(key), 0));
                    }
                    if (!ProfileBuilder.updateEnrollmentDO(objS, obj, hash).booleanValue()) {
                        failure.add(sAN);
                        continue;
                    }
                    loginIds.add(loginId);
                    if (enrolledUsers.contains(sAN.toLowerCase())) continue;
                    enrolledUsers.add(sAN.toLowerCase());
                }
            }
            CommonUtil.getPersistence(new boolean[0]).update(objS);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
            CommonUtil.getPersistence(new boolean[0]).update(objC);
            for (int i = 0; i < loginIds.size(); ++i) {
                ProfileBuilder.updateCSVEnrollment(objR, (Long)loginIds.get(i), methodsChosen);
            }
            CommonUtil.getPersistence(new boolean[0]).update(objR);
            String names = APCUtil.getDomainName(polId);
            String dName = new JSONObject(names).getString("DOMAIN_NAME");
            Hashtable<String, String> keyPairValue = new Hashtable<String, String>();
            keyPairValue.put("dateTime", TimeZoneUtil.getPresentDateTime(System.currentTimeMillis(), dateFormatMap));
            keyPairValue.put("ipAddress", " ");
            keyPairValue.put("hostName", " ");
            for (int i = 0; i < enrolledUsers.size(); ++i) {
                String loginName = (String)enrolledUsers.get(i);
                ArrayList<Long> nIds = new ArrayList<Long>();
                nIds.add(new Long(13L));
                nIds.add(new Long(14L));
                nIds.add(new Long(19L));
                PolicyNotifications.sendNotification(dName, loginName, polId, nIds, keyPairValue);
            }
            JSONObject jsonLog = AuditAPI.getInstance().setBulkAuditProps(dName, enrolledUsers.toString(), "adssp.congig.enrollment.bulk_enrollment", System.currentTimeMillis());
            jsonLog.put("FAILURE_USERS_LIST", (Object)failure.toString());
            LogForwarderAPI.getInstance().sendMessage(jsonLog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Boolean updateEnrollmentDO(DataObject objS, DataObject obj, Hashtable hash) {
        try {
            Criteria userPerCriteria;
            Row row;
            Long polId = (Long)hash.get("PId");
            Long loginId = (Long)hash.get("LoginId");
            Long qId = (Long)hash.get("QId");
            String ans = (String)hash.get("Answer");
            Boolean delPre = (Boolean)hash.get("Delete_Pre");
            String mobile = (String)hash.get("Mobile");
            String mailId = (String)hash.get("MailId");
            Boolean enrollDuo = (Boolean)hash.get("enrollDuo");
            Criteria crit = new Criteria(Column.getColumn((String)"SSPBuildInQAMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            crit = crit.and(Column.getColumn((String)"SSPBuildInQAMap", (String)"QUESTION_ID"), (Object)qId, 0);
            Row r = objS.getRow("SSPBuildInQAMap", crit);
            if (ans != null && !ans.equals("-")) {
                if (!delPre.booleanValue() && (delPre.booleanValue() || r != null)) return false;
                r = new Row("SSPBuildInQAMap");
                r.set("USER_LOGIN_ID", (Object)loginId);
                r.set("QUESTION_ID", (Object)qId);
                PolicyHandler.addAnswer(polId, ans, r);
                objS.addRow(r);
            }
            String userMail = (row = obj.getRow("ADMPUsersPersonal", userPerCriteria = new Criteria(Column.getColumn((String)"ADMPUsersPersonal", (String)"LOGIN_ID"), (Object)loginId, 0))).get("EMAIL_ADDRESSES") != null ? (String)row.get("EMAIL_ADDRESSES") : "";
            String userMobile = row.get("MOBILE_NUMBERS") != null ? (String)row.get("MOBILE_NUMBERS") : "";
            String mailRegex = "^[a-zA-Z0-9]([\\w\\-\\.\\+\\']*)@([\\w\\-\\.]*)(\\.[a-zA-Z]{2,8}(\\.[a-zA-Z]{2}){0,2})$";
            String mobRegex = ADSMPersUtil.getSyMParameter("ALLOWED_MOBILE_CHARS");
            if (mobRegex == null) {
                mobRegex = "[0-9+\\(\\)\\- ]+";
            }
            if (delPre.booleanValue()) {
                if (mailId != null && !mailId.equals("-")) {
                    if (!mailId.matches(mailRegex)) return false;
                    row.set("EMAIL_ADDRESSES", (Object)(mailId + ","));
                }
                if (mobile != null && !mobile.equals("-")) {
                    if (!mobile.matches(mobRegex)) return false;
                    row.set("MOBILE_NUMBERS", (Object)(mobile + ","));
                }
            } else {
                if (mailId != null && !mailId.equals("-") && !ProfileBuilder.isDuplicateExists(userMail, mailId)) {
                    if (!mailId.matches(mailRegex)) return false;
                    userMail = userMail + mailId + ",";
                    row.set("EMAIL_ADDRESSES", (Object)userMail);
                }
                if (mobile != null && !mobile.equals("-") && !ProfileBuilder.isDuplicateExists(userMobile, mobile)) {
                    if (!mobile.matches(mobRegex)) return false;
                    userMobile = userMobile + mobile + ",";
                    row.set("MOBILE_NUMBERS", (Object)userMobile);
                }
            }
            obj.updateRow(row);
            if (!enrollDuo.booleanValue()) return true;
            EnrollmentHandler.setEnrolledforDuo(loginId);
            return true;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public static void updateEnrollStatusDO(DataObject obj, Long loginId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0);
            Row row = obj.getRow("SSPUserPropertyMap", c);
            Long enrollmentType = EnrollmentHandler.getEnrollmentType(loginId);
            if (row == null && enrollmentType != 0L) {
                row = new Row("SSPUserPropertyMap");
                row.set("ENROLLED_TIME", (Object)System.currentTimeMillis());
                row.set("USER_LOGIN_ID", (Object)loginId);
                row.set("REGISTRATION_STATUS", (Object)new Integer(1));
                row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                obj.addRow(row);
            } else if (enrollmentType != 0L) {
                enrollmentType = enrollmentType | (Long)row.get("ENROLLMENT_TYPE");
                row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
                obj.updateRow(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static boolean isDuplicateExists(String parentStr, String subStr) {
        String[] strArray = parentStr.split(",");
        List<String> list = Arrays.asList(strArray);
        return list.contains(subStr);
    }

    public static void updateCSVEnrollment(DataObject obj, Long loginId, ArrayList methodsChosen) {
        try {
            Criteria c;
            Row row;
            Long enrollmentType = 0L;
            if (EnrollmentHandler.isUserQExist(loginId).booleanValue() && methodsChosen.contains(IdentityVerifyHandler.SQA_VERIFICATION_ID)) {
                enrollmentType = enrollmentType + 2L;
            }
            if (EnrollmentHandler.isVCSecMailRegistered(loginId) && methodsChosen.contains(IdentityVerifyHandler.CODE_VERIFICATION_ID)) {
                enrollmentType = enrollmentType + 4L;
            }
            if (EnrollmentHandler.isVCSecMobRegistered(loginId) && methodsChosen.contains(IdentityVerifyHandler.CODE_VERIFICATION_ID)) {
                enrollmentType = enrollmentType + 8L;
            }
            if (EnrollmentHandler.isDuoEnrollmentRegistered(loginId) && methodsChosen.contains(IdentityVerifyHandler.DUO_VERIFICATION_ID)) {
                enrollmentType = enrollmentType + 32L;
            }
            if ((row = obj.getRow("SSPUserPropertyMap", c = new Criteria(Column.getColumn((String)"SSPUserPropertyMap", (String)"USER_LOGIN_ID"), (Object)loginId, 0))) == null && enrollmentType != 0L) {
                row = new Row("SSPUserPropertyMap");
                row.set("ENROLLED_TIME", (Object)System.currentTimeMillis());
                row.set("USER_LOGIN_ID", (Object)loginId);
                row.set("REGISTRATION_STATUS", (Object)new Integer(1));
                row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                obj.addRow(row);
            } else if (enrollmentType != 0L) {
                enrollmentType = enrollmentType | (Long)row.get("ENROLLMENT_TYPE");
                row.set("ENROLLMENT_TYPE", (Object)enrollmentType);
                row.set("MODIFIED_TIME", (Object)System.currentTimeMillis());
                obj.updateRow(row);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }
}

