/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.sym.adsm.common.server.admin.ProfileBuilder;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProfileThreadHandler {
    private static Logger logger = Logger.getLogger(ProfileThreadHandler.class.getName());
    private ArrayList failedList = null;
    private static ProfileThreadHandler threadHandler = null;
    private static boolean isStarted = false;
    private static EnrollAction doEnroll = null;
    private String statusMessage = "";

    public ProfileThreadHandler() {
        isStarted = doEnroll != null && doEnroll.isAlive();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ProfileThreadHandler getInstance() {
        if (threadHandler == null) {
            Class<ProfileThreadHandler> clazz = ProfileThreadHandler.class;
            synchronized (ProfileThreadHandler.class) {
                if (threadHandler == null) {
                    threadHandler = new ProfileThreadHandler();
                }
                // ** MonitorExit[var0] (shouldn't be in output)
            }
        } else if (doEnroll != null && doEnroll.isAlive()) {
            isStarted = true;
        }
        return threadHandler;
    }

    public void start(ArrayList list, Long policyId, boolean delPre, int mismatch) {
        isStarted = true;
        doEnroll = new EnrollAction(list, policyId, delPre, mismatch);
        doEnroll.start();
    }

    public ArrayList getFailedList() {
        return this.failedList;
    }

    public boolean isRunning() {
        return isStarted;
    }

    public String getStatusMessage() {
        return this.statusMessage;
    }

    public String getStatusMessage(ArrayList list, ArrayList failure, int formatFailed) {
        String statusMsg = "";
        try {
            statusMsg = list.size() == 0 ? "adssp.admin.policies.import_ans.file_no_content" : (list.size() == failure.size() ? "adssp.admin.policies.import_ans.auto_enroll_failed_all_users" : (failure.size() != 0 ? "adssp.admin.policies.import_ans.auto_enroll_failed_all_users_some_users" : (formatFailed == list.size() ? "adssp.admin.policies.import_ans.improper_file" : "adssp.admin.policies.import_ans.auto_enroll_success")));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return statusMsg;
    }

    public void controlUI() {
        while (isStarted) {
            try {
                Thread.sleep(700L);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public class EnrollAction
    extends Thread {
        Long policyId = 0L;
        ArrayList enrollList = new ArrayList();
        boolean delPre = false;
        int mismatch = 0;

        public EnrollAction(ArrayList enrollList, Long policyId, boolean delPre, int mismatch) {
            this.enrollList = enrollList;
            this.policyId = policyId;
            this.delPre = delPre;
            this.mismatch = mismatch;
        }

        @Override
        public void run() {
            try {
                logger.log(Level.INFO, "Auto Enrollment Thread Started @ " + CommonUtil.getSystemTimeFormat(System.currentTimeMillis()));
                ProfileThreadHandler.this.failedList = new ArrayList();
                ProfileThreadHandler.this.failedList = ProfileBuilder.buildProfile(this.enrollList, this.policyId, this.delPre);
                isStarted = false;
                ProfileThreadHandler.this.statusMessage = ProfileThreadHandler.this.getStatusMessage(this.enrollList, ProfileThreadHandler.this.failedList, this.mismatch);
                logger.log(Level.INFO, "Auto Enrollment Thread Completed @ " + CommonUtil.getSystemTimeFormat(System.currentTimeMillis()));
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }
}

