/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.authentication.Credential;
import com.adventnet.authentication.util.AuthUtil;
import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.ProfileBuilder;
import com.adventnet.sym.adsm.common.server.admin.authentication.ADMPRoleHandler;
import com.adventnet.sym.adsm.common.server.mysql.DBManager;
import com.adventnet.sym.adsm.common.server.mysql.DBManagerObject;
import com.adventnet.sym.adsm.common.server.reports.AuditReportHandler;
import com.adventnet.sym.adsm.common.server.scheduler.ScheduleQAFetcher;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.QueryUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;

public class ProviderHandler {
    public static Long addSQAVerification(HttpServletRequest request) {
        Long verId = 0L;
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPSQAVerification");
            ProviderHandler.setSQAVRow(request, r);
            obj.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
            Row nR = obj.getRow("SSPSQAVerification");
            verId = (Long)nR.get("VERIFICATION_ID");
        }
        catch (Exception e) {
            request.setAttribute("statusMessage", (Object)e.getMessage());
            e.printStackTrace();
        }
        return verId;
    }

    public static void updateSQAVerification(Long verId, HttpServletRequest request) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSQAVerification", (String)"VERIFICATION_ID"), (Object)verId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSQAVerification", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("SSPSQAVerification");
                ProviderHandler.setSQAVRow(request, r);
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSQAVRow(HttpServletRequest request, Row r) {
        String verName = request.getParameter("VERIFICATION_NAME");
        Long dsId = new Long(request.getParameter("DSID"));
        Long policyId = new Long(request.getParameter("POLICY_ID"));
        String query = request.getParameter("QUERY");
        Long importColumn = new Long(request.getParameter("IMPORT_COLUMNS"));
        Boolean overwrite = request.getParameter("OVERWRITE") != null;
        r.set("VERIFICATION_NAME", (Object)StrUtil.decodeURIComponent(verName));
        r.set("DSID", (Object)dsId);
        r.set("POLICY_ID", (Object)policyId);
        r.set("QUERY", (Object)query);
        r.set("COLUMN_FLAGS", (Object)importColumn);
        r.set("OVERWRITE", (Object)overwrite);
    }

    public static ArrayList getSQAVerfications(Long verId) {
        ArrayList verList = new ArrayList();
        try {
            DataObject obj;
            Criteria crit;
            Credential cred = AuthUtil.getUserCredential();
            Long loggedOnLoginId = 1L;
            if (cred != null) {
                loggedOnLoginId = cred.getLoginId();
            }
            ArrayList<String> tablesList = new ArrayList<String>();
            tablesList.add("SSPSQAVerification");
            tablesList.add("DataSource");
            tablesList.add("PolicyConfiguration");
            Criteria criteria = crit = verId == null ? null : new Criteria(Column.getColumn((String)"SSPSQAVerification", (String)"VERIFICATION_ID"), (Object)verId, 0);
            if (!ADMPRoleHandler.isADSSPUser(loggedOnLoginId)) {
                String domainName = DomainHandler.getDomainName(loggedOnLoginId);
                ArrayList policyIds = PolicyHandler.getPolicyIdsWithEnrollPermission(domainName);
                Criteria c = new Criteria(new Column("SSPSQAVerification", "POLICY_ID"), (Object)policyIds.toArray(new Long[policyIds.size()]), 8);
                crit = crit == null ? c : crit.and(c);
            }
            if (!(obj = CommonUtil.getPersistence(new boolean[0]).get(tablesList, crit)).isEmpty()) {
                Iterator it = obj.getRows("SSPSQAVerification");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    Long dsId = (Long)r.get("DSID");
                    Long pId = (Long)r.get("POLICY_ID");
                    Hashtable<String, Object> props = new Hashtable<String, Object>();
                    verId = (Long)r.get("VERIFICATION_ID");
                    props.put("VERIFICATION_ID", verId);
                    props.put("VERIFICATION_NAME", (String)r.get("VERIFICATION_NAME"));
                    props.put("DSID", dsId);
                    props.put("POLICY_ID", pId);
                    props.put("QUERY", (String)r.get("QUERY"));
                    props.put("OVERWRITE", (Boolean)r.get("OVERWRITE"));
                    Long columnFlags = (Long)r.get("COLUMN_FLAGS");
                    props.put("COLUMN_FLAGS", columnFlags != null && !columnFlags.equals(0L) ? columnFlags : 3L);
                    r = obj.getRow("DataSource", new Criteria(Column.getColumn((String)"DataSource", (String)"DSID"), (Object)dsId, 0));
                    props.put("DSNAME", r != null ? r.get("DSNAME") : "-");
                    r = obj.getRow("PolicyConfiguration", new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)pId, 0));
                    props.put("POLICY_NAME", r != null ? r.get("POLICY_NAME") : "-");
                    props.put("ADMIN_STATUS", ScheduleQAFetcher.getAdminStatus(verId));
                    verList.add(props);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return verList;
    }

    public static void deleteSQAVerification(Long verId) {
        try {
            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"SSPSQAVerification", (String)"VERIFICATION_ID"), (Object)verId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable fetchData(Long verId, HttpServletRequest request) throws Exception {
        Connection connection = null;
        Statement statement = null;
        ResultSet resultSet = null;
        Hashtable result = new Hashtable();
        try {
            String dsName = "";
            String query = "";
            int importedColumns = 0;
            if (request != null && request.getParameter("FETCH") != null) {
                dsName = DBManager.getDSProp(request.getParameter("DSID").toString(), "DSID", "DSNAME");
                query = request.getParameter("QUERY");
                importedColumns = Integer.parseInt(request.getParameter("IMPORT_COLUMNS"));
            } else {
                Hashtable props = (Hashtable)ProviderHandler.getSQAVerfications(verId).get(0);
                dsName = DBManager.getDSProp(props.get("DSID").toString(), "DSID", "DSNAME");
                query = (String)props.get("QUERY");
                importedColumns = ((Long)props.get("COLUMN_FLAGS")).intValue();
            }
            DBManagerObject dbManObj = DBManager.getConnectionObject(dsName);
            connection = dbManObj.getConnection();
            statement = connection.createStatement();
            resultSet = QueryUtil.executeQuery("Getting value from tables", statement, query);
            int index = 0;
            while (resultSet.next()) {
                int columnIndex = 1;
                Hashtable<String, Object> hash = new Hashtable<String, Object>();
                hash.put("NAME", resultSet.getString(columnIndex++));
                hash.put("QUESTION", AuditReportHandler.isFilterEnabled(1L, importedColumns) ? resultSet.getString(columnIndex++) : "-");
                hash.put("ANSWER", AuditReportHandler.isFilterEnabled(2L, importedColumns) ? resultSet.getString(columnIndex++) : "-");
                hash.put("MOBILE", AuditReportHandler.isFilterEnabled(4L, importedColumns) ? resultSet.getString(columnIndex++) : "-");
                hash.put("MAIL", AuditReportHandler.isFilterEnabled(8L, importedColumns) ? resultSet.getString(columnIndex++) : "-");
                hash.put("ENROLL_DUO", AuditReportHandler.isFilterEnabled(16L, importedColumns));
                result.put(index++, hash);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("adssp.configuration.admin_tools.ext_dat_source.sqafetcher_invalid_query");
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (Exception rE) {
                rE.printStackTrace();
            }
            try {
                if (statement != null) {
                    statement.close();
                }
            }
            catch (Exception sE) {
                sE.printStackTrace();
            }
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (Exception rE) {
                rE.printStackTrace();
            }
        }
        return result;
    }

    public static Hashtable populate(ArrayList updateList, Long policyId, Boolean overwrite) throws Exception {
        Hashtable<String, Serializable> result = new Hashtable<String, Serializable>();
        try {
            ArrayList failure = ProfileBuilder.buildProfile(updateList, policyId, overwrite);
            result.put("TOTALSIZE", Integer.valueOf(updateList.size()));
            result.put("FAILED", failure);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception(e.getMessage());
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getDataSources(Long dsId) {
        ArrayList list = new ArrayList();
        Connection connection = null;
        DataSet dataSet = null;
        try {
            SelectQueryImpl sq = new SelectQueryImpl(new Table("DataSource"));
            Criteria c = new Criteria(Column.getColumn((String)"DataSource", (String)"DSNAME"), (Object)"default", 1);
            if (dsId != null) {
                c = c.and(new Criteria(Column.getColumn((String)"DataSource", (String)"DSID"), (Object)dsId, 0));
            }
            sq.setCriteria(c);
            sq.addJoin(new Join(new Table("DataSource"), new Table("DBAdapter"), new String[]{"DSID"}, new String[]{"DSID"}, 1));
            sq.addJoin(new Join(new Table("DataSource"), new Table("DBConnector"), new String[]{"DSID"}, new String[]{"DSID"}, 1));
            sq.addSelectColumn(Column.getColumn((String)"DataSource", (String)"DSID"));
            sq.addSelectColumn(Column.getColumn((String)"DataSource", (String)"DSNAME"));
            sq.addSelectColumn(Column.getColumn((String)"DBConnector", (String)"DBSERVER"));
            sq.addSelectColumn(Column.getColumn((String)"DBConnector", (String)"HOSTNAME"));
            sq.addSelectColumn(Column.getColumn((String)"DBConnector", (String)"PORT"));
            sq.addSelectColumn(Column.getColumn((String)"DBConnector", (String)"DBNAME"));
            sq.addSelectColumn(Column.getColumn((String)"DBConnector", (String)"DOMAINNAME"));
            sq.addSelectColumn(Column.getColumn((String)"DBAdapter", (String)"USERNAME"));
            sq.addSelectColumn(Column.getColumn((String)"DBAdapter", (String)"URL"));
            RelationalAPI relAPI = RelationalAPI.getInstance();
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                Hashtable<String, Object> dsProps = new Hashtable<String, Object>();
                dsProps.put("DSID", (Long)dataSet.getValue("DSID"));
                dsProps.put("DSNAME", (String)dataSet.getValue("DSNAME"));
                dsProps.put("DBSERVER", (String)dataSet.getValue("DBSERVER"));
                dsProps.put("HOSTNAME", (String)dataSet.getValue("HOSTNAME"));
                dsProps.put("PORT", (String)dataSet.getValue("PORT"));
                dsProps.put("DBNAME", (String)dataSet.getValue("DBNAME"));
                dsProps.put("USERNAME", (String)dataSet.getValue("USERNAME"));
                String domainName = (String)dataSet.getValue("DOMAINNAME");
                String authType = "SQL";
                String url = (String)dataSet.getValue("URL");
                if (domainName != null && !domainName.equals("")) {
                    dsProps.put("DOMAINNAME", domainName);
                    authType = "WIN";
                }
                if (((String)dataSet.getValue("DBSERVER")).equalsIgnoreCase("ORACLE")) {
                    authType = url.contains("jdbc:oracle:thin:@//") ? "SERVICE" : "SID";
                }
                dsProps.put("AUTHEN_TYPE", authType);
                list.add(dsProps);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                if (connection != null) {
                    connection.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
            try {
                if (dataSet != null) {
                    dataSet.close();
                }
            }
            catch (SQLException se) {
                se.printStackTrace();
            }
        }
        return list;
    }

    public static Hashtable getImportColumn(int importValue) {
        Hashtable<String, Boolean> hash = new Hashtable<String, Boolean>();
        hash.put("question", AuditReportHandler.isFilterEnabled(1L, importValue));
        hash.put("answer", AuditReportHandler.isFilterEnabled(2L, importValue));
        hash.put("mobile", AuditReportHandler.isFilterEnabled(4L, importValue));
        hash.put("mail", AuditReportHandler.isFilterEnabled(8L, importValue));
        return hash;
    }
}

