/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.db.api.RelationalAPI;
import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.DataSet;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.Query;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.admin.AuditAPI;
import com.adventnet.sym.adsm.common.server.i18n.AdventNetResourceBundle;
import com.adventnet.sym.adsm.common.server.i18n.ResourceBundleMgr;
import com.adventnet.sym.adsm.common.server.mailalias.GSConfigHandler;
import com.adventnet.sym.adsm.common.server.reports.UserAccountControl;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.DBUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.manageengine.ads.fw.logforward.LogForwarderAPI;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.json.JSONObject;

public class RestrictUsersHandler {
    private static Logger logger = Logger.getLogger(RestrictUsersHandler.class.getName());
    public static String[] colList = new String[]{"adssp.reports.common.text.display_name_txt", "adssp.reports.common.text.sam_name", "adssp.xml.actiondetails.e_mail", "adssp.xml.attributedetails.ouName", "adssp.xml.attributedetails.reason"};
    public static String[] attrList = new String[]{"DISPLAY_NAME", "SAM_ACCOUNT_NAME", "EMAIL_ADDRESS", "OU_NAME", "REASON_FOR_RESTRICTION", "OBJECT_GUID", "STALE_ACCOUNT_ID"};
    public static String[] quickSearchList = new String[]{"DISPLAY_NAME", "SAM_ACCOUNT_NAME", "EMAIL_ADDRESS", "OU_NAME", "REASON_FOR_RESTRICTION"};
    public static HashMap<String, String> accountType = new HashMap<String, String>(){
        {
            this.put("301", "adssp.admin.general.restrict_users.account_type.inactive_user");
            this.put("302", "adssp.admin.general.restrict_users.account_type.disabled_user");
            this.put("303", "adssp.admin.general.restrict_users.account_type.account_expired");
            this.put("304", "adssp.admin.general.restrict_users.account_type.deleted_user");
            this.put("307", "adssp.admin.general.restrict_users.account_type.service_account");
            this.put("308", "adssp.admin.general.restrict_users.account_type.all_user");
            this.put("309", "adssp.admin.general.restrict_users.account_type.smartcard_user");
        }
    };
    public static final long ACCOUNT_ENABLED = 1L;
    public static final long SMARTCARD_DISABLED = 2L;
    public static final long EXPIRATION_CHANGES = 4L;
    public static final long LOGGED_IN_CHANGES = 8L;
    public static final Integer RESTRICTED_USER_REP_ID = new Integer(306);
    public static final Integer SERVICE_ACCOUNTS_REP_ID = new Integer(307);

    public static ArrayList deleteFromAaaLogin(ArrayList selectedUsers, String domainName) {
        try {
            String[] users = selectedUsers.toArray(new String[selectedUsers.size()]);
            String userTN = "ADSMUserGeneralDetails";
            Criteria criteria = new Criteria(Column.getColumn((String)userTN, (String)"OBJECT_GUID"), (Object)users, 8, false);
            Join join = new Join(new Table("AaaLogin"), new Table(userTN), new String[]{"NAME"}, new String[]{"SAM_ACCOUNT_NAME"}, 2);
            SelectQueryImpl selectQuery = new SelectQueryImpl(new Table("AaaLogin"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"));
            selectQuery.addSelectColumn(Column.getColumn((String)"AaaLogin", (String)"NAME"));
            selectQuery.addSelectColumn(Column.getColumn((String)userTN, (String)"OBJECT_GUID"));
            selectQuery.addSelectColumn(Column.getColumn((String)userTN, (String)"SAM_ACCOUNT_NAME"));
            selectQuery.setCriteria(criteria);
            selectQuery.addJoin(join);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selectQuery);
            if (!obj.isEmpty()) {
                Iterator it = obj.getRows(userTN);
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    String sAN = (String)r.get("SAM_ACCOUNT_NAME");
                    Criteria c = new Criteria(Column.getColumn((String)"AaaLogin", (String)"NAME"), (Object)sAN, 0, false);
                    c = c.and(new Criteria(Column.getColumn((String)"AaaLogin", (String)"DOMAINNAME"), (Object)domainName, 0, false));
                    CommonUtil.getPersistence(new boolean[0]).delete(c);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return selectedUsers;
    }

    public static void deleteSelectedUsers(ArrayList list, String domainName, String tableName, String columnName, String critColumnName) {
        try {
            String[] users = list.toArray(new String[list.size()]);
            Criteria aAACriteria = new Criteria(Column.getColumn((String)tableName, (String)columnName), (Object)users, 8, false);
            if (!critColumnName.equals("")) {
                aAACriteria = aAACriteria.and(new Criteria(Column.getColumn((String)tableName, (String)critColumnName), (Object)domainName, 0, false));
            }
            CommonUtil.getPersistence(new boolean[0]).delete(aAACriteria);
            RestrictUsersHandler.auditRestrictedUser(list, domainName, "adssp.layout.admin.license_man_unrestrict_users", -1);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void unRestrict(String domainName) {
        try {
            ArrayList<String> selectedUsersList = new ArrayList<String>();
            JSONObject settings = RestrictUsersHandler.getUnrestrictDetails(domainName);
            String domainUserTable = CommonUtil.getDomainUserTableName(domainName);
            SelectQueryImpl selQuery = new SelectQueryImpl(Table.getTable((String)"StaleAccountUsers"));
            Join join = new Join("StaleAccountUsers", domainUserTable, new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            selQuery.addJoin(join);
            selQuery.addSelectColumn(Column.getColumn((String)domainUserTable, (String)"*"));
            selQuery.addSelectColumn(Column.getColumn((String)"StaleAccountUsers", (String)"*"));
            DataObject dObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)selQuery);
            if (!dObj.isEmpty()) {
                Iterator iter = dObj.getRows(domainUserTable);
                while (iter.hasNext()) {
                    Long diff;
                    Row row = (Row)iter.next();
                    int userAccountControl = (Integer)row.get("USER_ACCOUNT_CONTROL");
                    Long lastLogonTime = (Long)row.get("LAST_LOGON_TIMESTAMP");
                    String guid = (String)row.get("OBJECT_GUID");
                    Long accountExpiry = (Long)row.get("ACCOUNT_EXPIRY_DATE");
                    Row staleAccountRow = dObj.getRow("StaleAccountUsers", new Criteria(Column.getColumn((String)"StaleAccountUsers", (String)"OBJECT_GUID"), (Object)guid, 0));
                    Long currentTimeInMillis = System.currentTimeMillis();
                    if (staleAccountRow.get("REASON_FOR_RESTRICTION") == null) continue;
                    int reason = (Integer)staleAccountRow.get("REASON_FOR_RESTRICTION");
                    if (reason == 302 && settings.getString("EnabledUsers").equals("true")) {
                        if (!"adssp.admin.common.text.enabled".equalsIgnoreCase(UserAccountControl.getAccountStatus(userAccountControl))) continue;
                        selectedUsersList.add(guid);
                        continue;
                    }
                    if (reason == 309 && settings.getString("SmartcardUsers").equals("true")) {
                        if (!"adssp.admin.common.text.disabled".equalsIgnoreCase(UserAccountControl.getSmartcardStatus(userAccountControl))) continue;
                        selectedUsersList.add(guid);
                        continue;
                    }
                    if (reason == 303 && settings.getString("AccountExpiry").equals("true")) {
                        boolean isExpired = false;
                        if (accountExpiry != 0L) {
                            diff = (accountExpiry = CommonUtil.getDateFromFileTime(accountExpiry)) - currentTimeInMillis;
                            isExpired = diff < 0L;
                        }
                        if (isExpired) continue;
                        selectedUsersList.add(guid);
                        continue;
                    }
                    if (reason != 301 || settings.getString("LoggedIn").equals("false") || lastLogonTime == 0L) continue;
                    int unrestrictNoOfDays = Integer.parseInt(settings.getString("MAX_DAYS"));
                    lastLogonTime = CommonUtil.getDateFromFileTime(lastLogonTime);
                    diff = currentTimeInMillis - lastLogonTime;
                    Long noOfDays = diff / 86400000L;
                    if ((long)unrestrictNoOfDays < noOfDays) continue;
                    selectedUsersList.add(guid);
                }
            }
            RestrictUsersHandler.deleteSelectedUsers(selectedUsersList, domainName, "StaleAccountUsers", "OBJECT_GUID", "");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static JSONObject getUnrestrictDetails(String domName) {
        JSONObject settings = new JSONObject();
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPStaleAccountUnrestriction", (String)"DOMAIN_NAME"), (Object)domName, 0);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("SSPStaleAccountUnrestriction", crit);
            Long flags = 0L;
            Long max_days = 7L;
            if (!dob.isEmpty()) {
                Row r = dob.getRow("SSPStaleAccountUnrestriction");
                flags = (Long)r.get("UNRESTRICTION_FLAGS");
                max_days = (Long)r.get("USER_ACTIVE_LOGON_DAYS") != null ? (Long)r.get("USER_ACTIVE_LOGON_DAYS") : 7L;
            }
            settings.put("EnabledUsers", (Object)((flags & 1L) != 0L ? "true" : "false"));
            settings.put("SmartcardUsers", (Object)((flags & 2L) != 0L ? "true" : "false"));
            settings.put("AccountExpiry", (Object)((flags & 4L) != 0L ? "true" : "false"));
            settings.put("LoggedIn", (Object)((flags & 8L) != 0L ? "true" : "false"));
            settings.put("MAX_DAYS", (Object)max_days.toString());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return settings;
    }

    public static boolean isUnrestrictSchedulerEnabled(String domName) {
        Long flags = 0L;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPStaleAccountUnrestriction", (String)"DOMAIN_NAME"), (Object)domName, 0);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get("SSPStaleAccountUnrestriction", crit);
            if (!dob.isEmpty()) {
                Row r = dob.getRow("SSPStaleAccountUnrestriction");
                flags = (Long)r.get("UNRESTRICTION_FLAGS");
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return flags != 0L;
    }

    public static String setUnrestrictDetails(String domName, Long flag, Long max_days) {
        String result = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPStaleAccountUnrestriction", (String)"DOMAIN_NAME"), (Object)domName, 0);
            CommonUtil.getPersistence(new boolean[0]).delete(crit);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("SSPStaleAccountUnrestriction");
            r.set("DOMAIN_NAME", (Object)domName);
            r.set("UNRESTRICTION_FLAGS", (Object)flag);
            r.set("USER_ACTIVE_LOGON_DAYS", (Object)max_days);
            dob.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dob);
            result = "success";
        }
        catch (Exception e) {
            result = "failure";
            e.printStackTrace();
        }
        return result;
    }

    public static void addUserToRestrict(ArrayList selectedUsers, String domainName, int reason) {
        try {
            RestrictUsersHandler.deleteFromAaaLogin(selectedUsers, domainName);
            GSConfigHandler.deleteFromGSUsersTable(selectedUsers);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            for (int i = 0; i < selectedUsers.size(); ++i) {
                Row r = new Row("StaleAccountUsers");
                r.set("OBJECT_GUID", (Object)((String)selectedUsers.get(i)));
                r.set("REASON_FOR_RESTRICTION", (Object)reason);
                obj.addRow(r);
            }
            CommonUtil.getPersistenceLite().add(obj);
            RestrictUsersHandler.auditRestrictedUser(selectedUsers, domainName, "adssp.layout.admin.license_man_restrict_users", reason);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void auditRestrictedUser(ArrayList selectedUsers, String domainName, String action, int reason) {
        try {
            ArrayList userList = UserUtil.getUsersArrayFromGUID(selectedUsers, domainName);
            AdventNetResourceBundle rb = ResourceBundleMgr.getInstance().getBundle();
            JSONObject jsonLog = AuditAPI.getInstance().setBulkAuditProps(domainName, userList.toString(), action, System.currentTimeMillis());
            if (reason != -1) {
                jsonLog.put("REASON_FOR_RESTRICTION", (Object)rb.getString(accountType.get(String.valueOf(reason))));
            }
            LogForwarderAPI.getInstance().sendMessage(jsonLog);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addUserToRestrict(ArrayList selectedUsers, String domainName) {
        RestrictUsersHandler.addUserToRestrict(selectedUsers, domainName, (Integer)null);
    }

    public static DataObject getListOfColumns(String tableName) {
        DataObject dob = null;
        try {
            dob = CommonUtil.getPersistence(new boolean[0]).get(tableName, (Criteria)null);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dob;
    }

    public static ArrayList getGeneratedUsers(Hashtable reportParams) {
        ArrayList<Object> guIdList = new ArrayList<Object>();
        try {
            Long generationId = (Long)reportParams.get("REPORT_GENERATION_ID");
            ArrayList rejectedUsers = (ArrayList)reportParams.get("REJECTED_USERS_LIST");
            Criteria searchCrit = (Criteria)reportParams.get("SEARCH_CRITERIA");
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"ADSMUserReportResult"));
            sq.addSelectColumn(new Column(null, "*"));
            Join join = new Join(Table.getTable((String)"ADSMUserReportResult"), Table.getTable((String)"ADSMUserGeneralDetails"), new String[]{"OBJECT_GUID"}, new String[]{"OBJECT_GUID"}, 2);
            sq.addJoin(join);
            Criteria crit = new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"REPORT_GENERATION_ID"), (Object)generationId, 0, false);
            if (searchCrit != null) {
                crit = crit.and(searchCrit);
            }
            if (rejectedUsers != null) {
                crit = crit.and(new Criteria(Column.getColumn((String)"ADSMUserReportResult", (String)"OBJECT_GUID"), (Object)rejectedUsers.toArray(), 9));
            }
            sq.setCriteria(crit);
            DataObject dob = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
            if (!dob.isEmpty()) {
                Iterator it = dob.getRows("ADSMUserReportResult");
                while (it.hasNext()) {
                    Row r = (Row)it.next();
                    guIdList.add(r.get("OBJECT_GUID"));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return guIdList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void deleteAllUnOwnedLicenses(ArrayList rejectedList, String domainName) {
        Connection connection = null;
        DataSet dataSet = null;
        try {
            String tableName = "AaaLogin";
            String colName = "NAME";
            String usersTable = CommonUtil.getDomainUserTableName(domainName);
            String critCol = "SAM_ACCOUNT_NAME";
            ArrayList<String> list = new ArrayList<String>();
            SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)tableName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)colName));
            sq.addSelectColumn(Column.getColumn((String)tableName, (String)"DOMAINNAME"));
            sq.addSelectColumn(Column.getColumn((String)usersTable, (String)critCol));
            Join join = new Join(Table.getTable((String)tableName), Table.getTable((String)usersTable), new String[]{colName}, new String[]{critCol}, 1);
            Criteria crit = new Criteria(Column.getColumn((String)usersTable, (String)critCol), null, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)"DOMAINNAME"), (Object)domainName, 0));
            if (rejectedList != null && rejectedList.size() > 0) {
                crit = crit.and(new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)rejectedList.toArray(), 9));
            }
            sq.setCriteria(crit);
            sq.addJoin(join);
            RelationalAPI relAPI = RelationalAPI.getInstance();
            logger.log(Level.INFO, "The SELECT QUERY ::: " + relAPI.getSelectSQL((Query)sq));
            connection = relAPI.getConnection();
            dataSet = relAPI.executeQuery((Query)sq, connection);
            while (dataSet.next()) {
                list.add((String)dataSet.getValue(colName));
            }
            Criteria delCrit = new Criteria(Column.getColumn((String)tableName, (String)colName), (Object)list.toArray(), 8);
            CommonUtil.getPersistence(new boolean[0]).delete(delCrit);
            DBUtil.closeQuietly(connection, dataSet);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            DBUtil.closeQuietly(connection, dataSet);
        }
    }

    public static String[] getSearchList() {
        return quickSearchList;
    }
}

