/*
 * Decompiled with CFR 0.152.
 */
package com.adventnet.sym.adsm.common.server.admin;

import com.adventnet.ds.query.Column;
import com.adventnet.ds.query.Criteria;
import com.adventnet.ds.query.Join;
import com.adventnet.ds.query.SelectQuery;
import com.adventnet.ds.query.SelectQueryImpl;
import com.adventnet.ds.query.Table;
import com.adventnet.mfw.bean.BeanUtil;
import com.adventnet.persistence.DataObject;
import com.adventnet.persistence.Row;
import com.adventnet.sym.adsm.common.server.DomainHandler;
import com.adventnet.sym.adsm.common.server.DomainUtil;
import com.adventnet.sym.adsm.common.server.admin.PolicyHandler;
import com.adventnet.sym.adsm.common.server.admin.RestrictUsersHandler;
import com.adventnet.sym.adsm.common.server.reports.AuditMgmtUtil;
import com.adventnet.sym.adsm.common.server.reports.LicensedUsersHandler;
import com.adventnet.sym.adsm.common.server.reports.ReportHandler;
import com.adventnet.sym.adsm.common.server.scheduler.SchedulerUtil;
import com.adventnet.sym.adsm.common.server.taskengine.SchedulerConfiguration;
import com.adventnet.sym.adsm.common.server.util.CommonUtil;
import com.adventnet.sym.adsm.common.server.util.GroupUtil;
import com.adventnet.sym.adsm.common.server.util.OUUtil;
import com.adventnet.sym.adsm.common.server.util.StrUtil;
import com.adventnet.sym.adsm.common.server.util.UserUtil;
import com.adventnet.sym.adsm.security.server.ADSMPersUtil;
import com.adventnet.taskengine.Scheduler;
import com.adventnet.taskengine.util.ScheduleUtil;
import java.io.File;
import java.net.URLDecoder;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.http.HttpServletRequest;
import org.json.JSONObject;

public class SchedulerHandler {
    private static JSONObject asyncSchedulers = new JSONObject();
    private static SchedulerHandler instance = null;
    private static final Logger LOGMSG = Logger.getLogger(SchedulerHandler.class.getName());
    public static final Long UNLOCK_TASK_ID = SchedulerHandler.getTaskID("com.adventnet.sym.adsm.common.server.taskengine.LockedOutTask");
    public static final Long RESET_TASK_ID = SchedulerHandler.getTaskID("com.adventnet.sym.adsm.common.server.taskengine.PwdExpiredTask");

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SchedulerHandler getInstance() {
        if (instance != null) return instance;
        Class<SchedulerHandler> clazz = SchedulerHandler.class;
        synchronized (SchedulerHandler.class) {
            instance = new SchedulerHandler();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void removeAsyncSchedulerEntry(String scheduleId) {
        try {
            if (asyncSchedulers.has(scheduleId)) {
                asyncSchedulers.remove(scheduleId);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSchedulerRunning(String scheduleId, String className) {
        boolean isRunning = false;
        try {
            if (asyncSchedulers.has(scheduleId.toString())) {
                if (className == null || className != null && className.equals("")) {
                    Row r;
                    Criteria crit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                    DataObject taskDO = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("TaskEngine_Task", "Scheduled_Task")), crit);
                    if (!taskDO.isEmpty() && (r = taskDO.getRow("TaskEngine_Task")) != null) {
                        className = r.get("CLASS_NAME").toString();
                    }
                }
                if (asyncSchedulers.getString(scheduleId.toString()).equals(className)) {
                    return true;
                }
            }
            this.removeAsyncSchedulerEntry(scheduleId);
        }
        catch (Exception e) {
            e.printStackTrace();
            isRunning = false;
        }
        return isRunning;
    }

    public void deletePolicyScheduler(Long policyId, Long taskId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"TASK_ID"), (Object)taskId, 0));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", crit);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow("SchedulerConfiguration");
                Long scheduleId = (Long)row.get("SCHEDULE_ID");
                Criteria c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                CommonUtil.getPersistence(new boolean[0]).delete(c);
                CommonUtil.getPersistence(new boolean[0]).delete(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void updatePolicyScheduler(Hashtable scheduleProps, Long policyId, Long taskId, HttpServletRequest request) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"TASK_ID"), (Object)taskId, 0));
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", crit);
            if (!dataObj.isEmpty()) {
                Row row = dataObj.getFirstRow("SchedulerConfiguration");
                Long scheduleId = (Long)row.get("SCHEDULE_ID");
                Criteria c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                CommonUtil.getPersistence(new boolean[0]).delete(c);
                CommonUtil.getPersistence(new boolean[0]).update(dataObj);
            }
            if (taskId.equals(UNLOCK_TASK_ID)) {
                scheduleProps.put("SCHEDULE_NAME", "LockedOutScheduler_" + policyId);
                scheduleProps.put("DESCRIPTION", "Takes a database incremental backup.");
            } else {
                scheduleProps.put("SCHEDULE_NAME", "PwdExpiredScheduler_" + policyId);
                scheduleProps.put("DESCRIPTION", "Report Scheduled Task");
            }
            scheduleProps.put("POLICY_ID", policyId);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            this.addSchedulePolicy(obj, scheduleProps, taskId, request);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void addSchedulePolicy(DataObject obj, Hashtable scheduleProps, Long taskId, HttpServletRequest request) {
        try {
            Row scheduleRow = new Row("Schedule");
            scheduleRow.set("SCHEDULE_NAME", (Object)scheduleProps.get("SCHEDULE_NAME").toString());
            scheduleRow.set("DESCRIPTION", (Object)scheduleProps.get("DESCRIPTION").toString());
            obj.addRow(scheduleRow);
            Object scheduleId = scheduleRow.get("SCHEDULE_ID");
            String type = "";
            if (taskId.equals(UNLOCK_TASK_ID)) {
                type = (String)scheduleProps.get("SCHEDULE_UNLOCK");
                String unitOfTime = "Hours";
                Long timeOfDay = new Long((String)scheduleProps.get("TIME_OF_DAY_UNLOCK"));
                Long minOfHour = new Long((String)scheduleProps.get("MINS_OF_HOUR_UNLOCK"));
                if (minOfHour != null && !minOfHour.equals(0L)) {
                    timeOfDay = timeOfDay * 60L + minOfHour;
                    unitOfTime = "Minutes";
                }
                if (type.equals("hourly")) {
                    Row periodicRow = new Row("Periodic");
                    periodicRow.set("SCHEDULE_ID", scheduleId);
                    periodicRow.set("TIME_PERIOD", (Object)timeOfDay);
                    periodicRow.set("UNIT_OF_TIME", (Object)unitOfTime);
                    obj.addRow(periodicRow);
                } else {
                    Row calendarRow = new Row("Calendar");
                    calendarRow.set("SCHEDULE_ID", scheduleId);
                    calendarRow.set("TIME_OF_DAY", (Object)timeOfDay);
                    calendarRow.set("UNIT_OF_TIME", (Object)unitOfTime);
                    if (type.equals("weekly")) {
                        calendarRow.set("DAY_OF_WEEK", (Object)Integer.parseInt((String)scheduleProps.get("DAY_OF_WEEK_UNLOCK")));
                        calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
                    } else if (type.equals("monthly")) {
                        calendarRow.set("DATE_OF_MONTH", (Object)Integer.parseInt((String)scheduleProps.get("DATE_OF_MONTH_UNLOCK")));
                        calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
                    } else {
                        calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
                    }
                    obj.addRow(calendarRow);
                }
            } else {
                type = (String)scheduleProps.get("SCHEDULE_RESET");
                String unitOfTime = "Hours";
                Long timeOfDay = new Long((String)scheduleProps.get("TIME_OF_DAY_RESET"));
                Long minOfHour = new Long((String)scheduleProps.get("MINS_OF_HOUR_RESET"));
                if (minOfHour != null && !minOfHour.equals(0L)) {
                    timeOfDay = timeOfDay * 60L + minOfHour;
                    unitOfTime = "Minutes";
                }
                if (type.equals("hourly")) {
                    Row periodicRow = new Row("Periodic");
                    periodicRow.set("SCHEDULE_ID", scheduleId);
                    periodicRow.set("TIME_PERIOD", (Object)timeOfDay);
                    periodicRow.set("UNIT_OF_TIME", (Object)unitOfTime);
                    obj.addRow(periodicRow);
                } else {
                    Row calendarRow = new Row("Calendar");
                    calendarRow.set("SCHEDULE_ID", scheduleId);
                    calendarRow.set("TIME_OF_DAY", (Object)timeOfDay);
                    calendarRow.set("UNIT_OF_TIME", (Object)unitOfTime);
                    if (type.equals("weekly")) {
                        calendarRow.set("DAY_OF_WEEK", (Object)Integer.parseInt((String)scheduleProps.get("DAY_OF_WEEK_RESET")));
                        calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
                    } else if (type.equals("monthly")) {
                        calendarRow.set("DATE_OF_MONTH", (Object)Integer.parseInt((String)scheduleProps.get("DATE_OF_MONTH_RESET")));
                        calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
                    } else {
                        calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
                    }
                    obj.addRow(calendarRow);
                }
            }
            scheduleProps.put("ADMIN_STATUS", new Integer(3));
            SchedulerHandler.addScheduledTask(obj, scheduleId, taskId, scheduleProps);
            SchedulerHandler.addScheduleConfiguration(obj, (Long)scheduleProps.get("POLICY_ID"), scheduleId, taskId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Object updateReportScheduler(Hashtable scheduleProps, HttpServletRequest request) {
        return SchedulerHandler.updateReportScheduler(scheduleProps, request, true);
    }

    public static Object updateReportScheduler(Hashtable scheduleProps, HttpServletRequest request, boolean updateOUs) {
        Object newSchId = new Long(-1L);
        try {
            ArrayList policyIds;
            ArrayList reportIds;
            Criteria c = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), scheduleProps.get("SCHEDULE_NAME"), 0);
            Long scheduleId = (Long)scheduleProps.get("SCHEDULE_ID");
            SchedulerHandler.deleteScheduler(scheduleId);
            Long taskId = (Long)scheduleProps.get("TASK_ID");
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            newSchId = SchedulerHandler.addSchedule(obj, scheduleProps, taskId);
            if (request.getParameterValues("DOMAINS") != null) {
                SchedulerHandler.setSchedulerDomainsAndOUs(request, obj, newSchId);
            }
            if ((reportIds = (ArrayList)scheduleProps.get("MAPPING_REPORTS")) != null && !reportIds.isEmpty()) {
                SchedulerHandler.setSchedulerReportsMapping(reportIds, obj, newSchId);
            }
            if ((policyIds = (ArrayList)scheduleProps.get("MAPPING_POLICIES")) != null && !policyIds.isEmpty()) {
                SchedulerHandler.setSchedulerPolicyMapping(policyIds, obj, newSchId);
            }
            if ("true".equals(scheduleProps.get("NOTIFY_ADMIN")) || "true".equals(scheduleProps.get("NOTIFY_MANAGER"))) {
                SchedulerHandler.setSchedulerNotification(scheduleProps, obj, newSchId);
            }
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
            newSchId = new Long(-1L);
        }
        return newSchId;
    }

    public static Object addSchedule(DataObject obj, Hashtable scheduleProps, Long taskId) {
        Object scheduleId = new Long(-1L);
        try {
            String type;
            Row scheduleRow = new Row("Schedule");
            scheduleRow.set("SCHEDULE_NAME", (Object)((String)scheduleProps.get("SCHEDULE_NAME")));
            String desc = (String)scheduleProps.get("DESCRIPTION");
            if (desc.length() > 150) {
                desc = desc.substring(0, 150);
                scheduleProps.put("DESCRIPTION", desc);
            }
            scheduleRow.set("DESCRIPTION", (Object)desc);
            obj.addRow(scheduleRow);
            scheduleId = scheduleRow.get("SCHEDULE_ID");
            String unitOfTime = "Hours";
            Long timeOfDay = (Long)scheduleProps.get("TIME_OF_DAY");
            Long minOfHour = (Long)scheduleProps.get("MINS_OF_HOUR");
            if (minOfHour != null && !minOfHour.equals(0L)) {
                timeOfDay = timeOfDay * 60L + minOfHour;
                unitOfTime = "Minutes";
            }
            if ((type = (String)scheduleProps.get("SCHEDULE_TYPE")).equalsIgnoreCase("hourly")) {
                Row periodicRow = new Row("Periodic");
                periodicRow.set("SCHEDULE_ID", scheduleId);
                periodicRow.set("TIME_PERIOD", (Object)timeOfDay);
                periodicRow.set("UNIT_OF_TIME", (Object)unitOfTime);
                obj.addRow(periodicRow);
            } else {
                Row calendarRow = new Row("Calendar");
                calendarRow.set("SCHEDULE_ID", scheduleId);
                calendarRow.set("TIME_OF_DAY", (Object)timeOfDay);
                calendarRow.set("UNIT_OF_TIME", (Object)unitOfTime);
                if (type.equalsIgnoreCase("weekly")) {
                    calendarRow.set("DAY_OF_WEEK", scheduleProps.get("DAY_OF_WEEK"));
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Weekly");
                } else if (type.equalsIgnoreCase("monthly")) {
                    calendarRow.set("DATE_OF_MONTH", scheduleProps.get("DATE_OF_MONTH"));
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Monthly");
                } else {
                    calendarRow.set("REPEAT_FREQUENCY", (Object)"Daily");
                }
                obj.addRow(calendarRow);
            }
            SchedulerHandler.addScheduledTask(obj, scheduleId, taskId, scheduleProps);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleId;
    }

    public static void addScheduledTask(DataObject obj, Object scheduleId, Long taskId, Hashtable scheduleProps) {
        try {
            Row scheduledTask = new Row("Scheduled_Task");
            scheduledTask.set("SCHEDULE_ID", scheduleId);
            scheduledTask.set("TASK_ID", (Object)taskId);
            scheduledTask.set("TRANSACTION_TIME", (Object)new Integer(-1));
            Boolean skipMissedSchedule = scheduleProps.containsKey("SKIP_MISSED_SCHEDULE") ? (Boolean)scheduleProps.get("SKIP_MISSED_SCHEDULE") : Boolean.FALSE;
            scheduledTask.set("SKIP_MISSED_SCHEDULE", (Object)skipMissedSchedule);
            scheduledTask.set("ADMIN_STATUS", (Object)new Integer(3));
            scheduledTask.set("AUDIT_FLAG", (Object)true);
            obj.addRow(scheduledTask);
            Row taskInput = new Row("Task_Input");
            taskInput.set("SCHEDULE_ID", scheduleId);
            taskInput.set("TASK_ID", (Object)taskId);
            taskInput.set("ADMIN_STATUS", scheduleProps.get("ADMIN_STATUS"));
            Long time = ScheduleUtil.calculateNextScheduleTime((DataObject)obj, (Long)new Long(-1L), (boolean)false);
            taskInput.set("SCHEDULE_TIME", (Object)new Timestamp(time));
            obj.addRow(taskInput);
            Hashtable defaultTaskProps = (Hashtable)scheduleProps.get("DEFAULT_TASK_PROPS");
            if (defaultTaskProps != null) {
                defaultTaskProps.put("INSTANCE_ID", taskInput.get("INSTANCE_ID"));
                SchedulerHandler.setDefaultTaskInput(defaultTaskProps, obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void addScheduleConfiguration(DataObject obj, Long policyId, Object scheduleId, Long taskId) {
        try {
            Criteria c = new Criteria(Column.getColumn((String)"PolicyConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("PolicyConfiguration", c);
            Row r = dataObj.getFirstRow("PolicyConfiguration");
            Row row = new Row("SchedulerConfiguration");
            row.set("POLICY_ID", (Object)policyId);
            row.set("SCHEDULE_ID", scheduleId);
            row.set("TASK_ID", (Object)taskId);
            row.set("DOMAIN_NAME", (Object)((String)r.get("DOMAIN_NAME")));
            obj.addRow(row);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public boolean isSoonToExpireTask(Long taskId) {
        boolean ret = false;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)"TASK_ID"), (Object)taskId, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("TaskEngine_Task", crit);
            Row r = dataObj.getRow("TaskEngine_Task");
            String className = (String)r.get("CLASS_NAME");
            if (className.equals("com.adventnet.sym.adsm.common.server.taskengine.SoonToPwdExpTask")) {
                ret = true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return ret;
    }

    public static Long getTaskID(String className) {
        Long taskId = null;
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"TaskEngine_Task", (String)"CLASS_NAME"), (Object)className, 0);
            DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get("TaskEngine_Task", crit);
            Row r = dataObj.getRow("TaskEngine_Task");
            taskId = (Long)r.get("TASK_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return taskId;
    }

    public static void fillSchedulerPolicy(Long policyId, Long taskId, JSONObject json) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"POLICY_ID"), (Object)policyId, 0);
            crit = crit.and(new Criteria(Column.getColumn((String)"SchedulerConfiguration", (String)"TASK_ID"), (Object)taskId, 0));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SchedulerConfiguration", crit);
            Row row = obj.getFirstRow("SchedulerConfiguration");
            Long scheduleId = (Long)row.get("SCHEDULE_ID");
            crit = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("Periodic", crit);
            if (!obj.isEmpty()) {
                row = obj.getFirstRow("Periodic");
                String type = (String)row.get("UNIT_OF_TIME");
                String setType = "hourly";
                Long timeOfDay = (Long)row.get("TIME_PERIOD");
                Long hours = 0L;
                if (type.equalsIgnoreCase("minutes")) {
                    setType = "minutes";
                    Long day = timeOfDay / 60L;
                    hours = timeOfDay % 60L;
                    timeOfDay = day;
                }
                if (taskId.equals(UNLOCK_TASK_ID)) {
                    json.put("SCHEDULE_UNLOCK", (Object)"hourly");
                    json.put("TIME_OF_DAY_UNLOCK", (Object)timeOfDay);
                    if (type.equalsIgnoreCase("minutes")) {
                        json.put("MINS_OF_HOUR_UNLOCK", (Object)hours);
                    }
                } else {
                    json.put("SCHEDULE_RESET", (Object)"hourly");
                    json.put("TIME_OF_DAY_RESET", (Object)timeOfDay);
                    if (type.equalsIgnoreCase("minutes")) {
                        json.put("MINS_OF_HOUR_RESET", (Object)hours);
                    }
                }
            } else {
                crit = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                obj = CommonUtil.getPersistence(new boolean[0]).get("Calendar", crit);
                row = obj.getFirstRow("Calendar");
                Integer dayOfWeek = (Integer)row.get("DAY_OF_WEEK");
                Integer dateOfMonth = (Integer)row.get("DATE_OF_MONTH");
                if (dayOfWeek != -1) {
                    if (taskId.equals(UNLOCK_TASK_ID)) {
                        json.put("SCHEDULE_UNLOCK", (Object)"weekly");
                        json.put("DAY_OF_WEEK_UNLOCK", (Object)dayOfWeek);
                    } else {
                        json.put("SCHEDULE_RESET", (Object)"weekly");
                        json.put("DAY_OF_WEEK_RESET", (Object)dayOfWeek);
                    }
                } else if (dateOfMonth != -1) {
                    if (taskId.equals(UNLOCK_TASK_ID)) {
                        json.put("SCHEDULE_UNLOCK", (Object)"monthly");
                        json.put("DATE_OF_MONTH_UNLOCK", (Object)dateOfMonth);
                    } else {
                        json.put("SCHEDULE_RESET", (Object)"monthly");
                        json.put("DATE_OF_MONTH_RESET", (Object)dateOfMonth);
                    }
                } else if (taskId.equals(UNLOCK_TASK_ID)) {
                    json.put("SCHEDULE_UNLOCK", (Object)"daily");
                } else {
                    json.put("SCHEDULE_RESET", (Object)"daily");
                }
                String type = (String)row.get("UNIT_OF_TIME");
                String setType = "hourly";
                Long timeOfDay = (Long)row.get("TIME_OF_DAY");
                Long hours = 0L;
                if (type.equalsIgnoreCase("minutes")) {
                    setType = "minutes";
                    Long day = timeOfDay / 60L;
                    hours = timeOfDay % 60L;
                    timeOfDay = day;
                }
                if (taskId.equals(UNLOCK_TASK_ID)) {
                    json.put("TIME_OF_DAY_UNLOCK", (Object)timeOfDay);
                    if (type.equalsIgnoreCase("minutes")) {
                        json.put("MINS_OF_HOUR_UNLOCK", (Object)hours);
                    }
                } else {
                    json.put("TIME_OF_DAY_RESET", (Object)timeOfDay);
                    if (type.equalsIgnoreCase("minutes")) {
                        json.put("MINS_OF_HOUR_RESET", (Object)hours);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Hashtable getSchedulerProps(Long scheduleId, Hashtable props) {
        try {
            SchedulerHandler.fillSchedulerDetails(scheduleId, props);
            SchedulerHandler.fillDefaultTaskInput(scheduleId, props);
            SchedulerHandler.fillSchedulerDomainsAndOUs(scheduleId, props);
            SchedulerHandler.fillSchedulerPolicyMapping(scheduleId, props);
            String notifyAdmin = (String)((Hashtable)props.get("inputParams")).get("NOTIFY_ADMIN");
            if (notifyAdmin == null) {
                notifyAdmin = (String)props.get("NOTIFY_ADMIN");
            }
            if ("true".equals(notifyAdmin) || "true".equals((String)props.get("NOTIFY_MANAGER"))) {
                SchedulerHandler.fillSchedulerNotification(scheduleId, props);
            } else {
                Properties mailProp = ADSMPersUtil.getMailServerSettings();
                if (mailProp.get("ADMIN_MAIL_ID") != null) {
                    props.put("EMAIL_ID", (String)mailProp.get("ADMIN_MAIL_ID"));
                }
            }
            SchedulerHandler.fillSchedulerReportsMapping(scheduleId, props);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return props;
    }

    public static void fillSchedulerDetails(Long scheduleId, Hashtable props) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            Row row = new Row();
            if (obj.isEmpty()) {
                return;
            }
            row = obj.getFirstRow("Schedule");
            props.put("SCHEDULE_NAME", (String)row.get("SCHEDULE_NAME"));
            props.put("DESCRIPTION", (String)row.get("DESCRIPTION"));
            crit = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("Periodic", crit);
            if (!obj.isEmpty()) {
                row = obj.getFirstRow("Periodic");
                props.put("TIME_OF_DAY", row.get("TIME_PERIOD"));
                props.put("SCHEDULE_TYPE", "hourly");
            } else {
                crit = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                obj = CommonUtil.getPersistence(new boolean[0]).get("Calendar", crit);
                if (!obj.isEmpty()) {
                    row = obj.getFirstRow("Calendar");
                    if ("Minutes".equalsIgnoreCase((String)row.get("UNIT_OF_TIME"))) {
                        props.put("TIME_OF_DAY", (Long)row.get("TIME_OF_DAY") / 60L);
                        props.put("MINS_OF_HOUR", (Long)row.get("TIME_OF_DAY") % 60L);
                    } else {
                        props.put("TIME_OF_DAY", row.get("TIME_OF_DAY"));
                    }
                    Integer dayOfWeek = (Integer)row.get("DAY_OF_WEEK");
                    Integer dateOfMonth = (Integer)row.get("DATE_OF_MONTH");
                    if (dayOfWeek != -1) {
                        props.put("DAY_OF_WEEK", dayOfWeek);
                        props.put("SCHEDULE_TYPE", "weekly");
                    } else if (dateOfMonth != -1) {
                        props.put("DATE_OF_MONTH", dateOfMonth);
                        props.put("SCHEDULE_TYPE", "monthly");
                    } else {
                        props.put("SCHEDULE_TYPE", "daily");
                    }
                }
            }
            crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
            if (!obj.isEmpty()) {
                row = obj.getFirstRow("Task_Input");
                props.put("NEXT_SCHEDULE_TIME", (Timestamp)row.get("SCHEDULE_TIME"));
                props.put("ADMIN_STATUS", (Integer)row.get("ADMIN_STATUS"));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillSchedulerNotification(Long scheduleId, Hashtable props) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSchedulerNotification", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerNotification", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("SSPSchedulerNotification");
                List columnList = r.getColumns();
                for (Object object : columnList) {
                    String cN = (String)object;
                    if (r.get(cN) == null) continue;
                    props.put(cN, r.get(cN));
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSchedulerNotification(Hashtable props, DataObject obj, Object scheduleId) {
        try {
            Row r = new Row("SSPSchedulerNotification");
            List columnList = r.getColumns();
            for (Object object : columnList) {
                String cName = (String)object;
                Object cVal = props.get(cName);
                if ("SCHEDULE_ID".equals(cName)) {
                    cVal = scheduleId;
                }
                if (cVal == null) continue;
                r.set(cName, cVal);
            }
            obj.addRow(r);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillDefaultTaskInput(Long scheduleId, Hashtable props) {
        try {
            SelectQueryImpl query = new SelectQueryImpl(new Table("Default_Task_Input"));
            query.addJoin(new Join(new Table("Default_Task_Input"), new Table("Task_Input"), new String[]{"INSTANCE_ID"}, new String[]{"INSTANCE_ID"}, 2));
            Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            query.setCriteria(crit);
            query.addSelectColumn(Column.getColumn((String)"Default_Task_Input", (String)"INSTANCE_ID"));
            query.addSelectColumn(Column.getColumn((String)"Default_Task_Input", (String)"VARIABLE_NAME"));
            query.addSelectColumn(Column.getColumn((String)"Default_Task_Input", (String)"VARIABLE_VALUE"));
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)query);
            Hashtable<String, String> inputParams = new Hashtable<String, String>();
            Iterator it = obj.getRows("Default_Task_Input");
            while (it.hasNext()) {
                Row r = (Row)it.next();
                String key = (String)r.get("VARIABLE_NAME");
                String value = (String)r.get("VARIABLE_VALUE");
                inputParams.put(key, value);
            }
            props.put("inputParams", inputParams);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setDefaultTaskInput(Hashtable defaultTaskProps, DataObject obj) {
        try {
            Enumeration enu = defaultTaskProps.keys();
            while (enu.hasMoreElements()) {
                Row defaultTaskInput = new Row("Default_Task_Input");
                String propertyName = (String)enu.nextElement();
                defaultTaskInput.set("INSTANCE_ID", defaultTaskProps.get("INSTANCE_ID"));
                defaultTaskInput.set("VARIABLE_NAME", (Object)propertyName);
                defaultTaskInput.set("VARIABLE_VALUE", defaultTaskProps.get(propertyName));
                obj.addRow(defaultTaskInput);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillSchedulerDomainsAndOUs(Long scheduleId, Hashtable props) {
        try {
            boolean dashBoardScheduler;
            Hashtable inputs = (Hashtable)props.get("inputParams");
            boolean bl = dashBoardScheduler = inputs == null || "true".equals(inputs.get("UpdateDashBoard"));
            if (dashBoardScheduler) {
                Hashtable domains = DomainHandler.getConfiguredDomains();
                Hashtable domainVsItems = new Hashtable();
                ArrayList<String> domainList = new ArrayList<String>();
                Enumeration enumer = domains.keys();
                while (enumer.hasMoreElements()) {
                    String distinName = (String)enumer.nextElement();
                    Properties p = (Properties)domains.get(distinName);
                    String domainName = p.getProperty("DOMAIN_NAME");
                    String defaultNamingContext = p.getProperty("DEFAULT_NAMING_CONTEXT");
                    ArrayList<String> itemList = new ArrayList<String>();
                    itemList.add(defaultNamingContext);
                    domainVsItems.put(domainName, itemList);
                    domainList.add(domainName);
                }
                props.put("DOMAIN_VS_OUS", domainVsItems);
                props.put("SCHEDULED_DOMAINS", domainList);
                return;
            }
            String[] objClsArray = new String[]{"OU", "GROUP", "COMPUTER"};
            String[] keyArray = new String[]{"DOMAIN_VS_OUS", "DOMAIN_VS_GROUPS", "DOMAIN_VS_COMPUTERS"};
            Criteria schCrit = new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject sObj = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("SSPSchedulerReportOUs", "SSPSchRepObjects")), schCrit);
            for (int i = 0; i < objClsArray.length; ++i) {
                Hashtable domainVsItems = new Hashtable();
                ArrayList<String> domainList = new ArrayList<String>();
                ArrayList<String> itemList = new ArrayList<String>();
                String objClass = objClsArray[i];
                String propKey = keyArray[i];
                if (!props.containsKey("GROUP_SELECTION") && objClass.equalsIgnoreCase("GROUP")) continue;
                Iterator iterator = sObj.getRows("SSPSchedulerReportOUs");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    String domainName = (String)r.get("DOMAIN_NAME");
                    Criteria c = new Criteria(Column.getColumn((String)"SSPSchRepObjects", (String)"CONFIG_ID"), r.get("CONFIG_ID"), 0);
                    c = c.and(new Criteria(Column.getColumn((String)"SSPSchRepObjects", (String)"OBJECT_CLASS"), (Object)objClass, 0, false));
                    Iterator it = sObj.getRows("SSPSchRepObjects", c);
                    while (it.hasNext()) {
                        Row objRow = (Row)it.next();
                        String uniqueId = (String)objRow.get("OBJECT_VALUE");
                        if (!domainList.contains(domainName)) {
                            if (itemList.size() > 0) {
                                domainVsItems.put((String)domainList.get(domainList.size() - 1), itemList);
                            }
                            domainList.add(domainName);
                            itemList = new ArrayList();
                        }
                        itemList.add(uniqueId);
                    }
                }
                if (itemList.size() > 0) {
                    domainVsItems.put((String)domainList.get(domainList.size() - 1), itemList);
                }
                props.put(propKey, domainVsItems);
                if (null != props.get("SCHEDULED_DOMAINS")) {
                    ArrayList domList = (ArrayList)props.get("SCHEDULED_DOMAINS");
                    for (String domName : domList) {
                        if (domainList.contains(domName)) continue;
                        domainList.add(domName);
                    }
                }
                props.put("SCHEDULED_DOMAINS", domainList);
            }
            Hashtable domainVsComps = (Hashtable)props.get("DOMAIN_VS_COMPUTERS");
            Hashtable domainVsItemDetails = new Hashtable();
            if (domainVsComps != null) {
                Enumeration en = domainVsComps.keys();
                while (en.hasMoreElements()) {
                    String key = (String)en.nextElement();
                    ArrayList guidList = (ArrayList)domainVsComps.get(key);
                    String table = CommonUtil.getDomainComputerTableName(key);
                    Criteria crit = new Criteria(Column.getColumn((String)table, (String)"OBJECT_GUID"), (Object)guidList.toArray(new String[guidList.size()]), 8);
                    DataObject compDO = CommonUtil.getPersistence(new boolean[0]).get(table, crit);
                    if (compDO.isEmpty()) continue;
                    Iterator compIterator = compDO.getRows(table);
                    ArrayList<JSONObject> computerList = new ArrayList<JSONObject>();
                    while (compIterator.hasNext()) {
                        JSONObject itemDetails = new JSONObject();
                        Row compRow = (Row)compIterator.next();
                        itemDetails.put("OBJECT_GUID", (Object)((String)compRow.get("OBJECT_GUID")));
                        itemDetails.put("OBJECT_NAME", (Object)((String)compRow.get("NAME")));
                        itemDetails.put("OBJECT_CLASS", (Object)"computer");
                        computerList.add(itemDetails);
                    }
                    domainVsItemDetails.put(key, computerList);
                }
                props.put("DOMAIN_VS_COMPDETAILS", domainVsItemDetails);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSchedulerDomainsAndOUs(HttpServletRequest request, DataObject obj, Object scheduleId) {
        try {
            String[] domainList = request.getParameterValues("DOMAINS");
            String[] repIds = request.getParameterValues("ACCOUNT_TYPE");
            for (int i = 0; i < domainList.length; ++i) {
                String objType;
                String compList;
                JSONObject compsJson;
                String domainName = domainList[i];
                if (request.getParameter(domainName) == null) continue;
                Row r = new Row("SSPSchedulerReportOUs");
                r.set("SCHEDULE_ID", scheduleId);
                r.set("DOMAIN_NAME", (Object)domainName);
                obj.addRow(r);
                if (request.getParameter(domainName + "_hidden_grps") != null) {
                    String[] objTypeArr;
                    JSONObject grpsJson = new JSONObject(request.getParameter(domainName + "_hidden_grps"));
                    for (String objType2 : objTypeArr = new String[]{"group", "ou"}) {
                        if (!grpsJson.has(objType2)) continue;
                        JSONObject grpObj = grpsJson.getJSONObject(objType2);
                        Iterator objIterator = grpObj.keys();
                        if (objType2.equalsIgnoreCase("OU")) {
                            ArrayList<String> ouGuidList = new ArrayList<String>();
                            String domainGuid = request.getParameter(domainName + "_OBJECT_GUID");
                            String dn = request.getParameter(domainName + "_DN");
                            if (domainGuid == null) {
                                domainGuid = DomainUtil.getDomainGenDetails("NAME", domainName, new String[]{"OBJECT_GUID"}).get("OBJECT_GUID").toString();
                            }
                            if (grpObj.has(domainGuid)) {
                                if (dn == null) {
                                    dn = DomainHandler.getDefaultNamingContext(domainName);
                                }
                                ouGuidList.add(dn);
                                objIterator = ouGuidList.iterator();
                            } else {
                                while (objIterator.hasNext()) {
                                    ouGuidList.add((String)objIterator.next());
                                }
                                Criteria c = new Criteria(Column.getColumn((String)"ADSMOUDetails", (String)"OBJECT_GUID"), (Object)ouGuidList.toArray(new String[ouGuidList.size()]), 8, false);
                                objIterator = OUUtil.getOUList(domainName, c).iterator();
                            }
                        }
                        while (objIterator.hasNext()) {
                            Row grpRow = new Row("SSPSchRepObjects");
                            grpRow.set("CONFIG_ID", r.get("CONFIG_ID"));
                            grpRow.set("OBJECT_CLASS", (Object)objType2.toUpperCase());
                            grpRow.set("OBJECT_VALUE", (Object)((String)objIterator.next()));
                            obj.addRow(grpRow);
                        }
                    }
                } else if (request.getParameter(domainName + "_OULIST") != null) {
                    String[] ouList = request.getParameterValues(domainName + "_OULIST");
                    for (int j = 0; j < ouList.length; ++j) {
                        Row ouRow = new Row("SSPSchRepObjects");
                        ouRow.set("CONFIG_ID", r.get("CONFIG_ID"));
                        ouRow.set("OBJECT_CLASS", (Object)"OU");
                        ouRow.set("OBJECT_VALUE", (Object)StrUtil.decodeURIComponent(ouList[j]));
                        obj.addRow(ouRow);
                    }
                } else {
                    Row ouRow = new Row("SSPSchRepObjects");
                    ouRow.set("CONFIG_ID", r.get("CONFIG_ID"));
                    ouRow.set("OBJECT_CLASS", (Object)"OU");
                    ouRow.set("OBJECT_VALUE", (Object)StrUtil.decodeURIComponent(request.getParameter(domainName)));
                    obj.addRow(ouRow);
                }
                if (StrUtil.isEmpty(request.getParameter(domainName + "_COMPLIST")) || !Arrays.asList(repIds).contains(RestrictUsersHandler.SERVICE_ACCOUNTS_REP_ID.toString()) || !(compsJson = new JSONObject(URLDecoder.decode(compList = StrUtil.htmlUnescape(request.getParameter(domainName + "_COMPLIST")), "UTF-8"))).has(objType = "computer")) continue;
                JSONObject grpObj = compsJson.getJSONObject(objType);
                Iterator objIterator = grpObj.keys();
                while (objIterator.hasNext()) {
                    Row compRow = new Row("SSPSchRepObjects");
                    compRow.set("CONFIG_ID", r.get("CONFIG_ID"));
                    compRow.set("OBJECT_CLASS", (Object)objType.toUpperCase());
                    compRow.set("OBJECT_VALUE", (Object)StrUtil.decodeURIComponent((String)objIterator.next()));
                    obj.addRow(compRow);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillSchedulerReportsMapping(Long scheduleId, Hashtable props) {
        block7: {
            try {
                Criteria crit = new Criteria(Column.getColumn((String)"SSPSchedulerReportMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerReportMapping", crit);
                if (obj.isEmpty()) break block7;
                ArrayList<Integer> repIds = new ArrayList<Integer>();
                ArrayList<String> repNames = new ArrayList<String>();
                Iterator iterator = obj.getRows("SSPSchedulerReportMapping");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    Integer repId = (Integer)r.get("REPORT_ID");
                    repIds.add(repId);
                    String reportName = ReportHandler.getSSPReportName(repId.toString());
                    if (props.containsKey("SCHEDULED_DOMAINS") && !AuditMgmtUtil.USER_ATTEMPTS_IDS.contains(repId.toString())) {
                        ArrayList domains = (ArrayList)props.get("SCHEDULED_DOMAINS");
                        for (int i = 0; i < domains.size(); ++i) {
                            StringBuffer reportAttachName = new StringBuffer(reportName);
                            String domainName = (String)domains.get(i);
                            reportAttachName.append("_").append(domainName);
                            if (props.containsKey("FILE_FORMAT")) {
                                String fileFormat = props.get("FILE_FORMAT").toString().toLowerCase();
                                if (fileFormat.indexOf("csv") != -1) {
                                    fileFormat = "csv";
                                }
                                reportAttachName.append(".").append(fileFormat);
                            }
                            repNames.add(reportAttachName.toString());
                        }
                        continue;
                    }
                    repNames.add(reportName.toString());
                }
                props.put("SCHEDULED_REPORT_IDS", repIds);
                props.put("EXPORT_REPORT_NAMES", repNames);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static void setSchedulerReportsMapping(ArrayList reportIds, DataObject obj, Object scheduleId) {
        try {
            for (int i = 0; i < reportIds.size(); ++i) {
                Long reportId = (Long)reportIds.get(i);
                Row reportMapRow = new Row("SSPSchedulerReportMapping");
                reportMapRow.set("SCHEDULE_ID", scheduleId);
                reportMapRow.set("REPORT_ID", (Object)reportId);
                obj.addRow(reportMapRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void fillSchedulerPolicyMapping(Long scheduleId, Hashtable props) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"SSPSchedulerPolicyMapping", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerPolicyMapping", crit);
            if (!obj.isEmpty()) {
                ArrayList<Long> policyIds = new ArrayList<Long>();
                Iterator iterator = obj.getRows("SSPSchedulerPolicyMapping");
                while (iterator.hasNext()) {
                    Row r = (Row)iterator.next();
                    policyIds.add((Long)r.get("POLICY_ID"));
                }
                props.put("SCHEDULED_POLICY_IDS", policyIds);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void setSchedulerPolicyMapping(ArrayList policyIds, DataObject obj, Object scheduleId) {
        try {
            for (int i = 0; i < policyIds.size(); ++i) {
                Long policyId = (Long)policyIds.get(i);
                Row policyMapRow = new Row("SSPSchedulerPolicyMapping");
                policyMapRow.set("SCHEDULE_ID", scheduleId);
                policyMapRow.set("POLICY_ID", (Object)policyId);
                obj.addRow(policyMapRow);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteScheduler(Long scheduleId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            if (!o.isEmpty()) {
                CommonUtil.getPersistence(new boolean[0]).delete(crit);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void deleteTechnicianSchedulers(Long loginId) {
        try {
            if (loginId == null) {
                return;
            }
            Criteria crit = new Criteria(Column.getColumn((String)"AaaLogin", (String)"LOGIN_ID"), (Object)loginId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("AaaLogin", "SSPRestrictUsersScheduler", "SSPReportsScheduler")), crit);
            LOGMSG.log(Level.INFO, "DO : " + obj);
            if (!obj.isEmpty()) {
                String[] tableNames;
                ArrayList<Long> scheduleIds = new ArrayList<Long>();
                for (String tableName : tableNames = new String[]{"SSPRestrictUsersScheduler", "SSPReportsScheduler"}) {
                    Iterator iterator = obj.getRows(tableName);
                    while (iterator.hasNext()) {
                        Row r = (Row)iterator.next();
                        scheduleIds.add((Long)r.get("SCHEDULE_ID"));
                    }
                }
                Criteria criteria = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleIds.toArray(), 8);
                CommonUtil.getPersistence(new boolean[0]).delete(criteria);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Boolean isSchedulerNameExist(Long scheduleId, String scheduleName) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleName, 0, false);
            crit = crit.and(new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 1));
            DataObject o = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            if (!o.isEmpty()) {
                return true;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return false;
    }

    public static void enableDisable(Long scheduleId) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
            if (!obj.isEmpty()) {
                Row r = obj.getRow("Task_Input");
                int status = (Integer)r.get("ADMIN_STATUS");
                status = status == 3 ? 4 : 3;
                r.set("ADMIN_STATUS", (Object)status);
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static String enableDisableScheduler(String scheduleId) {
        String image = "";
        try {
            Criteria c = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", c);
            if (!obj.isEmpty()) {
                Row r = obj.getFirstRow("Task_Input");
                Integer adminStatus = (Integer)r.get("ADMIN_STATUS");
                if (adminStatus == 3) {
                    r.set("ADMIN_STATUS", (Object)new Integer(4));
                    image = "disableIcon";
                } else if (adminStatus == 4) {
                    r.set("ADMIN_STATUS", (Object)new Integer(3));
                    image = "enableIcon";
                }
                obj.updateRow(r);
                CommonUtil.getPersistence(new boolean[0]).update(obj);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return image;
    }

    public static ArrayList getOUs(Long taskId, String domainName, String scheduleName) {
        ArrayList<String> containerList = new ArrayList<String>();
        try {
            Long scheduleId = 0L;
            Criteria schCrit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)scheduleName, 0);
            DataObject schObj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", schCrit);
            if (!schObj.isEmpty()) {
                Row schRow = schObj.getFirstRow("Schedule");
                scheduleId = (Long)schRow.get("SCHEDULE_ID");
                Criteria crit = new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"TASK_ID"), (Object)taskId, 0);
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
                crit = crit.and(new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"DOMAIN_NAME"), (Object)domainName, 0));
                DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("SSPSchedulerReportOUs", crit);
                if (!obj.isEmpty()) {
                    Iterator it = obj.getRows("SSPSchedulerReportOUs");
                    while (it.hasNext()) {
                        Row r = (Row)it.next();
                        String dn = (String)r.get("OU_DISTINGUISHED_NAME");
                        containerList.add(dn);
                    }
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return containerList;
    }

    public static String makeDirectory(String scheduleName, String filePath) {
        String dir = "";
        try {
            boolean isCustomDirCreated;
            Long time = System.currentTimeMillis();
            Date date = new Date(time);
            String dateFormat = "MMMddyyyy";
            String timeFormat = "hh-mm-ss";
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat(dateFormat);
            String formattedCurrentDate = simpleDateFormat.format(date);
            SimpleDateFormat simpleTimeFormat = new SimpleDateFormat(timeFormat);
            String formattedCurrentTime = simpleTimeFormat.format(date);
            scheduleName = scheduleName.replaceAll(" ", "");
            String tempDir = "reports" + File.separator + formattedCurrentDate + File.separator + scheduleName + formattedCurrentTime;
            dir = filePath + File.separator + tempDir;
            File f = new File(dir);
            if (!(f.exists() || (isCustomDirCreated = f.mkdirs()) || (f = new File(dir = ".." + File.separator + "audit-data" + File.separator + tempDir)).exists())) {
                f.mkdirs();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return dir;
    }

    public static Object addScheduler(Hashtable scheduleProps, Long taskId) {
        Object scheduleId = new Long(-1L);
        try {
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            scheduleId = SchedulerHandler.addSchedule(obj, scheduleProps, taskId);
            CommonUtil.getPersistence(new boolean[0]).update(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleId;
    }

    public Object updateMobileScheduler(Hashtable scheduleProps, HttpServletRequest request) {
        Object newSchId = new Long(-1L);
        try {
            Long scheduleId = (Long)scheduleProps.get("SCHEDULE_ID");
            SchedulerHandler.deleteScheduler(scheduleId);
            Long taskId = (Long)scheduleProps.get("TASK_ID");
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            newSchId = SchedulerHandler.addSchedule(obj, scheduleProps, taskId);
            CommonUtil.getPersistence(new boolean[0]).add(obj);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return newSchId;
    }

    public static Properties updateScheduler(Hashtable hash) {
        Properties resProp = new Properties();
        try {
            Long scheduleId = -1L;
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_NAME"), (Object)((String)hash.get("SCHEDULE_NAME")), 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            LOGMSG.log(Level.INFO, "DO : " + obj);
            if (!obj.isEmpty()) {
                Long nextRun = new Long(-1L);
                Row scheduleRow = obj.getFirstRow("Schedule");
                scheduleId = (Long)scheduleRow.get("SCHEDULE_ID");
                Criteria calendarCriteria = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                Criteria periodCriteria = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject calendarObj = CommonUtil.getPersistence(new boolean[0]).get("Calendar", calendarCriteria);
                DataObject periodObj = CommonUtil.getPersistence(new boolean[0]).get("Periodic", periodCriteria);
                Row r = null;
                String scheduleType = (String)hash.get("SCHEDULE_TYPE");
                LOGMSG.log(Level.INFO, "SCH_TYPE : " + scheduleType + " :: MAP :: " + hash);
                String unitOfTime = "Hours";
                Long timeOfDay = (Long)hash.get("TIME_OF_DAY");
                Long minOfHour = (Long)hash.get("MINS_OF_HOUR");
                if (minOfHour != null && !minOfHour.equals(0L)) {
                    timeOfDay = timeOfDay * 60L + minOfHour;
                    unitOfTime = "Minutes";
                }
                if ("Hourly".equalsIgnoreCase(scheduleType)) {
                    CommonUtil.getPersistence(new boolean[0]).delete(calendarCriteria);
                    if (periodObj.isEmpty()) {
                        r = new Row("Periodic");
                        r.set("SCHEDULE_ID", (Object)scheduleId);
                        r.set("UNIT_OF_TIME", (Object)unitOfTime);
                        r.set("TIME_PERIOD", (Object)timeOfDay);
                        periodObj.addRow(r);
                    } else {
                        r = periodObj.getFirstRow("Periodic");
                        r.set("TIME_PERIOD", (Object)timeOfDay);
                        periodObj.updateRow(r);
                    }
                    nextRun = ScheduleUtil.calculateNextScheduleTime((DataObject)periodObj, (Long)new Long(-1L), (boolean)false);
                    CommonUtil.getPersistence(new boolean[0]).update(periodObj);
                } else {
                    Integer dayOfWeek = (Integer)hash.get("DAY_OF_WEEK");
                    Integer dateOfMonth = (Integer)hash.get("DATE_OF_MONTH");
                    CommonUtil.getPersistence(new boolean[0]).delete(periodCriteria);
                    if (calendarObj.isEmpty()) {
                        r = new Row("Calendar");
                        r.set("SCHEDULE_ID", (Object)scheduleId);
                        r.set("UNIT_OF_TIME", (Object)unitOfTime);
                        r.set("REPEAT_FREQUENCY", (Object)scheduleType);
                        r.set("TIME_OF_DAY", (Object)timeOfDay);
                        SchedulerConfiguration.fillCalendarProperties(scheduleType, dayOfWeek, dateOfMonth, r);
                        calendarObj.addRow(r);
                    } else {
                        r = calendarObj.getFirstRow("Calendar");
                        r.set("REPEAT_FREQUENCY", (Object)scheduleType);
                        r.set("TIME_OF_DAY", (Object)timeOfDay);
                        r.set("UNIT_OF_TIME", (Object)unitOfTime);
                        SchedulerConfiguration.fillCalendarProperties(scheduleType, dayOfWeek, dateOfMonth, r);
                        calendarObj.updateRow(r);
                    }
                    nextRun = ScheduleUtil.calculateNextScheduleTime((DataObject)calendarObj, (Long)new Long(-1L), (boolean)false);
                    CommonUtil.getPersistence(new boolean[0]).update(calendarObj);
                }
                Criteria c = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                DataObject taskInpObj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", c);
                if (!taskInpObj.isEmpty()) {
                    Row schTaskRow = taskInpObj.getFirstRow("Task_Input");
                    Long adminStatus = (Long)hash.get("ADMIN_STATUS");
                    schTaskRow.set("ADMIN_STATUS", (Object)adminStatus);
                    schTaskRow.set("SCHEDULE_TIME", (Object)new Timestamp(nextRun));
                    taskInpObj.updateRow(schTaskRow);
                    CommonUtil.getPersistence(new boolean[0]).update(taskInpObj);
                }
            }
            resProp.put("SCHEDULE_ID", scheduleId);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return resProp;
    }

    public static void fillSchedulerProps(Hashtable hash, HttpServletRequest request) {
        String schType = request.getParameter("SCHEDULE_TYPE");
        hash.put("SCHEDULE_TYPE", schType);
        Long timeOfDay = Long.parseLong(request.getParameter("TIME_OF_DAY"));
        Long minOfHours = Long.parseLong(request.getParameter("MINS_OF_HOUR"));
        hash.put("TIME_OF_DAY", timeOfDay);
        hash.put("MINS_OF_HOUR", minOfHours);
        if (schType.equalsIgnoreCase("weekly")) {
            hash.put("DAY_OF_WEEK", Integer.parseInt(request.getParameter("DAY_OF_WEEK")));
        } else if (schType.equalsIgnoreCase("monthly")) {
            hash.put("DATE_OF_MONTH", Integer.parseInt(request.getParameter("DATE_OF_MONTH")));
        }
    }

    public static void fillSQASchedulerDetails(Long scheduleId, Hashtable props) {
        try {
            Criteria crit = new Criteria(Column.getColumn((String)"Schedule", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject obj = CommonUtil.getPersistence(new boolean[0]).get("Schedule", crit);
            Row row = obj.getFirstRow("Schedule");
            props.put("SCHEDULE_NAME", (String)row.get("SCHEDULE_NAME"));
            props.put("DESCRIPTION", (String)row.get("DESCRIPTION"));
            crit = new Criteria(Column.getColumn((String)"Periodic", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("Periodic", crit);
            if (!obj.isEmpty()) {
                row = obj.getFirstRow("Periodic");
                if ("Minutes".equalsIgnoreCase((String)row.get("UNIT_OF_TIME"))) {
                    props.put("TIME_OF_DAY", (Long)row.get("TIME_PERIOD") / 60L);
                    props.put("MINS_OF_HOUR", (Long)row.get("TIME_PERIOD") % 60L);
                } else {
                    props.put("TIME_OF_DAY", row.get("TIME_PERIOD"));
                }
                props.put("SCHEDULE_TYPE", "hourly");
            } else {
                crit = new Criteria(Column.getColumn((String)"Calendar", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
                obj = CommonUtil.getPersistence(new boolean[0]).get("Calendar", crit);
                row = obj.getFirstRow("Calendar");
                if ("Minutes".equalsIgnoreCase((String)row.get("UNIT_OF_TIME"))) {
                    props.put("TIME_OF_DAY", (Long)row.get("TIME_OF_DAY") / 60L);
                    props.put("MINS_OF_HOUR", (Long)row.get("TIME_OF_DAY") % 60L);
                } else {
                    props.put("TIME_OF_DAY", row.get("TIME_OF_DAY"));
                }
                Integer dayOfWeek = (Integer)row.get("DAY_OF_WEEK");
                Integer dateOfMonth = (Integer)row.get("DATE_OF_MONTH");
                if (dayOfWeek != -1) {
                    props.put("DAY_OF_WEEK", dayOfWeek);
                    props.put("SCHEDULE_TYPE", "weekly");
                } else if (dateOfMonth != -1) {
                    props.put("DATE_OF_MONTH", dateOfMonth);
                    props.put("SCHEDULE_TYPE", "monthly");
                } else {
                    props.put("SCHEDULE_TYPE", "daily");
                }
            }
            crit = new Criteria(Column.getColumn((String)"Task_Input", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            obj = CommonUtil.getPersistence(new boolean[0]).get("Task_Input", crit);
            row = obj.getFirstRow("Task_Input");
            props.put("NEXT_SCHEDULE_TIME", (Timestamp)row.get("SCHEDULE_TIME"));
            props.put("ADMIN_STATUS", (Integer)row.get("ADMIN_STATUS"));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public String run(Long scheduleId) {
        String status = "success";
        try {
            Row r;
            String className = "";
            Criteria crit = new Criteria(Column.getColumn((String)"Scheduled_Task", (String)"SCHEDULE_ID"), (Object)scheduleId, 0);
            DataObject taskDO = CommonUtil.getPersistence(new boolean[0]).get(new ArrayList<String>(Arrays.asList("TaskEngine_Task", "Scheduled_Task")), crit);
            if (!taskDO.isEmpty() && (r = taskDO.getRow("TaskEngine_Task")) != null) {
                className = r.get("CLASS_NAME").toString();
            }
            Properties taskProps = new Properties();
            taskProps.setProperty("SCHEDULE_ID", scheduleId.toString());
            if (!className.equals("")) {
                if (!this.isSchedulerRunning(scheduleId.toString(), className)) {
                    Scheduler s = (Scheduler)BeanUtil.lookup((String)"Scheduler");
                    s.executeAsynchronously(className, 10L, taskProps, (Row)null, new Integer(-1).intValue());
                    asyncSchedulers.put(scheduleId.toString(), (Object)className);
                } else {
                    status = "adssp.config.step.scheduler_already_started";
                }
            } else {
                LOGMSG.log(Level.INFO, "No task class found for the schedule Id : " + scheduleId);
                status = "adssp.common.text.failure";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            status = e.getMessage();
        }
        return status;
    }

    public static Properties getForceStatus(String userName, String domainName, Boolean skipPolicySelection) {
        Long policyId;
        Boolean resultStatus;
        Properties prop;
        block12: {
            prop = new Properties();
            resultStatus = false;
            policyId = -1L;
            try {
                String enrollString = LicensedUsersHandler.isEnrolledUser(userName, domainName);
                if (!enrollString.equals("adssp.reports.audit.licensedusers.statmsg_enrolled_user")) {
                    resultStatus = true;
                }
                Properties userPro = UserUtil.getUserObjectDetails(userName, domainName, new String[]{"distinguishedName", "objectGUID", "memberOf", "primaryGroupID", "objectSID"}, true);
                String userDN = ((String)((ArrayList)userPro.get("distinguishedName")).get(0)).toLowerCase();
                String objGUID = (String)((ArrayList)userPro.get("objectGUID")).get(0);
                ArrayList userGroups = (ArrayList)userPro.get("memberOf");
                String primaryGroup = GroupUtil.getPrimaryGroup(domainName, (String)((ArrayList)userPro.get("primaryGroupID")).get(0));
                if (primaryGroup != null) {
                    userGroups.add(primaryGroup);
                }
                Hashtable userProps = PolicyHandler.checkUserPermission(domainName, userDN, userGroups);
                Boolean status = (Boolean)userProps.get("status");
                boolean isUserRestrict = PolicyHandler.isUserRestricted(objGUID);
                if (!isUserRestrict && status.booleanValue()) {
                    policyId = (Long)userProps.get("policyId");
                    if (!resultStatus.booleanValue()) break block12;
                    if (skipPolicySelection.booleanValue()) {
                        try {
                            Boolean isEnrollPermitted = PolicyHandler.isEnrollAllowed(policyId);
                            resultStatus = isEnrollPermitted != null ? isEnrollPermitted : false;
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        break block12;
                    }
                    try {
                        SelectQueryImpl sq = new SelectQueryImpl(Table.getTable((String)"Task_Input"));
                        sq.addSelectColumn(Column.getColumn((String)"Task_Input", (String)"*"));
                        Join join = new Join("Task_Input", "SSPEnrollmentLogonScript", new String[]{"SCHEDULE_ID"}, new String[]{"SCHEDULE_ID"}, 2);
                        sq.addJoin(join);
                        Criteria crit = new Criteria(Column.getColumn((String)"SSPEnrollmentLogonScript", (String)"POLICY_ID"), (Object)policyId, 0, false);
                        sq.setCriteria(crit);
                        DataObject dataObj = CommonUtil.getPersistence(new boolean[0]).get((SelectQuery)sq);
                        if (!dataObj.isEmpty()) {
                            Row row = dataObj.getFirstRow("Task_Input");
                            int adminStatus = (Integer)row.get("ADMIN_STATUS");
                            if (adminStatus == SchedulerUtil.ADMIN_STATUS_DISABLE) {
                                resultStatus = false;
                            }
                            break block12;
                        }
                        resultStatus = false;
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                    break block12;
                }
                resultStatus = false;
            }
            catch (Exception e) {
                e.printStackTrace();
                resultStatus = false;
            }
        }
        LOGMSG.log(Level.INFO, "userName : " + userName + " | domainName : " + domainName + " | skipPolicySelection : " + skipPolicySelection + " | Should force to enroll? : " + resultStatus);
        prop.put("status", resultStatus);
        prop.put("policyId", policyId);
        return prop;
    }

    public static void deleteScheduleDomainMapping(Long scheduleId) {
        try {
            CommonUtil.getPersistence(new boolean[0]).delete(new Criteria(Column.getColumn((String)"SSPSchedulerReportOUs", (String)"SCHEDULE_ID"), (Object)scheduleId, 0));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static Long createSchedule(String scheduleName, String description) {
        Long scheduleId = 0L;
        try {
            DataObject dataObject = CommonUtil.getPersistence(new boolean[0]).constructDataObject();
            Row r = new Row("Schedule");
            r.set("SCHEDULE_NAME", (Object)scheduleName);
            r.set("DESCRIPTION", (Object)description);
            dataObject.addRow(r);
            CommonUtil.getPersistence(new boolean[0]).add(dataObject);
            scheduleId = (Long)r.get("SCHEDULE_ID");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return scheduleId;
    }
}

